/*
 * Copyright (c) 2011 Paulo Zanoni
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef XDG_DESKTOP_ENTRY_H
#define XDG_DESKTOP_ENTRY_H

class XDGDesktopEntry
{
    // XXX: todo:
    //      - improve checks
    //      - check KDE stuff
    //      - check X- extensions
    //      - warn on unexistant keys
    //      - don't allow localization for non localestring stuff
    //      - implement a func to write a file
    public:
	XDGDesktopEntry(const char *fileName);
	~XDGDesktopEntry();
	bool valid();
	bool showInEnvironment(const char *environment);
	int run(const char *args);

    private:
	struct XDGEntry {
	    char *key;
	    char *locale;
	    char *value;
	    struct XDGEntry *next;
	};

	enum XDGEntryValueType {
	    XDGString,
	    XDGStrings,
	    XDGLocalestring,
	    XDGBoolean,
	    XDGNumeric
	};

	bool valid_;
	char *fileName_;
	char *fileContent_;
	struct XDGEntry *entries_;

	bool processEntry(char *line);
	bool storeEntry(struct XDGEntry *entry);
	bool getEntry(const char *key, const char *locale, const char **value);
	void validateEntries();

	bool checkValueType(const char *value, XDGEntryValueType type);


	// XXX: move all below this line to .cpp file?

	enum XDGTypeMask {
	    Application = 1,
	    Link        = 2,
	    Directory   = 4,
	    // Old KDE stuff:
	    ServiceType = 8,
	    Service     = 16,
	    FSDevice    = 32,
	    // Deprecated:
	    MimeType    = 64,
	    All         = 127
	};

	typedef struct {
	    const char *name;
	    XDGEntryValueType valueType;
	    bool required;
	    XDGTypeMask type;
	    bool deprecated;
	    bool (*validValueFunc)(const char *);
	} XDGEntryDescription;

	static XDGEntryDescription registeredEntries[];

	static bool validExec(const char *execString);

	static int runCommand(const char *commandString);
};

#endif
