#!/bin/sh -e

VERSION=$2
TAR=../bnd_$VERSION.orig.tar.xz
DIR=bnd-$VERSION
GIT_DIR=bnd-git

git clone git://github.com/bndtools/bnd.git $GIT_DIR
(
  cd $GIT_DIR
  git checkout "${VERSION}.REL"
)

# Bnd git cleanup
chmod +x debian/git-transform.sh
debian/git-transform.sh $GIT_DIR $DIR

XZ_OPT=--best tar -c -J -f $TAR $DIR
rm -rf $DIR
rm -rf $GIT_DIR
