#ifndef CR_DLM_H

/* DO NOT EDIT.  This file is auto-generated by dlm_header.py. */
#define CR_DLM_H

#if defined(WINDOWS)
#define DLM_APIENTRY
#else
#define DLM_APIENTRY
#endif

#include "chromium.h"
#include "state/cr_client.h"
#include "cr_spu.h"
#include "cr_hash.h"
#include "cr_threads.h"
#include "cr_pack.h"
#ifdef CHROMIUM_THREADSAFE
#include "cr_threads.h"
#endif

/* 3D bounding box */
typedef struct {
	double xmin, xmax, ymin, ymax, zmin, zmax;
} CRDLMBounds;

/* Indicates whether we're currently involved in playback or not */
typedef enum {
	CRDLM_IMMEDIATE = 0,
	CRDLM_REPLAY_STATE_FUNCTIONS = 1,
	CRDLM_REPLAY_ALL_FUNCTIONS = 2
} CRDLMReplayState;

/* This is enough information to hold an instance of a single function call. */
typedef struct DLMInstanceList {
	struct DLMInstanceList *next;
	struct DLMInstanceList *stateNext;
	void (*execute)(struct DLMInstanceList *instance, SPUDispatchTable *dispatchTable);
} DLMInstanceList;

typedef struct {
	DLMInstanceList *first, *last;
	int numInstances;
	DLMInstanceList *stateFirst, *stateLast;
	CRHashTable *references; /* display lists that this display list calls */
	CRDLMBounds bbox;
	GLboolean listSent;
} DLMListInfo;

typedef struct {
	/* This holds all the display list information, hashed by list identifier. */
	CRHashTable *displayLists;

	/* This is a count of the number of contexts/users that are using
	 * this DLM.
	 */
	unsigned int userCount;

#ifdef CHROMIUM_THREADSAFE
	/* This mutex protects the displayLists hash table from simultaneous
	 * updates by multiple contexts.
	 */
	CRmutex dlMutex;
	CRtsd tsdKey;
#endif

	/* Configuration information - see the CRDLMConfig structure below
	 * for details.
	 */
	unsigned int bufferSize;
} CRDLM;

/* This structure holds thread-specific state.  Each thread can be
 * associated with one (and only one) context; and each context can
 * be associated with one (and only one) DLM.  Making things interesting,
 * though, is that each DLM can be associated with multiple contexts.
 *
 * So the thread-specific data key is associated with each context, not
 * with each DLM.  Two different threads can, through two different
 * contexts that share a single DLM, each have independent state and
 * conditions.
 */

typedef struct {
	CRDLM *dlm;			/* the DLM associated with this state */
	unsigned long currentListIdentifier;	/* open display list */
	DLMListInfo *currentListInfo;	/* open display list data */
	GLenum currentListMode;		/* GL_COMPILE or GL_COMPILE_AND_EXECUTE */
	GLuint listBase;
	CRDLMReplayState replayState;	/* CRDLM_IMMEDIATE, CRDLM_REPLAY_STATE_FUNCTIONS, or CRDLM_REPLAY_ALL_FUNCTIONS */

} CRDLMContextState;

/* These additional structures are for passing information to and from the 
 * CRDLM interface routines.
 */
typedef struct {
	/* The size, in bytes, that the packer will initially allocate for
	 * each new buffer.
	 */
#define CRDLM_DEFAULT_BUFFERSIZE (1024*1024)
	unsigned int bufferSize;	/* this will be allocated for each buffer */
} CRDLMConfig;

/* Positive values match GL error values.
 * 0 (GL_NO_ERROR) is returned for success
 * Negative values are internal errors.
 * Possible positive values (from GL/gl.h) are:
 * GL_NO_ERROR (0x0)
 * GL_INVALID_ENUM (0x0500)
 * GL_INVALID_VALUE (0x0501)
 * GL_INVALID_OPERATION (0x0502)
 * GL_STACK_OVERFLOW (0x0503)
 * GL_STACK_UNDERFLOW (0x0504)
 * GL_OUT_OF_MEMORY (0x0505)
 */
typedef int CRDLMError;

/* This error reported if there's no current state. The caller is responsible
 * for appropriately allocating context state with crDLMNewContext(), and
 * for making it current with crDLMMakeCurrent().
 */
#define CRDLM_ERROR_STATE	(-1)


typedef void (*CRDLMErrorCallback)(int line, const char *file, GLenum error, const char *info);


#ifdef __cplusplus
extern "C" {
#endif

extern CRDLM DLM_APIENTRY * crDLMNewDLM(unsigned int configSize, const CRDLMConfig *config);
extern CRDLMContextState DLM_APIENTRY * crDLMNewContext(CRDLM *dlm);
extern void DLM_APIENTRY crDLMFreeContext(CRDLMContextState *state);
extern void DLM_APIENTRY crDLMUseDLM(CRDLM *dlm);
extern void DLM_APIENTRY crDLMFreeDLM(CRDLM *dlm);
extern void DLM_APIENTRY crDLMSetCurrentState(CRDLMContextState *state);
extern CRDLMContextState DLM_APIENTRY * crDLMGetCurrentState(void);
extern CRDLMReplayState DLM_APIENTRY crDLMGetReplayState(void);
extern void DLM_APIENTRY crDLMSetupClientState(SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMRestoreClientState(CRClientState *clientState, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMSendAllDLMLists(CRDLM *dlm, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMSendAllLists(SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMSendDLMList(CRDLM *dlm, unsigned long listIdentifier, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMSendList(unsigned long listIdentifier, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMReplayDLMList(CRDLM *dlm, unsigned long listIdentifier, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMReplayList(unsigned long listIdentifier, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMReplayDLMListState(CRDLM *dlm, unsigned long listIdentifier, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMReplayListState(unsigned long listIdentifier, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMReplayDLMLists(CRDLM *dlm, GLsizei n, GLenum type, const GLvoid *lists, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMReplayLists(GLsizei n, GLenum type, const GLvoid *lists, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMReplayDLMListsState(CRDLM *dlm, GLsizei n, GLenum type, const GLvoid *lists, SPUDispatchTable *dispatchTable);
extern void DLM_APIENTRY crDLMReplayListsState(GLsizei n, GLenum type, const GLvoid *lists, SPUDispatchTable *dispatchTable);
extern CRDLMError DLM_APIENTRY crDLMDeleteListContent(CRDLM *dlm, unsigned long listIdentifier);
extern int DLM_APIENTRY crDLMGetReferences(CRDLM *dlm, unsigned long listIdentifier, int firstIndex, int sizeofBuffer, unsigned int *buffer);
extern CRDLMError DLM_APIENTRY crDLMGetDLMBounds(CRDLM *dlm, unsigned long listIdentifier, CRDLMBounds *bounds);
extern CRDLMError DLM_APIENTRY crDLMGetBounds(unsigned long listIdentifier, CRDLMBounds *bounds);
extern void DLM_APIENTRY crDLMSetDLMBounds(CRDLM *dlm, unsigned long listIdentifier, double xmin, double ymin, double zmin, double xmax, double ymax, double zmax);
extern void DLM_APIENTRY crDLMSetBounds(unsigned long listIdentifier, double xmin, double ymin, double zmin, double xmax, double ymax, double zmax);
extern void DLM_APIENTRY crDLMComputeBoundingBox(unsigned long listId);
extern GLboolean DLM_APIENTRY crDLMListHasDLMBounds(CRDLM *dlm, unsigned long listIdentifier);
extern GLboolean DLM_APIENTRY crDLMListHasBounds(unsigned long listIdentifier);
extern GLuint DLM_APIENTRY crDLMGetCurrentList(void);
extern GLenum DLM_APIENTRY crDLMGetCurrentMode(void);
extern void DLM_APIENTRY crDLMErrorFunction(CRDLMErrorCallback callback);
extern void DLM_APIENTRY crDLMNewList(GLuint listIdentifier, GLenum mode);
extern void DLM_APIENTRY crDLMEndList(void);
extern void DLM_APIENTRY crDLMDeleteLists(GLuint firstListIdentifier, GLsizei range);
extern GLboolean DLM_APIENTRY crDLMIsList(GLuint list);
extern GLuint DLM_APIENTRY crDLMGenLists(GLsizei range);
extern void DLM_APIENTRY crDLMListBase(GLuint base);

/* auto-generated compilation functions begin here */
extern void DLM_APIENTRY crDLMCompileAccum( GLenum op, GLfloat value );
extern void DLM_APIENTRY crDLMCompileActiveTextureARB( GLenum texture );
extern void DLM_APIENTRY crDLMCompileAlphaFunc( GLenum func, GLclampf ref );
extern void DLM_APIENTRY crDLMCompileArrayElement( GLint i, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileBegin( GLenum mode );
extern void DLM_APIENTRY crDLMCompileBeginQueryARB( GLenum target, GLuint id );
extern void DLM_APIENTRY crDLMCompileBindProgramARB( GLenum target, GLuint program );
extern void DLM_APIENTRY crDLMCompileBindProgramNV( GLenum target, GLuint id );
extern void DLM_APIENTRY crDLMCompileBindTexture( GLenum target, GLuint texture );
extern void DLM_APIENTRY crDLMCompileBitmap( GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte * bitmap, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileBlendColorEXT( GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha );
extern void DLM_APIENTRY crDLMCompileBlendEquationEXT( GLenum mode );
extern void DLM_APIENTRY crDLMCompileBlendFunc( GLenum sfactor, GLenum dfactor );
extern void DLM_APIENTRY crDLMCompileBlendFuncSeparateEXT( GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorA, GLenum dfactorA );
extern void DLM_APIENTRY crDLMCompileCallList( GLuint list );
extern void DLM_APIENTRY crDLMCompileCallLists( GLsizei n, GLenum type, const GLvoid * lists );
extern void DLM_APIENTRY crDLMCompileClear( GLbitfield mask );
extern void DLM_APIENTRY crDLMCompileClearAccum( GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha );
extern void DLM_APIENTRY crDLMCompileClearColor( GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha );
extern void DLM_APIENTRY crDLMCompileClearDepth( GLclampd depth );
extern void DLM_APIENTRY crDLMCompileClearIndex( GLfloat c );
extern void DLM_APIENTRY crDLMCompileClearStencil( GLint s );
extern void DLM_APIENTRY crDLMCompileClipPlane( GLenum plane, const GLdouble * equation );
extern void DLM_APIENTRY crDLMCompileColor3b( GLbyte red, GLbyte green, GLbyte blue );
extern void DLM_APIENTRY crDLMCompileColor3bv( const GLbyte * v );
extern void DLM_APIENTRY crDLMCompileColor3d( GLdouble red, GLdouble green, GLdouble blue );
extern void DLM_APIENTRY crDLMCompileColor3dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileColor3f( GLfloat red, GLfloat green, GLfloat blue );
extern void DLM_APIENTRY crDLMCompileColor3fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileColor3i( GLint red, GLint green, GLint blue );
extern void DLM_APIENTRY crDLMCompileColor3iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileColor3s( GLshort red, GLshort green, GLshort blue );
extern void DLM_APIENTRY crDLMCompileColor3sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileColor3ub( GLubyte red, GLubyte green, GLubyte blue );
extern void DLM_APIENTRY crDLMCompileColor3ubv( const GLubyte * v );
extern void DLM_APIENTRY crDLMCompileColor3ui( GLuint red, GLuint green, GLuint blue );
extern void DLM_APIENTRY crDLMCompileColor3uiv( const GLuint * v );
extern void DLM_APIENTRY crDLMCompileColor3us( GLushort red, GLushort green, GLushort blue );
extern void DLM_APIENTRY crDLMCompileColor3usv( const GLushort * v );
extern void DLM_APIENTRY crDLMCompileColor4b( GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha );
extern void DLM_APIENTRY crDLMCompileColor4bv( const GLbyte * v );
extern void DLM_APIENTRY crDLMCompileColor4d( GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha );
extern void DLM_APIENTRY crDLMCompileColor4dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileColor4f( GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha );
extern void DLM_APIENTRY crDLMCompileColor4fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileColor4i( GLint red, GLint green, GLint blue, GLint alpha );
extern void DLM_APIENTRY crDLMCompileColor4iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileColor4s( GLshort red, GLshort green, GLshort blue, GLshort alpha );
extern void DLM_APIENTRY crDLMCompileColor4sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileColor4ub( GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha );
extern void DLM_APIENTRY crDLMCompileColor4ubv( const GLubyte * v );
extern void DLM_APIENTRY crDLMCompileColor4ui( GLuint red, GLuint green, GLuint blue, GLuint alpha );
extern void DLM_APIENTRY crDLMCompileColor4uiv( const GLuint * v );
extern void DLM_APIENTRY crDLMCompileColor4us( GLushort red, GLushort green, GLushort blue, GLushort alpha );
extern void DLM_APIENTRY crDLMCompileColor4usv( const GLushort * v );
extern void DLM_APIENTRY crDLMCompileColorMask( GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha );
extern void DLM_APIENTRY crDLMCompileColorMaterial( GLenum face, GLenum mode );
extern void DLM_APIENTRY crDLMCompileCombinerInputNV( GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage );
extern void DLM_APIENTRY crDLMCompileCombinerOutputNV( GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum );
extern void DLM_APIENTRY crDLMCompileCombinerParameterfNV( GLenum pname, GLfloat param );
extern void DLM_APIENTRY crDLMCompileCombinerParameterfvNV( GLenum pname, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileCombinerParameteriNV( GLenum pname, GLint param );
extern void DLM_APIENTRY crDLMCompileCombinerParameterivNV( GLenum pname, const GLint * params );
extern void DLM_APIENTRY crDLMCompileCombinerStageParameterfvNV( GLenum stage, GLenum pname, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileCompressedTexImage1DARB( GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLint border, GLsizei imagesize, const GLvoid * data );
extern void DLM_APIENTRY crDLMCompileCompressedTexImage2DARB( GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLint border, GLsizei imagesize, const GLvoid * data );
extern void DLM_APIENTRY crDLMCompileCompressedTexImage3DARB( GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imagesize, const GLvoid * data );
extern void DLM_APIENTRY crDLMCompileCompressedTexSubImage1DARB( GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imagesize, const GLvoid * data );
extern void DLM_APIENTRY crDLMCompileCompressedTexSubImage2DARB( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imagesize, const GLvoid * data );
extern void DLM_APIENTRY crDLMCompileCompressedTexSubImage3DARB( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imagesize, const GLvoid * data );
extern void DLM_APIENTRY crDLMCompileCopyPixels( GLint x, GLint y, GLsizei width, GLsizei height, GLenum type );
extern void DLM_APIENTRY crDLMCompileCopyTexImage1D( GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border );
extern void DLM_APIENTRY crDLMCompileCopyTexImage2D( GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border );
extern void DLM_APIENTRY crDLMCompileCopyTexSubImage1D( GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width );
extern void DLM_APIENTRY crDLMCompileCopyTexSubImage2D( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height );
extern void DLM_APIENTRY crDLMCompileCopyTexSubImage3D( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height );
extern void DLM_APIENTRY crDLMCompileCullFace( GLenum mode );
extern void DLM_APIENTRY crDLMCompileDepthFunc( GLenum func );
extern void DLM_APIENTRY crDLMCompileDepthMask( GLboolean flag );
extern void DLM_APIENTRY crDLMCompileDepthRange( GLclampd zNear, GLclampd zFar );
extern void DLM_APIENTRY crDLMCompileDisable( GLenum cap );
extern void DLM_APIENTRY crDLMCompileDrawArrays( GLenum mode, GLint first, GLsizei count, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileDrawBuffer( GLenum mode );
extern void DLM_APIENTRY crDLMCompileDrawElements( GLenum mode, GLsizei count, GLenum type, const GLvoid * indices, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileDrawPixels( GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileDrawRangeElements( GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid * indices, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileEdgeFlag( GLboolean flag );
extern void DLM_APIENTRY crDLMCompileEdgeFlagv( const GLboolean * flag );
extern void DLM_APIENTRY crDLMCompileEnable( GLenum cap );
extern void DLM_APIENTRY crDLMCompileEnd( void );
extern void DLM_APIENTRY crDLMCompileEndQueryARB( GLenum target );
extern void DLM_APIENTRY crDLMCompileEvalCoord1d( GLdouble u );
extern void DLM_APIENTRY crDLMCompileEvalCoord1dv( const GLdouble * u );
extern void DLM_APIENTRY crDLMCompileEvalCoord1f( GLfloat u );
extern void DLM_APIENTRY crDLMCompileEvalCoord1fv( const GLfloat * u );
extern void DLM_APIENTRY crDLMCompileEvalCoord2d( GLdouble u, GLdouble v );
extern void DLM_APIENTRY crDLMCompileEvalCoord2dv( const GLdouble * u );
extern void DLM_APIENTRY crDLMCompileEvalCoord2f( GLfloat u, GLfloat v );
extern void DLM_APIENTRY crDLMCompileEvalCoord2fv( const GLfloat * u );
extern void DLM_APIENTRY crDLMCompileEvalMesh1( GLenum mode, GLint i1, GLint i2 );
extern void DLM_APIENTRY crDLMCompileEvalMesh2( GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2 );
extern void DLM_APIENTRY crDLMCompileEvalPoint1( GLint i );
extern void DLM_APIENTRY crDLMCompileEvalPoint2( GLint i, GLint j );
extern void DLM_APIENTRY crDLMCompileExecuteProgramNV( GLenum target, GLuint id, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileFinalCombinerInputNV( GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage );
extern void DLM_APIENTRY crDLMCompileFogCoorddEXT( GLdouble coord );
extern void DLM_APIENTRY crDLMCompileFogCoorddvEXT( const GLdouble * coord );
extern void DLM_APIENTRY crDLMCompileFogCoordfEXT( GLfloat coord );
extern void DLM_APIENTRY crDLMCompileFogCoordfvEXT( const GLfloat * coord );
extern void DLM_APIENTRY crDLMCompileFogf( GLenum pname, GLfloat param );
extern void DLM_APIENTRY crDLMCompileFogfv( GLenum pname, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileFogi( GLenum pname, GLint param );
extern void DLM_APIENTRY crDLMCompileFogiv( GLenum pname, const GLint * params );
extern void DLM_APIENTRY crDLMCompileFrontFace( GLenum mode );
extern void DLM_APIENTRY crDLMCompileFrustum( GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar );
extern void DLM_APIENTRY crDLMCompileHint( GLenum target, GLenum mode );
extern void DLM_APIENTRY crDLMCompileIndexMask( GLuint mask );
extern void DLM_APIENTRY crDLMCompileIndexd( GLdouble c );
extern void DLM_APIENTRY crDLMCompileIndexdv( const GLdouble * c );
extern void DLM_APIENTRY crDLMCompileIndexf( GLfloat c );
extern void DLM_APIENTRY crDLMCompileIndexfv( const GLfloat * c );
extern void DLM_APIENTRY crDLMCompileIndexi( GLint c );
extern void DLM_APIENTRY crDLMCompileIndexiv( const GLint * c );
extern void DLM_APIENTRY crDLMCompileIndexs( GLshort c );
extern void DLM_APIENTRY crDLMCompileIndexsv( const GLshort * c );
extern void DLM_APIENTRY crDLMCompileIndexub( GLubyte c );
extern void DLM_APIENTRY crDLMCompileIndexubv( const GLubyte * c );
extern void DLM_APIENTRY crDLMCompileInitNames( void );
extern void DLM_APIENTRY crDLMCompileLightModelf( GLenum pname, GLfloat param );
extern void DLM_APIENTRY crDLMCompileLightModelfv( GLenum pname, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileLightModeli( GLenum pname, GLint param );
extern void DLM_APIENTRY crDLMCompileLightModeliv( GLenum pname, const GLint * params );
extern void DLM_APIENTRY crDLMCompileLightf( GLenum light, GLenum pname, GLfloat param );
extern void DLM_APIENTRY crDLMCompileLightfv( GLenum light, GLenum pname, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileLighti( GLenum light, GLenum pname, GLint param );
extern void DLM_APIENTRY crDLMCompileLightiv( GLenum light, GLenum pname, const GLint * params );
extern void DLM_APIENTRY crDLMCompileLineStipple( GLint factor, GLushort pattern );
extern void DLM_APIENTRY crDLMCompileLineWidth( GLfloat width );
extern void DLM_APIENTRY crDLMCompileListBase( GLuint base );
extern void DLM_APIENTRY crDLMCompileLoadIdentity( void );
extern void DLM_APIENTRY crDLMCompileLoadMatrixd( const GLdouble * m );
extern void DLM_APIENTRY crDLMCompileLoadMatrixf( const GLfloat * m );
extern void DLM_APIENTRY crDLMCompileLoadName( GLuint name );
extern void DLM_APIENTRY crDLMCompileLoadProgramNV( GLenum target, GLuint id, GLsizei len, const GLubyte * program );
extern void DLM_APIENTRY crDLMCompileLoadTransposeMatrixdARB( const GLdouble * m );
extern void DLM_APIENTRY crDLMCompileLoadTransposeMatrixfARB( const GLfloat * m );
extern void DLM_APIENTRY crDLMCompileLogicOp( GLenum opcode );
extern void DLM_APIENTRY crDLMCompileMap1d( GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble * points );
extern void DLM_APIENTRY crDLMCompileMap1f( GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat * points );
extern void DLM_APIENTRY crDLMCompileMap2d( GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble * points );
extern void DLM_APIENTRY crDLMCompileMap2f( GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat * points );
extern void DLM_APIENTRY crDLMCompileMapGrid1d( GLint un, GLdouble u1, GLdouble u2 );
extern void DLM_APIENTRY crDLMCompileMapGrid1f( GLint un, GLfloat u1, GLfloat u2 );
extern void DLM_APIENTRY crDLMCompileMapGrid2d( GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2 );
extern void DLM_APIENTRY crDLMCompileMapGrid2f( GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2 );
extern void DLM_APIENTRY crDLMCompileMaterialf( GLenum face, GLenum pname, GLfloat param );
extern void DLM_APIENTRY crDLMCompileMaterialfv( GLenum face, GLenum pname, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileMateriali( GLenum face, GLenum pname, GLint param );
extern void DLM_APIENTRY crDLMCompileMaterialiv( GLenum face, GLenum pname, const GLint * params );
extern void DLM_APIENTRY crDLMCompileMatrixMode( GLenum mode );
extern void DLM_APIENTRY crDLMCompileMultMatrixd( const GLdouble * m );
extern void DLM_APIENTRY crDLMCompileMultMatrixf( const GLfloat * m );
extern void DLM_APIENTRY crDLMCompileMultTransposeMatrixdARB( const GLdouble * m );
extern void DLM_APIENTRY crDLMCompileMultTransposeMatrixfARB( const GLfloat * m );
extern void DLM_APIENTRY crDLMCompileMultiDrawArraysEXT( GLenum mode, GLint * first, GLsizei * count, GLsizei primcount, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileMultiDrawElementsEXT( GLenum mode, const GLsizei * count, GLenum type, const GLvoid ** indices, GLsizei primcount, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord1dARB( GLenum texture, GLdouble s );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord1dvARB( GLenum texture, const GLdouble * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord1fARB( GLenum texture, GLfloat s );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord1fvARB( GLenum texture, const GLfloat * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord1iARB( GLenum texture, GLint s );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord1ivARB( GLenum texture, const GLint * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord1sARB( GLenum texture, GLshort s );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord1svARB( GLenum texture, const GLshort * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord2dARB( GLenum texture, GLdouble s, GLdouble t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord2dvARB( GLenum texture, const GLdouble * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord2fARB( GLenum texture, GLfloat s, GLfloat t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord2fvARB( GLenum texture, const GLfloat * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord2iARB( GLenum texture, GLint s, GLint t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord2ivARB( GLenum texture, const GLint * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord2sARB( GLenum texture, GLshort s, GLshort t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord2svARB( GLenum texture, const GLshort * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord3dARB( GLenum texture, GLdouble s, GLdouble t, GLdouble r );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord3dvARB( GLenum texture, const GLdouble * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord3fARB( GLenum texture, GLfloat s, GLfloat t, GLfloat r );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord3fvARB( GLenum texture, const GLfloat * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord3iARB( GLenum texture, GLint s, GLint t, GLint r );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord3ivARB( GLenum texture, const GLint * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord3sARB( GLenum texture, GLshort s, GLshort t, GLshort r );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord3svARB( GLenum texture, const GLshort * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord4dARB( GLenum texture, GLdouble s, GLdouble t, GLdouble r, GLdouble q );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord4dvARB( GLenum texture, const GLdouble * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord4fARB( GLenum texture, GLfloat s, GLfloat t, GLfloat r, GLfloat q );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord4fvARB( GLenum texture, const GLfloat * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord4iARB( GLenum texture, GLint s, GLint t, GLint r, GLint q );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord4ivARB( GLenum texture, const GLint * t );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord4sARB( GLenum texture, GLshort s, GLshort t, GLshort r, GLshort q );
extern void DLM_APIENTRY crDLMCompileMultiTexCoord4svARB( GLenum texture, const GLshort * t );
extern void DLM_APIENTRY crDLMCompileNormal3b( GLbyte nx, GLbyte ny, GLbyte nz );
extern void DLM_APIENTRY crDLMCompileNormal3bv( const GLbyte * v );
extern void DLM_APIENTRY crDLMCompileNormal3d( GLdouble nx, GLdouble ny, GLdouble nz );
extern void DLM_APIENTRY crDLMCompileNormal3dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileNormal3f( GLfloat nx, GLfloat ny, GLfloat nz );
extern void DLM_APIENTRY crDLMCompileNormal3fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileNormal3i( GLint nx, GLint ny, GLint nz );
extern void DLM_APIENTRY crDLMCompileNormal3iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileNormal3s( GLshort nx, GLshort ny, GLshort nz );
extern void DLM_APIENTRY crDLMCompileNormal3sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileOrtho( GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar );
extern void DLM_APIENTRY crDLMCompilePassThrough( GLfloat token );
extern void DLM_APIENTRY crDLMCompilePixelMapfv( GLenum map, GLsizei mapsize, const GLfloat * values );
extern void DLM_APIENTRY crDLMCompilePixelMapuiv( GLenum map, GLsizei mapsize, const GLuint * values );
extern void DLM_APIENTRY crDLMCompilePixelMapusv( GLenum map, GLsizei mapsize, const GLushort * values );
extern void DLM_APIENTRY crDLMCompilePixelTransferf( GLenum pname, GLfloat param );
extern void DLM_APIENTRY crDLMCompilePixelTransferi( GLenum pname, GLint param );
extern void DLM_APIENTRY crDLMCompilePixelZoom( GLfloat xfactor, GLfloat yfactor );
extern void DLM_APIENTRY crDLMCompilePointParameterfARB( GLenum pname, GLfloat param );
extern void DLM_APIENTRY crDLMCompilePointParameterfvARB( GLenum pname, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompilePointParameteri( GLenum pname, GLint param );
extern void DLM_APIENTRY crDLMCompilePointParameteriv( GLenum pname, const GLint * param );
extern void DLM_APIENTRY crDLMCompilePointSize( GLfloat size );
extern void DLM_APIENTRY crDLMCompilePolygonMode( GLenum face, GLenum mode );
extern void DLM_APIENTRY crDLMCompilePolygonOffset( GLfloat factor, GLfloat units );
extern void DLM_APIENTRY crDLMCompilePolygonStipple( const GLubyte * mask );
extern void DLM_APIENTRY crDLMCompilePopAttrib( void );
extern void DLM_APIENTRY crDLMCompilePopMatrix( void );
extern void DLM_APIENTRY crDLMCompilePopName( void );
extern void DLM_APIENTRY crDLMCompilePrioritizeTextures( GLsizei n, const GLuint * textures, const GLclampf * priorities );
extern void DLM_APIENTRY crDLMCompileProgramEnvParameter4dARB( GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w );
extern void DLM_APIENTRY crDLMCompileProgramEnvParameter4dvARB( GLenum target, GLuint index, const GLdouble * params );
extern void DLM_APIENTRY crDLMCompileProgramEnvParameter4fARB( GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w );
extern void DLM_APIENTRY crDLMCompileProgramEnvParameter4fvARB( GLenum target, GLuint index, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileProgramLocalParameter4dARB( GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w );
extern void DLM_APIENTRY crDLMCompileProgramLocalParameter4dvARB( GLenum target, GLuint index, const GLdouble * params );
extern void DLM_APIENTRY crDLMCompileProgramLocalParameter4fARB( GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w );
extern void DLM_APIENTRY crDLMCompileProgramLocalParameter4fvARB( GLenum target, GLuint index, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileProgramNamedParameter4dNV( GLuint id, GLsizei len, const GLubyte * name, GLdouble x, GLdouble y, GLdouble z, GLdouble w );
extern void DLM_APIENTRY crDLMCompileProgramNamedParameter4dvNV( GLuint id, GLsizei len, const GLubyte * name, const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileProgramNamedParameter4fNV( GLuint id, GLsizei len, const GLubyte * name, GLfloat x, GLfloat y, GLfloat z, GLfloat w );
extern void DLM_APIENTRY crDLMCompileProgramNamedParameter4fvNV( GLuint id, GLsizei len, const GLubyte * name, const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileProgramParameter4dNV( GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w );
extern void DLM_APIENTRY crDLMCompileProgramParameter4dvNV( GLenum target, GLuint index, const GLdouble * params );
extern void DLM_APIENTRY crDLMCompileProgramParameter4fNV( GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w );
extern void DLM_APIENTRY crDLMCompileProgramParameter4fvNV( GLenum target, GLuint index, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileProgramParameters4dvNV( GLenum target, GLuint index, GLuint num, const GLdouble * params );
extern void DLM_APIENTRY crDLMCompileProgramParameters4fvNV( GLenum target, GLuint index, GLuint num, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileProgramStringARB( GLenum target, GLenum format, GLsizei len, const GLvoid * string );
extern void DLM_APIENTRY crDLMCompilePushAttrib( GLbitfield mask );
extern void DLM_APIENTRY crDLMCompilePushMatrix( void );
extern void DLM_APIENTRY crDLMCompilePushName( GLuint name );
extern void DLM_APIENTRY crDLMCompileRasterPos2d( GLdouble x, GLdouble y );
extern void DLM_APIENTRY crDLMCompileRasterPos2dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileRasterPos2f( GLfloat x, GLfloat y );
extern void DLM_APIENTRY crDLMCompileRasterPos2fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileRasterPos2i( GLint x, GLint y );
extern void DLM_APIENTRY crDLMCompileRasterPos2iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileRasterPos2s( GLshort x, GLshort y );
extern void DLM_APIENTRY crDLMCompileRasterPos2sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileRasterPos3d( GLdouble x, GLdouble y, GLdouble z );
extern void DLM_APIENTRY crDLMCompileRasterPos3dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileRasterPos3f( GLfloat x, GLfloat y, GLfloat z );
extern void DLM_APIENTRY crDLMCompileRasterPos3fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileRasterPos3i( GLint x, GLint y, GLint z );
extern void DLM_APIENTRY crDLMCompileRasterPos3iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileRasterPos3s( GLshort x, GLshort y, GLshort z );
extern void DLM_APIENTRY crDLMCompileRasterPos3sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileRasterPos4d( GLdouble x, GLdouble y, GLdouble z, GLdouble w );
extern void DLM_APIENTRY crDLMCompileRasterPos4dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileRasterPos4f( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
extern void DLM_APIENTRY crDLMCompileRasterPos4fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileRasterPos4i( GLint x, GLint y, GLint z, GLint w );
extern void DLM_APIENTRY crDLMCompileRasterPos4iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileRasterPos4s( GLshort x, GLshort y, GLshort z, GLshort w );
extern void DLM_APIENTRY crDLMCompileRasterPos4sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileReadBuffer( GLenum mode );
extern void DLM_APIENTRY crDLMCompileRectd( GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2 );
extern void DLM_APIENTRY crDLMCompileRectdv( const GLdouble * v1, const GLdouble * v2 );
extern void DLM_APIENTRY crDLMCompileRectf( GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2 );
extern void DLM_APIENTRY crDLMCompileRectfv( const GLfloat * v1, const GLfloat * v2 );
extern void DLM_APIENTRY crDLMCompileRecti( GLint x1, GLint y1, GLint x2, GLint y2 );
extern void DLM_APIENTRY crDLMCompileRectiv( const GLint * v1, const GLint * v2 );
extern void DLM_APIENTRY crDLMCompileRects( GLshort x1, GLshort y1, GLshort x2, GLshort y2 );
extern void DLM_APIENTRY crDLMCompileRectsv( const GLshort * v1, const GLshort * v2 );
extern void DLM_APIENTRY crDLMCompileRequestResidentProgramsNV( GLsizei n, const GLuint * ids );
extern void DLM_APIENTRY crDLMCompileRotated( GLdouble angle, GLdouble x, GLdouble y, GLdouble z );
extern void DLM_APIENTRY crDLMCompileRotatef( GLfloat angle, GLfloat x, GLfloat y, GLfloat z );
extern void DLM_APIENTRY crDLMCompileSampleCoverageARB( GLclampf value, GLboolean invert );
extern void DLM_APIENTRY crDLMCompileScaled( GLdouble x, GLdouble y, GLdouble z );
extern void DLM_APIENTRY crDLMCompileScalef( GLfloat x, GLfloat y, GLfloat z );
extern void DLM_APIENTRY crDLMCompileScissor( GLint x, GLint y, GLsizei width, GLsizei height );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3bEXT( GLbyte red, GLbyte green, GLbyte blue );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3bvEXT( const GLbyte * v );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3dEXT( GLdouble red, GLdouble green, GLdouble blue );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3dvEXT( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3fEXT( GLfloat red, GLfloat green, GLfloat blue );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3fvEXT( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3iEXT( GLint red, GLint green, GLint blue );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3ivEXT( const GLint * v );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3sEXT( GLshort red, GLshort green, GLshort blue );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3svEXT( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3ubEXT( GLubyte red, GLubyte green, GLubyte blue );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3ubvEXT( const GLubyte * v );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3uiEXT( GLuint red, GLuint green, GLuint blue );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3uivEXT( const GLuint * v );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3usEXT( GLushort red, GLushort green, GLushort blue );
extern void DLM_APIENTRY crDLMCompileSecondaryColor3usvEXT( const GLushort * v );
extern void DLM_APIENTRY crDLMCompileSetFenceNV( GLuint fence, GLenum condition );
extern void DLM_APIENTRY crDLMCompileShadeModel( GLenum mode );
extern void DLM_APIENTRY crDLMCompileStencilFunc( GLenum func, GLint ref, GLuint mask );
extern void DLM_APIENTRY crDLMCompileStencilMask( GLuint mask );
extern void DLM_APIENTRY crDLMCompileStencilOp( GLenum fail, GLenum zfail, GLenum zpass );
extern void DLM_APIENTRY crDLMCompileTexCoord1d( GLdouble s );
extern void DLM_APIENTRY crDLMCompileTexCoord1dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileTexCoord1f( GLfloat s );
extern void DLM_APIENTRY crDLMCompileTexCoord1fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileTexCoord1i( GLint s );
extern void DLM_APIENTRY crDLMCompileTexCoord1iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileTexCoord1s( GLshort s );
extern void DLM_APIENTRY crDLMCompileTexCoord1sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileTexCoord2d( GLdouble s, GLdouble t );
extern void DLM_APIENTRY crDLMCompileTexCoord2dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileTexCoord2f( GLfloat s, GLfloat t );
extern void DLM_APIENTRY crDLMCompileTexCoord2fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileTexCoord2i( GLint s, GLint t );
extern void DLM_APIENTRY crDLMCompileTexCoord2iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileTexCoord2s( GLshort s, GLshort t );
extern void DLM_APIENTRY crDLMCompileTexCoord2sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileTexCoord3d( GLdouble s, GLdouble t, GLdouble r );
extern void DLM_APIENTRY crDLMCompileTexCoord3dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileTexCoord3f( GLfloat s, GLfloat t, GLfloat r );
extern void DLM_APIENTRY crDLMCompileTexCoord3fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileTexCoord3i( GLint s, GLint t, GLint r );
extern void DLM_APIENTRY crDLMCompileTexCoord3iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileTexCoord3s( GLshort s, GLshort t, GLshort r );
extern void DLM_APIENTRY crDLMCompileTexCoord3sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileTexCoord4d( GLdouble s, GLdouble t, GLdouble r, GLdouble q );
extern void DLM_APIENTRY crDLMCompileTexCoord4dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileTexCoord4f( GLfloat s, GLfloat t, GLfloat r, GLfloat q );
extern void DLM_APIENTRY crDLMCompileTexCoord4fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileTexCoord4i( GLint s, GLint t, GLint r, GLint q );
extern void DLM_APIENTRY crDLMCompileTexCoord4iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileTexCoord4s( GLshort s, GLshort t, GLshort r, GLshort q );
extern void DLM_APIENTRY crDLMCompileTexCoord4sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileTexEnvf( GLenum target, GLenum pname, GLfloat param );
extern void DLM_APIENTRY crDLMCompileTexEnvfv( GLenum target, GLenum pname, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileTexEnvi( GLenum target, GLenum pname, GLint param );
extern void DLM_APIENTRY crDLMCompileTexEnviv( GLenum target, GLenum pname, const GLint * params );
extern void DLM_APIENTRY crDLMCompileTexGend( GLenum coord, GLenum pname, GLdouble param );
extern void DLM_APIENTRY crDLMCompileTexGendv( GLenum coord, GLenum pname, const GLdouble * params );
extern void DLM_APIENTRY crDLMCompileTexGenf( GLenum coord, GLenum pname, GLfloat param );
extern void DLM_APIENTRY crDLMCompileTexGenfv( GLenum coord, GLenum pname, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileTexGeni( GLenum coord, GLenum pname, GLint param );
extern void DLM_APIENTRY crDLMCompileTexGeniv( GLenum coord, GLenum pname, const GLint * params );
extern void DLM_APIENTRY crDLMCompileTexImage1D( GLenum target, GLint level, GLint internalFormat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid * pixels, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileTexImage2D( GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileTexImage3D( GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileTexImage3DEXT( GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileTexParameterf( GLenum target, GLenum pname, GLfloat param );
extern void DLM_APIENTRY crDLMCompileTexParameterfv( GLenum target, GLenum pname, const GLfloat * params );
extern void DLM_APIENTRY crDLMCompileTexParameteri( GLenum target, GLenum pname, GLint param );
extern void DLM_APIENTRY crDLMCompileTexParameteriv( GLenum target, GLenum pname, const GLint * params );
extern void DLM_APIENTRY crDLMCompileTexSubImage1D( GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid * pixels, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileTexSubImage2D( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid * pixels, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileTexSubImage3D( GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid * pixels, CRClientState *c );
extern void DLM_APIENTRY crDLMCompileTrackMatrixNV( GLenum target, GLuint address, GLenum matrix, GLenum transform );
extern void DLM_APIENTRY crDLMCompileTranslated( GLdouble x, GLdouble y, GLdouble z );
extern void DLM_APIENTRY crDLMCompileTranslatef( GLfloat x, GLfloat y, GLfloat z );
extern void DLM_APIENTRY crDLMCompileVertex2d( GLdouble x, GLdouble y );
extern void DLM_APIENTRY crDLMCompileVertex2dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertex2f( GLfloat x, GLfloat y );
extern void DLM_APIENTRY crDLMCompileVertex2fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertex2i( GLint x, GLint y );
extern void DLM_APIENTRY crDLMCompileVertex2iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileVertex2s( GLshort x, GLshort y );
extern void DLM_APIENTRY crDLMCompileVertex2sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertex3d( GLdouble x, GLdouble y, GLdouble z );
extern void DLM_APIENTRY crDLMCompileVertex3dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertex3f( GLfloat x, GLfloat y, GLfloat z );
extern void DLM_APIENTRY crDLMCompileVertex3fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertex3i( GLint x, GLint y, GLint z );
extern void DLM_APIENTRY crDLMCompileVertex3iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileVertex3s( GLshort x, GLshort y, GLshort z );
extern void DLM_APIENTRY crDLMCompileVertex3sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertex4d( GLdouble x, GLdouble y, GLdouble z, GLdouble w );
extern void DLM_APIENTRY crDLMCompileVertex4dv( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertex4f( GLfloat x, GLfloat y, GLfloat z, GLfloat w );
extern void DLM_APIENTRY crDLMCompileVertex4fv( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertex4i( GLint x, GLint y, GLint z, GLint w );
extern void DLM_APIENTRY crDLMCompileVertex4iv( const GLint * v );
extern void DLM_APIENTRY crDLMCompileVertex4s( GLshort x, GLshort y, GLshort z, GLshort w );
extern void DLM_APIENTRY crDLMCompileVertex4sv( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib1dARB( GLuint index, GLdouble x );
extern void DLM_APIENTRY crDLMCompileVertexAttrib1dvARB( GLuint index, const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib1fARB( GLuint index, GLfloat x );
extern void DLM_APIENTRY crDLMCompileVertexAttrib1fvARB( GLuint index, const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib1sARB( GLuint index, GLshort x );
extern void DLM_APIENTRY crDLMCompileVertexAttrib1svARB( GLuint index, const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib2dARB( GLuint index, GLdouble x, GLdouble y );
extern void DLM_APIENTRY crDLMCompileVertexAttrib2dvARB( GLuint index, const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib2fARB( GLuint index, GLfloat x, GLfloat y );
extern void DLM_APIENTRY crDLMCompileVertexAttrib2fvARB( GLuint index, const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib2sARB( GLuint index, GLshort x, GLshort y );
extern void DLM_APIENTRY crDLMCompileVertexAttrib2svARB( GLuint index, const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib3dARB( GLuint index, GLdouble x, GLdouble y, GLdouble z );
extern void DLM_APIENTRY crDLMCompileVertexAttrib3dvARB( GLuint index, const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib3fARB( GLuint index, GLfloat x, GLfloat y, GLfloat z );
extern void DLM_APIENTRY crDLMCompileVertexAttrib3fvARB( GLuint index, const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib3sARB( GLuint index, GLshort x, GLshort y, GLshort z );
extern void DLM_APIENTRY crDLMCompileVertexAttrib3svARB( GLuint index, const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4NbvARB( GLuint index, const GLbyte * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4NivARB( GLuint index, const GLint * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4NsvARB( GLuint index, const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4NubARB( GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4NubvARB( GLuint index, const GLubyte * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4NuivARB( GLuint index, const GLuint * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4NusvARB( GLuint index, const GLushort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4bvARB( GLuint index, const GLbyte * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4dARB( GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4dvARB( GLuint index, const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4fARB( GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4fvARB( GLuint index, const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4ivARB( GLuint index, const GLint * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4sARB( GLuint index, GLshort x, GLshort y, GLshort z, GLshort w );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4svARB( GLuint index, const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4ubvARB( GLuint index, const GLubyte * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4uivARB( GLuint index, const GLuint * v );
extern void DLM_APIENTRY crDLMCompileVertexAttrib4usvARB( GLuint index, const GLushort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs1dvNV( GLuint index, GLsizei n, const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs1fvNV( GLuint index, GLsizei n, const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs1svNV( GLuint index, GLsizei n, const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs2dvNV( GLuint index, GLsizei n, const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs2fvNV( GLuint index, GLsizei n, const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs2svNV( GLuint index, GLsizei n, const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs3dvNV( GLuint index, GLsizei n, const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs3fvNV( GLuint index, GLsizei n, const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs3svNV( GLuint index, GLsizei n, const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs4dvNV( GLuint index, GLsizei n, const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs4fvNV( GLuint index, GLsizei n, const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs4svNV( GLuint index, GLsizei n, const GLshort * v );
extern void DLM_APIENTRY crDLMCompileVertexAttribs4ubvNV( GLuint index, GLsizei n, const GLubyte * v );
extern void DLM_APIENTRY crDLMCompileViewport( GLint x, GLint y, GLsizei width, GLsizei height );
extern void DLM_APIENTRY crDLMCompileWindowPos2dARB( GLdouble x, GLdouble y );
extern void DLM_APIENTRY crDLMCompileWindowPos2dvARB( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileWindowPos2fARB( GLfloat x, GLfloat y );
extern void DLM_APIENTRY crDLMCompileWindowPos2fvARB( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileWindowPos2iARB( GLint x, GLint y );
extern void DLM_APIENTRY crDLMCompileWindowPos2ivARB( const GLint * v );
extern void DLM_APIENTRY crDLMCompileWindowPos2sARB( GLshort x, GLshort y );
extern void DLM_APIENTRY crDLMCompileWindowPos2svARB( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileWindowPos3dARB( GLdouble x, GLdouble y, GLdouble z );
extern void DLM_APIENTRY crDLMCompileWindowPos3dvARB( const GLdouble * v );
extern void DLM_APIENTRY crDLMCompileWindowPos3fARB( GLfloat x, GLfloat y, GLfloat z );
extern void DLM_APIENTRY crDLMCompileWindowPos3fvARB( const GLfloat * v );
extern void DLM_APIENTRY crDLMCompileWindowPos3iARB( GLint x, GLint y, GLint z );
extern void DLM_APIENTRY crDLMCompileWindowPos3ivARB( const GLint * v );
extern void DLM_APIENTRY crDLMCompileWindowPos3sARB( GLshort x, GLshort y, GLshort z );
extern void DLM_APIENTRY crDLMCompileWindowPos3svARB( const GLshort * v );
extern void DLM_APIENTRY crDLMCompileZPixCR( GLsizei width, GLsizei height, GLenum format, GLenum type, GLenum ztype, GLint zparm, GLint length, const GLvoid * pixels, CRClientState *c );

/* auto-generated CheckList functions begin here.  There is one for each
 * function that has a dual nature: even when there's an active glNewList,
 * sometimes they are compiled into the display list, and sometimes they
 * are treated like a control function.  The CheckList function will
 * return TRUE if the function should really be compiled into a display
 * list.  The calling SPU is responsible for checking this; but the
 * DLM will also print an error if it detects an invalid use.
 */

int DLM_APIENTRY crDLMCheckListCompressedTexImage1DARB( GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLint border, GLsizei imagesize, const GLvoid * data );
int DLM_APIENTRY crDLMCheckListCompressedTexImage2DARB( GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLint border, GLsizei imagesize, const GLvoid * data );
int DLM_APIENTRY crDLMCheckListCompressedTexImage3DARB( GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imagesize, const GLvoid * data );
int DLM_APIENTRY crDLMCheckListTexImage1D( GLenum target, GLint level, GLint internalFormat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid * pixels );
int DLM_APIENTRY crDLMCheckListTexImage2D( GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid * pixels );
int DLM_APIENTRY crDLMCheckListTexImage3D( GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels );
int DLM_APIENTRY crDLMCheckListTexImage3DEXT( GLenum target, GLint level, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid * pixels );

#ifdef __cplusplus
}
#endif

#endif /* CR_DLM_H */
