#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Sojourn
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251011.4

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='the-sojourn'
GAME_NAME='The Sojourn'

ARCHIVE_BASE_0_NAME='setup_the_sojourn_1.1_(64bit)_(41585).exe'
ARCHIVE_BASE_0_MD5='dcb64504379bc323710bee15bf94deed'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_the_sojourn_1.1_(64bit)_(41585)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='6f1ba2e2348a794ba24ab0e5ae763e69'
ARCHIVE_BASE_0_SIZE='2600000'
ARCHIVE_BASE_0_VERSION='1.1-gog41585'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_sojourn'

UNREALENGINE4_NAME='thesojourn'

CONTENT_PATH_DEFAULT='.'

APP_MAIN_EXE="${UNREALENGINE4_NAME}/binaries/win64/${UNREALENGINE4_NAME}-win64-shipping.exe"
## Override the default wrestool options for Unreal Engine 4 games.
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=123'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
## Delete unused UE Prerequisites installer.
rm --recursive "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/engine/extras"

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Do not install the Visual C++ Runtime, to prevent crash related to MSVCP140.dll.
unrealengine4_wine_winetricks_verbs_default() { return 0; }

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
