#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Pedestrian
# send your bug reports to contact@dotslashplay.it
###

script_version=20240930.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-pedestrian'
GAME_NAME='The Pedestrian'

ARCHIVE_BASE_0_NAME='the_pedestrian_1_0_9_36404.sh'
ARCHIVE_BASE_0_MD5='8c57947cdd3e1384024bceb508ec36ac'
ARCHIVE_BASE_0_SIZE='1907337'
ARCHIVE_BASE_0_VERSION='1.0.9-gog36404'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_pedestrian'

UNITY3D_NAME='ThePed_Linux_64'
UNITY3D_PLUGINS='
libfmodL.so
libfmod.so
libfmodstudioL.so
libfmodstudio.so
ScreenSelector.so'
## TODO: Check if the Steam library is required.
UNITY3D_PLUGINS="$UNITY3D_PLUGINS
libsteam_api.so"

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME0_DATA_FILES='
UserData'

USER_PERSISTENT_DIRECTORIES='
UserData'

## Work around screen resolution detection problems
APP_MAIN_PRERUN='
# Work around screen resolution detection problems
config_file="$HOME/.config/unity3d/Skookum Arts/The Pedestrian/prefs"
if [ ! -e "$config_file" ]; then
	mkdir --parents "$(dirname "$config_file")"
	cat > "$config_file" <<- EOF
	<unity_prefs version_major="1" version_minor="1">
	        <pref name="Screenmanager Resolution Height" type="int">768</pref>
	        <pref name="Screenmanager Resolution Width" type="int">1024</pref>
	</unity_prefs>
	EOF
fi
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
