#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Toki Tori 2
# send your bug reports to contact@dotslashplay.it
###

script_version=20241107.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='toki-tori-2'
GAME_NAME='Toki Tori 2'

ARCHIVE_BASE_0_NAME='TokiTori2-Linux-2017-06-22.sh'
ARCHIVE_BASE_0_MD5='564ddc7b09982295732923bb7ac6f39e'
ARCHIVE_BASE_0_SIZE='624185'
ARCHIVE_BASE_0_VERSION='2017.06.22-humble.2017.10.02'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/toki-tori-2'

CONTENT_PATH_DEFAULT='data'
CONTENT_GAME_BIN64_RELATIVE_PATH='x86_64'
CONTENT_GAME_BIN64_FILES='
TokiTori2.bin.x86_64'
CONTENT_GAME_BIN32_RELATIVE_PATH='x86'
CONTENT_GAME_BIN32_FILES='
TokiTori2.bin.x86'
CONTENT_GAME_DATA_RELATIVE_PATH='noarch'
CONTENT_GAME_DATA_FILES='
audio
color_grading
config
default
levels
levels_unsavedchanges
localization
metadata
movement
particles
presentation
scripts
shaders
spritestrip
textures
userlevels
archive.ma
app_icon.png'
CONTENT_DOC_DATA_RELATIVE_PATH='noarch'
CONTENT_DOC_DATA_FILES='
README.linux
namespace.txt'

APP_MAIN_ICON='app_icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libgcc_s.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
libSDL2-2.0.so.0
libstdc++.so.6'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
