/*###############################################################################
# Linux Management Providers (LMP), Base_Server provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_ComputerSystem.h"

CMPIObjectPath* Base_Server_OpenDRIM_ComputerSystem_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_ComputerSystem& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_ComputerSystem_classnames[0], OpenDRIM_ComputerSystem_NAMESPACE);

	if (!instance.CreationClassName_isNULL)
		op.addKey("CreationClassName", instance.CreationClassName);

	if (!instance.Name_isNULL)
		op.addKey("Name", instance.Name);

	_L_;
	return op.getHdl();
}

CMPIInstance* Base_Server_OpenDRIM_ComputerSystem_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_ComputerSystem& instance) {
	_E_;
	Objectpath op(broker, Base_Server_OpenDRIM_ComputerSystem_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.InstallDate_isNULL)
		ci.setPropertyDatetime("InstallDate", instance.InstallDate);

	if (!instance.OperationalStatus_isNULL)
		ci.setProperty("OperationalStatus", instance.OperationalStatus);

	if (!instance.StatusDescriptions_isNULL)
		ci.setProperty("StatusDescriptions", instance.StatusDescriptions);

	if (!instance.Status_isNULL)
		ci.setProperty("Status", instance.Status);

	if (!instance.HealthState_isNULL)
		ci.setProperty("HealthState", instance.HealthState);

	if (!instance.PrimaryStatus_isNULL)
		ci.setProperty("PrimaryStatus", instance.PrimaryStatus);

	if (!instance.DetailedStatus_isNULL)
		ci.setProperty("DetailedStatus", instance.DetailedStatus);

	if (!instance.OperatingStatus_isNULL)
		ci.setProperty("OperatingStatus", instance.OperatingStatus);

	if (!instance.CommunicationStatus_isNULL)
		ci.setProperty("CommunicationStatus", instance.CommunicationStatus);

	if (!instance.EnabledState_isNULL)
		ci.setProperty("EnabledState", instance.EnabledState);

	if (!instance.OtherEnabledState_isNULL)
		ci.setProperty("OtherEnabledState", instance.OtherEnabledState);

	if (!instance.RequestedState_isNULL)
		ci.setProperty("RequestedState", instance.RequestedState);

	if (!instance.EnabledDefault_isNULL)
		ci.setProperty("EnabledDefault", instance.EnabledDefault);

	if (!instance.TimeOfLastStateChange_isNULL)
		ci.setPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange);

	if (!instance.AvailableRequestedStates_isNULL)
		ci.setProperty("AvailableRequestedStates", instance.AvailableRequestedStates);

	if (!instance.TransitioningToState_isNULL)
		ci.setProperty("TransitioningToState", instance.TransitioningToState);

	if (!instance.PrimaryOwnerName_isNULL)
		ci.setProperty("PrimaryOwnerName", instance.PrimaryOwnerName);

	if (!instance.PrimaryOwnerContact_isNULL)
		ci.setProperty("PrimaryOwnerContact", instance.PrimaryOwnerContact);

	if (!instance.Roles_isNULL)
		ci.setProperty("Roles", instance.Roles);

	if (!instance.OtherIdentifyingInfo_isNULL)
		ci.setProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo);

	if (!instance.IdentifyingDescriptions_isNULL)
		ci.setProperty("IdentifyingDescriptions", instance.IdentifyingDescriptions);

	if (!instance.NameFormat_isNULL)
		ci.setProperty("NameFormat", instance.NameFormat);

	if (!instance.Dedicated_isNULL)
		ci.setProperty("Dedicated", instance.Dedicated);

	if (!instance.OtherDedicatedDescriptions_isNULL)
		ci.setProperty("OtherDedicatedDescriptions", instance.OtherDedicatedDescriptions);

	if (!instance.ResetCapability_isNULL)
		ci.setProperty("ResetCapability", instance.ResetCapability);

	if (!instance.PowerManagementCapabilities_isNULL)
		ci.setProperty("PowerManagementCapabilities", instance.PowerManagementCapabilities);

	_L_;
	return ci.getHdl();
}

void Base_Server_OpenDRIM_ComputerSystem_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_ComputerSystem& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (op.getKey("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	_L_;
}

void Base_Server_OpenDRIM_ComputerSystem_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_ComputerSystem& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getPropertyDatetime("InstallDate", instance.InstallDate) == OK)
		instance.InstallDate_isNULL = false;

	if (inst.getProperty("OperationalStatus", instance.OperationalStatus) == OK)
		instance.OperationalStatus_isNULL = false;

	if (inst.getProperty("StatusDescriptions", instance.StatusDescriptions) == OK)
		instance.StatusDescriptions_isNULL = false;

	if (inst.getProperty("Status", instance.Status) == OK)
		instance.Status_isNULL = false;

	if (inst.getProperty("HealthState", instance.HealthState) == OK)
		instance.HealthState_isNULL = false;

	if (inst.getProperty("PrimaryStatus", instance.PrimaryStatus) == OK)
		instance.PrimaryStatus_isNULL = false;

	if (inst.getProperty("DetailedStatus", instance.DetailedStatus) == OK)
		instance.DetailedStatus_isNULL = false;

	if (inst.getProperty("OperatingStatus", instance.OperatingStatus) == OK)
		instance.OperatingStatus_isNULL = false;

	if (inst.getProperty("CommunicationStatus", instance.CommunicationStatus) == OK)
		instance.CommunicationStatus_isNULL = false;

	if (inst.getProperty("EnabledState", instance.EnabledState) == OK)
		instance.EnabledState_isNULL = false;

	if (inst.getProperty("OtherEnabledState", instance.OtherEnabledState) == OK)
		instance.OtherEnabledState_isNULL = false;

	if (inst.getProperty("RequestedState", instance.RequestedState) == OK)
		instance.RequestedState_isNULL = false;

	if (inst.getProperty("EnabledDefault", instance.EnabledDefault) == OK)
		instance.EnabledDefault_isNULL = false;

	if (inst.getPropertyDatetime("TimeOfLastStateChange", instance.TimeOfLastStateChange) == OK)
		instance.TimeOfLastStateChange_isNULL = false;

	if (inst.getProperty("AvailableRequestedStates", instance.AvailableRequestedStates) == OK)
		instance.AvailableRequestedStates_isNULL = false;

	if (inst.getProperty("TransitioningToState", instance.TransitioningToState) == OK)
		instance.TransitioningToState_isNULL = false;

	if (inst.getProperty("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("PrimaryOwnerName", instance.PrimaryOwnerName) == OK)
		instance.PrimaryOwnerName_isNULL = false;

	if (inst.getProperty("PrimaryOwnerContact", instance.PrimaryOwnerContact) == OK)
		instance.PrimaryOwnerContact_isNULL = false;

	if (inst.getProperty("Roles", instance.Roles) == OK)
		instance.Roles_isNULL = false;

	if (inst.getProperty("OtherIdentifyingInfo", instance.OtherIdentifyingInfo) == OK)
		instance.OtherIdentifyingInfo_isNULL = false;

	if (inst.getProperty("IdentifyingDescriptions", instance.IdentifyingDescriptions) == OK)
		instance.IdentifyingDescriptions_isNULL = false;

	if (inst.getProperty("NameFormat", instance.NameFormat) == OK)
		instance.NameFormat_isNULL = false;

	if (inst.getProperty("Dedicated", instance.Dedicated) == OK)
		instance.Dedicated_isNULL = false;

	if (inst.getProperty("OtherDedicatedDescriptions", instance.OtherDedicatedDescriptions) == OK)
		instance.OtherDedicatedDescriptions_isNULL = false;

	if (inst.getProperty("ResetCapability", instance.ResetCapability) == OK)
		instance.ResetCapability_isNULL = false;

	if (inst.getProperty("PowerManagementCapabilities", instance.PowerManagementCapabilities) == OK)
		instance.PowerManagementCapabilities_isNULL = false;

	_L_;
}

void Base_Server_OpenDRIM_ComputerSystem_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_ComputerSystem_RequestStateChange_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned short RequestedState;
	data = in->ft->getArg(in, "RequestedState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, RequestedState);	
		args.setRequestedState(RequestedState);
	}			

	Objectpath Job;
	data = in->ft->getArg(in, "Job", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, Job);	
		args.setJob(Job);
	}			

	string TimeoutPeriod;
	data = in->ft->getArg(in, "TimeoutPeriod", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, TimeoutPeriod);	
		args.setTimeoutPeriod(TimeoutPeriod);
	}			

	_L_;
}

void Base_Server_OpenDRIM_ComputerSystem_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_ComputerSystem_RequestStateChange_Out& args) {
	_E_;
	CMPIValue value;
	int errorMessage;

	Objectpath Job;
	errorMessage = args.getJob(Job);
	if (errorMessage == OK) {
		value = CT_toCMPI(Job);
		out->ft->addArg(out, "Job", &value, CMPI_ref);
	}

	_L_;
}
void Base_Server_OpenDRIM_ComputerSystem_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_ComputerSystem_SetPowerState_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	unsigned int PowerState;
	data = in->ft->getArg(in, "PowerState", &rc);
	if (rc.rc == OK) {
		CT_ToC(data, PowerState);	
		args.setPowerState(PowerState);
	}			

	string Time;
	data = in->ft->getArg(in, "Time", &rc);
	if (rc.rc == OK) {
		CT_ToCDatetime(data, Time);	
		args.setTime(Time);
	}			

	_L_;
}

