// Copyright (c) 1997-2003  Utrecht University (The Netherlands),
// ETH Zurich (Switzerland), Freie Universitaet Berlin (Germany),
// INRIA Sophia-Antipolis (France), Martin-Luther-University Halle-Wittenberg
// (Germany), Max-Planck-Institute Saarbruecken (Germany), RISC Linz (Austria),
// and Tel-Aviv University (Israel).  All rights reserved.
//
// This file is part of CGAL (www.cgal.org); you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; version 2.1 of the License.
// See the file LICENSE.LGPL distributed with CGAL.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $Source: /opt/cvs/multisdfDIST/CGAL-3.1/include/CGAL/Arithmetic_filter/predicates/kernel_ftC3.h,v $
// $Revision: 1.1.1.1 $ $Date: 2010/03/05 22:18:41 $
// $Name:  $
//
// Author(s)     : Sylvain Pion

// This file is automatically generated by
// scripts/filtered_predicates_generator.pl

#ifndef CGAL_ARITHMETIC_FILTER_PREDICATES_KERNEL_FTC3_H
#define CGAL_ARITHMETIC_FILTER_PREDICATES_KERNEL_FTC3_H

#include <CGAL/Profile_counter.h>

CGAL_BEGIN_NAMESPACE
template <class ET> class Lazy_exact_nt;
CGAL_END_NAMESPACE

CGAL_BEGIN_NAMESPACE

template < class CT, class ET, bool Protected, class Cache >
/* inline */
bool
parallelC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &v1x,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &v1y,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &v1z,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &v2x,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &v2y,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &v2z)
{
  try
  {
    CGAL_PROFILER("IA parallelC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return parallelC3(
		v1x.interval(),
		v1y.interval(),
		v1z.interval(),
		v2x.interval(),
		v2y.interval(),
		v2z.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA parallelC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return parallelC3(
		v1x.exact(),
		v1y.exact(),
		v1z.exact(),
		v2x.exact(),
		v2y.exact(),
		v2z.exact());
  }
}

template < class ET >
/* inline */
bool
parallelC3(
    const Lazy_exact_nt<ET> &v1x,
    const Lazy_exact_nt<ET> &v1y,
    const Lazy_exact_nt<ET> &v1z,
    const Lazy_exact_nt<ET> &v2x,
    const Lazy_exact_nt<ET> &v2y,
    const Lazy_exact_nt<ET> &v2z)
{
  try
  {
    CGAL_PROFILER("Lazy IA parallelC3 calls");
    Protect_FPU_rounding<true> Protection;
    return parallelC3(
		v1x.interval(),
		v1y.interval(),
		v1z.interval(),
		v2x.interval(),
		v2y.interval(),
		v2z.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA parallelC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return parallelC3(
		v1x.exact(),
		v1y.exact(),
		v1z.exact(),
		v2x.exact(),
		v2y.exact(),
		v2z.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/*  */
bool
parallelC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1sy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1sz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1ty,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s1tz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2sy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2sz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2ty,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &s2tz)
{
  try
  {
    CGAL_PROFILER("IA parallelC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return parallelC3(
		s1sx.interval(),
		s1sy.interval(),
		s1sz.interval(),
		s1tx.interval(),
		s1ty.interval(),
		s1tz.interval(),
		s2sx.interval(),
		s2sy.interval(),
		s2sz.interval(),
		s2tx.interval(),
		s2ty.interval(),
		s2tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA parallelC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return parallelC3(
		s1sx.exact(),
		s1sy.exact(),
		s1sz.exact(),
		s1tx.exact(),
		s1ty.exact(),
		s1tz.exact(),
		s2sx.exact(),
		s2sy.exact(),
		s2sz.exact(),
		s2tx.exact(),
		s2ty.exact(),
		s2tz.exact());
  }
}

template < class ET >
/*  */
bool
parallelC3(
    const Lazy_exact_nt<ET> &s1sx,
    const Lazy_exact_nt<ET> &s1sy,
    const Lazy_exact_nt<ET> &s1sz,
    const Lazy_exact_nt<ET> &s1tx,
    const Lazy_exact_nt<ET> &s1ty,
    const Lazy_exact_nt<ET> &s1tz,
    const Lazy_exact_nt<ET> &s2sx,
    const Lazy_exact_nt<ET> &s2sy,
    const Lazy_exact_nt<ET> &s2sz,
    const Lazy_exact_nt<ET> &s2tx,
    const Lazy_exact_nt<ET> &s2ty,
    const Lazy_exact_nt<ET> &s2tz)
{
  try
  {
    CGAL_PROFILER("Lazy IA parallelC3 calls");
    Protect_FPU_rounding<true> Protection;
    return parallelC3(
		s1sx.interval(),
		s1sy.interval(),
		s1sz.interval(),
		s1tx.interval(),
		s1ty.interval(),
		s1tz.interval(),
		s2sx.interval(),
		s2sy.interval(),
		s2sz.interval(),
		s2tx.interval(),
		s2ty.interval(),
		s2tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA parallelC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return parallelC3(
		s1sx.exact(),
		s1sy.exact(),
		s1sz.exact(),
		s1tx.exact(),
		s1ty.exact(),
		s1tz.exact(),
		s2sx.exact(),
		s2sy.exact(),
		s2sz.exact(),
		s2tx.exact(),
		s2ty.exact(),
		s2tz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
strict_dominanceC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz)
{
  try
  {
    CGAL_PROFILER("IA strict_dominanceC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return strict_dominanceC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA strict_dominanceC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return strict_dominanceC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
strict_dominanceC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz)
{
  try
  {
    CGAL_PROFILER("Lazy IA strict_dominanceC3 calls");
    Protect_FPU_rounding<true> Protection;
    return strict_dominanceC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA strict_dominanceC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return strict_dominanceC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
dominanceC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz)
{
  try
  {
    CGAL_PROFILER("IA dominanceC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return dominanceC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA dominanceC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return dominanceC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
dominanceC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz)
{
  try
  {
    CGAL_PROFILER("Lazy IA dominanceC3 calls");
    Protect_FPU_rounding<true> Protection;
    return dominanceC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA dominanceC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return dominanceC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
collinearC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rz)
{
  try
  {
    CGAL_PROFILER("IA collinearC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return collinearC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA collinearC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return collinearC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
collinearC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &rz)
{
  try
  {
    CGAL_PROFILER("Lazy IA collinearC3 calls");
    Protect_FPU_rounding<true> Protection;
    return collinearC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA collinearC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return collinearC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Orientation
orientationC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sz)
{
  try
  {
    CGAL_PROFILER("IA orientationC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return orientationC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval(),
		sx.interval(),
		sy.interval(),
		sz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA orientationC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return orientationC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact(),
		sx.exact(),
		sy.exact(),
		sz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Orientation
orientationC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &rz,
    const Lazy_exact_nt<ET> &sx,
    const Lazy_exact_nt<ET> &sy,
    const Lazy_exact_nt<ET> &sz)
{
  try
  {
    CGAL_PROFILER("Lazy IA orientationC3 calls");
    Protect_FPU_rounding<true> Protection;
    return orientationC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval(),
		sx.interval(),
		sy.interval(),
		sz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA orientationC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return orientationC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact(),
		sx.exact(),
		sy.exact(),
		sz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* inline */
Angle
angleC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rz)
{
  try
  {
    CGAL_PROFILER("IA angleC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return angleC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA angleC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return angleC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact());
  }
}

template < class ET >
/* inline */
Angle
angleC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &rz)
{
  try
  {
    CGAL_PROFILER("Lazy IA angleC3 calls");
    Protect_FPU_rounding<true> Protection;
    return angleC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA angleC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return angleC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_LARGE_INLINE */
Bounded_side
coplanar_side_of_bounded_circleC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ty,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tz)
{
  try
  {
    CGAL_PROFILER("IA coplanar_side_of_bounded_circleC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return coplanar_side_of_bounded_circleC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval(),
		tx.interval(),
		ty.interval(),
		tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA coplanar_side_of_bounded_circleC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return coplanar_side_of_bounded_circleC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact(),
		tx.exact(),
		ty.exact(),
		tz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_LARGE_INLINE */
Bounded_side
coplanar_side_of_bounded_circleC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &rz,
    const Lazy_exact_nt<ET> &tx,
    const Lazy_exact_nt<ET> &ty,
    const Lazy_exact_nt<ET> &tz)
{
  try
  {
    CGAL_PROFILER("Lazy IA coplanar_side_of_bounded_circleC3 calls");
    Protect_FPU_rounding<true> Protection;
    return coplanar_side_of_bounded_circleC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval(),
		tx.interval(),
		ty.interval(),
		tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA coplanar_side_of_bounded_circleC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return coplanar_side_of_bounded_circleC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact(),
		tx.exact(),
		ty.exact(),
		tz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
equal_directionC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &dx1,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &dy1,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &dz1,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &dx2,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &dy2,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &dz2)
{
  try
  {
    CGAL_PROFILER("IA equal_directionC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return equal_directionC3(
		dx1.interval(),
		dy1.interval(),
		dz1.interval(),
		dx2.interval(),
		dy2.interval(),
		dz2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA equal_directionC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return equal_directionC3(
		dx1.exact(),
		dy1.exact(),
		dz1.exact(),
		dx2.exact(),
		dy2.exact(),
		dz2.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
equal_directionC3(
    const Lazy_exact_nt<ET> &dx1,
    const Lazy_exact_nt<ET> &dy1,
    const Lazy_exact_nt<ET> &dz1,
    const Lazy_exact_nt<ET> &dx2,
    const Lazy_exact_nt<ET> &dy2,
    const Lazy_exact_nt<ET> &dz2)
{
  try
  {
    CGAL_PROFILER("Lazy IA equal_directionC3 calls");
    Protect_FPU_rounding<true> Protection;
    return equal_directionC3(
		dx1.interval(),
		dy1.interval(),
		dz1.interval(),
		dx2.interval(),
		dy2.interval(),
		dz2.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA equal_directionC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return equal_directionC3(
		dx1.exact(),
		dy1.exact(),
		dz1.exact(),
		dx2.exact(),
		dy2.exact(),
		dz2.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
equal_planeC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ha,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &hb,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &hc,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &hd,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pa,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pb,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pc,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pd)
{
  try
  {
    CGAL_PROFILER("IA equal_planeC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return equal_planeC3(
		ha.interval(),
		hb.interval(),
		hc.interval(),
		hd.interval(),
		pa.interval(),
		pb.interval(),
		pc.interval(),
		pd.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA equal_planeC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return equal_planeC3(
		ha.exact(),
		hb.exact(),
		hc.exact(),
		hd.exact(),
		pa.exact(),
		pb.exact(),
		pc.exact(),
		pd.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
bool
equal_planeC3(
    const Lazy_exact_nt<ET> &ha,
    const Lazy_exact_nt<ET> &hb,
    const Lazy_exact_nt<ET> &hc,
    const Lazy_exact_nt<ET> &hd,
    const Lazy_exact_nt<ET> &pa,
    const Lazy_exact_nt<ET> &pb,
    const Lazy_exact_nt<ET> &pc,
    const Lazy_exact_nt<ET> &pd)
{
  try
  {
    CGAL_PROFILER("Lazy IA equal_planeC3 calls");
    Protect_FPU_rounding<true> Protection;
    return equal_planeC3(
		ha.interval(),
		hb.interval(),
		hc.interval(),
		hd.interval(),
		pa.interval(),
		pb.interval(),
		pc.interval(),
		pd.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA equal_planeC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return equal_planeC3(
		ha.exact(),
		hb.exact(),
		hc.exact(),
		hd.exact(),
		pa.exact(),
		pb.exact(),
		pc.exact(),
		pd.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_LARGE_INLINE */
Oriented_side
side_of_oriented_planeC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &a,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &b,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &c,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &d,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz)
{
  try
  {
    CGAL_PROFILER("IA side_of_oriented_planeC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return side_of_oriented_planeC3(
		a.interval(),
		b.interval(),
		c.interval(),
		d.interval(),
		px.interval(),
		py.interval(),
		pz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA side_of_oriented_planeC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return side_of_oriented_planeC3(
		a.exact(),
		b.exact(),
		c.exact(),
		d.exact(),
		px.exact(),
		py.exact(),
		pz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_LARGE_INLINE */
Oriented_side
side_of_oriented_planeC3(
    const Lazy_exact_nt<ET> &a,
    const Lazy_exact_nt<ET> &b,
    const Lazy_exact_nt<ET> &c,
    const Lazy_exact_nt<ET> &d,
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz)
{
  try
  {
    CGAL_PROFILER("Lazy IA side_of_oriented_planeC3 calls");
    Protect_FPU_rounding<true> Protection;
    return side_of_oriented_planeC3(
		a.interval(),
		b.interval(),
		c.interval(),
		d.interval(),
		px.interval(),
		py.interval(),
		pz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA side_of_oriented_planeC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return side_of_oriented_planeC3(
		a.exact(),
		b.exact(),
		c.exact(),
		d.exact(),
		px.exact(),
		py.exact(),
		pz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_LARGE_INLINE */
Oriented_side
side_of_oriented_sphereC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ty,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tz)
{
  try
  {
    CGAL_PROFILER("IA side_of_oriented_sphereC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return side_of_oriented_sphereC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval(),
		sx.interval(),
		sy.interval(),
		sz.interval(),
		tx.interval(),
		ty.interval(),
		tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA side_of_oriented_sphereC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return side_of_oriented_sphereC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact(),
		sx.exact(),
		sy.exact(),
		sz.exact(),
		tx.exact(),
		ty.exact(),
		tz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_LARGE_INLINE */
Oriented_side
side_of_oriented_sphereC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &rz,
    const Lazy_exact_nt<ET> &sx,
    const Lazy_exact_nt<ET> &sy,
    const Lazy_exact_nt<ET> &sz,
    const Lazy_exact_nt<ET> &tx,
    const Lazy_exact_nt<ET> &ty,
    const Lazy_exact_nt<ET> &tz)
{
  try
  {
    CGAL_PROFILER("Lazy IA side_of_oriented_sphereC3 calls");
    Protect_FPU_rounding<true> Protection;
    return side_of_oriented_sphereC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval(),
		sx.interval(),
		sy.interval(),
		sz.interval(),
		tx.interval(),
		ty.interval(),
		tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA side_of_oriented_sphereC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return side_of_oriented_sphereC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact(),
		sx.exact(),
		sy.exact(),
		sz.exact(),
		tx.exact(),
		ty.exact(),
		tz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Bounded_side
side_of_bounded_sphereC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ty,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tz)
{
  try
  {
    CGAL_PROFILER("IA side_of_bounded_sphereC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return side_of_bounded_sphereC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval(),
		sx.interval(),
		sy.interval(),
		sz.interval(),
		tx.interval(),
		ty.interval(),
		tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA side_of_bounded_sphereC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return side_of_bounded_sphereC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact(),
		sx.exact(),
		sy.exact(),
		sz.exact(),
		tx.exact(),
		ty.exact(),
		tz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Bounded_side
side_of_bounded_sphereC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &rz,
    const Lazy_exact_nt<ET> &sx,
    const Lazy_exact_nt<ET> &sy,
    const Lazy_exact_nt<ET> &sz,
    const Lazy_exact_nt<ET> &tx,
    const Lazy_exact_nt<ET> &ty,
    const Lazy_exact_nt<ET> &tz)
{
  try
  {
    CGAL_PROFILER("Lazy IA side_of_bounded_sphereC3 calls");
    Protect_FPU_rounding<true> Protection;
    return side_of_bounded_sphereC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval(),
		sx.interval(),
		sy.interval(),
		sz.interval(),
		tx.interval(),
		ty.interval(),
		tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA side_of_bounded_sphereC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return side_of_bounded_sphereC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact(),
		sx.exact(),
		sy.exact(),
		sz.exact(),
		tx.exact(),
		ty.exact(),
		tz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Bounded_side
side_of_bounded_sphereC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ty,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tz)
{
  try
  {
    CGAL_PROFILER("IA side_of_bounded_sphereC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return side_of_bounded_sphereC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		tx.interval(),
		ty.interval(),
		tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA side_of_bounded_sphereC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return side_of_bounded_sphereC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		tx.exact(),
		ty.exact(),
		tz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Bounded_side
side_of_bounded_sphereC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz,
    const Lazy_exact_nt<ET> &tx,
    const Lazy_exact_nt<ET> &ty,
    const Lazy_exact_nt<ET> &tz)
{
  try
  {
    CGAL_PROFILER("Lazy IA side_of_bounded_sphereC3 calls");
    Protect_FPU_rounding<true> Protection;
    return side_of_bounded_sphereC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		tx.interval(),
		ty.interval(),
		tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA side_of_bounded_sphereC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return side_of_bounded_sphereC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		tx.exact(),
		ty.exact(),
		tz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_INLINE */
Comparison_result
cmp_dist_to_pointC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rz)
{
  try
  {
    CGAL_PROFILER("IA cmp_dist_to_pointC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return cmp_dist_to_pointC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA cmp_dist_to_pointC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return cmp_dist_to_pointC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_INLINE */
Comparison_result
cmp_dist_to_pointC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz,
    const Lazy_exact_nt<ET> &rx,
    const Lazy_exact_nt<ET> &ry,
    const Lazy_exact_nt<ET> &rz)
{
  try
  {
    CGAL_PROFILER("Lazy IA cmp_dist_to_pointC3 calls");
    Protect_FPU_rounding<true> Protection;
    return cmp_dist_to_pointC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		rx.interval(),
		ry.interval(),
		rz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA cmp_dist_to_pointC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return cmp_dist_to_pointC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		rx.exact(),
		ry.exact(),
		rz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Bounded_side
side_of_bounded_sphereC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &sz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ty,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &tz)
{
  try
  {
    CGAL_PROFILER("IA side_of_bounded_sphereC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return side_of_bounded_sphereC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		sx.interval(),
		sy.interval(),
		sz.interval(),
		tx.interval(),
		ty.interval(),
		tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA side_of_bounded_sphereC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return side_of_bounded_sphereC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		sx.exact(),
		sy.exact(),
		sz.exact(),
		tx.exact(),
		ty.exact(),
		tz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Bounded_side
side_of_bounded_sphereC3(
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz,
    const Lazy_exact_nt<ET> &sx,
    const Lazy_exact_nt<ET> &sy,
    const Lazy_exact_nt<ET> &sz,
    const Lazy_exact_nt<ET> &tx,
    const Lazy_exact_nt<ET> &ty,
    const Lazy_exact_nt<ET> &tz)
{
  try
  {
    CGAL_PROFILER("Lazy IA side_of_bounded_sphereC3 calls");
    Protect_FPU_rounding<true> Protection;
    return side_of_bounded_sphereC3(
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval(),
		sx.interval(),
		sy.interval(),
		sz.interval(),
		tx.interval(),
		ty.interval(),
		tz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA side_of_bounded_sphereC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return side_of_bounded_sphereC3(
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact(),
		sx.exact(),
		sy.exact(),
		sz.exact(),
		tx.exact(),
		ty.exact(),
		tz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
cmp_signed_dist_to_directionC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pa,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pb,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pc,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz)
{
  try
  {
    CGAL_PROFILER("IA cmp_signed_dist_to_directionC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return cmp_signed_dist_to_directionC3(
		pa.interval(),
		pb.interval(),
		pc.interval(),
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA cmp_signed_dist_to_directionC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return cmp_signed_dist_to_directionC3(
		pa.exact(),
		pb.exact(),
		pc.exact(),
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
cmp_signed_dist_to_directionC3(
    const Lazy_exact_nt<ET> &pa,
    const Lazy_exact_nt<ET> &pb,
    const Lazy_exact_nt<ET> &pc,
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz)
{
  try
  {
    CGAL_PROFILER("Lazy IA cmp_signed_dist_to_directionC3 calls");
    Protect_FPU_rounding<true> Protection;
    return cmp_signed_dist_to_directionC3(
		pa.interval(),
		pb.interval(),
		pc.interval(),
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA cmp_signed_dist_to_directionC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return cmp_signed_dist_to_directionC3(
		pa.exact(),
		pb.exact(),
		pc.exact(),
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
cmp_signed_dist_to_planeC3(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ppx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ppy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &ppz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pqx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pqy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pqz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &prx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pry,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &prz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &px,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &py,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pz,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qz)
{
  try
  {
    CGAL_PROFILER("IA cmp_signed_dist_to_planeC3 calls");
    Protect_FPU_rounding<Protected> Protection;
    return cmp_signed_dist_to_planeC3(
		ppx.interval(),
		ppy.interval(),
		ppz.interval(),
		pqx.interval(),
		pqy.interval(),
		pqz.interval(),
		prx.interval(),
		pry.interval(),
		prz.interval(),
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA cmp_signed_dist_to_planeC3 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return cmp_signed_dist_to_planeC3(
		ppx.exact(),
		ppy.exact(),
		ppz.exact(),
		pqx.exact(),
		pqy.exact(),
		pqz.exact(),
		prx.exact(),
		pry.exact(),
		prz.exact(),
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact());
  }
}

template < class ET >
/* CGAL_KERNEL_MEDIUM_INLINE */
Comparison_result
cmp_signed_dist_to_planeC3(
    const Lazy_exact_nt<ET> &ppx,
    const Lazy_exact_nt<ET> &ppy,
    const Lazy_exact_nt<ET> &ppz,
    const Lazy_exact_nt<ET> &pqx,
    const Lazy_exact_nt<ET> &pqy,
    const Lazy_exact_nt<ET> &pqz,
    const Lazy_exact_nt<ET> &prx,
    const Lazy_exact_nt<ET> &pry,
    const Lazy_exact_nt<ET> &prz,
    const Lazy_exact_nt<ET> &px,
    const Lazy_exact_nt<ET> &py,
    const Lazy_exact_nt<ET> &pz,
    const Lazy_exact_nt<ET> &qx,
    const Lazy_exact_nt<ET> &qy,
    const Lazy_exact_nt<ET> &qz)
{
  try
  {
    CGAL_PROFILER("Lazy IA cmp_signed_dist_to_planeC3 calls");
    Protect_FPU_rounding<true> Protection;
    return cmp_signed_dist_to_planeC3(
		ppx.interval(),
		ppy.interval(),
		ppz.interval(),
		pqx.interval(),
		pqy.interval(),
		pqz.interval(),
		prx.interval(),
		pry.interval(),
		prz.interval(),
		px.interval(),
		py.interval(),
		pz.interval(),
		qx.interval(),
		qy.interval(),
		qz.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA cmp_signed_dist_to_planeC3 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return cmp_signed_dist_to_planeC3(
		ppx.exact(),
		ppy.exact(),
		ppz.exact(),
		pqx.exact(),
		pqy.exact(),
		pqz.exact(),
		prx.exact(),
		pry.exact(),
		prz.exact(),
		px.exact(),
		py.exact(),
		pz.exact(),
		qx.exact(),
		qy.exact(),
		qz.exact());
  }
}

CGAL_END_NAMESPACE

#endif // CGAL_ARITHMETIC_FILTER_PREDICATES_KERNEL_FTC3_H
