# setup.py - Distutils interface for building glf Python extension.
# creating a distribution.

from distutils.core import setup, Extension
from distutils.command.build import build
from distutils.command.sdist import sdist
from distutils.command.install_data import install_data
import sys, os
from os import path
from platform import machine
machine_arch = machine()
pack_name = "pyglf"
ext_name = "_glf"
platform = sys.platform

source = [path.join(pack_name, "glf.i"),  path.join("src", "glf.c")]
include_dirs = {'posix': ["/usr/include/GL"]}.get ( os.name, [])
import numpy
numpy_include =  numpy.get_include()
include_dirs.extend([path.join(".", "src"), numpy_include])
libs =  {'posix': ["GLU","GL","Xmu", "Xt", "X11", "m"],
         'nt': ["glu32", "opengl32"]}.get( os.name, [])
lib_dirs = []
if platform in ("linux2", "darwin", "sunos5"):
    libs.append( "Xi")
    lib_dirs.append("/usr/X11R6/lib")
    if '64' in machine_arch:
        lib_dirs.insert(0,'/usr/X11R6/lib64')

extra_link_args=[]
macros = []
if platform == "darwin":
    macros.append(("__APPLE__", None))
    #extra_link_args=["-framework", "OpenGL"]
    (osname, host, release, version, machine) = os.uname()
    if release[0] == '9': # leopard
        extra_link_args=['-Wl,-dylib_file,/System/Library/Frameworks/OpenGL.framework/Versions/A/Libraries/libGL.dylib:/System/Library/Frameworks/OpenGL.framework/Versions/A/Libraries/libGL.dylib']
        
elif platform == 'win32':
    macros.append(('WIN32',None))
    
font_files = []
fonts_dir = os.path.join("pyglf", "fonts")
for f in os.listdir(fonts_dir):
    if os.path.isfile(os.path.join("pyglf","fonts", f)):
        font_files.append(os.path.join("pyglf","fonts", f))
    
data_files = [(fonts_dir, font_files)]
    
# Change the order of commands that are called by "build"
# so that "build_py" command is called after "build_ext". In this case
# "build_py" will install (copy to the build directory) python
# modules generated by "build_ext'.

class modified_build(build):

    sub_commands = [('build_clib',    build.has_c_libraries),
                    ('build_ext',     build.has_ext_modules),
                    ('build_py',      build.has_pure_modules),
                    ('build_scripts', build.has_scripts),
                    ]

# Overwrite the prune_file_list method of sdist to not
# remove automatically the RCS/CVS directory from the distribution.

class modified_sdist(sdist):
    def prune_file_list(self):

        build = self.get_finalized_command('build')
        base_dir = self.distribution.get_fullname()
        self.filelist.exclude_pattern(None, prefix=build.build_base)
        self.filelist.exclude_pattern(None, prefix=base_dir)

class modified_install_data(install_data):

    def run(self):
        install_cmd = self.get_finalized_command('install')
        self.install_dir = getattr(install_cmd, 'install_lib')
        return install_data.run(self)
try:   
    from version import VERSION
except:
    VERSION = "1.0"
# setup()      
dist = setup(name=pack_name,
             version=VERSION,
             description = "GLF library Python extension module. The library is used for displaying text in OpenGL.",
             author = "Molecular Graphics Laboratory",
             author_email = "mgltools@scripps.edu",
             url = "http://www.scripps.edu/~sanner/python/packager.html",
             packages = ["pyglf", "pyglf.Tests"],
             cmdclass = {"build" : modified_build,
                         'sdist' : modified_sdist,
                         'install_data': modified_install_data},
             ext_package = pack_name,
             data_files = data_files,
             ext_modules = [Extension (ext_name, source,
                                  include_dirs = include_dirs,
                                  libraries = libs,
                                  library_dirs = lib_dirs,
                                  extra_link_args=extra_link_args,
                                  define_macros = macros,
                                       ) ] ,)

