/*
 *  KCemu -- The emulator for the KC85 homecomputer series and much more.
 *  Copyright (C) 1997-2010 Torsten Paul
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __ui_font0_h
#define __ui_font0_h

#include "kc/system.h"

static byte_t __font[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x00 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x01 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x02 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x03 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x04 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x05 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x06 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x07 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x08 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x09 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x0a */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x0b */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x0c */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x0d */
	0x00, 0x00, 0x18, 0x24, 0x24, 0x18, 0x24, 0x42,   /* 0x0e */
	0xdb, 0xa5, 0x81, 0xff, 0x24, 0x24, 0x24, 0x42,   /* 0x0f */
	0x08, 0x34, 0x42, 0x81, 0x91, 0x69, 0x09, 0x31,   /* 0x10 */
	0x42, 0x7e, 0x81, 0xff, 0x00, 0x00, 0x00, 0x00,   /* 0x11 */
	0x18, 0x24, 0x42, 0x99, 0xbd, 0x99, 0x42, 0x24,   /* 0x12 */
	0x7e, 0x42, 0x99, 0xe7, 0x00, 0x00, 0x00, 0x00,   /* 0x13 */
	0x18, 0xdb, 0xc3, 0x18, 0x99, 0xe7, 0x81, 0x42,   /* 0x14 */
	0x18, 0x24, 0x18, 0xc3, 0xbd, 0x81, 0x81, 0x42,   /* 0x15 */
	0x24, 0x7e, 0x81, 0xff, 0x00, 0x00, 0x00, 0x00,   /* 0x16 */
	0x00, 0x00, 0x18, 0x3c, 0x3c, 0x18, 0x3c, 0x7e,   /* 0x17 */
	0xdb, 0xff, 0xff, 0xff, 0x3c, 0x3c, 0x3c, 0x7e,   /* 0x18 */
	0x08, 0x3c, 0x7e, 0xff, 0xff, 0x6f, 0x0f, 0x3f,   /* 0x19 */
	0x7e, 0x7e, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,   /* 0x1a */
	0x18, 0x3c, 0x7e, 0xe7, 0xc3, 0xe7, 0x7e, 0x3c,   /* 0x1b */
	0x7e, 0x7e, 0xff, 0xe7, 0x00, 0x00, 0x00, 0x00,   /* 0x1c */
	0x18, 0xdb, 0xc3, 0x18, 0x99, 0xff, 0xff, 0x7e,   /* 0x1d */
	0x18, 0x3c, 0x18, 0xc3, 0xff, 0xff, 0xff, 0x7e,   /* 0x1e */
	0x3c, 0x3c, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,   /* 0x1f */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0x20 */
	0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x00,   /* 0x21 */
	0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0x22 */
	0x24, 0x7e, 0x24, 0x24, 0x24, 0x7e, 0x24, 0x00,   /* 0x23 */
	0x10, 0x3c, 0x50, 0x38, 0x14, 0x78, 0x10, 0x00,   /* 0x24 */
	0x60, 0x64, 0x08, 0x10, 0x20, 0x4c, 0x0c, 0x00,   /* 0x25 */
	0x10, 0x28, 0x28, 0x30, 0x54, 0x48, 0x34, 0x00,   /* 0x26 */
	0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0x27 */
	0x08, 0x10, 0x20, 0x20, 0x20, 0x10, 0x08, 0x00,   /* 0x28 */
	0x20, 0x10, 0x08, 0x08, 0x08, 0x10, 0x20, 0x00,   /* 0x29 */
	0x00, 0x10, 0x54, 0x38, 0x54, 0x10, 0x00, 0x00,   /* 0x2a */
	0x00, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x00, 0x00,   /* 0x2b */
	0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x00,   /* 0x2c */
	0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x00,   /* 0x2d */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00,   /* 0x2e */
	0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00,   /* 0x2f */
	0x38, 0x44, 0x44, 0x54, 0x44, 0x44, 0x38, 0x00,   /* 0x30 */
	0x10, 0x30, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00,   /* 0x31 */
	0x38, 0x44, 0x04, 0x08, 0x10, 0x20, 0x7c, 0x00,   /* 0x32 */
	0x7c, 0x08, 0x10, 0x08, 0x04, 0x44, 0x38, 0x00,   /* 0x33 */
	0x08, 0x18, 0x28, 0x48, 0x7c, 0x08, 0x08, 0x00,   /* 0x34 */
	0x7c, 0x40, 0x78, 0x04, 0x04, 0x44, 0x38, 0x00,   /* 0x35 */
	0x18, 0x20, 0x40, 0x78, 0x44, 0x44, 0x38, 0x00,   /* 0x36 */
	0x7c, 0x04, 0x08, 0x10, 0x20, 0x20, 0x20, 0x00,   /* 0x37 */
	0x38, 0x44, 0x44, 0x38, 0x44, 0x44, 0x38, 0x00,   /* 0x38 */
	0x38, 0x44, 0x44, 0x3c, 0x04, 0x08, 0x30, 0x00,   /* 0x39 */
	0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00,   /* 0x3a */
	0x00, 0x00, 0x10, 0x00, 0x10, 0x10, 0x20, 0x00,   /* 0x3b */
	0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08, 0x00,   /* 0x3c */
	0x00, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x00, 0x00,   /* 0x3d */
	0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00,   /* 0x3e */
	0x38, 0x44, 0x04, 0x08, 0x10, 0x00, 0x10, 0x00,   /* 0x3f */
	0x38, 0x44, 0x5c, 0x54, 0x5c, 0x40, 0x3c, 0x00,   /* 0x40 */
	0x38, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x00,   /* 0x41 */
	0x78, 0x24, 0x24, 0x38, 0x24, 0x24, 0x78, 0x00,   /* 0x42 */
	0x38, 0x44, 0x40, 0x40, 0x40, 0x44, 0x38, 0x00,   /* 0x43 */
	0x78, 0x24, 0x24, 0x24, 0x24, 0x24, 0x78, 0x00,   /* 0x44 */
	0x7c, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7c, 0x00,   /* 0x45 */
	0x7c, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x00,   /* 0x46 */
	0x38, 0x44, 0x40, 0x40, 0x4c, 0x44, 0x3c, 0x00,   /* 0x47 */
	0x44, 0x44, 0x44, 0x7c, 0x44, 0x44, 0x44, 0x00,   /* 0x48 */
	0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00,   /* 0x49 */
	0x1c, 0x08, 0x08, 0x08, 0x08, 0x48, 0x30, 0x00,   /* 0x4a */
	0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0x00,   /* 0x4b */
	0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7c, 0x00,   /* 0x4c */
	0x44, 0x6c, 0x54, 0x54, 0x44, 0x44, 0x44, 0x00,   /* 0x4d */
	0x44, 0x44, 0x64, 0x54, 0x4c, 0x44, 0x44, 0x00,   /* 0x4e */
	0x38, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00,   /* 0x4f */
	0x78, 0x44, 0x44, 0x78, 0x40, 0x40, 0x40, 0x00,   /* 0x50 */
	0x38, 0x44, 0x44, 0x44, 0x54, 0x48, 0x34, 0x00,   /* 0x51 */
	0x78, 0x44, 0x44, 0x78, 0x50, 0x48, 0x44, 0x00,   /* 0x52 */
	0x3c, 0x40, 0x40, 0x38, 0x04, 0x04, 0x78, 0x00,   /* 0x53 */
	0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,   /* 0x54 */
	0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00,   /* 0x55 */
	0x44, 0x44, 0x44, 0x44, 0x44, 0x28, 0x10, 0x00,   /* 0x56 */
	0x44, 0x44, 0x44, 0x54, 0x54, 0x6c, 0x44, 0x00,   /* 0x57 */
	0x44, 0x44, 0x28, 0x10, 0x28, 0x44, 0x44, 0x00,   /* 0x58 */
	0x44, 0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x00,   /* 0x59 */
	0x7c, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7c, 0x00,   /* 0x5a */
	0x38, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38, 0x00,   /* 0x5b */
	0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00,   /* 0x5c */
	0x38, 0x08, 0x08, 0x08, 0x08, 0x08, 0x38, 0x00,   /* 0x5d */
	0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0x5e */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00,   /* 0x5f */
	0x00, 0x20, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00,   /* 0x60 */
	0x00, 0x00, 0x34, 0x4c, 0x44, 0x44, 0x3a, 0x00,   /* 0x61 */
	0x40, 0x40, 0x58, 0x64, 0x44, 0x44, 0x78, 0x00,   /* 0x62 */
	0x00, 0x00, 0x38, 0x44, 0x40, 0x44, 0x38, 0x00,   /* 0x63 */
	0x04, 0x04, 0x34, 0x4c, 0x44, 0x44, 0x3a, 0x00,   /* 0x64 */
	0x00, 0x00, 0x38, 0x44, 0x7c, 0x40, 0x38, 0x00,   /* 0x65 */
	0x08, 0x10, 0x38, 0x10, 0x10, 0x10, 0x10, 0x00,   /* 0x66 */
	0x00, 0x00, 0x34, 0x4c, 0x44, 0x3c, 0x04, 0x38,   /* 0x67 */
	0x40, 0x40, 0x58, 0x64, 0x44, 0x44, 0x44, 0x00,   /* 0x68 */
	0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00,   /* 0x69 */
	0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20,   /* 0x6a */
	0x40, 0x40, 0x48, 0x50, 0x70, 0x48, 0x44, 0x00,   /* 0x6b */
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x00,   /* 0x6c */
	0x00, 0x00, 0x68, 0x54, 0x54, 0x54, 0x54, 0x00,   /* 0x6d */
	0x00, 0x00, 0x58, 0x64, 0x44, 0x44, 0x44, 0x00,   /* 0x6e */
	0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00,   /* 0x6f */
	0x00, 0x00, 0x58, 0x64, 0x44, 0x78, 0x40, 0x40,   /* 0x70 */
	0x00, 0x00, 0x34, 0x4c, 0x44, 0x3c, 0x04, 0x04,   /* 0x71 */
	0x00, 0x00, 0x58, 0x64, 0x40, 0x40, 0x40, 0x00,   /* 0x72 */
	0x00, 0x00, 0x38, 0x40, 0x38, 0x04, 0x78, 0x00,   /* 0x73 */
	0x10, 0x10, 0x38, 0x10, 0x10, 0x10, 0x08, 0x00,   /* 0x74 */
	0x00, 0x00, 0x44, 0x44, 0x44, 0x4c, 0x34, 0x00,   /* 0x75 */
	0x00, 0x00, 0x44, 0x44, 0x44, 0x28, 0x10, 0x00,   /* 0x76 */
	0x00, 0x00, 0x54, 0x54, 0x54, 0x54, 0x28, 0x00,   /* 0x77 */
	0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00,   /* 0x78 */
	0x00, 0x00, 0x44, 0x44, 0x44, 0x3c, 0x04, 0x38,   /* 0x79 */
	0x00, 0x00, 0x7c, 0x08, 0x10, 0x20, 0x7c, 0x00,   /* 0x7a */
	0x08, 0x10, 0x10, 0x20, 0x10, 0x10, 0x08, 0x00,   /* 0x7b */
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,   /* 0x7c */
	0x20, 0x10, 0x10, 0x08, 0x10, 0x10, 0x20, 0x00,   /* 0x7d */
	0x00, 0x00, 0x00, 0x32, 0x4c, 0x00, 0x00, 0x00,   /* 0x7e */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0x7f */
	0xc0, 0x20, 0x10, 0x10, 0x10, 0x10, 0x20, 0xc0,   /* 0x80 */
	0x03, 0x04, 0x08, 0x08, 0x08, 0x08, 0x04, 0x03,   /* 0x81 */
	0x81, 0x81, 0x42, 0x3c, 0x00, 0x00, 0x00, 0x00,   /* 0x82 */
	0x00, 0x00, 0x00, 0x00, 0x3c, 0x42, 0x81, 0x81,   /* 0x83 */
	0x10, 0x10, 0x20, 0xc0, 0x00, 0x00, 0x00, 0x00,   /* 0x84 */
	0x08, 0x08, 0x04, 0x03, 0x00, 0x00, 0x00, 0x00,   /* 0x85 */
	0x00, 0x00, 0x00, 0x00, 0x03, 0x04, 0x08, 0x08,   /* 0x86 */
	0x00, 0x00, 0x00, 0x00, 0xc0, 0x20, 0x10, 0x10,   /* 0x87 */
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xff,   /* 0x88 */
	0xff, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,   /* 0x89 */
	0x00, 0x10, 0x28, 0x44, 0x82, 0x44, 0x28, 0x10,   /* 0x8a */
	0xff, 0xef, 0xc7, 0x83, 0x01, 0x83, 0xc7, 0xef,   /* 0x8b */
	0x3c, 0x42, 0x81, 0x81, 0x81, 0x81, 0x42, 0x3c,   /* 0x8c */
	0xc3, 0x81, 0x00, 0x00, 0x00, 0x00, 0x81, 0xc3,   /* 0x8d */
	0xff, 0xfe, 0xfc, 0xf8, 0xf0, 0xe0, 0xc0, 0x80,   /* 0x8e */
	0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff,   /* 0x8f */
	0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80,   /* 0x90 */
	0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x01,   /* 0x91 */
	0x00, 0x00, 0x00, 0x00, 0x03, 0x0c, 0x30, 0xc0,   /* 0x92 */
	0x03, 0x0c, 0x30, 0xc0, 0x00, 0x00, 0x00, 0x00,   /* 0x93 */
	0x03, 0x0c, 0x30, 0xc0, 0xc0, 0x30, 0x0c, 0x03,   /* 0x94 */
	0x00, 0x00, 0x00, 0x00, 0xc0, 0x30, 0x0c, 0x03,   /* 0x95 */
	0xc0, 0x30, 0x0c, 0x03, 0x00, 0x00, 0x00, 0x00,   /* 0x96 */
	0xc0, 0x30, 0x0c, 0x03, 0x03, 0x0c, 0x30, 0xc0,   /* 0x97 */
	0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x80, 0x80,   /* 0x98 */
	0x01, 0x01, 0x02, 0x02, 0x04, 0x04, 0x08, 0x08,   /* 0x99 */
	0x81, 0x81, 0x42, 0x42, 0x24, 0x24, 0x18, 0x18,   /* 0x9a */
	0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x10, 0x10,   /* 0x9b */
	0x08, 0x08, 0x04, 0x04, 0x02, 0x02, 0x01, 0x01,   /* 0x9c */
	0x18, 0x18, 0x24, 0x24, 0x42, 0x42, 0x81, 0x81,   /* 0x9d */
	0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0x9e */
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,   /* 0x9f */
	0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 0x00,   /* 0xa0 */
	0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18,   /* 0xa1 */
	0x18, 0x18, 0x18, 0xff, 0xff, 0x00, 0x00, 0x00,   /* 0xa2 */
	0x18, 0x18, 0x18, 0x1f, 0x1f, 0x18, 0x18, 0x18,   /* 0xa3 */
	0x00, 0x00, 0x00, 0xff, 0xff, 0x18, 0x18, 0x18,   /* 0xa4 */
	0x18, 0x18, 0x18, 0xf8, 0xf8, 0x18, 0x18, 0x18,   /* 0xa5 */
	0x18, 0x18, 0x18, 0xff, 0xff, 0x18, 0x18, 0x18,   /* 0xa6 */
	0x18, 0x18, 0x18, 0x1f, 0x1f, 0x00, 0x00, 0x00,   /* 0xa7 */
	0x00, 0x00, 0x00, 0x1f, 0x1f, 0x18, 0x18, 0x18,   /* 0xa8 */
	0x00, 0x00, 0x00, 0xf8, 0xf8, 0x18, 0x18, 0x18,   /* 0xa9 */
	0x18, 0x18, 0x18, 0xf8, 0xf8, 0x00, 0x00, 0x00,   /* 0xaa */
	0x80, 0x80, 0x80, 0x40, 0x40, 0x20, 0x18, 0x07,   /* 0xab */
	0x01, 0x01, 0x01, 0x02, 0x02, 0x04, 0x18, 0xe0,   /* 0xac */
	0xe0, 0x18, 0x04, 0x02, 0x02, 0x01, 0x01, 0x01,   /* 0xad */
	0x07, 0x18, 0x20, 0x40, 0x40, 0x80, 0x80, 0x80,   /* 0xae */
	0x81, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x81,   /* 0xaf */
	0xf0, 0xf0, 0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00,   /* 0xb0 */
	0x0f, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00,   /* 0xb1 */
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f, 0x0f, 0x0f,   /* 0xb2 */
	0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0, 0xf0, 0xf0,   /* 0xb3 */
	0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0, 0xf0,   /* 0xb4 */
	0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f, 0x0f,   /* 0xb5 */
	0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,   /* 0xb6 */
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,   /* 0xb7 */
	0xf0, 0xf0, 0xf0, 0xf0, 0x0f, 0x0f, 0x0f, 0x0f,   /* 0xb8 */
	0x0f, 0x0f, 0x0f, 0x0f, 0xf0, 0xf0, 0xf0, 0xf0,   /* 0xb9 */
	0x0f, 0x0f, 0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff,   /* 0xba */
	0xf0, 0xf0, 0xf0, 0xf0, 0xff, 0xff, 0xff, 0xff,   /* 0xbb */
	0xff, 0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf0, 0xf0,   /* 0xbc */
	0xff, 0xff, 0xff, 0xff, 0x0f, 0x0f, 0x0f, 0x0f,   /* 0xbd */
	0x01, 0x03, 0x07, 0x0f, 0x1f, 0x3f, 0x7f, 0xff,   /* 0xbe */
	0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01,   /* 0xbf */
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,   /* 0xc0 */
	0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,   /* 0xc1 */
	0xff, 0x80, 0x80, 0x9c, 0x9c, 0x9c, 0x80, 0x80,   /* 0xc2 */
	0xff, 0xff, 0xff, 0xe3, 0xe3, 0xe3, 0xff, 0xff,   /* 0xc3 */
	0x18, 0x3c, 0x7e, 0x3c, 0x18, 0x3c, 0x7e, 0xff,   /* 0xc4 */
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,   /* 0xc5 */
	0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,   /* 0xc6 */
	0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa,   /* 0xc7 */
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xff,   /* 0xc8 */
	0x00, 0x10, 0x38, 0x7c, 0xfe, 0x7c, 0x38, 0x10,   /* 0xc9 */
	0x38, 0x10, 0x92, 0xfe, 0x92, 0x10, 0x38, 0x7c,   /* 0xca */
	0x00, 0x6c, 0xfe, 0xfe, 0xfe, 0x7c, 0x38, 0x10,   /* 0xcb */
	0x10, 0x38, 0x7c, 0xfe, 0xfe, 0x7c, 0x10, 0x7c,   /* 0xcc */
	0xe7, 0xe7, 0x42, 0xff, 0xff, 0x42, 0xe7, 0xe7,   /* 0xcd */
	0xdb, 0xff, 0xdb, 0x18, 0x18, 0xdb, 0xff, 0xdb,   /* 0xce */
	0x3c, 0x7e, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x3c,   /* 0xcf */
	0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xd0 */
	0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xd1 */
	0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xd2 */
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xd3 */
	0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,   /* 0xd4 */
	0x00, 0x00, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00,   /* 0xd5 */
	0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x00,   /* 0xd6 */
	0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00,   /* 0xd7 */
	0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0x00, 0x00,   /* 0xd8 */
	0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, 0x00,   /* 0xd9 */
	0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00,   /* 0xda */
	0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00,   /* 0xdb */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,   /* 0xdc */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30,   /* 0xdd */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c,   /* 0xde */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,   /* 0xdf */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0f,   /* 0xe0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3f,   /* 0xe1 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,   /* 0xe2 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0xfc,   /* 0xe3 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xf0,   /* 0xe4 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0,   /* 0xe5 */
	0x00, 0x00, 0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0,   /* 0xe6 */
	0x00, 0x00, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,   /* 0xe7 */
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,   /* 0xe8 */
	0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00,   /* 0xe9 */
	0xc0, 0xc0, 0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00,   /* 0xea */
	0xc0, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xeb */
	0xf0, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xec */
	0xfc, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xed */
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xee */
	0x3f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xef */
	0x0f, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xf0 */
	0x03, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 0xf1 */
	0x03, 0x03, 0x03, 0x03, 0x00, 0x00, 0x00, 0x00,   /* 0xf2 */
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00,   /* 0xf3 */
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,   /* 0xf4 */
	0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,   /* 0xf5 */
	0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x03, 0x03,   /* 0xf6 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03,   /* 0xf7 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff,   /* 0xf8 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,   /* 0xf9 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,   /* 0xfa */
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,   /* 0xfb */
	0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0xfc */
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0xfd */
	0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0xfe */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,   /* 0xff */
};

#endif /* __ui_font0_h */
