/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.iff.Superchunk;
import edu.harvard.hul.ois.jhove.module.wave.ExifInfo;
import edu.harvard.hul.ois.jhove.module.wave.ExifStringChunk;
import edu.harvard.hul.ois.jhove.module.wave.ExifVersionChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabelChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabeledTextChunk;
import edu.harvard.hul.ois.jhove.module.wave.ListInfoTextChunk;
import edu.harvard.hul.ois.jhove.module.wave.NoteChunk;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.LinkedList;

public class ListInfoChunk
extends Superchunk {
    public ListInfoChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream, RepInfo repInfo) {
        super(moduleBase, chunkHeader, dataInputStream, repInfo);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        String string = ((WaveModule)this._module).read4Chars(this._dstream);
        this.bytesLeft -= 4L;
        if ("INFO".equals(string)) {
            return this.readInfoChunk(repInfo);
        }
        if ("exif".equals(string)) {
            return this.readExifChunk(repInfo);
        }
        if ("adtl".equals(string)) {
            return this.readAdtlChunk(repInfo);
        }
        repInfo.setMessage((Message)new ErrorMessage("Unknown list type " + string + " in List Chunk", this._module.getNByte()));
        repInfo.setWellFormed(false);
        return false;
    }

    private boolean readInfoChunk(RepInfo repInfo) throws IOException {
        ChunkHeader chunkHeader;
        LinkedList linkedList = new LinkedList();
        WaveModule waveModule = (WaveModule)this._module;
        while ((chunkHeader = this.getNextChunkHeader()) != null) {
            ListInfoTextChunk listInfoTextChunk = null;
            String string = chunkHeader.getID();
            int n = (int)chunkHeader.getSize();
            listInfoTextChunk = new ListInfoTextChunk(this._module, chunkHeader, this._dstream, linkedList, this);
            if (listInfoTextChunk == null) {
                this._module.skipBytes(this._dstream, n, this._module);
                repInfo.setMessage((Message)new InfoMessage("Chunk type '" + string + "' in List Info Chunk ignored"));
            } else if (!((Chunk)listInfoTextChunk).readChunk(repInfo)) {
                return false;
            }
            if ((n & 1) == 0) continue;
            this._module.skipBytes(this._dstream, 1, this._module);
            --this.bytesLeft;
        }
        if (!linkedList.isEmpty()) {
            waveModule.addListInfo(linkedList);
        }
        return true;
    }

    private boolean readExifChunk(RepInfo repInfo) throws IOException {
        ChunkHeader chunkHeader;
        LinkedList linkedList = new LinkedList();
        WaveModule waveModule = (WaveModule)this._module;
        waveModule.setExifInfo(new ExifInfo());
        while ((chunkHeader = this.getNextChunkHeader()) != null) {
            Chunk chunk = null;
            String string = chunkHeader.getID();
            int n = (int)chunkHeader.getSize();
            if ("ever".equals(string)) {
                chunk = new ExifVersionChunk(this._module, chunkHeader, this._dstream);
            } else if ("erel".equals(string) || "etim".equals(string) || "ecor".equals(string) || "emdl".equals(string)) {
                chunk = new ExifStringChunk(this._module, chunkHeader, this._dstream);
            } else if ("emnt".equals(string) || "eucm".equals(string)) {
                // empty if block
            }
            if (chunk == null) {
                this._module.skipBytes(this._dstream, n, this._module);
                repInfo.setMessage((Message)new InfoMessage("Chunk type '" + string + "' in Associated Data Chunk ignored"));
                continue;
            }
            if (((Chunk)chunk).readChunk(repInfo)) continue;
            return false;
        }
        return false;
    }

    public boolean readAdtlChunk(RepInfo repInfo) throws IOException {
        ChunkHeader chunkHeader;
        WaveModule waveModule = (WaveModule)this._module;
        while ((chunkHeader = this.getNextChunkHeader()) != null) {
            Chunk chunk = null;
            String string = chunkHeader.getID();
            int n = (int)chunkHeader.getSize();
            if (string.equals("labl")) {
                chunk = new LabelChunk(this._module, chunkHeader, this._dstream);
            } else if (string.equals("note")) {
                chunk = new NoteChunk(this._module, chunkHeader, this._dstream);
            } else if (string.equals("ltxt")) {
                chunk = new LabeledTextChunk(this._module, chunkHeader, this._dstream);
            }
            if (chunk == null) {
                this._module.skipBytes(this._dstream, n, this._module);
                repInfo.setMessage((Message)new InfoMessage("Chunk type '" + string + "' in Associated Data Chunk ignored"));
            } else if (!((Chunk)chunk).readChunk(repInfo)) {
                return false;
            }
            if ((n & 1) == 0) continue;
            this._module.skipBytes(this._dstream, 1, this._module);
            --this.bytesLeft;
        }
        return true;
    }
}

