/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfileClassG
extends TiffProfile {
    public TiffProfileClassG() {
        this._profileText = "Baseline grayscale (Class G)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD iFD) {
        if (!(iFD instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tiffIFD = (TiffIFD)iFD;
        NisoImageMetadata nisoImageMetadata = tiffIFD.getNisoImageMetadata();
        if (nisoImageMetadata.getImageWidth() == -1L || nisoImageMetadata.getImageLength() == -1L || nisoImageMetadata.getStripOffsets() == null || nisoImageMetadata.getRowsPerStrip() == -1L || nisoImageMetadata.getStripByteCounts() == null || nisoImageMetadata.getXSamplingFrequency() == null || nisoImageMetadata.getYSamplingFrequency() == null) {
            return false;
        }
        if (nisoImageMetadata.getSamplesPerPixel() > 1) {
            return false;
        }
        int[] nArray = nisoImageMetadata.getBitsPerSample();
        if (nArray == null || nArray[0] != 4 && nArray[0] != 8) {
            return false;
        }
        if (!this.satisfiesCompression(tiffIFD, new int[]{1, 32773})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tiffIFD, new int[]{0, 1})) {
            return false;
        }
        return this.satisfiesResolutionUnit(tiffIFD, new int[]{1, 2, 3});
    }
}

