/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.PdfModule;
import edu.harvard.hul.ois.jhove.module.pdf.DocNode;
import edu.harvard.hul.ois.jhove.module.pdf.PageObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfArray;
import edu.harvard.hul.ois.jhove.module.pdf.PdfDictionary;
import edu.harvard.hul.ois.jhove.module.pdf.PdfException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfIndirectObj;
import edu.harvard.hul.ois.jhove.module.pdf.PdfInvalidException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfMalformedException;
import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class PageTreeNode
extends DocNode {
    private List _descendants;
    private ListIterator _descendantsIter;
    private DocNode _currentDescendant;
    private boolean _walkFirst;

    public PageTreeNode(PdfModule pdfModule, PageTreeNode pageTreeNode, PdfDictionary pdfDictionary) {
        super(pdfModule, pageTreeNode, pdfDictionary);
        this._pageObjectFlag = false;
        this._descendants = new ArrayList(1);
    }

    public void buildSubtree(boolean bl, int n) throws PdfException {
        this.buildSubtree(bl, n, -1, -1);
    }

    public void buildSubtree(boolean bl, int n, int n2, int n3) throws PdfException {
        if (n <= 0) {
            throw new PdfMalformedException("Excessive depth or infinite recursion in page tree structure");
        }
        PdfArray pdfArray = null;
        try {
            PdfObject pdfObject = this._dict.get("Kids");
            pdfArray = pdfObject instanceof PdfIndirectObj ? (PdfArray)((PdfIndirectObj)pdfObject).getObject() : (PdfArray)pdfObject;
            if (bl && pdfArray == null) {
                PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)this._dict.get("Type");
                if (pdfSimpleObject != null && "Page".equals(pdfSimpleObject.getStringValue())) {
                    PageObject pageObject = new PageObject(this._module, this, this._dict);
                    this._descendants = new ArrayList(1);
                    this._descendants.add(pageObject);
                }
            } else {
                Vector vector = pdfArray.getContent();
                this._descendants = new ArrayList(vector.size());
                for (int i = 0; i < vector.size(); ++i) {
                    DocNode docNode;
                    PdfIndirectObj pdfIndirectObj = (PdfIndirectObj)vector.elementAt(i);
                    PdfDictionary pdfDictionary = (PdfDictionary)this._module.resolveIndirectObject(pdfIndirectObj);
                    PdfSimpleObject pdfSimpleObject = (PdfSimpleObject)pdfDictionary.get("Type");
                    String string = pdfSimpleObject.getStringValue();
                    if (string.equals("Page")) {
                        docNode = new PageObject(this._module, this, pdfDictionary);
                        ((PageObject)docNode).loadContent(this._module);
                        this._descendants.add(docNode);
                        continue;
                    }
                    if (!string.equals("Pages")) continue;
                    docNode = new PageTreeNode(this._module, this, pdfDictionary);
                    ((PageTreeNode)docNode).buildSubtree(false, n - 1);
                    this._descendants.add(docNode);
                }
            }
        }
        catch (PdfException pdfException) {
            throw pdfException;
        }
        catch (Exception exception) {
            throw new PdfInvalidException("Invalid page tree node");
        }
    }

    @Override
    public void startWalk() {
        this._descendantsIter = this._descendants.listIterator();
        this._currentDescendant = null;
        this._walkFirst = true;
        this._walkFinished = false;
    }

    @Override
    public PageObject nextPageObject() {
        PageObject pageObject;
        if (this._walkFinished) {
            return null;
        }
        if (this._currentDescendant == null) {
            if (!this._descendantsIter.hasNext()) {
                this._walkFinished = true;
                return null;
            }
            this._currentDescendant = (DocNode)this._descendantsIter.next();
            this._currentDescendant.startWalk();
        }
        if ((pageObject = this._currentDescendant.nextPageObject()) == null) {
            if (this._descendantsIter.hasNext()) {
                this._currentDescendant = (DocNode)this._descendantsIter.next();
                this._currentDescendant.startWalk();
                return this._currentDescendant.nextPageObject();
            }
            this._walkFinished = true;
            return null;
        }
        return pageObject;
    }

    @Override
    public DocNode nextDocNode() {
        DocNode docNode;
        if (this._walkFinished) {
            return null;
        }
        if (this._walkFirst) {
            this._walkFirst = false;
            return this;
        }
        if (this._currentDescendant == null) {
            if (!this._descendantsIter.hasNext()) {
                this._walkFinished = true;
                return null;
            }
            this._currentDescendant = (DocNode)this._descendantsIter.next();
            this._currentDescendant.startWalk();
        }
        if ((docNode = this._currentDescendant.nextDocNode()) == null) {
            if (this._descendantsIter.hasNext()) {
                this._currentDescendant = (DocNode)this._descendantsIter.next();
                this._currentDescendant.startWalk();
                return this._currentDescendant.nextDocNode();
            }
            this._walkFinished = true;
            return null;
        }
        return docNode;
    }
}

