/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PartialEtchedBorder;
import com.jidesoft.swing.PartialGradientLineBorder;
import com.jidesoft.swing.PartialLineBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class TitledSeparator
extends JPanel {
    public static final int TYPE_PARTIAL_ETCHED = 0;
    public static final int TYPE_PARTIAL_LINE = 1;
    public static final int TYPE_PARTIAL_GRADIENT_LINE = 2;
    private int _textAlignment;
    private int _barAlignment;
    private JComponent _labelComponent;
    private Border _border;
    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_SEPARATOR_BORDER = "separatorBorder";
    public static final String PROPERTY_BAR_ALIGNMENT = "barAlignment";
    public static final String PROPERTY_TEXT_ALIGNMENT = "textAlignment";

    public TitledSeparator() {
        this("");
    }

    public TitledSeparator(String string) {
        this(string, 0, 2);
    }

    public TitledSeparator(String string, int n) {
        this((JComponent)new JLabel(string), 0, n);
    }

    public TitledSeparator(String string, int n, int n2) {
        this((JComponent)new JLabel(string), n, n2);
    }

    public TitledSeparator(JComponent jComponent, int n) {
        this(jComponent, 0, n);
    }

    public TitledSeparator(JComponent jComponent, int n, int n2) {
        this(jComponent, n, n2, 0);
    }

    public TitledSeparator(JComponent jComponent, Border border, int n) {
        this(jComponent, border, n, 0);
    }

    public TitledSeparator(JComponent jComponent, int n, int n2, int n3) {
        AbstractBorder abstractBorder;
        int n4 = 2;
        int n5 = 1;
        Color color = jComponent.getBackground();
        if (color == null) {
            color = UIDefaultsLookup.getColor("Label.background");
        }
        switch (n) {
            case 1: {
                Color color2 = color.darker();
                abstractBorder = new PartialLineBorder(color2, n5, n4);
                break;
            }
            case 2: {
                Color color3 = color.darker();
                Color color4 = color.brighter();
                Color[] colorArray = new Color[]{color3, color4};
                abstractBorder = new PartialGradientLineBorder(colorArray, n5, n4);
                break;
            }
            default: {
                abstractBorder = new PartialEtchedBorder(n4);
            }
        }
        this._labelComponent = jComponent;
        this._border = abstractBorder;
        this._textAlignment = n2;
        this._barAlignment = n3;
        this.validateTitledSeparator();
    }

    public TitledSeparator(JComponent jComponent, Border border, int n, int n2) {
        this._labelComponent = jComponent;
        this._border = border;
        this._textAlignment = n;
        this._barAlignment = n2;
        this.validateTitledSeparator();
    }

    public void setLabelComponent(JComponent jComponent) {
        JComponent jComponent2 = this._labelComponent;
        if (!JideSwingUtilities.equals(jComponent2, jComponent)) {
            this._labelComponent = jComponent;
            this.firePropertyChange(PROPERTY_LABEL, jComponent2, this._labelComponent);
            this.validateTitledSeparator();
            this.repaint();
        }
    }

    public JComponent getLabelComponent() {
        return this._labelComponent;
    }

    public void setSeparatorBorder(Border border) {
        Border border2 = this._border;
        if (!JideSwingUtilities.equals(border2, border)) {
            this._border = border;
            this.firePropertyChange(PROPERTY_SEPARATOR_BORDER, border2, this._border);
            this.validateTitledSeparator();
            this.repaint();
        }
    }

    public Border getSeparatorBorder() {
        return this._border;
    }

    public void setTextAlignment(int n) {
        int n2 = this._textAlignment;
        if (n != n2) {
            this._textAlignment = n;
            this.firePropertyChange(PROPERTY_TEXT_ALIGNMENT, n2, this._textAlignment);
            this.validateTitledSeparator();
            this.repaint();
        }
    }

    public int getTextAlignment() {
        return this._textAlignment;
    }

    public void setBarAlignment(int n) {
        int n2 = this._barAlignment;
        if (n != n2) {
            this._barAlignment = n;
            this.firePropertyChange(PROPERTY_BAR_ALIGNMENT, n2, this._barAlignment);
            this.validateTitledSeparator();
            this.repaint();
        }
    }

    public int getBarAlignment() {
        return this._barAlignment;
    }

    public void validateTitledSeparator() {
        int n;
        if (this._labelComponent == null) {
            throw new NullPointerException("Component must not be null.");
        }
        if (this._border == null) {
            throw new NullPointerException("border must not be null.");
        }
        if (this._textAlignment != 2 && this._textAlignment != 4 && this._textAlignment != 0 && this._textAlignment != 10 && this._textAlignment != 11) {
            n = this.getComponentOrientation().isLeftToRight();
            this._textAlignment = n != 0 ? 2 : 4;
        }
        if (this._textAlignment == 10 || this._textAlignment == 11) {
            n = this.getComponentOrientation().isLeftToRight() ? 1 : 0;
            this._textAlignment = n != 0 ? 2 : 4;
        }
        if (this._barAlignment != 1 && this._barAlignment != 0 && this._barAlignment != 3) {
            this._barAlignment = 0;
        }
        this.removeAll();
        if (this._labelComponent instanceof JLabel) {
            ((JLabel)this._labelComponent).setVerticalAlignment(3);
        }
        n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Dimension dimension = this._labelComponent.getPreferredSize();
        int n5 = dimension.height;
        int n6 = 2;
        try {
            n6 = this._border.getBorderInsets(null).bottom;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this._textAlignment == 2) {
            n2 = 4;
        } else if (this._textAlignment == 4) {
            n4 = 4;
        } else if (this._textAlignment == 0) {
            n2 = 4;
            n4 = 4;
        }
        if (this._barAlignment == 0) {
            n3 = n5 / 2 - n6 / 2;
        } else if (this._barAlignment == 1) {
            n3 = n5 - n6;
        } else if (this._barAlignment == 3) {
            n3 = 0;
        }
        EmptyBorder emptyBorder = new EmptyBorder(n, n2, n3, n4);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new CompoundBorder(emptyBorder, this._border));
        this.setLayout(new JideBoxLayout(this, 0));
        this.setOpaque(false);
        if (this._textAlignment == 2) {
            this.add(this._labelComponent);
            this.add((Component)jPanel, "vary");
        } else if (this._textAlignment == 4) {
            this.add((Component)jPanel, "vary");
            this.add(this._labelComponent);
        } else {
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(new CompoundBorder(emptyBorder, this._border));
            this.add((Component)jPanel, "flexible");
            this.add((Component)this._labelComponent, "fix");
            this.add((Component)jPanel2, "flexible");
        }
    }
}

