/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.sam;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.filter.FilteringIterator;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.sam.HitsForInsert;
import net.sf.picard.sam.PrimaryAlignmentSelectionStrategy;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.Cigar;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordQueryNameComparator;
import net.sf.samtools.SAMTag;
import net.sf.samtools.SAMUtils;
import net.sf.samtools.util.CloseableIterator;

class MultiHitAlignedReadIterator
implements CloseableIterator<HitsForInsert> {
    private final PeekableIterator<SAMRecord> peekIterator;
    private final SAMRecordQueryNameComparator queryNameComparator = new SAMRecordQueryNameComparator();
    private final PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy;
    private HitsForInsert theNext = null;

    MultiHitAlignedReadIterator(CloseableIterator<SAMRecord> querynameOrderIterator, PrimaryAlignmentSelectionStrategy primaryAlignmentSelectionStrategy) {
        this.primaryAlignmentSelectionStrategy = primaryAlignmentSelectionStrategy;
        this.peekIterator = new PeekableIterator(new FilteringIterator((Iterator<SAMRecord>)querynameOrderIterator, new SamRecordFilter(){

            @Override
            public boolean filterOut(SAMRecord record) {
                return record.getReadUnmappedFlag() || SAMUtils.cigarMapsNoBasesToRef((Cigar)record.getCigar());
            }

            @Override
            public boolean filterOut(SAMRecord first, SAMRecord second) {
                return !(!first.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef((Cigar)first.getCigar()) || !second.getReadUnmappedFlag() && !SAMUtils.cigarMapsNoBasesToRef((Cigar)second.getCigar()));
            }
        }));
        this.advance();
    }

    public void close() {
        this.peekIterator.close();
    }

    public boolean hasNext() {
        return this.theNext != null;
    }

    public HitsForInsert next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        HitsForInsert ret = this.theNext;
        this.advance();
        return ret;
    }

    private void advance() {
        while (this.peekIterator.hasNext()) {
            this.theNext = this.nextMaybeEmpty();
            if (this.theNext.numHits() <= 0) continue;
            return;
        }
        this.theNext = null;
    }

    private HitsForInsert nextMaybeEmpty() {
        if (!this.peekIterator.hasNext()) {
            throw new IllegalStateException();
        }
        String readName = this.peekIterator.peek().getReadName();
        HitsForInsert hits = new HitsForInsert();
        Boolean isPaired = null;
        do {
            SAMRecord rec = this.peekIterator.next();
            if (this.peekIterator.hasNext() && this.queryNameComparator.fileOrderCompare(rec, this.peekIterator.peek()) > 0) {
                throw new IllegalStateException("Underlying iterator is not queryname sorted: " + rec + " > " + this.peekIterator.peek());
            }
            if (isPaired == null) {
                isPaired = rec.getReadPairedFlag();
            } else if (isPaired.booleanValue() != rec.getReadPairedFlag()) {
                throw new PicardException("Got a mix of paired and unpaired alignments for read " + readName);
            }
            if (!rec.getReadPairedFlag() || rec.getFirstOfPairFlag()) {
                hits.addFirstOfPairOrFragment(rec);
                continue;
            }
            if (rec.getSecondOfPairFlag()) {
                hits.addSecondOfPair(rec);
                continue;
            }
            throw new PicardException("Read is marked as pair but neither first or second: " + readName);
        } while (this.peekIterator.hasNext() && this.peekIterator.peek().getReadName().equals(readName));
        if (hits.numHits() <= 1) {
            if (hits.getFirstOfPair(0) != null) {
                hits.getFirstOfPair(0).setAttribute(SAMTag.HI.name(), null);
                hits.getFirstOfPair(0).setNotPrimaryAlignmentFlag(false);
            }
            if (hits.getSecondOfPair(0) != null) {
                hits.getSecondOfPair(0).setAttribute(SAMTag.HI.name(), null);
                hits.getSecondOfPair(0).setNotPrimaryAlignmentFlag(false);
            }
        } else {
            this.primaryAlignmentSelectionStrategy.pickPrimaryAlignment(hits);
        }
        return hits;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

