/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBEncoder;
import com.mongodb.DBObject;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.Mongo;
import com.mongodb.MongoInternalException;
import com.mongodb.ReadPreference;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.BSONObject;
import org.bson.BasicBSONEncoder;
import org.bson.io.PoolOutputBuffer;

class OutMessage
extends BasicBSONEncoder {
    static AtomicInteger ID = new AtomicInteger(1);
    private Mongo _mongo;
    private PoolOutputBuffer _buffer;
    private int _id;
    private int _queryOptions = 0;
    private ReadPreference _readPref = ReadPreference.PRIMARY;
    private DBEncoder _encoder;

    static OutMessage query(Mongo m, int options, String ns, int numToSkip, int batchSize, DBObject query, DBObject fields) {
        return OutMessage.query(m, options, ns, numToSkip, batchSize, query, fields, ReadPreference.PRIMARY);
    }

    static OutMessage query(Mongo m, int options, String ns, int numToSkip, int batchSize, DBObject query, DBObject fields, ReadPreference readPref) {
        return OutMessage.query(m, options, ns, numToSkip, batchSize, query, fields, readPref, DefaultDBEncoder.FACTORY.create());
    }

    static OutMessage query(Mongo m, int options, String ns, int numToSkip, int batchSize, DBObject query, DBObject fields, ReadPreference readPref, DBEncoder enc) {
        OutMessage out = new OutMessage(m, 2004, enc);
        out._appendQuery(options, ns, numToSkip, batchSize, query, fields, readPref);
        return out;
    }

    OutMessage(Mongo m) {
        this(m, DefaultDBEncoder.FACTORY.create());
    }

    OutMessage(Mongo m, int op) {
        this(m);
        this.reset(op);
    }

    OutMessage(Mongo m, DBEncoder encoder) {
        this._encoder = encoder;
        this._mongo = m;
        this._buffer = this._mongo == null ? new PoolOutputBuffer() : this._mongo._bufferPool.get();
        this._buffer.reset();
        this.set(this._buffer);
    }

    OutMessage(Mongo m, int op, DBEncoder enc) {
        this(m, enc);
        this.reset(op);
    }

    private void _appendQuery(int options, String ns, int numToSkip, int batchSize, DBObject query, DBObject fields, ReadPreference readPref) {
        this._queryOptions = options;
        this._readPref = readPref;
        if (this._readPref != null && !(this._readPref instanceof ReadPreference.PrimaryReadPreference)) {
            this._queryOptions |= 4;
        }
        this.writeInt(this._queryOptions);
        this.writeCString(ns);
        this.writeInt(numToSkip);
        this.writeInt(batchSize);
        this.putObject(query);
        if (fields != null) {
            this.putObject(fields);
        }
    }

    private void reset(int op) {
        this.done();
        this._buffer.reset();
        this.set(this._buffer);
        this._id = ID.getAndIncrement();
        this.writeInt(0);
        this.writeInt(this._id);
        this.writeInt(0);
        this.writeInt(op);
    }

    void prepare() {
        this._buffer.writeInt(0, this._buffer.size());
    }

    void pipe(OutputStream out) throws IOException {
        this._buffer.pipe(out);
    }

    int size() {
        return this._buffer.size();
    }

    byte[] toByteArray() {
        return this._buffer.toByteArray();
    }

    void doneWithMessage() {
        if (this._buffer != null && this._mongo != null) {
            this._buffer.reset();
        }
        this._mongo._bufferPool.done(this._buffer);
        this._buffer = null;
        this._mongo = null;
    }

    boolean hasOption(int option) {
        return (this._queryOptions & option) != 0;
    }

    int getId() {
        return this._id;
    }

    public int putObject(BSONObject o) {
        int sz = this._encoder.writeObject(this._buf, o);
        if (this._mongo != null) {
            int maxsize = this._mongo.getConnector().getMaxBsonObjectSize();
            if (sz > (maxsize = Math.max(maxsize, 0x400000))) {
                throw new MongoInternalException("DBObject of size " + sz + " is over Max BSON size " + this._mongo.getMaxBsonObjectSize());
            }
        }
        return sz;
    }

    public ReadPreference getReadPreference() {
        return this._readPref;
    }
}

