/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.controller;

import com.amazonaws.services.auth.identity.cli.common.Utils;
import com.amazonaws.services.auth.identity.cli.controller.IAMDriver;
import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.model.InstanceProfileGetAttributesRequest;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest;
import com.amazonaws.services.identitymanagement.model.GetInstanceProfileResult;
import com.amazonaws.services.identitymanagement.model.Role;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IAMInstanceProfileGetAttributesDriver
extends IAMDriver {
    private static final Log LOG = LogFactory.getLog(IAMInstanceProfileGetAttributesDriver.class);

    protected void invokeRequestImpl(CLIRequest request) {
        if (request instanceof InstanceProfileGetAttributesRequest) {
            InstanceProfileGetAttributesRequest getAttributesRequest = (InstanceProfileGetAttributesRequest)request;
            LOG.debug((Object)("Getting Instance Profile: " + getAttributesRequest));
            if (getAttributesRequest.getInstanceProfileName() == null) {
                Utils.exit(1, "no Instance Profile name has been passed in.", null);
            }
            GetInstanceProfileRequest iipGetAttributesRequest = new GetInstanceProfileRequest();
            iipGetAttributesRequest.setInstanceProfileName(getAttributesRequest.getInstanceProfileName());
            GetInstanceProfileResult iipGetResult = this.getClient().getInstanceProfile(iipGetAttributesRequest);
            LOG.info((Object)iipGetResult.getInstanceProfile().getArn());
            LOG.info((Object)iipGetResult.getInstanceProfile().getInstanceProfileId());
            if (getAttributesRequest.getPrintRole()) {
                for (Role r : iipGetResult.getInstanceProfile().getRoles()) {
                    LOG.info((Object)r.getArn());
                }
            }
        } else {
            Utils.exit(1, "request " + request + " is of an incorrect type.", null);
        }
    }
}

