/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGITS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	char *cfgTypeString(int type);

	Return a string describing human readeble the type.
	Never NULL, pointer to internal static read-only buffer

ob(ject): cfgTypeString
su(bsystem): inifile
sh(ort description): Return a human readeble string for a type
lo(ng description): Return the pointer to a string describing the specified
	type in human readeble form.
wa: The returned string must not be modified.
va: Never NULL
re(lated to): 
fi(le): cfgits.c
in(itialized by):

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "suppl.h"
#include "inifile.loc"
#include "msgs.loc"
#include "msgs.lng"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGITS.C 1.3 1999/12/13 02:22:27 ska Exp ska $";
#endif

static int types[] = {
	CFG_TNONE,
	CFG_TSTRING,
	CFG_TEXPAND,
	CFG_TINTEGER,
	CFG_TBOOLEAN,
	CFG_TEXPINTEGER,
	CFG_TEXPBOOLEAN
};

static char *typeStr[] = {		/* same order as above */
	I_TcfgNone,
	I_TcfgStr,
	I_TcfgExpStr,
	I_TcfgInt,
	I_TcfgBool,
	I_TcfgExpInt,
	I_TcfgExpBool
};

char *cfgTypeString(int type)
{	int i;

	DBG_ENTER("cfgTypeString", Suppl_inifile)
	DBG_ARGUMENTS( ("type=%d", type) )

	chkHeap
	for(i = itemsof(types); --i >= 0;)
		if(types[i] == type)
			DBG_RETURN_S( typeStr[i])

	DBG_RETURN_S( I_TcfgErr)
}
