#!/bin/csh
#      tree.csh <name>		Make a tree from a set of blocks
#	creates <name>.treefile
#   where <name> is a file containing the blocks to be processed
#
unalias rm
unalias mv
limit cputime 5m
#
set mach = `uname -n`
#  If $1 = /howard/btest/tmp/AA.blks, then $r = /howard/btest/tmp/AA
#
if ( -e $1 ) then
#
   set r = $1:r
#	Make clustalw tree file
   ./blalign $1 -f > $r.fblks
   if ( -e $r.fblks ) then
      set nseq = (`grep -c ">" $r.fblks`)
      if ( $nseq <= 25 || $mach == muller) then
#		always use 100 bootstraps
         @ nboot = 100
#        echo "      **CLUSTALW tree (bootstrap=$nboot)**" >> $r.treefile
#		drawgram requires bootlabels=node (default is branch)
         ./clustalw $r.fblks -bootstrap=$nboot -bootlabels=node -kimura >& /dev/null
         if (-e $r.phb) then
#           cat $r.phb >> $r.treefile
            mv $r.phb $r.treefile
         else
            echo "clustalw failed to make a tree" > $r.treefile
         endif
      else
#        echo "      **CLUSTALW tree (no bootstrap)**" >> $r.treefile
         ./clustalw $r.fblks -tree -kimura >& /dev/null
         if (-e $r.ph) then
#           cat $r.ph >> $r.treefile
            mv $r.ph $r.treefile
         else
            echo "clustalw failed to make a tree" >> $r.treefile
         endif
      endif
      rm $r.fblks
   endif
#  
else
   echo "Cannot open blocks file $1 to make a tree." >> $r.treefile
endif
#
exit(0)
