/* Generated by re2c */
#line 1 "real_world/parse_date_db.re"
// re2c $INPUT -o $OUTPUT -db
/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2006 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.01 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_01.txt                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors: Derick Rethans <derick@derickrethans.nl>                    |
   +----------------------------------------------------------------------+
 */

/* $Id: parse_date.re,v 1.36 2006/04/09 15:03:01 derick Exp $ */

#include "timelib.h"

#include <stdio.h>
#include <ctype.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define TIMELIB_SECOND  1
#define TIMELIB_MINUTE  2
#define TIMELIB_HOUR    3
#define TIMELIB_DAY     4
#define TIMELIB_MONTH   5
#define TIMELIB_YEAR    6
#define TIMELIB_WEEKDAY 7

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->f = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; s->time->relative.weekday_behavior = 0; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_weekday_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { add_warning(s, "Double timezone specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_zone = 1; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x) { \
	if ((x) == -1) {         \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

#include "timelib_structs.h"

typedef struct timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	struct timelib_error_container *errors;

	struct timelib_time *time;
	timelib_tzdb        *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
    const char *name;
    int         type;
    int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

#define HOUR(a) (int)(a * 60)

/* The timezone table. */
static timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = strdup(error);
}

static void add_error(Scanner *s, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		*ptr += 3;
	} else {
		++*ptr;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = -1;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	free(str);
	return tmp_nr;
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!strncasecmp(*ptr, "nd", 2) || !strncasecmp(*ptr, "rd", 2) ||!strncasecmp(*ptr, "st", 2) || !strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static double timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = -1;
	int len = 0;

	while ((**ptr != '.') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtod(str, NULL);
	free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return -1;
		}
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
	} else if (**ptr == '-') {
		dir = -1;
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	long  tmp;

	while (**ptr != '\0') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1:
		case 2:
			return HOUR(strtol(begin, NULL, 10));
			break;
		case 3:
		case 4:
			if (begin[1] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 2, NULL, 10);
				return tmp;
			} else if (begin[2] == ':') {
				tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return HOUR(tmp / 100) + tmp % 100;
			}
		case 5:
			tmp = HOUR(strtol(begin, NULL, 10)) + strtol(begin + 3, NULL, 10);
			return tmp;
	}
	return 0;
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	free(word);
	return value;
}

static long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != '\t') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	relunit = timelib_lookup_relunit(ptr);
	switch (relunit->unit) {
		case TIMELIB_SECOND: s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE: s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:   s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:    s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:  s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:   s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;
	}
}

static timelib_tz_lookup_table* zone_search(const char *word, long gmtoffset, int isdst)
{
	int first_found = 0;
	timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	timelib_tz_lookup_table  *fmp;

	if (strcasecmp("utc", word) == 0 || strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}
	
	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if ((fmp->gmtoffset * 3600) == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static long timelib_lookup_zone(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	long  value = 0;
	timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')') {
		++*ptr;
	}
	end = *ptr;
	word = calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = zone_search(word, -1, 0))) {
		value = -tp->gmtoffset / 60;
		*dst = tp->type;
		value += tp->type * 60;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

static long timelib_get_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, timelib_tzdb *tzdb)
{
	timelib_tzinfo *res;
	long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		long offset;
		char *tz_abbr;

		t->is_localtime = 1;

		offset = timelib_lookup_zone(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
		}
#if 0
		/* If we found a TimeZone identifier, use it */
		if (tz_name) {
			t->tz_info = timelib_parse_tzfile(tz_name);
			t->zone_type = TIMELIB_ZONETYPE_ID;
		}
#endif
		/* If we have a TimeZone identifier to start with, use it */
		if (strstr(tz_abbr, "/")) {
			if ((res = timelib_parse_tzfile(tz_abbr, tzdb)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		if (found && t->zone_type != TIMELIB_ZONETYPE_ID) {
			timelib_time_tz_abbr_update(t, tz_abbr);
		}
		free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		free(arg.v[i]);            \
	}                              \
	if (arg.v) {                   \
		free(arg.v);               \
	}                              \
}

static int scan(Scanner *s)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;
		
std:
	s->tok = cursor;
	s->len = 0;
#line 866 "real_world/parse_date_db.re"



#line 764 "real_world/parse_date_db.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 104,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		104,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,  64,  32,  96,   0, 
		 16,  16,  16,  16,  16,  16,  16,  16, 
		 16,  16,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0, 128, 128, 128, 192, 128, 128, 128, 
		192, 128, 128, 128, 128, 128, 192, 128, 
		128, 128, 192, 192, 192, 128, 128, 128, 
		128, 128, 128,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 29) YYFILL(29);
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00:
		case '\n': goto yy1;
		case '\t':
		case ' ': goto yy4;
		case '(': goto yy6;
		case '+':
		case '-': goto yy7;
		case ',':
		case '.': goto yy8;
		case '0': goto yy9;
		case '1': goto yy10;
		case '2': goto yy11;
		case '3': goto yy12;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy13;
		case '@': goto yy14;
		case 'A': goto yy15;
		case 'B':
		case 'C':
		case 'G':
		case 'H':
		case 'K':
		case 'Q':
		case 'R':
		case 'U':
		case 'Z': goto yy17;
		case 'D': goto yy18;
		case 'E': goto yy19;
		case 'F': goto yy20;
		case 'I': goto yy21;
		case 'J': goto yy22;
		case 'L': goto yy23;
		case 'M': goto yy24;
		case 'N': goto yy25;
		case 'O': goto yy26;
		case 'P': goto yy27;
		case 'S': goto yy28;
		case 'T': goto yy29;
		case 'V': goto yy30;
		case 'W': goto yy31;
		case 'X': goto yy32;
		case 'Y': goto yy33;
		case 'a': goto yy34;
		case 'b':
		case 'c':
		case 'g':
		case 'h':
		case 'i':
		case 'k':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy35;
		case 'd': goto yy36;
		case 'e': goto yy37;
		case 'f': goto yy38;
		case 'j': goto yy39;
		case 'l': goto yy40;
		case 'm': goto yy41;
		case 'n': goto yy42;
		case 'o': goto yy43;
		case 'p': goto yy44;
		case 's': goto yy45;
		case 't': goto yy46;
		case 'w': goto yy47;
		case 'y': goto yy48;
		default: goto yy2;
	}
yy1:
	YYDEBUG(1, *YYCURSOR);
	++YYCURSOR;
#line 1435 "real_world/parse_date_db.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 888 "real_world/parse_date_db.c"
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
yy3:
	YYDEBUG(3, *YYCURSOR);
#line 1441 "real_world/parse_date_db.re"
	{
		add_error(s, "Unexpected character");
		goto std;
	}
#line 899 "real_world/parse_date_db.c"
yy4:
	YYDEBUG(4, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy49;
	}
	if (yych <= '/') goto yy5;
	if (yych <= '9') goto yy51;
yy5:
	YYDEBUG(5, *YYCURSOR);
#line 1430 "real_world/parse_date_db.re"
	{
		goto std;
	}
#line 915 "real_world/parse_date_db.c"
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy3;
	if (yych <= 'Z') goto yy35;
	if (yych <= '`') goto yy3;
	if (yych <= 'z') goto yy35;
	goto yy3;
yy7:
	YYDEBUG(7, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 8) {
		goto yy49;
	}
	if (yych <= '/') goto yy3;
	if (yych <= '1') goto yy52;
	if (yych <= '2') goto yy53;
	if (yych <= '9') goto yy54;
	goto yy3;
yy8:
	YYDEBUG(8, *YYCURSOR);
	++YYCURSOR;
	goto yy5;
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t': goto yy55;
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'w':
		case 'y': goto yy57;
		case '-': goto yy58;
		case '.': goto yy59;
		case '/': goto yy60;
		case '0': goto yy61;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy62;
		case ':': goto yy63;
		case 'n': goto yy80;
		case 'r': goto yy81;
		case 's': goto yy82;
		case 't': goto yy83;
		default: goto yy3;
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t': goto yy84;
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy58;
		case '.': goto yy87;
		case '/': goto yy60;
		case '0':
		case '1':
		case '2': goto yy62;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy88;
		case ':': goto yy89;
		case 'n': goto yy80;
		case 'r': goto yy81;
		case 's': goto yy82;
		case 't': goto yy83;
		default: goto yy3;
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t': goto yy84;
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy58;
		case '.': goto yy87;
		case '/': goto yy60;
		case '0':
		case '1':
		case '2':
		case '3': goto yy88;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy92;
		case ':': goto yy89;
		case 'n': goto yy80;
		case 'r': goto yy81;
		case 's': goto yy82;
		case 't': goto yy83;
		default: goto yy3;
	}
yy12:
	YYDEBUG(12, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t': goto yy84;
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy58;
		case '.': goto yy87;
		case '/': goto yy60;
		case '0':
		case '1': goto yy92;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy93;
		case ':': goto yy89;
		case 'n': goto yy80;
		case 'r': goto yy81;
		case 's': goto yy82;
		case 't': goto yy83;
		default: goto yy3;
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t': goto yy84;
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'S':
		case 'T':
		case 'V':
		case 'W':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'o':
		case 'p':
		case 'w':
		case 'y': goto yy86;
		case '-': goto yy58;
		case '.': goto yy87;
		case '/': goto yy60;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy93;
		case ':': goto yy89;
		case 'n': goto yy80;
		case 'r': goto yy81;
		case 's': goto yy82;
		case 't': goto yy83;
		default: goto yy3;
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy94;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy95;
	goto yy3;
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy97;
			if (yych >= 'A') goto yy98;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy99;
				goto yy98;
			} else {
				if (yych <= 'P') goto yy100;
				if (yych <= 'T') goto yy98;
				goto yy101;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
			} else {
				if (yych == 'g') goto yy103;
				goto yy102;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy104;
				goto yy102;
			} else {
				if (yych <= 'u') goto yy105;
				if (yych <= 'z') goto yy102;
			}
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
#line 1370 "real_world/parse_date_db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1261 "real_world/parse_date_db.c"
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy98;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy102;
		goto yy16;
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy106;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy102;
		} else {
			if (yych <= 'e') goto yy107;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'I') goto yy108;
			if (yych <= 'K') goto yy98;
			goto yy109;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy102;
			goto yy110;
		} else {
			if (yych == 'l') goto yy111;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'D') goto yy98;
				goto yy112;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy113;
				goto yy98;
			} else {
				if (yych <= 'O') goto yy114;
				if (yych <= 'Q') goto yy98;
				goto yy115;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy98;
				if (yych <= '`') goto yy16;
				goto yy102;
			} else {
				if (yych <= 'e') goto yy116;
				if (yych <= 'h') goto yy102;
				goto yy117;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy118;
				goto yy102;
			} else {
				if (yych <= 'r') goto yy119;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych == '/') goto yy16;
				goto yy121;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy16;
				goto yy98;
			} else {
				if (yych <= 'I') goto yy126;
				if (yych <= 'U') goto yy98;
				goto yy127;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy127;
				goto yy98;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= 'A') goto yy128;
			if (yych <= 'T') goto yy98;
			goto yy129;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy130;
		} else {
			if (yych == 'u') goto yy131;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy132;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy98;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy133;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy134;
		} else {
			if (yych == 'I') goto yy135;
			if (yych <= 'N') goto yy98;
			goto yy136;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy137;
			goto yy102;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy138;
				goto yy102;
			} else {
				if (yych <= 'o') goto yy139;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy140;
				goto yy98;
			} else {
				if (yych <= 'I') goto yy141;
				if (yych <= 'N') goto yy98;
				goto yy142;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
				goto yy16;
			} else {
				if (yych == 'e') goto yy143;
				goto yy102;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy144;
				goto yy102;
			} else {
				if (yych <= 'o') goto yy145;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy98;
			goto yy146;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy102;
		} else {
			if (yych <= 'c') goto yy147;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy98;
			goto yy148;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy102;
		} else {
			if (yych <= 'r') goto yy149;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'A') goto yy150;
				goto yy98;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy151;
				goto yy98;
			} else {
				if (yych <= 'I') goto yy152;
				if (yych <= 'T') goto yy98;
				goto yy136;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
				goto yy16;
			} else {
				if (yych <= 'a') goto yy153;
				if (yych <= 'd') goto yy102;
				goto yy154;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy155;
				goto yy102;
			} else {
				if (yych <= 'u') goto yy139;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '0':
		case '1': goto yy156;
		case '2': goto yy157;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy158;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z': goto yy98;
		case 'E': goto yy141;
		case 'H': goto yy159;
		case 'O': goto yy160;
		case 'U': goto yy161;
		case 'W': goto yy162;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy102;
		case 'e': goto yy144;
		case 'h': goto yy163;
		case 'o': goto yy164;
		case 'u': goto yy165;
		case 'w': goto yy166;
		default: goto yy16;
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy121;
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych == ')') goto yy97;
			if (yych <= ',') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy167;
				goto yy98;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy102;
		} else {
			if (yych <= 'e') goto yy169;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy121;
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych == ')') goto yy97;
			if (yych <= ',') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy126;
				goto yy98;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy102;
				goto yy16;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy170;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy102;
		} else {
			if (yych <= 'e') goto yy171;
			if (yych <= 'z') goto yy102;
			goto yy16;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy99;
				goto yy98;
			} else {
				if (yych <= 'P') goto yy100;
				if (yych <= 'T') goto yy98;
				goto yy101;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
				goto yy16;
			} else {
				if (yych == 'g') goto yy99;
				goto yy98;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy100;
				goto yy98;
			} else {
				if (yych <= 'u') goto yy101;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy98;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy98;
		goto yy16;
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy106;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'e') goto yy106;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'I') goto yy108;
			if (yych <= 'K') goto yy98;
			goto yy109;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy98;
			goto yy108;
		} else {
			if (yych == 'l') goto yy109;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'D') goto yy98;
				goto yy112;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy113;
				goto yy98;
			} else {
				if (yych <= 'O') goto yy114;
				if (yych <= 'Q') goto yy98;
				goto yy115;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy98;
				if (yych <= '`') goto yy16;
				goto yy98;
			} else {
				if (yych <= 'e') goto yy112;
				if (yych <= 'h') goto yy98;
				goto yy113;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy114;
				goto yy98;
			} else {
				if (yych <= 'r') goto yy115;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= 'A') goto yy128;
			if (yych <= 'T') goto yy98;
			goto yy129;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy128;
		} else {
			if (yych == 'u') goto yy129;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy132;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy98;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy132;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy134;
		} else {
			if (yych == 'I') goto yy135;
			if (yych <= 'N') goto yy98;
			goto yy136;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy134;
			goto yy98;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy135;
				goto yy98;
			} else {
				if (yych <= 'o') goto yy136;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy140;
				goto yy98;
			} else {
				if (yych <= 'I') goto yy141;
				if (yych <= 'N') goto yy98;
				goto yy142;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
				goto yy16;
			} else {
				if (yych == 'e') goto yy140;
				goto yy98;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy141;
				goto yy98;
			} else {
				if (yych <= 'o') goto yy142;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy98;
			goto yy146;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'c') goto yy146;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy98;
			goto yy148;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'r') goto yy148;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'A') goto yy150;
				goto yy98;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy151;
				goto yy98;
			} else {
				if (yych <= 'I') goto yy152;
				if (yych <= 'T') goto yy98;
				goto yy136;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy98;
				goto yy16;
			} else {
				if (yych <= 'a') goto yy150;
				if (yych <= 'd') goto yy98;
				goto yy151;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy152;
				goto yy98;
			} else {
				if (yych <= 'u') goto yy136;
				if (yych <= 'z') goto yy98;
				goto yy16;
			}
		}
	}
yy46:
	YYDEBUG(46, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy97;
		case '0':
		case '1': goto yy156;
		case '2': goto yy157;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy158;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy98;
		case 'E':
		case 'e': goto yy141;
		case 'H':
		case 'h': goto yy159;
		case 'O':
		case 'o': goto yy160;
		case 'U':
		case 'u': goto yy161;
		case 'W':
		case 'w': goto yy162;
		default: goto yy16;
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy168;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'e') goto yy168;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy98;
			goto yy170;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy98;
			if (yych <= '`') goto yy16;
			goto yy98;
		} else {
			if (yych <= 'e') goto yy170;
			if (yych <= 'z') goto yy98;
			goto yy16;
		}
	}
yy49:
	YYDEBUG(49, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 8) {
		goto yy49;
	}
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy51;
yy50:
	YYDEBUG(50, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 13) {
		if (yyaccept <= 6) {
			if (yyaccept <= 3) {
				if (yyaccept <= 1) {
					if (yyaccept == 0) {
						goto yy5;
					} else {
						goto yy3;
					}
				} else {
					if (yyaccept == 2) {
						goto yy16;
					} else {
						goto yy69;
					}
				}
			} else {
				if (yyaccept <= 5) {
					if (yyaccept == 4) {
						goto yy123;
					} else {
						goto yy194;
					}
				} else {
					goto yy199;
				}
			}
		} else {
			if (yyaccept <= 10) {
				if (yyaccept <= 8) {
					if (yyaccept == 7) {
						goto yy256;
					} else {
						goto yy275;
					}
				} else {
					if (yyaccept == 9) {
						goto yy305;
					} else {
						goto yy360;
					}
				}
			} else {
				if (yyaccept <= 12) {
					if (yyaccept == 11) {
						goto yy362;
					} else {
						goto yy366;
					}
				} else {
					goto yy450;
				}
			}
		}
	} else {
		if (yyaccept <= 20) {
			if (yyaccept <= 17) {
				if (yyaccept <= 15) {
					if (yyaccept == 14) {
						goto yy484;
					} else {
						goto yy589;
					}
				} else {
					if (yyaccept == 16) {
						goto yy592;
					} else {
						goto yy631;
					}
				}
			} else {
				if (yyaccept <= 19) {
					if (yyaccept == 18) {
						goto yy674;
					} else {
						goto yy835;
					}
				} else {
					goto yy513;
				}
			}
		} else {
			if (yyaccept <= 23) {
				if (yyaccept <= 22) {
					if (yyaccept == 21) {
						goto yy906;
					} else {
						goto yy968;
					}
				} else {
					goto yy973;
				}
			} else {
				if (yyaccept <= 25) {
					if (yyaccept == 24) {
						goto yy1014;
					} else {
						goto yy1059;
					}
				} else {
					goto yy1131;
				}
			}
		}
	}
yy51:
	YYDEBUG(51, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 16) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy172;
				if (yych <= 0x1F) goto yy50;
				goto yy172;
			} else {
				if (yych == 'D') goto yy174;
				if (yych <= 'E') goto yy50;
				goto yy175;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy67;
				if (yych <= 'L') goto yy50;
				goto yy176;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy50;
					goto yy177;
				} else {
					if (yych <= 'T') goto yy75;
					if (yych <= 'V') goto yy50;
					goto yy77;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy79;
				if (yych <= 'c') goto yy50;
				goto yy174;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy50;
					goto yy175;
				} else {
					if (yych == 'h') goto yy67;
					goto yy50;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy176;
				if (yych <= 'r') goto yy50;
				if (yych <= 's') goto yy177;
				goto yy75;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy50;
					goto yy77;
				} else {
					if (yych == 'y') goto yy79;
					goto yy50;
				}
			}
		}
	}
yy52:
	YYDEBUG(52, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy16;
				goto yy173;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy16;
					goto yy54;
				} else {
					if (yych <= ':') goto yy178;
					if (yych <= 'C') goto yy16;
					goto yy173;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy173;
				if (yych <= 'G') goto yy16;
				goto yy173;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy16;
					goto yy173;
				} else {
					if (yych <= 'R') goto yy16;
					if (yych <= 'T') goto yy173;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy16;
				if (yych <= 'Y') goto yy173;
				goto yy16;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy173;
					goto yy16;
				} else {
					if (yych == 'g') goto yy16;
					goto yy173;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych <= 'r') goto yy16;
				goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy16;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy16;
				}
			}
		}
	}
yy53:
	YYDEBUG(53, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ':') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy16;
				goto yy173;
			} else {
				if (yych <= '3') {
					if (yych <= '/') goto yy16;
				} else {
					if (yych <= '5') goto yy179;
					if (yych <= '9') goto yy180;
					goto yy178;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy16;
					goto yy173;
				} else {
					if (yych == 'F') goto yy173;
					goto yy16;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy173;
					goto yy16;
				} else {
					if (yych <= 'M') goto yy173;
					if (yych <= 'R') goto yy16;
					goto yy173;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy173;
				if (yych <= 'X') goto yy16;
				goto yy173;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy16;
					goto yy173;
				} else {
					if (yych == 'f') goto yy173;
					goto yy16;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy173;
					goto yy16;
				} else {
					if (yych <= 'm') goto yy173;
					if (yych <= 'r') goto yy16;
					goto yy173;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy16;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy16;
				}
			}
		}
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy16;
				goto yy173;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy16;
					goto yy179;
				} else {
					if (yych <= '9') goto yy180;
					if (yych <= ':') goto yy178;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych == 'E') goto yy16;
				if (yych <= 'F') goto yy173;
				goto yy16;
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy173;
					goto yy16;
				} else {
					if (yych <= 'M') goto yy173;
					if (yych <= 'R') goto yy16;
					goto yy173;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy173;
				if (yych <= 'X') goto yy16;
				goto yy173;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy16;
					goto yy173;
				} else {
					if (yych == 'f') goto yy173;
					goto yy16;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy173;
					goto yy16;
				} else {
					if (yych <= 'm') goto yy173;
					if (yych <= 'r') goto yy16;
					goto yy173;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy16;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy16;
				}
			}
		}
	}
yy55:
	YYDEBUG(55, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy57;
	if (yych <= '0') goto yy183;
	if (yych <= '1') goto yy184;
	if (yych <= '9') goto yy185;
	goto yy57;
yy56:
	YYDEBUG(56, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy57:
	YYDEBUG(57, *YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ': goto yy56;
		case '-':
		case '.': goto yy181;
		case 'A':
		case 'a': goto yy64;
		case 'D':
		case 'd': goto yy65;
		case 'F':
		case 'f': goto yy66;
		case 'H':
		case 'h': goto yy67;
		case 'I': goto yy68;
		case 'J':
		case 'j': goto yy70;
		case 'M':
		case 'm': goto yy71;
		case 'N':
		case 'n': goto yy72;
		case 'O':
		case 'o': goto yy73;
		case 'S':
		case 's': goto yy74;
		case 'T':
		case 't': goto yy75;
		case 'V': goto yy76;
		case 'W':
		case 'w': goto yy77;
		case 'X': goto yy78;
		case 'Y':
		case 'y': goto yy79;
		default: goto yy50;
	}
yy58:
	YYDEBUG(58, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '0') goto yy186;
	if (yych <= '1') goto yy187;
	if (yych <= '9') goto yy188;
	goto yy182;
yy59:
	YYDEBUG(59, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy182;
		if (yych <= '0') goto yy193;
		goto yy195;
	} else {
		if (yych <= '5') goto yy196;
		if (yych <= '9') goto yy197;
		goto yy182;
	}
yy60:
	YYDEBUG(60, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy198;
		case '3': goto yy200;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy201;
		case 'A':
		case 'a': goto yy202;
		case 'D':
		case 'd': goto yy203;
		case 'F':
		case 'f': goto yy204;
		case 'J':
		case 'j': goto yy205;
		case 'M':
		case 'm': goto yy206;
		case 'N':
		case 'n': goto yy207;
		case 'O':
		case 'o': goto yy208;
		case 'S':
		case 's': goto yy209;
		default: goto yy50;
	}
yy61:
	YYDEBUG(61, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy55;
			if (yych <= ',') goto yy57;
			goto yy58;
		} else {
			if (yych <= '.') goto yy59;
			if (yych <= '/') goto yy60;
			if (yych <= '5') goto yy210;
			goto yy211;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy63;
			if (yych == 'n') goto yy80;
			goto yy57;
		} else {
			if (yych <= 'r') goto yy81;
			if (yych <= 's') goto yy82;
			if (yych <= 't') goto yy83;
			goto yy57;
		}
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy84;
			if (yych <= ',') goto yy86;
			goto yy58;
		} else {
			if (yych <= '.') goto yy87;
			if (yych <= '/') goto yy60;
			if (yych <= '5') goto yy210;
			goto yy211;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy89;
			if (yych == 'n') goto yy80;
			goto yy86;
		} else {
			if (yych <= 'r') goto yy81;
			if (yych <= 's') goto yy82;
			if (yych <= 't') goto yy83;
			goto yy86;
		}
	}
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy212;
	if (yych <= '9') goto yy213;
	goto yy50;
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy214;
		if (yych <= 'T') goto yy50;
		goto yy215;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy50;
			goto yy214;
		} else {
			if (yych == 'u') goto yy215;
			goto yy50;
		}
	}
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy216;
		if (yych <= 'D') goto yy50;
		goto yy217;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy216;
		} else {
			if (yych == 'e') goto yy217;
			goto yy50;
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy218;
			goto yy50;
		} else {
			if (yych <= 'O') goto yy219;
			if (yych <= 'Q') goto yy50;
			goto yy220;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy218;
			goto yy50;
		} else {
			if (yych <= 'o') goto yy219;
			if (yych == 'r') goto yy220;
			goto yy50;
		}
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy221;
	if (yych == 'o') goto yy221;
	goto yy50;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			if (yych <= '.') goto yy222;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy223;
			if (yych == 'I') goto yy225;
		} else {
			if (yych == 'W') goto yy69;
			if (yych <= 'X') goto yy226;
		}
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
#line 1165 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 2894 "real_world/parse_date_db.c"
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy227;
		if (yych <= 'T') goto yy50;
		goto yy228;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy227;
		} else {
			if (yych == 'u') goto yy228;
			goto yy50;
		}
	}
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy229;
			goto yy50;
		} else {
			if (yych <= 'I') goto yy230;
			if (yych <= 'N') goto yy50;
			goto yy231;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy229;
			goto yy50;
		} else {
			if (yych <= 'i') goto yy230;
			if (yych == 'o') goto yy231;
			goto yy50;
		}
	}
yy72:
	YYDEBUG(72, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy232;
	if (yych == 'o') goto yy232;
	goto yy50;
yy73:
	YYDEBUG(73, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy233;
	if (yych == 'c') goto yy233;
	goto yy50;
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy234;
			goto yy50;
		} else {
			if (yych <= 'E') goto yy235;
			if (yych <= 'T') goto yy50;
			goto yy236;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy234;
			goto yy50;
		} else {
			if (yych <= 'e') goto yy235;
			if (yych == 'u') goto yy236;
			goto yy50;
		}
	}
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy237;
		if (yych <= 'T') goto yy50;
		goto yy238;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy50;
			goto yy237;
		} else {
			if (yych == 'u') goto yy238;
			goto yy50;
		}
	}
yy76:
	YYDEBUG(76, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy69;
			goto yy222;
		} else {
			if (yych == ' ') goto yy222;
			goto yy69;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy222;
			if (yych <= '/') goto yy69;
			goto yy223;
		} else {
			if (yych == 'I') goto yy78;
			goto yy69;
		}
	}
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy239;
	if (yych == 'e') goto yy239;
	goto yy50;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy69;
			goto yy222;
		} else {
			if (yych == ' ') goto yy222;
			goto yy69;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy222;
			if (yych <= '/') goto yy69;
			goto yy223;
		} else {
			if (yych == 'I') goto yy225;
			goto yy69;
		}
	}
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy240;
	if (yych == 'e') goto yy240;
	goto yy50;
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy232;
		goto yy50;
	} else {
		if (yych <= 'd') goto yy241;
		if (yych == 'o') goto yy232;
		goto yy50;
	}
yy81:
	YYDEBUG(81, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy241;
	goto yy50;
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy234;
			goto yy50;
		} else {
			if (yych <= 'E') goto yy235;
			if (yych == 'U') goto yy236;
			goto yy50;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy234;
			if (yych <= 'd') goto yy50;
			goto yy235;
		} else {
			if (yych <= 's') goto yy50;
			if (yych <= 't') goto yy241;
			if (yych <= 'u') goto yy236;
			goto yy50;
		}
	}
yy83:
	YYDEBUG(83, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy237;
		if (yych <= 'T') goto yy50;
		goto yy238;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy50;
			goto yy242;
		} else {
			if (yych == 'u') goto yy238;
			goto yy50;
		}
	}
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy86;
	if (yych <= '0') goto yy183;
	if (yych <= '1') goto yy184;
	if (yych <= '9') goto yy185;
	goto yy86;
yy85:
	YYDEBUG(85, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy86:
	YYDEBUG(86, *YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ': goto yy85;
		case '-':
		case '.': goto yy181;
		case 'A':
		case 'a': goto yy90;
		case 'D':
		case 'd': goto yy65;
		case 'F':
		case 'f': goto yy66;
		case 'H':
		case 'h': goto yy67;
		case 'I': goto yy68;
		case 'J':
		case 'j': goto yy70;
		case 'M':
		case 'm': goto yy71;
		case 'N':
		case 'n': goto yy72;
		case 'O':
		case 'o': goto yy73;
		case 'P':
		case 'p': goto yy91;
		case 'S':
		case 's': goto yy74;
		case 'T':
		case 't': goto yy75;
		case 'V': goto yy76;
		case 'W':
		case 'w': goto yy77;
		case 'X': goto yy78;
		case 'Y':
		case 'y': goto yy79;
		default: goto yy50;
	}
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy182;
		if (yych <= '0') goto yy243;
		goto yy244;
	} else {
		if (yych <= '5') goto yy245;
		if (yych <= '9') goto yy246;
		goto yy182;
	}
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy55;
			if (yych <= ',') goto yy57;
			goto yy58;
		} else {
			if (yych <= '.') goto yy59;
			if (yych <= '/') goto yy247;
			if (yych <= '5') goto yy210;
			goto yy211;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy63;
			if (yych == 'n') goto yy80;
			goto yy57;
		} else {
			if (yych <= 'r') goto yy81;
			if (yych <= 's') goto yy82;
			if (yych <= 't') goto yy83;
			goto yy57;
		}
	}
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy248;
	if (yych <= '9') goto yy249;
	goto yy50;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy250;
			goto yy50;
		} else {
			if (yych <= 'M') goto yy251;
			if (yych == 'P') goto yy214;
			goto yy50;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy215;
			if (yych == 'm') goto yy251;
			goto yy50;
		} else {
			if (yych <= 'p') goto yy214;
			if (yych == 'u') goto yy215;
			goto yy50;
		}
	}
yy91:
	YYDEBUG(91, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy250;
		goto yy50;
	} else {
		if (yych <= 'M') goto yy251;
		if (yych == 'm') goto yy251;
		goto yy50;
	}
yy92:
	YYDEBUG(92, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy55;
			goto yy57;
		} else {
			if (yych <= '-') goto yy58;
			if (yych <= '.') goto yy252;
			if (yych <= '/') goto yy247;
			goto yy211;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy80;
			goto yy57;
		} else {
			if (yych <= 'r') goto yy81;
			if (yych <= 's') goto yy82;
			if (yych <= 't') goto yy83;
			goto yy57;
		}
	}
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy253;
	if (yych <= '/') goto yy173;
	if (yych <= '9') goto yy211;
	goto yy173;
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych >= ':') goto yy50;
yy95:
	YYDEBUG(95, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy96;
	if (yych <= '9') goto yy95;
yy96:
	YYDEBUG(96, *YYCURSOR);
#line 926 "real_world/parse_date_db.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->f = 0.0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3293 "real_world/parse_date_db.c"
yy97:
	YYDEBUG(97, *YYCURSOR);
	++YYCURSOR;
	goto yy16;
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy254;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy254;
		goto yy16;
	}
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy254;
			goto yy255;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'o') goto yy255;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy254;
			goto yy257;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'r') goto yy257;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy101:
	YYDEBUG(101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy254;
			goto yy258;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'g') goto yy258;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy102:
	YYDEBUG(102, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych == '/') goto yy259;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy103:
	YYDEBUG(103, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy254;
			goto yy255;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'o') goto yy261;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy104:
	YYDEBUG(104, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy254;
			goto yy257;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'r') goto yy262;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy105:
	YYDEBUG(105, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy254;
			goto yy258;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'g') goto yy263;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy254;
			goto yy264;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'c') goto yy264;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy107:
	YYDEBUG(107, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy254;
			goto yy264;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'c') goto yy265;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy108:
	YYDEBUG(108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy254;
			goto yy266;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'g') goto yy266;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy109:
	YYDEBUG(109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy254;
			goto yy267;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'e') goto yy267;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy110:
	YYDEBUG(110, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy254;
			goto yy266;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'g') goto yy268;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy111:
	YYDEBUG(111, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy254;
			goto yy267;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy269;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy254;
			goto yy270;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'b') goto yy270;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy113:
	YYDEBUG(113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'F') goto yy271;
			if (yych <= 'Q') goto yy254;
			goto yy272;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			if (yych <= 'e') goto yy254;
			goto yy271;
		} else {
			if (yych == 'r') goto yy272;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'T') goto yy254;
			goto yy273;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'u') goto yy273;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy115:
	YYDEBUG(115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy254;
			goto yy274;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'i') goto yy274;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy116:
	YYDEBUG(116, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy254;
			goto yy270;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'b') goto yy276;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy117:
	YYDEBUG(117, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych <= 'E') {
				if (yych <= '@') goto yy16;
				goto yy254;
			} else {
				if (yych <= 'F') goto yy271;
				if (yych <= 'Q') goto yy254;
				goto yy272;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy16;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy260;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'f') goto yy277;
				goto yy260;
			} else {
				if (yych <= 'r') goto yy278;
				if (yych <= 'z') goto yy260;
				goto yy16;
			}
		}
	}
yy118:
	YYDEBUG(118, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'T') goto yy254;
			goto yy273;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'u') goto yy279;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy254;
			goto yy274;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'i') goto yy280;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy120:
	YYDEBUG(120, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 20) YYFILL(20);
	yych = *YYCURSOR;
yy121:
	YYDEBUG(121, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy120;
	}
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy122;
	if (yych <= '3') goto yy124;
	if (yych <= '9') goto yy125;
	goto yy50;
yy122:
	YYDEBUG(122, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy282;
	if (yych <= '9') goto yy283;
	goto yy282;
yy123:
	YYDEBUG(123, *YYCURSOR);
#line 1152 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3865 "real_world/parse_date_db.c"
yy124:
	YYDEBUG(124, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy282;
	if (yych <= '1') goto yy283;
	if (yych <= '2') goto yy285;
	if (yych <= '9') goto yy286;
	goto yy282;
yy125:
	YYDEBUG(125, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy282;
	if (yych <= '1') goto yy287;
	if (yych <= '2') goto yy285;
	if (yych <= '9') goto yy286;
	goto yy282;
yy126:
	YYDEBUG(126, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy121;
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych == ')') goto yy97;
			if (yych <= ',') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy288;
				goto yy254;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy127:
	YYDEBUG(127, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy121;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy121;
			if (yych == ')') goto yy97;
			goto yy16;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy121;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy254;
			goto yy289;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'n') goto yy289;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy129:
	YYDEBUG(129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'L') goto yy290;
			if (yych <= 'M') goto yy254;
			goto yy291;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			if (yych <= 'k') goto yy254;
			goto yy290;
		} else {
			if (yych == 'n') goto yy291;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy130:
	YYDEBUG(130, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy254;
			goto yy289;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy292;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy131:
	YYDEBUG(131, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych <= 'K') {
				if (yych <= '@') goto yy16;
				goto yy254;
			} else {
				if (yych <= 'L') goto yy290;
				if (yych <= 'M') goto yy254;
				goto yy291;
			}
		}
	} else {
		if (yych <= 'k') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy16;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy260;
			}
		} else {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy293;
				goto yy260;
			} else {
				if (yych <= 'n') goto yy294;
				if (yych <= 'z') goto yy260;
				goto yy16;
			}
		}
	}
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy254;
			goto yy295;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 's') goto yy295;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy133:
	YYDEBUG(133, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy254;
			goto yy295;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 's') goto yy296;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy134:
	YYDEBUG(134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'R') goto yy297;
			if (yych <= 'X') goto yy254;
			goto yy298;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			if (yych <= 'q') goto yy254;
			goto yy297;
		} else {
			if (yych == 'y') goto yy298;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy135:
	YYDEBUG(135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy254;
			goto yy299;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'd') goto yy299;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy254;
			goto yy274;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'n') goto yy274;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy137:
	YYDEBUG(137, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy16;
				goto yy254;
			} else {
				if (yych <= 'R') goto yy297;
				if (yych <= 'X') goto yy254;
				goto yy298;
			}
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy16;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy260;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= 'r') goto yy300;
				goto yy260;
			} else {
				if (yych <= 'y') goto yy301;
				if (yych <= 'z') goto yy260;
				goto yy16;
			}
		}
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy254;
			goto yy299;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'd') goto yy302;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy254;
			goto yy274;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy280;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy254;
			goto yy295;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'x') goto yy295;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy254;
			goto yy271;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'n') goto yy271;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'O') goto yy303;
			if (yych <= 'U') goto yy254;
			if (yych <= 'V') goto yy264;
			goto yy304;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			if (yych <= 'n') goto yy254;
			goto yy303;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy254;
				goto yy264;
			} else {
				if (yych <= 'w') goto yy304;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy254;
			goto yy295;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'x') goto yy296;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy254;
			goto yy271;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy277;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych == '/') goto yy259;
				goto yy16;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy254;
				goto yy303;
			} else {
				if (yych <= 'U') goto yy254;
				if (yych <= 'V') goto yy264;
				goto yy304;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy16;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy260;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy306;
				if (yych <= 'u') goto yy260;
				goto yy265;
			} else {
				if (yych <= 'w') goto yy307;
				if (yych <= 'z') goto yy260;
				goto yy16;
			}
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy254;
			goto yy308;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 't') goto yy308;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy254;
			goto yy308;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy309;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy254;
			goto yy310;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'e') goto yy310;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy254;
			goto yy310;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy311;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy254;
			goto yy312;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 't') goto yy312;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy313;
				goto yy254;
			} else {
				if (yych <= 'P') goto yy314;
				if (yych <= 'U') goto yy254;
				goto yy315;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy254;
				goto yy16;
			} else {
				if (yych == 'c') goto yy313;
				goto yy254;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy314;
				goto yy254;
			} else {
				if (yych <= 'v') goto yy315;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy254;
			goto yy271;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'x') goto yy271;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy254;
			goto yy312;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy316;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych == '/') goto yy259;
				goto yy16;
			}
		} else {
			if (yych <= 'O') {
				if (yych == 'C') goto yy313;
				goto yy254;
			} else {
				if (yych <= 'P') goto yy314;
				if (yych <= 'U') goto yy254;
				goto yy315;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy254;
				if (yych <= '^') goto yy16;
				goto yy259;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'b') goto yy260;
				goto yy317;
			}
		} else {
			if (yych <= 'u') {
				if (yych == 'p') goto yy318;
				goto yy260;
			} else {
				if (yych <= 'v') goto yy319;
				if (yych <= 'z') goto yy260;
				goto yy16;
			}
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy254;
			goto yy271;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'x') goto yy277;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy63;
		goto yy50;
	} else {
		if (yych <= '9') goto yy320;
		if (yych <= ':') goto yy63;
		goto yy50;
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy63;
		goto yy50;
	} else {
		if (yych <= '3') goto yy320;
		if (yych == ':') goto yy63;
		goto yy50;
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy63;
	if (yych == ':') goto yy63;
	goto yy50;
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'I') goto yy321;
			if (yych <= 'T') goto yy254;
			goto yy322;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy254;
			goto yy321;
		} else {
			if (yych == 'u') goto yy322;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'D') goto yy323;
			if (yych <= 'L') goto yy254;
			goto yy324;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			if (yych <= 'c') goto yy254;
			goto yy323;
		} else {
			if (yych == 'm') goto yy324;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy254;
			goto yy325;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'e') goto yy325;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy254;
			goto yy326;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'e') goto yy326;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych <= 'H') {
				if (yych <= '@') goto yy16;
				goto yy254;
			} else {
				if (yych <= 'I') goto yy321;
				if (yych <= 'T') goto yy254;
				goto yy322;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy16;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy260;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'i') goto yy327;
				goto yy260;
			} else {
				if (yych <= 'u') goto yy328;
				if (yych <= 'z') goto yy260;
				goto yy16;
			}
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy16;
				goto yy254;
			} else {
				if (yych <= 'D') goto yy323;
				if (yych <= 'L') goto yy254;
				goto yy324;
			}
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy254;
				goto yy16;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy260;
			}
		} else {
			if (yych <= 'l') {
				if (yych <= 'd') goto yy329;
				goto yy260;
			} else {
				if (yych <= 'm') goto yy330;
				if (yych <= 'z') goto yy260;
				goto yy16;
			}
		}
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy254;
			goto yy325;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy331;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy254;
			goto yy326;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy332;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy167:
	YYDEBUG(167, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy121;
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych == ')') goto yy97;
			if (yych <= ',') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy333;
				goto yy254;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy254;
				goto yy16;
			}
		}
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy254;
			goto yy334;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 'd') goto yy334;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy254;
			goto yy334;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'd') goto yy335;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy254;
			goto yy336;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy254;
			if (yych <= '`') goto yy16;
			goto yy254;
		} else {
			if (yych <= 's') goto yy336;
			if (yych <= 'z') goto yy254;
			goto yy16;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy254;
			goto yy336;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy254;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 's') goto yy337;
			if (yych <= 'z') goto yy260;
			goto yy16;
		}
	}
yy172:
	YYDEBUG(172, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy173:
	YYDEBUG(173, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy172;
				if (yych <= 0x1F) goto yy50;
				goto yy172;
			} else {
				if (yych == 'D') goto yy174;
				if (yych <= 'E') goto yy50;
				goto yy175;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy67;
				if (yych <= 'L') goto yy50;
				goto yy176;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy50;
					goto yy177;
				} else {
					if (yych <= 'T') goto yy75;
					if (yych <= 'V') goto yy50;
					goto yy77;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy79;
				if (yych <= 'c') goto yy50;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy50;
					goto yy175;
				} else {
					if (yych == 'h') goto yy67;
					goto yy50;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy176;
				if (yych <= 'r') goto yy50;
				if (yych <= 's') goto yy177;
				goto yy75;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy50;
					goto yy77;
				} else {
					if (yych == 'y') goto yy79;
					goto yy50;
				}
			}
		}
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy216;
	if (yych == 'a') goto yy216;
	goto yy50;
yy175:
	YYDEBUG(175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy219;
		if (yych <= 'Q') goto yy50;
		goto yy220;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy50;
			goto yy219;
		} else {
			if (yych == 'r') goto yy220;
			goto yy50;
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy230;
		if (yych <= 'N') goto yy50;
		goto yy231;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy50;
			goto yy230;
		} else {
			if (yych == 'o') goto yy231;
			goto yy50;
		}
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy234;
			goto yy50;
		} else {
			if (yych <= 'E') goto yy338;
			if (yych <= 'T') goto yy50;
			goto yy236;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy234;
			goto yy50;
		} else {
			if (yych <= 'e') goto yy338;
			if (yych == 'u') goto yy236;
			goto yy50;
		}
	}
yy178:
	YYDEBUG(178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '5') goto yy339;
	if (yych <= '9') goto yy97;
	goto yy16;
yy179:
	YYDEBUG(179, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy16;
				goto yy173;
			} else {
				if (yych <= '/') goto yy16;
				if (yych <= '9') goto yy180;
				if (yych <= 'C') goto yy16;
				goto yy173;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy173;
				if (yych <= 'G') goto yy16;
				goto yy173;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy16;
					goto yy173;
				} else {
					if (yych <= 'R') goto yy16;
					if (yych <= 'T') goto yy173;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy16;
				if (yych <= 'Y') goto yy173;
				goto yy16;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy173;
					goto yy16;
				} else {
					if (yych == 'g') goto yy16;
					goto yy173;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych <= 'r') goto yy16;
				goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy16;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy16;
				}
			}
		}
	}
yy180:
	YYDEBUG(180, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy16;
				goto yy173;
			} else {
				if (yych == 'D') goto yy173;
				if (yych <= 'E') goto yy16;
				goto yy173;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy173;
				if (yych <= 'L') goto yy16;
				goto yy173;
			} else {
				if (yych <= 'R') goto yy16;
				if (yych <= 'T') goto yy173;
				if (yych <= 'V') goto yy16;
				goto yy173;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy173;
				if (yych <= 'c') goto yy16;
				goto yy173;
			} else {
				if (yych == 'f') goto yy173;
				if (yych <= 'g') goto yy16;
				goto yy173;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych <= 'r') goto yy16;
				goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy16;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy16;
				}
			}
		}
	}
yy181:
	YYDEBUG(181, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy182:
	YYDEBUG(182, *YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ':
		case '-':
		case '.': goto yy181;
		case 'A':
		case 'a': goto yy64;
		case 'D':
		case 'd': goto yy189;
		case 'F':
		case 'f': goto yy190;
		case 'I': goto yy68;
		case 'J':
		case 'j': goto yy70;
		case 'M':
		case 'm': goto yy191;
		case 'N':
		case 'n': goto yy72;
		case 'O':
		case 'o': goto yy73;
		case 'S':
		case 's': goto yy192;
		case 'V': goto yy76;
		case 'X': goto yy78;
		default: goto yy50;
	}
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy50;
	if (yych <= '.') goto yy340;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy185;
	goto yy50;
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy50;
	if (yych <= '.') goto yy340;
	if (yych <= '/') goto yy50;
	if (yych >= '3') goto yy50;
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy50;
	if (yych <= '.') goto yy340;
	goto yy50;
yy186:
	YYDEBUG(186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy50;
		if (yych <= '-') goto yy341;
		goto yy340;
	} else {
		if (yych <= '/') goto yy50;
		if (yych <= '9') goto yy188;
		goto yy50;
	}
yy187:
	YYDEBUG(187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy50;
		if (yych <= '-') goto yy341;
		goto yy340;
	} else {
		if (yych <= '/') goto yy50;
		if (yych >= '3') goto yy50;
	}
yy188:
	YYDEBUG(188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy50;
	if (yych <= '-') goto yy341;
	if (yych <= '.') goto yy340;
	goto yy50;
yy189:
	YYDEBUG(189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy217;
	if (yych == 'e') goto yy217;
	goto yy50;
yy190:
	YYDEBUG(190, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy218;
	if (yych == 'e') goto yy218;
	goto yy50;
yy191:
	YYDEBUG(191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy229;
	if (yych == 'a') goto yy229;
	goto yy50;
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy342;
	if (yych == 'e') goto yy342;
	goto yy50;
yy193:
	YYDEBUG(193, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy194;
		if (yych <= '-') goto yy340;
		goto yy343;
	} else {
		if (yych <= '/') goto yy194;
		if (yych <= '9') goto yy197;
		if (yych <= ':') goto yy344;
	}
yy194:
	YYDEBUG(194, *YYCURSOR);
#line 967 "real_world/parse_date_db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 5486 "real_world/parse_date_db.c"
yy195:
	YYDEBUG(195, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy194;
		if (yych <= '-') goto yy340;
		if (yych <= '.') goto yy343;
		goto yy194;
	} else {
		if (yych <= '2') goto yy197;
		if (yych <= '9') goto yy213;
		if (yych <= ':') goto yy344;
		goto yy194;
	}
yy196:
	YYDEBUG(196, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy194;
		if (yych <= '-') goto yy340;
		goto yy343;
	} else {
		if (yych <= '/') goto yy194;
		if (yych <= '9') goto yy213;
		if (yych <= ':') goto yy344;
		goto yy194;
	}
yy197:
	YYDEBUG(197, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy194;
		if (yych <= '-') goto yy340;
		goto yy343;
	} else {
		if (yych == ':') goto yy344;
		goto yy194;
	}
yy198:
	YYDEBUG(198, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy345;
		} else {
			if (yych <= '9') goto yy201;
			if (yych >= 'n') goto yy346;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy346;
		} else {
			if (yych <= 's') goto yy347;
			if (yych <= 't') goto yy348;
		}
	}
yy199:
	YYDEBUG(199, *YYCURSOR);
#line 1059 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr((char **) &ptr, 4);
			TIMELIB_PROCESS_YEAR(s->time->y);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 5563 "real_world/parse_date_db.c"
yy200:
	YYDEBUG(200, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy199;
			goto yy345;
		} else {
			if (yych <= '1') goto yy201;
			if (yych <= 'm') goto yy199;
			goto yy346;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy199;
			goto yy346;
		} else {
			if (yych <= 's') goto yy347;
			if (yych <= 't') goto yy348;
			goto yy199;
		}
	}
yy201:
	YYDEBUG(201, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy345;
		if (yych <= 'm') goto yy199;
		goto yy346;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy199;
			goto yy346;
		} else {
			if (yych <= 's') goto yy347;
			if (yych <= 't') goto yy348;
			goto yy199;
		}
	}
yy202:
	YYDEBUG(202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy349;
		if (yych <= 'T') goto yy50;
		goto yy350;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy50;
			goto yy349;
		} else {
			if (yych == 'u') goto yy350;
			goto yy50;
		}
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy351;
	if (yych == 'e') goto yy351;
	goto yy50;
yy204:
	YYDEBUG(204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy352;
	if (yych == 'e') goto yy352;
	goto yy50;
yy205:
	YYDEBUG(205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy353;
		if (yych <= 'T') goto yy50;
		goto yy354;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy353;
		} else {
			if (yych == 'u') goto yy354;
			goto yy50;
		}
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy355;
	if (yych == 'a') goto yy355;
	goto yy50;
yy207:
	YYDEBUG(207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy356;
	if (yych == 'o') goto yy356;
	goto yy50;
yy208:
	YYDEBUG(208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy357;
	if (yych == 'c') goto yy357;
	goto yy50;
yy209:
	YYDEBUG(209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy358;
	if (yych == 'e') goto yy358;
	goto yy50;
yy210:
	YYDEBUG(210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy253;
	if (yych <= '/') goto yy173;
	if (yych <= '9') goto yy359;
	goto yy173;
yy211:
	YYDEBUG(211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy253;
	if (yych <= '/') goto yy173;
	if (yych <= '9') goto yy361;
	goto yy173;
yy212:
	YYDEBUG(212, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy344;
		goto yy194;
	} else {
		if (yych <= '9') goto yy213;
		if (yych <= ':') goto yy344;
		goto yy194;
	}
yy213:
	YYDEBUG(213, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy344;
	if (yych == ':') goto yy344;
	goto yy194;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy363;
	if (yych == 'r') goto yy363;
	goto yy50;
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy364;
	if (yych == 'g') goto yy364;
	goto yy50;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy365;
	if (yych == 'y') goto yy365;
	goto yy50;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy367;
	if (yych == 'c') goto yy367;
	goto yy50;
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy368;
	if (yych == 'b') goto yy368;
	goto yy50;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy369;
	if (yych == 'r') goto yy369;
	goto yy50;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy370;
	if (yych == 'i') goto yy370;
	goto yy50;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy371;
	if (yych == 'u') goto yy371;
	goto yy50;
yy222:
	YYDEBUG(222, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy222;
		if (yych <= 0x1F) goto yy50;
		goto yy222;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy50;
			goto yy222;
		} else {
			if (yych <= '/') goto yy50;
			if (yych >= ':') goto yy50;
		}
	}
yy223:
	YYDEBUG(223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy224;
	if (yych <= '9') goto yy372;
yy224:
	YYDEBUG(224, *YYCURSOR);
#line 1099 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 5792 "real_world/parse_date_db.c"
yy225:
	YYDEBUG(225, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy69;
			goto yy222;
		} else {
			if (yych == ' ') goto yy222;
			goto yy69;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy222;
			if (yych <= '/') goto yy69;
			goto yy223;
		} else {
			if (yych != 'I') goto yy69;
		}
	}
yy226:
	YYDEBUG(226, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy222;
		if (yych <= 0x1F) goto yy69;
		goto yy222;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy69;
			goto yy222;
		} else {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		}
	}
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy373;
	if (yych == 'n') goto yy373;
	goto yy50;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy374;
		if (yych <= 'M') goto yy50;
		goto yy375;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy50;
			goto yy374;
		} else {
			if (yych == 'n') goto yy375;
			goto yy50;
		}
	}
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy376;
		if (yych <= 'X') goto yy50;
		goto yy226;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy50;
			goto yy376;
		} else {
			if (yych == 'y') goto yy226;
			goto yy50;
		}
	}
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy377;
	if (yych == 'n') goto yy377;
	goto yy50;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy378;
	if (yych == 'n') goto yy378;
	goto yy50;
yy232:
	YYDEBUG(232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy367;
	if (yych == 'v') goto yy367;
	goto yy50;
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy379;
	if (yych == 't') goto yy379;
	goto yy50;
yy234:
	YYDEBUG(234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy380;
	if (yych == 't') goto yy380;
	goto yy50;
yy235:
	YYDEBUG(235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy381;
		if (yych <= 'O') goto yy50;
		goto yy382;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy50;
			goto yy381;
		} else {
			if (yych == 'p') goto yy382;
			goto yy50;
		}
	}
yy236:
	YYDEBUG(236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy370;
	if (yych == 'n') goto yy370;
	goto yy50;
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy383;
	if (yych == 'u') goto yy383;
	goto yy50;
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy384;
	if (yych == 'e') goto yy384;
	goto yy50;
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy50;
		if (yych <= 'D') goto yy385;
		goto yy386;
	} else {
		if (yych <= 'c') goto yy50;
		if (yych <= 'd') goto yy385;
		if (yych <= 'e') goto yy386;
		goto yy50;
	}
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy371;
	if (yych == 'a') goto yy371;
	goto yy50;
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy252;
		goto yy182;
	} else {
		if (yych <= '.') goto yy252;
		if (yych <= '/') goto yy247;
		goto yy182;
	}
yy242:
	YYDEBUG(242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy182;
			goto yy252;
		} else {
			if (yych <= ',') goto yy182;
			if (yych <= '.') goto yy252;
			goto yy247;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy182;
			goto yy383;
		} else {
			if (yych == 'u') goto yy383;
			goto yy182;
		}
	}
yy243:
	YYDEBUG(243, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy194;
		if (yych <= '-') goto yy340;
		goto yy387;
	} else {
		if (yych <= '/') goto yy194;
		if (yych <= '9') goto yy388;
		if (yych <= ':') goto yy389;
		goto yy194;
	}
yy244:
	YYDEBUG(244, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy194;
		if (yych <= '-') goto yy340;
		if (yych <= '.') goto yy387;
		goto yy194;
	} else {
		if (yych <= '2') goto yy388;
		if (yych <= '9') goto yy390;
		if (yych <= ':') goto yy389;
		goto yy194;
	}
yy245:
	YYDEBUG(245, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy194;
		if (yych <= '-') goto yy340;
		goto yy387;
	} else {
		if (yych <= '/') goto yy194;
		if (yych <= '9') goto yy390;
		if (yych <= ':') goto yy389;
		goto yy194;
	}
yy246:
	YYDEBUG(246, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy194;
		if (yych <= '-') goto yy340;
		goto yy387;
	} else {
		if (yych == ':') goto yy389;
		goto yy194;
	}
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy202;
		case 'D':
		case 'd': goto yy203;
		case 'F':
		case 'f': goto yy204;
		case 'J':
		case 'j': goto yy205;
		case 'M':
		case 'm': goto yy206;
		case 'N':
		case 'n': goto yy207;
		case 'O':
		case 'o': goto yy208;
		case 'S':
		case 's': goto yy209;
		default: goto yy50;
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy389;
		goto yy194;
	} else {
		if (yych <= '9') goto yy390;
		if (yych <= ':') goto yy389;
		goto yy194;
	}
yy249:
	YYDEBUG(249, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy389;
	if (yych == ':') goto yy389;
	goto yy194;
yy250:
	YYDEBUG(250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy251;
	if (yych != 'm') goto yy50;
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy391;
		if (yych == '\t') goto yy391;
		goto yy50;
	} else {
		if (yych <= ' ') goto yy391;
		if (yych == '.') goto yy392;
		goto yy50;
	}
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy182;
	if (yych <= '0') goto yy183;
	if (yych <= '1') goto yy184;
	if (yych <= '9') goto yy185;
	goto yy182;
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy393;
		case '1': goto yy394;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy395;
		case 'A':
		case 'a': goto yy396;
		case 'D':
		case 'd': goto yy397;
		case 'F':
		case 'f': goto yy398;
		case 'J':
		case 'j': goto yy399;
		case 'M':
		case 'm': goto yy400;
		case 'N':
		case 'n': goto yy401;
		case 'O':
		case 'o': goto yy402;
		case 'S':
		case 's': goto yy403;
		default: goto yy50;
	}
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy404;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy404;
		goto yy16;
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
	} else {
		if (yych <= 'Z') goto yy404;
		if (yych <= '`') goto yy256;
		if (yych <= 'z') goto yy404;
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
#line 1322 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 6176 "real_world/parse_date_db.c"
yy257:
	YYDEBUG(257, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'I') goto yy406;
				goto yy404;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'i') goto yy406;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'U') goto yy407;
				goto yy404;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'u') goto yy407;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy50;
	if (yych <= 'Z') goto yy408;
	goto yy50;
yy260:
	YYDEBUG(260, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych == '/') goto yy259;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy256;
			goto yy97;
		} else {
			if (yych == '/') goto yy259;
			goto yy256;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '^') goto yy256;
			goto yy259;
		} else {
			if (yych <= '`') goto yy256;
			if (yych <= 'z') goto yy409;
			goto yy256;
		}
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'I') goto yy406;
				if (yych <= 'Z') goto yy404;
				goto yy16;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy409;
			} else {
				if (yych <= 'i') goto yy410;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'U') goto yy407;
				if (yych <= 'Z') goto yy404;
				goto yy16;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy409;
			} else {
				if (yych <= 'u') goto yy411;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy264:
	YYDEBUG(264, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'E') goto yy412;
				goto yy404;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'e') goto yy412;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy265:
	YYDEBUG(265, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'E') goto yy412;
				if (yych <= 'Z') goto yy404;
				goto yy16;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy409;
			} else {
				if (yych <= 'e') goto yy413;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy404;
			goto yy414;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'h') goto yy414;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy404;
			goto yy415;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'v') goto yy415;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy404;
			goto yy414;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'h') goto yy416;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy269:
	YYDEBUG(269, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy404;
			goto yy415;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'v') goto yy417;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'R') goto yy418;
				goto yy404;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'r') goto yy418;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy271:
	YYDEBUG(271, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy404;
			goto yy419;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 't') goto yy419;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy272:
	YYDEBUG(272, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy404;
			goto yy414;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 's') goto yy414;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy404;
			goto yy420;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'r') goto yy420;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy274:
	YYDEBUG(274, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych >= ')') goto yy97;
		} else {
			if (yych <= '@') goto yy275;
			if (yych <= 'C') goto yy404;
			goto yy421;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy404;
			if (yych >= 'a') goto yy404;
		} else {
			if (yych <= 'd') goto yy421;
			if (yych <= 'z') goto yy404;
		}
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
#line 1337 "real_world/parse_date_db.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		s->time->relative.weekday_behavior = 1;
		
		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 6740 "real_world/parse_date_db.c"
yy276:
	YYDEBUG(276, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'R') goto yy418;
				if (yych <= 'Z') goto yy404;
				goto yy16;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy409;
			} else {
				if (yych <= 'r') goto yy422;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy404;
			goto yy419;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy423;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy404;
			goto yy414;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 's') goto yy416;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy279:
	YYDEBUG(279, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy404;
			goto yy420;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'r') goto yy424;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy275;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy275;
			if (yych <= 'C') goto yy404;
			goto yy421;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy275;
		} else {
			if (yych == 'd') goto yy425;
			if (yych <= 'z') goto yy409;
			goto yy275;
		}
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	yyaccept = 4;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 17) YYFILL(17);
	yych = *YYCURSOR;
yy282:
	YYDEBUG(282, *YYCURSOR);
	if (yybm[0+yych] & 64) {
		goto yy281;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy123;
		if (yych <= '1') goto yy426;
		goto yy427;
	} else {
		if (yych <= '9') goto yy428;
		if (yych == 'T') goto yy284;
		goto yy123;
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '1') {
		if (yych == '.') goto yy429;
		if (yych <= '/') goto yy282;
		goto yy430;
	} else {
		if (yych <= '2') goto yy431;
		if (yych <= '9') goto yy432;
		if (yych <= ':') goto yy433;
		goto yy282;
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy434;
	if (yych <= '2') goto yy435;
	if (yych <= '9') goto yy436;
	goto yy50;
yy285:
	YYDEBUG(285, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy123;
	} else {
		if (yych <= '3') goto yy437;
		if (yych <= '9') goto yy438;
		if (yych <= ':') goto yy433;
		goto yy123;
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy123;
	} else {
		if (yych <= '9') goto yy438;
		if (yych <= ':') goto yy433;
		goto yy123;
	}
yy287:
	YYDEBUG(287, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy123;
	} else {
		if (yych <= '9') goto yy437;
		if (yych <= ':') goto yy433;
		goto yy123;
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy121;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy121;
			if (yych == ')') goto yy97;
			goto yy16;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy121;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy289:
	YYDEBUG(289, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'U') goto yy439;
				goto yy404;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'u') goto yy439;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy290:
	YYDEBUG(290, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'Y') goto yy440;
				goto yy404;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'y') goto yy440;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'E') goto yy440;
				goto yy404;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'e') goto yy440;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'U') goto yy439;
				if (yych <= 'Z') goto yy404;
				goto yy16;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy409;
			} else {
				if (yych <= 'u') goto yy441;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'Y') goto yy440;
				if (yych <= 'Z') goto yy404;
				goto yy16;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy409;
			} else {
				if (yych <= 'y') goto yy442;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy294:
	YYDEBUG(294, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'E') goto yy440;
				if (yych <= 'Z') goto yy404;
				goto yy16;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy409;
			} else {
				if (yych <= 'e') goto yy442;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy404;
			goto yy443;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 't') goto yy443;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy404;
			goto yy443;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy444;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'C') goto yy445;
				goto yy404;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'c') goto yy445;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy121;
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych == ')') goto yy97;
			if (yych <= ',') goto yy16;
			goto yy405;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy121;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy404;
			goto yy446;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'n') goto yy446;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'C') goto yy445;
				if (yych <= 'Z') goto yy404;
				goto yy16;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy409;
			} else {
				if (yych <= 'c') goto yy447;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy121;
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych <= ',') goto yy16;
				if (yych <= '-') goto yy405;
				goto yy121;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy259;
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy404;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy16;
				goto yy259;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy404;
			goto yy446;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy448;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy404;
			goto yy449;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'n') goto yy449;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy304:
	YYDEBUG(304, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
	} else {
		if (yych <= 'Z') goto yy404;
		if (yych <= '`') goto yy305;
		if (yych <= 'z') goto yy404;
	}
yy305:
	YYDEBUG(305, *YYCURSOR);
#line 883 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7543 "real_world/parse_date_db.c"
yy306:
	YYDEBUG(306, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy404;
			goto yy449;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy451;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy307:
	YYDEBUG(307, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy305;
			goto yy97;
		} else {
			if (yych == '/') goto yy259;
			goto yy305;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '^') goto yy305;
			goto yy259;
		} else {
			if (yych <= '`') goto yy305;
			if (yych <= 'z') goto yy409;
			goto yy305;
		}
	}
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'O') goto yy452;
				goto yy404;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'o') goto yy452;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'O') goto yy452;
				if (yych <= 'Z') goto yy404;
				goto yy16;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy409;
			} else {
				if (yych <= 'o') goto yy453;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy310:
	YYDEBUG(310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy404;
			goto yy454;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'v') goto yy454;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy404;
			goto yy454;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'v') goto yy455;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy312:
	YYDEBUG(312, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy275;
			goto yy97;
		} else {
			if (yych <= '@') goto yy275;
			if (yych <= 'T') goto yy404;
			goto yy456;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy275;
			goto yy404;
		} else {
			if (yych <= 'u') goto yy456;
			if (yych <= 'z') goto yy404;
			goto yy275;
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy404;
			goto yy457;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'o') goto yy457;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'T') goto yy458;
				goto yy404;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy404;
			} else {
				if (yych <= 't') goto yy458;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy404;
			goto yy459;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'e') goto yy459;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy275;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy275;
			if (yych <= 'T') goto yy404;
			goto yy456;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy275;
		} else {
			if (yych == 'u') goto yy460;
			if (yych <= 'z') goto yy409;
			goto yy275;
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy404;
			goto yy457;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'o') goto yy461;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy16;
				goto yy404;
			} else {
				if (yych <= 'T') goto yy458;
				if (yych <= 'Z') goto yy404;
				goto yy16;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy409;
			} else {
				if (yych <= 't') goto yy462;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy404;
			goto yy459;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy463;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy63;
		goto yy50;
	} else {
		if (yych <= '5') goto yy464;
		if (yych == ':') goto yy63;
		goto yy50;
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= 'Q') goto yy404;
			if (yych <= 'R') goto yy465;
			goto yy443;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'r') goto yy465;
			if (yych <= 's') goto yy443;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy275;
			goto yy97;
		} else {
			if (yych <= '@') goto yy275;
			if (yych <= 'Q') goto yy404;
			goto yy466;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy275;
			goto yy404;
		} else {
			if (yych <= 'r') goto yy466;
			if (yych <= 'z') goto yy404;
			goto yy275;
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy467;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy467;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy404;
			goto yy468;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'o') goto yy468;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy275;
			goto yy97;
		} else {
			if (yych <= '@') goto yy275;
			if (yych <= 'R') goto yy404;
			goto yy469;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy275;
			goto yy404;
		} else {
			if (yych <= 's') goto yy469;
			if (yych <= 'z') goto yy404;
			goto yy275;
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'K') goto yy404;
			goto yy470;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'l') goto yy470;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy404;
			if (yych <= 'R') goto yy465;
			goto yy443;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy409;
				goto yy471;
			} else {
				if (yych <= 's') goto yy444;
				if (yych <= 'z') goto yy409;
				goto yy16;
			}
		}
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy275;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy275;
			if (yych <= 'Q') goto yy404;
			goto yy466;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy275;
		} else {
			if (yych == 'r') goto yy472;
			if (yych <= 'z') goto yy409;
			goto yy275;
		}
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			goto yy467;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy473;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy330:
	YYDEBUG(330, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy404;
			goto yy468;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'o') goto yy474;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy275;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy275;
			if (yych <= 'R') goto yy404;
			goto yy469;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy275;
		} else {
			if (yych == 's') goto yy475;
			if (yych <= 'z') goto yy409;
			goto yy275;
		}
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'K') goto yy404;
			goto yy470;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'l') goto yy476;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy121;
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych == ')') goto yy97;
			if (yych <= ',') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy404;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy440;
				goto yy404;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy404;
				goto yy16;
			}
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy275;
			goto yy97;
		} else {
			if (yych <= '@') goto yy275;
			if (yych <= 'M') goto yy404;
			goto yy477;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy275;
			goto yy404;
		} else {
			if (yych <= 'n') goto yy477;
			if (yych <= 'z') goto yy404;
			goto yy275;
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy275;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy275;
			if (yych <= 'M') goto yy404;
			goto yy477;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy275;
		} else {
			if (yych == 'n') goto yy478;
			if (yych <= 'z') goto yy409;
			goto yy275;
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy404;
			goto yy479;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy404;
			if (yych <= '`') goto yy16;
			goto yy404;
		} else {
			if (yych <= 't') goto yy479;
			if (yych <= 'z') goto yy404;
			goto yy16;
		}
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy404;
			goto yy479;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy404;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy480;
			if (yych <= 'z') goto yy409;
			goto yy16;
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy381;
	if (yych == 'c') goto yy381;
	goto yy50;
yy339:
	YYDEBUG(339, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '9') goto yy97;
	goto yy16;
yy340:
	YYDEBUG(340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy481;
	goto yy50;
yy341:
	YYDEBUG(341, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy483;
	if (yych <= '3') goto yy485;
	if (yych <= '9') goto yy486;
	goto yy50;
yy342:
	YYDEBUG(342, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy382;
	if (yych == 'p') goto yy382;
	goto yy50;
yy343:
	YYDEBUG(343, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy487;
	if (yych <= '6') goto yy488;
	if (yych <= '9') goto yy489;
	goto yy50;
yy344:
	YYDEBUG(344, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy490;
	if (yych <= '6') goto yy491;
	if (yych <= '9') goto yy492;
	goto yy50;
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy493;
	goto yy50;
yy346:
	YYDEBUG(346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy494;
	goto yy50;
yy347:
	YYDEBUG(347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy494;
	goto yy50;
yy348:
	YYDEBUG(348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy494;
	goto yy50;
yy349:
	YYDEBUG(349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy495;
	if (yych == 'r') goto yy495;
	goto yy50;
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy495;
	if (yych == 'g') goto yy495;
	goto yy50;
yy351:
	YYDEBUG(351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy495;
	if (yych == 'c') goto yy495;
	goto yy50;
yy352:
	YYDEBUG(352, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy495;
	if (yych == 'b') goto yy495;
	goto yy50;
yy353:
	YYDEBUG(353, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy495;
	if (yych == 'n') goto yy495;
	goto yy50;
yy354:
	YYDEBUG(354, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy495;
		if (yych <= 'M') goto yy50;
		goto yy495;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy50;
			goto yy495;
		} else {
			if (yych == 'n') goto yy495;
			goto yy50;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy495;
		if (yych <= 'X') goto yy50;
		goto yy495;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy50;
			goto yy495;
		} else {
			if (yych == 'y') goto yy495;
			goto yy50;
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy495;
	if (yych == 'v') goto yy495;
	goto yy50;
yy357:
	YYDEBUG(357, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy495;
	if (yych == 't') goto yy495;
	goto yy50;
yy358:
	YYDEBUG(358, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy496;
	if (yych == 'p') goto yy496;
	goto yy50;
yy359:
	YYDEBUG(359, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'n':
		case 'o':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy498;
		case '-': goto yy499;
		case '.': goto yy500;
		case '/': goto yy501;
		case '0': goto yy502;
		case '1': goto yy503;
		case '2': goto yy504;
		case '3': goto yy505;
		case '4':
		case '5': goto yy506;
		case '6': goto yy507;
		case '7':
		case '8':
		case '9': goto yy51;
		case ':': goto yy508;
		case 'W': goto yy520;
		default: goto yy360;
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
#line 993 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 8610 "real_world/parse_date_db.c"
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ':
		case 'A':
		case 'D':
		case 'F':
		case 'H':
		case 'I':
		case 'J':
		case 'M':
		case 'N':
		case 'O':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'a':
		case 'd':
		case 'f':
		case 'h':
		case 'j':
		case 'm':
		case 'n':
		case 'o':
		case 's':
		case 't':
		case 'w':
		case 'y': goto yy498;
		case '-': goto yy499;
		case '.': goto yy500;
		case '/': goto yy501;
		case '0': goto yy522;
		case '1': goto yy523;
		case '2': goto yy524;
		case '3': goto yy525;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy51;
		case ':': goto yy508;
		case 'W': goto yy520;
		default: goto yy362;
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
#line 1313 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 8671 "real_world/parse_date_db.c"
yy363:
	YYDEBUG(363, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
			goto yy69;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			goto yy222;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		} else {
			if (yych <= 'I') goto yy526;
			if (yych == 'i') goto yy526;
			goto yy69;
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
			goto yy69;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			goto yy222;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		} else {
			if (yych <= 'U') goto yy527;
			if (yych == 'u') goto yy527;
			goto yy69;
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy528;
	if (yych == 's') goto yy528;
yy366:
	YYDEBUG(366, *YYCURSOR);
#line 1414 "real_world/parse_date_db.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 0, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 8742 "real_world/parse_date_db.c"
yy367:
	YYDEBUG(367, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
			goto yy69;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			goto yy222;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		} else {
			if (yych <= 'E') goto yy529;
			if (yych == 'e') goto yy529;
			goto yy69;
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
			goto yy69;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			goto yy222;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		} else {
			if (yych <= 'R') goto yy530;
			if (yych == 'r') goto yy530;
			goto yy69;
		}
	}
yy369:
	YYDEBUG(369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy531;
	if (yych == 't') goto yy531;
	goto yy50;
yy370:
	YYDEBUG(370, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy532;
	if (yych == 'd') goto yy532;
	goto yy366;
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy365;
	if (yych == 'r') goto yy365;
	goto yy50;
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy224;
	if (yych <= '9') goto yy533;
	goto yy224;
yy373:
	YYDEBUG(373, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
			goto yy69;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			goto yy222;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		} else {
			if (yych <= 'U') goto yy534;
			if (yych == 'u') goto yy534;
			goto yy69;
		}
	}
yy374:
	YYDEBUG(374, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
			goto yy69;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			goto yy222;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		} else {
			if (yych <= 'Y') goto yy226;
			if (yych == 'y') goto yy226;
			goto yy69;
		}
	}
yy375:
	YYDEBUG(375, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
			goto yy69;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			goto yy222;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		} else {
			if (yych <= 'E') goto yy226;
			if (yych == 'e') goto yy226;
			goto yy69;
		}
	}
yy376:
	YYDEBUG(376, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
			goto yy69;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			goto yy222;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		} else {
			if (yych <= 'C') goto yy535;
			if (yych == 'c') goto yy535;
			goto yy69;
		}
	}
yy377:
	YYDEBUG(377, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy528;
		if (yych <= 'T') goto yy366;
		goto yy536;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy366;
			goto yy528;
		} else {
			if (yych == 'u') goto yy536;
			goto yy366;
		}
	}
yy378:
	YYDEBUG(378, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy532;
		if (yych <= 'S') goto yy366;
		goto yy537;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy366;
			goto yy532;
		} else {
			if (yych == 't') goto yy537;
			goto yy366;
		}
	}
yy379:
	YYDEBUG(379, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
			goto yy69;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			goto yy222;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		} else {
			if (yych <= 'O') goto yy538;
			if (yych == 'o') goto yy538;
			goto yy69;
		}
	}
yy380:
	YYDEBUG(380, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy539;
	if (yych == 'u') goto yy539;
	goto yy366;
yy381:
	YYDEBUG(381, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy540;
		if (yych <= 'R') goto yy366;
		goto yy528;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy366;
			goto yy540;
		} else {
			if (yych == 's') goto yy528;
			goto yy366;
		}
	}
yy382:
	YYDEBUG(382, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy222;
			goto yy69;
		} else {
			if (yych <= ' ') goto yy222;
			if (yych <= ',') goto yy69;
			goto yy222;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy69;
			if (yych <= '9') goto yy223;
			goto yy69;
		} else {
			if (yych <= 'T') goto yy367;
			if (yych == 't') goto yy367;
			goto yy69;
		}
	}
yy383:
	YYDEBUG(383, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy541;
	if (yych == 'r') goto yy541;
	goto yy366;
yy384:
	YYDEBUG(384, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy542;
	if (yych == 's') goto yy542;
	goto yy366;
yy385:
	YYDEBUG(385, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy543;
	if (yych == 'n') goto yy543;
	goto yy366;
yy386:
	YYDEBUG(386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy365;
	if (yych == 'k') goto yy365;
	goto yy50;
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy544;
	if (yych <= '6') goto yy545;
	if (yych <= '9') goto yy489;
	goto yy50;
yy388:
	YYDEBUG(388, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy546;
			if (yych <= 0x1F) goto yy194;
			goto yy546;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy194;
				goto yy340;
			} else {
				if (yych <= '.') goto yy387;
				if (yych <= '9') goto yy194;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy91;
			if (yych <= 'O') goto yy194;
			goto yy91;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy194;
				goto yy91;
			} else {
				if (yych == 'p') goto yy91;
				goto yy194;
			}
		}
	}
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy547;
	if (yych <= '6') goto yy548;
	if (yych <= '9') goto yy492;
	goto yy50;
yy390:
	YYDEBUG(390, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy546;
			if (yych <= 0x1F) goto yy194;
			goto yy546;
		} else {
			if (yych == '.') goto yy389;
			if (yych <= '9') goto yy194;
			goto yy389;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy91;
			if (yych <= 'O') goto yy194;
			goto yy91;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy194;
				goto yy91;
			} else {
				if (yych == 'p') goto yy91;
				goto yy194;
			}
		}
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	++YYCURSOR;
#line 950 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 9142 "real_world/parse_date_db.c"
yy392:
	YYDEBUG(392, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy391;
		if (yych <= 0x08) goto yy50;
		goto yy391;
	} else {
		if (yych == ' ') goto yy391;
		goto yy50;
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy549;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy395;
	goto yy50;
yy394:
	YYDEBUG(394, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy549;
	if (yych <= '/') goto yy50;
	if (yych >= '3') goto yy50;
yy395:
	YYDEBUG(395, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy549;
	goto yy50;
yy396:
	YYDEBUG(396, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy550;
		if (yych <= 'T') goto yy50;
		goto yy551;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy50;
			goto yy550;
		} else {
			if (yych == 'u') goto yy551;
			goto yy50;
		}
	}
yy397:
	YYDEBUG(397, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy552;
	if (yych == 'e') goto yy552;
	goto yy50;
yy398:
	YYDEBUG(398, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy553;
	if (yych == 'e') goto yy553;
	goto yy50;
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy554;
		if (yych <= 'T') goto yy50;
		goto yy555;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy554;
		} else {
			if (yych == 'u') goto yy555;
			goto yy50;
		}
	}
yy400:
	YYDEBUG(400, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy556;
	if (yych == 'a') goto yy556;
	goto yy50;
yy401:
	YYDEBUG(401, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy557;
	if (yych == 'o') goto yy557;
	goto yy50;
yy402:
	YYDEBUG(402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy558;
	if (yych == 'c') goto yy558;
	goto yy50;
yy403:
	YYDEBUG(403, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy559;
	if (yych == 'e') goto yy559;
	goto yy50;
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy560;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy560;
		goto yy16;
	}
yy405:
	YYDEBUG(405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy121;
	if (yych <= '0') goto yy561;
	if (yych <= '2') goto yy562;
	if (yych <= '3') goto yy563;
	goto yy121;
yy406:
	YYDEBUG(406, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'K') goto yy560;
			goto yy564;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'l') goto yy564;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy560;
			goto yy565;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 's') goto yy565;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 128) {
		goto yy566;
	}
	goto yy50;
yy409:
	YYDEBUG(409, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych == '/') goto yy259;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'K') goto yy560;
			goto yy564;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'l') goto yy568;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy411:
	YYDEBUG(411, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy560;
			goto yy565;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 's') goto yy569;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy412:
	YYDEBUG(412, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'L') goto yy560;
			goto yy570;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'm') goto yy570;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'L') goto yy560;
			goto yy570;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'm') goto yy571;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy560;
			goto yy572;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 't') goto yy572;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy415:
	YYDEBUG(415, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy560;
			goto yy573;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'e') goto yy573;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy560;
			goto yy572;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy574;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy560;
			goto yy573;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy575;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'T') goto yy560;
			goto yy576;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'u') goto yy576;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy560;
			goto yy572;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'h') goto yy572;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy420:
	YYDEBUG(420, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy560;
			goto yy577;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 't') goto yy577;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy421:
	YYDEBUG(421, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy578;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy578;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy422:
	YYDEBUG(422, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'T') goto yy560;
			goto yy576;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'u') goto yy579;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy423:
	YYDEBUG(423, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy560;
			goto yy572;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'h') goto yy574;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy424:
	YYDEBUG(424, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy560;
			goto yy577;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy580;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			goto yy578;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy581;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy123;
	} else {
		if (yych <= '9') goto yy582;
		if (yych <= ':') goto yy433;
		goto yy123;
	}
yy427:
	YYDEBUG(427, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy123;
	} else {
		if (yych <= '3') goto yy582;
		if (yych <= '9') goto yy583;
		if (yych <= ':') goto yy433;
		goto yy123;
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy123;
	} else {
		if (yych <= '9') goto yy583;
		if (yych <= ':') goto yy433;
		goto yy123;
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '2') {
		if (yych <= '/') goto yy282;
		if (yych <= '1') goto yy584;
		goto yy585;
	} else {
		if (yych <= '5') goto yy586;
		if (yych <= '9') goto yy587;
		goto yy282;
	}
yy430:
	YYDEBUG(430, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy123;
	} else {
		if (yych <= '9') goto yy588;
		if (yych <= ':') goto yy433;
		goto yy123;
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy123;
	} else {
		if (yych <= '3') goto yy588;
		if (yych <= '9') goto yy590;
		if (yych <= ':') goto yy433;
		goto yy123;
	}
yy432:
	YYDEBUG(432, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy123;
	} else {
		if (yych <= '9') goto yy590;
		if (yych >= ';') goto yy123;
	}
yy433:
	YYDEBUG(433, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy591;
	if (yych <= '9') goto yy593;
	goto yy50;
yy434:
	YYDEBUG(434, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy50;
	} else {
		if (yych <= '9') goto yy436;
		if (yych <= ':') goto yy433;
		goto yy50;
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy50;
	} else {
		if (yych <= '3') goto yy436;
		if (yych == ':') goto yy433;
		goto yy50;
	}
yy436:
	YYDEBUG(436, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy433;
	if (yych == ':') goto yy433;
	goto yy50;
yy437:
	YYDEBUG(437, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy123;
	} else {
		if (yych <= '9') goto yy594;
		if (yych <= ':') goto yy433;
		goto yy123;
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy123;
	if (yych <= '9') goto yy594;
	goto yy123;
yy439:
	YYDEBUG(439, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy595;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy595;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy440:
	YYDEBUG(440, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy121;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy121;
			if (yych == ')') goto yy97;
			goto yy16;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy121;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy441:
	YYDEBUG(441, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			goto yy595;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy596;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy442:
	YYDEBUG(442, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy121;
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych == ')') goto yy97;
			if (yych <= ',') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy259;
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy560;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy16;
				goto yy259;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy567;
				goto yy16;
			}
		}
	}
yy443:
	YYDEBUG(443, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ': goto yy597;
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'U':
		case 'V':
		case 'X':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy560;
		case 'D':
		case 'd': goto yy599;
		case 'F':
		case 'f': goto yy600;
		case 'H':
		case 'h': goto yy601;
		case 'M':
		case 'm': goto yy602;
		case 'S':
		case 's': goto yy603;
		case 'T':
		case 't': goto yy604;
		case 'W':
		case 'w': goto yy605;
		case 'Y':
		case 'y': goto yy606;
		default: goto yy16;
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ': goto yy597;
		case ')': goto yy97;
		case '/':
		case '_': goto yy259;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'U':
		case 'V':
		case 'X':
		case 'Z': goto yy560;
		case 'D': goto yy599;
		case 'F': goto yy600;
		case 'H': goto yy601;
		case 'M': goto yy602;
		case 'S': goto yy603;
		case 'T': goto yy604;
		case 'W': goto yy605;
		case 'Y': goto yy606;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy567;
		case 'd': goto yy607;
		case 'f': goto yy608;
		case 'h': goto yy609;
		case 'm': goto yy610;
		case 's': goto yy611;
		case 't': goto yy612;
		case 'w': goto yy613;
		case 'y': goto yy614;
		default: goto yy16;
	}
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy560;
			goto yy564;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'h') goto yy564;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy560;
			goto yy615;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'i') goto yy615;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy560;
			goto yy564;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'h') goto yy568;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy560;
			goto yy615;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'i') goto yy616;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
	} else {
		if (yych <= 'Z') goto yy560;
		if (yych <= '`') goto yy450;
		if (yych <= 'z') goto yy560;
	}
yy450:
	YYDEBUG(450, *YYCURSOR);
#line 892 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 10199 "real_world/parse_date_db.c"
yy451:
	YYDEBUG(451, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy450;
			goto yy97;
		} else {
			if (yych == '/') goto yy259;
			goto yy450;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '^') goto yy450;
			goto yy259;
		} else {
			if (yych <= '`') goto yy450;
			if (yych <= 'z') goto yy567;
			goto yy450;
		}
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy560;
			goto yy617;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'b') goto yy617;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy560;
			goto yy617;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'b') goto yy618;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy560;
			goto yy619;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'i') goto yy619;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy560;
			goto yy619;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'i') goto yy620;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy560;
			goto yy621;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'r') goto yy621;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy560;
			goto yy622;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'n') goto yy622;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy458:
	YYDEBUG(458, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy97;
				goto yy16;
			} else {
				if (yych <= '-') goto yy405;
				if (yych <= '.') goto yy121;
				goto yy16;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy121;
				goto yy16;
			} else {
				if (yych == 'E') goto yy623;
				goto yy560;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy560;
			} else {
				if (yych <= 'e') goto yy623;
				if (yych <= 'z') goto yy560;
				goto yy16;
			}
		}
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy560;
			goto yy624;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'n') goto yy624;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy560;
			goto yy621;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'r') goto yy625;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy560;
			goto yy622;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy626;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy121;
			} else {
				if (yych == ' ') goto yy121;
				goto yy16;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy97;
				if (yych <= ',') goto yy16;
				goto yy405;
			} else {
				if (yych == '/') goto yy259;
				goto yy121;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy16;
				goto yy560;
			} else {
				if (yych <= 'E') goto yy623;
				if (yych <= 'Z') goto yy560;
				goto yy16;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy567;
			} else {
				if (yych <= 'e') goto yy627;
				if (yych <= 'z') goto yy567;
				goto yy16;
			}
		}
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy560;
			goto yy624;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy628;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy629;
	goto yy50;
yy465:
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy560;
			goto yy572;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'd') goto yy572;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy560;
			goto yy621;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 's') goto yy621;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'X') goto yy560;
			goto yy630;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'y') goto yy630;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy560;
			goto yy632;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'r') goto yy632;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy560;
			goto yy633;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'd') goto yy633;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'E') goto yy560;
			goto yy624;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'f') goto yy624;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy560;
			goto yy572;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'd') goto yy574;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy560;
			goto yy621;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 's') goto yy625;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy473:
	YYDEBUG(473, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'X') goto yy560;
			goto yy630;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'y') goto yy634;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy560;
			goto yy632;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'r') goto yy635;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy560;
			goto yy633;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'd') goto yy636;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'E') goto yy560;
			goto yy624;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'f') goto yy628;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy477:
	YYDEBUG(477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy560;
			goto yy637;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'e') goto yy637;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy560;
			goto yy637;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy638;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy560;
			goto yy639;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy560;
			if (yych <= '`') goto yy16;
			goto yy560;
		} else {
			if (yych <= 'e') goto yy639;
			if (yych <= 'z') goto yy560;
			goto yy16;
		}
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy560;
			goto yy639;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy560;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy640;
			if (yych <= 'z') goto yy567;
			goto yy16;
		}
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy482;
	if (yych <= '9') goto yy641;
yy482:
	YYDEBUG(482, *YYCURSOR);
#line 1113 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("pointed date");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 10960 "real_world/parse_date_db.c"
yy483:
	YYDEBUG(483, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy484;
		if (yych <= '9') goto yy642;
		if (yych >= 'n') goto yy643;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy643;
		} else {
			if (yych <= 's') goto yy644;
			if (yych <= 't') goto yy645;
		}
	}
yy484:
	YYDEBUG(484, *YYCURSOR);
#line 1086 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 10991 "real_world/parse_date_db.c"
yy485:
	YYDEBUG(485, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy484;
			goto yy642;
		} else {
			if (yych <= '9') goto yy641;
			if (yych <= 'm') goto yy484;
			goto yy643;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy484;
			goto yy643;
		} else {
			if (yych <= 's') goto yy644;
			if (yych <= 't') goto yy645;
			goto yy484;
		}
	}
yy486:
	YYDEBUG(486, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy484;
		if (yych <= '9') goto yy641;
		if (yych <= 'm') goto yy484;
		goto yy643;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy484;
			goto yy643;
		} else {
			if (yych <= 's') goto yy644;
			if (yych <= 't') goto yy645;
			goto yy484;
		}
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy646;
	if (yych <= '/') goto yy194;
	if (yych <= '9') goto yy647;
	goto yy194;
yy488:
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy646;
		goto yy194;
	} else {
		if (yych <= '0') goto yy647;
		if (yych <= '9') goto yy641;
		goto yy194;
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy646;
	if (yych <= '/') goto yy194;
	if (yych <= '9') goto yy641;
	goto yy194;
yy490:
	YYDEBUG(490, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy646;
	if (yych <= '/') goto yy194;
	if (yych <= '9') goto yy492;
	goto yy194;
yy491:
	YYDEBUG(491, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy646;
	if (yych != '0') goto yy194;
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy646;
	goto yy194;
yy493:
	YYDEBUG(493, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy648;
	goto yy199;
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy345;
	goto yy199;
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy649;
	goto yy50;
yy496:
	YYDEBUG(496, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy649;
		goto yy50;
	} else {
		if (yych <= 'T') goto yy495;
		if (yych == 't') goto yy495;
		goto yy50;
	}
yy497:
	YYDEBUG(497, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy498:
	YYDEBUG(498, *YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ': goto yy497;
		case '-':
		case '.': goto yy650;
		case 'A':
		case 'a': goto yy509;
		case 'D':
		case 'd': goto yy510;
		case 'F':
		case 'f': goto yy511;
		case 'H':
		case 'h': goto yy67;
		case 'I': goto yy512;
		case 'J':
		case 'j': goto yy514;
		case 'M':
		case 'm': goto yy515;
		case 'N':
		case 'n': goto yy516;
		case 'O':
		case 'o': goto yy517;
		case 'S':
		case 's': goto yy518;
		case 'T':
		case 't': goto yy75;
		case 'V': goto yy519;
		case 'W':
		case 'w': goto yy77;
		case 'X': goto yy521;
		case 'Y':
		case 'y': goto yy79;
		default: goto yy50;
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy652;
		case '1': goto yy653;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy654;
		case 'A':
		case 'a': goto yy655;
		case 'D':
		case 'd': goto yy656;
		case 'F':
		case 'f': goto yy657;
		case 'J':
		case 'j': goto yy658;
		case 'M':
		case 'm': goto yy659;
		case 'N':
		case 'n': goto yy660;
		case 'O':
		case 'o': goto yy661;
		case 'S':
		case 's': goto yy662;
		default: goto yy651;
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy651;
	if (yych <= '0') goto yy663;
	if (yych <= '2') goto yy664;
	if (yych <= '3') goto yy665;
	goto yy651;
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy670;
	if (yych <= '1') goto yy671;
	if (yych <= '9') goto yy672;
	goto yy50;
yy502:
	YYDEBUG(502, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '0') goto yy673;
	if (yych <= '9') goto yy675;
	goto yy173;
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '2') goto yy675;
	if (yych <= '9') goto yy676;
	goto yy173;
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '9') goto yy676;
	goto yy173;
yy505:
	YYDEBUG(505, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '5') goto yy676;
	if (yych <= '6') goto yy677;
	if (yych <= '9') goto yy678;
	goto yy173;
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '9') goto yy678;
	goto yy173;
yy507:
	YYDEBUG(507, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '0') goto yy678;
	if (yych <= '9') goto yy51;
	goto yy173;
yy508:
	YYDEBUG(508, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy679;
	if (yych <= '1') goto yy680;
	goto yy50;
yy509:
	YYDEBUG(509, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy681;
		if (yych <= 'T') goto yy50;
		goto yy682;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy50;
			goto yy681;
		} else {
			if (yych == 'u') goto yy682;
			goto yy50;
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy216;
		if (yych <= 'D') goto yy50;
		goto yy683;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy216;
		} else {
			if (yych == 'e') goto yy683;
			goto yy50;
		}
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy684;
			goto yy50;
		} else {
			if (yych <= 'O') goto yy219;
			if (yych <= 'Q') goto yy50;
			goto yy220;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy684;
			goto yy50;
		} else {
			if (yych <= 'o') goto yy219;
			if (yych == 'r') goto yy220;
			goto yy50;
		}
	}
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'I') goto yy685;
	} else {
		if (yych == 'W') goto yy513;
		if (yych <= 'X') goto yy686;
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
#line 1139 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 11324 "real_world/parse_date_db.c"
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy687;
		if (yych <= 'T') goto yy50;
		goto yy688;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy687;
		} else {
			if (yych == 'u') goto yy688;
			goto yy50;
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'H') {
			if (yych == 'A') goto yy689;
			goto yy50;
		} else {
			if (yych <= 'I') goto yy230;
			if (yych <= 'N') goto yy50;
			goto yy231;
		}
	} else {
		if (yych <= 'h') {
			if (yych == 'a') goto yy689;
			goto yy50;
		} else {
			if (yych <= 'i') goto yy230;
			if (yych == 'o') goto yy231;
			goto yy50;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy690;
	if (yych == 'o') goto yy690;
	goto yy50;
yy517:
	YYDEBUG(517, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy691;
	if (yych == 'c') goto yy691;
	goto yy50;
yy518:
	YYDEBUG(518, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy234;
			goto yy50;
		} else {
			if (yych <= 'E') goto yy692;
			if (yych <= 'T') goto yy50;
			goto yy236;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy234;
			goto yy50;
		} else {
			if (yych <= 'e') goto yy692;
			if (yych == 'u') goto yy236;
			goto yy50;
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy521;
	goto yy513;
yy520:
	YYDEBUG(520, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy50;
		if (yych <= '0') goto yy693;
		if (yych <= '4') goto yy694;
		goto yy695;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy50;
			goto yy239;
		} else {
			if (yych == 'e') goto yy239;
			goto yy50;
		}
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy685;
	goto yy513;
yy522:
	YYDEBUG(522, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '0') goto yy696;
	if (yych <= '9') goto yy697;
	goto yy173;
yy523:
	YYDEBUG(523, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '2') goto yy697;
	if (yych <= '9') goto yy698;
	goto yy173;
yy524:
	YYDEBUG(524, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '9') goto yy698;
	goto yy173;
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '5') goto yy698;
	if (yych <= '6') goto yy699;
	if (yych <= '9') goto yy51;
	goto yy173;
yy526:
	YYDEBUG(526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy226;
	if (yych == 'l') goto yy226;
	goto yy50;
yy527:
	YYDEBUG(527, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy700;
	if (yych == 's') goto yy700;
	goto yy50;
yy528:
	YYDEBUG(528, *YYCURSOR);
	++YYCURSOR;
	goto yy366;
yy529:
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy538;
	if (yych == 'm') goto yy538;
	goto yy50;
yy530:
	YYDEBUG(530, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy534;
	if (yych == 'u') goto yy534;
	goto yy50;
yy531:
	YYDEBUG(531, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy701;
		if (yych <= 'M') goto yy50;
		goto yy702;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy50;
			goto yy701;
		} else {
			if (yych == 'n') goto yy702;
			goto yy50;
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy703;
	if (yych == 'a') goto yy703;
	goto yy50;
yy533:
	YYDEBUG(533, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy224;
	if (yych <= '9') goto yy704;
	goto yy224;
yy534:
	YYDEBUG(534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy705;
	if (yych == 'a') goto yy705;
	goto yy50;
yy535:
	YYDEBUG(535, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy226;
	if (yych == 'h') goto yy226;
	goto yy50;
yy536:
	YYDEBUG(536, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy706;
	if (yych == 't') goto yy706;
	goto yy50;
yy537:
	YYDEBUG(537, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy365;
	if (yych == 'h') goto yy365;
	goto yy50;
yy538:
	YYDEBUG(538, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy707;
	if (yych == 'b') goto yy707;
	goto yy50;
yy539:
	YYDEBUG(539, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy542;
	if (yych == 'r') goto yy542;
	goto yy50;
yy540:
	YYDEBUG(540, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy708;
	if (yych == 'n') goto yy708;
	goto yy50;
yy541:
	YYDEBUG(541, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy542;
	if (yych != 's') goto yy50;
yy542:
	YYDEBUG(542, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy532;
	if (yych == 'd') goto yy532;
	goto yy50;
yy543:
	YYDEBUG(543, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy541;
	if (yych == 'e') goto yy541;
	goto yy50;
yy544:
	YYDEBUG(544, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy646;
	if (yych <= '/') goto yy194;
	if (yych <= '9') goto yy709;
	goto yy194;
yy545:
	YYDEBUG(545, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy646;
		goto yy194;
	} else {
		if (yych <= '0') goto yy709;
		if (yych <= '9') goto yy641;
		goto yy194;
	}
yy546:
	YYDEBUG(546, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy546;
			goto yy50;
		} else {
			if (yych <= ' ') goto yy546;
			if (yych <= '@') goto yy50;
			goto yy91;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy91;
			goto yy50;
		} else {
			if (yych <= 'a') goto yy91;
			if (yych == 'p') goto yy91;
			goto yy50;
		}
	}
yy547:
	YYDEBUG(547, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy646;
	if (yych <= '/') goto yy194;
	if (yych <= '9') goto yy710;
	goto yy194;
yy548:
	YYDEBUG(548, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy646;
	if (yych == '0') goto yy710;
	goto yy194;
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy711;
	if (yych <= '3') goto yy712;
	if (yych <= '9') goto yy713;
	goto yy50;
yy550:
	YYDEBUG(550, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy714;
	if (yych == 'r') goto yy714;
	goto yy50;
yy551:
	YYDEBUG(551, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy714;
	if (yych == 'g') goto yy714;
	goto yy50;
yy552:
	YYDEBUG(552, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy714;
	if (yych == 'c') goto yy714;
	goto yy50;
yy553:
	YYDEBUG(553, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy714;
	if (yych == 'b') goto yy714;
	goto yy50;
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy714;
	if (yych == 'n') goto yy714;
	goto yy50;
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy714;
		if (yych <= 'M') goto yy50;
		goto yy714;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy50;
			goto yy714;
		} else {
			if (yych == 'n') goto yy714;
			goto yy50;
		}
	}
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy714;
		if (yych <= 'X') goto yy50;
		goto yy714;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy50;
			goto yy714;
		} else {
			if (yych == 'y') goto yy714;
			goto yy50;
		}
	}
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy714;
	if (yych == 'v') goto yy714;
	goto yy50;
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy714;
	if (yych == 't') goto yy714;
	goto yy50;
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy715;
	if (yych == 'p') goto yy715;
	goto yy50;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy716;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy716;
		goto yy16;
	}
yy561:
	YYDEBUG(561, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy282;
	if (yych <= '0') goto yy283;
	if (yych <= '9') goto yy717;
	goto yy282;
yy562:
	YYDEBUG(562, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy282;
	if (yych <= '9') goto yy717;
	goto yy282;
yy563:
	YYDEBUG(563, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy282;
	if (yych <= '1') goto yy717;
	if (yych <= '2') goto yy285;
	if (yych <= '9') goto yy286;
	goto yy282;
yy564:
	YYDEBUG(564, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy121;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy121;
			if (yych == ')') goto yy97;
			goto yy16;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy121;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy716;
			goto yy718;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 't') goto yy718;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 128) {
		goto yy566;
	}
	if (yych == '/') goto yy259;
	if (yych == '_') goto yy259;
	goto yy16;
yy567:
	YYDEBUG(567, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych == '/') goto yy259;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy121;
			if (yych <= 0x1F) goto yy16;
			goto yy121;
		} else {
			if (yych == ')') goto yy97;
			if (yych <= ',') goto yy16;
			goto yy121;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy259;
			if (yych <= '9') goto yy121;
			if (yych <= '@') goto yy16;
			goto yy716;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy16;
				goto yy259;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy719;
				goto yy16;
			}
		}
	}
yy569:
	YYDEBUG(569, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy716;
			goto yy718;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy720;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy716;
			goto yy721;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'b') goto yy721;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy716;
			goto yy721;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'b') goto yy722;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy572:
	YYDEBUG(572, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ': goto yy597;
		case ')': goto yy97;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'U':
		case 'V':
		case 'X':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy716;
		case 'D':
		case 'd': goto yy723;
		case 'F':
		case 'f': goto yy724;
		case 'H':
		case 'h': goto yy725;
		case 'M':
		case 'm': goto yy726;
		case 'S':
		case 's': goto yy727;
		case 'T':
		case 't': goto yy728;
		case 'W':
		case 'w': goto yy729;
		case 'Y':
		case 'y': goto yy730;
		default: goto yy16;
	}
yy573:
	YYDEBUG(573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy716;
			goto yy731;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'n') goto yy731;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ': goto yy597;
		case ')': goto yy97;
		case '/':
		case '_': goto yy259;
		case 'A':
		case 'B':
		case 'C':
		case 'E':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'U':
		case 'V':
		case 'X':
		case 'Z': goto yy716;
		case 'D': goto yy723;
		case 'F': goto yy724;
		case 'H': goto yy725;
		case 'M': goto yy726;
		case 'S': goto yy727;
		case 'T': goto yy728;
		case 'W': goto yy729;
		case 'Y': goto yy730;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy719;
		case 'd': goto yy732;
		case 'f': goto yy733;
		case 'h': goto yy734;
		case 'm': goto yy735;
		case 's': goto yy736;
		case 't': goto yy737;
		case 'w': goto yy738;
		case 'y': goto yy739;
		default: goto yy16;
	}
yy575:
	YYDEBUG(575, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy716;
			goto yy731;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy740;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy741;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy741;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy577:
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy716;
			goto yy742;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'h') goto yy742;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'X') goto yy716;
			goto yy743;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'y') goto yy743;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy579:
	YYDEBUG(579, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			goto yy741;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy744;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy580:
	YYDEBUG(580, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy716;
			goto yy742;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'h') goto yy745;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy581:
	YYDEBUG(581, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'X') goto yy716;
			goto yy743;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'y') goto yy746;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy582:
	YYDEBUG(582, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
		goto yy123;
	} else {
		if (yych <= '9') goto yy747;
		if (yych <= ':') goto yy433;
		goto yy123;
	}
yy583:
	YYDEBUG(583, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy123;
	if (yych <= '9') goto yy747;
	goto yy123;
yy584:
	YYDEBUG(584, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy748;
		goto yy123;
	} else {
		if (yych <= '9') goto yy749;
		if (yych <= ':') goto yy748;
		goto yy123;
	}
yy585:
	YYDEBUG(585, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy748;
		goto yy123;
	} else {
		if (yych <= '3') goto yy749;
		if (yych <= '9') goto yy750;
		if (yych <= ':') goto yy748;
		goto yy123;
	}
yy586:
	YYDEBUG(586, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy748;
		goto yy123;
	} else {
		if (yych <= '9') goto yy750;
		if (yych <= ':') goto yy748;
		goto yy123;
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy748;
		goto yy123;
	} else {
		if (yych <= '9') goto yy583;
		if (yych <= ':') goto yy748;
		goto yy123;
	}
yy588:
	YYDEBUG(588, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy433;
	} else {
		if (yych <= '9') goto yy747;
		if (yych <= ':') goto yy433;
	}
yy589:
	YYDEBUG(589, *YYCURSOR);
#line 1126 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 12340 "real_world/parse_date_db.c"
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy589;
	if (yych <= '9') goto yy747;
	goto yy589;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy751;
	} else {
		if (yych <= '9') goto yy593;
		if (yych <= ':') goto yy751;
	}
yy592:
	YYDEBUG(592, *YYCURSOR);
#line 1384 "real_world/parse_date_db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->f = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 12388 "real_world/parse_date_db.c"
yy593:
	YYDEBUG(593, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy751;
	if (yych == ':') goto yy751;
	goto yy592;
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy589;
	if (yych <= '9') goto yy752;
	goto yy589;
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy716;
			goto yy753;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'r') goto yy753;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy596:
	YYDEBUG(596, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy716;
			goto yy753;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'r') goto yy754;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy597:
	YYDEBUG(597, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 11) YYFILL(11);
	yych = *YYCURSOR;
yy598:
	YYDEBUG(598, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy597;
				if (yych <= 0x1F) goto yy50;
				goto yy597;
			} else {
				if (yych == 'D') goto yy755;
				if (yych <= 'E') goto yy50;
				goto yy756;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy757;
				if (yych <= 'L') goto yy50;
				goto yy758;
			} else {
				if (yych <= 'S') {
					if (yych <= 'R') goto yy50;
					goto yy759;
				} else {
					if (yych <= 'T') goto yy760;
					if (yych <= 'V') goto yy50;
					goto yy761;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy762;
				if (yych <= 'c') goto yy50;
				goto yy755;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy50;
					goto yy756;
				} else {
					if (yych == 'h') goto yy757;
					goto yy50;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy758;
				if (yych <= 'r') goto yy50;
				if (yych <= 's') goto yy759;
				goto yy760;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy50;
					goto yy761;
				} else {
					if (yych == 'y') goto yy762;
					goto yy50;
				}
			}
		}
	}
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy763;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy763;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'O') goto yy764;
			if (yych <= 'Q') goto yy716;
			goto yy765;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			if (yych <= 'n') goto yy716;
			goto yy764;
		} else {
			if (yych == 'r') goto yy765;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy601:
	YYDEBUG(601, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy716;
			goto yy766;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'o') goto yy766;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'I') goto yy767;
			if (yych <= 'N') goto yy716;
			goto yy768;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy716;
			goto yy767;
		} else {
			if (yych == 'o') goto yy768;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'A') {
			if (yych == ')') goto yy97;
			if (yych <= '@') goto yy16;
			goto yy769;
		} else {
			if (yych == 'E') goto yy770;
			if (yych <= 'T') goto yy716;
			goto yy771;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy769;
			goto yy716;
		} else {
			if (yych <= 't') {
				if (yych <= 'e') goto yy770;
				goto yy716;
			} else {
				if (yych <= 'u') goto yy771;
				if (yych <= 'z') goto yy716;
				goto yy16;
			}
		}
	}
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych == 'H') goto yy772;
			if (yych <= 'T') goto yy716;
			goto yy773;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			if (yych <= 'g') goto yy716;
			goto yy772;
		} else {
			if (yych == 'u') goto yy773;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy605:
	YYDEBUG(605, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy716;
			goto yy774;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'e') goto yy774;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy606:
	YYDEBUG(606, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy716;
			goto yy775;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'e') goto yy775;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy607:
	YYDEBUG(607, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			goto yy763;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy776;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych <= 'N') {
				if (yych <= '@') goto yy16;
				goto yy716;
			} else {
				if (yych <= 'O') goto yy764;
				if (yych <= 'Q') goto yy716;
				goto yy765;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy716;
				goto yy16;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy719;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= 'o') goto yy777;
				goto yy719;
			} else {
				if (yych <= 'r') goto yy778;
				if (yych <= 'z') goto yy719;
				goto yy16;
			}
		}
	}
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy716;
			goto yy766;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'o') goto yy779;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy610:
	YYDEBUG(610, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych <= 'H') {
				if (yych <= '@') goto yy16;
				goto yy716;
			} else {
				if (yych <= 'I') goto yy767;
				if (yych <= 'N') goto yy716;
				goto yy768;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy716;
				goto yy16;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy719;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy780;
				goto yy719;
			} else {
				if (yych <= 'o') goto yy781;
				if (yych <= 'z') goto yy719;
				goto yy16;
			}
		}
	}
yy611:
	YYDEBUG(611, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych == '/') goto yy259;
				goto yy16;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= 'A') goto yy769;
				goto yy716;
			} else {
				if (yych <= 'E') goto yy770;
				if (yych <= 'T') goto yy716;
				goto yy771;
			}
		}
	} else {
		if (yych <= 'a') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy716;
				goto yy16;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy782;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'e') goto yy783;
				goto yy719;
			} else {
				if (yych <= 'u') goto yy784;
				if (yych <= 'z') goto yy719;
				goto yy16;
			}
		}
	}
yy612:
	YYDEBUG(612, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych <= 'G') {
				if (yych <= '@') goto yy16;
				goto yy716;
			} else {
				if (yych <= 'H') goto yy772;
				if (yych <= 'T') goto yy716;
				goto yy773;
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= '^') {
				if (yych <= 'Z') goto yy716;
				goto yy16;
			} else {
				if (yych <= '_') goto yy259;
				if (yych <= '`') goto yy16;
				goto yy719;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'h') goto yy785;
				goto yy719;
			} else {
				if (yych <= 'u') goto yy786;
				if (yych <= 'z') goto yy719;
				goto yy16;
			}
		}
	}
yy613:
	YYDEBUG(613, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy716;
			goto yy774;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy787;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy614:
	YYDEBUG(614, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy716;
			goto yy775;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy788;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy716;
			goto yy789;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'g') goto yy789;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy616:
	YYDEBUG(616, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy716;
			goto yy789;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'g') goto yy790;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy617:
	YYDEBUG(617, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy716;
			goto yy791;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'e') goto yy791;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy618:
	YYDEBUG(618, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy716;
			goto yy791;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy792;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy716;
			goto yy793;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'o') goto yy793;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy716;
			goto yy793;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'o') goto yy794;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy621:
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy716;
			goto yy795;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'd') goto yy795;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy716;
			goto yy742;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'd') goto yy742;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'L') goto yy716;
			goto yy796;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'm') goto yy796;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy716;
			goto yy797;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 't') goto yy797;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy625:
	YYDEBUG(625, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy716;
			goto yy795;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'd') goto yy798;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy626:
	YYDEBUG(626, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy716;
			goto yy742;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'd') goto yy745;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'L') goto yy716;
			goto yy796;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'm') goto yy799;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy716;
			goto yy797;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy800;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy360;
	if (yych <= '5') goto yy801;
	if (yych <= '6') goto yy802;
	goto yy360;
yy630:
	YYDEBUG(630, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy97;
	} else {
		if (yych <= 'Z') goto yy716;
		if (yych <= '`') goto yy631;
		if (yych <= 'z') goto yy716;
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
#line 904 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 13333 "real_world/parse_date_db.c"
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy716;
			goto yy803;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'r') goto yy803;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		if (yych <= '@') goto yy16;
		goto yy804;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy804;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy631;
			goto yy97;
		} else {
			if (yych == '/') goto yy259;
			goto yy631;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '^') goto yy631;
			goto yy259;
		} else {
			if (yych <= '`') goto yy631;
			if (yych <= 'z') goto yy719;
			goto yy631;
		}
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy716;
			goto yy803;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'r') goto yy805;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy636:
	YYDEBUG(636, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			goto yy804;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy806;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy637:
	YYDEBUG(637, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy716;
			goto yy807;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 's') goto yy807;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy716;
			goto yy807;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 's') goto yy808;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy716;
			goto yy809;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy716;
			if (yych <= '`') goto yy16;
			goto yy716;
		} else {
			if (yych <= 'r') goto yy809;
			if (yych <= 'z') goto yy716;
			goto yy16;
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy716;
			goto yy809;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy716;
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'r') goto yy810;
			if (yych <= 'z') goto yy719;
			goto yy16;
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy482;
	if (yych <= '9') goto yy811;
	goto yy482;
yy642:
	YYDEBUG(642, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy484;
		if (yych <= '9') goto yy811;
		if (yych <= 'm') goto yy484;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy484;
		} else {
			if (yych <= 's') goto yy644;
			if (yych <= 't') goto yy645;
			goto yy484;
		}
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy812;
	goto yy50;
yy644:
	YYDEBUG(644, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy812;
	goto yy50;
yy645:
	YYDEBUG(645, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy812;
	goto yy50;
yy646:
	YYDEBUG(646, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy813;
	goto yy50;
yy647:
	YYDEBUG(647, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy646;
	if (yych <= '/') goto yy194;
	if (yych <= '9') goto yy811;
	goto yy194;
yy648:
	YYDEBUG(648, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy814;
	goto yy199;
yy649:
	YYDEBUG(649, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy815;
	goto yy50;
yy650:
	YYDEBUG(650, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy651:
	YYDEBUG(651, *YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ':
		case '-':
		case '.': goto yy650;
		case 'A':
		case 'a': goto yy509;
		case 'D':
		case 'd': goto yy666;
		case 'F':
		case 'f': goto yy667;
		case 'I': goto yy512;
		case 'J':
		case 'j': goto yy514;
		case 'M':
		case 'm': goto yy668;
		case 'N':
		case 'n': goto yy516;
		case 'O':
		case 'o': goto yy517;
		case 'S':
		case 's': goto yy669;
		case 'V': goto yy519;
		case 'X': goto yy521;
		default: goto yy50;
	}
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy816;
		goto yy50;
	} else {
		if (yych <= '0') goto yy654;
		if (yych <= '9') goto yy817;
		goto yy50;
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy816;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy817;
	goto yy50;
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy816;
	goto yy50;
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy818;
		if (yych <= 'T') goto yy50;
		goto yy819;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy50;
			goto yy818;
		} else {
			if (yych == 'u') goto yy819;
			goto yy50;
		}
	}
yy656:
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy820;
	if (yych == 'e') goto yy820;
	goto yy50;
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy821;
	if (yych == 'e') goto yy821;
	goto yy50;
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy822;
		if (yych <= 'T') goto yy50;
		goto yy823;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy50;
			goto yy822;
		} else {
			if (yych == 'u') goto yy823;
			goto yy50;
		}
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy824;
	if (yych == 'a') goto yy824;
	goto yy50;
yy660:
	YYDEBUG(660, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy825;
	if (yych == 'o') goto yy825;
	goto yy50;
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy826;
	if (yych == 'c') goto yy826;
	goto yy50;
yy662:
	YYDEBUG(662, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy827;
	if (yych == 'e') goto yy827;
	goto yy50;
yy663:
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy828;
	if (yych <= '9') goto yy829;
	goto yy50;
yy664:
	YYDEBUG(664, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy829;
	goto yy50;
yy665:
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy829;
	if (yych <= '6') goto yy830;
	goto yy50;
yy666:
	YYDEBUG(666, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy683;
	if (yych == 'e') goto yy683;
	goto yy50;
yy667:
	YYDEBUG(667, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy684;
	if (yych == 'e') goto yy684;
	goto yy50;
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy689;
	if (yych == 'a') goto yy689;
	goto yy50;
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy831;
	if (yych == 'e') goto yy831;
	goto yy50;
yy670:
	YYDEBUG(670, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy50;
	if (yych <= '/') goto yy832;
	if (yych <= '0') goto yy672;
	if (yych <= '9') goto yy833;
	goto yy50;
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy50;
	if (yych <= '/') goto yy832;
	if (yych <= '2') goto yy833;
	goto yy50;
yy672:
	YYDEBUG(672, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy832;
	goto yy50;
yy673:
	YYDEBUG(673, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych >= ' ') goto yy173;
			} else {
				if (yych <= '0') {
					if (yych >= '0') goto yy51;
				} else {
					if (yych <= '9') goto yy834;
					if (yych >= 'D') goto yy173;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy173;
				if (yych >= 'H') goto yy173;
			} else {
				if (yych <= 'M') {
					if (yych >= 'M') goto yy173;
				} else {
					if (yych <= 'R') goto yy674;
					if (yych <= 'T') goto yy173;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy674;
				if (yych <= 'Y') goto yy173;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy173;
				} else {
					if (yych != 'g') goto yy173;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych >= 's') goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy173;
				} else {
					if (yych == 'y') goto yy173;
				}
			}
		}
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
#line 1039 "real_world/parse_date_db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
			if (tz_not_found) {
				add_error(s, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 13871 "real_world/parse_date_db.c"
yy675:
	YYDEBUG(675, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '9') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy674;
				goto yy173;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy674;
					goto yy836;
				} else {
					if (yych <= '2') goto yy837;
					if (yych <= '3') goto yy838;
					goto yy834;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy674;
					goto yy173;
				} else {
					if (yych == 'F') goto yy173;
					goto yy674;
				}
			} else {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy173;
					goto yy674;
				} else {
					if (yych <= 'M') goto yy173;
					if (yych <= 'R') goto yy674;
					goto yy173;
				}
			}
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Y') {
				if (yych == 'W') goto yy173;
				if (yych <= 'X') goto yy674;
				goto yy173;
			} else {
				if (yych <= 'd') {
					if (yych <= 'c') goto yy674;
					goto yy173;
				} else {
					if (yych == 'f') goto yy173;
					goto yy674;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'l') {
					if (yych <= 'h') goto yy173;
					goto yy674;
				} else {
					if (yych <= 'm') goto yy173;
					if (yych <= 'r') goto yy674;
					goto yy173;
				}
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy674;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy674;
				}
			}
		}
	}
yy676:
	YYDEBUG(676, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy674;
				goto yy173;
			} else {
				if (yych <= '/') goto yy674;
				if (yych <= '9') goto yy834;
				if (yych <= 'C') goto yy674;
				goto yy173;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy173;
				if (yych <= 'G') goto yy674;
				goto yy173;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy674;
					goto yy173;
				} else {
					if (yych <= 'R') goto yy674;
					if (yych <= 'T') goto yy173;
					goto yy674;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy674;
				if (yych <= 'Y') goto yy173;
				goto yy674;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy173;
					goto yy674;
				} else {
					if (yych == 'g') goto yy674;
					goto yy173;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych <= 'r') goto yy674;
				goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy674;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy674;
				}
			}
		}
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy674;
				goto yy173;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy674;
					goto yy834;
				} else {
					if (yych <= '9') goto yy51;
					if (yych <= 'C') goto yy674;
					goto yy173;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy173;
				if (yych <= 'G') goto yy674;
				goto yy173;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy674;
					goto yy173;
				} else {
					if (yych <= 'R') goto yy674;
					if (yych <= 'T') goto yy173;
					goto yy674;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy674;
				if (yych <= 'Y') goto yy173;
				goto yy674;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy173;
					goto yy674;
				} else {
					if (yych == 'g') goto yy674;
					goto yy173;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych <= 'r') goto yy674;
				goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy674;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy674;
				}
			}
		}
	}
yy678:
	YYDEBUG(678, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy674;
				goto yy173;
			} else {
				if (yych == 'D') goto yy173;
				if (yych <= 'E') goto yy674;
				goto yy173;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy173;
				if (yych <= 'L') goto yy674;
				goto yy173;
			} else {
				if (yych <= 'R') goto yy674;
				if (yych <= 'T') goto yy173;
				if (yych <= 'V') goto yy674;
				goto yy173;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy173;
				if (yych <= 'c') goto yy674;
				goto yy173;
			} else {
				if (yych == 'f') goto yy173;
				if (yych <= 'g') goto yy674;
				goto yy173;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych <= 'r') goto yy674;
				goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy674;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy674;
				}
			}
		}
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych <= '9') goto yy839;
	goto yy50;
yy680:
	YYDEBUG(680, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy839;
	goto yy50;
yy681:
	YYDEBUG(681, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy840;
	if (yych == 'r') goto yy840;
	goto yy50;
yy682:
	YYDEBUG(682, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy841;
	if (yych == 'g') goto yy841;
	goto yy50;
yy683:
	YYDEBUG(683, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy842;
	if (yych == 'c') goto yy842;
	goto yy50;
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy843;
	if (yych == 'b') goto yy843;
	goto yy50;
yy685:
	YYDEBUG(685, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy513;
yy686:
	YYDEBUG(686, *YYCURSOR);
	++YYCURSOR;
	goto yy513;
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy844;
	if (yych == 'n') goto yy844;
	goto yy50;
yy688:
	YYDEBUG(688, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy845;
		if (yych <= 'M') goto yy50;
		goto yy846;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy50;
			goto yy845;
		} else {
			if (yych == 'n') goto yy846;
			goto yy50;
		}
	}
yy689:
	YYDEBUG(689, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy847;
		if (yych <= 'X') goto yy50;
		goto yy686;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy50;
			goto yy847;
		} else {
			if (yych == 'y') goto yy686;
			goto yy50;
		}
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy842;
	if (yych == 'v') goto yy842;
	goto yy50;
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy848;
	if (yych == 't') goto yy848;
	goto yy50;
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy381;
		if (yych <= 'O') goto yy50;
		goto yy849;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy50;
			goto yy381;
		} else {
			if (yych == 'p') goto yy849;
			goto yy50;
		}
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych <= '9') goto yy850;
	goto yy50;
yy694:
	YYDEBUG(694, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy850;
	goto yy50;
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy850;
	goto yy50;
yy696:
	YYDEBUG(696, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '0') goto yy51;
	if (yych <= '9') goto yy834;
	goto yy173;
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy173;
		if (yych <= '0') goto yy836;
		goto yy837;
	} else {
		if (yych <= '3') goto yy838;
		if (yych <= '9') goto yy834;
		goto yy173;
	}
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '9') goto yy834;
	goto yy173;
yy699:
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy173;
	if (yych <= '6') goto yy834;
	if (yych <= '9') goto yy51;
	goto yy173;
yy700:
	YYDEBUG(700, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy226;
	if (yych == 't') goto yy226;
	goto yy50;
yy701:
	YYDEBUG(701, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy702;
	if (yych != 'n') goto yy50;
yy702:
	YYDEBUG(702, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy852;
	if (yych == 'i') goto yy852;
	goto yy50;
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy528;
	if (yych == 'y') goto yy528;
	goto yy50;
yy704:
	YYDEBUG(704, *YYCURSOR);
	++YYCURSOR;
	goto yy224;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy853;
	if (yych == 'r') goto yy853;
	goto yy50;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy365;
	if (yych == 'e') goto yy365;
	goto yy50;
yy707:
	YYDEBUG(707, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy854;
	if (yych == 'e') goto yy854;
	goto yy50;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy365;
	if (yych == 'd') goto yy365;
	goto yy50;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy546;
			if (yych <= 0x1F) goto yy194;
			goto yy546;
		} else {
			if (yych == '.') goto yy646;
			if (yych <= '/') goto yy194;
			goto yy811;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy91;
			if (yych <= 'O') goto yy194;
			goto yy91;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy194;
				goto yy91;
			} else {
				if (yych == 'p') goto yy91;
				goto yy194;
			}
		}
	}
yy710:
	YYDEBUG(710, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy546;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy546;
			if (yych == '.') goto yy646;
			goto yy194;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy91;
			if (yych == 'P') goto yy91;
			goto yy194;
		} else {
			if (yych <= 'a') goto yy91;
			if (yych == 'p') goto yy91;
			goto yy194;
		}
	}
yy711:
	YYDEBUG(711, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy484;
		if (yych <= '9') goto yy713;
		if (yych <= 'm') goto yy484;
		goto yy643;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy484;
			goto yy643;
		} else {
			if (yych <= 's') goto yy644;
			if (yych <= 't') goto yy645;
			goto yy484;
		}
	}
yy712:
	YYDEBUG(712, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy484;
		if (yych <= '1') goto yy713;
		if (yych <= 'm') goto yy484;
		goto yy643;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy484;
			goto yy643;
		} else {
			if (yych <= 's') goto yy644;
			if (yych <= 't') goto yy645;
			goto yy484;
		}
	}
yy713:
	YYDEBUG(713, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy643;
		goto yy484;
	} else {
		if (yych <= 'r') goto yy643;
		if (yych <= 's') goto yy644;
		if (yych <= 't') goto yy645;
		goto yy484;
	}
yy714:
	YYDEBUG(714, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy855;
	goto yy50;
yy715:
	YYDEBUG(715, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy855;
		goto yy50;
	} else {
		if (yych <= 'T') goto yy714;
		if (yych == 't') goto yy714;
		goto yy50;
	}
yy716:
	YYDEBUG(716, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy97;
	goto yy16;
yy717:
	YYDEBUG(717, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '-': goto yy856;
		case '.': goto yy429;
		case '0':
		case '1': goto yy430;
		case '2': goto yy431;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy432;
		case ':': goto yy433;
		default: goto yy282;
	}
yy718:
	YYDEBUG(718, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy16;
			goto yy121;
		} else {
			if (yych == ' ') goto yy121;
			goto yy16;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy97;
			if (yych <= ',') goto yy16;
			goto yy121;
		} else {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy121;
			goto yy16;
		}
	}
yy719:
	YYDEBUG(719, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy97;
		if (yych <= '.') goto yy16;
		goto yy259;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy16;
			goto yy259;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy720:
	YYDEBUG(720, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy121;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy121;
			if (yych == ')') goto yy97;
			goto yy16;
		}
	} else {
		if (yych <= '^') {
			if (yych == '/') goto yy259;
			if (yych <= '9') goto yy121;
			goto yy16;
		} else {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy721:
	YYDEBUG(721, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'E') goto yy859;
		if (yych == 'e') goto yy859;
		goto yy16;
	}
yy722:
	YYDEBUG(722, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'D') goto yy16;
			goto yy859;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy860;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy723:
	YYDEBUG(723, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'A') goto yy861;
		if (yych == 'a') goto yy861;
		goto yy16;
	}
yy724:
	YYDEBUG(724, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych == 'O') goto yy862;
			goto yy16;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'R') goto yy863;
			if (yych <= 'n') goto yy16;
			goto yy862;
		} else {
			if (yych == 'r') goto yy863;
			goto yy16;
		}
	}
yy725:
	YYDEBUG(725, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'O') goto yy864;
		if (yych == 'o') goto yy864;
		goto yy16;
	}
yy726:
	YYDEBUG(726, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych == 'I') goto yy865;
			goto yy16;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'O') goto yy866;
			if (yych <= 'h') goto yy16;
			goto yy865;
		} else {
			if (yych == 'o') goto yy866;
			goto yy16;
		}
	}
yy727:
	YYDEBUG(727, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '@') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= 'A') goto yy867;
			if (yych == 'E') goto yy868;
			goto yy16;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'U') goto yy869;
			if (yych == 'a') goto yy867;
			goto yy16;
		} else {
			if (yych <= 'e') goto yy868;
			if (yych == 'u') goto yy869;
			goto yy16;
		}
	}
yy728:
	YYDEBUG(728, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy97;
		} else {
			if (yych == 'H') goto yy870;
			goto yy16;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'U') goto yy871;
			if (yych <= 'g') goto yy16;
			goto yy870;
		} else {
			if (yych == 'u') goto yy871;
			goto yy16;
		}
	}
yy729:
	YYDEBUG(729, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'E') goto yy872;
		if (yych == 'e') goto yy872;
		goto yy16;
	}
yy730:
	YYDEBUG(730, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'E') goto yy873;
		if (yych == 'e') goto yy873;
		goto yy16;
	}
yy731:
	YYDEBUG(731, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'T') goto yy874;
		if (yych == 't') goto yy874;
		goto yy16;
	}
yy732:
	YYDEBUG(732, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			goto yy861;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy875;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy733:
	YYDEBUG(733, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych == 'O') goto yy862;
			if (yych <= 'Q') goto yy16;
			goto yy863;
		}
	} else {
		if (yych <= 'n') {
			if (yych == '_') goto yy259;
			if (yych <= '`') goto yy16;
			goto yy857;
		} else {
			if (yych <= 'q') {
				if (yych <= 'o') goto yy876;
				goto yy857;
			} else {
				if (yych <= 'r') goto yy877;
				if (yych <= 'z') goto yy857;
				goto yy16;
			}
		}
	}
yy734:
	YYDEBUG(734, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'N') goto yy16;
			goto yy864;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'o') goto yy878;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy735:
	YYDEBUG(735, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych == 'I') goto yy865;
			if (yych <= 'N') goto yy16;
			goto yy866;
		}
	} else {
		if (yych <= 'h') {
			if (yych == '_') goto yy259;
			if (yych <= '`') goto yy16;
			goto yy857;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy879;
				goto yy857;
			} else {
				if (yych <= 'o') goto yy880;
				if (yych <= 'z') goto yy857;
				goto yy16;
			}
		}
	}
yy736:
	YYDEBUG(736, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy97;
			} else {
				if (yych == '/') goto yy259;
				goto yy16;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= 'A') goto yy867;
				goto yy16;
			} else {
				if (yych <= 'E') goto yy868;
				if (yych <= 'T') goto yy16;
				goto yy869;
			}
		}
	} else {
		if (yych <= 'd') {
			if (yych <= '_') {
				if (yych <= '^') goto yy16;
				goto yy259;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'a') goto yy881;
				goto yy857;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'e') goto yy882;
				goto yy857;
			} else {
				if (yych <= 'u') goto yy883;
				if (yych <= 'z') goto yy857;
				goto yy16;
			}
		}
	}
yy737:
	YYDEBUG(737, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych == ')') goto yy97;
			if (yych <= '.') goto yy16;
			goto yy259;
		} else {
			if (yych == 'H') goto yy870;
			if (yych <= 'T') goto yy16;
			goto yy871;
		}
	} else {
		if (yych <= 'g') {
			if (yych == '_') goto yy259;
			if (yych <= '`') goto yy16;
			goto yy857;
		} else {
			if (yych <= 't') {
				if (yych <= 'h') goto yy884;
				goto yy857;
			} else {
				if (yych <= 'u') goto yy885;
				if (yych <= 'z') goto yy857;
				goto yy16;
			}
		}
	}
yy738:
	YYDEBUG(738, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'D') goto yy16;
			goto yy872;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy886;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy739:
	YYDEBUG(739, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'D') goto yy16;
			goto yy873;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy887;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy740:
	YYDEBUG(740, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'S') goto yy16;
			goto yy874;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy888;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'R') goto yy889;
		if (yych == 'r') goto yy889;
		goto yy16;
	}
yy742:
	YYDEBUG(742, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy598;
				if (yych <= 0x1F) goto yy16;
				goto yy598;
			} else {
				if (yych == ')') goto yy97;
				if (yych <= 'C') goto yy16;
				goto yy598;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy598;
				if (yych <= 'G') goto yy16;
				goto yy598;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy16;
					goto yy598;
				} else {
					if (yych <= 'R') goto yy16;
					if (yych <= 'T') goto yy598;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy16;
				if (yych <= 'Y') goto yy598;
				goto yy16;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy598;
					goto yy16;
				} else {
					if (yych == 'g') goto yy16;
					goto yy598;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy598;
				if (yych <= 'r') goto yy16;
				goto yy598;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy16;
					goto yy598;
				} else {
					if (yych == 'y') goto yy598;
					goto yy16;
				}
			}
		}
	}
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy97;
	goto yy275;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'Q') goto yy16;
			goto yy889;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'r') goto yy890;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy745:
	YYDEBUG(745, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ':
		case 'D':
		case 'F':
		case 'H':
		case 'M':
		case 'S':
		case 'T':
		case 'W':
		case 'Y': goto yy598;
		case ')': goto yy97;
		case '/':
		case '_': goto yy259;
		case 'a':
		case 'b':
		case 'c':
		case 'e':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy857;
		case 'd': goto yy891;
		case 'f': goto yy892;
		case 'h': goto yy893;
		case 'm': goto yy894;
		case 's': goto yy895;
		case 't': goto yy896;
		case 'w': goto yy897;
		case 'y': goto yy898;
		default: goto yy16;
	}
yy746:
	YYDEBUG(746, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy97;
		if (yych <= '.') goto yy275;
		goto yy259;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy275;
			goto yy259;
		} else {
			if (yych <= '`') goto yy275;
			if (yych <= 'z') goto yy857;
			goto yy275;
		}
	}
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy123;
	if (yych <= '9') goto yy752;
	goto yy123;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy899;
	if (yych <= '6') goto yy900;
	if (yych <= '9') goto yy593;
	goto yy50;
yy749:
	YYDEBUG(749, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy748;
		goto yy123;
	} else {
		if (yych <= '9') goto yy747;
		if (yych <= ':') goto yy748;
		goto yy123;
	}
yy750:
	YYDEBUG(750, *YYCURSOR);
	yyaccept = 4;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych != '.') goto yy123;
	} else {
		if (yych <= '9') goto yy747;
		if (yych >= ';') goto yy123;
	}
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy901;
	if (yych <= '6') goto yy902;
	if (yych <= '9') goto yy903;
	goto yy50;
yy752:
	YYDEBUG(752, *YYCURSOR);
	++YYCURSOR;
	goto yy123;
yy753:
	YYDEBUG(753, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Y') goto yy120;
		if (yych == 'y') goto yy120;
		goto yy16;
	}
yy754:
	YYDEBUG(754, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'X') goto yy16;
			goto yy120;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'y') goto yy904;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy861;
	if (yych == 'a') goto yy861;
	goto yy50;
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy862;
		if (yych <= 'Q') goto yy50;
		goto yy863;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy50;
			goto yy862;
		} else {
			if (yych == 'r') goto yy863;
			goto yy50;
		}
	}
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy864;
	if (yych == 'o') goto yy864;
	goto yy50;
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy865;
		if (yych <= 'N') goto yy50;
		goto yy866;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy50;
			goto yy865;
		} else {
			if (yych == 'o') goto yy866;
			goto yy50;
		}
	}
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy867;
			goto yy50;
		} else {
			if (yych <= 'E') goto yy868;
			if (yych <= 'T') goto yy50;
			goto yy869;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy867;
			goto yy50;
		} else {
			if (yych <= 'e') goto yy868;
			if (yych == 'u') goto yy869;
			goto yy50;
		}
	}
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy870;
		if (yych <= 'T') goto yy50;
		goto yy871;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy50;
			goto yy870;
		} else {
			if (yych == 'u') goto yy871;
			goto yy50;
		}
	}
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy872;
	if (yych == 'e') goto yy872;
	goto yy50;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy873;
	if (yych == 'e') goto yy873;
	goto yy50;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Y') goto yy905;
		if (yych == 'y') goto yy905;
		goto yy16;
	}
yy764:
	YYDEBUG(764, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'R') goto yy907;
		if (yych == 'r') goto yy907;
		goto yy16;
	}
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'I') goto yy908;
		if (yych == 'i') goto yy908;
		goto yy16;
	}
yy766:
	YYDEBUG(766, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'U') goto yy909;
		if (yych == 'u') goto yy909;
		goto yy16;
	}
yy767:
	YYDEBUG(767, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'N') goto yy910;
		if (yych == 'n') goto yy910;
		goto yy16;
	}
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'N') goto yy911;
		if (yych == 'n') goto yy911;
		goto yy16;
	}
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'T') goto yy912;
		if (yych == 't') goto yy912;
		goto yy16;
	}
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'C') goto yy913;
		if (yych == 'c') goto yy913;
		goto yy16;
	}
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'N') goto yy908;
		if (yych == 'n') goto yy908;
		goto yy16;
	}
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'U') goto yy914;
		if (yych == 'u') goto yy914;
		goto yy16;
	}
yy773:
	YYDEBUG(773, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'E') goto yy915;
		if (yych == 'e') goto yy915;
		goto yy16;
	}
yy774:
	YYDEBUG(774, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy97;
		if (yych <= 'C') goto yy16;
		goto yy916;
	} else {
		if (yych <= 'c') {
			if (yych <= 'E') goto yy917;
			goto yy16;
		} else {
			if (yych <= 'd') goto yy916;
			if (yych <= 'e') goto yy917;
			goto yy16;
		}
	}
yy775:
	YYDEBUG(775, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'A') goto yy909;
		if (yych == 'a') goto yy909;
		goto yy16;
	}
yy776:
	YYDEBUG(776, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'X') goto yy16;
			goto yy905;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'y') goto yy918;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy777:
	YYDEBUG(777, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'Q') goto yy16;
			goto yy907;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'r') goto yy919;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy778:
	YYDEBUG(778, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'I') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'H') goto yy16;
			goto yy908;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'i') goto yy920;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy779:
	YYDEBUG(779, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'T') goto yy16;
			goto yy909;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'u') goto yy921;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy780:
	YYDEBUG(780, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'M') goto yy16;
			goto yy910;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy922;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy781:
	YYDEBUG(781, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'M') goto yy16;
			goto yy911;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy923;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy782:
	YYDEBUG(782, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'S') goto yy16;
			goto yy912;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 't') goto yy924;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy783:
	YYDEBUG(783, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'B') goto yy16;
			goto yy913;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'c') goto yy925;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy784:
	YYDEBUG(784, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'M') goto yy16;
			goto yy908;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'n') goto yy920;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy785:
	YYDEBUG(785, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'T') goto yy16;
			goto yy914;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'u') goto yy926;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'D') goto yy16;
			goto yy915;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'e') goto yy927;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy787:
	YYDEBUG(787, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'C') goto yy16;
			if (yych <= 'D') goto yy916;
			goto yy917;
		}
	} else {
		if (yych <= 'c') {
			if (yych == '_') goto yy259;
			if (yych <= '`') goto yy16;
			goto yy857;
		} else {
			if (yych <= 'd') goto yy928;
			if (yych <= 'e') goto yy929;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy788:
	YYDEBUG(788, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			goto yy909;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy921;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy789:
	YYDEBUG(789, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'H') goto yy930;
		if (yych == 'h') goto yy930;
		goto yy16;
	}
yy790:
	YYDEBUG(790, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'G') goto yy16;
			goto yy930;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'h') goto yy931;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'R') goto yy120;
		if (yych == 'r') goto yy120;
		goto yy16;
	}
yy792:
	YYDEBUG(792, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'Q') goto yy16;
			goto yy120;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'r') goto yy904;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy793:
	YYDEBUG(793, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'U') goto yy932;
		if (yych == 'u') goto yy932;
		goto yy16;
	}
yy794:
	YYDEBUG(794, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'T') goto yy16;
			goto yy932;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'u') goto yy933;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy795:
	YYDEBUG(795, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'A') goto yy934;
		if (yych == 'a') goto yy934;
		goto yy16;
	}
yy796:
	YYDEBUG(796, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'B') goto yy935;
		if (yych == 'b') goto yy935;
		goto yy16;
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'H') goto yy597;
		if (yych == 'h') goto yy597;
		goto yy16;
	}
yy798:
	YYDEBUG(798, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= '@') goto yy16;
			goto yy934;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy936;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'A') goto yy16;
			goto yy935;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'b') goto yy937;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy800:
	YYDEBUG(800, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'G') goto yy16;
			goto yy597;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'h') goto yy938;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy801:
	YYDEBUG(801, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy939;
	goto yy50;
yy802:
	YYDEBUG(802, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy939;
	goto yy50;
yy803:
	YYDEBUG(803, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'O') goto yy940;
		if (yych == 'o') goto yy940;
		goto yy16;
	}
yy804:
	YYDEBUG(804, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'Y') goto yy941;
		if (yych == 'y') goto yy941;
		goto yy16;
	}
yy805:
	YYDEBUG(805, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'N') goto yy16;
			goto yy940;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'o') goto yy942;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy806:
	YYDEBUG(806, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Y') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'X') goto yy16;
			goto yy941;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'y') goto yy943;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy807:
	YYDEBUG(807, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'D') goto yy944;
		if (yych == 'd') goto yy944;
		goto yy16;
	}
yy808:
	YYDEBUG(808, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'C') goto yy16;
			goto yy944;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'd') goto yy945;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy809:
	YYDEBUG(809, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy97;
		goto yy16;
	} else {
		if (yych <= 'D') goto yy946;
		if (yych == 'd') goto yy946;
		goto yy16;
	}
yy810:
	YYDEBUG(810, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '.') {
			if (yych == ')') goto yy97;
			goto yy16;
		} else {
			if (yych <= '/') goto yy259;
			if (yych <= 'C') goto yy16;
			goto yy946;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy259;
			goto yy16;
		} else {
			if (yych == 'd') goto yy947;
			if (yych <= 'z') goto yy857;
			goto yy16;
		}
	}
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy482;
	if (yych <= '9') goto yy948;
	goto yy482;
yy812:
	YYDEBUG(812, *YYCURSOR);
	++YYCURSOR;
	goto yy484;
yy813:
	YYDEBUG(813, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy194;
	if (yych <= '9') goto yy813;
	goto yy194;
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy199;
	if (yych <= '9') goto yy949;
	goto yy199;
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy950;
	goto yy50;
yy816:
	YYDEBUG(816, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy951;
	if (yych <= '3') goto yy952;
	if (yych <= '9') goto yy953;
	goto yy50;
yy817:
	YYDEBUG(817, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy954;
	goto yy50;
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy955;
	if (yych == 'r') goto yy955;
	goto yy50;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy956;
	if (yych == 'g') goto yy956;
	goto yy50;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy957;
	if (yych == 'c') goto yy957;
	goto yy50;
yy821:
	YYDEBUG(821, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy958;
	if (yych == 'b') goto yy958;
	goto yy50;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy959;
	if (yych == 'n') goto yy959;
	goto yy50;
yy823:
	YYDEBUG(823, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy960;
		if (yych <= 'M') goto yy50;
		goto yy961;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy50;
			goto yy960;
		} else {
			if (yych == 'n') goto yy961;
			goto yy50;
		}
	}
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy962;
		if (yych <= 'X') goto yy50;
		goto yy963;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy50;
			goto yy962;
		} else {
			if (yych == 'y') goto yy963;
			goto yy50;
		}
	}
yy825:
	YYDEBUG(825, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy957;
	if (yych == 'v') goto yy957;
	goto yy50;
yy826:
	YYDEBUG(826, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy964;
	if (yych == 't') goto yy964;
	goto yy50;
yy827:
	YYDEBUG(827, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy965;
	if (yych == 'p') goto yy965;
	goto yy50;
yy828:
	YYDEBUG(828, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych <= '9') goto yy966;
	goto yy50;
yy829:
	YYDEBUG(829, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy966;
	goto yy50;
yy830:
	YYDEBUG(830, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '6') goto yy966;
	goto yy50;
yy831:
	YYDEBUG(831, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy849;
	if (yych == 'p') goto yy849;
	goto yy50;
yy832:
	YYDEBUG(832, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '2') goto yy967;
	if (yych <= '3') goto yy969;
	if (yych <= '9') goto yy970;
	goto yy50;
yy833:
	YYDEBUG(833, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy971;
	goto yy50;
yy834:
	YYDEBUG(834, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych >= ' ') goto yy173;
			} else {
				if (yych == 'D') goto yy173;
				if (yych >= 'F') goto yy173;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy173;
				if (yych >= 'M') goto yy173;
			} else {
				if (yych <= 'R') goto yy835;
				if (yych <= 'T') goto yy173;
				if (yych >= 'W') goto yy173;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy173;
				if (yych >= 'd') goto yy173;
			} else {
				if (yych == 'f') goto yy173;
				if (yych >= 'h') goto yy173;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych >= 's') goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy173;
				} else {
					if (yych == 'y') goto yy173;
				}
			}
		}
	}
yy835:
	YYDEBUG(835, *YYCURSOR);
#line 1215 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 16371 "real_world/parse_date_db.c"
yy836:
	YYDEBUG(836, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy835;
				goto yy173;
			} else {
				if (yych <= '0') {
					if (yych <= '/') goto yy835;
					goto yy51;
				} else {
					if (yych <= '9') goto yy972;
					if (yych <= 'C') goto yy835;
					goto yy173;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy173;
				if (yych <= 'G') goto yy835;
				goto yy173;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy835;
					goto yy173;
				} else {
					if (yych <= 'R') goto yy835;
					if (yych <= 'T') goto yy173;
					goto yy835;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy835;
				if (yych <= 'Y') goto yy173;
				goto yy835;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy173;
					goto yy835;
				} else {
					if (yych == 'g') goto yy835;
					goto yy173;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych <= 'r') goto yy835;
				goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy835;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy835;
				}
			}
		}
	}
yy837:
	YYDEBUG(837, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy835;
				goto yy173;
			} else {
				if (yych <= '/') goto yy835;
				if (yych <= '9') goto yy972;
				if (yych <= 'C') goto yy835;
				goto yy173;
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy173;
				if (yych <= 'G') goto yy835;
				goto yy173;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy835;
					goto yy173;
				} else {
					if (yych <= 'R') goto yy835;
					if (yych <= 'T') goto yy173;
					goto yy835;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy835;
				if (yych <= 'Y') goto yy173;
				goto yy835;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy173;
					goto yy835;
				} else {
					if (yych == 'g') goto yy835;
					goto yy173;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych <= 'r') goto yy835;
				goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy835;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy835;
				}
			}
		}
	}
yy838:
	YYDEBUG(838, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy173;
				if (yych <= 0x1F) goto yy835;
				goto yy173;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy835;
					goto yy972;
				} else {
					if (yych <= '9') goto yy51;
					if (yych <= 'C') goto yy835;
					goto yy173;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych == 'F') goto yy173;
				if (yych <= 'G') goto yy835;
				goto yy173;
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy835;
					goto yy173;
				} else {
					if (yych <= 'R') goto yy835;
					if (yych <= 'T') goto yy173;
					goto yy835;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'c') {
				if (yych == 'X') goto yy835;
				if (yych <= 'Y') goto yy173;
				goto yy835;
			} else {
				if (yych <= 'e') {
					if (yych <= 'd') goto yy173;
					goto yy835;
				} else {
					if (yych == 'g') goto yy835;
					goto yy173;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych == 'm') goto yy173;
				if (yych <= 'r') goto yy835;
				goto yy173;
			} else {
				if (yych <= 'w') {
					if (yych <= 'v') goto yy835;
					goto yy173;
				} else {
					if (yych == 'y') goto yy173;
					goto yy835;
				}
			}
		}
	}
yy839:
	YYDEBUG(839, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy974;
	goto yy50;
yy840:
	YYDEBUG(840, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy975;
	if (yych == 'i') goto yy975;
	goto yy513;
yy841:
	YYDEBUG(841, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy976;
	if (yych == 'u') goto yy976;
	goto yy513;
yy842:
	YYDEBUG(842, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy977;
	if (yych == 'e') goto yy977;
	goto yy513;
yy843:
	YYDEBUG(843, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy978;
	if (yych == 'r') goto yy978;
	goto yy513;
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy979;
	if (yych == 'u') goto yy979;
	goto yy513;
yy845:
	YYDEBUG(845, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy686;
	if (yych == 'y') goto yy686;
	goto yy513;
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy686;
	if (yych == 'e') goto yy686;
	goto yy513;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy980;
	if (yych == 'c') goto yy980;
	goto yy513;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy981;
	if (yych == 'o') goto yy981;
	goto yy513;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy842;
	if (yych == 't') goto yy842;
	goto yy513;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy851;
	if (yych <= '7') goto yy982;
yy851:
	YYDEBUG(851, *YYCURSOR);
#line 1247 "real_world/parse_date_db.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 16666 "real_world/parse_date_db.c"
yy852:
	YYDEBUG(852, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy983;
	if (yych == 'g') goto yy983;
	goto yy50;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy226;
	if (yych == 'y') goto yy226;
	goto yy50;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy226;
	if (yych == 'r') goto yy226;
	goto yy50;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy984;
	if (yych <= '2') goto yy985;
	if (yych <= '3') goto yy986;
	goto yy50;
yy856:
	YYDEBUG(856, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy987;
	goto yy50;
yy857:
	YYDEBUG(857, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy858:
	YYDEBUG(858, *YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy50;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy50;
		if (yych <= 'z') goto yy857;
		goto yy50;
	}
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy120;
	if (yych == 'r') goto yy120;
	goto yy50;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy120;
	if (yych == 'r') goto yy904;
	goto yy858;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy905;
	if (yych == 'y') goto yy905;
	goto yy50;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy907;
	if (yych == 'r') goto yy907;
	goto yy50;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy908;
	if (yych == 'i') goto yy908;
	goto yy50;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy909;
	if (yych == 'u') goto yy909;
	goto yy50;
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy910;
	if (yych == 'n') goto yy910;
	goto yy50;
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy911;
	if (yych == 'n') goto yy911;
	goto yy50;
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy912;
	if (yych == 't') goto yy912;
	goto yy50;
yy868:
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy913;
	if (yych == 'c') goto yy913;
	goto yy50;
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy908;
	if (yych == 'n') goto yy908;
	goto yy50;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy914;
	if (yych == 'u') goto yy914;
	goto yy50;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy915;
	if (yych == 'e') goto yy915;
	goto yy50;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy50;
		if (yych <= 'D') goto yy916;
		goto yy917;
	} else {
		if (yych <= 'c') goto yy50;
		if (yych <= 'd') goto yy916;
		if (yych <= 'e') goto yy917;
		goto yy50;
	}
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy909;
	if (yych == 'a') goto yy909;
	goto yy50;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy597;
	if (yych == 'h') goto yy597;
	goto yy50;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy905;
	if (yych == 'y') goto yy918;
	goto yy858;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy907;
	if (yych == 'r') goto yy919;
	goto yy858;
yy877:
	YYDEBUG(877, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy908;
	if (yych == 'i') goto yy920;
	goto yy858;
yy878:
	YYDEBUG(878, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy909;
	if (yych == 'u') goto yy921;
	goto yy858;
yy879:
	YYDEBUG(879, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy910;
	if (yych == 'n') goto yy922;
	goto yy858;
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy911;
	if (yych == 'n') goto yy923;
	goto yy858;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy912;
	if (yych == 't') goto yy924;
	goto yy858;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy913;
	if (yych == 'c') goto yy925;
	goto yy858;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy908;
	if (yych == 'n') goto yy920;
	goto yy858;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy914;
	if (yych == 'u') goto yy926;
	goto yy858;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy915;
	if (yych == 'e') goto yy927;
	goto yy858;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy858;
		if (yych <= 'D') goto yy916;
		goto yy917;
	} else {
		if (yych <= 'c') goto yy858;
		if (yych <= 'd') goto yy928;
		if (yych <= 'e') goto yy929;
		goto yy858;
	}
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy909;
	if (yych == 'a') goto yy921;
	goto yy858;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy597;
	if (yych == 'h') goto yy938;
	goto yy858;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy120;
	if (yych == 'y') goto yy120;
	goto yy50;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy120;
	if (yych == 'y') goto yy904;
	goto yy858;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy861;
	if (yych == 'a') goto yy875;
	goto yy858;
yy892:
	YYDEBUG(892, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy862;
		if (yych <= 'Q') goto yy858;
		goto yy863;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy858;
			goto yy876;
		} else {
			if (yych == 'r') goto yy877;
			goto yy858;
		}
	}
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy864;
	if (yych == 'o') goto yy878;
	goto yy858;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych == 'I') goto yy865;
		if (yych <= 'N') goto yy858;
		goto yy866;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy858;
			goto yy879;
		} else {
			if (yych == 'o') goto yy880;
			goto yy858;
		}
	}
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy867;
			goto yy858;
		} else {
			if (yych <= 'E') goto yy868;
			if (yych <= 'T') goto yy858;
			goto yy869;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy881;
			goto yy858;
		} else {
			if (yych <= 'e') goto yy882;
			if (yych == 'u') goto yy883;
			goto yy858;
		}
	}
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy870;
		if (yych <= 'T') goto yy858;
		goto yy871;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy858;
			goto yy884;
		} else {
			if (yych == 'u') goto yy885;
			goto yy858;
		}
	}
yy897:
	YYDEBUG(897, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy872;
	if (yych == 'e') goto yy886;
	goto yy858;
yy898:
	YYDEBUG(898, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy873;
	if (yych == 'e') goto yy887;
	goto yy858;
yy899:
	YYDEBUG(899, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy751;
		goto yy592;
	} else {
		if (yych <= '9') goto yy989;
		if (yych <= ':') goto yy751;
		goto yy592;
	}
yy900:
	YYDEBUG(900, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy751;
		goto yy592;
	} else {
		if (yych <= '0') goto yy990;
		if (yych == ':') goto yy751;
		goto yy592;
	}
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy592;
	if (yych <= '9') goto yy990;
	goto yy592;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy990;
	goto yy592;
yy903:
	YYDEBUG(903, *YYCURSOR);
	++YYCURSOR;
	goto yy592;
yy904:
	YYDEBUG(904, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy121;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy121;
		if (yych <= 'z') goto yy857;
		goto yy121;
	}
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy991;
	if (yych == 's') goto yy991;
yy906:
	YYDEBUG(906, *YYCURSOR);
#line 1353 "real_world/parse_date_db.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 17089 "real_world/parse_date_db.c"
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy992;
	if (yych == 't') goto yy992;
	goto yy50;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy993;
	if (yych == 'd') goto yy993;
	goto yy906;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy905;
	if (yych == 'r') goto yy905;
	goto yy50;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy991;
		if (yych <= 'T') goto yy906;
		goto yy994;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy906;
			goto yy991;
		} else {
			if (yych == 'u') goto yy994;
			goto yy906;
		}
	}
yy911:
	YYDEBUG(911, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy993;
		if (yych <= 'S') goto yy906;
		goto yy995;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy906;
			goto yy993;
		} else {
			if (yych == 't') goto yy995;
			goto yy906;
		}
	}
yy912:
	YYDEBUG(912, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy996;
	if (yych == 'u') goto yy996;
	goto yy906;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy997;
		if (yych <= 'R') goto yy906;
		goto yy991;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy906;
			goto yy997;
		} else {
			if (yych == 's') goto yy991;
			goto yy906;
		}
	}
yy914:
	YYDEBUG(914, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy998;
	if (yych == 'r') goto yy998;
	goto yy906;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy999;
	if (yych == 's') goto yy999;
	goto yy906;
yy916:
	YYDEBUG(916, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy1000;
	if (yych == 'n') goto yy1000;
	goto yy906;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy905;
	if (yych == 'k') goto yy905;
	goto yy50;
yy918:
	YYDEBUG(918, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy906;
			goto yy259;
		} else {
			if (yych == 'S') goto yy991;
			goto yy906;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy906;
			goto yy857;
		} else {
			if (yych <= 's') goto yy1001;
			if (yych <= 'z') goto yy857;
			goto yy906;
		}
	}
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy992;
	if (yych == 't') goto yy1002;
	goto yy858;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy906;
			goto yy259;
		} else {
			if (yych == 'D') goto yy993;
			goto yy906;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy906;
			goto yy857;
		} else {
			if (yych <= 'd') goto yy1003;
			if (yych <= 'z') goto yy857;
			goto yy906;
		}
	}
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy905;
	if (yych == 'r') goto yy918;
	goto yy858;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'R') {
			if (yych == '/') goto yy259;
			goto yy906;
		} else {
			if (yych <= 'S') goto yy991;
			if (yych == 'U') goto yy994;
			goto yy906;
		}
	} else {
		if (yych <= 's') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy906;
			if (yych <= 'r') goto yy857;
			goto yy1001;
		} else {
			if (yych == 'u') goto yy1004;
			if (yych <= 'z') goto yy857;
			goto yy906;
		}
	}
yy923:
	YYDEBUG(923, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'C') {
			if (yych == '/') goto yy259;
			goto yy906;
		} else {
			if (yych <= 'D') goto yy993;
			if (yych == 'T') goto yy995;
			goto yy906;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy906;
			if (yych <= 'c') goto yy857;
			goto yy1003;
		} else {
			if (yych == 't') goto yy1005;
			if (yych <= 'z') goto yy857;
			goto yy906;
		}
	}
yy924:
	YYDEBUG(924, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy906;
			goto yy259;
		} else {
			if (yych == 'U') goto yy996;
			goto yy906;
		}
	} else {
		if (yych <= 't') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy906;
			goto yy857;
		} else {
			if (yych <= 'u') goto yy1006;
			if (yych <= 'z') goto yy857;
			goto yy906;
		}
	}
yy925:
	YYDEBUG(925, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= 'N') {
			if (yych == '/') goto yy259;
			goto yy906;
		} else {
			if (yych <= 'O') goto yy997;
			if (yych == 'S') goto yy991;
			goto yy906;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy906;
			if (yych <= 'n') goto yy857;
			goto yy1007;
		} else {
			if (yych == 's') goto yy1001;
			if (yych <= 'z') goto yy857;
			goto yy906;
		}
	}
yy926:
	YYDEBUG(926, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy906;
			goto yy259;
		} else {
			if (yych == 'R') goto yy998;
			goto yy906;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy906;
			goto yy857;
		} else {
			if (yych <= 'r') goto yy1008;
			if (yych <= 'z') goto yy857;
			goto yy906;
		}
	}
yy927:
	YYDEBUG(927, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy906;
			goto yy259;
		} else {
			if (yych == 'S') goto yy999;
			goto yy906;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy906;
			goto yy857;
		} else {
			if (yych <= 's') goto yy1009;
			if (yych <= 'z') goto yy857;
			goto yy906;
		}
	}
yy928:
	YYDEBUG(928, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych <= '.') goto yy906;
			goto yy259;
		} else {
			if (yych == 'N') goto yy1000;
			goto yy906;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= '_') goto yy259;
			if (yych <= '`') goto yy906;
			goto yy857;
		} else {
			if (yych <= 'n') goto yy1010;
			if (yych <= 'z') goto yy857;
			goto yy906;
		}
	}
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy905;
	if (yych == 'k') goto yy918;
	goto yy858;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1011;
	if (yych == 't') goto yy1011;
	goto yy50;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1011;
	if (yych == 't') goto yy1012;
	goto yy858;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy597;
	if (yych == 's') goto yy597;
	goto yy50;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy597;
	if (yych == 's') goto yy938;
	goto yy858;
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy941;
	if (yych == 'y') goto yy941;
	goto yy50;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy859;
	if (yych == 'e') goto yy859;
	goto yy50;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy941;
	if (yych == 'y') goto yy943;
	goto yy858;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy859;
	if (yych == 'e') goto yy860;
	goto yy858;
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'h') {
		if (yych <= '`') {
			if (yych <= '/') {
				if (yych <= '.') goto yy598;
				goto yy259;
			} else {
				if (yych == '_') goto yy259;
				goto yy598;
			}
		} else {
			if (yych <= 'e') {
				if (yych == 'd') goto yy891;
				goto yy857;
			} else {
				if (yych <= 'f') goto yy892;
				if (yych <= 'g') goto yy857;
				goto yy893;
			}
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'm') {
				if (yych <= 'l') goto yy857;
				goto yy894;
			} else {
				if (yych <= 'r') goto yy857;
				if (yych <= 's') goto yy895;
				goto yy896;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'w') goto yy897;
				goto yy857;
			} else {
				if (yych <= 'y') goto yy898;
				if (yych <= 'z') goto yy857;
				goto yy598;
			}
		}
	}
yy939:
	YYDEBUG(939, *YYCURSOR);
	++YYCURSOR;
	goto yy674;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1013;
	if (yych == 'w') goto yy1013;
	goto yy50;
yy941:
	YYDEBUG(941, *YYCURSOR);
	++YYCURSOR;
	goto yy275;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1013;
	if (yych == 'w') goto yy1015;
	goto yy858;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy275;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy275;
		if (yych <= 'z') goto yy857;
		goto yy275;
	}
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy934;
	if (yych == 'a') goto yy934;
	goto yy50;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy934;
	if (yych == 'a') goto yy936;
	goto yy858;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1016;
	if (yych == 'a') goto yy1016;
	goto yy50;
yy947:
	YYDEBUG(947, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1016;
	if (yych == 'a') goto yy1017;
	goto yy858;
yy948:
	YYDEBUG(948, *YYCURSOR);
	++YYCURSOR;
	goto yy482;
yy949:
	YYDEBUG(949, *YYCURSOR);
	++YYCURSOR;
	goto yy199;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1018;
	goto yy50;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy484;
			goto yy953;
		} else {
			if (yych == 'T') goto yy1019;
			goto yy484;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1020;
			if (yych <= 'q') goto yy484;
			goto yy1020;
		} else {
			if (yych <= 's') goto yy1021;
			if (yych <= 't') goto yy1022;
			goto yy484;
		}
	}
yy952:
	YYDEBUG(952, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy484;
		} else {
			if (yych == 'T') goto yy1019;
			goto yy484;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1020;
			if (yych <= 'q') goto yy484;
			goto yy1020;
		} else {
			if (yych <= 's') goto yy1021;
			if (yych <= 't') goto yy1022;
			goto yy484;
		}
	}
yy953:
	YYDEBUG(953, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1019;
		if (yych <= 'm') goto yy484;
		goto yy1020;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy484;
			goto yy1020;
		} else {
			if (yych <= 's') goto yy1021;
			if (yych <= 't') goto yy1022;
			goto yy484;
		}
	}
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy50;
		if (yych <= '0') goto yy1023;
		goto yy1024;
	} else {
		if (yych <= '3') goto yy1025;
		if (yych <= '9') goto yy953;
		goto yy50;
	}
yy955:
	YYDEBUG(955, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy855;
		goto yy513;
	} else {
		if (yych <= 'I') goto yy975;
		if (yych == 'i') goto yy975;
		goto yy513;
	}
yy956:
	YYDEBUG(956, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy855;
		goto yy513;
	} else {
		if (yych <= 'U') goto yy976;
		if (yych == 'u') goto yy976;
		goto yy513;
	}
yy957:
	YYDEBUG(957, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy855;
		goto yy513;
	} else {
		if (yych <= 'E') goto yy977;
		if (yych == 'e') goto yy977;
		goto yy513;
	}
yy958:
	YYDEBUG(958, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy855;
		goto yy513;
	} else {
		if (yych <= 'R') goto yy978;
		if (yych == 'r') goto yy978;
		goto yy513;
	}
yy959:
	YYDEBUG(959, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy855;
		goto yy513;
	} else {
		if (yych <= 'U') goto yy979;
		if (yych == 'u') goto yy979;
		goto yy513;
	}
yy960:
	YYDEBUG(960, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy855;
		goto yy513;
	} else {
		if (yych <= 'Y') goto yy686;
		if (yych == 'y') goto yy686;
		goto yy513;
	}
yy961:
	YYDEBUG(961, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy855;
		goto yy513;
	} else {
		if (yych <= 'E') goto yy686;
		if (yych == 'e') goto yy686;
		goto yy513;
	}
yy962:
	YYDEBUG(962, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy855;
		goto yy513;
	} else {
		if (yych <= 'C') goto yy980;
		if (yych == 'c') goto yy980;
		goto yy513;
	}
yy963:
	YYDEBUG(963, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy855;
	goto yy513;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy855;
		goto yy513;
	} else {
		if (yych <= 'O') goto yy981;
		if (yych == 'o') goto yy981;
		goto yy513;
	}
yy965:
	YYDEBUG(965, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy855;
		goto yy513;
	} else {
		if (yych <= 'T') goto yy957;
		if (yych == 't') goto yy957;
		goto yy513;
	}
yy966:
	YYDEBUG(966, *YYCURSOR);
	++YYCURSOR;
	goto yy835;
yy967:
	YYDEBUG(967, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy968;
		if (yych <= '9') goto yy970;
		if (yych >= 'n') goto yy1026;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy1026;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1028;
		}
	}
yy968:
	YYDEBUG(968, *YYCURSOR);
#line 1074 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("iso8601date | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 17821 "real_world/parse_date_db.c"
yy969:
	YYDEBUG(969, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy968;
		if (yych <= '1') goto yy970;
		if (yych <= 'm') goto yy968;
		goto yy1026;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy968;
			goto yy1026;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1028;
			goto yy968;
		}
	}
yy970:
	YYDEBUG(970, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1026;
		goto yy968;
	} else {
		if (yych <= 'r') goto yy1026;
		if (yych <= 's') goto yy1027;
		if (yych <= 't') goto yy1028;
		goto yy968;
	}
yy971:
	YYDEBUG(971, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy50;
		if (yych <= '0') goto yy1029;
		goto yy1030;
	} else {
		if (yych <= '3') goto yy1031;
		if (yych <= '9') goto yy970;
		goto yy50;
	}
yy972:
	YYDEBUG(972, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy51;
	}
	if (yych <= 'W') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy172;
				if (yych >= ' ') goto yy172;
			} else {
				if (yych == 'D') goto yy174;
				if (yych >= 'F') goto yy175;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy67;
				if (yych >= 'M') goto yy176;
			} else {
				if (yych <= 'S') {
					if (yych >= 'S') goto yy177;
				} else {
					if (yych <= 'T') goto yy1032;
					if (yych >= 'W') goto yy77;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy79;
				if (yych >= 'd') goto yy174;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy175;
				} else {
					if (yych == 'h') goto yy67;
				}
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'm') goto yy176;
				if (yych <= 'r') goto yy973;
				if (yych <= 's') goto yy177;
				goto yy1033;
			} else {
				if (yych <= 'w') {
					if (yych >= 'w') goto yy77;
				} else {
					if (yych == 'y') goto yy79;
				}
			}
		}
	}
yy973:
	YYDEBUG(973, *YYCURSOR);
#line 1177 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 17935 "real_world/parse_date_db.c"
yy974:
	YYDEBUG(974, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy1034;
	if (yych <= '2') goto yy1035;
	if (yych <= '3') goto yy1036;
	goto yy50;
yy975:
	YYDEBUG(975, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy686;
	if (yych == 'l') goto yy686;
	goto yy50;
yy976:
	YYDEBUG(976, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1037;
	if (yych == 's') goto yy1037;
	goto yy50;
yy977:
	YYDEBUG(977, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy981;
	if (yych == 'm') goto yy981;
	goto yy50;
yy978:
	YYDEBUG(978, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy979;
	if (yych != 'u') goto yy50;
yy979:
	YYDEBUG(979, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1038;
	if (yych == 'a') goto yy1038;
	goto yy50;
yy980:
	YYDEBUG(980, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy686;
	if (yych == 'h') goto yy686;
	goto yy50;
yy981:
	YYDEBUG(981, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1039;
	if (yych == 'b') goto yy1039;
	goto yy50;
yy982:
	YYDEBUG(982, *YYCURSOR);
	++YYCURSOR;
#line 1228 "real_world/parse_date_db.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();
		
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 18006 "real_world/parse_date_db.c"
yy983:
	YYDEBUG(983, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1040;
	if (yych == 'h') goto yy1040;
	goto yy50;
yy984:
	YYDEBUG(984, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych <= '9') goto yy1041;
	goto yy50;
yy985:
	YYDEBUG(985, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1041;
	goto yy50;
yy986:
	YYDEBUG(986, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1041;
	goto yy50;
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy988;
	if (yych <= '9') goto yy1042;
yy988:
	YYDEBUG(988, *YYCURSOR);
#line 1266 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 18050 "real_world/parse_date_db.c"
yy989:
	YYDEBUG(989, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1043;
			if (yych <= 0x1F) goto yy592;
			goto yy1043;
		} else {
			if (yych <= '(') {
				if (yych <= '\'') goto yy592;
				goto yy1044;
			} else {
				if (yych == '+') goto yy1045;
				goto yy592;
			}
		}
	} else {
		if (yych <= ':') {
			if (yych <= '-') goto yy1045;
			if (yych <= '.') goto yy751;
			if (yych <= '9') goto yy592;
			goto yy751;
		} else {
			if (yych <= 'Z') {
				if (yych <= '@') goto yy592;
				goto yy1046;
			} else {
				if (yych <= '`') goto yy592;
				if (yych <= 'z') goto yy1047;
				goto yy592;
			}
		}
	}
yy990:
	YYDEBUG(990, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1043;
			goto yy592;
		} else {
			if (yych <= ' ') goto yy1043;
			if (yych == '(') goto yy1044;
			goto yy592;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy592;
			if (yych <= '-') goto yy1045;
			goto yy592;
		} else {
			if (yych <= 'Z') goto yy1046;
			if (yych <= '`') goto yy592;
			if (yych <= 'z') goto yy1047;
			goto yy592;
		}
	}
yy991:
	YYDEBUG(991, *YYCURSOR);
	++YYCURSOR;
	goto yy906;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1048;
		if (yych <= 'M') goto yy50;
		goto yy1049;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy50;
			goto yy1048;
		} else {
			if (yych == 'n') goto yy1049;
			goto yy50;
		}
	}
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1050;
	if (yych == 'a') goto yy1050;
	goto yy50;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1051;
	if (yych == 't') goto yy1051;
	goto yy50;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy905;
	if (yych == 'h') goto yy905;
	goto yy50;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy999;
	if (yych == 'r') goto yy999;
	goto yy50;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1052;
	if (yych == 'n') goto yy1052;
	goto yy50;
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy999;
	if (yych != 's') goto yy50;
yy999:
	YYDEBUG(999, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy993;
	if (yych == 'd') goto yy993;
	goto yy50;
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy998;
	if (yych == 'e') goto yy998;
	goto yy50;
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy906;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy906;
		if (yych <= 'z') goto yy857;
		goto yy906;
	}
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1048;
		if (yych <= 'M') goto yy858;
		goto yy1049;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy858;
			goto yy1053;
		} else {
			if (yych == 'n') goto yy1054;
			goto yy858;
		}
	}
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1050;
	if (yych == 'a') goto yy1055;
	goto yy858;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1051;
	if (yych == 't') goto yy1056;
	goto yy858;
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy905;
	if (yych == 'h') goto yy918;
	goto yy858;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy999;
	if (yych == 'r') goto yy1009;
	goto yy858;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1052;
	if (yych == 'n') goto yy1057;
	goto yy858;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy999;
	if (yych != 's') goto yy858;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy993;
	if (yych == 'd') goto yy1003;
	goto yy858;
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy998;
	if (yych == 'e') goto yy1008;
	goto yy858;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	++YYCURSOR;
	goto yy631;
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy631;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy631;
		if (yych <= 'z') goto yy857;
		goto yy631;
	}
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	++YYCURSOR;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
#line 914 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18287 "real_world/parse_date_db.c"
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy1014;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy1014;
		if (yych <= 'z') goto yy857;
		goto yy1014;
	}
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1058;
	if (yych == 'y') goto yy1058;
	goto yy50;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1058;
	if (yych == 'y') goto yy1060;
	goto yy858;
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1061;
	goto yy50;
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1062;
	if (yych <= '2') goto yy1063;
	if (yych <= '9') goto yy1064;
	goto yy50;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1065;
	goto yy50;
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1065;
	goto yy50;
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1065;
	goto yy50;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy484;
			if (yych <= '0') goto yy953;
			goto yy1066;
		} else {
			if (yych == 'T') goto yy1019;
			goto yy484;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1020;
			if (yych <= 'q') goto yy484;
			goto yy1020;
		} else {
			if (yych <= 's') goto yy1021;
			if (yych <= 't') goto yy1022;
			goto yy484;
		}
	}
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy484;
			goto yy1066;
		} else {
			if (yych == 'T') goto yy1019;
			goto yy484;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1020;
			if (yych <= 'q') goto yy484;
			goto yy1020;
		} else {
			if (yych <= 's') goto yy1021;
			if (yych <= 't') goto yy1022;
			goto yy484;
		}
	}
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy484;
			goto yy1066;
		} else {
			if (yych == 'T') goto yy1019;
			goto yy484;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1020;
			if (yych <= 'q') goto yy484;
			goto yy1020;
		} else {
			if (yych <= 's') goto yy1021;
			if (yych <= 't') goto yy1022;
			goto yy484;
		}
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1067;
	goto yy50;
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1067;
	goto yy50;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1067;
	goto yy50;
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '0') {
			if (yych <= '/') goto yy968;
			goto yy970;
		} else {
			if (yych <= '9') goto yy1068;
			if (yych <= 'm') goto yy968;
			goto yy1026;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy968;
			goto yy1026;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1028;
			goto yy968;
		}
	}
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy968;
		if (yych <= '9') goto yy1068;
		if (yych <= 'm') goto yy968;
		goto yy1026;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy968;
			goto yy1026;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1028;
			goto yy968;
		}
	}
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy968;
		if (yych <= '1') goto yy1068;
		if (yych <= 'm') goto yy968;
		goto yy1026;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy968;
			goto yy1026;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1028;
			goto yy968;
		}
	}
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy50;
			if (yych <= '1') goto yy1069;
			goto yy1070;
		} else {
			if (yych <= '9') goto yy1071;
			if (yych <= 'G') goto yy50;
			goto yy237;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy238;
			goto yy50;
		} else {
			if (yych <= 'h') goto yy237;
			if (yych == 'u') goto yy238;
			goto yy50;
		}
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy50;
			if (yych <= '1') goto yy1072;
			goto yy1073;
		} else {
			if (yych <= '9') goto yy1074;
			if (yych <= 'G') goto yy50;
			goto yy237;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy238;
			goto yy50;
		} else {
			if (yych <= 'h') goto yy237;
			if (yych == 'u') goto yy238;
			goto yy50;
		}
	}
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy50;
	if (yych <= '9') goto yy1075;
	goto yy50;
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1075;
	goto yy50;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1075;
	goto yy50;
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy686;
	if (yych == 't') goto yy686;
	goto yy50;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1076;
	if (yych == 'r') goto yy1076;
	goto yy50;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1077;
	if (yych == 'e') goto yy1077;
	goto yy50;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy365;
	if (yych == 't') goto yy365;
	goto yy50;
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	++YYCURSOR;
#line 1279 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 18591 "real_world/parse_date_db.c"
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy988;
	if (yych <= '9') goto yy1078;
	goto yy988;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 8) YYFILL(8);
	yych = *YYCURSOR;
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1043;
			goto yy50;
		} else {
			if (yych <= ' ') goto yy1043;
			if (yych != '(') goto yy50;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy50;
			if (yych <= '-') goto yy1045;
			goto yy50;
		} else {
			if (yych <= 'Z') goto yy1046;
			if (yych <= '`') goto yy50;
			if (yych <= 'z') goto yy1047;
			goto yy50;
		}
	}
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy50;
	if (yych <= 'Z') goto yy1047;
	if (yych <= '`') goto yy50;
	if (yych <= 'z') goto yy1047;
	goto yy50;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1079;
	if (yych <= '2') goto yy1080;
	if (yych <= '9') goto yy1081;
	goto yy50;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy903;
		goto yy592;
	} else {
		if (yych <= 'Z') goto yy1082;
		if (yych <= '`') goto yy592;
		if (yych <= 'z') goto yy1083;
		goto yy592;
	}
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy903;
		goto yy592;
	} else {
		if (yych <= 'Z') goto yy1082;
		if (yych <= '`') goto yy592;
		if (yych <= 'z') goto yy1082;
		goto yy592;
	}
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1049;
	if (yych != 'n') goto yy50;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1084;
	if (yych == 'i') goto yy1084;
	goto yy50;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy991;
	if (yych == 'y') goto yy991;
	goto yy50;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy905;
	if (yych == 'e') goto yy905;
	goto yy50;
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy905;
	if (yych == 'd') goto yy905;
	goto yy50;
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1049;
	if (yych != 'n') goto yy858;
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1084;
	if (yych == 'i') goto yy1085;
	goto yy858;
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy991;
	if (yych == 'y') goto yy1001;
	goto yy858;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy905;
	if (yych == 'e') goto yy918;
	goto yy858;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy905;
	if (yych == 'd') goto yy918;
	goto yy858;
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	++YYCURSOR;
yy1059:
	YYDEBUG(1059, *YYCURSOR);
#line 871 "real_world/parse_date_db.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18737 "real_world/parse_date_db.c"
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '^') {
		if (yych == '/') goto yy259;
		goto yy1059;
	} else {
		if (yych <= '_') goto yy259;
		if (yych <= '`') goto yy1059;
		if (yych <= 'z') goto yy857;
		goto yy1059;
	}
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1086;
	goto yy50;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1064;
	if (yych <= ':') goto yy1087;
	goto yy50;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy1064;
	if (yych == ':') goto yy1087;
	goto yy50;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1087;
	goto yy50;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1019;
	goto yy484;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1088;
		if (yych <= 'm') goto yy968;
		goto yy1020;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy968;
			goto yy1020;
		} else {
			if (yych <= 's') goto yy1021;
			if (yych <= 't') goto yy1022;
			goto yy968;
		}
	}
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	++YYCURSOR;
	goto yy968;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy1067;
		if (yych <= 'm') goto yy968;
		goto yy1026;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy968;
			goto yy1026;
		} else {
			if (yych <= 's') goto yy1027;
			if (yych <= 't') goto yy1028;
			goto yy968;
		}
	}
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1089;
	if (yych <= '9') goto yy1071;
	if (yych <= ':') goto yy1090;
	goto yy50;
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy50;
		if (yych <= '3') goto yy1089;
		goto yy1091;
	} else {
		if (yych == ':') goto yy1090;
		goto yy50;
	}
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1091;
	if (yych == ':') goto yy1090;
	goto yy50;
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1092;
	if (yych <= '9') goto yy1074;
	goto yy50;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy1092;
	if (yych <= '5') goto yy1091;
	goto yy50;
yy1074:
	YYDEBUG(1074, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1091;
	goto yy50;
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1093;
	goto yy50;
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy686;
	if (yych == 'y') goto yy686;
	goto yy50;
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy686;
	if (yych == 'r') goto yy686;
	goto yy50;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy988;
	if (yych <= '9') goto yy1094;
	goto yy988;
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy592;
	if (yych <= '9') goto yy1081;
	if (yych <= ':') goto yy1095;
	goto yy592;
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy592;
		if (yych >= '4') goto yy1096;
	} else {
		if (yych <= '9') goto yy903;
		if (yych <= ':') goto yy1095;
		goto yy592;
	}
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy592;
	if (yych <= '5') goto yy1096;
	if (yych <= '9') goto yy903;
	if (yych <= ':') goto yy1095;
	goto yy592;
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy903;
		goto yy592;
	} else {
		if (yych <= 'Z') goto yy1097;
		if (yych <= '`') goto yy592;
		if (yych <= 'z') goto yy1097;
		goto yy592;
	}
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy592;
			goto yy903;
		} else {
			if (yych == '/') goto yy1098;
			goto yy592;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1097;
			if (yych <= '^') goto yy592;
			goto yy1098;
		} else {
			if (yych <= '`') goto yy592;
			if (yych <= 'z') goto yy1099;
			goto yy592;
		}
	}
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1100;
	if (yych == 'g') goto yy1100;
	goto yy50;
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1100;
	if (yych == 'g') goto yy1101;
	goto yy858;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1102;
	if (yych <= '2') goto yy1103;
	goto yy50;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1104;
	if (yych <= '9') goto yy1105;
	goto yy50;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1106;
	if (yych <= '2') goto yy1107;
	if (yych <= '9') goto yy1064;
	goto yy50;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1108;
	if (yych <= '9') goto yy1109;
	if (yych >= ';') goto yy50;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1110;
	goto yy50;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1109;
	goto yy50;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1108;
	if (yych <= '9') goto yy1109;
	goto yy50;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1111;
	if (yych <= '2') goto yy1112;
	goto yy50;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	++YYCURSOR;
	goto yy988;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy592;
	if (yych <= '5') goto yy1096;
	if (yych <= '9') goto yy903;
	goto yy592;
yy1096:
	YYDEBUG(1096, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy592;
	if (yych <= '9') goto yy903;
	goto yy592;
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy903;
		goto yy592;
	} else {
		if (yych <= 'Z') goto yy1113;
		if (yych <= '`') goto yy592;
		if (yych <= 'z') goto yy1113;
		goto yy592;
	}
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy50;
	if (yych <= 'Z') goto yy1114;
	goto yy50;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy592;
			goto yy903;
		} else {
			if (yych == '/') goto yy1098;
			goto yy592;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1113;
			if (yych <= '^') goto yy592;
			goto yy1098;
		} else {
			if (yych <= '`') goto yy592;
			if (yych <= 'z') goto yy1115;
			goto yy592;
		}
	}
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1116;
	if (yych == 'h') goto yy1116;
	goto yy50;
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1116;
	if (yych == 'h') goto yy1117;
	goto yy858;
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1118;
	goto yy50;
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy1118;
	goto yy50;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1105;
	if (yych <= ':') goto yy1119;
	goto yy50;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1119;
	goto yy50;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1120;
	if (yych <= ':') goto yy1087;
	goto yy50;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy1120;
	if (yych == ':') goto yy1087;
	goto yy50;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1119;
	if (yych <= '6') goto yy1121;
	if (yych >= ':') goto yy50;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1122;
	if (yych <= '6') goto yy1123;
	goto yy50;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1124;
	goto yy50;
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1125;
	goto yy50;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '3') goto yy1125;
	goto yy50;
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy903;
		goto yy592;
	} else {
		if (yych <= 'Z') goto yy1126;
		if (yych <= '`') goto yy592;
		if (yych <= 'z') goto yy1126;
		goto yy592;
	}
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '`') goto yy50;
	if (yych <= 'z') goto yy1127;
	goto yy50;
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy592;
			goto yy903;
		} else {
			if (yych == '/') goto yy1098;
			goto yy592;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1126;
			if (yych <= '^') goto yy592;
			goto yy1098;
		} else {
			if (yych <= '`') goto yy592;
			if (yych <= 'z') goto yy1128;
			goto yy592;
		}
	}
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy905;
	if (yych == 't') goto yy905;
	goto yy50;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy905;
	if (yych == 't') goto yy918;
	goto yy858;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1129;
	goto yy50;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1130;
	if (yych <= '6') goto yy1132;
	if (yych <= '9') goto yy1133;
	goto yy50;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1134;
	goto yy50;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '0') goto yy1130;
	if (yych <= '5') goto yy1122;
	if (yych <= '6') goto yy1123;
	goto yy50;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1133;
	goto yy50;
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1133;
	goto yy50;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1109;
	goto yy50;
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1090;
	goto yy50;
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy903;
		goto yy592;
	} else {
		if (yych <= 'Z') goto yy1135;
		if (yych <= '`') goto yy592;
		if (yych <= 'z') goto yy1135;
		goto yy592;
	}
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	yyaccept = 16;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy1098;
		goto yy592;
	} else {
		if (yych <= '_') goto yy1098;
		if (yych <= '`') goto yy592;
		if (yych <= 'z') goto yy1127;
		goto yy592;
	}
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ')') {
			if (yych <= '(') goto yy592;
			goto yy903;
		} else {
			if (yych == '/') goto yy1098;
			goto yy592;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1135;
			if (yych <= '^') goto yy592;
			goto yy1098;
		} else {
			if (yych <= '`') goto yy592;
			if (yych <= 'z') goto yy1136;
			goto yy592;
		}
	}
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1137;
	goto yy50;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1131;
	if (yych <= '9') goto yy1133;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
#line 1189 "real_world/parse_date_db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->f = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
				if (tz_not_found) {
					add_error(s, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 19350 "real_world/parse_date_db.c"
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1131;
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	++YYCURSOR;
	goto yy1131;
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1138;
	if (yych <= '9') goto yy1105;
	goto yy50;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy903;
	goto yy592;
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == ')') goto yy903;
		if (yych <= '.') goto yy592;
		goto yy1098;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy592;
			goto yy1098;
		} else {
			if (yych <= '`') goto yy592;
			if (yych <= 'z') goto yy1139;
			goto yy592;
		}
	}
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1140;
	goto yy50;
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1141;
	if (yych <= ':') goto yy1119;
	goto yy50;
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '^') {
		if (yych == '/') goto yy1098;
		goto yy50;
	} else {
		if (yych <= '_') goto yy1098;
		if (yych <= '`') goto yy50;
		if (yych <= 'z') goto yy1139;
		goto yy50;
	}
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1142;
	goto yy50;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1143;
	goto yy50;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1144;
	if (yych <= '6') goto yy1145;
	goto yy50;
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '5') goto yy1146;
	if (yych <= '6') goto yy1147;
	if (yych <= '9') goto yy1133;
	goto yy50;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1148;
	goto yy50;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1148;
	goto yy50;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1131;
	if (yych <= '9') goto yy1149;
	goto yy1131;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1149;
	goto yy1131;
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1150;
	if (yych == ' ') goto yy1150;
	goto yy50;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1151;
	goto yy1131;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy1150;
		if (yych <= 0x1F) goto yy50;
		goto yy1150;
	} else {
		if (yych <= '+') {
			if (yych <= '*') goto yy50;
			goto yy1152;
		} else {
			if (yych == '-') goto yy1152;
			goto yy50;
		}
	}
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '9') goto yy1153;
	goto yy50;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1154;
	if (yych <= '2') goto yy1156;
	if (yych <= '9') goto yy1157;
	goto yy50;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yyaccept = 26;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 6) YYFILL(6);
	yych = *YYCURSOR;
	if (yych <= ',') {
		if (yych == '+') goto yy1158;
		goto yy1131;
	} else {
		if (yych <= '-') goto yy1158;
		if (yych <= '/') goto yy1131;
		if (yych <= '9') goto yy1153;
		goto yy1131;
	}
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1155;
	if (yych <= '9') goto yy1157;
	if (yych <= ':') goto yy1159;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
#line 1292 "real_world/parse_date_db.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_get_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb);
		if (tz_not_found) {
			add_error(s, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 19550 "real_world/parse_date_db.c"
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1155;
		if (yych >= '4') goto yy1160;
	} else {
		if (yych <= '9') goto yy1161;
		if (yych <= ':') goto yy1159;
		goto yy1155;
	}
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1155;
	if (yych <= '5') goto yy1160;
	if (yych <= '9') goto yy1161;
	if (yych <= ':') goto yy1159;
	goto yy1155;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy50;
	if (yych <= '1') goto yy1162;
	if (yych <= '2') goto yy1163;
	if (yych <= '9') goto yy1164;
	goto yy50;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1155;
	if (yych <= '5') goto yy1160;
	if (yych <= '9') goto yy1161;
	goto yy1155;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1155;
	if (yych >= ':') goto yy1155;
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	++YYCURSOR;
	goto yy1155;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1131;
	if (yych <= '9') goto yy1164;
	if (yych <= ':') goto yy1165;
	goto yy1131;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1131;
		if (yych >= '4') goto yy1130;
	} else {
		if (yych <= '9') goto yy1133;
		if (yych <= ':') goto yy1165;
		goto yy1131;
	}
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1131;
	if (yych <= '5') goto yy1130;
	if (yych <= '9') goto yy1133;
	if (yych >= ';') goto yy1131;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1131;
	if (yych <= '5') goto yy1130;
	if (yych <= '9') goto yy1133;
	goto yy1131;
}
#line 1445 "real_world/parse_date_db.re"

}

#line 19631 "real_world/parse_date_db.c"
#define YYMAXFILL 29
#line 1448 "real_world/parse_date_db.re"


timelib_time* timelib_strtotime(char *s, int len, struct timelib_error_container **errors, timelib_tzdb *tzdb)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = malloc(sizeof(struct timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	while (isspace(*s) && s < e) {
		s++;
	}
	while (isspace(*e) && e > s) {
		e--;
	}
	if (e - s < 1) {
		in.time = timelib_time_ctor();
		add_error(&in, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->f = in.time->z = in.time->dst = -1;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = -1;
	in.time->d = -1;
	in.time->m = -1;
	in.time->h = -1;
	in.time->i = -1;
	in.time->s = -1;
	in.time->f = -1;
	in.time->z = -1;
	in.time->dst = -1;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	do {
		t = scan(&in);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options && TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->f = 0;
	}
	if (parsed->y == -1) parsed->y = now->y != -1 ? now->y : 0;
	if (parsed->d == -1) parsed->d = now->d != -1 ? now->d : 0;
	if (parsed->m == -1) parsed->m = now->m != -1 ? now->m : 0;
	if (parsed->h == -1) parsed->h = now->h != -1 ? now->h : 0;
	if (parsed->i == -1) parsed->i = now->i != -1 ? now->i : 0;
	if (parsed->s == -1) parsed->s = now->s != -1 ? now->s : 0;
	if (parsed->f == -1) parsed->f = now->f != -1 ? now->f : 0;
	if (parsed->z == -1) parsed->z = now->z != -1 ? now->z : 0;
	if (parsed->dst == -1) parsed->dst = now->dst != -1 ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, long gmtoffset, int isdst)
{
	timelib_tz_lookup_table *tp;

	tp = zone_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS", 
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;				
}
#endif

/*
 * vim: syntax=c
 */
