/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 1.48 $ of : mfd-top.m2c,v $ 
 *
 * $Id$
 */
/** \page MFD helper for ipSystemStatsTable
 *
 * \section intro Introduction
 * Introductory text.
 *
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

/*
 * include our parent header 
 */
#include "ipSystemStatsTable.h"

#include <net-snmp/agent/mib_modules.h>

#include "ipSystemStatsTable_interface.h"

const oid       ipSystemStatsTable_oid[] = { IPSYSTEMSTATSTABLE_OID };
const int       ipSystemStatsTable_oid_size =
OID_LENGTH(ipSystemStatsTable_oid);

ipSystemStatsTable_registration ipSystemStatsTable_user_context;
static ipSystemStatsTable_registration *ipSystemStatsTable_user_context_p;

void            initialize_table_ipSystemStatsTable(void);
void            shutdown_table_ipSystemStatsTable(void);


/**
 * Initializes the ipSystemStatsTable module
 */
void
init_ipSystemStatsTable(void)
{
    DEBUGMSGTL(("verbose:ipSystemStatsTable:init_ipSystemStatsTable",
                "called\n"));

    /*
     * TODO:300:o: Perform ipSystemStatsTable one-time module initialization.
     */

    /*
     * here we initialize all the tables we're planning on supporting
     */
    if (should_init("ipSystemStatsTable"))
        initialize_table_ipSystemStatsTable();

}                               /* init_ipSystemStatsTable */

/**
 * Shut-down the ipSystemStatsTable module (agent is exiting)
 */
void
shutdown_ipSystemStatsTable(void)
{
    if (should_init("ipSystemStatsTable"))
        shutdown_table_ipSystemStatsTable();

}

/**
 * Initialize the table ipSystemStatsTable 
 *    (Define its contents and how it's structured)
 */
void
initialize_table_ipSystemStatsTable(void)
{
    u_long          flags;

    DEBUGMSGTL(("verbose:ipSystemStatsTable:initialize_table_ipSystemStatsTable", "called\n"));

    /*
     * TODO:301:o: Perform ipSystemStatsTable one-time table initialization.
     */

    /*
     * TODO:302:o: |->Initialize ipSystemStatsTable user context
     * if you'd like to pass in a pointer to some data for this
     * table, allocate or set it up here.
     */
    /*
     * a netsnmp_data_list is a simple way to store void pointers. A simple
     * string token is used to add, find or remove pointers.
     */
    ipSystemStatsTable_user_context_p =
        netsnmp_create_data_list("ipSystemStatsTable", NULL, NULL);

    /*
     * No support for any flags yet, but in the future you would
     * set any flags here.
     */
    flags = 0;

    /*
     * call interface initialization code
     */
    _ipSystemStatsTable_initialize_interface
	(ipSystemStatsTable_user_context_p, flags);
}                               /* initialize_table_ipSystemStatsTable */

/**
 * Shutdown the table ipSystemStatsTable 
 */
void
shutdown_table_ipSystemStatsTable(void)
{
    /*
     * call interface shutdown code
     */
    _ipSystemStatsTable_shutdown_interface
        (ipSystemStatsTable_user_context_p);
    netsnmp_free_all_list_data(ipSystemStatsTable_user_context_p);
    ipSystemStatsTable_user_context_p = NULL;
}

/**
 * extra context initialization (eg default values)
 *
 * @param rowreq_ctx    : row request context
 * @param user_init_ctx : void pointer for user (parameter to rowreq_ctx_allocate)
 *
 * @retval MFD_SUCCESS  : no errors
 * @retval MFD_ERROR    : error (context allocate will fail)
 */
int
ipSystemStatsTable_rowreq_ctx_init(ipSystemStatsTable_rowreq_ctx *
                                   rowreq_ctx, void *user_init_ctx)
{
    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsTable_rowreq_ctx_init", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:210:o: |-> Perform extra ipSystemStatsTable rowreq initialization. (eg DEFVALS)
     */

    return MFD_SUCCESS;
}                               /* ipSystemStatsTable_rowreq_ctx_init */

/**
 * extra context cleanup
 *
 */
void
ipSystemStatsTable_rowreq_ctx_cleanup(ipSystemStatsTable_rowreq_ctx *
                                      rowreq_ctx)
{
    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsTable_rowreq_ctx_cleanup", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:211:o: |-> Perform extra ipSystemStatsTable rowreq cleanup.
     */
    netsnmp_access_systemstats_entry_free(rowreq_ctx->data);
    rowreq_ctx->data = NULL;
}                               /* ipSystemStatsTable_rowreq_ctx_cleanup */

/**
 * pre-request callback
 *
 * @param user_context
 *
 * @retval MFD_SUCCESS              : success.
 * @retval MFD_ERROR                : other error
 */
int
ipSystemStatsTable_pre_request(ipSystemStatsTable_registration *
                               user_context)
{
    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsTable_pre_request", "called\n"));

    /*
     * TODO:510:o: Perform ipSystemStatsTable pre-request actions.
     */

    return MFD_SUCCESS;
}                               /* ipSystemStatsTable_pre_request */

/**
 * post-request callback
 *
 * Note:
 *   New rows have been inserted into the container, and
 *   deleted rows have been removed from the container and
 *   released.
 * @param user_context
 * @param rc : MFD_SUCCESS if all requests succeeded
 *
 * @retval MFD_SUCCESS : success.
 * @retval MFD_ERROR   : other error (ignored)
 */
int
ipSystemStatsTable_post_request(ipSystemStatsTable_registration *
                                user_context, int rc)
{
    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsTable_post_request", "called\n"));

    /*
     * TODO:511:o: Perform ipSystemStatsTable post-request actions.
     */

    return MFD_SUCCESS;
}                               /* ipSystemStatsTable_post_request */


/**********************************************************************
 **********************************************************************
 ***
 *** Table ipSystemStatsTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * IP-MIB::ipSystemStatsTable is subid 1 of ipTrafficStats.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.4.31.1, length: 9
 */

/*
 * ---------------------------------------------------------------------
 * * TODO:200:r: Implement ipSystemStatsTable data context functions.
 */
/*
 * ipSystemStatsTable_allocate_data
 *
 * Purpose: create new ipSystemStatsTable_data.
 */
ipSystemStatsTable_data *
ipSystemStatsTable_allocate_data(void)
{
    /*
     * TODO:201:r: |-> allocate memory for the ipSystemStatsTable data context.
     */
    ipSystemStatsTable_data *rtn =
        SNMP_MALLOC_TYPEDEF(ipSystemStatsTable_data);

    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsTable_allocate_data", "called\n"));

    if (NULL == rtn) {
        snmp_log(LOG_ERR, "unable to malloc memory for new "
                 "ipSystemStatsTable_data.\n");
    }

    return rtn;
}                               /* ipSystemStatsTable_allocate_data */

/*
 * ipSystemStatsTable_release_data
 *
 * Purpose: release ipSystemStatsTable data.
 */
void
ipSystemStatsTable_release_data(ipSystemStatsTable_data * data)
{
    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsTable_release_data", "called\n"));

    /*
     * TODO:202:r: |-> release memory for the ipSystemStatsTable data context.
     */
    free(data);
}                               /* ipSystemStatsTable_release_data */



/**
 * set mib index(es)
 *
 * @param tbl_idx mib index structure
 * @param ipSystemStatsIPVersion_val
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This convenience function is useful for setting all the MIB index
 *  components with a single function call. It is assume that the C values
 *  have already been mapped from their native/rawformat to the MIB format.
 */
int
ipSystemStatsTable_indexes_set_tbl_idx(ipSystemStatsTable_mib_index *
                                       tbl_idx,
                                       u_long ipSystemStatsIPVersion_val)
{
    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsTable_indexes_set_tbl_idx", "called\n"));

    /*
     * ipSystemStatsIPVersion(1)/InetVersion/ASN_INTEGER/long(u_long)//l/a/w/E/r/d/h 
     */
    /** WARNING: this code might not work for netsnmp_systemstats_entry */
    tbl_idx->ipSystemStatsIPVersion = ipSystemStatsIPVersion_val;


    return MFD_SUCCESS;
}                               /* ipSystemStatsTable_indexes_set_tbl_idx */

/**
 * @internal
 * set row context indexes
 *
 * @param reqreq_ctx the row context that needs updated indexes
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 *
 * @remark
 *  This function sets the mib indexs, then updates the oid indexs
 *  from the mib index.
 */
int
ipSystemStatsTable_indexes_set(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                               u_long ipSystemStatsIPVersion_val)
{
    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsTable_indexes_set", "called\n"));

    if (MFD_SUCCESS !=
        ipSystemStatsTable_indexes_set_tbl_idx(&rowreq_ctx->tbl_idx,
                                               ipSystemStatsIPVersion_val))
        return MFD_ERROR;

    /*
     * convert mib index to oid index
     */
    rowreq_ctx->oid_idx.len = sizeof(rowreq_ctx->oid_tmp) / sizeof(oid);
    if (0 != ipSystemStatsTable_index_to_oid(&rowreq_ctx->oid_idx,
                                             &rowreq_ctx->tbl_idx)) {
        return MFD_ERROR;
    }

    return MFD_SUCCESS;
}                               /* ipSystemStatsTable_indexes_set */


/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInReceives
 * ipSystemStatsInReceives is subid 3 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.3
 * Description:
The total number of input IP datagrams received, including
            those received in error.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInReceives data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInReceives_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInReceives_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                            u_long * ipSystemStatsInReceives_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInReceives_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInReceives_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);
    
    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInReceives data.
     * copy (* ipSystemStatsInReceives_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINRECEIVES])
        return MFD_SKIP;

    (*ipSystemStatsInReceives_val_ptr) =
        rowreq_ctx->data->stats.HCInReceives.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInReceives_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCInReceives
 * ipSystemStatsHCInReceives is subid 4 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.4
 * Description:
The total number of input IP datagrams received, including
            those received in error.  This object counts the same
            datagrams as ipSystemStatsInReceives but allows for larger




            values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCInReceives data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCInReceives_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCInReceives_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                              U64 * ipSystemStatsHCInReceives_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCInReceives_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCInReceives data.
     * get (* ipSystemStatsHCInReceives_val_ptr ).low and (* ipSystemStatsHCInReceives_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINRECEIVES])
        return MFD_SKIP;

    (*ipSystemStatsHCInReceives_val_ptr).low =
        rowreq_ctx->data->stats.HCInReceives.low;
    (*ipSystemStatsHCInReceives_val_ptr).high =
        rowreq_ctx->data->stats.HCInReceives.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCInReceives_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInOctets
 * ipSystemStatsInOctets is subid 5 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.5
 * Description:
The total number of octets received in input IP datagrams,
            including those received in error.  Octets from datagrams
            counted in ipSystemStatsInReceives MUST be counted here.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInOctets_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInOctets_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                          u_long * ipSystemStatsInOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInOctets_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInOctets_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInOctets data.
     * copy (* ipSystemStatsInOctets_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINOCTETS])
        return MFD_SKIP;

    (*ipSystemStatsInOctets_val_ptr) =
        rowreq_ctx->data->stats.HCInOctets.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCInOctets
 * ipSystemStatsHCInOctets is subid 6 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.6
 * Description:
The total number of octets received in input IP datagrams,
            including those received in error.  This object counts the
            same octets as ipSystemStatsInOctets but allows for larger
            values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCInOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCInOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCInOctets_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                            U64 * ipSystemStatsHCInOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCInOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCInOctets data.
     * get (* ipSystemStatsHCInOctets_val_ptr ).low and (* ipSystemStatsHCInOctets_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINOCTETS])
        return MFD_SKIP;

    (*ipSystemStatsHCInOctets_val_ptr).low =
        rowreq_ctx->data->stats.HCInOctets.low;
    (*ipSystemStatsHCInOctets_val_ptr).high =
        rowreq_ctx->data->stats.HCInOctets.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCInOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInHdrErrors
 * ipSystemStatsInHdrErrors is subid 7 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.7
 * Description:
The number of input IP datagrams discarded due to errors in
            their IP headers, including version number mismatch, other
            format errors, hop count exceeded, errors discovered in
            processing their IP options, etc.




            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInHdrErrors data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInHdrErrors_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInHdrErrors_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long * ipSystemStatsInHdrErrors_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInHdrErrors_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInHdrErrors_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInHdrErrors data.
     * copy (* ipSystemStatsInHdrErrors_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_INHDRERRORS])
        return MFD_SKIP;

    (*ipSystemStatsInHdrErrors_val_ptr) =
        rowreq_ctx->data->stats.InHdrErrors;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInHdrErrors_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInNoRoutes
 * ipSystemStatsInNoRoutes is subid 8 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.8
 * Description:
The number of input IP datagrams discarded because no route
            could be found to transmit them to their destination.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInNoRoutes data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInNoRoutes_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInNoRoutes_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                            u_long * ipSystemStatsInNoRoutes_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInNoRoutes_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInNoRoutes_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInNoRoutes data.
     * copy (* ipSystemStatsInNoRoutes_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINNOROUTES])
        return MFD_SKIP;

    (*ipSystemStatsInNoRoutes_val_ptr) =
        rowreq_ctx->data->stats.HCInNoRoutes.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInNoRoutes_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInAddrErrors
 * ipSystemStatsInAddrErrors is subid 9 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.9
 * Description:
The number of input IP datagrams discarded because the IP
            address in their IP header's destination field was not a
            valid address to be received at this entity.  This count
            includes invalid addresses (e.g., ::0) and unsupported
            addresses (e.g., addresses with unallocated prefixes).  For
            entities which are not IP routers and therefore do not
            forward datagrams, this counter includes datagrams discarded
            because the destination address was not a local address.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInAddrErrors data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInAddrErrors_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInAddrErrors_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                              u_long * ipSystemStatsInAddrErrors_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInAddrErrors_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInAddrErrors_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInAddrErrors data.
     * copy (* ipSystemStatsInAddrErrors_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_INADDRERRORS])
        return MFD_SKIP;

    (*ipSystemStatsInAddrErrors_val_ptr) =
        rowreq_ctx->data->stats.InAddrErrors;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInAddrErrors_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInUnknownProtos
 * ipSystemStatsInUnknownProtos is subid 10 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.10
 * Description:
The number of locally-addressed IP datagrams received
            successfully but discarded because of an unknown or
            unsupported protocol.




            When tracking interface statistics the counter of the
            interface to which these datagrams were addressed is
            incremented.  This interface might not be the same as the
            input interface for some of the datagrams.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInUnknownProtos data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInUnknownProtos_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInUnknownProtos_get(ipSystemStatsTable_rowreq_ctx *
                                 rowreq_ctx,
                                 u_long *
                                 ipSystemStatsInUnknownProtos_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInUnknownProtos_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInUnknownProtos_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInUnknownProtos data.
     * copy (* ipSystemStatsInUnknownProtos_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_INUNKNOWNPROTOS])
        return MFD_SKIP;

    (*ipSystemStatsInUnknownProtos_val_ptr) =
        rowreq_ctx->data->stats.InUnknownProtos;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInUnknownProtos_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInTruncatedPkts
 * ipSystemStatsInTruncatedPkts is subid 11 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.11
 * Description:
The number of input IP datagrams discarded because the
            datagram frame didn't carry enough data.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInTruncatedPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInTruncatedPkts_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInTruncatedPkts_get(ipSystemStatsTable_rowreq_ctx *
                                 rowreq_ctx,
                                 u_long *
                                 ipSystemStatsInTruncatedPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInTruncatedPkts_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInTruncatedPkts_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInTruncatedPkts data.
     * copy (* ipSystemStatsInTruncatedPkts_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_INTRUNCATEDPKTS])
        return MFD_SKIP;

    (*ipSystemStatsInTruncatedPkts_val_ptr) =
        rowreq_ctx->data->stats.InTruncatedPkts;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInTruncatedPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInForwDatagrams
 * ipSystemStatsInForwDatagrams is subid 12 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.12
 * Description:
The number of input datagrams for which this entity was not
            their final IP destination and for which this entity
            attempted to find a route to forward them to that final
            destination.  In entities which do not act as IP routers,
            this counter will include only those datagrams which were
            Source-Routed via this entity, and the Source-Route
            processing was successful.


            When tracking interface statistics the counter of the
            incoming interface is incremented for each datagram.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInForwDatagrams data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInForwDatagrams_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInForwDatagrams_get(ipSystemStatsTable_rowreq_ctx *
                                 rowreq_ctx,
                                 u_long *
                                 ipSystemStatsInForwDatagrams_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInForwDatagrams_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInForwDatagrams_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInForwDatagrams data.
     * copy (* ipSystemStatsInForwDatagrams_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINFORWDATAGRAMS])
        return MFD_SKIP;

    (*ipSystemStatsInForwDatagrams_val_ptr) =
        rowreq_ctx->data->stats.HCInForwDatagrams.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInForwDatagrams_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCInForwDatagrams
 * ipSystemStatsHCInForwDatagrams is subid 13 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.13
 * Description:
The number of input datagrams for which this entity was not
            their final IP destination and for which this entity
            attempted to find a route to forward them to that final
            destination.  This object counts the same packets as
            ipSystemStatsInForwDatagrams but allows for larger values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCInForwDatagrams data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCInForwDatagrams_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCInForwDatagrams_get(ipSystemStatsTable_rowreq_ctx *
                                   rowreq_ctx,
                                   U64 *
                                   ipSystemStatsHCInForwDatagrams_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCInForwDatagrams_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCInForwDatagrams data.
     * get (* ipSystemStatsHCInForwDatagrams_val_ptr ).low and (* ipSystemStatsHCInForwDatagrams_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINFORWDATAGRAMS])
        return MFD_SKIP;

    (*ipSystemStatsHCInForwDatagrams_val_ptr).low =
        rowreq_ctx->data->stats.HCInForwDatagrams.low;
    (*ipSystemStatsHCInForwDatagrams_val_ptr).high =
        rowreq_ctx->data->stats.HCInForwDatagrams.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCInForwDatagrams_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsReasmReqds
 * ipSystemStatsReasmReqds is subid 14 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.14
 * Description:
The number of IP fragments received which needed to be
            reassembled at this interface.


            When tracking interface statistics the counter of the
            interface to which these fragments were addressed is
            incremented.  This interface might not be the same as the
            input interface for some of the fragments.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsReasmReqds data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsReasmReqds_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsReasmReqds_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                            u_long * ipSystemStatsReasmReqds_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsReasmReqds_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsReasmReqds_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsReasmReqds data.
     * copy (* ipSystemStatsReasmReqds_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_REASMREQDS])
        return MFD_SKIP;

    (*ipSystemStatsReasmReqds_val_ptr) =
        rowreq_ctx->data->stats.ReasmReqds;

    return MFD_SUCCESS;
}                               /* ipSystemStatsReasmReqds_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsReasmOKs
 * ipSystemStatsReasmOKs is subid 15 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.15
 * Description:
The number of IP datagrams successfully reassembled.


            When tracking interface statistics the counter of the
            interface to which these datagrams were addressed is
            incremented.  This interface might not be the same as the
            input interface for some of the datagrams.


            Discontinuities in the value of this counter can occur at




            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsReasmOKs data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsReasmOKs_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsReasmOKs_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                          u_long * ipSystemStatsReasmOKs_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsReasmOKs_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsReasmOKs_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsReasmOKs data.
     * copy (* ipSystemStatsReasmOKs_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_REASMOKS])
        return MFD_SKIP;

    (*ipSystemStatsReasmOKs_val_ptr) = rowreq_ctx->data->stats.ReasmOKs;

    return MFD_SUCCESS;
}                               /* ipSystemStatsReasmOKs_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsReasmFails
 * ipSystemStatsReasmFails is subid 16 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.16
 * Description:
The number of failures detected by the IP re-assembly
            algorithm (for whatever reason: timed out, errors, etc.).
            Note that this is not necessarily a count of discarded IP
            fragments since some algorithms (notably the algorithm in
            RFC 815) can lose track of the number of fragments by
            combining them as they are received.


            When tracking interface statistics the counter of the
            interface to which these fragments were addressed is
            incremented.  This interface might not be the same as the
            input interface for some of the fragments.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsReasmFails data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsReasmFails_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsReasmFails_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                            u_long * ipSystemStatsReasmFails_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsReasmFails_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsReasmFails_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsReasmFails data.
     * copy (* ipSystemStatsReasmFails_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_REASMFAILS])
        return MFD_SKIP;

    (*ipSystemStatsReasmFails_val_ptr) =
        rowreq_ctx->data->stats.ReasmFails;

    return MFD_SUCCESS;
}                               /* ipSystemStatsReasmFails_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInDiscards
 * ipSystemStatsInDiscards is subid 17 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.17
 * Description:
The number of input IP datagrams for which no problems were
            encountered to prevent their continued processing, but which
            were discarded (e.g., for lack of buffer space).  Note that
            this counter does not include any datagrams discarded while
            awaiting re-assembly.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInDiscards data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInDiscards_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInDiscards_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                            u_long * ipSystemStatsInDiscards_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInDiscards_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInDiscards_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInDiscards data.
     * copy (* ipSystemStatsInDiscards_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_INDISCARDS])
        return MFD_SKIP;

    (*ipSystemStatsInDiscards_val_ptr) =
        rowreq_ctx->data->stats.InDiscards;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInDiscards_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInDelivers
 * ipSystemStatsInDelivers is subid 18 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.18
 * Description:
The total number of datagrams successfully delivered to IP
            user-protocols (including ICMP).


            When tracking interface statistics the counter of the
            interface to which these datagrams were addressed is
            incremented.  This interface might not be the same as the
            input interface for some of the datagrams.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInDelivers data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInDelivers_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInDelivers_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                            u_long * ipSystemStatsInDelivers_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInDelivers_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInDelivers_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInDelivers data.
     * copy (* ipSystemStatsInDelivers_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINDELIVERS])
        return MFD_SKIP;

    (*ipSystemStatsInDelivers_val_ptr) =
        rowreq_ctx->data->stats.HCInDelivers.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInDelivers_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCInDelivers
 * ipSystemStatsHCInDelivers is subid 19 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.19
 * Description:
The total number of datagrams successfully delivered to IP
            user-protocols (including ICMP).  This object counts the
            same packets as ipSystemStatsInDelivers but allows for
            larger values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCInDelivers data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCInDelivers_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCInDelivers_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                              U64 * ipSystemStatsHCInDelivers_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCInDelivers_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCInDelivers data.
     * get (* ipSystemStatsHCInDelivers_val_ptr ).low and (* ipSystemStatsHCInDelivers_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINDELIVERS])
        return MFD_SKIP;

    (*ipSystemStatsHCInDelivers_val_ptr).low =
        rowreq_ctx->data->stats.HCInDelivers.low;
    (*ipSystemStatsHCInDelivers_val_ptr).high =
        rowreq_ctx->data->stats.HCInDelivers.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCInDelivers_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutRequests
 * ipSystemStatsOutRequests is subid 20 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.20
 * Description:
The total number of IP datagrams which local IP user-
            protocols (including ICMP) supplied to IP in requests for
            transmission.  Note that this counter does not include any
            datagrams counted in ipSystemStatsOutForwDatagrams.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutRequests data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutRequests_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutRequests_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long * ipSystemStatsOutRequests_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutRequests_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutRequests_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutRequests data.
     * copy (* ipSystemStatsOutRequests_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTREQUESTS])
        return MFD_SKIP;

    (*ipSystemStatsOutRequests_val_ptr) =
        rowreq_ctx->data->stats.HCOutRequests.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutRequests_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCOutRequests
 * ipSystemStatsHCOutRequests is subid 21 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.21
 * Description:
The total number of IP datagrams which local IP user-
            protocols (including ICMP) supplied to IP in requests for
            transmission.  This object counts the same packets as
            ipSystemStatsHCOutRequests but allows for larger values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCOutRequests data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCOutRequests_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCOutRequests_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                               U64 * ipSystemStatsHCOutRequests_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCOutRequests_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCOutRequests data.
     * get (* ipSystemStatsHCOutRequests_val_ptr ).low and (* ipSystemStatsHCOutRequests_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTREQUESTS])
        return MFD_SKIP;

    (*ipSystemStatsHCOutRequests_val_ptr).low =
        rowreq_ctx->data->stats.HCOutRequests.low;
    (*ipSystemStatsHCOutRequests_val_ptr).high =
        rowreq_ctx->data->stats.HCOutRequests.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCOutRequests_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutNoRoutes
 * ipSystemStatsOutNoRoutes is subid 22 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.22
 * Description:
The number of locally generated IP datagrams discarded
            because no route could be found to transmit them to their
            destination.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutNoRoutes data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutNoRoutes_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutNoRoutes_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long * ipSystemStatsOutNoRoutes_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutNoRoutes_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutNoRoutes_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutNoRoutes data.
     * copy (* ipSystemStatsOutNoRoutes_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTNOROUTES])
        return MFD_SKIP;

    (*ipSystemStatsOutNoRoutes_val_ptr) =
        rowreq_ctx->data->stats.HCOutNoRoutes.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutNoRoutes_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutForwDatagrams
 * ipSystemStatsOutForwDatagrams is subid 23 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.23
 * Description:
The number of datagrams for which this entity was not their
            final IP destination and for which it was successful in
            finding a path to their final destination.  In entities
            which do not act as IP routers, this counter will include
            only those datagrams which were Source-Routed via this
            entity, and the Source-Route processing was successful.


            When tracking interface statistics the counter of the
            outgoing interface is incremented for a successfully
            forwarded datagram.


            Discontinuities in the value of this counter can occur at




            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutForwDatagrams data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutForwDatagrams_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutForwDatagrams_get(ipSystemStatsTable_rowreq_ctx *
                                  rowreq_ctx,
                                  u_long *
                                  ipSystemStatsOutForwDatagrams_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutForwDatagrams_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutForwDatagrams_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutForwDatagrams data.
     * copy (* ipSystemStatsOutForwDatagrams_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFORWDATAGRAMS])
        return MFD_SKIP;

    (*ipSystemStatsOutForwDatagrams_val_ptr) =
        rowreq_ctx->data->stats.HCOutForwDatagrams.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutForwDatagrams_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCOutForwDatagrams
 * ipSystemStatsHCOutForwDatagrams is subid 24 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.24
 * Description:
The number of datagrams for which this entity was not their
            final IP destination and for which it was successful in
            finding a path to their final destination.  This object
            counts the same packets as ipSystemStatsOutForwDatagrams but
            allows for larger values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCOutForwDatagrams data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCOutForwDatagrams_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCOutForwDatagrams_get(ipSystemStatsTable_rowreq_ctx *
                                    rowreq_ctx,
                                    U64 *
                                    ipSystemStatsHCOutForwDatagrams_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCOutForwDatagrams_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCOutForwDatagrams data.
     * get (* ipSystemStatsHCOutForwDatagrams_val_ptr ).low and (* ipSystemStatsHCOutForwDatagrams_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFORWDATAGRAMS])
        return MFD_SKIP;

    (*ipSystemStatsHCOutForwDatagrams_val_ptr).low =
        rowreq_ctx->data->stats.HCOutForwDatagrams.low;
    (*ipSystemStatsHCOutForwDatagrams_val_ptr).high =
        rowreq_ctx->data->stats.HCOutForwDatagrams.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCOutForwDatagrams_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutDiscards
 * ipSystemStatsOutDiscards is subid 25 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.25
 * Description:
The number of output IP datagrams for which no problem was
            encountered to prevent their transmission to their
            destination, but which were discarded (e.g., for lack of
            buffer space).  Note that this counter would include
            datagrams counted in ipSystemStatsOutForwDatagrams if any
            such datagrams met this (discretionary) discard criterion.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutDiscards data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutDiscards_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutDiscards_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long * ipSystemStatsOutDiscards_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutDiscards_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutDiscards_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutDiscards data.
     * copy (* ipSystemStatsOutDiscards_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTDISCARDS])
        return MFD_SKIP;

    (*ipSystemStatsOutDiscards_val_ptr) =
        rowreq_ctx->data->stats.HCOutDiscards.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutDiscards_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutFragReqds
 * ipSystemStatsOutFragReqds is subid 26 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.26
 * Description:
The number of IP datagrams that would require fragmentation
            in order to be transmitted.





            When tracking interface statistics the counter of the
            outgoing interface is incremented for a successfully
            fragmented datagram.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutFragReqds data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutFragReqds_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutFragReqds_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                              u_long * ipSystemStatsOutFragReqds_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutFragReqds_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutFragReqds_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutFragReqds data.
     * copy (* ipSystemStatsOutFragReqds_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFRAGREQDS])
        return MFD_SKIP;

    (*ipSystemStatsOutFragReqds_val_ptr) =
        rowreq_ctx->data->stats.HCOutFragReqds.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutFragReqds_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutFragOKs
 * ipSystemStatsOutFragOKs is subid 27 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.27
 * Description:
The number of IP datagrams that have been successfully
            fragmented.


            When tracking interface statistics the counter of the
            outgoing interface is incremented for a successfully
            fragmented datagram.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutFragOKs data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutFragOKs_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutFragOKs_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                            u_long * ipSystemStatsOutFragOKs_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutFragOKs_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutFragOKs_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutFragOKs data.
     * copy (* ipSystemStatsOutFragOKs_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFRAGOKS])
        return MFD_SKIP;

    (*ipSystemStatsOutFragOKs_val_ptr) =
        rowreq_ctx->data->stats.HCOutFragOKs.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutFragOKs_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutFragFails
 * ipSystemStatsOutFragFails is subid 28 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.28
 * Description:
The number of IP datagrams that have been discarded because
            they needed to be fragmented but could not be.  This
            includes IPv4 packets that have the DF bit set and IPv6
            packets that are being forwarded and exceed the outgoing
            link MTU.


            When tracking interface statistics the counter of the
            outgoing interface is incremented for an unsuccessfully
            fragmented datagram.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutFragFails data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutFragFails_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutFragFails_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                              u_long * ipSystemStatsOutFragFails_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutFragFails_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutFragFails_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutFragFails data.
     * copy (* ipSystemStatsOutFragFails_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFRAGFAILS])
        return MFD_SKIP;

    (*ipSystemStatsOutFragFails_val_ptr) =
        rowreq_ctx->data->stats.HCOutFragFails.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutFragFails_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutFragCreates
 * ipSystemStatsOutFragCreates is subid 29 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.29
 * Description:
The number of output datagram fragments that have been
            generated as a result of IP fragmentation.


            When tracking interface statistics the counter of the
            outgoing interface is incremented for a successfully
            fragmented datagram.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutFragCreates data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutFragCreates_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutFragCreates_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                                u_long *
                                ipSystemStatsOutFragCreates_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutFragCreates_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutFragCreates_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutFragCreates data.
     * copy (* ipSystemStatsOutFragCreates_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTFRAGCREATES])
        return MFD_SKIP;

    (*ipSystemStatsOutFragCreates_val_ptr) =
        rowreq_ctx->data->stats.HCOutFragCreates.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutFragCreates_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutTransmits
 * ipSystemStatsOutTransmits is subid 30 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.30
 * Description:
The total number of IP datagrams that this entity supplied
            to the lower layers for transmission.  This includes
            datagrams generated local and those forwarded by this
            entity.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutTransmits data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutTransmits_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutTransmits_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                              u_long * ipSystemStatsOutTransmits_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutTransmits_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutTransmits_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutTransmits data.
     * copy (* ipSystemStatsOutTransmits_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTTRANSMITS])
        return MFD_SKIP;

    (*ipSystemStatsOutTransmits_val_ptr) =
        rowreq_ctx->data->stats.HCOutTransmits.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutTransmits_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCOutTransmits
 * ipSystemStatsHCOutTransmits is subid 31 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.31
 * Description:
The total number of IP datagrams that this entity supplied
            to the lower layers for transmission.  This object counts
            the same datagrams as ipSystemStatsOutTransmits but allows
            for larger values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCOutTransmits data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCOutTransmits_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCOutTransmits_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                                U64 * ipSystemStatsHCOutTransmits_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCOutTransmits_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCOutTransmits data.
     * get (* ipSystemStatsHCOutTransmits_val_ptr ).low and (* ipSystemStatsHCOutTransmits_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTTRANSMITS])
        return MFD_SKIP;

    (*ipSystemStatsHCOutTransmits_val_ptr).low =
        rowreq_ctx->data->stats.HCOutTransmits.low;
    (*ipSystemStatsHCOutTransmits_val_ptr).high =
        rowreq_ctx->data->stats.HCOutTransmits.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCOutTransmits_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutOctets
 * ipSystemStatsOutOctets is subid 32 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.32
 * Description:
The total number of octets in IP datagrams delivered to the
            lower layers for transmission.  Octets from datagrams
            counted in ipSystemStatsOutTransmits MUST be counted here.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutOctets_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutOctets_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                           u_long * ipSystemStatsOutOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutOctets_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutOctets_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutOctets data.
     * copy (* ipSystemStatsOutOctets_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTOCTETS])
        return MFD_SKIP;

    (*ipSystemStatsOutOctets_val_ptr) =
        rowreq_ctx->data->stats.HCOutOctets.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCOutOctets
 * ipSystemStatsHCOutOctets is subid 33 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.33
 * Description:
The total number of octets in IP datagrams delivered to the
            lower layers for transmission.  This objects counts the same
            octets as ipSystemStatsOutOctets but allows for larger
            values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCOutOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCOutOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCOutOctets_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                             U64 * ipSystemStatsHCOutOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCOutOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCOutOctets data.
     * get (* ipSystemStatsHCOutOctets_val_ptr ).low and (* ipSystemStatsHCOutOctets_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTOCTETS])
        return MFD_SKIP;

    (*ipSystemStatsHCOutOctets_val_ptr).low =
        rowreq_ctx->data->stats.HCOutOctets.low;
    (*ipSystemStatsHCOutOctets_val_ptr).high =
        rowreq_ctx->data->stats.HCOutOctets.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCOutOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInMcastPkts
 * ipSystemStatsInMcastPkts is subid 34 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.34
 * Description:
The number of IP multicast datagrams received.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInMcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInMcastPkts_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInMcastPkts_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long * ipSystemStatsInMcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInMcastPkts_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInMcastPkts_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInMcastPkts data.
     * copy (* ipSystemStatsInMcastPkts_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINMCASTPKTS])
        return MFD_SKIP;

    (*ipSystemStatsInMcastPkts_val_ptr) =
        rowreq_ctx->data->stats.HCInMcastPkts.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInMcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCInMcastPkts
 * ipSystemStatsHCInMcastPkts is subid 35 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.35
 * Description:
The number of IP multicast datagrams received.  This object
            counts the same datagrams as ipSystemStatsInMcastPkts but
            allows for larger values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCInMcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCInMcastPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCInMcastPkts_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                               U64 * ipSystemStatsHCInMcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCInMcastPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCInMcastPkts data.
     * get (* ipSystemStatsHCInMcastPkts_val_ptr ).low and (* ipSystemStatsHCInMcastPkts_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINMCASTPKTS])
        return MFD_SKIP;

    (*ipSystemStatsHCInMcastPkts_val_ptr).low =
        rowreq_ctx->data->stats.HCInMcastPkts.low;
    (*ipSystemStatsHCInMcastPkts_val_ptr).high =
        rowreq_ctx->data->stats.HCInMcastPkts.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCInMcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInMcastOctets
 * ipSystemStatsInMcastOctets is subid 36 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.36
 * Description:
The total number of octets received in IP multicast
            datagrams.  Octets from datagrams counted in
            ipSystemStatsOutMcastPkts MUST be counted here.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInMcastOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInMcastOctets_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInMcastOctets_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                               u_long * ipSystemStatsInMcastOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInMcastOctets_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInMcastOctets_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInMcastOctets data.
     * copy (* ipSystemStatsInMcastOctets_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINMCASTOCTETS])
        return MFD_SKIP;

    (*ipSystemStatsInMcastOctets_val_ptr) =
        rowreq_ctx->data->stats.HCInMcastOctets.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInMcastOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCInMcastOctets
 * ipSystemStatsHCInMcastOctets is subid 37 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.37
 * Description:
The total number of octets received in IP multicast
            datagrams.  This object counts the same octets as
            ipSystemStatsInMcastOctets but allows for larger values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCInMcastOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCInMcastOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCInMcastOctets_get(ipSystemStatsTable_rowreq_ctx *
                                 rowreq_ctx,
                                 U64 *
                                 ipSystemStatsHCInMcastOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCInMcastOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCInMcastOctets data.
     * get (* ipSystemStatsHCInMcastOctets_val_ptr ).low and (* ipSystemStatsHCInMcastOctets_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINMCASTOCTETS])
        return MFD_SKIP;

    (*ipSystemStatsHCInMcastOctets_val_ptr).low =
        rowreq_ctx->data->stats.HCInMcastOctets.low;
    (*ipSystemStatsHCInMcastOctets_val_ptr).high =
        rowreq_ctx->data->stats.HCInMcastOctets.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCInMcastOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutMcastPkts
 * ipSystemStatsOutMcastPkts is subid 38 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.38
 * Description:
The number of IP multicast datagrams transmitted.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutMcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutMcastPkts_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutMcastPkts_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                              u_long * ipSystemStatsOutMcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutMcastPkts_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutMcastPkts_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutMcastPkts data.
     * copy (* ipSystemStatsOutMcastPkts_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTMCASTPKTS])
        return MFD_SKIP;

    (*ipSystemStatsOutMcastPkts_val_ptr) =
        rowreq_ctx->data->stats.HCOutMcastPkts.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutMcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCOutMcastPkts
 * ipSystemStatsHCOutMcastPkts is subid 39 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.39
 * Description:
The number of IP multicast datagrams transmitted.  This
            object counts the same datagrams as
            ipSystemStatsOutMcastPkts but allows for larger values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCOutMcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCOutMcastPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCOutMcastPkts_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                                U64 * ipSystemStatsHCOutMcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCOutMcastPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCOutMcastPkts data.
     * get (* ipSystemStatsHCOutMcastPkts_val_ptr ).low and (* ipSystemStatsHCOutMcastPkts_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTMCASTPKTS])
        return MFD_SKIP;

    (*ipSystemStatsHCOutMcastPkts_val_ptr).low =
        rowreq_ctx->data->stats.HCOutMcastPkts.low;
    (*ipSystemStatsHCOutMcastPkts_val_ptr).high =
        rowreq_ctx->data->stats.HCOutMcastPkts.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCOutMcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutMcastOctets
 * ipSystemStatsOutMcastOctets is subid 40 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.40
 * Description:
The total number of octets transmitted in IP multicast
            datagrams.  Octets from datagrams counted in
            ipSystemStatsInMcastPkts MUST be counted here.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutMcastOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutMcastOctets_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutMcastOctets_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                                u_long *
                                ipSystemStatsOutMcastOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutMcastOctets_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutMcastOctets_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutMcastOctets data.
     * copy (* ipSystemStatsOutMcastOctets_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTMCASTOCTETS])
        return MFD_SKIP;

    (*ipSystemStatsOutMcastOctets_val_ptr) =
        rowreq_ctx->data->stats.HCOutMcastOctets.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutMcastOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCOutMcastOctets
 * ipSystemStatsHCOutMcastOctets is subid 41 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.41
 * Description:
The total number of octets transmitted in IP multicast
            datagrams.  This object counts the same octets as
            ipSystemStatsOutMcastOctets but allows for larger values.


            Discontinuities in the value of this counter can occur at




            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCOutMcastOctets data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCOutMcastOctets_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCOutMcastOctets_get(ipSystemStatsTable_rowreq_ctx *
                                  rowreq_ctx,
                                  U64 *
                                  ipSystemStatsHCOutMcastOctets_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCOutMcastOctets_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCOutMcastOctets data.
     * get (* ipSystemStatsHCOutMcastOctets_val_ptr ).low and (* ipSystemStatsHCOutMcastOctets_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTMCASTOCTETS])
        return MFD_SKIP;

    (*ipSystemStatsHCOutMcastOctets_val_ptr).low =
        rowreq_ctx->data->stats.HCOutMcastOctets.low;
    (*ipSystemStatsHCOutMcastOctets_val_ptr).high =
        rowreq_ctx->data->stats.HCOutMcastOctets.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCOutMcastOctets_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsInBcastPkts
 * ipSystemStatsInBcastPkts is subid 42 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.42
 * Description:
The number of IP broadcast datagrams received.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsInBcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsInBcastPkts_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsInBcastPkts_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long * ipSystemStatsInBcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsInBcastPkts_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsInBcastPkts_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsInBcastPkts data.
     * copy (* ipSystemStatsInBcastPkts_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINBCASTPKTS])
        return MFD_SKIP;

    (*ipSystemStatsInBcastPkts_val_ptr) =
        rowreq_ctx->data->stats.HCInBcastPkts.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsInBcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCInBcastPkts
 * ipSystemStatsHCInBcastPkts is subid 43 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.43
 * Description:
The number of IP broadcast datagrams received.  This object
            counts the same datagrams as ipSystemStatsInBcastPkts but
            allows for larger values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCInBcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCInBcastPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCInBcastPkts_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                               U64 * ipSystemStatsHCInBcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCInBcastPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCInBcastPkts data.
     * get (* ipSystemStatsHCInBcastPkts_val_ptr ).low and (* ipSystemStatsHCInBcastPkts_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCINBCASTPKTS])
        return MFD_SKIP;

    (*ipSystemStatsHCInBcastPkts_val_ptr).low =
        rowreq_ctx->data->stats.HCInBcastPkts.low;
    (*ipSystemStatsHCInBcastPkts_val_ptr).high =
        rowreq_ctx->data->stats.HCInBcastPkts.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCInBcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsOutBcastPkts
 * ipSystemStatsOutBcastPkts is subid 44 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.44
 * Description:
The number of IP broadcast datagrams transmitted.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER (based on perltype COUNTER)
 * The net-snmp type is ASN_COUNTER. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsOutBcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsOutBcastPkts_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsOutBcastPkts_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                              u_long * ipSystemStatsOutBcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsOutBcastPkts_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsOutBcastPkts_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsOutBcastPkts data.
     * copy (* ipSystemStatsOutBcastPkts_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTBCASTPKTS])
        return MFD_SKIP;

    (*ipSystemStatsOutBcastPkts_val_ptr) =
        rowreq_ctx->data->stats.HCOutBcastPkts.low;

    return MFD_SUCCESS;
}                               /* ipSystemStatsOutBcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsHCOutBcastPkts
 * ipSystemStatsHCOutBcastPkts is subid 45 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.45
 * Description:
The number of IP broadcast datagrams transmitted.  This
            object counts the same datagrams as
            ipSystemStatsOutBcastPkts but allows for larger values.


            Discontinuities in the value of this counter can occur at
            re-initialization of the management system, and at other
            times as indicated by the value of
            ipSystemStatsDiscontinuityTime.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is COUNTER64 (based on perltype COUNTER64)
 * The net-snmp type is ASN_COUNTER64. The C type decl is U64 (U64)
 */
/**
 * Extract the current value of the ipSystemStatsHCOutBcastPkts data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsHCOutBcastPkts_val_ptr
 *        Pointer to storage for a U64 variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsHCOutBcastPkts_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                                U64 * ipSystemStatsHCOutBcastPkts_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsHCOutBcastPkts_val_ptr);

    /*
     * TODO:231:o: |-> copy ipSystemStatsHCOutBcastPkts data.
     * get (* ipSystemStatsHCOutBcastPkts_val_ptr ).low and (* ipSystemStatsHCOutBcastPkts_val_ptr ).high from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_HCOUTBCASTPKTS])
        return MFD_SKIP;

    (*ipSystemStatsHCOutBcastPkts_val_ptr).low =
        rowreq_ctx->data->stats.HCOutBcastPkts.low;
    (*ipSystemStatsHCOutBcastPkts_val_ptr).high =
        rowreq_ctx->data->stats.HCOutBcastPkts.high;

    return MFD_SUCCESS;
}                               /* ipSystemStatsHCOutBcastPkts_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsDiscontinuityTime
 * ipSystemStatsDiscontinuityTime is subid 46 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.46
 * Description:
The value of sysUpTime on the most recent occasion at which
            any one or more of this entry's counters suffered a
            discontinuity.


            If no such discontinuities have occurred since the last re-
            initialization of the local management subsystem, then this
            object contains a zero value.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is TimeStamp (based on perltype TICKS)
 * The net-snmp type is ASN_TIMETICKS. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsDiscontinuityTime data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsDiscontinuityTime_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsDiscontinuityTime_get(ipSystemStatsTable_rowreq_ctx *
                                   rowreq_ctx,
                                   u_long *
                                   ipSystemStatsDiscontinuityTime_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsDiscontinuityTime_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsDiscontinuityTime_get", "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsDiscontinuityTime data.
     * copy (* ipSystemStatsDiscontinuityTime_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_DISCONTINUITYTIME])
        return MFD_SKIP;

    (*ipSystemStatsDiscontinuityTime_val_ptr) =
        rowreq_ctx->ipSystemStatsDiscontinuityTime;

    return MFD_SUCCESS;
}                               /* ipSystemStatsDiscontinuityTime_get */

/*---------------------------------------------------------------------
 * IP-MIB::ipSystemStatsEntry.ipSystemStatsRefreshRate
 * ipSystemStatsRefreshRate is subid 47 of ipSystemStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.4.31.1.1.47
 * Description:
The minimum reasonable polling interval for this entry.
            This object provides an indication of the minimum amount of
            time required to update the counters in this entry.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 0      hashint   0
 *   settable   0
 *
 *
 * Its syntax is UNSIGNED32 (based on perltype UNSIGNED32)
 * The net-snmp type is ASN_UNSIGNED. The C type decl is u_long (u_long)
 */
/**
 * Extract the current value of the ipSystemStatsRefreshRate data.
 *
 * Set a value using the data context for the row.
 *
 * @param rowreq_ctx
 *        Pointer to the row request context.
 * @param ipSystemStatsRefreshRate_val_ptr
 *        Pointer to storage for a u_long variable
 *
 * @retval MFD_SUCCESS         : success
 * @retval MFD_SKIP            : skip this node (no value for now)
 * @retval MFD_ERROR           : Any other error
 */
int
ipSystemStatsRefreshRate_get(ipSystemStatsTable_rowreq_ctx * rowreq_ctx,
                             u_long * ipSystemStatsRefreshRate_val_ptr)
{
   /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != ipSystemStatsRefreshRate_val_ptr);


    DEBUGMSGTL(("verbose:ipSystemStatsTable:ipSystemStatsRefreshRate_get",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:231:o: |-> Extract the current value of the ipSystemStatsRefreshRate data.
     * copy (* ipSystemStatsRefreshRate_val_ptr ) from rowreq_ctx->data
     */
    if (!rowreq_ctx->data->stats.columnAvail[IPSYSTEMSTATSTABLE_REFRESHRATE])
        return MFD_SKIP;

    (*ipSystemStatsRefreshRate_val_ptr) =
        rowreq_ctx->ipSystemStatsRefreshRate;

    return MFD_SUCCESS;
}                               /* ipSystemStatsRefreshRate_get */



/** @} */
/** @} */
/** @{ */
