/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.BoundType;
import com.google.common.collect.Collections2;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.EmptyContiguousSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
final class RegularContiguousSet<C extends Comparable>
extends ContiguousSet<C> {
    private final Range<C> range;
    private static final long serialVersionUID = 0L;

    RegularContiguousSet(Range<C> range, DiscreteDomain<C> domain) {
        super(domain);
        this.range = range;
    }

    private ContiguousSet<C> intersectionInCurrentDomain(Range<C> other) {
        return this.range.isConnected(other) ? this.range.intersection(other).asSet(this.domain) : new EmptyContiguousSet(this.domain);
    }

    @Override
    ContiguousSet<C> headSetImpl(C toElement, boolean inclusive) {
        return this.intersectionInCurrentDomain(Ranges.upTo(toElement, BoundType.forBoolean(inclusive)));
    }

    @Override
    ContiguousSet<C> subSetImpl(C fromElement, boolean fromInclusive, C toElement, boolean toInclusive) {
        if (fromElement.compareTo(toElement) == 0 && !fromInclusive && !toInclusive) {
            return new EmptyContiguousSet(this.domain);
        }
        return this.intersectionInCurrentDomain(Ranges.range(fromElement, BoundType.forBoolean(fromInclusive), toElement, BoundType.forBoolean(toInclusive)));
    }

    @Override
    ContiguousSet<C> tailSetImpl(C fromElement, boolean inclusive) {
        return this.intersectionInCurrentDomain(Ranges.downTo(fromElement, BoundType.forBoolean(inclusive)));
    }

    @Override
    @GwtIncompatible(value="not used by GWT emulation")
    int indexOf(Object target) {
        return this.contains(target) ? (int)this.domain.distance(this.first(), (Comparable)target) : -1;
    }

    @Override
    public UnmodifiableIterator<C> iterator() {
        return new AbstractSequentialIterator<C>((Comparable)this.first()){
            final C last;
            {
                this.last = RegularContiguousSet.this.last();
            }

            @Override
            protected C computeNext(C previous) {
                return RegularContiguousSet.equalsOrThrow(previous, this.last) ? null : (Object)RegularContiguousSet.this.domain.next(previous);
            }
        };
    }

    private static boolean equalsOrThrow(Comparable<?> left, @Nullable Comparable<?> right) {
        return right != null && Range.compareOrThrow(left, right) == 0;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public C first() {
        return this.range.lowerBound.leastValueAbove(this.domain);
    }

    @Override
    public C last() {
        return this.range.upperBound.greatestValueBelow(this.domain);
    }

    @Override
    public int size() {
        long distance = this.domain.distance(this.first(), this.last());
        return distance >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)distance + 1;
    }

    @Override
    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        try {
            return this.range.contains((Comparable)object);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> targets) {
        return Collections2.containsAllImpl(this, targets);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    @Override
    public <T> T[] toArray(T[] other) {
        return ObjectArrays.toArrayImpl(this, other);
    }

    @Override
    public ContiguousSet<C> intersection(ContiguousSet<C> other) {
        Comparable upperEndpoint;
        Preconditions.checkNotNull(other);
        Preconditions.checkArgument(this.domain.equals(other.domain));
        if (other.isEmpty()) {
            return other;
        }
        Comparable lowerEndpoint = (Comparable)Ordering.natural().max(this.first(), other.first());
        return lowerEndpoint.compareTo(upperEndpoint = (Comparable)Ordering.natural().min(this.last(), other.last())) < 0 ? Ranges.closed(lowerEndpoint, upperEndpoint).asSet(this.domain) : new EmptyContiguousSet(this.domain);
    }

    @Override
    public Range<C> range() {
        return this.range(BoundType.CLOSED, BoundType.CLOSED);
    }

    @Override
    public Range<C> range(BoundType lowerBoundType, BoundType upperBoundType) {
        return Ranges.create(this.range.lowerBound.withLowerBoundType(lowerBoundType, this.domain), this.range.upperBound.withUpperBoundType(upperBoundType, this.domain));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof RegularContiguousSet) {
            RegularContiguousSet that = (RegularContiguousSet)object;
            if (this.domain.equals(that.domain)) {
                return this.first().equals(that.first()) && this.last().equals(that.last());
            }
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new SerializedForm(this.range, this.domain);
    }

    @Override
    @GwtIncompatible(value="NavigableSet")
    ImmutableSortedSet<C> createDescendingSet() {
        return new DescendingContiguousSet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="NavigableSet")
    private final class DescendingContiguousSet
    extends ImmutableSortedSet<C> {
        private DescendingContiguousSet() {
            super(Ordering.natural().reverse());
        }

        @Override
        public C first() {
            return RegularContiguousSet.this.last();
        }

        @Override
        public C last() {
            return RegularContiguousSet.this.first();
        }

        @Override
        public int size() {
            return RegularContiguousSet.this.size();
        }

        @Override
        public UnmodifiableIterator<C> iterator() {
            return new AbstractSequentialIterator<C>((Comparable)this.first()){
                final C last;
                {
                    this.last = DescendingContiguousSet.this.last();
                }

                @Override
                protected C computeNext(C previous) {
                    return RegularContiguousSet.equalsOrThrow(previous, this.last) ? null : (Object)RegularContiguousSet.this.domain.previous(previous);
                }
            };
        }

        @Override
        ImmutableSortedSet<C> headSetImpl(C toElement, boolean inclusive) {
            return RegularContiguousSet.this.tailSetImpl(toElement, inclusive).descendingSet();
        }

        @Override
        ImmutableSortedSet<C> subSetImpl(C fromElement, boolean fromInclusive, C toElement, boolean toInclusive) {
            return RegularContiguousSet.this.subSetImpl(toElement, toInclusive, fromElement, fromInclusive).descendingSet();
        }

        @Override
        ImmutableSortedSet<C> tailSetImpl(C fromElement, boolean inclusive) {
            return RegularContiguousSet.this.headSetImpl(fromElement, inclusive).descendingSet();
        }

        @Override
        ImmutableSortedSet<C> createDescendingSet() {
            return RegularContiguousSet.this;
        }

        @Override
        int indexOf(Object target) {
            return this.contains(target) ? (int)RegularContiguousSet.this.domain.distance(this.last(), (Comparable)target) : -1;
        }

        @Override
        boolean isPartialView() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GwtIncompatible(value="serialization")
    private static final class SerializedForm<C extends Comparable>
    implements Serializable {
        final Range<C> range;
        final DiscreteDomain<C> domain;

        private SerializedForm(Range<C> range, DiscreteDomain<C> domain) {
            this.range = range;
            this.domain = domain;
        }

        private Object readResolve() {
            return new RegularContiguousSet<C>(this.range, this.domain);
        }
    }
}

