/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.Locator;
import org.jhotdraw.draw.LocatorHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TransformRestoreEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class ResizeHandleKit {
    private static final boolean DEBUG = false;

    public static void addCornerResizeHandles(Figure figure, Collection<Handle> collection) {
        collection.add(ResizeHandleKit.southEast(figure));
        collection.add(ResizeHandleKit.southWest(figure));
        collection.add(ResizeHandleKit.northEast(figure));
        collection.add(ResizeHandleKit.northWest(figure));
    }

    public static void addEdgeResizeHandles(Figure figure, Collection<Handle> collection) {
        collection.add(ResizeHandleKit.south(figure));
        collection.add(ResizeHandleKit.north(figure));
        collection.add(ResizeHandleKit.east(figure));
        collection.add(ResizeHandleKit.west(figure));
    }

    public static void addResizeHandles(Figure figure, Collection<Handle> collection) {
        collection.add(new BoundsOutlineHandle(figure));
        ResizeHandleKit.addCornerResizeHandles(figure, collection);
        ResizeHandleKit.addEdgeResizeHandles(figure, collection);
    }

    public static Handle south(Figure figure) {
        return new SouthHandle(figure);
    }

    public static Handle southEast(Figure figure) {
        return new SouthEastHandle(figure);
    }

    public static Handle southWest(Figure figure) {
        return new SouthWestHandle(figure);
    }

    public static Handle north(Figure figure) {
        return new NorthHandle(figure);
    }

    public static Handle northEast(Figure figure) {
        return new NorthEastHandle(figure);
    }

    public static Handle northWest(Figure figure) {
        return new NorthWestHandle(figure);
    }

    public static Handle east(Figure figure) {
        return new EastHandle(figure);
    }

    public static Handle west(Figure figure) {
        return new WestHandle(figure);
    }

    private static class EastHandle
    extends ResizeHandle {
        EastHandle(Figure figure) {
            super(figure, RelativeLocator.east(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(double_2.x, double_2.y), new Point2D.Double(Math.max(double_2.x + 1.0, double_.x), double_2.y + double_2.height));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Rectangle2D.Double double_ = this.getOwner().getBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    break;
                }
                case 37: {
                    if (double_.width > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width - 1.0, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width + 1.0, double_.y + double_.height));
                    keyEvent.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 11 : 0);
        }
    }

    private static class NorthEastHandle
    extends ResizeHandle {
        NorthEastHandle(Figure figure) {
            super(figure, RelativeLocator.northEast(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(double_2.x, Math.min(double_2.y + double_2.height - 1.0, double_.y)), new Point2D.Double(Math.max(double_2.x, double_.x), double_2.y + double_2.height));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Rectangle2D.Double double_ = this.getOwner().getBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.setBounds(new Point2D.Double(double_.x, double_.y - 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (double_.height > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x, double_.y + 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    if (double_.width > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width - 1.0, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width + 1.0, double_.y + double_.height));
                    keyEvent.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 7 : 0);
        }
    }

    private static class NorthHandle
    extends ResizeHandle {
        NorthHandle(Figure figure) {
            super(figure, RelativeLocator.north(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(double_2.x, Math.min(double_2.y + double_2.height - 1.0, double_.y)), new Point2D.Double(double_2.x + double_2.width, double_2.y + double_2.height));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Rectangle2D.Double double_ = this.getOwner().getBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.setBounds(new Point2D.Double(double_.x, double_.y - 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (double_.height > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x, double_.y + 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    keyEvent.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 8 : 0);
        }
    }

    private static class NorthWestHandle
    extends ResizeHandle {
        NorthWestHandle(Figure figure) {
            super(figure, RelativeLocator.northWest(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(double_2.x + double_2.width - 1.0, double_.x), Math.min(double_2.y + double_2.height - 1.0, double_.y)), new Point2D.Double(double_2.x + double_2.width, double_2.y + double_2.height));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Rectangle2D.Double double_ = this.getOwner().getBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.setBounds(new Point2D.Double(double_.x, double_.y - 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    if (double_.height > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x, double_.y + 1.0), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    this.setBounds(new Point2D.Double(double_.x - 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    if (double_.width > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x + 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 6 : 0);
        }
    }

    private static class ResizeHandle
    extends LocatorHandle {
        private int dx;
        private int dy;
        Object geometry;

        ResizeHandle(Figure figure, Locator locator) {
            super(figure, locator);
        }

        @Override
        public String getToolTipText(Point point) {
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            return resourceBundleUtil.getString("handle.resize.toolTipText");
        }

        @Override
        public void draw(Graphics2D graphics2D) {
            if (this.getEditor().getTool().supportsHandleInteraction()) {
                if (this.getOwner().isTransformable()) {
                    this.drawRectangle(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.RESIZE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.RESIZE_HANDLE_STROKE_COLOR));
                } else {
                    this.drawRectangle(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.NULL_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.NULL_HANDLE_STROKE_COLOR));
                }
            } else {
                this.drawRectangle(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.HANDLE_STROKE_COLOR_DISABLED));
            }
        }

        @Override
        public void trackStart(Point point, int n) {
            this.geometry = this.getOwner().getTransformRestoreData();
            Point point2 = this.getLocation();
            this.dx = -point.x + point2.x;
            this.dy = -point.y + point2.y;
        }

        @Override
        public void trackStep(Point point, Point point2, int n) {
            if (this.getOwner().isTransformable()) {
                Point2D.Double double_ = this.view.viewToDrawing(new Point(point2.x + this.dx, point2.y + this.dy));
                this.view.getConstrainer().constrainPoint(double_);
                if (this.getOwner().get(AttributeKeys.TRANSFORM) != null) {
                    try {
                        this.getOwner().get(AttributeKeys.TRANSFORM).inverseTransform(double_, double_);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        // empty catch block
                    }
                }
                this.trackStepNormalized(double_);
            }
        }

        @Override
        public void trackEnd(Point point, Point point2, int n) {
            if (this.getOwner().isTransformable()) {
                this.fireUndoableEditHappened(new TransformRestoreEdit(this.getOwner(), this.geometry, this.getOwner().getTransformRestoreData()));
            }
        }

        protected void trackStepNormalized(Point2D.Double double_) {
        }

        protected void setBounds(Point2D.Double double_, Point2D.Double double_2) {
            Figure figure = this.getOwner();
            figure.willChange();
            figure.setBounds(double_, double_2);
            figure.changed();
        }
    }

    private static class SouthEastHandle
    extends ResizeHandle {
        SouthEastHandle(Figure figure) {
            super(figure, RelativeLocator.southEast(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(double_2.x, double_2.y), new Point2D.Double(Math.max(double_2.x + 1.0, double_.x), Math.max(double_2.y + 1.0, double_.y)));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Rectangle2D.Double double_ = this.getOwner().getBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (double_.height > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height - 1.0));
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height + 1.0));
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    if (double_.width > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width - 1.0, double_.y + double_.height));
                    }
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width + 1.0, double_.y + double_.height));
                    keyEvent.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 5 : 0);
        }
    }

    private static class SouthHandle
    extends ResizeHandle {
        SouthHandle(Figure figure) {
            super(figure, RelativeLocator.south(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(double_2.x, double_2.y), new Point2D.Double(double_2.x + double_2.width, Math.max(double_2.y + 1.0, double_.y)));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Rectangle2D.Double double_ = this.getOwner().getBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (double_.height > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height - 1.0));
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height + 1.0));
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    keyEvent.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 9 : 0);
        }
    }

    private static class SouthWestHandle
    extends ResizeHandle {
        SouthWestHandle(Figure figure) {
            super(figure, RelativeLocator.southWest(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(double_2.x + double_2.width - 1.0, double_.x), double_2.y), new Point2D.Double(double_2.x + double_2.width, Math.max(double_2.y + 1.0, double_.y)));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Rectangle2D.Double double_ = this.getOwner().getBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (double_.height > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height - 1.0));
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    this.setBounds(new Point2D.Double(double_.x, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height + 1.0));
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    this.setBounds(new Point2D.Double(double_.x - 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    if (double_.width > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x + 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 4 : 0);
        }
    }

    private static class WestHandle
    extends ResizeHandle {
        WestHandle(Figure figure) {
            super(figure, RelativeLocator.west(true));
        }

        @Override
        protected void trackStepNormalized(Point2D.Double double_) {
            Rectangle2D.Double double_2 = this.getOwner().getBounds();
            this.setBounds(new Point2D.Double(Math.min(double_2.x + double_2.width - 1.0, double_.x), double_2.y), new Point2D.Double(double_2.x + double_2.width, double_2.y + double_2.height));
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Rectangle2D.Double double_ = this.getOwner().getBounds();
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    this.setBounds(new Point2D.Double(double_.x - 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    if (double_.width > 1.0) {
                        this.setBounds(new Point2D.Double(double_.x + 1.0, double_.y), new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
                    }
                    keyEvent.consume();
                }
            }
        }

        @Override
        public Cursor getCursor() {
            return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 10 : 0);
        }
    }
}

