/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.net.URL;
import javax.swing.ImageIcon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;

public class DrawingOpacityIcon
extends ImageIcon {
    private DrawingEditor editor;
    private AttributeKey<Double> opacityKey;
    private AttributeKey<Color> fillColorKey;
    private AttributeKey<Color> strokeColorKey;
    private Shape fillShape;
    private Shape strokeShape;

    public DrawingOpacityIcon(DrawingEditor drawingEditor, AttributeKey<Double> attributeKey, AttributeKey<Color> attributeKey2, AttributeKey<Color> attributeKey3, URL uRL, Shape shape, Shape shape2) {
        super(uRL);
        this.editor = drawingEditor;
        this.opacityKey = attributeKey;
        this.fillColorKey = attributeKey2;
        this.strokeColorKey = attributeKey3;
        this.fillShape = shape;
        this.strokeShape = shape2;
    }

    public DrawingOpacityIcon(DrawingEditor drawingEditor, AttributeKey<Double> attributeKey, AttributeKey<Color> attributeKey2, AttributeKey<Color> attributeKey3, Image image, Shape shape, Shape shape2) {
        super(image);
        this.editor = drawingEditor;
        this.opacityKey = attributeKey;
        this.fillColorKey = attributeKey2;
        this.strokeColorKey = attributeKey3;
        this.fillShape = shape;
        this.strokeShape = shape2;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintIcon(component, graphics2D, n, n2);
        Double d = 0.0;
        Color color = null;
        Color color2 = null;
        if (this.editor != null) {
            DrawingView drawingView = this.editor.getActiveView();
            if (drawingView != null && drawingView.getDrawing() != null) {
                Drawing drawing = drawingView.getDrawing();
                d = drawing.get(this.opacityKey);
                color = this.fillColorKey == null ? null : drawing.get(this.fillColorKey);
                color2 = this.strokeColorKey == null ? null : drawing.get(this.strokeColorKey);
            } else {
                d = this.opacityKey.get(this.editor.getDefaultAttributes());
                color = this.fillColorKey == null ? null : this.fillColorKey.get(this.editor.getDefaultAttributes());
                Color color3 = color2 = this.strokeColorKey == null ? null : this.strokeColorKey.get(this.editor.getDefaultAttributes());
            }
        }
        if (this.fillColorKey != null && this.fillShape != null && d != null) {
            if (color == null) {
                color = Color.BLACK;
            }
            graphics2D.setColor(new Color((int)(d * 255.0) << 24 | color.getRGB() & 0xFFFFFF, true));
            graphics2D.translate(n, n2);
            graphics2D.fill(this.fillShape);
            graphics2D.translate(-n, -n2);
        }
        if (this.strokeColorKey != null && this.strokeShape != null && d != null) {
            if (color2 == null) {
                color2 = Color.BLACK;
            }
            graphics2D.setColor(new Color((int)(d * 255.0) << 24 | color2.getRGB() & 0xFFFFFF, true));
            graphics2D.translate(n, n2);
            graphics2D.draw(this.strokeShape);
            graphics2D.translate(-n, -n2);
        }
    }
}

