# Copyright 2014-2015 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Global license keys."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'LicenseKey',
    ]


from django.db.models import CharField
from maasserver import DefaultMeta
from maasserver.models.timestampedmodel import TimestampedModel


class LicenseKey(TimestampedModel):
    """Available license key for osystem and distro_series combo.

    Each `LicenseKey` matches to a operating system and release. Only one
    license key can exists per osystem/distro_series combination.
    """

    class Meta(DefaultMeta):
        unique_together = (
            ('osystem', 'distro_series'),
            )

    # Operating system (e.g. "ubuntu") that uses the license key.
    osystem = CharField(max_length=255, blank=False)

    # OS series (e.g. "precise") that uses the license key.
    distro_series = CharField(max_length=255, blank=False)

    # License key for the osystem/distro_series combo.
    license_key = CharField(
        max_length=255, blank=False, verbose_name="License Key", help_text=(
            "License key for operating system"))
