# Copyright 2014-2015 Cloudbase Solutions SRL.
# Copyright 2012 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

""":class:`SSLKey` and friends."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'SSLKey',
    ]


from django.contrib.auth.models import User
from django.db.models import (
    CASCADE,
    ForeignKey,
    TextField,
)
from maasserver import DefaultMeta
from maasserver.models.cleansave import CleanSave
from maasserver.models.timestampedmodel import TimestampedModel


def validate_ssl_key(value):
    """Validate that the given value contains a valid SSL key."""
    pass


class SSLKey(CleanSave, TimestampedModel):
    """An `SSLKey` represents a user SSL key.

    Users will be able to access Windows winrm service with
    any of the registered keys.

    :ivar user: The user which owns the key.
    :ivar key: The SSL key.

    """
    user = ForeignKey(User, null=False, editable=False, on_delete=CASCADE)
    key = TextField(
        null=False, blank=False, editable=True, validators=[validate_ssl_key])

    class Meta(DefaultMeta):
        verbose_name = "SSL key"
        unique_together = ('user', 'key')
