// Copyright 2023 Google Inc. All Rights Reserved.
//
// Use of this source code is governed by a BSD-style license
// that can be found in the COPYING file in the root of the source
// tree. An additional intellectual property rights grant can be found
// in the file PATENTS. All contributing project authors may
// be found in the AUTHORS file in the root of the source tree.
// -----------------------------------------------------------------------------
//
// Precomputed data for 420 risk estimation.

#include "src/webp/types.h"

const int kSharpYuvPrecomputedRiskYuvSampling = 7;

const uint8_t kSharpYuvPrecomputedRisk[] = {
    0,  2,  2,  3,  3,  2,  2,  1,  2,  2,  3,  2,  2,  1,  2,  1,  2,  2,  2,
    1,  2,  2,  1,  1,  2,  2,  3,  4,  4,  4,  4,  4,  5,  4,  4,  8,  8,  8,
    7,  5,  4,  4,  14, 12, 9,  8,  6,  4,  4,  2,  1,  2,  2,  2,  2,  1,  2,
    0,  2,  2,  2,  1,  1,  2,  1,  1,  2,  2,  1,  3,  2,  2,  2,  2,  2,  3,
    4,  5,  5,  5,  5,  5,  4,  4,  11, 9,  9,  8,  6,  5,  4,  18, 14, 11, 9,
    7,  5,  4,  2,  1,  1,  1,  1,  3,  6,  2,  2,  1,  1,  1,  3,  6,  3,  2,
    2,  2,  3,  3,  7,  6,  3,  5,  6,  6,  6,  8,  9,  7,  9,  9,  9,  8,  8,
    14, 12, 13, 12, 11, 10, 8,  20, 18, 16, 14, 13, 11, 10, 3,  6,  6,  7,  7,
    7,  10, 6,  7,  7,  8,  8,  8,  10, 10, 7,  9,  9,  10, 10, 10, 13, 10, 12,
    13, 13, 13, 12, 13, 15, 17, 17, 17, 16, 15, 14, 22, 21, 20, 19, 18, 17, 20,
    27, 25, 23, 20, 19, 19, 14, 15, 14, 14, 15, 14, 9,  16, 16, 16, 16, 16, 15,
    9,  16, 17, 18, 18, 18, 17, 14, 16, 21, 21, 22, 22, 20, 17, 19, 26, 27, 26,
    25, 24, 18, 23, 30, 32, 29, 28, 25, 20, 27, 33, 35, 32, 30, 28, 22, 24, 25,
    24, 24, 21, 17, 12, 23, 27, 25, 26, 22, 17, 14, 24, 30, 29, 28, 24, 20, 17,
    24, 31, 32, 32, 28, 24, 20, 27, 34, 37, 36, 32, 27, 22, 30, 36, 42, 41, 34,
    29, 23, 33, 39, 44, 44, 38, 31, 26, 32, 37, 36, 29, 23, 19, 15, 31, 38, 39,
    31, 25, 20, 16, 31, 38, 41, 34, 28, 24, 20, 31, 38, 44, 38, 33, 27, 24, 34,
    41, 46, 45, 37, 31, 25, 36, 43, 47, 49, 40, 33, 27, 39, 44, 49, 49, 42, 36,
    29, 2,  0,  2,  2,  2,  2,  1,  2,  1,  2,  2,  2,  1,  1,  2,  2,  1,  2,
    1,  2,  3,  2,  2,  2,  2,  3,  4,  5,  5,  5,  5,  5,  6,  5,  5,  9,  9,
    9,  8,  6,  5,  5,  15, 14, 10, 8,  7,  5,  5,  2,  2,  1,  2,  1,  1,  4,
    2,  2,  0,  2,  1,  1,  4,  2,  2,  1,  1,  1,  3,  5,  3,  3,  3,  3,  3,
    4,  6,  7,  6,  7,  6,  6,  5,  6,  12, 11, 10, 9,  8,  7,  6,  19, 16, 12,
    10, 9,  8,  6,  2,  2,  3,  3,  3,  5,  7,  3,  2,  3,  4,  4,  5,  7,  7,
    2,  4,  6,  6,  6,  9,  10, 4,  8,  9,  9,  9,  11, 13, 8,  11, 13, 13, 12,
    11, 17, 14, 15, 16, 15, 14, 10, 21, 20, 18, 18, 16, 15, 13, 7,  7,  9,  9,
    10, 8,  11, 11, 8,  10, 11, 11, 11, 11, 13, 8,  11, 13, 13, 14, 13, 16, 11,
    16, 17, 17, 17, 15, 17, 17, 20, 21, 21, 20, 18, 18, 23, 25, 24, 23, 21, 20,
    21, 29, 28, 26, 25, 23, 22, 16, 17, 17, 17, 18, 17, 11, 20, 18, 19, 19, 19,
    18, 11, 19, 20, 20, 22, 21, 20, 16, 19, 24, 26, 25, 26, 24, 22, 21, 29, 31,
    30, 31, 27, 22, 26, 33, 35, 33, 31, 30, 25, 30, 36, 39, 36, 35, 31, 26, 27,
    28, 28, 27, 23, 20, 15, 26, 30, 29, 29, 25, 21, 17, 27, 32, 32, 32, 28, 24,
    21, 26, 35, 38, 37, 32, 29, 25, 30, 38, 41, 41, 36, 31, 25, 34, 40, 47, 45,
    39, 33, 27, 37, 44, 48, 49, 41, 35, 29, 35, 42, 40, 33, 27, 22, 18, 36, 41,
    42, 34, 29, 24, 21, 36, 41, 46, 38, 32, 28, 24, 35, 43, 49, 42, 37, 32, 28,
    38, 45, 51, 48, 42, 36, 30, 40, 47, 53, 51, 44, 38, 32, 44, 49, 54, 55, 47,
    39, 34, 2,  2,  0,  2,  2,  1,  2,  3,  2,  1,  2,  2,  1,  3,  3,  2,  1,
    1,  2,  3,  5,  3,  3,  3,  3,  3,  4,  5,  6,  6,  7,  6,  6,  5,  6,  11,
    10, 10, 9,  7,  5,  5,  17, 15, 12, 10, 8,  5,  6,  3,  2,  2,  1,  1,  3,
    6,  3,  2,  2,  1,  1,  3,  6,  4,  3,  2,  2,  3,  5,  7,  7,  4,  4,  5,
    6,  6,  8,  11, 7,  8,  9,  9,  6,  9,  14, 12, 12, 11, 11, 10, 8,  20, 17,
    14, 12, 13, 11, 9,  4,  3,  4,  5,  6,  6,  8,  8,  3,  4,  6,  7,  6,  9,
    11, 3,  5,  9,  10, 8,  11, 14, 5,  9,  12, 13, 12, 13, 17, 10, 12, 16, 17,
    16, 13, 21, 15, 17, 20, 19, 17, 12, 23, 20, 20, 21, 20, 19, 16, 11, 8,  12,
    13, 12, 10, 13, 15, 9,  12, 14, 14, 14, 14, 18, 10, 13, 16, 17, 17, 16, 20,
    14, 18, 20, 21, 21, 18, 21, 20, 22, 24, 25, 24, 21, 21, 25, 27, 28, 27, 26,
    25, 23, 31, 30, 30, 28, 27, 26, 19, 19, 20, 21, 21, 20, 13, 23, 21, 21, 22,
    23, 21, 14, 23, 22, 23, 25, 25, 25, 19, 23, 26, 28, 29, 29, 28, 25, 24, 31,
    34, 34, 34, 32, 26, 28, 36, 40, 38, 37, 34, 28, 32, 40, 43, 40, 39, 35, 29,
    29, 32, 31, 30, 26, 22, 17, 29, 33, 32, 32, 29, 25, 21, 29, 36, 36, 36, 32,
    28, 24, 29, 38, 42, 40, 36, 32, 28, 32, 42, 45, 44, 40, 35, 30, 37, 45, 50,
    49, 42, 37, 31, 40, 47, 52, 52, 46, 39, 33, 38, 45, 42, 36, 30, 25, 21, 39,
    45, 45, 38, 32, 28, 24, 39, 45, 49, 42, 37, 32, 28, 38, 46, 52, 46, 41, 35,
    31, 42, 49, 55, 52, 45, 40, 34, 45, 51, 57, 57, 48, 42, 36, 48, 53, 58, 57,
    51, 44, 38, 3,  2,  2,  0,  0,  2,  4,  3,  2,  2,  0,  1,  3,  6,  3,  3,
    2,  2,  2,  4,  7,  4,  4,  4,  5,  4,  5,  7,  8,  7,  8,  8,  7,  6,  7,
    12, 11, 12, 10, 8,  6,  7,  18, 16, 13, 11, 9,  6,  8,  3,  2,  2,  2,  3,
    5,  7,  4,  3,  2,  2,  3,  6,  8,  8,  3,  2,  3,  6,  7,  9,  11, 4,  5,
    6,  9,  8,  11, 14, 8,  9,  10, 12, 8,  11, 17, 13, 13, 13, 14, 12, 11, 22,
    18, 15, 13, 16, 15, 11, 8,  3,  5,  8,  8,  8,  10, 12, 3,  5,  8,  10, 8,
    11, 15, 5,  6,  11, 13, 9,  13, 18, 9,  10, 15, 16, 16, 16, 21, 12, 14, 19,
    19, 19, 16, 24, 17, 18, 21, 22, 21, 16, 26, 22, 20, 23, 23, 22, 19, 15, 9,
    13, 15, 16, 12, 15, 18, 11, 14, 16, 17, 17, 17, 22, 13, 15, 19, 21, 21, 19,
    26, 17, 20, 24, 23, 25, 21, 26, 22, 24, 27, 28, 27, 24, 25, 27, 30, 31, 31,
    29, 27, 25, 33, 33, 33, 32, 31, 30, 23, 20, 22, 24, 24, 23, 16, 26, 22, 25,
    25, 26, 25, 17, 26, 25, 26, 28, 30, 28, 22, 26, 29, 31, 33, 33, 32, 27, 28,
    34, 37, 36, 38, 36, 30, 30, 39, 42, 42, 41, 37, 32, 34, 43, 46, 44, 42, 39,
    33, 31, 34, 33, 33, 30, 26, 20, 31, 36, 35, 35, 32, 28, 24, 32, 37, 39, 39,
    36, 31, 28, 32, 40, 45, 42, 40, 37, 32, 34, 44, 50, 48, 44, 40, 34, 39, 47,
    54, 52, 47, 40, 35, 43, 48, 56, 56, 49, 43, 37, 43, 46, 45, 39, 32, 29, 25,
    42, 47, 47, 40, 35, 31, 28, 41, 47, 49, 44, 39, 36, 31, 42, 48, 55, 50, 44,
    40, 34, 45, 52, 57, 55, 49, 43, 38, 48, 54, 59, 60, 53, 44, 39, 51, 57, 61,
    60, 54, 47, 41, 3,  2,  2,  0,  0,  2,  4,  3,  2,  2,  1,  0,  3,  6,  3,
    2,  2,  2,  2,  4,  6,  4,  4,  4,  4,  4,  5,  7,  8,  7,  8,  8,  7,  6,
    8,  12, 12, 11, 11, 8,  6,  8,  18, 16, 13, 11, 9,  6,  8,  3,  2,  2,  2,
    3,  5,  7,  4,  3,  2,  2,  3,  6,  8,  8,  3,  2,  3,  6,  7,  9,  12, 5,
    5,  6,  9,  8,  11, 14, 8,  9,  10, 12, 8,  10, 17, 13, 13, 13, 14, 13, 11,
    22, 18, 15, 13, 15, 15, 11, 8,  3,  5,  8,  8,  8,  10, 12, 3,  5,  9,  10,
    8,  11, 16, 5,  6,  11, 13, 9,  13, 17, 8,  9,  15, 16, 15, 15, 22, 12, 14,
    19, 20, 20, 16, 24, 17, 18, 21, 22, 21, 16, 26, 22, 20, 23, 24, 22, 19, 15,
    9,  13, 15, 15, 12, 16, 18, 11, 14, 16, 17, 17, 17, 21, 13, 15, 19, 21, 21,
    19, 26, 17, 20, 23, 24, 25, 20, 25, 21, 24, 27, 27, 27, 24, 24, 27, 29, 30,
    30, 29, 27, 26, 33, 32, 33, 32, 31, 30, 23, 21, 23, 24, 23, 22, 15, 26, 22,
    24, 24, 26, 25, 17, 26, 24, 25, 28, 30, 27, 22, 26, 29, 30, 33, 33, 32, 27,
    28, 34, 36, 38, 37, 35, 30, 30, 38, 43, 42, 41, 37, 32, 33, 42, 46, 44, 42,
    39, 34, 32, 34, 33, 33, 29, 26, 20, 32, 37, 35, 35, 32, 28, 24, 31, 38, 38,
    39, 36, 32, 28, 31, 40, 44, 44, 39, 36, 32, 35, 42, 49, 48, 44, 40, 33, 39,
    47, 54, 53, 46, 40, 36, 44, 50, 54, 55, 48, 43, 37, 40, 47, 44, 37, 33, 28,
    25, 41, 48, 47, 40, 35, 31, 28, 40, 47, 50, 44, 40, 35, 31, 41, 49, 55, 50,
    44, 39, 35, 44, 52, 58, 55, 47, 43, 38, 48, 55, 60, 59, 50, 45, 39, 50, 57,
    62, 62, 53, 47, 42, 2,  2,  1,  2,  2,  0,  3,  2,  2,  1,  2,  2,  1,  4,
    2,  2,  1,  2,  4,  3,  5,  3,  3,  4,  4,  6,  6,  6,  6,  7,  7,  7,  9,
    8,  6,  11, 11, 11, 10, 9,  8,  6,  18, 15, 13, 11, 10, 7,  6,  2,  2,  2,
    1,  1,  3,  5,  3,  2,  2,  1,  1,  4,  6,  6,  2,  2,  3,  4,  5,  7,  10,
    4,  5,  6,  7,  6,  9,  11, 8,  9,  9,  10, 7,  8,  16, 13, 13, 12, 12, 11,
    9,  21, 18, 15, 13, 14, 13, 9,  6,  2,  4,  6,  6,  6,  8,  10, 2,  4,  7,
    8,  6,  9,  14, 3,  5,  9,  10, 7,  11, 16, 6,  9,  13, 14, 13, 13, 18, 11,
    12, 17, 18, 17, 13, 22, 16, 17, 20, 20, 18, 13, 25, 22, 20, 22, 22, 20, 17,
    14, 7,  12, 13, 13, 9,  13, 17, 9,  12, 14, 15, 14, 14, 20, 12, 13, 17, 18,
    19, 16, 22, 15, 18, 22, 22, 22, 18, 22, 20, 22, 25, 26, 25, 21, 23, 25, 28,
    28, 28, 27, 24, 24, 31, 31, 30, 30, 29, 27, 22, 19, 21, 21, 21, 20, 13, 24,
    20, 22, 22, 23, 22, 14, 24, 22, 23, 26, 26, 25, 19, 25, 26, 28, 29, 32, 29,
    25, 25, 32, 34, 35, 35, 32, 27, 28, 36, 41, 39, 37, 34, 30, 32, 40, 43, 43,
    39, 36, 30, 29, 32, 32, 30, 26, 22, 17, 29, 35, 32, 32, 29, 25, 22, 29, 35,
    35, 36, 33, 29, 25, 29, 38, 41, 41, 37, 33, 29, 33, 41, 47, 45, 42, 37, 30,
    38, 44, 52, 52, 44, 38, 32, 41, 47, 53, 53, 47, 40, 34, 39, 46, 42, 36, 30,
    26, 22, 39, 45, 45, 38, 33, 29, 25, 39, 44, 48, 42, 36, 33, 28, 39, 46, 52,
    47, 41, 37, 33, 42, 50, 54, 52, 45, 39, 36, 45, 52, 58, 56, 49, 43, 35, 49,
    54, 58, 59, 52, 44, 37, 1,  1,  2,  4,  4,  3,  0,  2,  1,  2,  4,  4,  3,
    2,  2,  1,  1,  4,  5,  4,  4,  2,  3,  3,  5,  7,  7,  6,  5,  6,  7,  8,
    10, 8,  7,  10, 10, 11, 11, 10, 8,  7,  17, 15, 12, 11, 11, 8,  7,  2,  1,
    1,  3,  2,  2,  3,  2,  2,  1,  2,  2,  2,  4,  2,  2,  1,  3,  3,  3,  5,
    6,  3,  4,  5,  5,  4,  6,  9,  7,  8,  8,  8,  6,  6,  13, 12, 12, 11, 9,
    8,  6,  20, 18, 13, 12, 11, 9,  6,  2,  2,  3,  3,  3,  5,  6,  6,  2,  3,
    4,  4,  4,  6,  11, 2,  4,  7,  7,  5,  8,  15, 4,  8,  10, 10, 10, 10, 16,
    9,  11, 14, 14, 14, 10, 19, 14, 16, 18, 16, 15, 10, 23, 21, 19, 19, 18, 16,
    14, 11, 7,  9,  10, 10, 7,  11, 15, 7,  10, 11, 12, 11, 11, 17, 9,  12, 14,
    15, 15, 12, 19, 13, 16, 18, 18, 18, 14, 19, 17, 20, 22, 23, 22, 18, 20, 23,
    26, 26, 25, 23, 21, 22, 29, 29, 27, 26, 25, 23, 19, 17, 18, 18, 18, 17, 11,
    22, 18, 20, 19, 20, 19, 11, 22, 20, 21, 23, 23, 22, 17, 22, 24, 26, 27, 27,
    26, 22, 23, 30, 31, 32, 32, 28, 24, 25, 34, 37, 36, 34, 30, 26, 30, 37, 41,
    37, 36, 33, 27, 27, 29, 27, 27, 24, 20, 15, 26, 31, 30, 29, 26, 22, 18, 27,
    33, 32, 33, 30, 26, 22, 26, 35, 39, 36, 34, 29, 25, 31, 37, 43, 42, 38, 33,
    28, 35, 44, 48, 47, 40, 34, 30, 38, 45, 49, 49, 42, 37, 31, 35, 41, 38, 32,
    26, 23, 18, 36, 42, 41, 35, 29, 25, 22, 36, 40, 43, 38, 33, 29, 25, 36, 42,
    50, 43, 37, 34, 29, 39, 45, 52, 47, 42, 37, 31, 42, 47, 53, 54, 45, 39, 33,
    46, 51, 54, 54, 46, 40, 35, 1,  2,  3,  3,  3,  2,  2,  0,  2,  2,  3,  3,
    2,  1,  1,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  4,  4,  3,  4,
    4,  5,  4,  4,  7,  7,  7,  7,  5,  4,  4,  13, 12, 9,  7,  6,  4,  4,  1,
    2,  2,  3,  2,  2,  1,  2,  1,  2,  2,  2,  1,  0,  2,  0,  2,  2,  2,  1,
    2,  2,  2,  2,  2,  2,  3,  4,  5,  5,  5,  5,  5,  4,  4,  10, 9,  9,  8,
    6,  4,  4,  17, 14, 11, 8,  6,  5,  4,  2,  1,  1,  2,  2,  2,  5,  2,  1,
    1,  1,  1,  2,  6,  2,  2,  1,  2,  2,  2,  6,  5,  3,  4,  4,  5,  5,  7,
    8,  7,  8,  8,  8,  7,  7,  13, 12, 12, 11, 10, 9,  7,  20, 17, 15, 13, 11,
    10, 9,  2,  5,  6,  6,  6,  6,  9,  5,  6,  6,  7,  7,  7,  9,  8,  7,  8,
    8,  9,  9,  9,  11, 9,  11, 12, 12, 12, 11, 12, 15, 15, 16, 15, 15, 14, 14,
    20, 20, 20, 18, 17, 16, 19, 27, 24, 21, 20, 18, 17, 13, 14, 13, 14, 14, 13,
    9,  15, 15, 14, 15, 15, 14, 9,  15, 17, 17, 17, 17, 16, 12, 15, 21, 20, 20,
    21, 19, 16, 18, 25, 25, 24, 24, 23, 17, 22, 29, 30, 29, 26, 24, 19, 26, 32,
    33, 31, 29, 26, 21, 23, 24, 23, 22, 20, 15, 12, 23, 27, 25, 25, 21, 16, 13,
    23, 28, 28, 26, 23, 19, 15, 23, 30, 32, 31, 28, 22, 19, 26, 32, 36, 36, 31,
    26, 20, 29, 34, 41, 39, 34, 28, 23, 31, 38, 41, 42, 35, 30, 25, 31, 37, 35,
    29, 23, 18, 14, 31, 37, 38, 30, 25, 19, 15, 30, 36, 40, 33, 27, 23, 18, 30,
    37, 44, 37, 31, 26, 23, 33, 39, 45, 43, 36, 30, 24, 36, 42, 48, 47, 39, 31,
    27, 38, 43, 48, 49, 42, 34, 28, 2,  1,  2,  2,  2,  2,  1,  2,  0,  2,  3,
    2,  2,  1,  2,  1,  1,  2,  2,  1,  3,  2,  2,  2,  2,  3,  3,  5,  5,  5,
    5,  5,  5,  5,  4,  9,  8,  8,  8,  6,  5,  4,  15, 13, 10, 8,  7,  5,  4,
    2,  1,  2,  2,  2,  1,  3,  2,  2,  1,  2,  1,  1,  3,  2,  2,  1,  1,  1,
    2,  5,  2,  3,  3,  3,  3,  3,  6,  6,  6,  6,  6,  6,  4,  6,  11, 10, 10,
    9,  7,  5,  6,  19, 15, 12, 9,  8,  7,  6,  2,  2,  2,  2,  2,  4,  7,  3,
    2,  3,  3,  3,  5,  7,  5,  2,  4,  5,  5,  5,  8,  9,  3,  7,  8,  8,  8,
    9,  12, 8,  11, 11, 12, 11, 10, 16, 13, 15, 15, 14, 12, 10, 21, 19, 18, 17,
    15, 14, 13, 5,  7,  8,  8,  9,  8,  11, 9,  7,  9,  10, 10, 10, 11, 12, 8,
    11, 11, 12, 12, 12, 16, 11, 15, 16, 16, 15, 14, 16, 17, 19, 19, 20, 19, 17,
    16, 23, 24, 23, 22, 20, 19, 21, 29, 27, 25, 23, 22, 20, 16, 16, 17, 16, 17,
    16, 10, 18, 18, 18, 18, 18, 17, 11, 18, 19, 20, 20, 21, 19, 16, 18, 24, 24,
    25, 25, 23, 20, 21, 29, 29, 28, 28, 26, 21, 24, 32, 34, 33, 31, 28, 24, 29,
    36, 38, 34, 33, 30, 25, 26, 28, 26, 26, 22, 18, 14, 25, 31, 28, 28, 23, 19,
    16, 26, 32, 31, 31, 27, 23, 19, 26, 33, 36, 33, 32, 26, 22, 29, 36, 40, 38,
    35, 30, 25, 33, 39, 45, 44, 36, 31, 27, 35, 42, 45, 46, 41, 33, 29, 35, 41,
    38, 31, 26, 21, 17, 35, 40, 41, 34, 27, 23, 19, 35, 41, 44, 37, 30, 26, 22,
    34, 41, 47, 41, 35, 31, 26, 37, 43, 50, 47, 40, 34, 29, 39, 46, 52, 51, 42,
    37, 30, 42, 49, 53, 53, 44, 39, 32, 2,  1,  1,  2,  2,  1,  2,  2,  2,  0,
    2,  2,  1,  3,  3,  2,  1,  1,  2,  2,  4,  3,  3,  3,  3,  3,  4,  5,  5,
    6,  6,  6,  6,  5,  5,  10, 10, 9,  8,  7,  5,  5,  17, 15, 11, 9,  7,  5,
    5,  3,  2,  1,  1,  1,  3,  5,  3,  2,  2,  1,  1,  3,  6,  3,  2,  2,  2,
    2,  4,  7,  6,  4,  4,  4,  5,  5,  8,  9,  7,  7,  8,  8,  5,  8,  13, 12,
    11, 11, 10, 9,  8,  20, 17, 13, 11, 11, 10, 8,  3,  2,  4,  5,  5,  6,  8,
    6,  3,  4,  6,  6,  6,  8,  10, 3,  5,  8,  8,  7,  10, 13, 4,  9,  11, 12,
    11, 12, 16, 9,  12, 15, 15, 15, 12, 20, 14, 16, 18, 17, 16, 12, 22, 20, 19,
    20, 19, 17, 16, 10, 7,  11, 11, 11, 9,  12, 13, 8,  11, 12, 13, 13, 13, 16,
    10, 13, 16, 16, 16, 15, 18, 13, 17, 19, 19, 19, 17, 20, 18, 22, 23, 24, 22,
    19, 20, 24, 27, 27, 25, 25, 22, 23, 30, 30, 28, 27, 26, 25, 19, 18, 19, 19,
    20, 18, 12, 21, 19, 20, 21, 21, 20, 13, 22, 21, 23, 24, 25, 23, 18, 21, 26,
    27, 28, 28, 27, 23, 24, 31, 33, 32, 33, 30, 25, 27, 36, 38, 36, 34, 31, 26,
    31, 39, 41, 38, 37, 34, 28, 28, 31, 30, 29, 25, 21, 17, 28, 33, 32, 31, 28,
    23, 19, 27, 35, 35, 34, 31, 26, 23, 28, 36, 40, 38, 35, 30, 27, 32, 41, 45,
    44, 39, 34, 29, 35, 43, 51, 48, 42, 36, 30, 39, 46, 51, 50, 44, 38, 32, 37,
    44, 41, 34, 29, 24, 20, 39, 44, 44, 37, 32, 26, 23, 38, 43, 47, 40, 36, 31,
    26, 38, 45, 50, 45, 39, 35, 30, 40, 48, 54, 50, 43, 37, 32, 44, 51, 56, 53,
    46, 40, 34, 46, 52, 57, 57, 49, 42, 37, 3,  2,  2,  0,  0,  2,  4,  3,  3,
    2,  0,  1,  2,  5,  3,  3,  2,  2,  2,  3,  6,  4,  4,  4,  4,  4,  5,  7,
    7,  7,  7,  7,  7,  6,  7,  12, 11, 11, 10, 8,  6,  7,  17, 15, 12, 10, 9,
    6,  7,  3,  3,  2,  2,  2,  5,  7,  3,  3,  2,  2,  2,  5,  8,  7,  3,  2,
    3,  5,  6,  9,  10, 4,  5,  6,  8,  7,  10, 13, 8,  9,  9,  12, 8,  10, 16,
    13, 13, 12, 13, 12, 10, 22, 18, 14, 13, 15, 14, 10, 7,  3,  5,  7,  7,  8,
    10, 11, 3,  5,  8,  9,  8,  11, 14, 4,  6,  11, 12, 9,  12, 17, 7,  9,  14,
    15, 15, 15, 19, 11, 13, 18, 19, 18, 15, 24, 16, 18, 20, 21, 20, 15, 25, 21,
    20, 22, 22, 21, 18, 14, 8,  13, 14, 14, 11, 15, 17, 10, 13, 15, 17, 16, 16,
    20, 12, 14, 18, 20, 20, 18, 22, 16, 19, 22, 23, 23, 19, 23, 21, 24, 26, 27,
    27, 23, 24, 26, 29, 30, 30, 28, 27, 25, 32, 32, 31, 31, 29, 29, 22, 20, 22,
    23, 23, 22, 15, 27, 21, 24, 24, 25, 24, 16, 25, 23, 26, 28, 28, 27, 21, 25,
    29, 30, 32, 33, 31, 27, 27, 34, 36, 37, 37, 34, 29, 30, 38, 42, 41, 38, 35,
    31, 32, 41, 45, 42, 42, 38, 33, 32, 33, 34, 32, 29, 25, 19, 31, 36, 35, 34,
    32, 27, 24, 31, 38, 37, 38, 34, 30, 27, 31, 39, 43, 42, 39, 35, 31, 35, 43,
    50, 47, 44, 39, 33, 39, 47, 55, 52, 46, 39, 34, 43, 50, 54, 55, 49, 42, 36,
    41, 46, 44, 38, 32, 27, 24, 41, 46, 46, 40, 34, 31, 27, 40, 48, 50, 44, 40,
    35, 30, 41, 47, 55, 48, 43, 39, 34, 44, 50, 58, 54, 48, 42, 37, 47, 54, 60,
    58, 52, 45, 37, 50, 55, 61, 60, 54, 47, 39, 2,  2,  2,  1,  1,  2,  4,  3,
    2,  2,  1,  0,  2,  5,  3,  2,  2,  2,  2,  4,  6,  4,  4,  4,  4,  4,  5,
    7,  8,  7,  7,  7,  7,  6,  7,  12, 11, 11, 10, 8,  6,  7,  17, 15, 13, 10,
    9,  6,  7,  3,  2,  2,  1,  3,  5,  8,  4,  2,  2,  2,  3,  5,  8,  7,  3,
    2,  3,  6,  6,  9,  11, 4,  5,  6,  9,  7,  10, 14, 8,  8,  9,  12, 8,  10,
    17, 13, 13, 12, 14, 12, 10, 22, 18, 14, 13, 15, 14, 10, 7,  3,  5,  8,  8,
    9,  11, 12, 3,  5,  8,  9,  8,  11, 15, 5,  5,  11, 12, 9,  13, 18, 8,  9,
    15, 16, 15, 15, 21, 12, 13, 18, 19, 19, 15, 25, 16, 18, 21, 21, 21, 15, 25,
    22, 20, 23, 23, 22, 19, 15, 8,  13, 15, 15, 12, 16, 18, 10, 14, 16, 17, 17,
    17, 21, 13, 14, 19, 20, 21, 18, 25, 17, 19, 23, 23, 24, 20, 25, 21, 24, 27,
    28, 27, 23, 25, 26, 29, 31, 30, 28, 26, 25, 32, 32, 32, 31, 31, 29, 23, 21,
    22, 24, 24, 23, 16, 26, 22, 23, 24, 26, 25, 17, 26, 24, 26, 28, 30, 28, 21,
    26, 28, 31, 33, 33, 32, 27, 27, 35, 36, 36, 38, 35, 30, 29, 38, 41, 42, 39,
    36, 31, 34, 41, 45, 43, 42, 38, 33, 32, 34, 34, 32, 30, 25, 20, 31, 35, 35,
    35, 32, 28, 23, 31, 38, 38, 38, 35, 31, 28, 31, 40, 44, 43, 39, 35, 32, 34,
    43, 49, 47, 43, 40, 32, 40, 46, 54, 52, 46, 39, 35, 43, 50, 55, 55, 48, 42,
    36, 42, 47, 45, 39, 33, 28, 24, 41, 47, 48, 40, 35, 31, 27, 41, 47, 50, 45,
    40, 35, 31, 42, 48, 56, 49, 44, 39, 35, 45, 51, 57, 55, 48, 42, 37, 48, 53,
    61, 59, 51, 44, 39, 50, 57, 61, 61, 54, 48, 40, 2,  1,  1,  3,  3,  1,  3,
    2,  1,  1,  2,  2,  0,  3,  2,  2,  1,  1,  2,  2,  4,  2,  3,  3,  3,  4,
    4,  5,  5,  6,  6,  6,  7,  6,  5,  10, 10, 9,  9,  8,  6,  5,  16, 14, 11,
    9,  8,  6,  5,  2,  2,  1,  1,  2,  4,  6,  2,  2,  1,  1,  2,  3,  5,  4,
    2,  1,  2,  3,  4,  6,  9,  3,  4,  4,  6,  5,  7,  11, 7,  7,  8,  9,  5,
    7,  14, 11, 11, 11, 11, 9,  7,  19, 16, 13, 11, 12, 11, 7,  5,  2,  4,  6,
    7,  7,  9,  9,  2,  4,  7,  7,  6,  8,  13, 2,  5,  9,  9,  6,  10, 15, 5,
    8,  12, 12, 12, 12, 18, 9,  11, 16, 16, 15, 12, 21, 14, 16, 19, 18, 17, 12,
    23, 20, 18, 20, 19, 18, 16, 13, 7,  11, 12, 13, 11, 14, 16, 8,  12, 14, 15,
    14, 13, 19, 10, 13, 16, 17, 18, 15, 21, 14, 17, 20, 20, 20, 16, 22, 19, 21,
    24, 24, 24, 20, 21, 24, 26, 27, 26, 26, 23, 22, 30, 29, 28, 28, 27, 26, 20,
    19, 20, 20, 22, 21, 14, 23, 20, 22, 23, 23, 21, 13, 23, 22, 24, 25, 26, 24,
    19, 24, 26, 28, 29, 29, 28, 23, 25, 31, 34, 33, 34, 32, 25, 28, 36, 39, 37,
    36, 33, 28, 30, 39, 41, 39, 38, 34, 30, 29, 32, 31, 31, 28, 23, 19, 28, 33,
    33, 32, 29, 24, 20, 28, 37, 35, 37, 32, 28, 24, 28, 37, 41, 40, 37, 33, 28,
    31, 39, 46, 43, 40, 35, 29, 37, 43, 51, 48, 42, 36, 31, 39, 46, 51, 51, 44,
    39, 33, 39, 44, 42, 36, 30, 26, 22, 39, 44, 45, 38, 32, 28, 24, 39, 44, 47,
    41, 35, 31, 27, 38, 47, 51, 45, 40, 35, 31, 41, 48, 54, 51, 44, 39, 33, 46,
    51, 56, 57, 47, 40, 35, 47, 53, 58, 58, 49, 43, 37, 1,  1,  3,  6,  6,  4,
    2,  1,  1,  3,  5,  5,  3,  0,  2,  1,  2,  3,  4,  3,  2,  2,  2,  2,  3,
    5,  5,  4,  4,  5,  5,  6,  8,  6,  4,  9,  8,  8,  8,  8,  6,  4,  14, 12,
    10, 8,  9,  6,  4,  2,  1,  2,  4,  3,  3,  5,  2,  1,  1,  3,  3,  2,  3,
    2,  1,  1,  1,  1,  2,  4,  3,  3,  3,  3,  3,  3,  4,  8,  6,  6,  6,  6,
    4,  4,  12, 10, 10, 9,  7,  6,  5,  18, 14, 11, 10, 8,  7,  5,  2,  1,  3,
    4,  5,  6,  8,  4,  2,  3,  5,  5,  5,  6,  9,  2,  4,  6,  6,  4,  6,  12,
    3,  7,  9,  9,  9,  8,  16, 8,  10, 12, 13, 12, 8,  18, 13, 14, 15, 14, 13,
    8,  20, 18, 16, 17, 16, 15, 13, 8,  6,  9,  10, 11, 9,  11, 13, 7,  10, 11,
    12, 12, 11, 15, 8,  11, 13, 13, 13, 11, 17, 11, 15, 16, 16, 16, 13, 19, 16,
    19, 21, 21, 20, 16, 18, 21, 23, 24, 23, 22, 19, 20, 27, 26, 25, 24, 23, 21,
    17, 17, 18, 18, 19, 18, 12, 21, 18, 19, 19, 20, 18, 11, 20, 20, 21, 22, 22,
    21, 15, 20, 24, 25, 25, 26, 24, 19, 22, 28, 29, 29, 30, 28, 22, 24, 33, 36,
    35, 32, 29, 24, 28, 36, 39, 36, 35, 31, 26, 27, 29, 27, 27, 24, 21, 17, 26,
    32, 30, 29, 25, 21, 16, 26, 33, 33, 31, 27, 23, 20, 25, 36, 36, 34, 32, 28,
    23, 29, 37, 42, 41, 34, 31, 26, 32, 40, 46, 44, 38, 33, 27, 37, 41, 47, 46,
    40, 34, 29, 36, 41, 39, 32, 27, 24, 19, 36, 41, 41, 35, 29, 24, 20, 35, 40,
    44, 37, 32, 27, 24, 36, 43, 47, 42, 37, 32, 27, 38, 44, 50, 47, 40, 34, 29,
    41, 47, 52, 49, 42, 37, 31, 43, 49, 52, 52, 46, 39, 33, 2,  2,  3,  3,  3,
    2,  2,  1,  2,  3,  3,  3,  2,  2,  0,  2,  2,  3,  2,  2,  1,  1,  1,  1,
    2,  2,  2,  3,  3,  3,  3,  4,  4,  3,  3,  7,  7,  7,  6,  5,  3,  3,  13,
    11, 9,  7,  5,  3,  3,  0,  2,  2,  3,  2,  2,  2,  1,  2,  2,  3,  2,  2,
    1,  2,  1,  2,  2,  2,  2,  1,  2,  1,  2,  2,  2,  2,  3,  4,  4,  4,  4,
    4,  3,  4,  9,  8,  8,  7,  5,  4,  4,  16, 13, 10, 8,  6,  4,  3,  2,  1,
    2,  2,  2,  1,  4,  2,  1,  1,  1,  1,  1,  4,  2,  1,  1,  0,  0,  1,  5,
    3,  2,  3,  3,  3,  3,  6,  7,  6,  6,  6,  7,  6,  6,  12, 11, 11, 10, 8,
    7,  6,  19, 17, 13, 12, 10, 9,  8,  2,  4,  4,  5,  5,  5,  8,  3,  5,  5,
    6,  6,  6,  8,  7,  6,  6,  7,  7,  7,  8,  10, 9,  10, 10, 10, 11, 10, 10,
    14, 14, 14, 14, 13, 13, 13, 19, 19, 18, 16, 15, 14, 18, 25, 22, 20, 18, 16,
    16, 12, 12, 12, 12, 12, 12, 8,  14, 14, 14, 13, 14, 13, 8,  14, 16, 15, 15,
    15, 14, 11, 14, 19, 19, 19, 19, 18, 14, 17, 23, 23, 23, 23, 20, 16, 21, 27,
    28, 27, 26, 23, 18, 25, 31, 32, 29, 28, 25, 20, 21, 23, 22, 21, 18, 14, 10,
    21, 25, 23, 23, 20, 16, 11, 21, 27, 26, 25, 22, 18, 14, 21, 27, 30, 29, 25,
    21, 18, 24, 30, 34, 34, 30, 25, 19, 27, 33, 39, 37, 32, 26, 21, 30, 36, 40,
    40, 35, 28, 23, 29, 34, 33, 27, 22, 17, 13, 29, 35, 37, 29, 23, 19, 14, 29,
    35, 39, 32, 25, 22, 17, 30, 35, 42, 35, 30, 25, 21, 31, 37, 44, 40, 35, 29,
    23, 33, 41, 46, 46, 36, 31, 25, 36, 43, 47, 46, 39, 32, 26, 1,  2,  2,  2,
    2,  2,  1,  2,  1,  2,  3,  2,  2,  1,  2,  0,  2,  2,  2,  2,  2,  2,  2,
    2,  2,  2,  3,  4,  4,  4,  4,  4,  5,  4,  4,  8,  8,  8,  7,  5,  4,  4,
    14, 12, 9,  8,  6,  4,  4,  2,  0,  2,  2,  2,  2,  2,  2,  1,  2,  2,  2,
    1,  2,  2,  2,  1,  2,  2,  1,  4,  2,  2,  2,  3,  2,  3,  5,  6,  5,  5,
    5,  5,  4,  5,  11, 10, 9,  8,  6,  5,  5,  18, 15, 11, 9,  7,  5,  5,  2,
    2,  1,  2,  1,  3,  6,  2,  2,  2,  2,  2,  4,  6,  4,  2,  3,  3,  4,  4,
    7,  7,  3,  6,  6,  6,  7,  9,  11, 7,  9,  10, 10, 10, 8,  15, 12, 14, 13,
    12, 11, 8,  20, 18, 17, 15, 14, 12, 11, 4,  6,  7,  7,  8,  7,  10, 8,  7,
    8,  8,  9,  9,  10, 11, 8,  10, 10, 11, 11, 11, 14, 10, 14, 14, 14, 14, 13,
    14, 16, 18, 18, 18, 17, 16, 15, 21, 22, 21, 20, 18, 18, 20, 28, 26, 24, 22,
    20, 19, 14, 15, 15, 15, 16, 15, 10, 17, 17, 16, 16, 17, 15, 10, 16, 18, 19,
    19, 19, 18, 14, 17, 22, 23, 23, 23, 21, 18, 19, 27, 27, 27, 27, 24, 20, 24,
    31, 34, 32, 29, 27, 21, 28, 34, 36, 33, 31, 28, 23, 24, 26, 24, 24, 21, 17,
    13, 24, 29, 27, 26, 23, 18, 14, 24, 30, 29, 28, 25, 21, 17, 24, 31, 34, 32,
    29, 25, 22, 29, 35, 38, 37, 34, 29, 23, 32, 37, 44, 42, 36, 31, 25, 34, 40,
    45, 44, 39, 33, 26, 33, 38, 37, 30, 24, 20, 16, 32, 39, 40, 32, 26, 21, 18,
    32, 38, 42, 35, 30, 25, 21, 33, 40, 46, 39, 33, 28, 24, 34, 41, 48, 43, 38,
    32, 27, 37, 43, 49, 49, 41, 35, 28, 40, 46, 49, 50, 44, 36, 30, 2,  1,  1,
    2,  2,  1,  1,  2,  1,  1,  2,  2,  1,  2,  2,  2,  0,  2,  1,  2,  3,  2,
    3,  2,  3,  3,  4,  5,  5,  5,  6,  5,  6,  5,  5,  10, 9,  9,  8,  6,  5,
    5,  16, 14, 11, 8,  7,  5,  4,  2,  2,  1,  2,  1,  2,  5,  2,  2,  1,  1,
    1,  2,  5,  3,  2,  1,  1,  1,  3,  6,  4,  3,  3,  3,  4,  4,  7,  8,  6,
    7,  7,  7,  5,  7,  12, 11, 10, 10, 9,  7,  7,  19, 16, 13, 11, 10, 9,  7,
    2,  2,  4,  4,  5,  6,  8,  4,  2,  4,  5,  5,  6,  8,  8,  2,  5,  7,  7,
    6,  9,  11, 4,  8,  10, 10, 10, 11, 14, 8,  11, 14, 14, 14, 11, 18, 14, 16,
    17, 16, 15, 11, 21, 20, 18, 19, 18, 16, 14, 8,  7,  10, 11, 11, 9,  12, 11,
    8,  11, 11, 12, 12, 12, 14, 8,  12, 14, 14, 15, 14, 17, 12, 17, 18, 18, 17,
    15, 18, 17, 21, 21, 22, 21, 19, 18, 23, 26, 25, 24, 23, 21, 22, 30, 29, 27,
    26, 24, 23, 17, 18, 18, 18, 19, 18, 12, 19, 19, 19, 20, 20, 19, 12, 20, 20,
    21, 23, 23, 22, 17, 20, 25, 27, 26, 27, 26, 21, 22, 30, 32, 31, 31, 29, 23,
    26, 35, 37, 35, 33, 30, 25, 30, 37, 40, 37, 36, 32, 27, 28, 29, 28, 28, 25,
    20, 17, 27, 32, 31, 30, 26, 22, 18, 27, 34, 34, 34, 29, 25, 21, 27, 35, 38,
    37, 34, 30, 25, 31, 38, 43, 41, 38, 33, 27, 34, 41, 49, 47, 39, 33, 29, 38,
    44, 49, 49, 43, 36, 30, 36, 43, 41, 34, 28, 24, 20, 37, 43, 44, 36, 30, 25,
    21, 36, 43, 46, 38, 34, 29, 24, 37, 44, 49, 44, 38, 34, 29, 40, 46, 53, 49,
    42, 36, 30, 42, 49, 55, 54, 45, 38, 33, 45, 51, 55, 55, 48, 41, 34, 2,  2,
    1,  2,  2,  2,  4,  2,  2,  1,  2,  2,  1,  3,  3,  2,  2,  0,  1,  2,  4,
    3,  3,  3,  3,  2,  3,  5,  6,  6,  6,  6,  5,  4,  5,  10, 10, 9,  8,  6,
    4,  5,  16, 14, 11, 9,  7,  4,  5,  2,  2,  1,  2,  3,  5,  7,  3,  2,  2,
    2,  3,  4,  6,  4,  2,  2,  2,  3,  5,  7,  7,  3,  4,  4,  6,  6,  8,  10,
    7,  7,  8,  9,  6,  8,  14, 11, 11, 10, 11, 10, 8,  19, 16, 13, 11, 13, 11,
    8,  4,  2,  5,  7,  8,  9,  11, 8,  3,  4,  7,  8,  8,  10, 11, 3,  5,  9,
    10, 8,  11, 14, 5,  8,  12, 13, 13, 13, 18, 9,  12, 16, 17, 16, 13, 21, 14,
    16, 19, 19, 18, 13, 22, 20, 18, 21, 20, 19, 17, 11, 8,  12, 14, 14, 12, 16,
    15, 8,  13, 14, 15, 16, 15, 18, 10, 14, 17, 18, 17, 16, 20, 14, 18, 20, 21,
    21, 18, 21, 19, 23, 24, 25, 24, 21, 21, 24, 27, 28, 27, 27, 24, 23, 30, 31,
    29, 29, 27, 27, 20, 19, 21, 22, 23, 22, 16, 23, 21, 23, 23, 24, 22, 15, 23,
    23, 24, 26, 26, 25, 20, 23, 27, 29, 30, 31, 29, 25, 25, 32, 33, 34, 34, 32,
    27, 27, 36, 39, 38, 36, 34, 29, 31, 39, 43, 41, 39, 37, 30, 30, 33, 33, 32,
    29, 25, 20, 29, 34, 34, 34, 30, 25, 21, 29, 37, 37, 37, 33, 28, 25, 30, 39,
    41, 40, 37, 33, 29, 33, 42, 47, 45, 41, 38, 30, 36, 44, 51, 49, 44, 38, 33,
    40, 47, 52, 53, 46, 38, 34, 41, 46, 44, 37, 32, 28, 23, 40, 45, 46, 40, 33,
    29, 25, 40, 46, 49, 42, 37, 33, 28, 40, 47, 53, 47, 41, 36, 32, 43, 50, 55,
    52, 46, 40, 35, 45, 52, 57, 56, 49, 43, 36, 48, 54, 57, 58, 52, 44, 38, 2,
    1,  2,  2,  2,  4,  5,  2,  2,  2,  2,  2,  2,  4,  3,  2,  2,  1,  0,  2,
    5,  3,  3,  3,  2,  2,  3,  6,  7,  6,  6,  5,  5,  4,  6,  11, 9,  9,  8,
    6,  4,  6,  16, 13, 10, 8,  7,  4,  6,  3,  2,  2,  3,  4,  7,  9,  3,  2,
    2,  3,  4,  6,  8,  5,  2,  2,  2,  4,  5,  8,  9,  4,  4,  4,  7,  6,  9,
    13, 7,  7,  7,  10, 6,  9,  16, 11, 11, 10, 12, 11, 9,  20, 16, 12, 11, 13,
    12, 9,  5,  2,  5,  9,  9,  10, 13, 9,  3,  5,  9,  10, 9,  11, 13, 3,  5,
    10, 11, 8,  11, 15, 6,  8,  13, 14, 14, 14, 20, 11, 12, 16, 18, 18, 13, 23,
    15, 16, 19, 20, 18, 14, 23, 19, 18, 20, 21, 20, 18, 13, 8,  13, 15, 16, 14,
    18, 16, 9,  14, 16, 17, 17, 17, 19, 11, 14, 18, 18, 19, 17, 23, 15, 18, 21,
    22, 22, 19, 24, 20, 23, 25, 26, 25, 22, 24, 24, 27, 28, 28, 28, 25, 23, 30,
    31, 30, 30, 29, 27, 21, 20, 23, 23, 25, 24, 18, 25, 22, 24, 25, 26, 24, 17,
    24, 24, 27, 28, 28, 26, 21, 24, 28, 30, 31, 31, 29, 26, 26, 32, 35, 36, 36,
    33, 28, 28, 37, 40, 39, 39, 35, 29, 30, 40, 45, 42, 40, 37, 32, 31, 34, 33,
    34, 31, 27, 22, 31, 36, 35, 36, 32, 28, 23, 30, 38, 38, 38, 34, 30, 26, 30,
    41, 42, 42, 39, 33, 29, 34, 43, 48, 47, 42, 37, 31, 36, 45, 53, 51, 44, 40,
    34, 41, 47, 53, 54, 47, 40, 35, 41, 47, 45, 39, 34, 30, 26, 41, 47, 47, 41,
    35, 30, 26, 42, 48, 50, 44, 37, 34, 30, 42, 48, 54, 47, 42, 38, 33, 43, 51,
    56, 52, 47, 40, 35, 47, 53, 59, 57, 49, 42, 37, 50, 55, 59, 59, 52, 46, 39,
    1,  2,  2,  4,  4,  3,  4,  2,  1,  2,  4,  4,  2,  3,  2,  2,  2,  2,  3,
    0,  3,  2,  2,  1,  1,  2,  2,  3,  4,  4,  4,  4,  5,  4,  4,  8,  8,  7,
    7,  6,  4,  4,  13, 11, 9,  7,  6,  4,  4,  2,  1,  2,  3,  4,  6,  7,  2,
    1,  2,  3,  4,  5,  6,  3,  2,  1,  1,  2,  3,  5,  6,  3,  2,  3,  4,  4,
    6,  10, 5,  5,  6,  7,  4,  6,  12, 9,  9,  8,  9,  7,  6,  17, 14, 10, 9,
    10, 9,  6,  2,  2,  5,  7,  8,  9,  11, 7,  2,  4,  8,  8,  8,  9,  11, 2,
    4,  7,  8,  6,  8,  14, 4,  7,  10, 10, 11, 10, 17, 8,  10, 14, 15, 14, 10,
    19, 12, 14, 16, 16, 15, 10, 20, 17, 15, 17, 18, 17, 15, 11, 7,  12, 14, 14,
    12, 15, 14, 8,  12, 15, 16, 15, 15, 17, 9,  12, 15, 16, 16, 14, 19, 12, 16,
    18, 19, 18, 15, 21, 17, 20, 22, 23, 22, 18, 20, 22, 24, 25, 25, 23, 22, 20,
    26, 26, 27, 26, 25, 24, 18, 18, 21, 22, 23, 22, 16, 21, 20, 22, 23, 24, 23,
    15, 22, 21, 24, 25, 24, 23, 18, 22, 26, 26, 28, 28, 27, 23, 23, 30, 31, 32,
    33, 29, 24, 26, 34, 38, 36, 34, 31, 26, 27, 36, 39, 37, 37, 34, 27, 28, 31,
    32, 32, 29, 25, 20, 29, 33, 33, 33, 29, 25, 21, 27, 36, 35, 34, 30, 27, 23,
    28, 38, 39, 37, 34, 29, 26, 31, 39, 43, 42, 38, 32, 28, 34, 41, 48, 46, 41,
    34, 30, 37, 44, 49, 49, 42, 37, 31, 39, 44, 42, 36, 31, 27, 23, 39, 45, 45,
    38, 33, 28, 23, 39, 45, 47, 40, 34, 30, 26, 40, 45, 52, 44, 38, 34, 30, 41,
    47, 52, 49, 42, 37, 33, 43, 48, 55, 53, 45, 39, 33, 46, 51, 56, 55, 48, 40,
    35, 2,  3,  5,  6,  6,  5,  4,  1,  2,  4,  6,  6,  4,  2,  1,  2,  3,  4,
    5,  3,  0,  1,  1,  1,  3,  4,  3,  2,  3,  3,  3,  4,  6,  4,  2,  7,  6,
    6,  6,  6,  4,  2,  11, 9,  7,  6,  6,  4,  2,  1,  2,  3,  5,  4,  5,  6,
    1,  2,  3,  4,  4,  4,  5,  2,  1,  2,  3,  2,  2,  3,  2,  1,  1,  1,  1,
    2,  4,  5,  4,  4,  4,  3,  2,  3,  9,  8,  7,  7,  5,  4,  4,  14, 11, 8,
    7,  7,  6,  4,  2,  1,  5,  5,  6,  8,  9,  2,  1,  4,  6,  6,  6,  8,  5,
    1,  4,  6,  6,  5,  6,  10, 2,  5,  7,  7,  7,  7,  13, 6,  8,  10, 11, 10,
    7,  15, 11, 11, 13, 13, 11, 7,  16, 14, 13, 14, 14, 13, 12, 6,  6,  11, 11,
    12, 11, 13, 11, 7,  11, 12, 13, 13, 12, 13, 7,  11, 13, 13, 13, 11, 16, 10,
    14, 15, 14, 15, 12, 17, 15, 17, 19, 19, 18, 15, 16, 19, 20, 21, 21, 20, 18,
    16, 22, 23, 23, 23, 21, 20, 15, 17, 18, 19, 20, 19, 13, 18, 18, 20, 20, 21,
    20, 12, 18, 19, 21, 21, 21, 19, 15, 18, 22, 24, 24, 24, 22, 18, 20, 27, 28,
    28, 28, 26, 20, 21, 30, 33, 31, 29, 28, 22, 24, 33, 34, 33, 32, 28, 24, 27,
    30, 29, 29, 26, 22, 17, 26, 31, 30, 31, 27, 22, 18, 26, 34, 33, 31, 27, 23,
    19, 26, 34, 35, 33, 31, 27, 22, 28, 36, 40, 38, 34, 29, 24, 31, 37, 43, 42,
    36, 30, 26, 33, 39, 45, 44, 39, 33, 27, 37, 41, 39, 34, 29, 25, 21, 36, 41,
    42, 36, 30, 25, 21, 37, 41, 45, 37, 31, 26, 22, 36, 42, 46, 41, 35, 31, 26,
    37, 43, 48, 44, 38, 31, 28, 39, 45, 50, 48, 41, 34, 29, 41, 46, 51, 51, 45,
    36, 29, 2,  2,  3,  4,  4,  3,  2,  2,  2,  3,  4,  4,  3,  2,  1,  2,  2,
    3,  3,  2,  1,  0,  2,  2,  2,  3,  2,  3,  3,  3,  3,  3,  4,  3,  3,  7,
    6,  7,  6,  4,  3,  3,  12, 11, 8,  7,  5,  3,  3,  1,  2,  3,  3,  2,  2,
    2,  0,  2,  2,  3,  2,  2,  1,  1,  2,  2,  2,  2,  2,  1,  2,  1,  2,  2,
    2,  1,  3,  4,  3,  4,  4,  4,  3,  3,  9,  8,  8,  7,  5,  3,  3,  16, 13,
    10, 8,  6,  4,  3,  1,  2,  2,  2,  2,  2,  3,  2,  1,  1,  2,  2,  2,  3,
    2,  0,  1,  1,  1,  1,  3,  2,  2,  2,  2,  2,  2,  5,  6,  5,  5,  5,  5,
    4,  5,  12, 10, 10, 9,  7,  6,  5,  18, 17, 13, 10, 9,  7,  6,  2,  3,  3,
    4,  4,  4,  7,  2,  4,  4,  5,  5,  5,  8,  5,  5,  5,  6,  6,  6,  7,  8,
    8,  8,  9,  9,  9,  9,  9,  13, 13, 12, 13, 12, 11, 12, 19, 17, 16, 15, 14,
    13, 18, 24, 21, 18, 17, 15, 15, 11, 11, 11, 11, 11, 11, 8,  13, 13, 12, 13,
    13, 12, 8,  12, 15, 15, 14, 14, 13, 10, 13, 18, 18, 17, 18, 16, 13, 16, 23,
    22, 22, 22, 20, 15, 20, 26, 28, 26, 25, 21, 17, 24, 29, 30, 27, 27, 23, 18,
    20, 23, 21, 21, 17, 13, 10, 21, 24, 23, 22, 19, 15, 10, 21, 25, 26, 24, 21,
    17, 12, 21, 27, 28, 27, 25, 20, 17, 23, 29, 33, 33, 29, 23, 19, 25, 32, 38,
    36, 30, 26, 20, 29, 35, 39, 39, 34, 27, 21, 28, 34, 33, 25, 21, 17, 12, 28,
    34, 34, 29, 22, 17, 13, 28, 34, 38, 30, 25, 20, 16, 29, 34, 40, 33, 29, 24,
    20, 30, 37, 42, 38, 33, 26, 22, 33, 39, 44, 43, 36, 29, 24, 35, 41, 44, 44,
    38, 32, 26, 1,  2,  3,  4,  4,  3,  3,  2,  2,  3,  4,  4,  3,  2,  1,  2,
    3,  3,  3,  2,  1,  2,  0,  2,  2,  2,  2,  3,  3,  3,  3,  3,  3,  3,  3,
    7,  6,  6,  6,  4,  3,  3,  13, 11, 8,  6,  5,  3,  3,  2,  2,  3,  3,  3,
    3,  3,  2,  1,  2,  3,  3,  2,  3,  2,  1,  2,  2,  2,  1,  1,  2,  1,  1,
    2,  1,  1,  3,  4,  4,  4,  4,  4,  3,  3,  9,  8,  8,  7,  5,  3,  3,  16,
    13, 10, 7,  5,  4,  3,  2,  1,  2,  2,  3,  4,  6,  2,  2,  2,  3,  3,  4,
    6,  2,  2,  2,  2,  3,  3,  6,  5,  2,  4,  4,  4,  5,  7,  8,  6,  8,  8,
    8,  7,  6,  13, 11, 12, 11, 10, 9,  7,  19, 16, 15, 13, 11, 10, 9,  2,  6,
    7,  8,  8,  7,  10, 5,  6,  8,  8,  9,  9,  10, 9,  7,  8,  9,  9,  9,  10,
    12, 9,  12, 12, 12, 12, 11, 12, 14, 15, 15, 16, 15, 14, 13, 20, 20, 19, 18,
    16, 15, 18, 26, 24, 21, 19, 18, 18, 13, 14, 15, 15, 16, 15, 10, 14, 16, 15,
    16, 17, 16, 10, 15, 18, 17, 17, 17, 16, 12, 15, 21, 21, 21, 21, 19, 16, 18,
    25, 25, 25, 25, 22, 17, 21, 28, 30, 28, 26, 24, 19, 25, 32, 34, 31, 30, 26,
    21, 24, 24, 25, 25, 21, 17, 13, 23, 27, 26, 25, 23, 18, 14, 23, 29, 28, 27,
    23, 19, 15, 23, 30, 31, 31, 27, 23, 19, 26, 32, 36, 35, 31, 26, 21, 29, 35,
    41, 41, 34, 28, 23, 31, 38, 42, 43, 35, 30, 24, 32, 38, 36, 30, 25, 20, 16,
    31, 38, 39, 32, 26, 21, 17, 31, 38, 41, 33, 27, 23, 19, 32, 37, 44, 36, 31,
    26, 23, 34, 39, 45, 42, 36, 30, 25, 35, 41, 47, 46, 39, 33, 26, 38, 44, 48,
    49, 42, 34, 29, 1,  2,  3,  4,  4,  4,  3,  2,  2,  3,  4,  4,  3,  2,  1,
    2,  2,  3,  3,  1,  1,  2,  2,  0,  2,  2,  2,  3,  4,  3,  3,  3,  3,  3,
    3,  7,  7,  7,  6,  4,  3,  3,  13, 11, 8,  6,  5,  3,  3,  2,  2,  2,  3,
    4,  4,  6,  2,  2,  2,  3,  3,  3,  5,  2,  1,  2,  2,  2,  2,  4,  2,  2,
    2,  1,  1,  2,  5,  5,  5,  4,  4,  4,  3,  5,  10, 9,  8,  7,  6,  4,  5,
    17, 14, 10, 8,  7,  6,  5,  2,  2,  4,  5,  5,  7,  9,  2,  2,  4,  5,  6,
    7,  8,  5,  2,  4,  5,  5,  6,  7,  8,  3,  6,  7,  7,  7,  9,  12, 6,  9,
    10, 11, 10, 9,  15, 11, 13, 14, 13, 12, 9,  19, 17, 16, 16, 14, 13, 12, 4,
    7,  10, 11, 12, 10, 13, 9,  7,  11, 12, 12, 12, 13, 12, 8,  11, 12, 12, 12,
    12, 14, 10, 14, 15, 15, 15, 13, 16, 15, 18, 18, 20, 18, 16, 15, 21, 23, 22,
    21, 20, 19, 19, 27, 26, 24, 22, 21, 20, 15, 17, 18, 19, 19, 18, 13, 17, 18,
    19, 20, 21, 19, 13, 18, 20, 21, 21, 20, 19, 15, 17, 24, 24, 24, 24, 23, 18,
    20, 27, 28, 29, 28, 26, 21, 23, 32, 34, 32, 30, 27, 22, 27, 35, 37, 35, 32,
    29, 23, 26, 29, 28, 28, 25, 21, 17, 27, 31, 30, 30, 26, 21, 17, 27, 33, 33,
    31, 27, 22, 19, 27, 34, 36, 34, 31, 26, 22, 28, 36, 41, 40, 36, 28, 24, 33,
    38, 45, 43, 37, 32, 26, 35, 41, 45, 45, 40, 34, 28, 35, 41, 40, 33, 29, 24,
    20, 35, 42, 43, 35, 29, 25, 20, 36, 41, 45, 37, 31, 26, 22, 36, 41, 47, 40,
    35, 30, 25, 37, 43, 48, 46, 40, 33, 27, 39, 44, 51, 51, 42, 35, 30, 43, 47,
    52, 52, 46, 38, 31, 2,  2,  3,  5,  5,  4,  5,  2,  2,  3,  4,  4,  3,  3,
    2,  2,  3,  3,  2,  1,  3,  2,  2,  2,  0,  2,  1,  3,  4,  4,  3,  3,  3,
    2,  3,  8,  7,  7,  6,  4,  2,  4,  13, 11, 8,  6,  5,  2,  3,  2,  2,  3,
    3,  5,  6,  8,  2,  2,  2,  3,  4,  5,  7,  2,  2,  2,  2,  3,  4,  6,  4,
    2,  2,  2,  3,  4,  6,  8,  5,  5,  5,  6,  4,  7,  11, 9,  9,  8,  8,  7,
    7,  17, 13, 10, 8,  10, 8,  7,  2,  2,  5,  7,  8,  10, 12, 4,  2,  5,  8,
    9,  9,  11, 8,  2,  5,  8,  8,  7,  9,  11, 3,  6,  10, 10, 10, 10, 15, 7,
    9,  13, 14, 13, 11, 18, 12, 13, 16, 15, 15, 11, 19, 17, 16, 17, 17, 16, 15,
    8,  8,  12, 14, 15, 13, 16, 12, 8,  13, 14, 16, 15, 15, 15, 8,  13, 15, 16,
    15, 15, 17, 12, 16, 17, 18, 18, 16, 19, 16, 20, 22, 22, 22, 18, 18, 22, 24,
    25, 24, 23, 22, 19, 26, 27, 26, 26, 24, 24, 17, 19, 21, 21, 23, 22, 16, 20,
    20, 22, 24, 24, 23, 16, 20, 22, 23, 24, 24, 22, 18, 20, 25, 27, 27, 27, 26,
    22, 22, 30, 31, 32, 31, 29, 24, 25, 34, 36, 36, 34, 30, 26, 29, 37, 40, 37,
    36, 33, 27, 28, 32, 32, 31, 29, 25, 20, 28, 34, 33, 33, 29, 25, 21, 28, 36,
    36, 35, 30, 25, 22, 29, 37, 39, 37, 33, 30, 25, 31, 39, 44, 43, 38, 33, 27,
    34, 41, 49, 46, 41, 35, 29, 39, 43, 49, 49, 42, 37, 31, 39, 46, 43, 37, 31,
    27, 23, 39, 45, 46, 39, 33, 28, 23, 39, 46, 49, 41, 34, 29, 25, 39, 45, 50,
    44, 37, 34, 29, 40, 47, 52, 49, 42, 37, 31, 43, 49, 54, 53, 46, 39, 32, 45,
    51, 54, 55, 49, 42, 34, 2,  3,  3,  4,  4,  6,  7,  2,  2,  3,  4,  3,  4,
    5,  2,  2,  3,  2,  2,  2,  4,  3,  2,  2,  2,  0,  2,  5,  5,  4,  4,  3,
    3,  3,  5,  9,  8,  7,  6,  4,  3,  5,  13, 10, 8,  6,  5,  3,  5,  2,  2,
    3,  4,  6,  9,  10, 3,  2,  3,  4,  6,  7,  9,  3,  2,  2,  3,  4,  6,  8,
    6,  3,  2,  2,  5,  5,  8,  10, 5,  5,  5,  8,  6,  8,  13, 9,  8,  8,  10,
    9,  8,  16, 13, 9,  8,  11, 11, 8,  3,  2,  6,  9,  11, 12, 14, 7,  2,  6,
    10, 11, 11, 13, 10, 3,  5,  9,  11, 10, 12, 13, 4,  7,  11, 12, 13, 12, 18,
    9,  10, 14, 16, 15, 13, 21, 12, 13, 17, 18, 17, 12, 20, 16, 15, 18, 19, 19,
    17, 10, 8,  14, 16, 17, 15, 18, 13, 8,  14, 17, 18, 18, 18, 16, 10, 14, 17,
    19, 19, 17, 20, 13, 17, 20, 21, 21, 18, 21, 18, 21, 23, 25, 24, 21, 21, 22,
    25, 26, 27, 25, 24, 20, 26, 27, 28, 28, 27, 26, 19, 20, 23, 25, 26, 25, 19,
    22, 22, 25, 26, 27, 25, 18, 23, 23, 26, 27, 27, 26, 21, 22, 26, 29, 30, 31,
    29, 24, 24, 31, 34, 34, 34, 31, 27, 26, 34, 38, 37, 36, 34, 28, 28, 36, 41,
    38, 38, 35, 30, 31, 35, 35, 35, 31, 28, 23, 31, 37, 36, 36, 33, 28, 24, 30,
    39, 38, 37, 33, 29, 25, 31, 38, 41, 40, 36, 32, 28, 32, 41, 46, 44, 40, 35,
    29, 35, 43, 52, 49, 42, 37, 32, 37, 45, 51, 51, 45, 39, 33, 40, 48, 45, 39,
    34, 31, 26, 42, 48, 48, 41, 36, 30, 26, 42, 48, 50, 43, 37, 32, 28, 41, 48,
    53, 46, 39, 35, 31, 43, 49, 54, 52, 45, 39, 33, 44, 52, 57, 56, 47, 42, 36,
    46, 53, 57, 58, 50, 43, 37, 3,  4,  4,  5,  5,  6,  7,  2,  3,  4,  5,  5,
    4,  5,  2,  3,  4,  3,  3,  2,  3,  2,  2,  2,  2,  2,  0,  3,  3,  2,  2,
    2,  3,  2,  3,  6,  5,  5,  4,  3,  2,  3,  9,  7,  5,  4,  3,  2,  3,  2,
    3,  4,  5,  6,  8,  9,  2,  3,  3,  5,  6,  6,  7,  2,  2,  3,  3,  4,  5,
    6,  4,  2,  1,  1,  3,  3,  5,  8,  3,  3,  4,  5,  3,  5,  10, 6,  6,  5,
    7,  6,  5,  12, 9,  6,  5,  8,  7,  5,  2,  2,  6,  8,  9,  11, 12, 5,  2,
    5,  9,  9,  9,  11, 9,  2,  5,  8,  9,  8,  10, 13, 2,  5,  8,  9,  9,  9,
    15, 6,  8,  11, 12, 12, 9,  16, 8,  10, 13, 14, 13, 9,  15, 12, 11, 15, 15,
    15, 13, 9,  7,  13, 15, 15, 14, 17, 14, 8,  13, 15, 16, 16, 16, 16, 8,  13,
    15, 16, 16, 15, 18, 10, 14, 17, 17, 17, 14, 19, 15, 18, 20, 20, 20, 17, 16,
    18, 21, 22, 22, 22, 20, 15, 21, 22, 24, 24, 23, 22, 17, 19, 22, 23, 24, 23,
    16, 20, 20, 23, 24, 25, 23, 16, 20, 21, 24, 25, 24, 23, 19, 20, 24, 25, 26,
    27, 25, 21, 21, 29, 30, 29, 30, 28, 23, 22, 30, 33, 33, 31, 29, 24, 22, 31,
    36, 35, 33, 31, 26, 28, 32, 32, 32, 30, 26, 21, 28, 34, 34, 34, 30, 25, 21,
    29, 36, 35, 35, 31, 26, 22, 28, 36, 38, 36, 32, 28, 24, 29, 38, 44, 40, 36,
    32, 26, 32, 40, 46, 43, 38, 33, 28, 33, 42, 46, 46, 41, 35, 30, 39, 46, 44,
    37, 32, 28, 24, 40, 45, 46, 40, 33, 29, 24, 40, 46, 48, 40, 33, 29, 24, 40,
    45, 50, 43, 37, 33, 28, 40, 45, 51, 47, 40, 34, 29, 41, 47, 52, 51, 43, 37,
    31, 43, 48, 53, 53, 46, 39, 32, 4,  5,  6,  7,  8,  6,  7,  4,  4,  5,  7,
    7,  5,  4,  3,  4,  4,  5,  6,  3,  2,  3,  3,  3,  3,  5,  3,  0,  2,  1,
    1,  2,  4,  2,  0,  3,  2,  2,  2,  3,  2,  0,  5,  3,  2,  2,  3,  2,  0,
    4,  4,  5,  6,  7,  8,  8,  3,  4,  4,  5,  6,  6,  6,  2,  4,  4,  4,  4,
    4,  4,  2,  2,  2,  2,  2,  2,  3,  2,  1,  1,  2,  2,  1,  3,  4,  3,  2,
    2,  2,  2,  3,  8,  5,  3,  2,  4,  3,  3,  3,  4,  6,  7,  9,  10, 11, 2,
    3,  6,  8,  8,  8,  9,  5,  3,  6,  7,  7,  6,  8,  9,  2,  4,  7,  6,  7,
    6,  12, 3,  5,  7,  8,  8,  6,  13, 4,  6,  9,  9,  9,  6,  11, 8,  6,  9,
    10, 10, 10, 5,  7,  11, 12, 13, 13, 14, 10, 8,  12, 13, 14, 14, 13, 13, 8,
    12, 13, 14, 14, 12, 15, 8,  12, 14, 14, 14, 11, 15, 10, 13, 15, 16, 15, 14,
    13, 12, 15, 17, 17, 17, 16, 11, 15, 17, 18, 19, 18, 18, 15, 17, 20, 20, 21,
    21, 14, 18, 18, 21, 21, 21, 20, 13, 18, 20, 22, 22, 22, 20, 16, 18, 20, 22,
    22, 23, 21, 17, 16, 23, 26, 24, 24, 22, 18, 16, 24, 27, 28, 26, 24, 20, 17,
    25, 30, 28, 28, 26, 21, 27, 29, 30, 29, 26, 23, 18, 27, 32, 31, 31, 27, 22,
    18, 27, 33, 33, 32, 27, 23, 19, 27, 33, 35, 32, 29, 24, 19, 26, 33, 37, 35,
    31, 26, 22, 27, 34, 39, 37, 32, 28, 23, 27, 34, 40, 40, 35, 29, 24, 37, 42,
    41, 34, 29, 25, 21, 37, 42, 43, 35, 30, 25, 21, 37, 43, 44, 36, 31, 27, 22,
    37, 42, 46, 40, 32, 27, 23, 36, 41, 46, 41, 35, 28, 24, 36, 42, 46, 45, 37,
    31, 26, 36, 41, 46, 46, 39, 33, 27, 4,  5,  6,  8,  8,  6,  5,  4,  5,  6,
    7,  8,  6,  4,  3,  4,  5,  6,  7,  4,  3,  3,  3,  4,  4,  4,  3,  2,  0,
    2,  2,  2,  3,  2,  2,  4,  4,  4,  3,  3,  2,  2,  10, 8,  6,  4,  3,  2,
    2,  3,  4,  5,  6,  5,  5,  5,  3,  4,  5,  6,  6,  5,  4,  2,  4,  4,  5,
    4,  4,  3,  2,  2,  3,  3,  3,  2,  1,  2,  2,  2,  2,  2,  2,  1,  6,  5,
    6,  5,  2,  1,  1,  13, 11, 7,  5,  3,  1,  1,  2,  3,  4,  4,  5,  5,  5,
    2,  3,  4,  4,  5,  4,  5,  2,  2,  4,  3,  4,  4,  4,  2,  1,  1,  1,  1,
    1,  2,  3,  3,  2,  2,  3,  1,  2,  9,  8,  7,  6,  4,  3,  2,  15, 14, 10,
    7,  6,  4,  3,  2,  3,  5,  5,  6,  6,  8,  1,  4,  5,  6,  6,  6,  8,  3,
    5,  6,  6,  6,  6,  8,  6,  6,  6,  6,  6,  7,  7,  6,  10, 9,  10, 10, 9,
    8,  9,  15, 14, 13, 12, 11, 10, 15, 21, 18, 15, 14, 12, 12, 11, 11, 11, 12,
    13, 11, 8,  12, 13, 13, 13, 14, 12, 8,  12, 14, 14, 14, 15, 13, 9,  12, 16,
    15, 15, 15, 14, 10, 14, 19, 19, 19, 19, 17, 12, 17, 23, 24, 23, 21, 19, 13,
    21, 26, 28, 25, 23, 21, 15, 20, 22, 21, 22, 19, 14, 10, 20, 24, 23, 24, 20,
    16, 11, 20, 26, 25, 25, 21, 16, 12, 20, 25, 26, 25, 22, 18, 14, 20, 26, 30,
    29, 25, 20, 15, 22, 29, 36, 33, 28, 23, 17, 25, 31, 35, 36, 30, 25, 19, 28,
    35, 32, 26, 22, 17, 13, 28, 35, 36, 29, 24, 18, 14, 28, 34, 38, 30, 25, 19,
    14, 28, 35, 38, 31, 26, 21, 17, 26, 33, 38, 36, 30, 26, 19, 29, 36, 40, 39,
    33, 28, 20, 32, 37, 40, 40, 33, 29, 23, 4,  5,  6,  7,  7,  7,  6,  3,  5,
    6,  7,  7,  6,  5,  3,  4,  5,  6,  6,  4,  3,  3,  3,  3,  4,  4,  2,  1,
    2,  0,  1,  2,  3,  2,  2,  4,  4,  4,  3,  2,  2,  1,  10, 8,  5,  4,  2,
    2,  1,  3,  4,  5,  7,  7,  7,  6,  3,  4,  5,  6,  6,  5,  5,  2,  3,  5,
    5,  5,  4,  3,  2,  2,  2,  2,  2,  2,  0,  2,  2,  1,  2,  1,  1,  0,  7,
    6,  5,  4,  2,  1,  0,  13, 11, 7,  5,  3,  1,  0,  3,  3,  4,  5,  6,  7,
    8,  2,  3,  4,  5,  6,  6,  7,  2,  2,  4,  4,  4,  4,  6,  2,  2,  2,  2,
    3,  3,  5,  5,  3,  5,  5,  5,  4,  5,  10, 8,  9,  8,  7,  6,  5,  15, 13,
    12, 10, 8,  7,  6,  2,  6,  7,  8,  9,  9,  11, 2,  7,  8,  8,  9,  9,  10,
    6,  7,  8,  9,  9,  9,  10, 9,  7,  9,  9,  9,  9,  9,  9,  11, 12, 12, 13,
    12, 11, 10, 17, 17, 16, 14, 13, 13, 16, 23, 20, 18, 16, 15, 14, 13, 14, 14,
    15, 16, 15, 11, 13, 16, 16, 16, 17, 16, 11, 14, 17, 17, 17, 17, 16, 12, 14,
    18, 17, 18, 18, 16, 13, 15, 22, 22, 21, 22, 19, 14, 19, 26, 27, 26, 24, 21,
    16, 23, 30, 31, 28, 26, 23, 18, 23, 25, 24, 24, 22, 17, 13, 23, 27, 26, 25,
    23, 18, 14, 23, 29, 29, 26, 23, 18, 14, 23, 28, 29, 28, 24, 20, 16, 23, 29,
    33, 32, 28, 23, 18, 26, 32, 39, 37, 31, 25, 19, 29, 33, 38, 39, 34, 27, 21,
    31, 37, 37, 29, 24, 20, 16, 32, 38, 39, 31, 26, 21, 17, 31, 37, 41, 33, 27,
    21, 17, 31, 36, 43, 34, 28, 24, 20, 30, 37, 42, 40, 32, 26, 21, 31, 38, 44,
    44, 35, 29, 23, 35, 40, 46, 46, 39, 31, 24, 4,  5,  6,  8,  8,  7,  6,  4,
    5,  6,  7,  7,  6,  5,  3,  4,  5,  6,  6,  4,  3,  3,  3,  3,  3,  4,  2,
    1,  2,  1,  0,  2,  2,  1,  1,  4,  4,  4,  3,  2,  1,  1,  10, 8,  5,  3,
    2,  1,  1,  4,  4,  5,  7,  7,  8,  8,  3,  4,  5,  6,  7,  6,  7,  3,  4,
    5,  5,  5,  4,  5,  2,  2,  2,  2,  2,  2,  3,  2,  2,  2,  2,  1,  0,  3,
    7,  6,  5,  4,  2,  1,  3,  13, 10, 7,  5,  4,  2,  3,  3,  4,  6,  7,  8,
    10, 10, 2,  3,  6,  7,  8,  8,  9,  3,  3,  6,  6,  6,  7,  8,  6,  2,  4,
    5,  5,  6,  7,  8,  4,  6,  7,  7,  7,  7,  12, 8,  10, 10, 9,  8,  7,  15,
    13, 13, 12, 10, 10, 8,  2,  7,  10, 11, 11, 12, 13, 6,  8,  10, 11, 12, 12,
    13, 10, 8,  11, 11, 12, 12, 12, 12, 8,  11, 12, 12, 12, 11, 12, 12, 14, 15,
    16, 14, 14, 12, 18, 20, 19, 17, 17, 15, 15, 23, 22, 21, 19, 18, 16, 14, 17,
    18, 18, 19, 18, 14, 15, 19, 19, 19, 19, 19, 13, 16, 19, 20, 20, 20, 19, 15,
    16, 21, 22, 21, 21, 20, 16, 16, 24, 25, 24, 24, 22, 17, 19, 27, 30, 29, 27,
    24, 19, 24, 32, 34, 31, 29, 26, 20, 26, 29, 28, 28, 25, 21, 16, 26, 31, 29,
    30, 26, 21, 16, 25, 32, 32, 30, 26, 21, 17, 26, 31, 33, 32, 27, 23, 19, 25,
    32, 37, 35, 31, 26, 20, 28, 34, 41, 39, 34, 27, 23, 32, 36, 42, 42, 36, 30,
    24, 35, 41, 39, 33, 28, 24, 19, 35, 41, 42, 35, 29, 24, 19, 35, 42, 45, 36,
    30, 24, 19, 35, 40, 46, 38, 31, 26, 22, 33, 40, 46, 43, 37, 29, 24, 35, 43,
    47, 47, 39, 32, 26, 39, 45, 49, 48, 41, 34, 29, 4,  5,  6,  8,  8,  7,  8,
    4,  5,  6,  7,  7,  6,  6,  3,  5,  6,  6,  5,  4,  4,  3,  3,  3,  3,  3,
    2,  2,  2,  2,  2,  0,  2,  1,  2,  5,  4,  4,  3,  2,  1,  2,  9,  7,  5,
    3,  2,  1,  2,  4,  5,  5,  7,  8,  10, 10, 3,  4,  5,  6,  7,  8,  8,  3,
    4,  5,  5,  5,  6,  6,  3,  2,  3,  3,  3,  4,  5,  4,  2,  2,  2,  3,  3,
    5,  8,  6,  5,  5,  5,  4,  5,  12, 9,  6,  5,  6,  5,  5,  3,  4,  7,  9,
    10, 12, 13, 3,  3,  7,  9,  9,  10, 11, 6,  3,  6,  8,  8,  8,  10, 9,  2,
    5,  7,  8,  8,  9,  11, 4,  7,  10, 10, 10, 9,  14, 8,  10, 12, 12, 11, 9,
    14, 11, 11, 14, 13, 12, 11, 6,  8,  12, 13, 14, 14, 16, 10, 9,  13, 14, 15,
    15, 16, 13, 9,  13, 14, 15, 15, 15, 15, 9,  13, 15, 15, 16, 14, 15, 13, 16,
    18, 18, 18, 17, 14, 18, 21, 21, 20, 19, 18, 14, 21, 23, 23, 22, 21, 20, 16,
    19, 20, 21, 22, 22, 16, 18, 20, 22, 23, 23, 22, 16, 18, 21, 23, 23, 24, 22,
    18, 18, 23, 24, 24, 25, 23, 19, 18, 27, 28, 27, 27, 25, 20, 21, 30, 33, 31,
    30, 27, 22, 24, 31, 35, 33, 32, 29, 23, 27, 32, 31, 31, 28, 24, 20, 28, 34,
    32, 33, 29, 24, 20, 27, 35, 36, 34, 29, 25, 20, 28, 35, 37, 36, 31, 27, 22,
    27, 34, 40, 39, 35, 29, 23, 31, 38, 44, 43, 37, 31, 25, 34, 39, 45, 46, 40,
    33, 27, 38, 45, 43, 37, 31, 26, 22, 39, 44, 46, 39, 33, 27, 23, 39, 45, 47,
    40, 33, 28, 23, 39, 45, 49, 41, 35, 30, 26, 37, 43, 49, 46, 39, 33, 27, 38,
    45, 51, 50, 43, 35, 29, 41, 46, 51, 51, 44, 38, 31, 5,  5,  6,  7,  7,  9,
    10, 5,  5,  6,  7,  7,  7,  8,  4,  5,  6,  5,  5,  5,  6,  4,  3,  3,  3,
    3,  3,  4,  3,  3,  2,  2,  0,  1,  4,  4,  3,  3,  2,  1,  1,  4,  6,  5,
    3,  2,  2,  2,  4,  4,  5,  6,  7,  9,  11, 12, 4,  5,  5,  7,  9,  10, 10,
    4,  4,  5,  5,  7,  8,  9,  5,  3,  3,  3,  5,  6,  7,  6,  3,  2,  3,  6,
    5,  7,  8,  4,  4,  4,  7,  7,  7,  10, 7,  4,  4,  8,  8,  7,  3,  5,  8,
    11, 12, 14, 15, 5,  4,  7,  11, 12, 12, 14, 8,  4,  7,  10, 11, 11, 13, 12,
    3,  5,  10, 11, 12, 11, 13, 4,  7,  12, 13, 13, 12, 14, 6,  8,  12, 14, 14,
    12, 14, 9,  9,  13, 16, 16, 15, 8,  9,  14, 17, 18, 17, 20, 12, 10, 15, 17,
    19, 19, 19, 15, 10, 16, 18, 19, 19, 18, 17, 10, 15, 18, 18, 19, 17, 16, 14,
    17, 20, 21, 21, 20, 15, 16, 20, 22, 23, 23, 22, 14, 18, 21, 23, 24, 24, 24,
    19, 21, 24, 25, 26, 26, 19, 21, 22, 25, 26, 28, 26, 19, 21, 24, 26, 28, 27,
    25, 21, 21, 25, 26, 27, 28, 27, 22, 20, 28, 30, 30, 31, 29, 24, 21, 29, 34,
    33, 32, 30, 25, 21, 30, 37, 35, 34, 33, 27, 30, 34, 35, 34, 32, 28, 24, 30,
    37, 37, 37, 33, 28, 24, 30, 39, 39, 37, 33, 29, 25, 31, 38, 40, 39, 35, 30,
    25, 30, 39, 43, 41, 36, 32, 27, 31, 40, 47, 44, 39, 33, 29, 32, 41, 45, 47,
    41, 36, 31, 42, 48, 47, 40, 35, 31, 26, 43, 49, 49, 42, 36, 32, 27, 42, 48,
    51, 44, 37, 32, 27, 43, 48, 53, 44, 39, 33, 29, 41, 47, 53, 49, 41, 35, 31,
    42, 48, 52, 50, 44, 38, 32, 43, 48, 53, 53, 46, 40, 33, 4,  5,  5,  6,  6,
    8,  8,  4,  5,  5,  6,  6,  6,  6,  3,  4,  5,  4,  4,  4,  4,  3,  3,  3,
    2,  3,  2,  3,  2,  2,  1,  1,  1,  0,  2,  3,  2,  2,  2,  1,  0,  2,  5,
    3,  2,  1,  1,  0,  2,  4,  4,  5,  6,  8,  10, 10, 3,  4,  5,  6,  7,  8,
    9,  3,  3,  4,  4,  5,  6,  7,  4,  2,  2,  2,  3,  4,  5,  6,  2,  2,  2,
    4,  3,  5,  7,  3,  2,  2,  5,  5,  5,  9,  5,  3,  2,  6,  6,  5,  3,  4,
    7,  9,  11, 12, 14, 5,  3,  7,  10, 10, 10, 12, 9,  3,  6,  9,  9,  9,  10,
    13, 2,  5,  8,  9,  10, 9,  13, 3,  5,  9,  10, 11, 9,  16, 5,  6,  10, 12,
    12, 9,  14, 8,  7,  11, 13, 13, 13, 9,  8,  13, 15, 16, 15, 17, 13, 8,  13,
    16, 16, 17, 17, 16, 8,  13, 16, 17, 16, 16, 18, 9,  14, 16, 17, 17, 14, 18,
    12, 15, 18, 19, 18, 17, 15, 13, 17, 19, 20, 20, 20, 14, 16, 19, 21, 21, 21,
    21, 16, 19, 22, 23, 24, 24, 18, 20, 20, 22, 24, 25, 23, 17, 20, 21, 25, 25,
    25, 24, 19, 20, 24, 25, 26, 26, 24, 20, 18, 25, 27, 28, 28, 25, 21, 18, 26,
    30, 30, 29, 27, 23, 18, 27, 32, 32, 31, 30, 25, 29, 33, 33, 32, 30, 26, 21,
    28, 35, 34, 34, 31, 26, 21, 29, 38, 37, 35, 31, 27, 22, 28, 36, 38, 37, 32,
    28, 23, 28, 36, 41, 39, 34, 29, 25, 29, 36, 42, 42, 35, 30, 26, 30, 37, 43,
    43, 38, 33, 27, 40, 47, 45, 37, 33, 28, 24, 40, 45, 46, 40, 34, 29, 25, 41,
    46, 49, 41, 34, 29, 25, 40, 45, 50, 42, 36, 31, 26, 39, 44, 49, 46, 38, 33,
    28, 39, 45, 50, 47, 40, 34, 30, 39, 46, 50, 49, 43, 36, 30, 4,  5,  6,  8,
    8,  6,  6,  4,  4,  5,  7,  7,  5,  4,  3,  4,  5,  5,  6,  4,  2,  3,  3,
    3,  3,  5,  3,  0,  2,  1,  1,  2,  4,  2,  0,  2,  2,  2,  2,  3,  2,  0,
    4,  3,  2,  2,  3,  2,  0,  4,  4,  5,  6,  6,  8,  8,  3,  4,  5,  5,  6,
    6,  6,  3,  4,  4,  4,  4,  4,  5,  2,  2,  2,  2,  2,  2,  3,  2,  2,  1,
    1,  1,  1,  3,  4,  2,  2,  2,  2,  2,  3,  7,  5,  2,  2,  3,  3,  3,  3,
    4,  6,  8,  9,  10, 11, 2,  3,  6,  8,  8,  8,  9,  5,  3,  6,  7,  7,  7,
    8,  9,  2,  4,  7,  6,  7,  6,  11, 2,  4,  7,  8,  8,  6,  13, 4,  5,  8,
    9,  9,  6,  10, 8,  6,  9,  10, 10, 10, 5,  7,  11, 12, 13, 13, 14, 10, 7,
    11, 13, 14, 14, 13, 13, 8,  12, 13, 14, 13, 12, 15, 7,  12, 14, 14, 14, 11,
    16, 10, 13, 15, 15, 15, 14, 12, 12, 15, 16, 17, 17, 16, 10, 15, 17, 18, 18,
    18, 18, 15, 17, 20, 20, 21, 20, 14, 18, 18, 21, 21, 22, 20, 13, 18, 19, 21,
    22, 22, 20, 17, 17, 21, 23, 23, 23, 21, 16, 16, 22, 25, 25, 25, 23, 18, 16,
    24, 27, 27, 25, 24, 20, 17, 25, 30, 28, 28, 26, 21, 25, 29, 30, 30, 26, 23,
    18, 27, 32, 32, 30, 27, 23, 18, 27, 34, 34, 33, 28, 23, 19, 27, 33, 34, 32,
    29, 25, 20, 26, 33, 37, 34, 30, 26, 21, 27, 33, 41, 38, 32, 28, 23, 27, 34,
    39, 41, 35, 29, 24, 36, 42, 39, 34, 29, 25, 21, 37, 43, 42, 36, 31, 26, 22,
    37, 43, 45, 38, 31, 26, 22, 38, 42, 47, 39, 32, 28, 23, 37, 40, 45, 42, 34,
    29, 24, 35, 41, 46, 44, 36, 30, 26, 36, 42, 46, 45, 40, 33, 27, 8,  9,  10,
    12, 12, 11, 10, 8,  9,  10, 12, 12, 10, 9,  7,  8,  9,  10, 11, 8,  7,  7,
    7,  7,  8,  8,  6,  3,  4,  4,  4,  5,  4,  3,  2,  0,  2,  2,  2,  3,  3,
    2,  6,  5,  2,  2,  2,  3,  2,  7,  8,  10, 11, 11, 11, 10, 7,  8,  9,  10,
    10, 10, 9,  6,  7,  9,  9,  9,  8,  7,  6,  6,  6,  7,  6,  5,  2,  3,  3,
    3,  3,  3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  9,  7,  4,  2,  1,  2,  2,
    6,  8,  9,  9,  10, 11, 10, 6,  7,  8,  9,  9,  9,  9,  5,  6,  7,  7,  8,
    8,  7,  5,  5,  5,  5,  5,  5,  3,  2,  1,  1,  2,  2,  2,  3,  5,  4,  3,
    2,  0,  2,  3,  11, 10, 6,  4,  2,  2,  3,  6,  7,  8,  9,  11, 12, 11, 5,
    7,  8,  10, 10, 10, 10, 4,  7,  8,  8,  8,  9,  8,  5,  6,  5,  6,  6,  6,
    6,  3,  6,  6,  6,  7,  7,  7,  5,  11, 10, 9,  8,  8,  8,  11, 16, 13, 12,
    10, 9,  10, 9,  10, 11, 11, 12, 12, 12, 11, 12, 12, 12, 13, 12, 10, 11, 13,
    14, 13, 13, 12, 8,  11, 15, 14, 14, 14, 13, 9,  11, 16, 16, 15, 15, 15, 10,
    12, 18, 21, 20, 18, 16, 11, 17, 21, 24, 21, 20, 18, 13, 18, 20, 20, 21, 18,
    14, 11, 19, 23, 23, 22, 19, 14, 10, 19, 24, 25, 24, 20, 15, 10, 18, 24, 25,
    26, 22, 16, 11, 18, 24, 27, 27, 23, 17, 13, 19, 24, 30, 29, 24, 20, 15, 21,
    27, 31, 31, 27, 21, 16, 27, 33, 33, 26, 21, 16, 12, 27, 33, 35, 27, 22, 17,
    13, 27, 33, 36, 29, 23, 18, 13, 28, 33, 37, 30, 25, 19, 15, 26, 33, 36, 33,
    26, 22, 16, 27, 32, 35, 34, 28, 23, 19, 28, 31, 36, 36, 31, 25, 20, 8,  9,
    10, 11, 11, 11, 10, 7,  8,  10, 11, 11, 10, 8,  7,  8,  9,  10, 9,  8,  6,
    6,  6,  7,  7,  7,  5,  2,  4,  4,  4,  4,  4,  2,  2,  2,  0,  2,  2,  2,
    2,  2,  6,  4,  2,  2,  2,  2,  2,  7,  8,  9,  11, 11, 11, 11, 6,  8,  9,
    10, 11, 9,  9,  6,  7,  8,  9,  8,  7,  6,  6,  5,  6,  6,  6,  5,  2,  3,
    3,  3,  3,  2,  2,  2,  3,  2,  2,  2,  1,  2,  2,  9,  7,  3,  2,  1,  2,
    2,  6,  7,  8,  9,  11, 11, 12, 6,  6,  8,  9,  10, 10, 10, 6,  6,  8,  8,
    8,  8,  8,  5,  5,  6,  6,  5,  5,  5,  3,  2,  3,  3,  3,  3,  4,  5,  5,
    5,  4,  3,  4,  5,  11, 9,  8,  6,  5,  5,  5,  6,  9,  9,  11, 12, 14, 13,
    5,  8,  10, 11, 12, 12, 11, 5,  8,  9,  9,  9,  10, 9,  8,  7,  8,  8,  8,
    9,  8,  6,  8,  9,  9,  10, 10, 10, 6,  13, 13, 12, 11, 11, 11, 11, 18, 16,
    14, 12, 12, 13, 12, 13, 14, 14, 15, 15, 13, 12, 15, 15, 16, 16, 14, 11, 13,
    16, 17, 16, 16, 15, 11, 13, 17, 17, 16, 17, 16, 12, 12, 19, 19, 18, 18, 17,
    13, 14, 22, 23, 21, 20, 18, 14, 19, 24, 26, 24, 22, 20, 16, 22, 24, 24, 24,
    21, 17, 13, 22, 26, 25, 25, 22, 17, 12, 22, 28, 28, 27, 22, 17, 13, 22, 27,
    29, 27, 24, 19, 14, 22, 27, 30, 30, 25, 20, 16, 21, 28, 34, 33, 27, 21, 17,
    25, 30, 34, 35, 30, 24, 18, 31, 37, 36, 29, 23, 19, 15, 30, 36, 39, 32, 25,
    20, 16, 30, 37, 40, 32, 26, 21, 17, 31, 35, 41, 33, 27, 22, 17, 29, 35, 41,
    36, 29, 23, 19, 29, 35, 41, 38, 32, 26, 20, 30, 37, 40, 42, 34, 27, 22, 8,
    9,  10, 12, 11, 11, 10, 7,  8,  10, 11, 11, 9,  8,  7,  8,  9,  9,  9,  7,
    6,  6,  6,  7,  7,  7,  5,  2,  4,  4,  3,  4,  3,  2,  2,  2,  2,  0,  2,
    2,  2,  2,  5,  3,  2,  1,  2,  2,  2,  7,  8,  9,  10, 11, 11, 12, 7,  8,
    9,  10, 11, 10, 10, 6,  7,  8,  8,  8,  7,  7,  6,  6,  6,  6,  5,  4,  4,
    3,  3,  3,  3,  2,  2,  4,  3,  2,  2,  1,  2,  2,  3,  7,  5,  3,  1,  1,
    2,  3,  6,  7,  9,  11, 12, 14, 14, 6,  7,  10, 11, 12, 12, 12, 6,  7,  9,
    10, 9,  9,  9,  5,  5,  7,  7,  7,  7,  6,  6,  2,  4,  5,  5,  5,  6,  8,
    4,  7,  7,  6,  6,  6,  8,  7,  8,  9,  7,  7,  8,  6,  10, 11, 12, 14, 15,
    15, 5,  9,  11, 12, 13, 13, 13, 8,  9,  11, 11, 12, 11, 11, 10, 8,  11, 11,
    11, 12, 10, 9,  9,  11, 12, 12, 12, 13, 8,  13, 15, 15, 14, 14, 14, 8,  16,
    17, 16, 15, 15, 15, 13, 16, 17, 17, 18, 18, 15, 15, 17, 18, 18, 19, 17, 13,
    15, 18, 20, 19, 19, 18, 14, 15, 20, 20, 20, 20, 19, 14, 13, 22, 22, 21, 21,
    20, 15, 16, 24, 26, 24, 23, 21, 17, 18, 25, 28, 27, 25, 23, 19, 24, 27, 27,
    27, 24, 20, 16, 26, 29, 29, 29, 25, 21, 16, 25, 31, 31, 30, 25, 21, 17, 24,
    31, 32, 30, 26, 22, 17, 24, 30, 34, 32, 28, 23, 18, 24, 31, 36, 36, 30, 24,
    20, 27, 33, 38, 39, 33, 27, 21, 35, 39, 39, 32, 27, 22, 18, 34, 41, 42, 34,
    28, 23, 19, 35, 41, 44, 36, 29, 24, 19, 34, 40, 44, 37, 30, 25, 21, 33, 39,
    44, 39, 32, 26, 22, 32, 39, 43, 43, 34, 29, 23, 34, 40, 45, 45, 39, 30, 25,
    7,  8,  9,  10, 10, 10, 11, 7,  7,  8,  10, 10, 9,  8,  6,  7,  8,  9,  8,
    7,  6,  6,  6,  6,  6,  6,  4,  3,  3,  3,  3,  3,  2,  1,  2,  2,  2,  2,
    0,  2,  2,  2,  4,  3,  2,  1,  1,  1,  2,  7,  7,  8,  9,  10, 12, 13, 6,
    7,  8,  9,  10, 10, 11, 6,  7,  7,  7,  8,  8,  8,  5,  5,  5,  5,  5,  5,
    5,  3,  2,  2,  2,  2,  3,  5,  3,  2,  2,  2,  2,  3,  4,  6,  4,  2,  2,
    3,  3,  4,  6,  7,  10, 11, 13, 14, 15, 5,  6,  9,  12, 12, 12, 12, 4,  6,
    9,  10, 10, 10, 10, 8,  4,  6,  8,  8,  8,  8,  10, 2,  4,  7,  8,  8,  8,
    11, 3,  5,  8,  9,  9,  8,  10, 7,  6,  10, 10, 10, 11, 5,  10, 13, 13, 15,
    15, 17, 8,  9,  12, 14, 14, 14, 15, 11, 9,  13, 13, 14, 14, 14, 13, 8,  13,
    14, 14, 15, 13, 13, 10, 14, 15, 16, 16, 16, 11, 12, 16, 16, 17, 16, 17, 10,
    15, 17, 18, 18, 18, 18, 15, 18, 20, 20, 22, 21, 17, 17, 20, 22, 22, 22, 21,
    15, 17, 20, 23, 22, 22, 22, 17, 17, 22, 23, 23, 23, 22, 17, 16, 24, 25, 25,
    25, 23, 19, 16, 25, 28, 27, 26, 24, 20, 17, 26, 30, 28, 29, 26, 22, 27, 31,
    31, 31, 27, 24, 19, 27, 32, 33, 33, 28, 24, 19, 27, 35, 35, 34, 29, 24, 20,
    27, 33, 35, 34, 29, 25, 21, 26, 33, 38, 36, 31, 26, 22, 27, 32, 39, 39, 33,
    27, 23, 28, 34, 39, 40, 35, 30, 25, 38, 44, 42, 36, 31, 26, 21, 38, 45, 45,
    38, 31, 27, 22, 37, 44, 47, 39, 32, 27, 22, 38, 43, 48, 40, 34, 28, 23, 37,
    42, 48, 43, 35, 30, 25, 36, 43, 47, 45, 37, 32, 27, 37, 42, 47, 47, 41, 33,
    28, 6,  6,  7,  8,  8,  9,  10, 5,  6,  7,  8,  8,  8,  8,  5,  6,  6,  6,
    6,  6,  6,  4,  4,  4,  4,  4,  3,  3,  2,  2,  2,  2,  1,  1,  3,  3,  2,
    2,  2,  0,  1,  3,  5,  4,  2,  2,  1,  1,  3,  5,  6,  7,  8,  10, 12, 13,
    5,  5,  6,  8,  10, 10, 10, 4,  5,  6,  6,  7,  8,  8,  4,  3,  3,  4,  5,
    6,  7,  5,  3,  2,  2,  4,  4,  7,  6,  3,  3,  2,  5,  5,  7,  8,  5,  3,
    3,  6,  6,  7,  4,  5,  8,  11, 13, 14, 15, 4,  4,  8,  11, 12, 12, 14, 8,
    4,  8,  10, 10, 11, 12, 11, 3,  5,  9,  10, 11, 11, 12, 3,  5,  10, 11, 12,
    11, 13, 4,  7,  11, 13, 13, 11, 12, 8,  7,  12, 13, 14, 14, 8,  9,  14, 16,
    17, 17, 19, 11, 9,  14, 17, 18, 17, 18, 14, 9,  15, 17, 18, 18, 17, 16, 10,
    14, 17, 18, 19, 16, 16, 12, 16, 18, 20, 19, 19, 14, 14, 18, 20, 21, 21, 21,
    12, 16, 20, 22, 22, 22, 22, 17, 21, 23, 24, 25, 25, 19, 20, 21, 24, 25, 26,
    25, 18, 20, 22, 26, 26, 27, 25, 21, 20, 25, 26, 27, 27, 26, 21, 18, 26, 28,
    29, 29, 27, 22, 18, 27, 31, 32, 30, 29, 24, 19, 29, 33, 33, 33, 30, 25, 30,
    33, 34, 34, 31, 27, 23, 30, 37, 36, 35, 32, 27, 23, 30, 38, 38, 37, 33, 28,
    23, 30, 38, 39, 37, 33, 29, 24, 28, 37, 42, 39, 35, 30, 25, 30, 37, 44, 42,
    36, 32, 27, 31, 38, 43, 44, 38, 33, 29, 42, 48, 45, 40, 34, 30, 26, 41, 48,
    48, 41, 35, 30, 26, 42, 47, 50, 42, 36, 31, 27, 41, 47, 51, 44, 37, 32, 27,
    40, 45, 51, 46, 39, 34, 29, 40, 46, 50, 49, 42, 36, 30, 40, 46, 51, 51, 44,
    37, 32, 4,  5,  5,  6,  6,  8,  8,  4,  5,  5,  6,  6,  6,  6,  3,  4,  5,
    4,  4,  4,  4,  3,  3,  3,  2,  3,  2,  2,  2,  2,  1,  1,  2,  0,  2,  3,
    2,  2,  1,  2,  0,  2,  5,  3,  2,  1,  1,  0,  2,  4,  4,  5,  6,  8,  9,
    10, 3,  4,  5,  6,  8,  8,  8,  3,  4,  4,  4,  6,  6,  7,  4,  2,  2,  2,
    4,  4,  5,  6,  2,  2,  2,  4,  3,  5,  7,  3,  2,  2,  5,  5,  5,  9,  5,
    3,  2,  6,  6,  5,  3,  4,  7,  9,  10, 12, 14, 5,  3,  7,  10, 10, 10, 12,
    9,  3,  6,  8,  9,  9,  10, 13, 2,  5,  8,  9,  10, 9,  13, 3,  5,  9,  11,
    11, 9,  17, 5,  6,  10, 11, 12, 9,  14, 9,  7,  11, 13, 13, 13, 9,  8,  13,
    15, 15, 15, 17, 15, 8,  13, 16, 17, 17, 16, 16, 8,  14, 15, 16, 17, 16, 19,
    9,  13, 17, 17, 17, 14, 18, 12, 15, 18, 18, 19, 17, 15, 13, 17, 19, 20, 20,
    20, 15, 16, 19, 21, 21, 21, 22, 17, 19, 22, 23, 25, 23, 18, 20, 20, 23, 24,
    26, 23, 17, 20, 21, 25, 25, 26, 24, 19, 20, 23, 25, 25, 26, 24, 20, 19, 25,
    27, 28, 28, 26, 22, 18, 26, 30, 30, 29, 27, 23, 19, 27, 32, 32, 31, 28, 25,
    28, 32, 32, 33, 30, 26, 21, 29, 35, 35, 34, 31, 26, 22, 29, 37, 36, 36, 31,
    26, 22, 28, 36, 39, 37, 33, 28, 23, 29, 35, 40, 40, 33, 29, 24, 28, 36, 42,
    41, 36, 30, 26, 30, 37, 43, 44, 38, 33, 28, 40, 46, 44, 38, 32, 29, 25, 40,
    46, 47, 39, 33, 29, 24, 42, 45, 49, 41, 35, 30, 25, 39, 46, 50, 42, 36, 30,
    26, 39, 44, 49, 46, 39, 32, 28, 39, 45, 50, 48, 40, 34, 29, 39, 45, 50, 50,
    43, 37, 31, 4,  5,  6,  7,  7,  6,  6,  4,  4,  5,  7,  7,  5,  4,  3,  4,
    5,  5,  6,  4,  2,  3,  3,  3,  3,  5,  3,  0,  2,  1,  1,  2,  4,  2,  0,
    2,  2,  2,  2,  3,  2,  0,  4,  3,  2,  2,  3,  2,  0,  4,  4,  5,  6,  7,
    8,  8,  3,  4,  4,  5,  6,  6,  7,  3,  4,  4,  4,  4,  4,  4,  2,  2,  2,
    2,  2,  2,  3,  2,  2,  1,  1,  1,  1,  3,  4,  2,  2,  2,  2,  2,  3,  7,
    5,  2,  2,  4,  3,  3,  3,  4,  6,  8,  9,  10, 11, 2,  3,  7,  8,  8,  8,
    9,  5,  3,  6,  7,  6,  6,  8,  9,  2,  4,  7,  6,  6,  6,  11, 2,  4,  7,
    8,  8,  6,  12, 4,  5,  8,  9,  9,  6,  10, 8,  6,  9,  10, 10, 10, 5,  7,
    11, 13, 13, 13, 14, 10, 7,  11, 13, 14, 14, 13, 13, 8,  12, 13, 14, 13, 12,
    15, 8,  12, 14, 14, 14, 11, 15, 10, 13, 15, 15, 15, 14, 13, 12, 15, 16, 17,
    16, 17, 10, 15, 17, 18, 18, 18, 18, 15, 17, 19, 20, 21, 20, 15, 18, 19, 20,
    21, 22, 21, 13, 18, 20, 22, 22, 22, 20, 16, 18, 22, 22, 22, 23, 22, 17, 16,
    23, 24, 24, 25, 23, 18, 16, 24, 27, 27, 26, 23, 20, 17, 25, 30, 28, 28, 25,
    21, 27, 30, 29, 30, 27, 23, 19, 27, 32, 32, 31, 27, 23, 18, 26, 34, 34, 32,
    27, 23, 19, 27, 33, 34, 33, 29, 24, 19, 25, 33, 37, 35, 31, 26, 21, 27, 33,
    40, 38, 32, 26, 22, 27, 34, 40, 40, 34, 29, 24, 37, 43, 40, 34, 29, 26, 21,
    37, 42, 44, 36, 31, 25, 22, 36, 41, 46, 37, 30, 26, 22, 37, 42, 47, 39, 32,
    28, 23, 36, 41, 46, 42, 36, 29, 24, 36, 40, 45, 44, 36, 31, 25, 35, 41, 45,
    46, 40, 33, 28, 14, 15, 16, 18, 18, 17, 16, 13, 15, 16, 18, 17, 16, 14, 13,
    14, 16, 16, 16, 13, 11, 12, 13, 13, 13, 13, 9,  5,  10, 10, 10, 9,  6,  5,
    5,  6,  6,  5,  4,  5,  5,  4,  0,  2,  2,  3,  4,  5,  4,  13, 14, 16, 17,
    17, 17, 16, 12, 14, 15, 16, 17, 16, 14, 12, 13, 15, 15, 14, 13, 11, 11, 12,
    12, 12, 11, 9,  4,  9,  8,  8,  8,  5,  4,  4,  5,  4,  4,  3,  3,  4,  4,
    3,  2,  2,  2,  3,  4,  4,  12, 13, 15, 16, 17, 17, 17, 11, 13, 14, 15, 16,
    15, 15, 12, 12, 13, 13, 13, 12, 11, 11, 11, 10, 10, 10, 8,  4,  7,  7,  7,
    7,  3,  4,  4,  2,  2,  2,  2,  3,  3,  4,  5,  4,  1,  2,  3,  4,  5,  11,
    13, 14, 16, 17, 18, 18, 11, 13, 14, 16, 17, 16, 16, 10, 13, 14, 14, 14, 14,
    12, 7,  12, 11, 11, 11, 9,  9,  4,  8,  7,  7,  5,  5,  6,  3,  6,  6,  6,
    7,  6,  7,  5,  11, 8,  8,  8,  8,  8,  12, 12, 14, 15, 17, 18, 19, 10, 12,
    14, 15, 16, 16, 16, 10, 12, 13, 13, 13, 13, 12, 10, 12, 12, 12, 12, 10, 7,
    8,  13, 13, 13, 14, 13, 8,  8,  14, 16, 16, 16, 15, 10, 11, 17, 19, 18, 18,
    17, 11, 16, 18, 18, 19, 16, 17, 18, 16, 20, 20, 21, 17, 15, 15, 16, 22, 22,
    21, 17, 12, 11, 16, 21, 23, 23, 19, 14, 10, 15, 20, 25, 24, 20, 17, 11, 15,
    22, 27, 25, 23, 18, 13, 17, 23, 27, 28, 24, 20, 15, 25, 31, 30, 24, 18, 16,
    17, 25, 31, 32, 26, 20, 15, 14, 25, 31, 33, 27, 21, 16, 11, 25, 30, 35, 28,
    23, 18, 13, 24, 30, 32, 28, 24, 21, 15, 24, 28, 31, 30, 25, 21, 17, 24, 28,
    31, 31, 27, 23, 19, 12, 13, 15, 16, 16, 16, 15, 12, 13, 14, 15, 15, 14, 12,
    11, 12, 14, 14, 13, 11, 9,  11, 11, 11, 11, 10, 7,  3,  8,  8,  8,  7,  5,
    3,  3,  5,  4,  3,  3,  3,  3,  3,  2,  0,  2,  2,  3,  3,  3,  11, 12, 14,
    15, 16, 16, 15, 11, 12, 13, 15, 15, 14, 12, 11, 12, 13, 13, 12, 11, 9,  11,
    10, 10, 10, 9,  7,  3,  8,  7,  7,  7,  3,  3,  3,  4,  3,  3,  2,  2,  3,
    3,  3,  2,  2,  2,  2,  2,  3,  10, 12, 13, 14, 15, 16, 17, 10, 11, 13, 14,
    14, 14, 14, 11, 11, 12, 12, 12, 11, 10, 10, 10, 10, 10, 9,  7,  5,  5,  6,
    7,  6,  4,  4,  5,  3,  2,  3,  3,  3,  4,  5,  3,  2,  3,  3,  3,  4,  4,
    11, 13, 14, 15, 17, 18, 18, 9,  13, 14, 15, 16, 16, 15, 7,  13, 14, 13, 13,
    13, 11, 8,  11, 11, 11, 10, 9,  9,  6,  7,  8,  8,  8,  8,  8,  3,  8,  9,
    9,  9,  9,  10, 3,  11, 11, 11, 10, 11, 11, 12, 13, 14, 15, 17, 18, 17, 11,
    13, 14, 15, 16, 16, 15, 11, 14, 15, 15, 15, 14, 11, 11, 15, 15, 15, 15, 14,
    10, 10, 17, 17, 16, 17, 15, 12, 11, 17, 20, 19, 18, 17, 13, 13, 18, 22, 20,
    21, 19, 14, 20, 22, 22, 22, 19, 18, 17, 20, 24, 23, 24, 20, 16, 15, 20, 26,
    26, 25, 20, 16, 12, 20, 26, 27, 25, 22, 17, 13, 19, 24, 28, 28, 24, 19, 14,
    19, 25, 31, 30, 25, 20, 16, 20, 25, 31, 33, 27, 22, 17, 28, 34, 33, 27, 22,
    18, 17, 29, 36, 36, 29, 23, 18, 14, 28, 35, 39, 30, 25, 19, 14, 29, 34, 39,
    31, 25, 20, 16, 27, 33, 38, 34, 28, 22, 18, 28, 33, 37, 36, 30, 25, 19, 27,
    34, 38, 39, 33, 26, 21, 9,  11, 12, 13, 13, 13, 12, 9,  10, 11, 13, 12, 11,
    9,  9,  9,  11, 11, 10, 9,  7,  8,  8,  8,  8,  8,  5,  2,  6,  6,  5,  5,
    3,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  0,  2,  2,  2,  2,  9,  9,
    11, 12, 12, 13, 13, 9,  9,  10, 12, 12, 11, 11, 8,  9,  10, 10, 9,  9,  8,
    8,  7,  7,  7,  7,  5,  3,  5,  5,  4,  4,  2,  2,  3,  2,  2,  1,  1,  2,
    2,  3,  4,  2,  2,  1,  2,  2,  3,  8,  9,  11, 12, 13, 15, 15, 8,  8,  11,
    12, 13, 13, 13, 8,  8,  11, 11, 10, 10, 10, 6,  7,  8,  8,  8,  7,  6,  5,
    3,  5,  6,  4,  5,  6,  6,  2,  4,  5,  5,  5,  6,  5,  4,  5,  6,  6,  6,
    7,  8,  11, 12, 13, 15, 16, 16, 5,  11, 12, 14, 14, 14, 14, 7,  11, 12, 12,
    12, 12, 11, 10, 9,  10, 10, 10, 10, 10, 8,  7,  10, 11, 11, 12, 12, 6,  10,
    13, 12, 13, 13, 13, 5,  13, 14, 14, 14, 14, 15, 12, 15, 16, 16, 17, 18, 16,
    14, 16, 17, 18, 18, 17, 14, 13, 18, 19, 19, 19, 17, 13, 13, 19, 18, 19, 18,
    18, 14, 13, 20, 20, 20, 20, 19, 15, 13, 21, 22, 22, 22, 20, 16, 16, 22, 26,
    24, 24, 22, 18, 23, 26, 25, 25, 23, 19, 16, 24, 28, 28, 28, 24, 19, 15, 24,
    30, 30, 29, 24, 20, 15, 23, 29, 30, 29, 25, 21, 16, 23, 29, 33, 31, 27, 22,
    17, 24, 29, 35, 34, 29, 23, 19, 23, 29, 34, 36, 32, 26, 21, 33, 39, 38, 31,
    25, 21, 18, 33, 40, 41, 33, 27, 22, 18, 33, 39, 43, 35, 29, 22, 18, 33, 39,
    44, 36, 29, 24, 19, 32, 37, 43, 38, 30, 25, 20, 31, 36, 43, 41, 33, 27, 22,
    31, 37, 43, 42, 36, 30, 24, 7,  8,  10, 11, 11, 11, 11, 7,  8,  9,  11, 10,
    9,  8,  7,  8,  9,  9,  8,  7,  6,  6,  6,  6,  6,  6,  4,  2,  4,  3,  3,
    3,  2,  2,  2,  2,  2,  1,  1,  2,  1,  2,  3,  2,  1,  0,  2,  1,  2,  7,
    8,  8,  10, 11, 12, 13, 7,  7,  8,  9,  10, 10, 10, 6,  7,  8,  8,  8,  8,
    8,  6,  6,  5,  5,  5,  5,  4,  3,  3,  2,  3,  2,  3,  4,  3,  2,  2,  1,
    2,  2,  4,  6,  3,  2,  2,  2,  3,  4,  6,  7,  10, 11, 13, 14, 14, 6,  7,
    10, 11, 12, 12, 12, 4,  6,  9,  10, 10, 10, 9,  6,  5,  7,  8,  8,  7,  8,
    8,  2,  4,  7,  7,  7,  8,  9,  3,  5,  8,  8,  8,  8,  8,  6,  6,  9,  9,
    9,  10, 5,  10, 12, 13, 14, 15, 16, 7,  9,  12, 13, 14, 14, 14, 10, 9,  12,
    13, 13, 13, 13, 13, 8,  12, 13, 13, 14, 12, 12, 9,  13, 14, 15, 15, 15, 9,
    12, 15, 16, 16, 16, 16, 8,  15, 17, 18, 17, 16, 18, 14, 18, 19, 19, 21, 20,
    16, 16, 19, 20, 21, 21, 20, 14, 16, 20, 22, 22, 21, 20, 16, 16, 22, 23, 22,
    23, 21, 17, 15, 23, 24, 24, 23, 22, 18, 15, 23, 27, 26, 25, 24, 19, 17, 24,
    29, 27, 27, 26, 20, 26, 30, 29, 30, 27, 22, 18, 26, 31, 31, 31, 28, 22, 18,
    27, 34, 33, 33, 28, 23, 19, 26, 32, 35, 34, 29, 24, 19, 27, 33, 36, 35, 30,
    25, 21, 25, 33, 40, 38, 33, 26, 22, 27, 33, 40, 39, 34, 29, 24, 37, 43, 41,
    34, 29, 25, 21, 37, 43, 43, 37, 30, 26, 21, 36, 43, 46, 38, 32, 26, 21, 38,
    41, 48, 40, 33, 27, 23, 35, 41, 47, 42, 35, 29, 24, 35, 42, 47, 44, 37, 31,
    26, 35, 41, 47, 46, 39, 32, 27, 6,  7,  8,  9,  9,  10, 11, 6,  7,  7,  9,
    9,  8,  8,  5,  6,  7,  7,  7,  6,  6,  5,  5,  5,  5,  5,  3,  3,  3,  2,
    2,  2,  2,  1,  3,  3,  2,  2,  1,  1,  1,  3,  4,  3,  2,  2,  0,  1,  3,
    5,  6,  7,  8,  10, 12, 13, 5,  6,  7,  8,  10, 10, 10, 4,  6,  6,  7,  8,
    8,  8,  4,  4,  4,  4,  5,  6,  6,  4,  2,  2,  2,  3,  3,  6,  5,  3,  2,
    2,  4,  4,  6,  7,  4,  3,  2,  5,  5,  6,  5,  6,  9,  11, 12, 14, 14, 4,
    5,  9,  11, 12, 12, 13, 7,  5,  8,  10, 10, 10, 11, 10, 3,  6,  9,  9,  9,
    10, 12, 3,  5,  9,  10, 10, 10, 13, 4,  6,  10, 11, 11, 10, 11, 8,  7,  11,
    12, 13, 13, 6,  9,  13, 15, 16, 16, 18, 10, 9,  13, 15, 17, 17, 17, 14, 9,
    14, 15, 16, 17, 16, 16, 9,  14, 16, 17, 17, 15, 15, 11, 15, 17, 18, 18, 18,
    13, 13, 17, 19, 19, 19, 19, 12, 16, 18, 20, 20, 21, 21, 16, 19, 22, 23, 24,
    23, 18, 19, 20, 23, 24, 25, 23, 17, 19, 22, 25, 25, 25, 23, 19, 18, 24, 25,
    26, 26, 25, 20, 17, 26, 27, 27, 27, 26, 21, 17, 25, 29, 30, 29, 27, 23, 19,
    28, 33, 31, 30, 29, 24, 29, 32, 33, 32, 30, 25, 21, 29, 35, 35, 34, 31, 26,
    22, 28, 37, 36, 35, 30, 26, 22, 29, 36, 38, 37, 32, 27, 22, 28, 35, 40, 38,
    34, 29, 23, 29, 36, 42, 41, 36, 31, 26, 30, 36, 43, 44, 38, 32, 27, 40, 46,
    44, 38, 33, 28, 24, 41, 46, 47, 40, 34, 29, 24, 40, 46, 50, 41, 35, 29, 25,
    39, 46, 49, 42, 36, 30, 26, 39, 45, 49, 46, 38, 33, 27, 38, 45, 49, 48, 40,
    34, 29, 39, 45, 49, 48, 43, 36, 30, 4,  5,  5,  6,  6,  8,  8,  4,  5,  5,
    6,  6,  6,  6,  3,  4,  5,  4,  4,  4,  4,  3,  3,  3,  2,  3,  2,  2,  2,
    2,  1,  1,  2,  0,  2,  3,  2,  2,  2,  1,  0,  2,  5,  3,  2,  1,  1,  0,
    2,  4,  4,  5,  6,  8,  10, 10, 3,  4,  5,  6,  8,  8,  8,  3,  4,  4,  4,
    5,  6,  7,  4,  2,  2,  2,  3,  4,  5,  6,  2,  2,  2,  4,  3,  5,  7,  3,
    2,  2,  5,  4,  5,  10, 5,  3,  2,  6,  6,  5,  3,  4,  7,  9,  10, 12, 14,
    5,  3,  7,  10, 10, 10, 12, 9,  3,  6,  8,  9,  9,  10, 13, 2,  5,  8,  9,
    10, 9,  14, 3,  5,  9,  11, 10, 9,  15, 5,  6,  10, 12, 11, 9,  14, 8,  7,
    11, 13, 13, 13, 10, 8,  13, 15, 16, 15, 18, 14, 8,  13, 15, 17, 17, 16, 16,
    9,  14, 16, 16, 17, 16, 18, 9,  14, 16, 17, 17, 14, 18, 12, 15, 18, 18, 19,
    17, 16, 13, 17, 19, 20, 20, 19, 14, 16, 19, 20, 21, 21, 21, 17, 19, 22, 23,
    24, 23, 18, 19, 20, 23, 24, 26, 23, 17, 20, 21, 25, 25, 25, 24, 19, 20, 23,
    25, 26, 26, 24, 20, 18, 26, 28, 28, 28, 26, 21, 18, 26, 31, 31, 29, 27, 23,
    19, 27, 33, 32, 32, 28, 24, 28, 33, 33, 32, 30, 26, 22, 29, 34, 35, 35, 31,
    27, 22, 28, 38, 37, 35, 31, 26, 23, 29, 37, 37, 37, 32, 27, 23, 28, 35, 40,
    39, 34, 29, 24, 29, 35, 43, 41, 36, 31, 27, 29, 38, 43, 44, 38, 32, 27, 40,
    46, 44, 37, 32, 28, 24, 39, 45, 46, 40, 33, 29, 24, 41, 45, 49, 41, 34, 30,
    25, 40, 45, 50, 42, 35, 31, 26, 39, 44, 49, 45, 38, 33, 28, 39, 46, 50, 47,
    41, 35, 29, 40, 44, 50, 50, 43, 36, 31, 4,  5,  6,  8,  8,  6,  6,  4,  4,
    5,  7,  7,  5,  4,  3,  4,  5,  5,  6,  4,  2,  3,  3,  3,  4,  5,  3,  0,
    2,  2,  1,  2,  4,  2,  0,  2,  2,  2,  2,  3,  2,  0,  4,  3,  2,  2,  3,
    2,  0,  4,  4,  5,  6,  6,  8,  8,  3,  4,  4,  5,  6,  6,  7,  3,  4,  4,
    4,  4,  4,  4,  2,  2,  2,  2,  2,  2,  3,  2,  2,  1,  1,  1,  1,  3,  4,
    3,  2,  2,  2,  2,  3,  7,  5,  2,  2,  3,  3,  3,  3,  4,  6,  8,  9,  10,
    11, 2,  3,  6,  8,  8,  8,  9,  5,  3,  6,  7,  6,  6,  8,  9,  2,  4,  7,
    6,  6,  6,  11, 2,  4,  7,  8,  8,  6,  12, 4,  5,  8,  9,  9,  6,  10, 8,
    6,  9,  10, 10, 10, 5,  7,  11, 12, 13, 13, 14, 10, 7,  12, 13, 13, 14, 13,
    14, 8,  12, 13, 13, 13, 12, 14, 8,  12, 14, 14, 14, 11, 15, 10, 13, 15, 15,
    15, 14, 14, 12, 15, 16, 17, 16, 16, 10, 15, 17, 18, 18, 18, 18, 15, 18, 19,
    20, 21, 20, 14, 18, 18, 20, 21, 22, 20, 13, 18, 20, 22, 22, 21, 20, 16, 18,
    22, 23, 22, 23, 22, 17, 16, 24, 24, 24, 24, 22, 18, 16, 24, 27, 27, 26, 24,
    20, 17, 25, 30, 29, 28, 26, 21, 26, 29, 30, 29, 26, 22, 18, 26, 32, 30, 30,
    27, 23, 19, 27, 33, 33, 32, 27, 23, 19, 26, 33, 34, 32, 28, 24, 20, 27, 34,
    36, 35, 31, 25, 21, 27, 34, 40, 38, 33, 27, 23, 28, 34, 39, 39, 35, 29, 24,
    36, 42, 40, 34, 29, 25, 21, 37, 43, 43, 36, 30, 25, 21, 36, 42, 45, 37, 32,
    27, 21, 37, 41, 46, 38, 32, 27, 23, 35, 40, 45, 41, 35, 28, 24, 36, 42, 46,
    44, 37, 32, 25, 37, 41, 46, 46, 38, 33, 27, 2,  2,  3,  3,  3,  2,  2,  1,
    2,  3,  3,  3,  2,  2,  0,  2,  2,  3,  3,  2,  1,  1,  2,  2,  2,  2,  2,
    4,  3,  3,  3,  4,  4,  3,  4,  7,  7,  7,  6,  5,  4,  4,  13, 11, 9,  7,
    5,  4,  4,  0,  2,  2,  3,  2,  2,  1,  1,  2,  2,  3,  2,  2,  1,  2,  1,
    2,  2,  2,  1,  1,  2,  1,  2,  2,  2,  2,  3,  4,  4,  4,  5,  4,  4,  4,
    9,  9,  9,  7,  5,  4,  4,  16, 14, 10, 8,  6,  4,  4,  2,  1,  2,  1,  2,
    1,  4,  2,  1,  2,  1,  1,  1,  4,  2,  1,  0,  0,  1,  0,  5,  3,  2,  3,
    3,  3,  3,  6,  7,  6,  6,  6,  7,  6,  7,  12, 11, 11, 10, 9,  7,  7,  19,
    17, 14, 12, 10, 9,  8,  2,  4,  5,  5,  5,  5,  8,  3,  5,  5,  6,  6,  6,
    8,  7,  6,  6,  7,  7,  8,  8,  10, 9,  10, 10, 10, 11, 10, 10, 14, 14, 14,
    14, 14, 12, 13, 20, 19, 17, 16, 15, 14, 19, 26, 22, 20, 18, 16, 15, 12, 13,
    12, 13, 12, 12, 8,  13, 14, 14, 14, 14, 13, 8,  14, 16, 16, 15, 16, 15, 11,
    13, 20, 19, 19, 19, 18, 14, 17, 25, 24, 22, 23, 21, 16, 21, 27, 30, 26, 25,
    23, 17, 25, 31, 32, 29, 27, 25, 20, 21, 23, 22, 21, 18, 15, 11, 21, 26, 24,
    23, 20, 16, 11, 22, 27, 26, 25, 22, 18, 14, 22, 28, 30, 29, 25, 22, 18, 25,
    31, 35, 34, 30, 25, 20, 27, 33, 40, 38, 33, 26, 22, 31, 37, 41, 41, 35, 28,
    23, 29, 35, 34, 27, 22, 17, 13, 29, 35, 36, 29, 23, 19, 15, 30, 35, 38, 31,
    26, 21, 17, 30, 36, 41, 35, 30, 25, 21, 31, 37, 43, 40, 35, 28, 24, 34, 40,
    46, 45, 38, 31, 25, 37, 42, 46, 46, 39, 33, 27, 1,  2,  2,  2,  2,  2,  1,
    2,  1,  2,  3,  2,  2,  1,  2,  0,  2,  2,  2,  1,  2,  2,  2,  2,  2,  2,
    3,  4,  4,  4,  4,  5,  5,  4,  4,  8,  8,  8,  7,  6,  4,  4,  14, 13, 9,
    8,  6,  4,  4,  2,  0,  2,  2,  2,  1,  2,  2,  1,  2,  2,  2,  1,  2,  2,
    2,  1,  2,  2,  1,  4,  2,  2,  2,  3,  2,  3,  5,  6,  5,  5,  6,  5,  4,
    5,  11, 10, 10, 8,  6,  5,  5,  18, 15, 11, 9,  7,  5,  5,  2,  2,  1,  1,
    1,  3,  6,  2,  2,  2,  2,  2,  4,  6,  3,  2,  3,  3,  4,  4,  7,  7,  3,
    6,  6,  7,  7,  9,  11, 7,  10, 10, 11, 9,  9,  15, 12, 14, 13, 12, 11, 9,
    20, 18, 17, 16, 14, 12, 12, 4,  6,  7,  8,  8,  7,  10, 7,  7,  8,  8,  9,
    9,  10, 11, 8,  10, 10, 11, 11, 11, 14, 10, 13, 14, 14, 14, 13, 14, 16, 18,
    18, 18, 17, 15, 15, 22, 23, 21, 21, 19, 18, 20, 28, 26, 24, 22, 20, 19, 15,
    15, 15, 15, 16, 14, 10, 17, 17, 17, 17, 17, 15, 10, 17, 19, 19, 19, 19, 18,
    14, 17, 22, 23, 23, 23, 22, 18, 20, 27, 28, 26, 28, 25, 20, 24, 30, 34, 32,
    29, 27, 21, 29, 34, 35, 33, 31, 28, 22, 25, 26, 24, 25, 21, 17, 13, 24, 29,
    27, 26, 23, 18, 14, 25, 31, 30, 29, 25, 22, 17, 25, 32, 34, 33, 29, 25, 22,
    28, 34, 38, 38, 34, 28, 23, 31, 37, 45, 42, 36, 30, 25, 34, 39, 45, 45, 38,
    32, 27, 33, 38, 36, 30, 25, 20, 16, 33, 39, 40, 32, 26, 21, 18, 34, 39, 43,
    34, 30, 26, 21, 33, 39, 46, 39, 33, 29, 25, 35, 40, 48, 44, 38, 31, 27, 38,
    44, 50, 48, 42, 34, 29, 40, 46, 51, 51, 44, 37, 30, 2,  1,  2,  2,  2,  2,
    1,  2,  2,  1,  2,  2,  1,  2,  2,  2,  1,  1,  2,  2,  3,  2,  3,  2,  3,
    3,  4,  5,  5,  5,  6,  5,  6,  5,  5,  10, 9,  9,  8,  7,  5,  5,  16, 13,
    11, 8,  7,  5,  5,  2,  2,  0,  2,  1,  2,  4,  3,  2,  1,  2,  1,  2,  5,
    3,  2,  1,  1,  1,  3,  6,  4,  3,  3,  3,  3,  4,  7,  8,  7,  7,  7,  7,
    5,  7,  12, 11, 11, 10, 9,  7,  7,  20, 16, 13, 11, 10, 9,  7,  3,  2,  4,
    4,  4,  5,  7,  5,  2,  4,  4,  5,  5,  8,  8,  3,  5,  7,  7,  6,  9,  11,
    4,  8,  10, 10, 10, 11, 15, 9,  11, 14, 14, 13, 11, 18, 14, 16, 17, 16, 15,
    11, 21, 19, 19, 19, 18, 16, 15, 8,  7,  10, 10, 10, 8,  11, 12, 8,  11, 11,
    12, 12, 12, 15, 9,  12, 14, 14, 15, 14, 17, 12, 17, 18, 18, 18, 15, 18, 17,
    20, 21, 22, 22, 19, 18, 24, 26, 25, 23, 23, 21, 22, 30, 28, 28, 25, 24, 23,
    17, 18, 19, 18, 19, 17, 12, 20, 19, 20, 19, 20, 19, 12, 20, 20, 22, 23, 23,
    22, 17, 20, 24, 26, 27, 27, 26, 22, 23, 29, 31, 31, 31, 29, 24, 25, 33, 36,
    35, 33, 30, 25, 30, 38, 40, 38, 36, 31, 27, 28, 29, 28, 27, 24, 21, 15, 27,
    32, 31, 30, 26, 22, 18, 27, 33, 33, 32, 30, 25, 22, 28, 35, 39, 37, 33, 29,
    25, 31, 38, 43, 42, 38, 32, 27, 35, 42, 48, 46, 40, 34, 28, 38, 44, 49, 49,
    43, 36, 30, 37, 42, 39, 34, 27, 23, 19, 37, 42, 43, 36, 30, 25, 21, 37, 42,
    46, 39, 33, 29, 25, 37, 44, 50, 42, 38, 32, 28, 39, 45, 52, 49, 42, 36, 31,
    43, 48, 54, 54, 46, 39, 33, 44, 50, 55, 55, 48, 41, 33, 2,  2,  1,  2,  2,
    1,  3,  3,  2,  2,  2,  1,  1,  4,  3,  2,  2,  2,  3,  3,  5,  3,  3,  4,
    3,  4,  5,  6,  6,  6,  7,  7,  7,  6,  6,  11, 11, 11, 10, 8,  6,  6,  17,
    15, 12, 10, 8,  6,  6,  3,  2,  2,  0,  1,  4,  6,  3,  2,  2,  1,  1,  4,
    6,  5,  3,  2,  3,  3,  5,  8,  8,  4,  4,  5,  7,  6,  9,  11, 7,  8,  9,
    10, 7,  9,  15, 12, 12, 12, 12, 10, 9,  21, 18, 14, 12, 13, 12, 9,  5,  3,
    5,  6,  6,  7,  8,  8,  3,  5,  7,  7,  6,  9,  11, 3,  5,  9,  10, 8,  11,
    15, 5,  9,  13, 13, 13, 13, 18, 10, 12, 17, 18, 16, 13, 21, 16, 17, 20, 19,
    18, 13, 24, 21, 20, 21, 21, 19, 17, 11, 8,  12, 12, 13, 10, 13, 15, 9,  12,
    14, 15, 14, 15, 18, 11, 14, 17, 18, 19, 16, 20, 14, 18, 20, 21, 21, 18, 21,
    20, 22, 24, 25, 24, 21, 22, 25, 29, 28, 26, 27, 24, 23, 31, 31, 31, 29, 29,
    27, 20, 19, 20, 21, 21, 20, 13, 24, 20, 21, 23, 23, 22, 14, 23, 22, 24, 26,
    27, 25, 20, 24, 26, 29, 30, 30, 29, 25, 24, 33, 35, 35, 35, 31, 27, 28, 37,
    40, 39, 37, 33, 28, 32, 40, 44, 40, 40, 37, 32, 29, 32, 31, 32, 27, 23, 18,
    29, 35, 33, 33, 30, 26, 22, 29, 36, 36, 37, 32, 28, 25, 29, 37, 41, 41, 37,
    33, 29, 33, 41, 47, 46, 42, 36, 31, 36, 45, 52, 50, 44, 38, 31, 40, 46, 53,
    53, 46, 40, 34, 40, 45, 43, 37, 30, 26, 22, 40, 46, 45, 38, 32, 28, 25, 39,
    45, 49, 43, 38, 32, 28, 39, 46, 53, 46, 41, 36, 33, 44, 49, 54, 52, 46, 40,
    35, 45, 52, 58, 57, 48, 43, 36, 48, 54, 60, 59, 52, 44, 38, 2,  1,  1,  3,
    3,  1,  2,  2,  2,  1,  2,  3,  2,  3,  2,  2,  1,  3,  4,  4,  4,  2,  3,
    4,  5,  6,  6,  6,  6,  7,  7,  8,  10, 8,  6,  11, 11, 11, 10, 10, 8,  7,
    17, 15, 13, 11, 10, 8,  7,  2,  2,  1,  1,  0,  2,  4,  2,  2,  1,  1,  1,
    3,  5,  5,  2,  2,  2,  3,  4,  6,  9,  3,  4,  5,  6,  5,  8,  11, 7,  8,
    9,  10, 6,  8,  15, 13, 13, 12, 11, 10, 8,  21, 18, 15, 13, 13, 12, 8,  5,
    2,  4,  5,  5,  5,  7,  10, 2,  4,  6,  7,  5,  8,  13, 2,  5,  9,  10, 6,
    10, 15, 5,  8,  12, 13, 12, 12, 17, 10, 12, 16, 17, 16, 12, 21, 16, 17, 19,
    19, 17, 12, 24, 21, 20, 21, 20, 19, 16, 13, 7,  11, 12, 11, 8,  11, 16, 9,
    11, 12, 14, 13, 13, 19, 11, 13, 16, 17, 17, 15, 21, 14, 17, 20, 20, 21, 17,
    21, 19, 22, 24, 23, 24, 21, 22, 25, 27, 28, 27, 26, 23, 24, 31, 31, 30, 28,
    27, 26, 21, 18, 19, 20, 20, 19, 11, 24, 19, 21, 21, 22, 22, 13, 25, 21, 23,
    25, 26, 24, 19, 24, 26, 27, 30, 29, 28, 24, 25, 31, 33, 34, 35, 33, 26, 27,
    36, 39, 38, 36, 34, 28, 32, 41, 42, 41, 39, 35, 30, 28, 30, 30, 28, 25, 22,
    16, 29, 33, 31, 31, 28, 24, 20, 28, 35, 34, 35, 31, 28, 24, 29, 37, 40, 39,
    37, 31, 28, 32, 40, 45, 45, 41, 35, 29, 36, 44, 51, 48, 42, 37, 32, 39, 48,
    51, 50, 45, 39, 33, 38, 43, 41, 34, 28, 24, 21, 38, 43, 43, 37, 31, 28, 24,
    37, 44, 46, 39, 36, 31, 28, 37, 45, 51, 45, 39, 36, 31, 41, 49, 54, 51, 45,
    39, 33, 44, 51, 57, 56, 47, 41, 34, 47, 52, 57, 58, 50, 43, 37, 2,  1,  3,
    5,  5,  3,  2,  2,  1,  3,  4,  6,  4,  3,  2,  1,  2,  5,  7,  6,  5,  2,
    3,  4,  6,  8,  8,  8,  5,  6,  7,  9,  11, 10, 8,  11, 11, 11, 12, 12, 10,
    8,  17, 15, 13, 12, 12, 10, 8,  2,  1,  2,  4,  2,  0,  2,  2,  2,  2,  3,
    3,  1,  4,  2,  2,  1,  4,  4,  3,  5,  5,  3,  4,  6,  6,  6,  6,  8,  7,
    8,  9,  9,  7,  7,  14, 13, 12, 12, 10, 8,  6,  21, 18, 15, 12, 10, 9,  7,
    2,  2,  3,  2,  2,  3,  5,  6,  2,  3,  3,  4,  4,  6,  10, 2,  4,  6,  7,
    5,  7,  13, 3,  8,  10, 10, 10, 10, 15, 9,  12, 14, 14, 13, 10, 19, 15, 17,
    17, 16, 15, 10, 23, 22, 19, 19, 17, 16, 14, 10, 7,  9,  9,  9,  6,  8,  14,
    7,  10, 10, 11, 11, 10, 16, 9,  11, 13, 14, 15, 12, 19, 12, 16, 18, 18, 18,
    14, 18, 17, 20, 22, 22, 21, 17, 19, 24, 25, 25, 25, 24, 21, 23, 30, 29, 28,
    26, 24, 23, 19, 16, 17, 17, 17, 16, 9,  23, 18, 18, 18, 20, 18, 10, 23, 20,
    21, 22, 23, 21, 16, 22, 24, 26, 27, 27, 26, 22, 22, 29, 31, 31, 31, 29, 23,
    25, 35, 37, 36, 34, 31, 25, 31, 38, 39, 37, 35, 32, 26, 27, 28, 27, 26, 23,
    18, 14, 28, 31, 27, 27, 25, 21, 18, 26, 32, 32, 32, 29, 25, 21, 26, 34, 37,
    36, 32, 29, 25, 30, 38, 43, 42, 39, 31, 28, 35, 42, 49, 46, 39, 33, 28, 39,
    44, 49, 49, 42, 38, 30, 35, 41, 36, 31, 25, 21, 18, 34, 39, 39, 32, 27, 25,
    20, 36, 40, 41, 36, 33, 29, 25, 35, 42, 47, 42, 36, 32, 29, 39, 44, 52, 49,
    41, 37, 31, 42, 48, 54, 52, 44, 38, 32, 45, 50, 53, 54, 47, 41, 34, 1,  4,
    5,  7,  7,  5,  3,  1,  3,  5,  7,  8,  6,  5,  1,  2,  5,  7,  9,  8,  6,
    2,  3,  6,  8,  10, 9,  8,  5,  6,  8,  10, 12, 10, 8,  10, 10, 12, 13, 12,
    10, 8,  16, 15, 13, 13, 13, 10, 8,  1,  2,  4,  5,  4,  2,  0,  2,  1,  4,
    5,  4,  3,  2,  2,  1,  3,  6,  5,  4,  4,  2,  3,  5,  7,  7,  6,  6,  6,
    7,  8,  10, 10, 8,  6,  12, 12, 12, 13, 10, 8,  6,  20, 17, 14, 13, 11, 9,
    6,  2,  1,  1,  1,  2,  2,  3,  2,  2,  1,  1,  1,  2,  4,  5,  2,  2,  3,
    3,  3,  5,  10, 3,  6,  7,  6,  7,  7,  12, 8,  10, 11, 11, 10, 7,  17, 14,
    15, 14, 12, 11, 7,  22, 20, 18, 16, 14, 13, 11, 5,  6,  6,  6,  6,  5,  7,
    11, 6,  7,  7,  8,  8,  7,  14, 7,  9,  10, 11, 11, 9,  16, 10, 14, 14, 14,
    15, 11, 16, 16, 18, 18, 18, 18, 15, 17, 23, 23, 22, 21, 19, 18, 22, 30, 26,
    24, 22, 21, 20, 16, 14, 14, 13, 14, 13, 7,  18, 15, 15, 15, 16, 15, 7,  18,
    18, 18, 19, 19, 17, 13, 19, 22, 22, 23, 23, 22, 18, 20, 27, 28, 28, 28, 25,
    20, 24, 31, 34, 32, 29, 26, 22, 29, 34, 37, 34, 32, 29, 23, 24, 24, 23, 23,
    19, 15, 11, 24, 28, 25, 24, 21, 18, 14, 24, 30, 28, 27, 26, 21, 18, 24, 31,
    33, 32, 29, 26, 22, 27, 34, 39, 36, 33, 29, 23, 32, 38, 44, 42, 35, 30, 25,
    34, 41, 45, 45, 39, 33, 26, 30, 37, 33, 27, 22, 18, 14, 32, 36, 35, 29, 24,
    21, 18, 32, 36, 38, 32, 28, 25, 21, 31, 37, 44, 38, 33, 29, 25, 34, 40, 46,
    42, 38, 32, 27, 38, 44, 48, 48, 41, 34, 29, 42, 48, 50, 50, 43, 35, 30, 2,
    2,  3,  4,  4,  3,  2,  2,  2,  3,  4,  4,  2,  2,  1,  2,  2,  3,  3,  2,
    1,  0,  2,  2,  2,  3,  2,  3,  3,  3,  3,  3,  4,  3,  3,  7,  6,  7,  6,
    5,  3,  3,  13, 11, 9,  7,  5,  3,  3,  1,  2,  3,  3,  2,  2,  2,  0,  2,
    2,  3,  2,  2,  1,  1,  2,  2,  2,  2,  2,  1,  1,  1,  2,  2,  2,  2,  3,
    4,  4,  4,  4,  4,  3,  3,  9,  8,  8,  7,  5,  4,  3,  16, 13, 10, 8,  6,
    4,  3,  1,  2,  2,  2,  2,  2,  3,  2,  2,  2,  1,  2,  1,  3,  2,  1,  1,
    1,  1,  1,  4,  2,  2,  2,  2,  2,  2,  6,  6,  6,  5,  5,  6,  5,  5,  12,
    11, 10, 9,  7,  6,  5,  18, 16, 13, 11, 9,  7,  7,  2,  3,  4,  4,  4,  4,
    8,  2,  5,  4,  5,  5,  5,  8,  5,  5,  6,  6,  6,  7,  8,  8,  8,  9,  9,
    9,  10, 9,  9,  13, 13, 13, 13, 12, 12, 12, 18, 17, 16, 15, 14, 13, 18, 24,
    21, 19, 16, 15, 15, 11, 11, 12, 12, 12, 11, 7,  13, 13, 13, 13, 13, 12, 8,
    13, 15, 14, 15, 14, 13, 10, 13, 19, 18, 18, 18, 17, 14, 16, 23, 22, 21, 23,
    20, 15, 20, 26, 27, 26, 24, 22, 17, 24, 29, 31, 28, 26, 24, 19, 20, 22, 21,
    21, 18, 14, 9,  21, 24, 23, 22, 19, 15, 10, 21, 26, 25, 25, 21, 17, 13, 21,
    27, 29, 28, 25, 20, 17, 23, 28, 33, 32, 29, 23, 18, 26, 31, 38, 37, 32, 25,
    20, 29, 35, 38, 39, 34, 28, 22, 28, 35, 33, 26, 21, 17, 12, 28, 34, 35, 28,
    23, 18, 14, 28, 34, 38, 30, 25, 20, 16, 28, 34, 40, 35, 29, 24, 20, 30, 36,
    43, 39, 32, 28, 23, 32, 38, 43, 42, 36, 29, 24, 34, 40, 44, 46, 38, 32, 26,
    0,  2,  2,  3,  3,  2,  2,  1,  2,  2,  3,  2,  2,  1,  2,  1,  2,  2,  2,
    1,  2,  2,  1,  2,  2,  2,  3,  4,  4,  4,  4,  4,  5,  4,  4,  8,  8,  8,
    7,  5,  4,  4,  14, 12, 9,  7,  6,  4,  4,  2,  1,  2,  3,  2,  2,  1,  2,
    0,  2,  2,  2,  1,  1,  2,  1,  2,  2,  2,  1,  3,  2,  2,  2,  2,  2,  3,
    4,  5,  5,  5,  5,  5,  4,  4,  10, 9,  9,  8,  6,  4,  4,  17, 15, 11, 9,
    7,  5,  4,  2,  1,  1,  1,  1,  2,  6,  2,  2,  1,  1,  1,  3,  6,  2,  2,
    2,  2,  2,  3,  7,  6,  3,  5,  5,  5,  6,  8,  9,  7,  9,  9,  9,  8,  8,
    14, 12, 13, 12, 11, 10, 8,  20, 18, 16, 14, 12, 11, 10, 3,  6,  6,  6,  7,
    6,  9,  6,  7,  7,  8,  8,  8,  9,  9,  7,  9,  9,  10, 10, 10, 12, 10, 12,
    13, 13, 13, 12, 13, 15, 16, 17, 17, 16, 14, 14, 21, 21, 20, 19, 17, 16, 20,
    28, 24, 22, 20, 19, 18, 14, 15, 14, 14, 15, 13, 9,  16, 17, 16, 15, 16, 15,
    10, 16, 17, 18, 18, 18, 17, 13, 15, 22, 21, 21, 22, 20, 17, 19, 26, 27, 26,
    26, 23, 19, 23, 31, 32, 30, 28, 25, 20, 27, 33, 35, 31, 29, 27, 21, 24, 25,
    24, 24, 20, 16, 12, 23, 27, 25, 25, 22, 18, 14, 24, 30, 28, 27, 25, 20, 17,
    23, 30, 33, 31, 28, 24, 20, 27, 33, 38, 36, 32, 28, 22, 30, 36, 42, 41, 34,
    29, 24, 33, 39, 43, 42, 37, 31, 26, 32, 37, 36, 29, 23, 19, 15, 32, 37, 38,
    30, 25, 20, 17, 31, 36, 40, 33, 28, 23, 20, 32, 38, 44, 38, 32, 28, 24, 34,
    41, 46, 44, 37, 31, 25, 36, 43, 48, 49, 40, 34, 28, 39, 45, 49, 50, 42, 35,
    30, 2,  0,  2,  2,  2,  2,  1,  2,  1,  2,  2,  2,  1,  1,  2,  2,  2,  2,
    2,  2,  3,  2,  2,  2,  2,  3,  3,  4,  5,  5,  5,  5,  5,  5,  4,  9,  9,
    9,  8,  6,  5,  4,  15, 13, 10, 8,  7,  5,  4,  2,  2,  1,  2,  1,  1,  4,
    2,  2,  0,  2,  1,  1,  4,  2,  2,  1,  1,  1,  2,  5,  3,  3,  3,  3,  3,
    4,  6,  7,  6,  6,  6,  6,  4,  6,  11, 11, 11, 9,  7,  6,  6,  19, 16, 12,
    10, 9,  7,  6,  3,  2,  3,  3,  3,  5,  7,  3,  2,  3,  4,  4,  5,  7,  7,
    2,  4,  6,  6,  5,  8,  10, 3,  7,  9,  9,  9,  10, 13, 8,  11, 12, 13, 12,
    10, 17, 13, 15, 16, 15, 13, 10, 21, 19, 18, 17, 16, 15, 14, 7,  7,  9,  9,
    10, 8,  11, 11, 8,  10, 10, 11, 11, 11, 13, 8,  11, 12, 13, 13, 12, 16, 11,
    15, 16, 16, 17, 14, 17, 17, 20, 20, 20, 19, 18, 18, 23, 24, 24, 23, 21, 20,
    21, 30, 27, 25, 24, 22, 22, 17, 17, 17, 17, 18, 16, 11, 19, 18, 18, 18, 18,
    18, 11, 19, 20, 21, 21, 22, 20, 16, 19, 23, 25, 25, 25, 24, 20, 21, 30, 30,
    29, 29, 26, 22, 25, 34, 35, 34, 31, 29, 24, 30, 36, 39, 35, 34, 31, 26, 26,
    28, 27, 27, 23, 19, 15, 26, 31, 29, 28, 25, 21, 17, 26, 32, 32, 31, 28, 24,
    20, 26, 34, 37, 35, 31, 28, 23, 30, 36, 41, 40, 36, 30, 26, 33, 41, 46, 45,
    38, 32, 27, 37, 42, 48, 48, 41, 35, 28, 35, 41, 39, 32, 26, 22, 18, 35, 41,
    42, 34, 29, 24, 20, 36, 42, 45, 37, 33, 27, 23, 36, 42, 49, 41, 37, 31, 27,
    38, 45, 50, 47, 42, 35, 29, 41, 48, 53, 52, 44, 37, 31, 44, 50, 53, 54, 46,
    40, 32, 2,  2,  1,  2,  2,  1,  2,  2,  2,  1,  2,  2,  1,  3,  3,  2,  1,
    2,  3,  3,  4,  3,  3,  3,  3,  4,  5,  5,  6,  6,  7,  6,  7,  6,  5,  10,
    10, 10, 9,  8,  6,  5,  17, 15, 12, 10, 8,  6,  5,  3,  2,  2,  1,  1,  3,
    5,  3,  2,  2,  0,  1,  3,  6,  3,  2,  2,  2,  2,  4,  7,  6,  4,  4,  5,
    5,  5,  8,  10, 7,  8,  8,  9,  6,  8,  14, 12, 12, 11, 10, 9,  8,  20, 17,
    14, 12, 12, 11, 8,  3,  2,  4,  5,  5,  6,  8,  7,  3,  4,  6,  6,  6,  9,
    10, 3,  5,  8,  9,  7,  10, 14, 5,  9,  12, 12, 12, 12, 16, 9,  12, 15, 16,
    15, 12, 20, 15, 16, 19, 18, 17, 12, 23, 21, 20, 21, 19, 18, 16, 10, 7,  11,
    12, 12, 9,  13, 14, 8,  12, 13, 14, 13, 13, 17, 10, 13, 16, 16, 17, 15, 19,
    13, 17, 20, 20, 20, 17, 20, 18, 22, 24, 24, 23, 20, 20, 24, 26, 28, 26, 25,
    23, 23, 30, 30, 29, 27, 26, 25, 19, 19, 20, 20, 20, 19, 13, 23, 20, 21, 22,
    22, 21, 13, 22, 22, 23, 25, 26, 24, 19, 22, 26, 28, 28, 29, 28, 24, 24, 32,
    33, 33, 33, 31, 25, 27, 37, 39, 38, 35, 32, 27, 31, 40, 42, 39, 39, 35, 29,
    28, 31, 30, 29, 27, 22, 17, 29, 33, 32, 31, 28, 24, 20, 28, 35, 34, 35, 32,
    27, 23, 28, 37, 40, 39, 36, 31, 27, 32, 41, 46, 44, 41, 34, 29, 36, 43, 50,
    49, 42, 37, 32, 40, 47, 51, 51, 45, 38, 32, 38, 44, 41, 35, 28, 25, 20, 38,
    44, 44, 37, 32, 28, 24, 39, 44, 47, 41, 36, 31, 27, 38, 45, 52, 46, 40, 36,
    31, 41, 48, 55, 52, 44, 39, 34, 45, 51, 57, 56, 47, 40, 35, 48, 53, 56, 58,
    51, 43, 37, 2,  1,  1,  3,  3,  1,  2,  2,  1,  1,  2,  3,  2,  3,  2,  2,
    1,  3,  4,  4,  4,  2,  3,  3,  4,  6,  6,  6,  5,  6,  7,  7,  9,  8,  6,
    11, 11, 11, 10, 10, 8,  6,  17, 15, 12, 10, 9,  8,  6,  2,  2,  1,  1,  1,
    3,  4,  2,  2,  1,  1,  0,  3,  5,  4,  2,  1,  2,  2,  4,  6,  8,  3,  4,
    5,  5,  5,  7,  10, 7,  8,  9,  9,  6,  7,  14, 12, 12, 12, 11, 9,  7,  21,
    17, 14, 12, 12, 11, 7,  4,  2,  4,  5,  5,  6,  8,  9,  2,  4,  6,  6,  5,
    8,  13, 2,  5,  8,  9,  6,  10, 15, 5,  8,  12, 12, 12, 12, 17, 10, 12, 16,
    17, 16, 12, 21, 15, 17, 19, 19, 17, 12, 24, 21, 19, 20, 19, 18, 16, 13, 7,
    11, 12, 11, 9,  12, 16, 8,  11, 12, 14, 13, 13, 19, 11, 12, 15, 17, 17, 14,
    21, 14, 17, 20, 20, 20, 16, 20, 19, 22, 23, 25, 24, 19, 22, 25, 27, 27, 27,
    25, 24, 23, 31, 30, 30, 28, 27, 26, 21, 17, 19, 20, 20, 19, 12, 24, 19, 21,
    21, 22, 21, 13, 24, 21, 23, 24, 25, 24, 18, 24, 26, 27, 28, 30, 28, 24, 25,
    32, 32, 34, 33, 32, 25, 27, 34, 39, 38, 36, 33, 27, 32, 39, 43, 39, 38, 36,
    29, 28, 29, 29, 29, 26, 22, 16, 28, 33, 31, 31, 27, 24, 20, 28, 36, 35, 33,
    31, 27, 24, 28, 37, 39, 38, 35, 31, 27, 32, 39, 45, 44, 40, 34, 30, 35, 43,
    51, 47, 41, 36, 31, 39, 48, 52, 52, 45, 38, 33, 38, 43, 40, 34, 29, 24, 21,
    38, 43, 43, 37, 32, 27, 24, 37, 43, 46, 40, 36, 32, 27, 37, 44, 50, 44, 40,
    34, 31, 41, 48, 53, 51, 43, 39, 33, 45, 51, 55, 56, 48, 40, 34, 47, 53, 55,
    57, 51, 41, 37, 1,  1,  4,  6,  5,  4,  2,  1,  1,  3,  5,  5,  3,  2,  2,
    1,  2,  4,  6,  5,  4,  2,  2,  3,  5,  7,  6,  6,  5,  5,  6,  8,  10, 8,
    6,  10, 9,  9,  10, 10, 8,  6,  15, 14, 11, 10, 10, 8,  6,  2,  1,  2,  4,
    3,  1,  3,  2,  1,  1,  3,  3,  0,  3,  2,  2,  1,  3,  3,  2,  4,  4,  3,
    4,  5,  5,  4,  5,  7,  6,  7,  8,  7,  6,  5,  12, 11, 11, 10, 8,  6,  5,
    19, 16, 12, 10, 9,  8,  5,  2,  1,  3,  2,  3,  4,  6,  4,  2,  3,  3,  4,
    3,  5,  8,  2,  4,  6,  6,  4,  6,  13, 3,  7,  9,  9,  9,  8,  14, 8,  11,
    13, 13, 12, 8,  18, 14, 15, 16, 15, 13, 8,  21, 19, 18, 18, 16, 15, 13, 9,
    6,  9,  9,  9,  7,  10, 13, 7,  9,  10, 10, 10, 9,  16, 8,  11, 13, 13, 13,
    11, 18, 11, 15, 16, 17, 17, 13, 18, 17, 19, 20, 21, 19, 16, 18, 23, 25, 23,
    23, 21, 19, 21, 28, 27, 26, 24, 23, 22, 18, 16, 17, 16, 17, 17, 10, 21, 18,
    18, 18, 19, 17, 9,  21, 19, 20, 22, 21, 20, 15, 21, 23, 24, 25, 25, 24, 20,
    22, 29, 30, 30, 30, 27, 22, 25, 33, 35, 34, 32, 29, 24, 29, 37, 38, 35, 34,
    31, 26, 26, 28, 27, 26, 22, 19, 14, 26, 30, 28, 27, 25, 21, 17, 25, 32, 31,
    30, 28, 24, 20, 26, 34, 36, 35, 32, 28, 24, 28, 36, 41, 40, 36, 31, 26, 33,
    41, 47, 43, 38, 31, 27, 37, 41, 47, 47, 40, 34, 29, 35, 40, 37, 30, 26, 22,
    18, 34, 40, 40, 33, 27, 24, 20, 35, 40, 43, 36, 31, 27, 24, 34, 42, 46, 41,
    36, 32, 28, 37, 43, 48, 46, 40, 35, 30, 41, 46, 52, 51, 42, 36, 31, 44, 49,
    53, 52, 45, 39, 32, 1,  5,  6,  8,  8,  6,  4,  0,  3,  6,  8,  8,  5,  3,
    1,  2,  5,  6,  8,  6,  5,  1,  3,  5,  7,  9,  7,  6,  4,  5,  7,  8,  10,
    9,  6,  8,  8,  10, 11, 11, 9,  7,  14, 12, 11, 11, 10, 8,  7,  1,  2,  5,
    7,  5,  4,  2,  1,  1,  4,  6,  5,  3,  0,  2,  1,  3,  5,  4,  3,  2,  2,
    2,  4,  5,  5,  4,  4,  5,  6,  7,  8,  7,  6,  4,  11, 10, 10, 10, 8,  6,
    4,  17, 14, 12, 10, 8,  6,  4,  1,  1,  1,  2,  3,  3,  5,  2,  1,  0,  1,
    2,  2,  3,  3,  1,  2,  2,  2,  2,  4,  7,  2,  5,  5,  5,  5,  5,  11, 7,
    9,  9,  9,  8,  5,  15, 12, 13, 12, 11, 9,  5,  19, 17, 15, 14, 12, 10, 9,
    3,  5,  6,  6,  7,  6,  8,  8,  6,  7,  7,  8,  8,  7,  11, 7,  8,  9,  9,
    9,  8,  14, 9,  13, 13, 13, 13, 10, 15, 14, 17, 16, 17, 16, 13, 15, 20, 21,
    20, 19, 17, 16, 20, 26, 24, 22, 21, 19, 18, 14, 14, 14, 14, 15, 14, 8,  17,
    16, 15, 15, 16, 14, 7,  17, 17, 18, 18, 18, 17, 12, 16, 21, 22, 21, 22, 20,
    16, 19, 27, 27, 26, 26, 24, 18, 22, 30, 31, 30, 27, 25, 21, 27, 33, 35, 32,
    30, 27, 22, 24, 25, 24, 23, 20, 17, 12, 24, 27, 25, 24, 21, 17, 12, 23, 29,
    27, 27, 24, 20, 16, 24, 31, 31, 30, 27, 24, 20, 26, 33, 37, 35, 32, 27, 21,
    30, 36, 43, 39, 33, 29, 24, 33, 39, 43, 41, 36, 29, 25, 31, 35, 33, 27, 23,
    19, 15, 32, 36, 35, 28, 24, 20, 16, 32, 37, 38, 32, 27, 24, 20, 30, 37, 41,
    36, 31, 27, 23, 34, 39, 44, 41, 36, 30, 25, 37, 41, 47, 46, 39, 32, 28, 39,
    45, 48, 47, 41, 34, 29, 2,  2,  4,  8,  8,  6,  2,  2,  2,  3,  7,  8,  4,
    2,  2,  2,  3,  4,  5,  3,  2,  1,  2,  2,  2,  3,  2,  2,  2,  2,  3,  3,
    3,  3,  3,  6,  6,  6,  6,  4,  3,  2,  12, 10, 8,  6,  4,  3,  3,  2,  2,
    3,  5,  5,  2,  2,  1,  2,  3,  4,  4,  2,  2,  0,  2,  2,  2,  2,  2,  1,
    1,  1,  1,  2,  1,  1,  3,  3,  3,  4,  4,  3,  3,  3,  8,  7,  8,  7,  4,
    3,  3,  15, 13, 10, 7,  5,  3,  3,  0,  2,  2,  2,  2,  2,  1,  2,  2,  2,
    2,  2,  2,  1,  2,  1,  1,  1,  1,  1,  2,  2,  1,  1,  1,  1,  1,  4,  5,
    5,  4,  4,  5,  3,  4,  11, 10, 9,  8,  6,  4,  4,  17, 16, 12, 9,  7,  6,
    5,  2,  2,  2,  3,  3,  3,  7,  2,  3,  3,  4,  4,  4,  7,  4,  4,  4,  5,
    5,  5,  7,  7,  7,  7,  7,  8,  8,  8,  7,  11, 11, 11, 12, 11, 10, 11, 17,
    16, 15, 14, 12, 12, 18, 22, 19, 17, 16, 14, 13, 10, 10, 10, 10, 11, 10, 7,
    12, 12, 12, 11, 12, 11, 7,  12, 14, 13, 13, 13, 12, 8,  12, 17, 16, 17, 16,
    15, 12, 15, 21, 20, 20, 20, 19, 13, 18, 24, 26, 24, 24, 21, 15, 22, 28, 29,
    26, 25, 23, 17, 19, 21, 20, 20, 16, 12, 8,  19, 23, 22, 22, 18, 13, 9,  20,
    25, 24, 24, 20, 15, 11, 19, 25, 27, 27, 23, 19, 15, 21, 28, 31, 31, 28, 22,
    17, 25, 30, 36, 35, 30, 24, 18, 27, 33, 38, 36, 31, 27, 21, 27, 32, 31, 25,
    20, 16, 11, 27, 33, 34, 27, 22, 16, 12, 27, 32, 36, 29, 24, 19, 15, 27, 33,
    38, 32, 27, 23, 19, 28, 35, 40, 36, 32, 26, 21, 31, 36, 41, 40, 33, 28, 22,
    34, 37, 42, 41, 35, 31, 24, 1,  2,  3,  3,  3,  2,  2,  0,  2,  2,  3,  3,
    2,  1,  1,  2,  2,  2,  2,  2,  1,  2,  1,  1,  2,  2,  2,  4,  4,  3,  4,
    4,  4,  4,  4,  7,  7,  7,  7,  5,  4,  4,  13, 11, 9,  7,  6,  4,  4,  1,
    2,  2,  3,  2,  2,  1,  2,  1,  2,  2,  2,  1,  1,  2,  0,  2,  2,  2,  1,
    1,  2,  2,  2,  2,  2,  2,  4,  5,  4,  4,  5,  4,  4,  3,  9,  9,  8,  8,
    5,  4,  4,  17, 14, 10, 8,  6,  4,  3,  2,  0,  1,  1,  2,  2,  5,  2,  2,
    1,  1,  1,  2,  5,  2,  2,  1,  1,  1,  1,  6,  4,  2,  4,  4,  4,  4,  7,
    8,  6,  7,  8,  8,  7,  7,  13, 11, 12, 11, 9,  8,  7,  19, 17, 15, 13, 11,
    10, 9,  2,  5,  5,  6,  6,  5,  8,  5,  6,  6,  7,  7,  7,  9,  8,  7,  7,
    8,  8,  8,  9,  11, 9,  11, 11, 11, 11, 11, 11, 14, 15, 15, 15, 14, 13, 13,
    20, 20, 19, 18, 16, 15, 19, 26, 23, 20, 19, 17, 17, 12, 13, 13, 13, 14, 12,
    8,  14, 15, 15, 15, 15, 13, 8,  14, 17, 16, 16, 16, 15, 12, 14, 21, 20, 19,
    20, 19, 15, 18, 26, 24, 24, 25, 22, 17, 21, 29, 30, 29, 26, 23, 19, 26, 31,
    33, 30, 29, 26, 20, 22, 24, 22, 22, 19, 15, 11, 23, 26, 24, 23, 21, 16, 12,
    22, 28, 27, 26, 22, 19, 15, 22, 28, 31, 30, 26, 22, 19, 26, 32, 35, 35, 31,
    26, 21, 28, 34, 40, 39, 32, 28, 23, 32, 37, 42, 41, 36, 29, 25, 30, 36, 35,
    28, 22, 18, 14, 30, 36, 37, 29, 23, 19, 15, 30, 36, 39, 32, 27, 22, 19, 31,
    38, 42, 36, 31, 26, 23, 32, 39, 44, 42, 34, 30, 24, 34, 40, 47, 45, 38, 32,
    27, 37, 42, 48, 48, 41, 34, 27, 1,  1,  2,  2,  2,  2,  1,  2,  1,  2,  2,
    2,  1,  1,  2,  1,  1,  2,  2,  1,  2,  2,  2,  2,  2,  2,  3,  4,  4,  5,
    4,  5,  5,  4,  4,  9,  8,  8,  7,  6,  4,  4,  15, 13, 10, 8,  6,  4,  4,
    2,  1,  1,  2,  1,  1,  3,  2,  1,  1,  2,  1,  1,  3,  2,  2,  0,  1,  2,
    1,  5,  2,  3,  2,  3,  3,  3,  5,  6,  6,  6,  6,  5,  4,  5,  11, 10, 10,
    9,  6,  5,  5,  18, 15, 12, 9,  8,  6,  5,  2,  2,  2,  2,  2,  5,  7,  2,
    2,  3,  3,  3,  5,  7,  5,  2,  4,  4,  5,  5,  8,  8,  3,  7,  7,  8,  8,
    9,  12, 7,  10, 11, 11, 10, 9,  15, 13, 15, 15, 13, 12, 9,  21, 19, 17, 16,
    15, 13, 12, 5,  7,  8,  9,  9,  8,  11, 9,  7,  9,  10, 10, 10, 11, 11, 8,
    11, 11, 12, 12, 12, 14, 10, 15, 15, 15, 15, 13, 15, 16, 18, 19, 19, 18, 17,
    16, 22, 23, 22, 21, 20, 19, 21, 28, 27, 25, 23, 22, 21, 15, 16, 16, 16, 17,
    16, 11, 17, 18, 18, 18, 18, 17, 11, 17, 19, 20, 21, 21, 19, 15, 17, 23, 24,
    23, 24, 22, 19, 20, 29, 28, 28, 28, 25, 21, 24, 33, 34, 33, 31, 27, 23, 29,
    35, 37, 33, 32, 30, 24, 26, 27, 26, 26, 23, 18, 14, 25, 30, 28, 27, 24, 20,
    15, 26, 31, 31, 31, 26, 23, 19, 25, 33, 34, 35, 31, 26, 22, 28, 35, 40, 38,
    36, 29, 24, 32, 39, 45, 43, 37, 32, 26, 36, 41, 46, 46, 40, 34, 28, 34, 41,
    38, 32, 26, 22, 17, 34, 41, 41, 34, 27, 22, 19, 34, 40, 43, 37, 31, 26, 22,
    34, 41, 47, 41, 35, 30, 26, 36, 43, 49, 44, 40, 33, 28, 39, 45, 52, 51, 43,
    35, 30, 42, 48, 52, 51, 45, 38, 32, 2,  1,  2,  4,  3,  3,  3,  2,  1,  2,
    3,  3,  2,  1,  2,  2,  1,  2,  2,  1,  3,  2,  2,  2,  2,  3,  3,  4,  5,
    5,  5,  5,  5,  4,  4,  9,  9,  8,  8,  6,  4,  4,  15, 13, 10, 8,  7,  4,
    4,  2,  2,  1,  3,  3,  4,  6,  2,  2,  1,  2,  2,  3,  5,  2,  2,  1,  0,
    0,  3,  6,  4,  3,  3,  3,  3,  4,  7,  8,  6,  6,  7,  6,  4,  7,  12, 10,
    10, 9,  8,  7,  7,  19, 16, 12, 10, 10, 9,  7,  2,  2,  4,  5,  6,  7,  9,
    4,  2,  4,  6,  6,  6,  8,  7,  2,  4,  6,  7,  6,  9,  11, 3,  7,  10, 10,
    10, 10, 14, 8,  11, 14, 14, 13, 10, 18, 13, 15, 17, 15, 15, 10, 21, 18, 18,
    18, 17, 16, 14, 7,  7,  10, 11, 12, 10, 14, 11, 8,  11, 12, 13, 13, 13, 14,
    8,  12, 13, 14, 14, 13, 17, 12, 16, 17, 18, 18, 15, 17, 17, 20, 21, 22, 21,
    19, 18, 23, 26, 24, 23, 22, 21, 21, 29, 28, 27, 25, 23, 24, 17, 18, 19, 19,
    20, 20, 14, 20, 19, 21, 21, 21, 20, 13, 19, 20, 22, 23, 23, 22, 17, 20, 25,
    26, 27, 27, 26, 21, 22, 31, 30, 31, 32, 29, 23, 25, 35, 36, 35, 33, 30, 25,
    30, 37, 40, 37, 36, 32, 26, 27, 30, 29, 29, 26, 22, 18, 27, 32, 31, 30, 27,
    23, 18, 28, 34, 34, 33, 30, 25, 21, 27, 36, 39, 38, 33, 29, 25, 30, 39, 42,
    41, 37, 32, 27, 34, 41, 47, 46, 40, 34, 29, 38, 42, 49, 50, 43, 35, 30, 36,
    44, 41, 34, 29, 25, 20, 38, 43, 43, 36, 30, 26, 21, 38, 44, 47, 40, 34, 29,
    25, 37, 44, 50, 44, 38, 33, 29, 39, 45, 52, 50, 42, 36, 30, 42, 49, 54, 54,
    46, 37, 33, 47, 51, 56, 55, 49, 41, 34, 2,  1,  3,  6,  6,  4,  3,  2,  1,
    2,  5,  6,  3,  1,  2,  2,  1,  3,  4,  2,  2,  2,  2,  2,  3,  4,  4,  4,
    4,  5,  5,  5,  7,  5,  4,  9,  8,  8,  8,  7,  5,  4,  14, 12, 10, 7,  8,
    5,  4,  2,  2,  1,  3,  3,  4,  5,  2,  2,  1,  2,  2,  3,  4,  2,  2,  1,
    0,  0,  2,  4,  4,  3,  3,  3,  3,  3,  5,  8,  6,  6,  6,  6,  3,  5,  12,
    10, 10, 9,  8,  7,  5,  18, 15, 11, 9,  9,  8,  5,  2,  2,  4,  5,  5,  6,
    8,  5,  2,  3,  6,  6,  6,  7,  8,  2,  4,  6,  7,  4,  7,  12, 3,  7,  10,
    10, 9,  9,  15, 8,  10, 13, 14, 13, 9,  18, 12, 14, 17, 16, 14, 9,  21, 18,
    16, 18, 17, 16, 14, 9,  6,  10, 11, 12, 10, 13, 12, 7,  10, 12, 13, 12, 12,
    15, 8,  12, 13, 14, 14, 12, 16, 11, 15, 17, 17, 17, 14, 18, 16, 19, 21, 22,
    21, 17, 18, 22, 24, 24, 24, 22, 21, 20, 27, 27, 26, 25, 24, 23, 17, 17, 19,
    19, 20, 19, 13, 20, 19, 20, 20, 21, 20, 12, 20, 20, 22, 23, 23, 22, 16, 20,
    23, 26, 26, 27, 25, 21, 22, 29, 31, 31, 30, 28, 23, 25, 34, 37, 35, 33, 29,
    25, 29, 37, 40, 37, 35, 32, 26, 27, 30, 29, 29, 26, 22, 17, 26, 32, 31, 30,
    27, 22, 18, 26, 34, 34, 33, 29, 25, 21, 27, 35, 39, 37, 33, 29, 25, 30, 39,
    44, 41, 37, 32, 26, 34, 41, 48, 46, 39, 33, 29, 37, 44, 48, 48, 43, 36, 30,
    37, 42, 40, 33, 29, 25, 21, 37, 42, 42, 36, 29, 25, 21, 37, 42, 45, 38, 34,
    29, 24, 37, 44, 49, 43, 36, 33, 28, 38, 46, 50, 48, 42, 35, 30, 42, 49, 53,
    52, 45, 38, 32, 45, 49, 55, 55, 47, 40, 34, 1,  3,  5,  7,  7,  5,  3,  1,
    1,  4,  6,  6,  4,  2,  2,  1,  3,  5,  5,  3,  2,  2,  1,  2,  4,  6,  5,
    4,  4,  4,  4,  6,  8,  6,  4,  8,  7,  7,  8,  8,  6,  4,  13, 11, 9,  8,
    8,  6,  4,  1,  1,  3,  5,  4,  3,  4,  1,  1,  2,  4,  4,  2,  3,  2,  1,
    1,  3,  2,  0,  3,  2,  2,  2,  3,  3,  2,  4,  6,  5,  5,  6,  5,  4,  4,
    11, 9,  9,  8,  6,  4,  3,  16, 13, 10, 8,  7,  6,  3,  2,  1,  3,  4,  4,
    6,  7,  2,  2,  4,  4,  5,  5,  6,  5,  2,  3,  4,  4,  3,  5,  10, 3,  6,
    7,  7,  7,  7,  13, 7,  9,  11, 11, 10, 7,  16, 12, 13, 14, 12, 12, 7,  19,
    17, 15, 15, 14, 13, 12, 5,  6,  9,  10, 11, 9,  11, 11, 7,  9,  11, 11, 11,
    10, 14, 7,  11, 11, 11, 11, 10, 16, 10, 14, 14, 15, 15, 11, 17, 15, 18, 19,
    19, 18, 14, 16, 20, 22, 22, 20, 20, 18, 18, 25, 25, 24, 23, 21, 20, 15, 16,
    17, 18, 18, 17, 11, 19, 17, 19, 19, 20, 18, 10, 19, 19, 20, 20, 20, 18, 14,
    19, 22, 23, 23, 24, 22, 18, 21, 28, 28, 28, 28, 25, 20, 23, 31, 34, 32, 30,
    27, 23, 26, 34, 36, 35, 32, 29, 24, 26, 28, 27, 27, 24, 19, 16, 25, 30, 28,
    28, 25, 21, 16, 25, 32, 30, 29, 25, 22, 18, 25, 33, 34, 34, 30, 26, 22, 28,
    35, 40, 38, 34, 29, 23, 31, 40, 45, 41, 36, 30, 26, 35, 40, 44, 45, 39, 33,
    27, 36, 40, 37, 31, 25, 23, 19, 35, 40, 40, 33, 28, 23, 19, 35, 40, 42, 35,
    30, 26, 22, 34, 41, 45, 39, 32, 30, 26, 37, 43, 48, 44, 37, 33, 28, 38, 44,
    50, 49, 41, 35, 29, 42, 47, 49, 50, 44, 37, 31, 3,  5,  7,  9,  9,  7,  5,
    2,  5,  7,  8,  9,  6,  4,  1,  4,  6,  7,  8,  5,  3,  1,  1,  4,  6,  8,
    6,  5,  3,  3,  5,  6,  9,  7,  4,  7,  6,  7,  8,  8,  7,  4,  10, 9,  8,
    8,  8,  7,  5,  1,  4,  6,  8,  7,  5,  4,  1,  3,  5,  7,  6,  4,  2,  1,
    1,  5,  6,  4,  3,  0,  2,  1,  3,  4,  3,  3,  2,  4,  4,  4,  6,  5,  4,
    2,  9,  8,  7,  8,  6,  4,  2,  14, 11, 8,  8,  6,  4,  2,  1,  1,  3,  3,
    4,  5,  6,  2,  1,  3,  3,  3,  4,  5,  2,  1,  2,  2,  2,  2,  3,  4,  2,
    4,  4,  3,  3,  4,  9,  6,  7,  7,  7,  6,  4,  12, 10, 10, 9,  9,  8,  4,
    16, 13, 12, 11, 10, 9,  8,  2,  6,  7,  8,  8,  8,  9,  5,  6,  8,  8,  9,
    9,  8,  9,  6,  8,  9,  9,  9,  7,  12, 8,  11, 11, 10, 11, 8,  13, 13, 15,
    14, 15, 14, 12, 12, 17, 18, 17, 17, 15, 14, 16, 22, 21, 19, 19, 17, 16, 13,
    14, 15, 15, 16, 15, 9,  15, 15, 16, 17, 17, 16, 8,  15, 17, 18, 17, 17, 15,
    12, 15, 20, 20, 20, 20, 18, 15, 17, 25, 24, 25, 24, 21, 16, 20, 27, 29, 27,
    26, 23, 18, 23, 29, 32, 29, 28, 25, 20, 23, 25, 24, 23, 21, 17, 14, 24, 27,
    26, 25, 23, 18, 13, 23, 29, 28, 26, 22, 18, 14, 23, 30, 31, 29, 26, 22, 18,
    26, 32, 36, 33, 29, 25, 20, 29, 35, 39, 37, 32, 26, 21, 31, 36, 40, 39, 33,
    28, 23, 31, 37, 34, 28, 23, 20, 17, 32, 36, 35, 29, 25, 20, 16, 32, 37, 39,
    31, 25, 22, 17, 32, 36, 40, 35, 29, 26, 21, 33, 38, 43, 39, 33, 28, 23, 36,
    40, 43, 44, 36, 30, 25, 38, 42, 45, 45, 39, 32, 26, 2,  3,  7,  11, 11, 10,
    6,  2,  2,  6,  10, 11, 9,  3,  2,  2,  4,  7,  9,  6,  2,  2,  2,  2,  4,
    6,  4,  2,  2,  2,  2,  3,  5,  4,  2,  6,  6,  6,  5,  4,  4,  2,  11, 11,
    8,  6,  4,  4,  2,  2,  2,  4,  8,  9,  5,  2,  1,  2,  3,  6,  8,  3,  2,
    1,  2,  2,  4,  4,  2,  2,  0,  2,  2,  2,  2,  1,  2,  3,  3,  3,  3,  3,
    2,  2,  8,  7,  8,  7,  4,  3,  2,  15, 13, 10, 7,  5,  3,  2,  1,  2,  2,
    2,  2,  2,  2,  0,  2,  2,  2,  2,  2,  1,  1,  2,  2,  2,  1,  2,  0,  2,
    1,  1,  1,  1,  1,  2,  5,  4,  4,  4,  4,  3,  2,  11, 10, 9,  8,  6,  3,
    2,  17, 16, 12, 9,  6,  5,  3,  1,  1,  1,  1,  1,  2,  6,  1,  2,  3,  3,
    3,  3,  6,  3,  3,  3,  4,  4,  4,  6,  6,  6,  6,  6,  7,  7,  8,  6,  10,
    10, 10, 10, 10, 9,  11, 15, 15, 14, 12, 11, 10, 17, 21, 18, 16, 15, 13, 12,
    9,  9,  9,  10, 10, 9,  6,  11, 11, 11, 11, 11, 10, 6,  11, 12, 12, 12, 13,
    11, 7,  11, 16, 15, 15, 15, 14, 10, 14, 20, 19, 19, 20, 18, 12, 17, 23, 25,
    23, 22, 20, 14, 21, 27, 28, 26, 24, 22, 16, 18, 19, 19, 20, 16, 12, 7,  18,
    22, 21, 21, 18, 13, 9,  18, 23, 23, 23, 19, 15, 10, 18, 24, 27, 25, 22, 18,
    14, 20, 27, 30, 27, 26, 21, 16, 23, 28, 34, 31, 28, 24, 18, 27, 31, 35, 34,
    30, 25, 20, 26, 32, 29, 24, 20, 15, 10, 26, 31, 32, 26, 21, 16, 11, 26, 32,
    33, 28, 23, 18, 14, 25, 31, 36, 29, 26, 22, 18, 26, 31, 37, 34, 29, 25, 20,
    30, 34, 38, 36, 30, 26, 22, 31, 36, 37, 37, 32, 29, 24, 2,  3,  4,  4,  4,
    4,  3,  2,  3,  4,  4,  4,  3,  3,  1,  2,  3,  4,  4,  3,  1,  1,  1,  2,
    2,  2,  2,  2,  2,  2,  2,  2,  3,  2,  2,  6,  6,  6,  5,  3,  2,  2,  11,
    10, 7,  6,  4,  2,  2,  1,  3,  3,  4,  3,  3,  3,  1,  2,  3,  4,  3,  3,
    2,  1,  2,  3,  3,  3,  2,  1,  2,  0,  1,  2,  2,  1,  2,  3,  3,  3,  3,
    3,  2,  2,  8,  7,  7,  6,  4,  2,  2,  15, 12, 9,  7,  5,  3,  2,  1,  2,
    2,  3,  3,  3,  5,  2,  1,  2,  3,  3,  3,  5,  2,  1,  2,  2,  2,  2,  4,
    2,  1,  2,  2,  2,  2,  5,  6,  5,  5,  5,  5,  5,  5,  11, 10, 10, 9,  7,
    6,  5,  17, 15, 12, 10, 9,  7,  6,  2,  4,  5,  5,  6,  6,  9,  2,  5,  6,
    7,  7,  7,  8,  6,  6,  7,  7,  7,  8,  9,  9,  8,  9,  9,  9,  9,  9,  9,
    13, 13, 13, 13, 13, 11, 11, 18, 17, 16, 15, 14, 13, 17, 25, 20, 19, 17, 15,
    14, 12, 12, 13, 13, 14, 12, 9,  13, 14, 14, 14, 15, 13, 9,  13, 15, 16, 16,
    16, 14, 10, 13, 18, 18, 18, 18, 17, 13, 16, 23, 22, 22, 22, 20, 15, 20, 26,
    27, 26, 24, 22, 16, 24, 29, 31, 27, 26, 24, 17, 22, 23, 22, 22, 20, 15, 11,
    21, 25, 24, 24, 21, 16, 12, 21, 27, 26, 26, 21, 17, 13, 22, 27, 29, 27, 24,
    20, 16, 23, 29, 34, 32, 28, 23, 18, 26, 32, 39, 37, 32, 26, 20, 29, 35, 40,
    40, 34, 27, 22, 29, 36, 35, 28, 22, 18, 14, 29, 36, 38, 30, 24, 19, 15, 30,
    37, 39, 31, 25, 20, 17, 30, 34, 41, 34, 29, 24, 20, 29, 37, 42, 39, 34, 28,
    22, 32, 38, 44, 43, 37, 30, 24, 35, 41, 45, 46, 39, 32, 25, 2,  3,  4,  5,
    5,  5,  4,  2,  3,  4,  5,  5,  4,  3,  2,  2,  3,  4,  4,  2,  1,  2,  1,
    2,  2,  2,  1,  2,  3,  2,  2,  3,  3,  2,  2,  6,  6,  6,  5,  3,  2,  2,
    12, 10, 7,  5,  4,  2,  2,  2,  2,  3,  4,  4,  4,  5,  2,  2,  3,  4,  4,
    3,  4,  2,  2,  2,  3,  3,  2,  2,  2,  2,  0,  1,  2,  1,  3,  4,  3,  3,
    3,  3,  2,  4,  9,  8,  7,  6,  4,  2,  4,  16, 13, 9,  7,  5,  3,  3,  2,
    2,  3,  4,  5,  6,  8,  2,  2,  3,  4,  5,  5,  8,  2,  2,  3,  4,  4,  4,
    6,  5,  2,  4,  5,  5,  5,  7,  9,  5,  8,  8,  8,  7,  7,  12, 10, 12, 11,
    10, 9,  7,  17, 16, 15, 13, 11, 10, 9,  2,  6,  8,  9,  10, 9,  11, 5,  7,
    9,  10, 11, 11, 12, 9,  8,  10, 10, 10, 11, 11, 12, 9,  12, 12, 12, 13, 11,
    12, 14, 15, 15, 16, 16, 14, 13, 20, 21, 20, 18, 17, 16, 18, 26, 24, 22, 19,
    18, 17, 13, 15, 16, 17, 18, 17, 11, 15, 17, 17, 18, 19, 17, 11, 15, 18, 19,
    18, 19, 18, 13, 15, 22, 21, 20, 21, 20, 16, 17, 26, 26, 25, 25, 23, 17, 22,
    30, 31, 30, 27, 24, 19, 26, 33, 34, 32, 29, 26, 21, 25, 27, 26, 26, 23, 20,
    15, 24, 29, 28, 27, 24, 20, 16, 25, 31, 30, 30, 25, 20, 16, 24, 31, 32, 32,
    28, 23, 19, 26, 32, 36, 36, 32, 26, 21, 29, 35, 42, 41, 35, 28, 23, 33, 38,
    42, 42, 37, 30, 25, 33, 40, 37, 32, 27, 22, 18, 32, 39, 40, 33, 27, 22, 18,
    34, 40, 43, 35, 28, 23, 19, 33, 38, 44, 38, 32, 28, 23, 34, 40, 45, 43, 36,
    31, 25, 36, 43, 48, 47, 40, 33, 26, 38, 44, 49, 49, 42, 35, 28, 2,  3,  5,
    6,  6,  6,  4,  2,  3,  4,  6,  6,  4,  3,  2,  2,  3,  4,  4,  2,  1,  2,
    2,  1,  2,  2,  1,  2,  3,  2,  2,  3,  3,  2,  2,  7,  6,  6,  5,  4,  2,
    2,  12, 10, 8,  5,  4,  2,  2,  2,  3,  3,  5,  5,  6,  7,  2,  2,  3,  5,
    5,  4,  5,  2,  2,  3,  3,  3,  3,  4,  2,  2,  2,  0,  0,  2,  5,  5,  4,
    3,  4,  3,  3,  4,  9,  8,  7,  7,  5,  4,  5,  15, 13, 9,  8,  7,  5,  5,
    2,  2,  5,  6,  7,  8,  10, 2,  2,  5,  6,  7,  7,  9,  4,  2,  5,  6,  6,
    6,  8,  8,  2,  5,  7,  7,  7,  8,  11, 6,  8,  10, 11, 10, 8,  15, 11, 12,
    13, 12, 11, 8,  17, 15, 15, 16, 14, 13, 11, 4,  7,  11, 11, 12, 11, 14, 8,
    7,  11, 12, 13, 13, 14, 11, 8,  12, 13, 13, 13, 13, 14, 10, 14, 14, 15, 14,
    13, 14, 14, 17, 18, 18, 18, 16, 15, 20, 22, 21, 20, 19, 18, 17, 26, 25, 24,
    22, 21, 20, 15, 17, 18, 19, 20, 19, 14, 17, 19, 20, 21, 21, 20, 14, 17, 20,
    21, 22, 22, 20, 16, 17, 23, 24, 24, 23, 23, 19, 19, 27, 28, 28, 28, 26, 20,
    22, 31, 33, 32, 30, 27, 22, 27, 34, 37, 34, 32, 29, 23, 27, 29, 29, 28, 26,
    22, 18, 27, 32, 30, 30, 27, 22, 18, 27, 33, 33, 32, 28, 23, 18, 27, 33, 35,
    34, 30, 25, 21, 28, 36, 40, 38, 35, 29, 24, 31, 38, 45, 43, 36, 30, 26, 34,
    40, 45, 46, 39, 34, 27, 37, 42, 41, 35, 29, 25, 20, 36, 42, 43, 37, 30, 25,
    21, 36, 43, 45, 38, 31, 26, 22, 37, 42, 48, 41, 35, 30, 25, 37, 43, 49, 46,
    39, 33, 28, 38, 46, 51, 50, 42, 35, 30, 41, 47, 52, 53, 45, 38, 32, 2,  3,
    6,  9,  9,  7,  5,  2,  3,  5,  8,  9,  6,  3,  2,  2,  3,  6,  7,  4,  1,
    2,  1,  1,  3,  5,  3,  2,  3,  2,  2,  3,  5,  3,  2,  6,  6,  6,  5,  5,
    4,  2,  11, 9,  7,  5,  5,  3,  2,  2,  2,  3,  7,  6,  6,  7,  2,  2,  3,
    5,  6,  5,  5,  2,  2,  3,  3,  3,  3,  4,  2,  2,  2,  0,  0,  1,  4,  5,
    3,  3,  3,  3,  2,  4,  9,  7,  7,  6,  5,  4,  4,  14, 11, 8,  7,  6,  5,
    4,  1,  2,  5,  6,  7,  8,  9,  2,  2,  5,  6,  7,  7,  8,  5,  2,  4,  6,
    6,  5,  7,  8,  2,  5,  7,  7,  7,  7,  12, 5,  8,  10, 11, 10, 7,  15, 11,
    11, 13, 12, 11, 7,  16, 14, 13, 14, 14, 13, 11, 5,  6,  10, 11, 12, 11, 13,
    9,  7,  11, 12, 13, 13, 12, 11, 7,  11, 12, 13, 13, 11, 14, 9,  13, 14, 14,
    14, 12, 15, 14, 17, 19, 19, 18, 15, 14, 18, 21, 22, 21, 19, 18, 16, 23, 23,
    22, 22, 21, 20, 15, 16, 18, 19, 20, 19, 14, 18, 18, 20, 21, 21, 20, 13, 18,
    19, 21, 22, 21, 19, 15, 17, 22, 24, 24, 23, 22, 18, 19, 26, 28, 27, 28, 25,
    20, 21, 30, 32, 31, 30, 27, 22, 24, 34, 36, 34, 32, 29, 23, 26, 29, 29, 29,
    26, 22, 17, 26, 31, 31, 30, 27, 22, 17, 26, 33, 33, 32, 27, 22, 18, 26, 33,
    35, 34, 30, 25, 21, 28, 35, 39, 38, 35, 29, 24, 31, 37, 44, 42, 37, 31, 25,
    34, 38, 44, 45, 39, 34, 27, 36, 42, 41, 33, 29, 25, 20, 37, 43, 43, 36, 30,
    25, 21, 36, 42, 45, 38, 31, 26, 22, 36, 42, 46, 41, 34, 29, 25, 37, 43, 48,
    45, 39, 33, 27, 38, 46, 51, 50, 42, 35, 29, 40, 47, 51, 51, 43, 36, 31, 3,
    4,  6,  8,  8,  6,  4,  3,  3,  5,  7,  7,  5,  3,  2,  3,  4,  6,  6,  4,
    2,  1,  1,  2,  4,  5,  3,  2,  2,  2,  2,  4,  6,  4,  2,  6,  5,  5,  5,
    6,  4,  2,  9,  7,  5,  5,  6,  4,  2,  2,  3,  4,  6,  5,  6,  6,  2,  3,
    4,  5,  5,  4,  4,  1,  2,  3,  4,  3,  2,  3,  1,  1,  1,  2,  1,  0,  3,
    4,  3,  3,  3,  3,  2,  3,  8,  6,  5,  5,  3,  2,  2,  11, 8,  6,  5,  5,
    4,  3,  1,  2,  5,  5,  6,  8,  9,  2,  2,  5,  6,  6,  6,  7,  3,  1,  5,
    5,  5,  5,  6,  8,  1,  4,  5,  5,  5,  5,  11, 5,  7,  9,  9,  8,  5,  12,
    9,  9,  11, 10, 9,  5,  13, 11, 10, 12, 11, 11, 10, 3,  6,  10, 11, 11, 11,
    12, 8,  7,  11, 12, 12, 12, 11, 11, 7,  11, 12, 12, 12, 10, 14, 8,  12, 13,
    13, 13, 10, 15, 13, 15, 17, 17, 16, 13, 12, 16, 18, 19, 18, 18, 16, 13, 19,
    21, 20, 19, 19, 18, 14, 16, 18, 19, 20, 19, 13, 17, 18, 19, 20, 20, 19, 12,
    17, 18, 21, 20, 20, 19, 15, 17, 21, 22, 22, 23, 21, 17, 19, 26, 26, 26, 25,
    24, 18, 20, 28, 30, 29, 27, 25, 20, 21, 29, 32, 30, 29, 27, 21, 25, 28, 28,
    28, 24, 21, 17, 26, 30, 29, 29, 26, 21, 17, 26, 32, 31, 29, 26, 21, 18, 25,
    32, 34, 31, 27, 24, 20, 28, 33, 38, 35, 31, 27, 22, 29, 35, 41, 39, 33, 28,
    24, 30, 36, 42, 40, 36, 31, 26, 35, 40, 39, 32, 27, 23, 19, 35, 40, 41, 34,
    29, 24, 20, 36, 41, 43, 35, 29, 25, 20, 36, 39, 43, 38, 33, 28, 23, 35, 42,
    45, 42, 36, 30, 26, 38, 43, 47, 45, 39, 32, 27, 38, 43, 47, 47, 41, 33, 29,
    4,  7,  8,  11, 10, 9,  6,  4,  6,  8,  10, 10, 7,  5,  3,  5,  7,  8,  9,
    6,  3,  3,  3,  5,  7,  8,  5,  3,  1,  0,  3,  5,  7,  5,  3,  2,  2,  4,
    5,  7,  5,  3,  4,  3,  3,  4,  6,  5,  3,  4,  5,  7,  9,  8,  6,  7,  3,
    4,  6,  8,  7,  5,  4,  2,  3,  5,  7,  5,  3,  2,  2,  2,  3,  5,  4,  3,
    0,  1,  1,  2,  4,  3,  2,  0,  4,  3,  3,  4,  2,  2,  0,  7,  4,  3,  3,
    3,  1,  0,  3,  4,  4,  5,  7,  8,  8,  2,  3,  5,  6,  6,  6,  6,  2,  3,
    5,  4,  4,  4,  5,  3,  2,  3,  3,  2,  3,  3,  6,  2,  4,  4,  4,  4,  3,
    7,  4,  5,  5,  5,  5,  3,  8,  6,  6,  7,  6,  6,  6,  2,  7,  8,  8,  9,
    10, 11, 3,  7,  9,  9,  10, 10, 9,  8,  7,  9,  9,  10, 10, 8,  11, 7,  10,
    10, 10, 10, 7,  10, 9,  11, 11, 12, 11, 11, 7,  11, 13, 13, 13, 13, 12, 8,
    14, 15, 15, 14, 14, 14, 12, 15, 15, 16, 17, 16, 11, 14, 16, 17, 18, 17, 15,
    9,  14, 18, 18, 18, 18, 16, 12, 14, 20, 19, 18, 18, 17, 13, 14, 21, 22, 21,
    20, 18, 14, 14, 22, 24, 23, 22, 20, 15, 16, 22, 27, 25, 23, 21, 17, 24, 27,
    24, 24, 22, 18, 14, 24, 28, 27, 26, 23, 18, 14, 24, 29, 29, 26, 22, 19, 15,
    24, 30, 30, 27, 24, 20, 15, 23, 30, 32, 30, 25, 21, 17, 24, 30, 36, 33, 27,
    23, 19, 25, 30, 35, 34, 30, 25, 20, 32, 37, 34, 29, 24, 20, 17, 33, 37, 37,
    30, 26, 21, 16, 32, 38, 39, 32, 26, 22, 17, 32, 37, 40, 33, 27, 23, 19, 31,
    37, 40, 36, 30, 24, 20, 31, 37, 41, 38, 32, 27, 21, 33, 36, 42, 40, 34, 28,
    23, 5,  7,  10, 14, 14, 11, 8,  5,  6,  9,  13, 14, 11, 8,  4,  6,  8,  11,
    13, 10, 6,  4,  4,  5,  8,  11, 8,  2,  2,  2,  2,  4,  6,  6,  2,  3,  3,
    3,  3,  5,  6,  2,  9,  8,  5,  3,  4,  6,  2,  4,  6,  8,  11, 11, 8,  6,
    4,  5,  7,  9,  10, 7,  5,  3,  5,  6,  8,  8,  6,  4,  3,  3,  4,  5,  5,
    4,  1,  0,  2,  2,  2,  2,  2,  1,  5,  5,  5,  4,  2,  2,  1,  12, 10, 7,
    5,  2,  2,  1,  4,  5,  5,  6,  7,  6,  5,  3,  4,  5,  5,  5,  5,  5,  2,
    4,  4,  4,  4,  4,  4,  2,  2,  2,  3,  3,  3,  1,  2,  2,  2,  2,  2,  1,
    1,  8,  7,  7,  5,  3,  1,  1,  14, 14, 9,  6,  4,  1,  1,  2,  4,  4,  5,
    5,  6,  6,  2,  3,  5,  5,  5,  5,  6,  2,  3,  4,  5,  5,  5,  6,  3,  4,
    4,  4,  5,  5,  6,  3,  7,  7,  7,  7,  7,  6,  8,  13, 12, 11, 9,  8,  8,
    14, 18, 15, 13, 11, 10, 9,  9,  9,  10, 10, 11, 9,  6,  10, 11, 11, 11, 12,
    10, 6,  10, 12, 12, 12, 13, 12, 7,  10, 14, 13, 13, 14, 12, 8,  11, 17, 17,
    16, 16, 15, 9,  14, 19, 21, 20, 19, 16, 11, 18, 22, 24, 21, 20, 19, 13, 17,
    20, 20, 20, 17, 12, 8,  18, 22, 21, 21, 18, 13, 9,  17, 23, 23, 22, 19, 15,
    10, 18, 22, 24, 23, 20, 16, 11, 17, 23, 26, 24, 22, 19, 13, 19, 25, 28, 27,
    23, 20, 15, 22, 26, 29, 27, 24, 21, 17, 25, 30, 28, 25, 20, 15, 11, 26, 30,
    31, 26, 22, 16, 12, 26, 31, 33, 27, 22, 18, 13, 26, 30, 33, 27, 23, 19, 15,
    24, 29, 32, 29, 24, 21, 17, 25, 28, 32, 31, 26, 22, 19, 27, 30, 32, 32, 28,
    23, 20, 5,  6,  7,  8,  8,  7,  7,  5,  6,  7,  8,  8,  7,  6,  4,  5,  6,
    7,  7,  5,  4,  3,  4,  5,  5,  5,  3,  2,  1,  2,  2,  2,  3,  2,  1,  3,
    3,  3,  2,  3,  2,  1,  9,  7,  5,  3,  2,  2,  2,  4,  5,  7,  7,  7,  7,
    7,  4,  5,  6,  7,  7,  6,  5,  3,  4,  6,  6,  6,  5,  4,  3,  3,  3,  4,
    3,  3,  1,  2,  0,  2,  2,  2,  1,  1,  5,  4,  4,  3,  1,  2,  1,  12, 9,
    6,  4,  2,  1,  1,  3,  5,  5,  6,  7,  7,  8,  3,  4,  5,  6,  6,  6,  7,
    2,  3,  4,  5,  5,  5,  5,  3,  2,  2,  2,  2,  2,  3,  3,  2,  2,  2,  2,
    2,  3,  8,  7,  6,  5,  4,  3,  3,  14, 12, 9,  7,  5,  4,  4,  3,  5,  6,
    7,  8,  9,  10, 2,  5,  6,  7,  8,  8,  9,  3,  6,  6,  6,  7,  7,  8,  6,
    6,  7,  7,  7,  8,  8,  6,  10, 9,  10, 10, 9,  9,  8,  15, 14, 13, 12, 10,
    10, 14, 21, 18, 15, 13, 12, 11, 11, 12, 12, 13, 14, 13, 10, 12, 14, 14, 14,
    15, 14, 9,  12, 15, 15, 15, 15, 14, 9,  13, 17, 16, 15, 16, 15, 11, 13, 20,
    19, 19, 19, 17, 12, 17, 22, 24, 23, 20, 18, 13, 21, 26, 28, 25, 23, 21, 15,
    21, 22, 21, 23, 20, 16, 11, 21, 24, 24, 24, 21, 16, 12, 21, 26, 27, 25, 22,
    17, 12, 21, 26, 27, 26, 22, 17, 13, 20, 26, 29, 29, 25, 20, 15, 22, 28, 35,
    34, 28, 22, 17, 25, 33, 36, 36, 31, 25, 18, 29, 36, 35, 28, 22, 19, 14, 29,
    35, 37, 29, 24, 19, 15, 30, 36, 39, 30, 25, 20, 15, 29, 35, 39, 32, 26, 21,
    17, 28, 34, 38, 36, 31, 24, 19, 29, 35, 41, 40, 32, 27, 21, 32, 37, 43, 41,
    35, 28, 23, 5,  7,  8,  9,  9,  9,  8,  5,  6,  7,  9,  9,  7,  6,  4,  5,
    7,  7,  7,  5,  4,  4,  4,  4,  5,  5,  3,  1,  2,  1,  2,  2,  2,  2,  1,
    3,  3,  3,  2,  2,  2,  1,  8,  7,  4,  2,  2,  2,  1,  4,  5,  7,  8,  8,
    8,  8,  4,  5,  7,  8,  8,  7,  7,  4,  5,  6,  6,  6,  5,  4,  3,  3,  3,
    4,  3,  3,  2,  2,  2,  0,  1,  1,  1,  2,  5,  4,  4,  3,  1,  1,  2,  12,
    9,  6,  3,  2,  1,  2,  4,  5,  6,  7,  8,  10, 10, 3,  4,  6,  7,  8,  8,
    9,  3,  4,  6,  6,  6,  6,  7,  3,  3,  4,  4,  4,  5,  6,  5,  2,  4,  5,
    5,  4,  5,  9,  7,  9,  8,  6,  5,  6,  14, 12, 11, 9,  8,  7,  7,  3,  7,
    8,  9,  10, 12, 12, 3,  7,  9,  10, 10, 10, 11, 7,  8,  9,  10, 10, 10, 11,
    10, 7,  10, 10, 10, 10, 10, 9,  11, 12, 12, 12, 12, 11, 9,  16, 17, 15, 14,
    13, 13, 14, 22, 20, 18, 16, 15, 14, 13, 15, 15, 16, 17, 16, 12, 14, 16, 17,
    17, 18, 16, 11, 14, 18, 19, 18, 17, 17, 13, 14, 19, 19, 19, 19, 17, 13, 14,
    23, 21, 21, 20, 19, 14, 18, 25, 27, 25, 23, 21, 16, 23, 28, 31, 28, 25, 23,
    18, 24, 25, 26, 26, 22, 18, 14, 23, 29, 26, 28, 24, 19, 15, 24, 29, 30, 28,
    24, 20, 15, 24, 29, 30, 30, 26, 20, 16, 23, 29, 33, 32, 28, 23, 17, 26, 31,
    38, 37, 30, 24, 19, 28, 34, 39, 38, 33, 26, 21, 33, 39, 38, 31, 26, 20, 17,
    33, 39, 41, 32, 27, 22, 17, 33, 40, 42, 34, 27, 23, 18, 33, 38, 43, 36, 29,
    24, 19, 31, 37, 42, 39, 33, 28, 21, 32, 37, 44, 44, 35, 29, 23, 34, 41, 45,
    45, 38, 32, 25, 5,  6,  9,  10, 10, 9,  8,  5,  6,  8,  9,  9,  8,  6,  4,
    5,  7,  8,  7,  6,  4,  4,  4,  4,  5,  6,  4,  2,  2,  2,  2,  2,  3,  2,
    1,  3,  3,  3,  2,  2,  2,  1,  8,  7,  4,  2,  2,  2,  1,  4,  6,  7,  9,
    9,  9,  10, 4,  5,  6,  8,  9,  8,  8,  4,  5,  6,  6,  6,  6,  6,  3,  3,
    3,  4,  3,  3,  3,  2,  2,  2,  0,  0,  1,  4,  6,  5,  4,  3,  2,  2,  4,
    11, 8,  6,  4,  3,  2,  4,  4,  5,  7,  9,  10, 11, 12, 3,  4,  8,  9,  9,
    10, 10, 3,  4,  7,  8,  8,  8,  8,  6,  3,  5,  6,  6,  6,  7,  8,  3,  5,
    7,  7,  6,  7,  11, 7,  9,  10, 8,  8,  7,  13, 11, 11, 12, 10, 9,  9,  3,
    8,  10, 11, 12, 13, 14, 6,  8,  11, 12, 13, 13, 13, 9,  8,  11, 12, 13, 12,
    13, 12, 8,  12, 12, 13, 13, 11, 11, 11, 14, 14, 15, 14, 14, 11, 16, 18, 18,
    16, 16, 16, 13, 20, 21, 20, 18, 17, 17, 13, 17, 18, 19, 19, 19, 15, 16, 18,
    19, 20, 21, 19, 13, 15, 19, 21, 21, 21, 19, 15, 16, 21, 22, 21, 22, 20, 15,
    15, 24, 25, 24, 24, 22, 17, 19, 27, 29, 28, 26, 23, 18, 22, 28, 32, 30, 29,
    25, 20, 26, 29, 28, 28, 26, 22, 17, 27, 31, 31, 30, 26, 22, 17, 26, 34, 33,
    32, 27, 22, 18, 26, 33, 34, 32, 27, 23, 18, 25, 32, 36, 35, 31, 25, 20, 27,
    35, 40, 39, 33, 28, 22, 30, 36, 41, 42, 35, 30, 24, 37, 42, 40, 34, 28, 24,
    20, 36, 43, 43, 35, 30, 23, 20, 36, 42, 45, 37, 31, 24, 20, 36, 41, 46, 39,
    32, 26, 22, 35, 40, 45, 42, 34, 30, 24, 35, 42, 47, 46, 38, 32, 25, 38, 43,
    48, 48, 41, 34, 27, 5,  6,  9,  12, 13, 10, 8,  5,  6,  8,  12, 12, 9,  6,
    4,  5,  7,  9,  10, 7,  3,  4,  4,  4,  6,  8,  5,  2,  2,  1,  1,  3,  6,
    4,  1,  3,  2,  2,  2,  4,  4,  1,  5,  3,  2,  2,  3,  4,  1,  4,  5,  7,
    10, 10, 9,  9,  4,  5,  6,  9,  9,  7,  7,  3,  4,  5,  7,  6,  5,  5,  3,
    3,  3,  3,  3,  3,  3,  2,  2,  1,  0,  0,  1,  3,  4,  3,  2,  2,  2,  1,
    3,  7,  4,  3,  2,  3,  2,  3,  4,  5,  7,  8,  10, 11, 11, 3,  4,  7,  9,
    9,  9,  9,  3,  4,  7,  7,  7,  7,  8,  7,  2,  4,  6,  6,  6,  6,  9,  2,
    5,  7,  7,  7,  6,  9,  4,  6,  9,  9,  8,  6,  9,  7,  7,  10, 9,  9,  9,
    3,  7,  11, 11, 12, 13, 14, 8,  7,  11, 12, 13, 13, 13, 11, 8,  12, 12, 13,
    12, 12, 12, 7,  12, 13, 13, 13, 11, 12, 10, 14, 14, 15, 15, 14, 10, 12, 15,
    16, 16, 16, 15, 9,  15, 18, 18, 17, 17, 17, 14, 17, 18, 19, 20, 20, 14, 16,
    18, 20, 20, 21, 19, 13, 16, 19, 21, 21, 21, 19, 15, 16, 21, 21, 22, 22, 20,
    16, 15, 24, 24, 24, 24, 22, 17, 16, 24, 28, 27, 26, 23, 18, 18, 27, 30, 28,
    27, 25, 20, 27, 30, 28, 28, 25, 22, 18, 26, 31, 30, 31, 27, 22, 17, 26, 34,
    33, 31, 26, 22, 18, 26, 32, 34, 32, 28, 23, 18, 25, 32, 37, 35, 31, 26, 20,
    26, 33, 39, 38, 32, 28, 22, 27, 34, 40, 40, 35, 29, 24, 37, 43, 40, 34, 30,
    24, 21, 37, 42, 43, 36, 30, 25, 20, 37, 42, 45, 36, 30, 26, 21, 36, 41, 46,
    38, 31, 27, 22, 35, 41, 44, 40, 34, 28, 24, 36, 42, 46, 45, 38, 31, 26, 35,
    41, 46, 45, 40, 33, 28, 4,  5,  6,  8,  8,  7,  6,  4,  4,  5,  8,  8,  5,
    4,  3,  4,  5,  6,  6,  4,  2,  3,  3,  3,  4,  6,  3,  1,  2,  1,  0,  2,
    5,  3,  1,  2,  2,  2,  3,  4,  3,  1,  4,  3,  2,  3,  3,  3,  1,  4,  4,
    5,  6,  6,  7,  8,  3,  4,  5,  6,  6,  6,  6,  3,  4,  4,  4,  3,  4,  4,
    2,  2,  2,  3,  2,  2,  2,  2,  1,  1,  1,  1,  0,  2,  3,  2,  2,  2,  1,
    1,  2,  7,  4,  2,  2,  3,  2,  2,  3,  4,  6,  7,  8,  9,  10, 2,  3,  6,
    7,  7,  8,  9,  3,  3,  6,  6,  6,  6,  7,  7,  2,  4,  6,  6,  5,  5,  9,
    2,  4,  6,  7,  7,  5,  10, 4,  5,  7,  8,  8,  5,  9,  7,  6,  8,  9,  9,
    9,  3,  7,  10, 11, 12, 12, 13, 8,  7,  11, 12, 13, 12, 12, 12, 8,  12, 12,
    12, 12, 11, 14, 7,  11, 13, 13, 13, 10, 14, 10, 12, 14, 14, 14, 13, 11, 12,
    14, 15, 16, 16, 15, 9,  15, 16, 17, 17, 17, 17, 14, 17, 19, 19, 20, 19, 13,
    17, 18, 19, 20, 20, 19, 12, 17, 19, 20, 21, 20, 19, 15, 17, 21, 21, 21, 22,
    20, 15, 16, 22, 24, 24, 23, 22, 17, 15, 23, 26, 26, 24, 22, 18, 16, 24, 28,
    27, 26, 24, 20, 26, 29, 28, 28, 25, 21, 17, 26, 31, 30, 30, 26, 22, 17, 26,
    33, 32, 31, 26, 22, 17, 26, 32, 33, 32, 27, 23, 18, 25, 32, 35, 33, 30, 25,
    20, 26, 33, 38, 36, 30, 26, 21, 26, 33, 38, 39, 33, 27, 23, 36, 41, 38, 32,
    27, 24, 20, 35, 41, 42, 34, 29, 25, 20, 35, 41, 44, 36, 30, 25, 20, 35, 40,
    45, 37, 31, 26, 22, 35, 40, 44, 40, 33, 27, 23, 34, 40, 44, 43, 36, 30, 25,
    35, 40, 45, 45, 37, 31, 25, 4,  6,  9,  11, 10, 9,  6,  4,  6,  8,  10, 10,
    7,  4,  3,  5,  7,  8,  9,  6,  4,  3,  3,  5,  7,  8,  5,  3,  1,  0,  3,
    5,  7,  5,  3,  2,  2,  4,  5,  7,  5,  3,  4,  3,  3,  4,  6,  5,  3,  4,
    5,  7,  9,  8,  7,  6,  3,  4,  6,  8,  7,  5,  4,  3,  4,  5,  6,  5,  3,
    2,  2,  2,  4,  5,  4,  3,  0,  1,  1,  2,  3,  3,  2,  0,  3,  2,  3,  4,
    2,  2,  0,  6,  4,  3,  3,  2,  1,  0,  3,  4,  4,  5,  7,  8,  8,  2,  3,
    5,  6,  6,  6,  6,  2,  3,  5,  4,  4,  4,  5,  3,  2,  3,  3,  3,  3,  3,
    6,  2,  4,  4,  4,  4,  3,  7,  4,  5,  5,  5,  5,  3,  9,  7,  6,  6,  6,
    6,  6,  2,  7,  8,  9,  9,  10, 11, 3,  7,  9,  9,  10, 10, 9,  8,  7,  9,
    9,  10, 9,  8,  11, 7,  10, 10, 9,  10, 7,  10, 9,  11, 11, 12, 11, 10, 8,
    11, 13, 13, 13, 13, 12, 8,  14, 15, 15, 14, 14, 13, 13, 15, 16, 16, 16, 16,
    11, 14, 17, 17, 17, 18, 16, 10, 14, 18, 18, 18, 18, 16, 12, 14, 20, 19, 18,
    18, 17, 13, 14, 21, 21, 20, 20, 18, 14, 15, 22, 24, 23, 21, 19, 15, 16, 23,
    26, 24, 24, 20, 17, 24, 25, 24, 24, 21, 18, 14, 24, 28, 27, 25, 22, 18, 14,
    24, 30, 29, 27, 22, 19, 15, 23, 29, 30, 27, 23, 20, 15, 23, 29, 32, 30, 26,
    22, 17, 24, 30, 36, 33, 28, 23, 18, 25, 30, 35, 35, 29, 25, 20, 32, 37, 34,
    29, 23, 20, 17, 32, 37, 36, 30, 25, 21, 17, 33, 37, 39, 31, 26, 22, 17, 32,
    37, 40, 33, 27, 23, 18, 31, 38, 39, 36, 29, 25, 20, 31, 36, 40, 39, 32, 26,
    20, 32, 36, 41, 40, 34, 28, 23, 10, 12, 14, 17, 18, 16, 13, 10, 11, 13, 17,
    17, 14, 12, 9,  11, 12, 14, 15, 12, 10, 9,  9,  10, 11, 14, 9,  4,  6,  7,
    7,  8,  8,  7,  4,  2,  2,  3,  3,  6,  7,  4,  5,  4,  2,  3,  5,  8,  4,
    9,  11, 12, 15, 15, 14, 12, 9,  10, 12, 14, 14, 12, 11, 8,  10, 11, 12, 12,
    11, 9,  8,  8,  9,  9,  9,  8,  3,  5,  5,  5,  5,  4,  4,  3,  0,  2,  2,
    2,  3,  3,  3,  8,  6,  3,  2,  2,  3,  3,  8,  10, 11, 11, 13, 13, 12, 8,
    9,  11, 11, 12, 12, 11, 7,  8,  10, 10, 10, 10, 9,  7,  7,  7,  7,  8,  7,
    4,  3,  3,  4,  4,  3,  3,  3,  3,  2,  2,  1,  2,  2,  3,  9,  9,  5,  2,
    1,  3,  3,  7,  9,  10, 11, 12, 13, 13, 7,  8,  10, 11, 12, 12, 12, 6,  8,
    9,  10, 10, 10, 10, 4,  7,  7,  7,  7,  7,  5,  2,  3,  4,  4,  4,  4,  5,
    3,  8,  7,  7,  6,  6,  6,  9,  13, 11, 9,  7,  7,  8,  7,  8,  9,  11, 12,
    13, 13, 8,  9,  9,  10, 11, 11, 12, 8,  10, 11, 11, 11, 9,  9,  9,  12, 12,
    11, 12, 11, 6,  8,  13, 13, 14, 14, 13, 8,  9,  15, 16, 15, 15, 15, 10, 13,
    17, 18, 16, 16, 16, 12, 16, 18, 19, 19, 15, 12, 13, 16, 20, 20, 20, 16, 12,
    11, 16, 22, 22, 21, 18, 12, 9,  16, 21, 21, 21, 19, 14, 10, 15, 21, 22, 21,
    18, 16, 12, 16, 20, 22, 21, 19, 16, 13, 17, 21, 23, 22, 20, 17, 15, 24, 28,
    27, 23, 18, 14, 12, 24, 28, 28, 24, 20, 15, 10, 24, 28, 30, 23, 21, 16, 11,
    24, 27, 29, 25, 20, 18, 13, 22, 26, 28, 25, 20, 18, 15, 22, 25, 27, 26, 20,
    18, 16, 22, 24, 27, 28, 22, 19, 16, 9,  11, 12, 13, 13, 13, 12, 9,  10, 12,
    13, 13, 11, 10, 8,  10, 11, 11, 11, 10, 8,  8,  8,  9,  9,  9,  6,  3,  5,
    6,  6,  6,  4,  3,  2,  2,  2,  2,  2,  3,  3,  3,  4,  3,  2,  2,  3,  3,
    3,  8,  10, 11, 12, 13, 13, 12, 8,  9,  10, 12, 12, 11, 10, 7,  9,  10, 10,
    10, 9,  7,  7,  7,  7,  8,  7,  6,  2,  5,  4,  4,  5,  3,  2,  2,  2,  0,
    1,  2,  2,  2,  2,  7,  5,  2,  2,  2,  2,  2,  8,  9,  10, 11, 12, 13, 13,
    7,  8,  10, 11, 11, 11, 11, 7,  8,  9,  9,  9,  9,  8,  7,  7,  6,  6,  7,
    6,  4,  3,  3,  3,  3,  2,  3,  3,  3,  3,  2,  2,  2,  3,  3,  9,  8,  5,
    3,  3,  3,  4,  7,  9,  10, 11, 13, 14, 14, 7,  9,  10, 11, 12, 12, 12, 5,
    9,  10, 10, 10, 10, 9,  6,  8,  7,  7,  8,  7,  7,  4,  6,  7,  7,  7,  7,
    8,  3,  10, 10, 9,  9,  9,  9,  9,  16, 13, 11, 10, 10, 11, 10, 11, 11, 12,
    13, 14, 14, 10, 12, 13, 13, 14, 12, 12, 11, 14, 14, 14, 14, 12, 9,  11, 15,
    15, 15, 15, 13, 9,  10, 17, 16, 16, 17, 15, 11, 12, 18, 20, 18, 18, 16, 12,
    16, 21, 23, 20, 20, 18, 14, 19, 21, 21, 21, 18, 15, 14, 20, 23, 23, 23, 19,
    15, 12, 19, 25, 25, 24, 20, 15, 11, 19, 25, 26, 25, 21, 17, 12, 18, 23, 29,
    27, 23, 18, 14, 19, 25, 31, 30, 25, 20, 15, 21, 27, 32, 32, 27, 22, 17, 29,
    34, 33, 27, 21, 17, 14, 28, 34, 36, 29, 23, 18, 13, 28, 34, 39, 30, 24, 19,
    14, 28, 34, 38, 30, 25, 20, 15, 27, 33, 39, 35, 28, 22, 17, 26, 32, 37, 37,
    29, 24, 18, 27, 33, 36, 37, 32, 26, 20, 9,  11, 12, 13, 13, 13, 12, 9,  10,
    11, 13, 13, 11, 10, 8,  9,  11, 11, 10, 9,  7,  8,  8,  8,  9,  8,  6,  2,
    6,  5,  5,  5,  4,  2,  2,  2,  2,  2,  2,  2,  2,  2,  4,  3,  1,  2,  2,
    2,  2,  8,  10, 11, 12, 13, 13, 13, 8,  9,  10, 12, 12, 11, 10, 8,  8,  10,
    10, 9,  9,  7,  8,  7,  7,  7,  7,  5,  3,  5,  4,  4,  4,  2,  2,  2,  2,
    1,  0,  2,  2,  2,  2,  6,  4,  2,  1,  2,  2,  3,  8,  9,  10, 11, 13, 14,
    15, 8,  8,  10, 12, 12, 12, 12, 7,  8,  10, 10, 10, 10, 9,  6,  7,  8,  8,
    8,  6,  5,  4,  3,  5,  5,  4,  4,  5,  5,  3,  5,  4,  4,  4,  5,  7,  6,
    7,  6,  5,  5,  5,  8,  11, 12, 13, 14, 16, 15, 6,  10, 12, 13, 14, 14, 13,
    6,  10, 12, 11, 11, 11, 10, 9,  9,  9,  9,  9,  9,  9,  7,  7,  9,  10, 10,
    10, 11, 5,  12, 12, 12, 12, 12, 12, 7,  15, 15, 14, 13, 13, 13, 11, 14, 15,
    15, 16, 16, 16, 13, 15, 16, 16, 16, 15, 13, 12, 16, 17, 17, 17, 15, 12, 13,
    18, 18, 18, 18, 17, 13, 12, 19, 19, 19, 19, 18, 13, 13, 22, 23, 22, 20, 19,
    15, 17, 22, 26, 24, 22, 21, 16, 22, 24, 25, 24, 22, 18, 16, 22, 26, 26, 27,
    23, 18, 13, 22, 29, 28, 27, 23, 18, 14, 22, 27, 28, 28, 24, 19, 15, 22, 28,
    31, 31, 26, 21, 16, 22, 28, 34, 32, 27, 22, 18, 24, 29, 35, 36, 30, 24, 20,
    32, 38, 37, 29, 24, 21, 16, 31, 38, 38, 32, 26, 21, 16, 31, 37, 41, 32, 27,
    21, 17, 31, 37, 42, 34, 28, 23, 18, 30, 35, 42, 38, 30, 24, 19, 29, 35, 41,
    40, 33, 26, 21, 30, 36, 40, 41, 34, 28, 22, 8,  9,  11, 12, 13, 12, 11, 8,
    9,  11, 12, 12, 11, 9,  7,  8,  10, 10, 10, 8,  6,  7,  7,  7,  8,  8,  5,
    2,  5,  4,  4,  5,  3,  2,  2,  2,  2,  1,  2,  2,  2,  2,  3,  2,  1,  1,
    2,  2,  2,  8,  8,  10, 12, 12, 12, 13, 7,  8,  9,  11, 12, 10, 10, 7,  8,
    9,  10, 9,  8,  8,  6,  6,  6,  7,  6,  5,  4,  4,  3,  3,  3,  2,  2,  4,
    2,  2,  2,  0,  1,  2,  4,  5,  3,  2,  1,  2,  3,  4,  7,  8,  10, 11, 13,
    14, 15, 6,  7,  10, 12, 12, 13, 12, 6,  7,  10, 10, 10, 10, 10, 5,  6,  7,
    8,  8,  7,  6,  6,  2,  4,  5,  5,  6,  6,  7,  2,  5,  6,  6,  7,  6,  6,
    5,  6,  8,  7,  8,  8,  6,  10, 12, 13, 14, 16, 15, 5,  10, 12, 13, 14, 14,
    13, 8,  10, 12, 12, 12, 12, 11, 11, 8,  11, 11, 11, 12, 11, 10, 8,  12, 12,
    12, 13, 13, 8,  11, 14, 14, 14, 14, 14, 6,  14, 15, 16, 15, 15, 16, 13, 16,
    17, 18, 19, 18, 15, 15, 18, 19, 19, 19, 18, 13, 15, 18, 20, 19, 20, 18, 14,
    14, 20, 21, 20, 21, 20, 15, 14, 21, 22, 22, 22, 20, 16, 14, 23, 25, 24, 24,
    22, 17, 16, 23, 27, 26, 25, 23, 19, 25, 27, 27, 27, 24, 21, 17, 25, 31, 29,
    30, 25, 20, 16, 25, 31, 31, 30, 26, 21, 16, 25, 31, 32, 31, 27, 22, 18, 23,
    31, 34, 33, 29, 24, 18, 24, 31, 36, 34, 31, 25, 20, 26, 32, 37, 38, 33, 27,
    22, 35, 40, 40, 33, 27, 23, 19, 35, 41, 42, 34, 29, 24, 19, 35, 40, 44, 36,
    30, 25, 19, 35, 41, 45, 37, 31, 26, 20, 33, 39, 44, 40, 33, 27, 23, 33, 39,
    45, 42, 35, 30, 23, 33, 39, 44, 44, 38, 30, 25, 6,  8,  11, 14, 14, 12, 9,
    6,  7,  10, 13, 13, 11, 7,  5,  6,  9,  11, 12, 9,  5,  5,  5,  6,  8,  10,
    7,  2,  2,  2,  2,  5,  7,  5,  2,  2,  1,  1,  2,  5,  5,  2,  3,  2,  2,
    2,  4,  5,  2,  5,  6,  8,  11, 11, 10, 10, 5,  6,  7,  10, 11, 8,  8,  4,
    5,  6,  8,  8,  6,  6,  4,  4,  4,  5,  5,  3,  2,  2,  1,  1,  2,  2,  1,
    2,  3,  2,  2,  1,  0,  1,  2,  6,  3,  2,  2,  1,  1,  2,  5,  6,  8,  9,
    10, 11, 12, 4,  5,  8,  9,  10, 10, 9,  3,  5,  8,  8,  8,  8,  7,  5,  3,
    5,  5,  5,  5,  5,  8,  2,  4,  5,  6,  6,  5,  9,  3,  5,  7,  7,  7,  5,
    8,  6,  6,  8,  8,  8,  8,  3,  8,  10, 10, 11, 13, 14, 6,  8,  10, 11, 12,
    12, 13, 10, 8,  11, 12, 12, 12, 11, 12, 7,  11, 12, 11, 12, 10, 12, 8,  12,
    13, 13, 13, 13, 9,  11, 13, 14, 14, 14, 15, 8,  14, 16, 16, 15, 15, 16, 13,
    16, 17, 18, 20, 18, 14, 15, 17, 19, 19, 20, 19, 12, 15, 19, 20, 20, 20, 19,
    14, 15, 20, 20, 21, 21, 19, 14, 14, 21, 22, 22, 22, 20, 16, 14, 23, 25, 24,
    23, 22, 17, 16, 24, 28, 26, 27, 24, 19, 26, 29, 27, 28, 24, 21, 16, 25, 30,
    29, 29, 26, 21, 17, 25, 33, 33, 31, 26, 22, 17, 25, 32, 33, 31, 27, 23, 17,
    25, 31, 35, 33, 28, 24, 18, 25, 32, 36, 36, 30, 24, 20, 26, 32, 38, 39, 33,
    27, 22, 35, 41, 39, 33, 28, 23, 19, 36, 41, 42, 35, 29, 24, 19, 36, 40, 45,
    36, 30, 24, 20, 35, 40, 45, 37, 31, 25, 21, 34, 40, 44, 40, 33, 27, 22, 34,
    39, 43, 43, 35, 29, 23, 35, 39, 44, 44, 38, 31, 25, 4,  6,  10, 12, 13, 11,
    8,  4,  5,  9,  12, 12, 9,  6,  4,  5,  7,  10, 10, 8,  4,  3,  3,  4,  7,
    9,  6,  2,  1,  1,  1,  4,  6,  4,  2,  2,  2,  2,  3,  5,  4,  2,  4,  3,
    2,  2,  4,  5,  2,  4,  5,  7,  10, 10, 8,  8,  4,  5,  6,  9,  9,  6,  6,
    3,  4,  5,  7,  7,  4,  4,  3,  2,  2,  4,  4,  2,  2,  2,  2,  1,  2,  1,
    1,  2,  3,  2,  2,  2,  1,  0,  2,  6,  4,  2,  2,  2,  1,  2,  3,  4,  6,
    7,  8,  10, 10, 3,  4,  6,  7,  8,  8,  8,  2,  3,  6,  6,  6,  6,  7,  6,
    2,  4,  5,  5,  5,  5,  8,  2,  4,  6,  6,  6,  5,  9,  4,  5,  7,  7,  7,
    5,  8,  7,  6,  8,  8,  8,  8,  2,  7,  10, 10, 11, 12, 13, 7,  7,  11, 11,
    12, 12, 12, 11, 7,  11, 12, 11, 12, 10, 12, 7,  11, 12, 12, 12, 10, 12, 9,
    13, 13, 13, 13, 13, 9,  11, 14, 14, 15, 15, 14, 9,  14, 16, 17, 16, 16, 16,
    13, 16, 18, 18, 18, 18, 13, 15, 17, 19, 20, 20, 18, 12, 15, 19, 20, 20, 20,
    18, 14, 15, 20, 21, 21, 20, 19, 15, 15, 22, 23, 22, 23, 21, 16, 15, 23, 27,
    24, 24, 21, 18, 16, 24, 28, 27, 25, 23, 19, 25, 28, 27, 27, 25, 20, 16, 26,
    30, 29, 29, 25, 21, 16, 25, 32, 32, 31, 26, 21, 17, 26, 32, 33, 31, 26, 22,
    18, 24, 31, 35, 33, 29, 23, 19, 25, 32, 37, 35, 30, 25, 21, 25, 32, 37, 38,
    32, 27, 22, 35, 40, 39, 32, 27, 23, 19, 36, 40, 41, 34, 27, 24, 19, 35, 39,
    43, 35, 30, 24, 19, 36, 39, 44, 36, 31, 26, 21, 34, 39, 44, 38, 32, 27, 23,
    34, 39, 43, 42, 35, 29, 24, 34, 40, 43, 44, 37, 30, 25, 4,  6,  8,  11, 11,
    9,  6,  4,  6,  8,  10, 10, 7,  4,  3,  5,  7,  8,  9,  6,  4,  3,  3,  5,
    7,  8,  5,  3,  1,  0,  3,  5,  7,  5,  3,  2,  2,  4,  4,  7,  5,  3,  4,
    3,  3,  4,  6,  5,  3,  4,  5,  7,  9,  8,  6,  6,  3,  4,  6,  8,  7,  5,
    4,  3,  4,  5,  7,  5,  4,  2,  2,  2,  4,  5,  4,  3,  0,  1,  1,  2,  4,
    3,  2,  0,  3,  2,  3,  4,  2,  2,  0,  7,  4,  3,  3,  3,  1,  0,  3,  4,
    5,  5,  7,  8,  8,  2,  3,  5,  6,  6,  6,  6,  2,  3,  5,  4,  4,  4,  5,
    3,  2,  3,  3,  2,  3,  3,  6,  2,  4,  4,  4,  4,  3,  7,  4,  5,  5,  5,
    5,  3,  8,  7,  6,  6,  6,  6,  6,  2,  7,  8,  8,  9,  10, 11, 3,  7,  9,
    9,  10, 10, 10, 9,  7,  10, 9,  10, 10, 8,  11, 7,  10, 10, 9,  10, 7,  10,
    9,  11, 11, 12, 11, 11, 7,  11, 13, 12, 13, 13, 12, 8,  14, 15, 14, 14, 14,
    14, 12, 16, 16, 16, 17, 16, 11, 14, 16, 17, 17, 18, 16, 10, 15, 18, 18, 18,
    17, 16, 12, 14, 20, 19, 19, 19, 17, 12, 14, 21, 21, 21, 20, 18, 14, 15, 22,
    24, 22, 21, 19, 15, 16, 23, 26, 25, 23, 21, 17, 24, 26, 24, 25, 21, 18, 14,
    24, 28, 26, 25, 22, 18, 14, 24, 30, 29, 27, 23, 19, 14, 24, 29, 30, 28, 25,
    19, 15, 23, 29, 32, 30, 25, 21, 17, 24, 30, 35, 32, 27, 23, 18, 25, 30, 35,
    35, 30, 25, 20, 32, 37, 35, 28, 24, 21, 16, 32, 37, 38, 31, 25, 20, 17, 33,
    37, 39, 32, 27, 22, 17, 32, 37, 40, 33, 27, 22, 18, 31, 36, 41, 37, 30, 24,
    20, 31, 35, 40, 40, 32, 26, 21, 32, 37, 40, 41, 34, 28, 23, 17, 19, 20, 23,
    22, 21, 20, 17, 19, 20, 22, 22, 20, 18, 16, 18, 19, 19, 20, 17, 14, 16, 16,
    16, 17, 17, 12, 7,  13, 13, 13, 12, 10, 10, 7,  9,  9,  7,  6,  8,  9,  7,
    3,  3,  4,  6,  7,  9,  7,  16, 18, 19, 21, 21, 21, 20, 15, 18, 19, 20, 20,
    19, 17, 15, 17, 18, 19, 18, 17, 14, 14, 15, 15, 16, 14, 11, 7,  12, 12, 12,
    11, 7,  7,  7,  8,  7,  6,  5,  6,  6,  6,  0,  2,  4,  4,  5,  6,  6,  15,
    17, 18, 19, 21, 21, 20, 14, 16, 17, 19, 19, 19, 17, 15, 16, 17, 17, 17, 16,
    13, 15, 14, 14, 14, 13, 11, 6,  10, 10, 10, 9,  5,  6,  6,  3,  5,  5,  4,
    5,  6,  6,  2,  2,  2,  4,  5,  5,  6,  15, 16, 17, 18, 20, 21, 21, 14, 16,
    18, 19, 19, 19, 19, 12, 16, 17, 17, 17, 16, 15, 9,  15, 14, 14, 13, 10, 10,
    6,  11, 10, 9,  5,  5,  7,  4,  4,  4,  4,  4,  5,  6,  2,  7,  5,  5,  5,
    5,  6,  14, 15, 17, 19, 19, 21, 21, 12, 15, 16, 18, 19, 18, 19, 11, 14, 15,
    15, 16, 15, 14, 12, 12, 12, 12, 11, 10, 6,  9,  10, 10, 10, 11, 11, 6,  6,
    11, 13, 12, 12, 12, 7,  7,  12, 14, 13, 13, 12, 9,  13, 15, 16, 17, 17, 19,
    21, 13, 17, 17, 18, 16, 17, 18, 13, 19, 18, 18, 14, 14, 13, 13, 18, 19, 18,
    16, 11, 8,  12, 17, 19, 18, 15, 12, 9,  12, 16, 19, 17, 15, 13, 11, 13, 15,
    18, 18, 16, 14, 12, 21, 25, 24, 21, 16, 18, 19, 21, 25, 25, 21, 17, 16, 16,
    21, 24, 26, 22, 18, 13, 12, 21, 23, 25, 21, 18, 14, 11, 19, 21, 24, 20, 16,
    14, 12, 18, 21, 22, 21, 16, 15, 13, 17, 19, 22, 22, 18, 15, 13, 15, 16, 17,
    19, 18, 18, 17, 14, 16, 17, 18, 18, 17, 15, 13, 15, 16, 16, 16, 14, 11, 13,
    14, 14, 13, 12, 9,  5,  11, 11, 10, 9,  6,  5,  4,  7,  7,  5,  4,  5,  5,
    5,  2,  2,  2,  3,  5,  5,  4,  14, 15, 16, 18, 18, 18, 17, 14, 15, 16, 17,
    18, 16, 14, 13, 14, 15, 16, 15, 13, 10, 13, 12, 13, 12, 11, 9,  4,  10, 9,
    9,  8,  4,  4,  4,  6,  5,  4,  3,  3,  4,  4,  2,  0,  2,  2,  3,  4,  4,
    13, 14, 15, 16, 18, 18, 18, 13, 13, 15, 16, 16, 16, 15, 13, 13, 14, 14, 14,
    13, 11, 12, 12, 11, 11, 10, 8,  5,  8,  8,  8,  8,  3,  4,  4,  3,  4,  4,
    3,  3,  4,  4,  2,  2,  1,  2,  3,  4,  5,  13, 15, 15, 17, 19, 19, 19, 12,
    15, 16, 17, 17, 18, 16, 10, 15, 15, 15, 15, 14, 13, 7,  14, 13, 13, 12, 9,
    9,  5,  10, 9,  8,  6,  6,  7,  3,  6,  6,  7,  7,  7,  8,  2,  9,  9,  8,
    8,  9,  9,  13, 14, 15, 17, 18, 19, 20, 11, 14, 15, 16, 17, 17, 17, 12, 13,
    14, 14, 15, 14, 12, 11, 13, 12, 12, 13, 12, 8,  9,  13, 14, 14, 14, 14, 9,
    8,  15, 16, 17, 16, 15, 11, 10, 16, 19, 19, 19, 17, 12, 16, 19, 19, 20, 17,
    18, 19, 16, 21, 21, 21, 18, 16, 16, 16, 23, 23, 22, 18, 14, 12, 17, 22, 24,
    23, 19, 15, 11, 15, 22, 25, 25, 22, 17, 12, 16, 22, 28, 28, 24, 19, 14, 17,
    23, 28, 29, 25, 21, 16, 26, 32, 31, 24, 20, 17, 18, 25, 31, 33, 26, 21, 16,
    15, 26, 31, 35, 27, 22, 17, 12, 25, 31, 36, 29, 23, 18, 14, 24, 30, 35, 32,
    25, 21, 15, 24, 31, 35, 33, 28, 23, 17, 24, 31, 35, 33, 29, 24, 19, 11, 12,
    14, 15, 15, 15, 14, 10, 12, 13, 15, 14, 13, 11, 10, 11, 13, 13, 12, 10, 8,
    10, 10, 10, 10, 9,  6,  3,  7,  7,  7,  6,  4,  3,  2,  4,  3,  3,  2,  3,
    3,  2,  2,  1,  1,  2,  3,  3,  2,  10, 11, 13, 14, 15, 14, 14, 10, 11, 12,
    13, 14, 12, 12, 10, 10, 11, 12, 11, 10, 8,  10, 9,  9,  9,  8,  6,  3,  7,
    6,  6,  6,  3,  2,  3,  3,  2,  2,  2,  2,  2,  3,  4,  2,  0,  2,  2,  2,
    3,  10, 10, 11, 13, 14, 16, 16, 10, 10, 12, 13, 13, 14, 14, 10, 10, 11, 12,
    11, 11, 10, 9,  8,  9,  9,  9,  6,  5,  4,  5,  6,  6,  4,  3,  5,  3,  2,
    3,  3,  3,  4,  5,  4,  3,  4,  4,  4,  5,  5,  10, 13, 13, 14, 16, 17, 17,
    8,  12, 13, 14, 15, 15, 14, 6,  12, 13, 13, 13, 12, 11, 8,  11, 10, 10, 10,
    9,  9,  6,  7,  8,  9,  9,  10, 9,  4,  9,  10, 10, 11, 11, 11, 4,  12, 12,
    12, 12, 12, 12, 11, 13, 14, 15, 16, 17, 17, 11, 14, 15, 15, 16, 15, 14, 11,
    15, 16, 16, 16, 14, 11, 11, 17, 17, 16, 17, 15, 11, 11, 18, 17, 18, 18, 17,
    12, 12, 19, 21, 20, 20, 18, 14, 14, 20, 23, 21, 22, 20, 16, 21, 23, 23, 23,
    20, 17, 17, 21, 25, 25, 25, 21, 17, 14, 21, 28, 27, 26, 22, 17, 13, 21, 25,
    29, 27, 22, 19, 14, 20, 27, 31, 29, 25, 20, 15, 20, 26, 33, 32, 26, 21, 17,
    22, 27, 32, 34, 29, 24, 18, 30, 35, 35, 28, 23, 19, 16, 30, 36, 38, 31, 24,
    19, 15, 30, 36, 39, 32, 26, 20, 15, 30, 35, 40, 32, 27, 22, 17, 28, 35, 40,
    35, 29, 23, 19, 28, 35, 40, 38, 30, 26, 20, 29, 35, 40, 41, 33, 28, 21, 9,
    10, 12, 13, 13, 13, 12, 8,  9,  11, 13, 13, 11, 9,  8,  9,  11, 11, 11, 9,
    7,  8,  7,  8,  9,  8,  5,  2,  5,  5,  5,  5,  4,  2,  2,  2,  2,  1,  2,
    3,  2,  2,  3,  2,  1,  2,  2,  2,  2,  8,  9,  11, 12, 13, 12, 13, 8,  9,
    10, 12, 12, 10, 10, 7,  8,  9,  10, 10, 8,  8,  7,  7,  7,  8,  7,  5,  4,
    5,  4,  3,  4,  3,  2,  3,  2,  2,  1,  1,  2,  2,  3,  4,  2,  2,  0,  1,
    2,  3,  8,  8,  10, 11, 13, 14, 14, 7,  8,  10, 12, 12, 12, 12, 7,  7,  10,
    10, 10, 10, 9,  5,  6,  8,  8,  8,  6,  6,  5,  3,  5,  5,  5,  5,  6,  6,
    2,  5,  5,  5,  6,  6,  5,  4,  5,  7,  7,  7,  7,  7,  11, 12, 13, 14, 16,
    15, 5,  10, 12, 14, 13, 13, 13, 7,  10, 11, 11, 12, 12, 11, 10, 9,  10, 11,
    11, 11, 10, 9,  8,  11, 11, 12, 12, 12, 7,  10, 13, 13, 13, 13, 14, 5,  13,
    14, 15, 14, 14, 15, 12, 15, 16, 17, 18, 17, 15, 14, 16, 18, 18, 19, 17, 13,
    14, 17, 19, 19, 18, 17, 13, 14, 20, 19, 19, 20, 18, 14, 13, 21, 21, 20, 20,
    19, 15, 14, 22, 23, 23, 22, 21, 17, 16, 22, 26, 25, 25, 23, 18, 24, 27, 26,
    26, 23, 19, 16, 24, 29, 28, 28, 24, 21, 15, 24, 31, 31, 29, 26, 20, 16, 24,
    30, 31, 30, 27, 21, 17, 23, 30, 33, 31, 27, 22, 18, 23, 30, 35, 34, 29, 24,
    19, 25, 30, 35, 36, 32, 27, 21, 33, 40, 39, 32, 26, 22, 18, 34, 40, 42, 34,
    28, 23, 18, 33, 40, 43, 35, 29, 23, 18, 34, 40, 44, 36, 30, 25, 19, 32, 38,
    44, 39, 32, 26, 21, 33, 38, 43, 42, 34, 28, 23, 32, 39, 42, 43, 36, 30, 24,
    7,  9,  13, 15, 15, 14, 10, 6,  8,  11, 15, 15, 12, 9,  6,  7,  10, 12, 13,
    10, 7,  6,  5,  7,  10, 11, 8,  4,  3,  3,  4,  6,  8,  6,  3,  1,  1,  2,
    3,  6,  6,  3,  3,  2,  2,  2,  5,  6,  3,  6,  7,  10, 13, 13, 10, 10, 6,
    7,  9,  12, 12, 9,  8,  5,  6,  8,  10, 10, 7,  6,  5,  5,  5,  7,  6,  5,
    3,  2,  2,  2,  3,  3,  3,  2,  2,  2,  2,  2,  1,  2,  3,  5,  3,  2,  1,
    0,  1,  2,  5,  6,  8,  9,  11, 12, 12, 5,  6,  8,  9,  10, 10, 10, 4,  5,
    8,  8,  8,  8,  8,  4,  4,  5,  6,  6,  5,  5,  6,  2,  3,  4,  4,  4,  4,
    8,  3,  4,  5,  5,  5,  5,  7,  5,  5,  7,  7,  7,  7,  5,  8,  10, 10, 12,
    13, 13, 4,  8,  10, 11, 11, 11, 11, 7,  8,  10, 10, 10, 10, 10, 10, 7,  10,
    11, 11, 11, 9,  10, 8,  11, 11, 12, 11, 12, 8,  10, 13, 13, 13, 13, 13, 7,
    13, 15, 15, 15, 14, 15, 12, 16, 16, 17, 18, 17, 14, 14, 16, 18, 18, 19, 17,
    12, 14, 18, 19, 19, 18, 17, 13, 14, 19, 19, 19, 19, 18, 13, 13, 21, 21, 21,
    21, 19, 15, 13, 22, 23, 23, 22, 20, 16, 15, 23, 26, 25, 24, 22, 18, 24, 27,
    26, 26, 23, 19, 15, 24, 30, 28, 28, 25, 20, 15, 24, 31, 30, 29, 24, 20, 16,
    25, 31, 31, 30, 25, 21, 16, 24, 30, 34, 32, 27, 23, 17, 24, 30, 36, 35, 28,
    23, 20, 24, 31, 35, 36, 31, 26, 20, 34, 39, 39, 32, 26, 21, 18, 34, 40, 39,
    33, 28, 23, 18, 34, 41, 43, 35, 28, 23, 18, 33, 39, 44, 35, 30, 24, 19, 32,
    39, 42, 39, 31, 26, 20, 32, 39, 43, 41, 34, 28, 23, 32, 38, 42, 43, 36, 30,
    24, 5,  8,  11, 15, 15, 13, 9,  5,  7,  10, 14, 14, 11, 7,  4,  5,  9,  11,
    13, 9,  6,  4,  4,  6,  8,  11, 7,  3,  1,  1,  2,  5,  8,  6,  3,  2,  2,
    2,  3,  6,  6,  3,  4,  3,  2,  3,  5,  6,  3,  4,  5,  9,  12, 12, 9,  9,
    4,  5,  8,  11, 11, 8,  7,  3,  5,  6,  8,  8,  6,  4,  3,  3,  3,  6,  5,
    4,  1,  2,  1,  1,  2,  2,  2,  1,  3,  2,  2,  3,  1,  1,  1,  7,  4,  2,
    2,  1,  0,  1,  4,  5,  6,  7,  9,  10, 10, 3,  4,  7,  7,  8,  8,  8,  3,
    4,  6,  6,  6,  6,  6,  4,  2,  4,  4,  4,  4,  4,  7,  2,  4,  5,  5,  4,
    4,  8,  3,  5,  6,  6,  6,  4,  8,  6,  6,  7,  7,  7,  7,  3,  7,  9,  9,
    10, 11, 12, 5,  7,  10, 10, 11, 11, 11, 8,  7,  10, 10, 10, 11, 10, 11, 7,
    10, 11, 11, 11, 8,  10, 9,  11, 12, 12, 12, 12, 8,  11, 13, 13, 14, 13, 13,
    8,  14, 15, 15, 14, 14, 15, 13, 16, 16, 17, 18, 17, 12, 15, 16, 17, 18, 19,
    17, 11, 15, 18, 19, 19, 19, 18, 13, 15, 20, 20, 20, 20, 18, 13, 14, 21, 21,
    21, 21, 19, 15, 14, 22, 25, 23, 22, 21, 16, 16, 24, 27, 25, 25, 23, 18, 24,
    28, 27, 26, 23, 19, 15, 24, 29, 28, 27, 24, 19, 15, 24, 32, 31, 29, 25, 20,
    16, 24, 31, 31, 29, 26, 21, 16, 23, 29, 33, 31, 27, 22, 18, 24, 30, 37, 34,
    28, 24, 19, 25, 30, 37, 36, 31, 26, 21, 34, 39, 37, 31, 26, 22, 18, 35, 40,
    39, 33, 27, 22, 18, 34, 39, 42, 34, 29, 24, 18, 34, 37, 42, 34, 29, 24, 19,
    33, 38, 42, 37, 31, 26, 21, 34, 38, 41, 41, 34, 27, 23, 33, 38, 42, 42, 35,
    28, 24, 4,  6,  8,  11, 11, 9,  6,  4,  6,  8,  10, 10, 7,  4,  3,  5,  7,
    8,  9,  6,  4,  3,  3,  5,  6,  8,  5,  3,  1,  0,  3,  5,  8,  5,  3,  2,
    2,  4,  5,  7,  5,  3,  4,  3,  3,  4,  6,  5,  3,  4,  5,  7,  9,  8,  7,
    6,  3,  4,  6,  8,  7,  5,  4,  3,  4,  5,  7,  5,  4,  2,  2,  2,  3,  5,
    4,  3,  0,  1,  1,  2,  4,  3,  2,  0,  3,  2,  3,  4,  2,  2,  0,  7,  4,
    3,  3,  3,  1,  0,  3,  4,  5,  5,  7,  8,  8,  2,  3,  5,  6,  6,  6,  6,
    2,  3,  5,  4,  4,  4,  5,  3,  2,  3,  3,  3,  3,  3,  5,  2,  4,  4,  4,
    4,  3,  7,  4,  5,  5,  5,  5,  3,  8,  7,  6,  6,  6,  6,  6,  2,  7,  8,
    9,  9,  10, 11, 3,  7,  9,  9,  10, 10, 9,  9,  7,  10, 9,  9,  10, 8,  11,
    7,  10, 10, 10, 10, 7,  9,  9,  11, 11, 11, 11, 11, 8,  11, 13, 13, 13, 13,
    12, 8,  14, 15, 14, 14, 14, 13, 12, 15, 16, 16, 16, 16, 11, 14, 17, 17, 17,
    18, 16, 10, 14, 17, 18, 18, 18, 16, 12, 14, 19, 18, 19, 18, 17, 12, 14, 21,
    21, 20, 19, 19, 14, 15, 22, 24, 23, 21, 19, 16, 16, 22, 26, 24, 23, 21, 17,
    24, 26, 24, 24, 21, 18, 14, 24, 28, 27, 26, 23, 18, 14, 24, 30, 28, 27, 23,
    19, 15, 24, 29, 31, 27, 24, 20, 16, 23, 28, 32, 30, 25, 21, 17, 24, 30, 34,
    33, 28, 23, 19, 24, 30, 35, 34, 30, 24, 20, 32, 37, 35, 28, 24, 20, 17, 33,
    37, 36, 30, 25, 21, 16, 33, 37, 39, 31, 26, 22, 17, 32, 37, 40, 33, 27, 23,
    19, 31, 36, 39, 36, 30, 23, 20, 31, 36, 40, 38, 32, 26, 21, 33, 36, 41, 40,
    34, 28, 22, 2,  3,  4,  8,  8,  6,  2,  2,  2,  3,  7,  8,  4,  2,  2,  2,
    2,  4,  5,  2,  2,  1,  2,  2,  2,  3,  2,  3,  2,  3,  3,  3,  4,  3,  3,
    6,  6,  6,  6,  4,  3,  3,  12, 11, 8,  6,  5,  3,  3,  2,  2,  3,  5,  5,
    2,  2,  1,  2,  3,  3,  4,  2,  1,  0,  2,  2,  2,  2,  2,  1,  1,  1,  2,
    2,  1,  1,  3,  4,  3,  4,  4,  4,  3,  3,  8,  8,  8,  7,  5,  3,  3,  15,
    13, 10, 7,  5,  4,  3,  0,  2,  2,  2,  2,  2,  1,  1,  2,  2,  2,  2,  2,
    1,  2,  1,  1,  1,  1,  1,  2,  2,  1,  2,  1,  2,  2,  4,  6,  5,  5,  5,
    5,  4,  4,  11, 10, 9,  8,  6,  5,  4,  18, 16, 12, 9,  7,  6,  5,  2,  2,
    2,  3,  3,  3,  7,  2,  3,  4,  4,  4,  4,  7,  4,  4,  5,  5,  5,  5,  7,
    7,  7,  7,  7,  8,  8,  8,  8,  12, 11, 11, 12, 11, 10, 12, 17, 16, 15, 14,
    13, 12, 18, 23, 20, 17, 15, 14, 13, 10, 10, 10, 10, 11, 10, 7,  12, 12, 12,
    11, 12, 11, 7,  12, 13, 13, 14, 13, 12, 8,  12, 17, 16, 16, 17, 15, 12, 15,
    21, 21, 20, 20, 19, 14, 19, 24, 25, 25, 23, 20, 15, 22, 27, 30, 27, 25, 22,
    17, 19, 21, 20, 20, 17, 13, 8,  19, 22, 22, 22, 18, 14, 10, 19, 24, 24, 24,
    19, 15, 11, 19, 25, 27, 27, 23, 19, 15, 22, 28, 32, 31, 28, 23, 17, 24, 30,
    36, 35, 30, 25, 18, 27, 34, 37, 37, 32, 26, 20, 27, 32, 32, 25, 20, 16, 11,
    27, 33, 34, 28, 22, 17, 13, 26, 34, 36, 29, 24, 19, 15, 28, 34, 38, 32, 27,
    23, 19, 29, 35, 40, 36, 32, 27, 21, 31, 37, 40, 40, 33, 27, 23, 33, 38, 42,
    42, 36, 30, 25, 1,  2,  3,  3,  3,  2,  2,  1,  2,  2,  3,  3,  2,  1,  1,
    2,  2,  2,  2,  2,  1,  2,  1,  2,  2,  2,  2,  4,  4,  3,  4,  4,  4,  4,
    4,  8,  7,  7,  7,  5,  4,  4,  13, 12, 9,  7,  6,  4,  4,  1,  2,  2,  3,
    2,  2,  1,  2,  1,  2,  2,  2,  1,  1,  2,  0,  2,  2,  2,  1,  1,  2,  2,
    2,  2,  2,  2,  4,  5,  5,  5,  5,  5,  4,  4,  10, 9,  9,  8,  6,  4,  4,
    17, 14, 11, 8,  6,  5,  4,  2,  0,  1,  2,  2,  1,  5,  2,  1,  1,  1,  1,
    1,  5,  2,  2,  1,  1,  1,  1,  6,  4,  2,  4,  4,  4,  4,  7,  8,  6,  7,
    7,  8,  7,  7,  13, 12, 12, 11, 10, 8,  7,  19, 17, 15, 13, 11, 10, 9,  2,
    5,  5,  6,  6,  6,  9,  5,  6,  6,  7,  7,  7,  9,  8,  7,  7,  8,  8,  8,
    9,  11, 10, 11, 11, 11, 12, 11, 11, 15, 15, 15, 15, 15, 14, 13, 20, 20, 18,
    17, 16, 15, 19, 26, 23, 21, 18, 18, 17, 13, 14, 13, 13, 13, 13, 9,  14, 15,
    14, 15, 15, 14, 9,  14, 17, 16, 17, 16, 15, 12, 15, 21, 20, 20, 20, 19, 16,
    18, 25, 25, 24, 24, 22, 17, 22, 28, 30, 29, 26, 24, 19, 26, 31, 33, 30, 29,
    26, 20, 22, 24, 23, 23, 19, 15, 11, 23, 26, 25, 24, 21, 16, 12, 23, 28, 27,
    26, 23, 19, 15, 23, 29, 31, 30, 27, 22, 19, 25, 32, 36, 34, 31, 26, 21, 29,
    34, 41, 39, 34, 27, 22, 32, 37, 42, 41, 36, 30, 24, 31, 36, 34, 28, 23, 18,
    14, 30, 37, 37, 30, 23, 20, 15, 31, 36, 39, 33, 26, 22, 19, 30, 36, 42, 36,
    31, 27, 23, 32, 39, 45, 41, 35, 29, 24, 34, 40, 47, 45, 39, 31, 26, 38, 43,
    47, 46, 41, 34, 28, 1,  3,  4,  5,  5,  4,  3,  1,  2,  4,  5,  5,  4,  3,
    2,  1,  4,  4,  5,  5,  5,  2,  2,  4,  5,  6,  6,  6,  4,  4,  6,  7,  8,
    7,  6,  8,  8,  9,  10, 8,  7,  6,  14, 13, 10, 10, 9,  7,  6,  2,  1,  3,
    4,  4,  3,  1,  2,  1,  3,  4,  4,  3,  1,  2,  2,  2,  4,  4,  3,  3,  2,
    3,  3,  5,  5,  5,  5,  5,  5,  6,  7,  7,  6,  4,  11, 10, 10, 10, 8,  6,
    4,  18, 15, 12, 10, 8,  6,  4,  2,  1,  0,  1,  1,  2,  5,  2,  2,  1,  1,
    1,  2,  4,  3,  2,  2,  2,  3,  3,  6,  7,  3,  6,  6,  6,  6,  8,  10, 7,
    9,  9,  9,  9,  8,  15, 12, 13, 13, 11, 10, 7,  21, 19, 16, 14, 13, 11, 10,
    3,  6,  6,  6,  7,  6,  8,  8,  6,  7,  7,  8,  8,  9,  10, 7,  9,  9,  10,
    10, 10, 12, 10, 13, 13, 13, 13, 11, 13, 15, 17, 17, 17, 16, 14, 15, 22, 22,
    21, 19, 18, 17, 20, 27, 25, 22, 21, 20, 19, 14, 15, 15, 14, 15, 13, 8,  16,
    15, 16, 16, 15, 14, 8,  16, 17, 18, 19, 18, 17, 13, 16, 22, 22, 22, 22, 21,
    17, 19, 27, 27, 26, 26, 24, 18, 23, 31, 33, 31, 29, 25, 21, 28, 34, 35, 32,
    31, 28, 22, 23, 25, 24, 23, 20, 16, 12, 23, 28, 26, 25, 21, 17, 13, 24, 29,
    28, 28, 25, 21, 17, 24, 31, 33, 32, 28, 24, 21, 27, 33, 39, 36, 33, 27, 21,
    31, 37, 42, 41, 36, 29, 24, 33, 40, 45, 44, 38, 31, 26, 32, 38, 36, 29, 24,
    19, 15, 32, 37, 38, 30, 25, 21, 17, 31, 38, 40, 35, 29, 24, 19, 32, 39, 45,
    39, 32, 28, 24, 34, 41, 46, 44, 37, 31, 25, 37, 44, 48, 48, 41, 33, 28, 40,
    45, 49, 50, 43, 36, 30, 1,  3,  6,  8,  8,  6,  3,  1,  2,  5,  7,  8,  6,
    4,  1,  2,  4,  7,  8,  7,  5,  2,  2,  5,  7,  9,  8,  7,  4,  5,  7,  9,
    11, 9,  8,  9,  9,  10, 11, 11, 9,  8,  16, 14, 12, 11, 11, 9,  7,  1,  1,
    4,  6,  5,  3,  1,  2,  1,  3,  5,  5,  2,  2,  2,  1,  2,  5,  5,  4,  3,
    2,  3,  4,  6,  6,  5,  5,  6,  6,  7,  9,  8,  7,  5,  12, 11, 11, 11, 9,
    7,  5,  19, 17, 13, 11, 9,  7,  5,  2,  2,  1,  0,  1,  2,  4,  2,  2,  1,
    1,  1,  2,  4,  5,  2,  3,  3,  3,  3,  6,  8,  3,  6,  7,  7,  7,  7,  11,
    8,  10, 10, 10, 10, 8,  16, 13, 15, 14, 13, 11, 8,  21, 20, 18, 16, 14, 12,
    11, 5,  6,  7,  7,  7,  5,  7,  9,  6,  7,  8,  8,  8,  8,  12, 7,  9,  10,
    11, 11, 10, 14, 10, 14, 15, 14, 14, 12, 15, 15, 18, 18, 18, 18, 15, 16, 23,
    22, 21, 21, 19, 17, 22, 29, 26, 24, 22, 20, 20, 15, 14, 14, 14, 14, 13, 7,
    18, 15, 16, 15, 16, 15, 8,  18, 17, 18, 19, 19, 17, 14, 17, 22, 23, 23, 23,
    22, 18, 20, 28, 28, 27, 27, 25, 20, 23, 32, 34, 32, 28, 26, 22, 28, 35, 37,
    34, 32, 28, 23, 24, 26, 24, 23, 20, 16, 12, 24, 28, 26, 26, 22, 18, 14, 24,
    30, 29, 29, 25, 21, 18, 24, 32, 34, 33, 30, 25, 22, 28, 35, 40, 38, 34, 29,
    23, 32, 37, 45, 42, 36, 30, 25, 36, 42, 45, 45, 39, 33, 27, 32, 38, 35, 29,
    23, 19, 15, 32, 38, 37, 31, 26, 21, 18, 33, 38, 41, 35, 29, 26, 21, 32, 40,
    45, 39, 35, 29, 25, 36, 43, 48, 44, 39, 33, 26, 38, 45, 50, 50, 41, 35, 29,
    41, 47, 51, 51, 44, 37, 30, 1,  3,  6,  8,  8,  6,  3,  2,  2,  5,  7,  8,
    6,  5,  2,  1,  5,  8,  9,  8,  6,  2,  3,  5,  8,  10, 9,  8,  5,  6,  8,
    10, 12, 10, 9,  10, 11, 12, 13, 13, 10, 9,  17, 15, 13, 12, 12, 10, 9,  2,
    1,  4,  6,  5,  2,  2,  2,  1,  3,  5,  5,  3,  2,  2,  2,  2,  6,  5,  4,
    4,  2,  3,  5,  7,  7,  6,  7,  7,  7,  8,  10, 10, 8,  7,  13, 12, 13, 13,
    10, 9,  7,  21, 18, 14, 13, 11, 9,  7,  2,  2,  1,  1,  0,  2,  4,  3,  2,
    1,  1,  2,  3,  5,  7,  2,  3,  4,  5,  4,  6,  10, 3,  7,  8,  8,  8,  8,
    13, 9,  11, 12, 12, 11, 8,  17, 15, 16, 15, 14, 13, 8,  23, 21, 19, 17, 15,
    14, 13, 6,  6,  7,  7,  7,  4,  7,  11, 7,  8,  8,  9,  9,  8,  13, 7,  10,
    11, 12, 12, 11, 16, 10, 15, 16, 16, 16, 13, 16, 17, 19, 20, 20, 19, 16, 18,
    24, 25, 23, 22, 21, 19, 23, 30, 28, 25, 23, 22, 22, 16, 15, 15, 15, 15, 13,
    7,  19, 17, 16, 16, 18, 16, 8,  19, 18, 19, 20, 21, 19, 15, 19, 23, 23, 25,
    25, 24, 20, 20, 28, 30, 29, 29, 26, 21, 24, 33, 35, 33, 31, 29, 23, 30, 37,
    38, 35, 33, 30, 25, 25, 26, 25, 24, 20, 16, 12, 24, 28, 26, 25, 22, 19, 15,
    24, 30, 29, 30, 27, 23, 19, 25, 32, 35, 34, 31, 27, 23, 28, 36, 41, 39, 35,
    30, 25, 33, 40, 46, 43, 38, 32, 27, 37, 42, 47, 46, 40, 34, 28, 32, 38, 35,
    28, 23, 19, 16, 33, 37, 38, 31, 26, 22, 19, 34, 38, 40, 35, 31, 27, 22, 33,
    40, 45, 40, 35, 31, 27, 35, 43, 47, 46, 39, 34, 29, 41, 46, 50, 50, 42, 36,
    30, 43, 48, 50, 53, 45, 38, 32, 3,  5,  7,  8,  8,  6,  5,  2,  4,  6,  8,
    9,  7,  6,  1,  3,  6,  9,  10, 9,  8,  2,  4,  7,  9,  12, 11, 10, 5,  7,
    10, 11, 14, 12, 10, 11, 12, 13, 14, 14, 12, 10, 17, 16, 15, 14, 14, 12, 10,
    1,  4,  5,  7,  5,  3,  2,  2,  2,  5,  6,  6,  4,  3,  2,  2,  5,  7,  7,
    6,  5,  2,  3,  6,  8,  8,  7,  8,  6,  7,  10, 11, 11, 9,  8,  13, 13, 14,
    14, 11, 10, 8,  21, 18, 15, 14, 12, 10, 8,  2,  1,  2,  2,  2,  0,  2,  2,
    2,  1,  1,  2,  1,  4,  4,  2,  1,  3,  3,  3,  5,  9,  3,  5,  6,  6,  7,
    7,  11, 9,  10, 10, 10, 10, 7,  17, 15, 15, 14, 12, 11, 7,  23, 21, 17, 15,
    14, 12, 11, 4,  5,  5,  5,  5,  3,  5,  9,  6,  6,  6,  7,  7,  7,  12, 7,
    8,  9,  10, 11, 9,  15, 10, 13, 14, 14, 14, 11, 15, 15, 18, 18, 18, 17, 15,
    17, 23, 23, 22, 20, 19, 17, 24, 30, 26, 24, 22, 20, 19, 15, 13, 13, 12, 13,
    11, 5,  18, 15, 14, 14, 15, 14, 7,  19, 16, 17, 19, 19, 18, 13, 19, 21, 22,
    23, 23, 21, 18, 19, 27, 28, 27, 27, 24, 19, 23, 31, 34, 31, 29, 25, 21, 29,
    35, 36, 33, 31, 28, 23, 23, 24, 22, 20, 18, 14, 10, 23, 26, 24, 22, 20, 17,
    13, 23, 28, 27, 27, 23, 21, 17, 23, 30, 32, 30, 29, 24, 21, 27, 34, 37, 36,
    32, 28, 23, 31, 38, 43, 42, 35, 30, 25, 35, 40, 44, 43, 37, 31, 26, 31, 33,
    30, 25, 20, 17, 14, 30, 33, 33, 27, 23, 20, 17, 31, 33, 36, 31, 27, 25, 21,
    30, 35, 42, 36, 32, 28, 25, 34, 39, 44, 43, 37, 32, 27, 38, 42, 47, 47, 40,
    33, 28, 41, 46, 49, 48, 42, 36, 30, 6,  7,  9,  10, 10, 8,  6,  5,  6,  8,
    10, 11, 9,  8,  4,  6,  8,  11, 13, 11, 9,  3,  6,  9,  12, 14, 12, 11, 5,
    8,  10, 13, 15, 14, 11, 11, 13, 14, 14, 16, 14, 11, 17, 17, 15, 15, 14, 13,
    11, 4,  6,  7,  9,  7,  5,  3,  3,  5,  7,  8,  7,  6,  5,  1,  5,  7,  9,
    8,  7,  6,  1,  5,  8,  10, 9,  9,  8,  5,  8,  10, 12, 11, 10, 8,  12, 13,
    15, 15, 12, 10, 8,  20, 18, 16, 14, 12, 10, 8,  1,  5,  5,  4,  4,  2,  0,
    2,  3,  5,  4,  3,  3,  2,  2,  2,  4,  5,  4,  5,  4,  4,  3,  6,  6,  6,
    6,  6,  8,  8,  10, 10, 10, 8,  6,  15, 15, 15, 13, 11, 9,  6,  22, 20, 17,
    14, 11, 9,  8,  2,  2,  2,  2,  1,  2,  3,  5,  3,  3,  2,  3,  3,  4,  8,
    5,  4,  6,  6,  6,  6,  11, 7,  9,  10, 10, 10, 8,  12, 14, 14, 14, 14, 13,
    11, 15, 20, 19, 17, 16, 15, 13, 22, 26, 22, 20, 18, 16, 15, 12, 10, 9,  9,
    9,  8,  3,  15, 12, 11, 11, 11, 10, 4,  15, 14, 13, 14, 14, 13, 10, 14, 18,
    18, 18, 19, 17, 14, 17, 25, 23, 23, 23, 20, 15, 22, 28, 30, 27, 24, 21, 17,
    26, 31, 33, 29, 26, 23, 19, 20, 19, 18, 16, 14, 10, 6,  19, 22, 18, 17, 15,
    13, 9,  19, 23, 22, 21, 19, 16, 13, 20, 25, 26, 26, 23, 20, 17, 23, 30, 33,
    30, 28, 23, 19, 27, 33, 38, 35, 29, 25, 20, 32, 35, 40, 38, 32, 27, 22, 24,
    28, 25, 19, 15, 13, 10, 25, 28, 27, 21, 17, 15, 13, 25, 28, 29, 25, 22, 19,
    16, 25, 29, 35, 31, 27, 23, 20, 28, 35, 39, 36, 31, 27, 22, 32, 37, 41, 41,
    34, 28, 23, 36, 40, 42, 43, 37, 30, 26, 2,  3,  8,  12, 12, 10, 7,  2,  3,
    6,  11, 11, 9,  4,  2,  2,  4,  8,  9,  7,  2,  2,  2,  2,  4,  7,  5,  2,
    2,  2,  2,  3,  5,  5,  2,  6,  6,  6,  5,  4,  5,  2,  11, 11, 8,  6,  4,
    5,  2,  2,  2,  5,  8,  9,  6,  2,  1,  2,  3,  7,  9,  4,  2,  2,  2,  2,
    4,  5,  2,  2,  0,  2,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  2,  2,  7,
    7,  8,  6,  4,  3,  2,  15, 13, 10, 7,  5,  3,  2,  1,  2,  2,  2,  3,  2,
    2,  0,  2,  2,  2,  2,  2,  1,  1,  2,  2,  2,  2,  2,  0,  1,  1,  1,  1,
    1,  1,  2,  5,  4,  4,  4,  4,  3,  2,  11, 9,  9,  7,  5,  3,  2,  17, 16,
    12, 9,  6,  4,  3,  1,  1,  1,  1,  1,  1,  5,  2,  2,  2,  3,  3,  3,  6,
    2,  3,  3,  3,  4,  4,  6,  5,  5,  6,  6,  6,  7,  7,  6,  10, 10, 10, 10,
    9,  9,  11, 15, 14, 14, 12, 11, 10, 17, 21, 18, 16, 14, 13, 12, 9,  9,  9,
    9,  10, 9,  6,  11, 11, 10, 11, 11, 10, 6,  11, 12, 12, 12, 12, 11, 7,  11,
    15, 14, 15, 15, 14, 11, 13, 20, 19, 19, 19, 18, 12, 17, 23, 25, 24, 21, 20,
    14, 21, 26, 27, 24, 24, 21, 16, 18, 20, 19, 19, 16, 12, 7,  18, 21, 21, 21,
    18, 12, 9,  18, 23, 22, 22, 18, 14, 10, 18, 24, 26, 25, 22, 18, 14, 20, 25,
    30, 28, 25, 21, 16, 22, 28, 33, 31, 27, 23, 18, 25, 31, 34, 34, 29, 25, 19,
    26, 31, 29, 24, 19, 15, 10, 26, 31, 31, 26, 21, 16, 11, 26, 31, 33, 27, 23,
    18, 14, 25, 31, 35, 30, 26, 21, 18, 27, 32, 35, 33, 28, 24, 20, 29, 35, 37,
    36, 31, 27, 22, 32, 34, 36, 37, 31, 28, 23, 2,  2,  3,  3,  3,  2,  2,  1,
    2,  3,  3,  3,  2,  2,  1,  2,  2,  3,  3,  2,  1,  1,  1,  2,  2,  2,  2,
    3,  3,  3,  3,  3,  4,  3,  3,  7,  6,  7,  6,  5,  3,  3,  13, 11, 8,  7,
    5,  3,  3,  1,  2,  2,  3,  2,  2,  2,  1,  2,  2,  3,  2,  2,  1,  2,  2,
    2,  2,  2,  2,  1,  2,  1,  2,  2,  1,  2,  3,  4,  4,  4,  4,  4,  3,  3,
    9,  8,  8,  7,  5,  4,  3,  16, 14, 10, 8,  6,  4,  3,  2,  1,  2,  2,  2,
    2,  3,  2,  0,  1,  1,  1,  2,  3,  2,  1,  1,  0,  1,  0,  4,  3,  2,  2,
    2,  3,  3,  6,  7,  6,  6,  6,  6,  5,  6,  12, 11, 10, 9,  8,  7,  6,  18,
    17, 13, 11, 9,  8,  7,  2,  4,  4,  4,  5,  4,  8,  3,  5,  5,  5,  6,  6,
    8,  6,  6,  6,  6,  7,  7,  8,  9,  9,  9,  10, 10, 10, 10, 10, 13, 13, 13,
    13, 13, 12, 12, 19, 18, 16, 16, 15, 14, 18, 25, 22, 19, 18, 16, 15, 12, 12,
    12, 12, 12, 12, 8,  14, 14, 13, 13, 14, 12, 8,  13, 15, 15, 15, 15, 14, 11,
    13, 19, 19, 18, 19, 18, 14, 17, 24, 23, 23, 23, 20, 16, 20, 27, 29, 27, 25,
    22, 17, 25, 30, 31, 29, 28, 25, 19, 21, 23, 22, 21, 18, 14, 10, 21, 25, 23,
    23, 20, 15, 11, 20, 26, 27, 26, 22, 17, 13, 21, 27, 28, 28, 25, 21, 17, 24,
    30, 34, 33, 30, 24, 19, 27, 33, 40, 37, 32, 26, 21, 30, 36, 40, 39, 34, 29,
    22, 29, 36, 33, 27, 20, 17, 13, 29, 35, 35, 28, 23, 18, 14, 29, 35, 38, 31,
    25, 20, 16, 29, 34, 42, 35, 30, 25, 21, 31, 37, 43, 40, 34, 29, 22, 33, 40,
    45, 43, 37, 30, 25, 35, 42, 46, 46, 39, 32, 27, 1,  3,  4,  5,  5,  4,  3,
    1,  3,  4,  5,  5,  4,  3,  1,  2,  4,  4,  5,  4,  4,  1,  2,  4,  5,  5,
    5,  6,  4,  4,  6,  7,  7,  6,  6,  8,  8,  10, 10, 8,  7,  6,  14, 12, 11,
    10, 9,  7,  6,  1,  2,  4,  5,  4,  3,  1,  1,  1,  3,  4,  4,  3,  0,  2,
    1,  3,  4,  3,  4,  3,  2,  2,  3,  5,  5,  5,  5,  5,  5,  6,  8,  7,  6,
    5,  10, 10, 10, 11, 8,  6,  5,  18, 15, 11, 10, 8,  7,  5,  2,  1,  1,  1,
    1,  1,  4,  2,  1,  0,  1,  1,  1,  4,  2,  1,  2,  2,  2,  2,  5,  5,  3,
    5,  5,  5,  5,  7,  9,  7,  8,  8,  8,  8,  7,  14, 12, 13, 11, 10, 9,  7,
    20, 18, 15, 14, 12, 10, 9,  2,  5,  6,  6,  6,  5,  8,  6,  6,  6,  7,  7,
    7,  8,  9,  7,  8,  8,  9,  9,  9,  11, 9,  12, 12, 12, 12, 11, 12, 15, 16,
    16, 16, 16, 14, 14, 21, 20, 19, 18, 17, 16, 20, 27, 24, 21, 20, 18, 17, 13,
    13, 13, 14, 14, 13, 8,  15, 15, 14, 15, 15, 14, 8,  15, 17, 17, 17, 17, 16,
    12, 15, 22, 21, 20, 21, 20, 16, 18, 26, 25, 24, 25, 23, 18, 23, 30, 32, 29,
    28, 24, 20, 26, 33, 35, 31, 30, 26, 21, 23, 25, 23, 23, 19, 15, 11, 23, 27,
    25, 24, 20, 16, 12, 23, 28, 27, 28, 24, 19, 16, 22, 30, 32, 31, 28, 23, 19,
    26, 33, 36, 35, 31, 26, 21, 29, 35, 41, 40, 34, 29, 22, 33, 38, 43, 43, 36,
    30, 24, 30, 37, 35, 28, 22, 18, 14, 31, 36, 37, 30, 24, 20, 16, 31, 36, 40,
    33, 28, 22, 19, 30, 38, 44, 38, 31, 27, 23, 33, 39, 45, 42, 36, 31, 25, 35,
    41, 48, 46, 39, 32, 27, 40, 44, 48, 51, 41, 35, 29, 1,  4,  6,  9,  9,  7,
    4,  1,  3,  5,  8,  8,  7,  5,  1,  2,  5,  7,  9,  8,  6,  1,  3,  5,  8,
    10, 8,  8,  5,  5,  7,  9,  11, 10, 8,  9,  9,  11, 12, 11, 9,  8,  15, 14,
    12, 12, 11, 10, 8,  1,  2,  4,  7,  6,  3,  1,  1,  1,  4,  6,  6,  3,  1,
    2,  1,  3,  6,  5,  4,  3,  2,  3,  4,  6,  6,  6,  6,  5,  6,  7,  9,  9,
    7,  6,  11, 11, 11, 12, 9,  8,  6,  19, 16, 13, 12, 9,  8,  6,  2,  1,  1,
    1,  2,  1,  3,  2,  1,  1,  0,  1,  1,  4,  3,  2,  2,  2,  2,  3,  5,  7,
    3,  5,  6,  5,  6,  7,  10, 8,  9,  9,  10, 8,  7,  15, 13, 14, 13, 11, 10,
    7,  21, 20, 17, 15, 13, 11, 10, 3,  5,  6,  6,  6,  4,  7,  8,  6,  7,  7,
    7,  7,  7,  11, 7,  8,  9,  10, 10, 9,  13, 9,  13, 13, 13, 13, 11, 13, 15,
    17, 16, 17, 17, 14, 16, 22, 22, 21, 19, 18, 16, 21, 28, 26, 23, 21, 20, 18,
    14, 14, 14, 14, 14, 13, 7,  16, 15, 15, 15, 15, 14, 7,  16, 17, 17, 18, 18,
    17, 13, 16, 21, 22, 22, 22, 21, 17, 19, 27, 27, 27, 26, 24, 19, 23, 30, 32,
    31, 28, 26, 20, 28, 33, 35, 32, 31, 28, 22, 23, 24, 23, 23, 19, 16, 11, 22,
    27, 25, 24, 21, 17, 13, 23, 30, 28, 28, 24, 21, 17, 23, 31, 33, 32, 28, 24,
    21, 28, 34, 36, 36, 33, 27, 22, 31, 36, 44, 42, 36, 29, 24, 34, 39, 43, 45,
    37, 32, 26, 31, 36, 35, 28, 22, 18, 14, 31, 37, 37, 31, 25, 20, 17, 31, 37,
    41, 33, 29, 25, 19, 31, 38, 45, 39, 33, 28, 24, 35, 39, 46, 44, 36, 32, 26,
    38, 45, 51, 50, 40, 33, 28, 40, 46, 50, 51, 43, 35, 30, 1,  4,  7,  10, 10,
    8,  4,  1,  3,  6,  9,  9,  7,  5,  1,  2,  5,  8,  10, 8,  6,  2,  3,  6,
    8,  11, 9,  8,  5,  6,  8,  10, 12, 10, 8,  10, 10, 12, 12, 12, 10, 8,  16,
    14, 12, 12, 12, 10, 8,  1,  2,  5,  7,  7,  4,  1,  1,  1,  4,  6,  6,  4,
    2,  2,  1,  3,  6,  6,  5,  3,  2,  3,  5,  7,  7,  6,  6,  5,  6,  8,  9,
    9,  7,  6,  12, 11, 12, 12, 9,  8,  6,  19, 17, 13, 12, 10, 8,  6,  2,  1,
    1,  1,  2,  2,  3,  2,  2,  1,  1,  0,  1,  4,  4,  2,  2,  3,  3,  2,  5,
    8,  3,  6,  6,  6,  6,  7,  11, 8,  9,  10, 10, 9,  7,  16, 14, 14, 13, 12,
    10, 7,  21, 20, 17, 15, 13, 12, 11, 4,  5,  6,  6,  6,  4,  7,  8,  6,  7,
    7,  7,  7,  7,  12, 6,  8,  10, 10, 10, 9,  13, 9,  13, 13, 14, 14, 11, 14,
    15, 17, 17, 18, 17, 14, 16, 22, 22, 21, 20, 18, 17, 21, 28, 25, 23, 22, 20,
    19, 15, 14, 14, 14, 14, 13, 7,  17, 15, 15, 15, 15, 14, 7,  16, 17, 17, 19,
    19, 17, 13, 17, 21, 23, 23, 22, 21, 17, 19, 27, 27, 27, 27, 24, 19, 24, 32,
    34, 31, 30, 26, 20, 28, 36, 36, 34, 31, 29, 23, 23, 25, 23, 23, 20, 16, 11,
    23, 27, 25, 24, 22, 17, 14, 23, 29, 28, 28, 24, 20, 17, 23, 31, 34, 33, 29,
    25, 21, 27, 34, 38, 37, 33, 28, 22, 30, 38, 44, 42, 36, 30, 24, 35, 40, 44,
    44, 37, 32, 26, 32, 35, 34, 27, 22, 18, 14, 31, 37, 36, 29, 24, 21, 17, 31,
    36, 38, 33, 29, 24, 21, 32, 39, 43, 38, 33, 28, 24, 35, 42, 46, 44, 37, 32,
    27, 37, 43, 49, 48, 42, 34, 28, 41, 46, 49, 51, 44, 36, 30, 3,  5,  6,  8,
    8,  6,  4,  2,  5,  6,  8,  8,  6,  5,  1,  4,  6,  8,  9,  8,  6,  2,  4,
    7,  9,  11, 9,  8,  4,  6,  8,  10, 12, 10, 8,  10, 10, 12, 12, 12, 10, 8,
    15, 15, 13, 12, 12, 10, 8,  1,  4,  5,  7,  5,  4,  2,  1,  3,  5,  6,  5,
    3,  2,  2,  2,  5,  6,  6,  5,  4,  2,  3,  5,  7,  7,  6,  6,  5,  6,  8,
    10, 9,  7,  6,  12, 11, 12, 12, 10, 8,  6,  19, 16, 14, 12, 10, 8,  6,  2,
    1,  2,  2,  3,  1,  3,  2,  1,  1,  1,  1,  0,  3,  3,  1,  1,  2,  2,  2,
    4,  7,  3,  5,  5,  5,  5,  5,  11, 8,  9,  9,  9,  8,  5,  15, 14, 13, 12,
    11, 9,  5,  21, 18, 16, 14, 12, 11, 9,  2,  5,  5,  5,  5,  4,  6,  7,  6,
    6,  6,  6,  6,  6,  11, 6,  7,  8,  9,  9,  7,  14, 9,  12, 12, 12, 12, 10,
    14, 14, 17, 16, 17, 16, 13, 16, 21, 21, 20, 19, 17, 16, 21, 27, 25, 22, 20,
    18, 18, 14, 13, 13, 13, 13, 13, 6,  16, 15, 14, 14, 14, 13, 6,  17, 16, 16,
    17, 17, 16, 12, 17, 21, 21, 21, 22, 19, 15, 19, 27, 27, 26, 25, 23, 18, 23,
    30, 32, 30, 27, 25, 20, 27, 33, 34, 31, 29, 27, 21, 23, 23, 22, 21, 18, 15,
    10, 23, 26, 23, 22, 19, 16, 12, 23, 28, 26, 25, 23, 19, 16, 23, 29, 32, 29,
    27, 23, 19, 26, 33, 37, 34, 31, 26, 21, 31, 37, 40, 40, 33, 28, 23, 33, 38,
    42, 42, 35, 29, 24, 30, 34, 30, 25, 20, 16, 13, 29, 34, 33, 27, 22, 20, 16,
    30, 34, 36, 30, 26, 23, 19, 29, 36, 40, 34, 30, 27, 23, 33, 39, 43, 41, 35,
    30, 25, 37, 41, 46, 46, 37, 31, 27, 40, 44, 47, 47, 40, 34, 28, 6,  7,  9,
    12, 11, 9,  6,  5,  6,  8,  11, 11, 8,  6,  4,  6,  8,  10, 11, 9,  8,  3,
    6,  9,  10, 13, 11, 9,  5,  7,  9,  11, 14, 12, 9,  9,  10, 11, 12, 14, 12,
    9,  15, 14, 12, 12, 13, 12, 9,  4,  6,  7,  9,  8,  6,  4,  3,  6,  7,  8,
    7,  5,  3,  1,  5,  7,  8,  7,  6,  5,  1,  4,  8,  9,  8,  8,  6,  5,  7,
    9,  10, 9,  9,  6,  11, 11, 12, 12, 10, 8,  6,  18, 16, 13, 12, 10, 8,  6,
    1,  5,  5,  4,  5,  4,  2,  1,  3,  4,  4,  4,  3,  0,  1,  2,  4,  4,  3,
    3,  2,  2,  3,  5,  5,  4,  4,  4,  7,  8,  8,  7,  8,  6,  4,  14, 13, 12,
    10, 8,  7,  4,  20, 17, 14, 11, 9,  7,  5,  1,  2,  2,  2,  2,  3,  5,  2,
    3,  2,  2,  3,  3,  3,  7,  4,  4,  5,  5,  5,  4,  10, 7,  8,  8,  8,  8,
    6,  10, 13, 12, 12, 12, 11, 9,  14, 19, 17, 15, 14, 13, 11, 19, 23, 20, 17,
    15, 14, 13, 11, 10, 9,  9,  10, 9,  5,  13, 12, 11, 10, 11, 9,  3,  13, 13,
    13, 14, 13, 11, 8,  13, 18, 17, 16, 17, 15, 12, 16, 23, 22, 21, 21, 18, 13,
    20, 26, 27, 25, 22, 20, 15, 23, 28, 31, 26, 24, 22, 16, 19, 19, 17, 16, 15,
    11, 8,  19, 22, 18, 17, 15, 11, 8,  19, 23, 21, 20, 17, 14, 12, 20, 25, 25,
    24, 22, 18, 15, 22, 28, 31, 28, 25, 22, 17, 27, 31, 36, 33, 27, 23, 19, 29,
    34, 38, 35, 29, 25, 20, 25, 27, 25, 19, 16, 13, 10, 25, 27, 27, 20, 17, 14,
    11, 25, 28, 29, 24, 21, 18, 15, 25, 29, 34, 29, 25, 21, 18, 28, 33, 36, 34,
    30, 24, 20, 31, 35, 40, 38, 32, 26, 21, 35, 38, 41, 41, 34, 28, 23, 3,  7,
    12, 15, 16, 14, 11, 2,  5,  10, 14, 15, 14, 8,  2,  4,  8,  11, 13, 11, 6,
    2,  2,  5,  8,  10, 10, 5,  2,  2,  3,  6,  8,  9,  5,  5,  6,  6,  5,  7,
    9,  5,  12, 11, 8,  4,  7,  9,  5,  2,  4,  8,  12, 13, 11, 5,  2,  3,  7,
    10, 12, 9,  3,  2,  2,  5,  7,  8,  6,  2,  1,  2,  2,  4,  5,  3,  2,  2,
    3,  3,  3,  3,  3,  2,  7,  7,  7,  6,  3,  2,  2,  15, 13, 9,  7,  4,  3,
    2,  2,  2,  3,  5,  6,  4,  2,  1,  2,  2,  3,  4,  3,  1,  0,  2,  2,  2,
    2,  2,  1,  1,  1,  1,  1,  1,  1,  1,  4,  4,  4,  4,  4,  3,  2,  10, 9,
    9,  8,  5,  3,  2,  17, 16, 12, 9,  6,  4,  2,  0,  1,  1,  1,  2,  2,  4,
    1,  1,  1,  1,  1,  1,  5,  1,  2,  2,  3,  3,  3,  5,  4,  4,  5,  5,  5,
    6,  7,  5,  9,  8,  9,  9,  8,  7,  11, 14, 13, 13, 11, 10, 9,  17, 20, 17,
    15, 13, 12, 11, 8,  8,  8,  9,  9,  8,  5,  10, 10, 9,  10, 10, 9,  5,  10,
    11, 11, 11, 12, 11, 6,  10, 14, 13, 14, 14, 13, 9,  12, 18, 18, 18, 18, 17,
    11, 16, 21, 22, 21, 20, 19, 13, 19, 24, 24, 22, 21, 20, 16, 17, 18, 18, 18,
    15, 11, 7,  17, 20, 19, 19, 16, 12, 7,  17, 22, 22, 21, 19, 14, 9,  17, 22,
    23, 22, 20, 17, 13, 18, 24, 26, 24, 23, 20, 15, 21, 26, 29, 28, 24, 21, 17,
    23, 28, 30, 29, 26, 22, 18, 25, 28, 26, 22, 19, 14, 9,  24, 28, 28, 24, 20,
    16, 10, 24, 29, 31, 24, 21, 17, 13, 24, 29, 31, 26, 23, 20, 17, 25, 28, 32,
    30, 25, 22, 18, 27, 29, 33, 32, 27, 23, 20, 28, 31, 33, 34, 29, 24, 21, 2,
    2,  3,  5,  5,  3,  2,  2,  2,  3,  4,  5,  2,  2,  2,  2,  2,  3,  3,  2,
    1,  0,  2,  2,  2,  3,  2,  3,  2,  2,  3,  3,  4,  3,  3,  6,  6,  7,  6,
    4,  3,  3,  12, 11, 8,  6,  5,  3,  3,  1,  2,  3,  3,  3,  2,  2,  1,  2,
    2,  3,  2,  2,  1,  1,  2,  2,  2,  2,  2,  1,  2,  1,  2,  2,  2,  1,  3,
    4,  3,  4,  4,  4,  3,  3,  9,  8,  8,  7,  5,  3,  3,  16, 13, 10, 8,  5,
    4,  3,  1,  2,  2,  2,  2,  2,  2,  2,  1,  2,  2,  2,  2,  2,  2,  0,  1,
    1,  1,  1,  3,  2,  2,  2,  1,  2,  2,  5,  6,  5,  5,  5,  5,  4,  5,  12,
    10, 10, 8,  7,  5,  5,  18, 17, 12, 10, 8,  7,  6,  2,  3,  3,  3,  4,  4,
    7,  2,  4,  4,  5,  5,  5,  8,  5,  5,  5,  5,  6,  6,  7,  8,  8,  8,  8,
    9,  9,  9,  9,  13, 12, 12, 13, 12, 11, 12, 18, 16, 16, 15, 13, 12, 18, 23,
    20, 18, 17, 15, 14, 11, 11, 11, 11, 11, 11, 7,  12, 13, 12, 13, 13, 12, 7,
    12, 14, 14, 14, 14, 13, 9,  13, 18, 17, 17, 18, 16, 13, 16, 22, 22, 21, 22,
    19, 14, 19, 26, 27, 26, 24, 22, 16, 24, 29, 31, 28, 26, 23, 18, 19, 21, 20,
    20, 17, 13, 9,  20, 23, 22, 23, 19, 14, 10, 20, 25, 25, 24, 20, 16, 12, 20,
    26, 28, 28, 24, 20, 16, 23, 28, 32, 32, 29, 23, 18, 26, 32, 37, 37, 31, 25,
    20, 28, 34, 39, 39, 33, 28, 22, 28, 34, 32, 26, 20, 16, 12, 28, 34, 34, 27,
    22, 17, 13, 27, 34, 38, 30, 24, 20, 16, 28, 34, 39, 34, 28, 23, 20, 30, 36,
    41, 39, 32, 28, 22, 32, 38, 44, 41, 36, 30, 24, 34, 40, 45, 43, 38, 31, 25,
    2,  4,  5,  6,  6,  5,  4,  1,  4,  5,  6,  6,  5,  4,  0,  3,  5,  5,  5,
    4,  4,  1,  2,  4,  5,  5,  5,  6,  3,  4,  6,  6,  7,  6,  6,  8,  8,  9,
    9,  8,  6,  6,  13, 12, 11, 9,  8,  6,  6,  0,  3,  5,  5,  5,  4,  2,  1,
    2,  4,  5,  5,  4,  2,  1,  1,  4,  4,  4,  3,  2,  2,  2,  3,  5,  4,  5,
    5,  5,  4,  6,  7,  7,  6,  5,  9,  9,  10, 10, 8,  6,  5,  17, 14, 11, 10,
    8,  6,  5,  1,  1,  2,  3,  3,  1,  4,  2,  1,  2,  2,  2,  1,  4,  2,  1,
    0,  0,  0,  0,  5,  4,  2,  3,  3,  3,  3,  6,  8,  6,  7,  7,  7,  6,  6,
    13, 11, 11, 10, 9,  7,  6,  19, 18, 14, 12, 10, 9,  8,  2,  4,  5,  5,  5,
    5,  7,  4,  5,  5,  6,  6,  6,  8,  8,  6,  7,  7,  7,  8,  8,  10, 9,  10,
    10, 11, 11, 10, 11, 14, 14, 15, 15, 14, 13, 13, 20, 19, 18, 17, 15, 15, 19,
    26, 22, 20, 18, 17, 16, 12, 13, 12, 13, 13, 12, 7,  13, 14, 14, 14, 14, 13,
    8,  14, 16, 16, 16, 16, 15, 11, 13, 20, 19, 19, 20, 18, 15, 18, 25, 24, 24,
    24, 21, 16, 22, 28, 30, 28, 26, 23, 18, 26, 31, 33, 29, 28, 25, 20, 22, 23,
    22, 22, 18, 14, 10, 22, 25, 24, 24, 20, 16, 12, 22, 27, 26, 26, 23, 18, 14,
    21, 29, 30, 29, 26, 22, 18, 26, 31, 36, 34, 30, 25, 20, 27, 34, 39, 38, 33,
    27, 21, 31, 37, 41, 41, 34, 28, 23, 29, 35, 34, 27, 22, 17, 13, 29, 36, 36,
    29, 24, 19, 14, 29, 36, 39, 32, 26, 22, 17, 30, 36, 42, 35, 30, 26, 22, 31,
    38, 44, 41, 33, 29, 24, 34, 40, 47, 47, 38, 30, 26, 37, 43, 47, 47, 39, 33,
    27, 2,  6,  9,  11, 11, 10, 7,  2,  5,  8,  11, 11, 9,  6,  0,  3,  7,  9,
    10, 7,  6,  1,  2,  5,  7,  9,  8,  7,  3,  4,  6,  8,  10, 9,  7,  7,  8,
    10, 10, 10, 9,  7,  14, 13, 11, 10, 10, 9,  7,  0,  3,  7,  10, 9,  6,  3,
    1,  2,  5,  8,  9,  6,  2,  1,  1,  4,  6,  6,  4,  2,  2,  2,  4,  6,  6,
    5,  4,  4,  5,  6,  8,  7,  6,  4,  10, 9,  10, 10, 8,  6,  4,  17, 14, 11,
    11, 8,  6,  4,  1,  1,  2,  3,  4,  3,  5,  2,  0,  2,  2,  3,  2,  4,  2,
    1,  0,  0,  0,  0,  3,  4,  2,  3,  3,  3,  3,  5,  8,  6,  7,  7,  7,  6,
    5,  13, 11, 11, 10, 9,  7,  5,  19, 17, 14, 12, 10, 9,  8,  2,  4,  5,  5,
    6,  6,  8,  5,  5,  6,  6,  7,  7,  7,  10, 6,  7,  7,  7,  7,  7,  11, 9,
    10, 11, 11, 10, 9,  12, 14, 14, 15, 14, 14, 12, 13, 20, 19, 18, 17, 16, 14,
    19, 26, 23, 21, 18, 17, 16, 12, 13, 12, 13, 14, 13, 8,  15, 14, 14, 15, 15,
    14, 7,  14, 16, 16, 16, 15, 14, 11, 14, 20, 19, 19, 20, 17, 14, 17, 25, 24,
    23, 24, 21, 16, 21, 28, 30, 28, 26, 23, 18, 25, 31, 33, 30, 27, 25, 20, 22,
    24, 22, 22, 19, 16, 12, 21, 26, 24, 24, 20, 16, 12, 22, 28, 26, 26, 21, 18,
    14, 22, 29, 30, 30, 26, 22, 18, 25, 33, 36, 34, 30, 25, 19, 28, 34, 41, 38,
    33, 27, 22, 31, 37, 42, 41, 36, 29, 23, 30, 35, 34, 28, 23, 18, 14, 29, 36,
    36, 30, 23, 19, 14, 30, 35, 38, 32, 26, 21, 17, 29, 37, 41, 35, 31, 25, 21,
    32, 39, 45, 39, 34, 29, 23, 34, 41, 47, 46, 38, 31, 26, 37, 43, 47, 46, 40,
    33, 27, 3,  6,  9,  13, 13, 10, 7,  2,  5,  8,  12, 12, 9,  6,  0,  4,  7,
    10, 11, 8,  6,  1,  3,  5,  8,  10, 9,  7,  4,  4,  6,  8,  11, 9,  7,  7,
    8,  10, 10, 10, 9,  7,  13, 12, 10, 10, 10, 9,  7,  1,  4,  7,  10, 10, 7,
    3,  1,  2,  6,  9,  9,  6,  2,  1,  1,  5,  7,  7,  4,  2,  1,  2,  4,  6,
    6,  5,  4,  4,  5,  6,  8,  7,  5,  4,  10, 9,  10, 10, 7,  6,  4,  16, 14,
    11, 10, 8,  6,  4,  1,  1,  3,  4,  5,  3,  4,  1,  1,  2,  2,  3,  2,  3,
    2,  1,  0,  0,  0,  1,  3,  4,  2,  3,  3,  3,  3,  4,  8,  6,  7,  7,  7,
    6,  4,  13, 12, 11, 10, 9,  7,  4,  19, 17, 14, 12, 10, 9,  8,  1,  5,  5,
    5,  6,  6,  8,  5,  6,  6,  6,  7,  7,  7,  9,  6,  7,  7,  7,  7,  6,  11,
    8,  11, 11, 10, 11, 8,  12, 14, 15, 15, 15, 14, 12, 13, 19, 19, 18, 17, 15,
    14, 19, 26, 23, 20, 19, 17, 16, 12, 13, 13, 13, 14, 13, 8,  14, 15, 14, 14,
    15, 13, 7,  15, 16, 16, 16, 16, 14, 11, 14, 20, 20, 20, 20, 18, 14, 17, 25,
    25, 24, 23, 21, 16, 22, 29, 30, 28, 26, 23, 18, 26, 32, 33, 31, 28, 25, 20,
    22, 23, 23, 23, 20, 16, 11, 22, 26, 24, 24, 21, 16, 12, 23, 29, 27, 26, 22,
    17, 14, 23, 29, 31, 29, 26, 22, 18, 25, 32, 37, 34, 30, 25, 19, 28, 35, 41,
    38, 33, 27, 22, 31, 36, 41, 40, 34, 30, 23, 31, 35, 33, 27, 22, 18, 14, 30,
    36, 36, 29, 23, 18, 14, 29, 36, 38, 31, 25, 21, 17, 31, 36, 40, 35, 30, 26,
    22, 32, 38, 43, 40, 34, 29, 23, 36, 41, 45, 45, 37, 31, 25, 37, 43, 46, 46,
    40, 34, 27, 3,  6,  8,  9,  9,  7,  5,  2,  6,  7,  9,  9,  6,  4,  1,  4,
    6,  8,  8,  6,  5,  1,  3,  5,  7,  9,  8,  6,  4,  4,  7,  8,  11, 9,  6,
    8,  8,  10, 10, 10, 9,  6,  13, 12, 10, 10, 10, 9,  6,  0,  4,  6,  8,  7,
    5,  3,  1,  3,  5,  7,  6,  4,  2,  1,  1,  5,  6,  4,  3,  2,  2,  2,  4,
    6,  5,  5,  4,  5,  5,  6,  8,  7,  6,  4,  10, 9,  10, 10, 7,  6,  4,  16,
    13, 11, 10, 8,  6,  4,  1,  1,  3,  3,  4,  3,  5,  2,  1,  2,  3,  3,  2,
    3,  2,  1,  0,  0,  0,  0,  2,  4,  2,  3,  3,  3,  3,  4,  9,  7,  7,  7,
    7,  6,  4,  14, 11, 11, 10, 9,  7,  4,  18, 16, 13, 11, 10, 9,  8,  2,  5,
    5,  6,  6,  6,  8,  5,  6,  6,  6,  7,  7,  6,  9,  6,  7,  7,  8,  7,  6,
    11, 8,  11, 11, 10, 11, 8,  12, 14, 15, 14, 15, 14, 11, 13, 20, 19, 18, 16,
    16, 14, 18, 25, 22, 20, 18, 17, 16, 13, 13, 13, 13, 14, 13, 8,  15, 15, 14,
    15, 15, 13, 7,  15, 16, 16, 16, 16, 14, 10, 15, 20, 20, 20, 20, 18, 15, 18,
    25, 24, 23, 24, 21, 16, 22, 28, 29, 28, 26, 23, 18, 25, 30, 32, 29, 28, 25,
    20, 23, 24, 23, 22, 19, 16, 11, 23, 26, 24, 22, 20, 16, 11, 23, 28, 26, 24,
    21, 18, 14, 22, 29, 31, 28, 25, 22, 18, 25, 31, 35, 34, 29, 24, 19, 28, 33,
    39, 37, 31, 26, 22, 31, 35, 41, 39, 33, 27, 23, 29, 34, 32, 26, 22, 18, 14,
    30, 34, 33, 27, 22, 18, 14, 29, 33, 36, 29, 24, 21, 17, 29, 34, 39, 34, 29,
    26, 21, 32, 37, 42, 38, 34, 27, 23, 34, 40, 44, 44, 35, 29, 25, 37, 41, 45,
    45, 37, 31, 27, 7,  9,  11, 13, 13, 11, 8,  6,  8,  10, 12, 13, 10, 6,  5,
    7,  9,  11, 11, 8,  6,  3,  6,  7,  10, 12, 10, 8,  4,  6,  8,  10, 13, 10,
    8,  7,  8,  9,  10, 12, 10, 7,  11, 10, 9,  9,  11, 11, 8,  5,  7,  9,  11,
    10, 7,  5,  4,  6,  8,  10, 9,  6,  4,  1,  6,  7,  9,  7,  5,  3,  0,  4,
    6,  8,  7,  6,  5,  4,  5,  7,  8,  8,  7,  5,  9,  8,  9,  10, 7,  7,  5,
    13, 11, 10, 9,  8,  6,  5,  2,  6,  6,  6,  6,  5,  4,  0,  4,  5,  5,  5,
    4,  2,  1,  3,  5,  3,  3,  3,  0,  1,  2,  3,  3,  3,  3,  2,  6,  6,  6,
    5,  5,  4,  2,  12, 10, 8,  8,  6,  4,  2,  15, 13, 10, 8,  6,  5,  3,  1,
    2,  3,  3,  4,  5,  6,  1,  3,  3,  4,  4,  4,  5,  4,  5,  4,  4,  4,  4,
    4,  7,  7,  7,  6,  6,  6,  5,  8,  12, 11, 10, 10, 9,  8,  12, 16, 14, 13,
    12, 11, 10, 15, 20, 16, 14, 14, 12, 11, 11, 10, 10, 10, 11, 10, 6,  12, 12,
    11, 11, 12, 10, 5,  12, 14, 13, 12, 12, 10, 7,  12, 17, 15, 15, 15, 13, 10,
    15, 22, 20, 19, 18, 16, 12, 19, 23, 25, 22, 20, 18, 13, 20, 25, 27, 24, 22,
    19, 15, 19, 19, 18, 17, 15, 12, 9,  19, 22, 19, 18, 16, 12, 8,  19, 23, 21,
    19, 16, 13, 10, 19, 23, 24, 22, 19, 17, 13, 21, 27, 29, 27, 23, 20, 15, 24,
    28, 34, 29, 25, 20, 17, 26, 30, 34, 34, 27, 23, 18, 25, 28, 26, 20, 17, 14,
    11, 25, 28, 28, 22, 18, 14, 11, 25, 28, 30, 23, 19, 16, 12, 25, 29, 32, 27,
    23, 19, 16, 27, 31, 36, 33, 27, 22, 18, 29, 33, 38, 36, 29, 24, 20, 30, 36,
    38, 38, 32, 26, 21, 6,  10, 15, 18, 18, 17, 15, 5,  9,  13, 16, 17, 15, 12,
    3,  7,  11, 14, 15, 13, 10, 2,  5,  8,  11, 13, 13, 9,  2,  2,  6,  9,  11,
    13, 10, 5,  5,  5,  8,  11, 13, 10, 11, 10, 6,  6,  10, 13, 9,  3,  7,  12,
    15, 15, 13, 10, 2,  6,  10, 13, 15, 13, 7,  2,  4,  8,  11, 12, 10, 4,  2,
    2,  5,  8,  8,  8,  3,  2,  3,  3,  6,  7,  7,  3,  7,  7,  6,  5,  5,  6,
    3,  14, 12, 9,  5,  4,  4,  3,  2,  4,  7,  9,  10, 9,  4,  2,  3,  5,  7,
    8,  7,  2,  1,  2,  4,  5,  4,  4,  1,  0,  2,  1,  1,  2,  1,  2,  4,  4,
    4,  4,  4,  3,  2,  10, 10, 9,  8,  6,  3,  2,  16, 15, 11, 9,  7,  4,  2,
    1,  1,  1,  2,  2,  3,  3,  0,  1,  1,  1,  1,  1,  4,  1,  1,  2,  2,  2,
    2,  4,  3,  3,  3,  4,  4,  4,  5,  5,  8,  7,  8,  8,  7,  6,  10, 13, 12,
    12, 10, 9,  8,  16, 18, 15, 13, 12, 11, 10, 7,  7,  8,  8,  9,  7,  3,  9,
    9,  9,  10, 9,  8,  4,  9,  10, 11, 11, 11, 10, 5,  9,  13, 13, 13, 13, 12,
    8,  11, 16, 16, 16, 15, 15, 10, 14, 19, 19, 18, 17, 16, 12, 18, 21, 21, 19,
    18, 17, 14, 16, 16, 16, 16, 14, 11, 6,  16, 19, 17, 17, 15, 12, 7,  16, 20,
    19, 18, 16, 13, 8,  15, 20, 20, 19, 17, 15, 12, 17, 21, 23, 21, 19, 17, 14,
    19, 22, 25, 24, 21, 18, 15, 21, 23, 27, 25, 22, 18, 16, 21, 25, 23, 19, 17,
    14, 9,  21, 25, 26, 20, 17, 15, 10, 22, 25, 27, 21, 18, 15, 12, 21, 24, 28,
    22, 18, 17, 15, 20, 25, 29, 26, 21, 19, 16, 22, 26, 29, 28, 23, 20, 17, 24,
    27, 30, 30, 24, 21, 18, 3,  3,  5,  8,  8,  6,  3,  2,  3,  4,  7,  8,  5,
    3,  2,  3,  4,  5,  6,  4,  2,  2,  2,  3,  3,  4,  2,  2,  1,  2,  2,  2,
    3,  2,  2,  5,  5,  5,  4,  3,  2,  2,  11, 9,  7,  5,  3,  2,  2,  2,  3,
    4,  6,  5,  4,  3,  2,  3,  4,  5,  5,  3,  2,  1,  2,  3,  3,  3,  3,  2,
    1,  1,  2,  2,  2,  2,  2,  2,  2,  3,  3,  2,  2,  2,  7,  6,  7,  6,  3,
    2,  2,  14, 12, 8,  6,  4,  2,  2,  1,  2,  3,  3,  3,  3,  3,  1,  2,  3,
    3,  3,  3,  3,  1,  2,  2,  2,  2,  2,  2,  2,  0,  1,  1,  1,  1,  2,  4,
    4,  3,  3,  4,  2,  3,  10, 9,  8,  7,  5,  3,  3,  17, 15, 11, 8,  6,  5,
    4,  2,  3,  3,  4,  4,  4,  7,  2,  4,  4,  5,  5,  5,  8,  3,  5,  5,  6,
    6,  6,  8,  5,  6,  6,  6,  7,  7,  8,  6,  10, 10, 10, 10, 10, 9,  10, 16,
    15, 14, 13, 11, 11, 16, 21, 18, 16, 14, 13, 12, 10, 11, 11, 11, 12, 11, 7,
    11, 12, 12, 12, 13, 12, 8,  12, 13, 14, 14, 14, 13, 9,  12, 16, 16, 15, 15,
    15, 11, 14, 20, 19, 19, 19, 17, 12, 17, 23, 25, 24, 22, 20, 14, 20, 27, 29,
    26, 24, 22, 16, 19, 21, 21, 20, 18, 14, 9,  20, 23, 23, 23, 19, 14, 10, 19,
    25, 25, 24, 21, 16, 11, 19, 24, 26, 26, 22, 18, 14, 21, 26, 31, 29, 27, 21,
    16, 23, 29, 34, 34, 28, 24, 17, 26, 31, 35, 34, 31, 25, 20, 28, 34, 32, 26,
    22, 17, 12, 27, 34, 34, 28, 23, 18, 13, 27, 33, 37, 30, 24, 19, 14, 28, 33,
    38, 31, 26, 22, 18, 27, 34, 39, 36, 30, 25, 19, 29, 36, 39, 39, 33, 27, 22,
    33, 37, 39, 41, 34, 30, 24, 5,  8,  9,  10, 10, 9,  8,  4,  7,  9,  10, 9,
    8,  7,  3,  6,  8,  8,  8,  7,  5,  2,  4,  6,  6,  7,  5,  4,  1,  2,  4,
    5,  5,  5,  4,  5,  5,  7,  6,  5,  5,  4,  10, 10, 8,  7,  6,  5,  4,  3,
    6,  8,  9,  8,  8,  6,  2,  5,  7,  9,  8,  7,  5,  1,  4,  7,  7,  7,  6,
    4,  1,  2,  4,  5,  5,  4,  3,  2,  2,  4,  5,  4,  4,  3,  7,  6,  8,  7,
    5,  4,  3,  14, 11, 9,  8,  5,  4,  3,  2,  4,  6,  6,  7,  5,  6,  1,  2,
    5,  5,  6,  5,  5,  1,  2,  3,  3,  3,  3,  3,  1,  1,  0,  0,  0,  0,  3,
    5,  4,  3,  3,  3,  3,  3,  10, 9,  8,  7,  5,  4,  3,  16, 15, 11, 8,  7,
    6,  5,  1,  4,  5,  5,  6,  6,  9,  2,  5,  5,  6,  7,  7,  8,  4,  6,  6,
    6,  6,  7,  7,  7,  7,  7,  7,  7,  8,  7,  8,  11, 11, 11, 11, 10, 10, 10,
    17, 16, 14, 13, 12, 11, 16, 22, 19, 17, 15, 14, 13, 11, 12, 12, 12, 13, 12,
    8,  12, 13, 14, 14, 14, 13, 8,  12, 15, 15, 15, 15, 13, 9,  12, 17, 16, 16,
    16, 15, 11, 15, 21, 21, 20, 20, 18, 13, 18, 25, 26, 25, 22, 19, 14, 23, 27,
    29, 26, 25, 22, 16, 21, 22, 22, 22, 19, 15, 11, 21, 25, 24, 24, 20, 15, 11,
    21, 26, 25, 25, 20, 16, 12, 21, 26, 27, 26, 23, 18, 14, 21, 28, 31, 31, 27,
    21, 16, 24, 30, 37, 35, 29, 23, 18, 28, 33, 37, 38, 31, 25, 20, 29, 33, 34,
    27, 22, 18, 13, 28, 36, 36, 29, 23, 18, 14, 28, 35, 38, 30, 24, 19, 14, 28,
    34, 39, 32, 26, 22, 18, 29, 35, 42, 38, 32, 26, 20, 31, 37, 43, 41, 34, 27,
    22, 33, 39, 44, 44, 37, 30, 23, 5,  9,  12, 15, 15, 13, 10, 4,  8,  11, 14,
    15, 12, 9,  3,  6,  10, 13, 13, 10, 7,  2,  4,  7,  10, 11, 8,  7,  1,  2,
    5,  8,  10, 9,  7,  5,  5,  7,  8,  9,  8,  7,  10, 10, 8,  8,  8,  8,  7,
    3,  7,  10, 13, 12, 10, 7,  2,  5,  9,  12, 12, 9,  5,  1,  4,  8,  10, 10,
    7,  4,  1,  2,  5,  7,  7,  5,  3,  3,  2,  4,  6,  6,  6,  3,  7,  6,  8,
    8,  6,  5,  3,  13, 12, 9,  8,  6,  4,  3,  1,  4,  6,  7,  8,  6,  6,  1,
    2,  5,  6,  6,  5,  4,  1,  1,  3,  3,  3,  3,  3,  1,  1,  0,  0,  0,  0,
    3,  5,  4,  3,  3,  3,  3,  3,  10, 8,  8,  7,  5,  4,  3,  16, 14, 11, 9,
    7,  5,  5,  1,  4,  5,  5,  6,  7,  8,  1,  5,  6,  6,  7,  7,  7,  5,  6,
    6,  6,  6,  7,  7,  8,  7,  7,  7,  7,  7,  6,  9,  11, 11, 11, 11, 11, 9,
    11, 17, 16, 15, 13, 12, 11, 16, 22, 19, 17, 15, 14, 12, 11, 12, 12, 13, 14,
    13, 9,  12, 14, 13, 14, 15, 13, 8,  12, 15, 15, 14, 15, 13, 9,  12, 17, 16,
    16, 16, 15, 11, 15, 22, 20, 20, 20, 18, 12, 18, 25, 27, 25, 22, 19, 14, 23,
    28, 29, 27, 25, 22, 16, 21, 22, 22, 22, 19, 15, 11, 21, 24, 24, 24, 20, 15,
    11, 21, 26, 26, 25, 20, 16, 11, 21, 26, 28, 26, 22, 18, 15, 22, 27, 31, 30,
    26, 21, 16, 25, 31, 37, 35, 29, 23, 18, 28, 33, 37, 37, 32, 25, 20, 29, 35,
    33, 27, 22, 18, 14, 29, 36, 36, 30, 23, 19, 14, 30, 35, 38, 30, 24, 19, 14,
    29, 35, 40, 33, 27, 22, 18, 28, 35, 40, 38, 31, 25, 20, 31, 37, 43, 40, 34,
    27, 22, 33, 40, 44, 43, 37, 29, 23, 6,  9,  13, 16, 16, 14, 10, 5,  8,  11,
    15, 15, 12, 9,  3,  6,  10, 13, 14, 11, 7,  2,  4,  7,  10, 12, 9,  6,  1,
    3,  5,  8,  11, 9,  6,  5,  6,  7,  8,  10, 9,  6,  10, 9,  8,  8,  9,  9,
    6,  3,  7,  10, 13, 13, 10, 7,  2,  6,  9,  12, 12, 9,  5,  1,  4,  8,  10,
    10, 7,  3,  1,  2,  5,  7,  7,  5,  2,  3,  2,  4,  6,  6,  5,  2,  7,  6,
    8,  8,  5,  5,  2,  13, 10, 9,  8,  6,  4,  3,  1,  4,  6,  7,  8,  6,  6,
    1,  3,  5,  6,  6,  5,  4,  1,  2,  3,  3,  3,  3,  3,  2,  1,  0,  0,  0,
    0,  3,  5,  4,  4,  4,  4,  3,  3,  11, 9,  8,  7,  6,  4,  3,  15, 13, 10,
    9,  7,  6,  5,  1,  5,  5,  6,  6,  7,  9,  2,  6,  6,  6,  7,  7,  7,  5,
    6,  7,  7,  7,  7,  6,  8,  7,  8,  7,  7,  7,  6,  9,  11, 12, 11, 12, 10,
    9,  11, 17, 16, 15, 13, 12, 11, 15, 21, 19, 17, 15, 14, 13, 11, 13, 13, 13,
    14, 13, 9,  12, 14, 14, 14, 15, 13, 8,  12, 16, 15, 15, 15, 13, 10, 13, 18,
    17, 17, 16, 15, 11, 14, 22, 21, 21, 21, 18, 13, 19, 26, 27, 25, 22, 20, 15,
    22, 27, 29, 27, 25, 22, 16, 21, 24, 22, 22, 19, 16, 11, 22, 26, 25, 24, 21,
    16, 11, 21, 28, 26, 25, 20, 16, 12, 21, 27, 27, 27, 23, 19, 15, 23, 28, 34,
    31, 27, 22, 16, 25, 31, 37, 35, 28, 24, 18, 28, 33, 37, 37, 32, 26, 19, 31,
    35, 33, 29, 22, 18, 14, 30, 36, 36, 30, 23, 18, 15, 29, 35, 37, 31, 24, 20,
    14, 31, 36, 39, 33, 28, 22, 18, 29, 35, 40, 37, 32, 26, 20, 31, 38, 42, 41,
    34, 27, 22, 34, 39, 44, 43, 37, 31, 24, 6,  9,  12, 16, 16, 13, 11, 5,  8,
    12, 15, 16, 12, 9,  3,  7,  10, 13, 14, 11, 7,  2,  5,  8,  10, 13, 9,  6,
    1,  3,  6,  8,  12, 10, 7,  5,  5,  7,  8,  11, 10, 6,  8,  7,  7,  7,  9,
    9,  7,  3,  7,  10, 13, 13, 10, 7,  2,  6,  9,  12, 12, 9,  5,  1,  4,  8,
    10, 10, 7,  3,  1,  2,  5,  7,  7,  5,  3,  3,  2,  4,  6,  6,  5,  3,  7,
    6,  7,  7,  5,  5,  3,  11, 8,  7,  7,  5,  4,  3,  2,  5,  6,  7,  8,  6,
    6,  1,  3,  5,  6,  6,  5,  4,  1,  2,  4,  3,  3,  3,  3,  2,  1,  0,  0,
    0,  0,  2,  6,  4,  4,  4,  4,  3,  2,  9,  8,  6,  6,  5,  4,  2,  13, 10,
    8,  7,  7,  6,  5,  1,  5,  5,  6,  6,  7,  9,  2,  6,  6,  7,  7,  7,  7,
    6,  6,  7,  7,  7,  7,  6,  8,  7,  8,  8,  7,  8,  6,  9,  12, 12, 11, 11,
    10, 9,  10, 15, 15, 14, 13, 12, 11, 12, 18, 17, 15, 14, 14, 13, 12, 13, 13,
    13, 14, 13, 9,  13, 14, 14, 15, 15, 13, 7,  13, 16, 16, 15, 15, 13, 10, 13,
    18, 17, 16, 17, 15, 11, 15, 23, 21, 21, 20, 18, 13, 18, 24, 26, 24, 22, 20,
    14, 20, 25, 28, 25, 23, 22, 16, 22, 24, 22, 21, 19, 15, 11, 22, 25, 24, 23,
    20, 16, 12, 22, 28, 26, 24, 20, 16, 12, 22, 26, 27, 25, 22, 19, 15, 23, 29,
    33, 30, 25, 22, 16, 25, 30, 35, 33, 28, 23, 18, 26, 31, 36, 36, 30, 25, 20,
    30, 34, 31, 26, 22, 18, 14, 30, 33, 33, 28, 22, 19, 14, 29, 33, 35, 28, 23,
    19, 15, 29, 34, 37, 30, 26, 22, 18, 29, 34, 39, 36, 29, 24, 21, 31, 36, 40,
    39, 32, 27, 21, 32, 37, 40, 40, 33, 27, 23, 8,  11, 13, 15, 15, 13, 10, 7,
    10, 12, 15, 15, 12, 8,  6,  8,  11, 13, 14, 10, 7,  5,  7,  9,  10, 12, 9,
    6,  2,  5,  7,  9,  12, 9,  6,  3,  5,  6,  8,  11, 9,  6,  4,  5,  6,  8,
    10, 9,  6,  6,  8,  11, 13, 12, 10, 7,  6,  8,  10, 12, 12, 8,  5,  4,  7,
    9,  10, 9,  7,  4,  2,  5,  7,  8,  7,  5,  3,  1,  3,  6,  7,  6,  5,  3,
    3,  4,  5,  6,  6,  5,  3,  6,  5,  5,  6,  5,  4,  3,  4,  7,  7,  7,  8,
    7,  6,  2,  6,  7,  7,  6,  5,  4,  1,  5,  5,  5,  4,  4,  2,  2,  2,  3,
    3,  3,  2,  0,  3,  3,  2,  2,  2,  1,  0,  5,  4,  3,  2,  3,  1,  0,  9,
    5,  4,  3,  2,  2,  2,  2,  4,  4,  5,  6,  8,  8,  1,  5,  4,  5,  6,  5,
    6,  1,  6,  5,  5,  5,  5,  5,  6,  6,  5,  5,  5,  5,  4,  5,  8,  7,  7,
    7,  7,  6,  6,  10, 9,  8,  8,  8,  7,  9,  14, 12, 10, 10, 9,  9,  11, 11,
    11, 11, 12, 11, 8,  12, 13, 12, 12, 12, 11, 6,  12, 14, 14, 13, 12, 11, 7,
    12, 16, 14, 13, 13, 12, 8,  13, 18, 16, 16, 15, 14, 9,  14, 19, 20, 18, 16,
    14, 10, 15, 20, 22, 21, 18, 16, 12, 19, 21, 18, 18, 16, 13, 9,  19, 22, 20,
    19, 17, 13, 9,  20, 24, 22, 20, 16, 13, 10, 20, 24, 23, 21, 17, 15, 11, 19,
    24, 26, 24, 21, 16, 12, 20, 24, 30, 27, 23, 17, 14, 21, 26, 29, 30, 25, 19,
    14, 26, 30, 27, 22, 18, 14, 12, 26, 30, 30, 23, 18, 15, 12, 26, 30, 32, 24,
    19, 16, 12, 26, 30, 33, 26, 21, 16, 14, 25, 29, 34, 30, 24, 19, 15, 25, 30,
    35, 34, 27, 21, 16, 27, 32, 36, 35, 29, 23, 17, 9,  13, 17, 22, 21, 18, 16,
    8,  12, 16, 20, 21, 18, 15, 7,  10, 14, 18, 20, 17, 13, 6,  9,  12, 15, 17,
    15, 11, 4,  5,  8,  11, 13, 14, 12, 2,  3,  6,  10, 12, 14, 12, 7,  5,  5,
    8,  12, 13, 11, 7,  10, 15, 18, 18, 15, 13, 6,  9,  13, 16, 17, 15, 11, 5,
    8,  11, 14, 15, 13, 9,  5,  6,  9,  11, 12, 11, 6,  2,  3,  5,  8,  9,  10,
    6,  3,  3,  4,  6,  8,  8,  6,  10, 8,  4,  5,  6,  6,  5,  5,  8,  10, 11,
    13, 11, 8,  5,  7,  9,  10, 11, 10, 7,  4,  6,  7,  8,  9,  8,  6,  4,  4,
    5,  5,  5,  6,  3,  0,  2,  1,  1,  1,  2,  3,  6,  6,  5,  4,  1,  2,  3,
    11, 10, 7,  5,  2,  1,  2,  5,  6,  6,  7,  7,  8,  7,  4,  5,  6,  6,  7,
    7,  7,  3,  5,  6,  6,  6,  6,  6,  2,  3,  3,  4,  4,  4,  3,  2,  3,  4,
    4,  4,  3,  3,  6,  8,  7,  7,  6,  5,  5,  11, 13, 9,  8,  8,  7,  6,  6,
    7,  7,  7,  8,  7,  7,  7,  8,  8,  9,  9,  7,  7,  7,  10, 10, 10, 11, 9,
    6,  7,  11, 10, 10, 10, 10, 5,  7,  11, 10, 10, 10, 10, 6,  9,  13, 13, 12,
    11, 10, 8,  12, 15, 15, 13, 12, 11, 9,  14, 15, 14, 14, 13, 9,  7,  14, 16,
    15, 15, 14, 11, 6,  14, 17, 16, 16, 14, 11, 7,  14, 16, 16, 15, 14, 11, 8,
    13, 15, 17, 16, 14, 11, 9,  13, 16, 20, 18, 14, 12, 10, 15, 18, 20, 19, 16,
    13, 10, 18, 23, 21, 17, 15, 12, 8,  18, 22, 23, 18, 16, 13, 9,  18, 23, 24,
    18, 16, 13, 10, 19, 22, 24, 19, 15, 13, 10, 17, 20, 23, 20, 16, 13, 11, 17,
    20, 23, 22, 18, 14, 11, 18, 22, 24, 24, 19, 15, 12, 7,  8,  10, 12, 12, 11,
    9,  6,  8,  9,  12, 12, 9,  8,  6,  7,  8,  10, 11, 8,  6,  6,  6,  6,  7,
    9,  6,  3,  3,  3,  4,  4,  4,  3,  2,  1,  2,  2,  2,  3,  3,  2,  7,  6,
    3,  2,  3,  3,  2,  6,  7,  8,  10, 10, 9,  8,  6,  7,  8,  10, 9,  8,  7,
    5,  6,  7,  8,  8,  7,  5,  4,  5,  5,  6,  5,  5,  2,  2,  2,  2,  3,  2,
    2,  2,  3,  3,  3,  2,  2,  2,  2,  10, 8,  5,  3,  1,  2,  2,  5,  6,  7,
    8,  9,  9,  8,  4,  6,  7,  8,  8,  8,  8,  4,  5,  6,  6,  6,  6,  6,  4,
    4,  4,  4,  4,  4,  3,  2,  0,  1,  1,  1,  2,  3,  6,  5,  5,  3,  1,  1,
    2,  12, 11, 7,  4,  2,  1,  2,  4,  6,  7,  8,  9,  9,  9,  4,  5,  7,  8,
    8,  8,  9,  3,  5,  6,  7,  7,  7,  7,  4,  4,  5,  5,  5,  5,  5,  3,  6,
    6,  6,  7,  7,  7,  6,  12, 11, 10, 9,  7,  8,  12, 17, 14, 12, 10, 9,  9,
    9,  10, 10, 10, 11, 10, 9,  10, 11, 11, 12, 12, 11, 9,  11, 12, 13, 13, 13,
    12, 8,  10, 14, 13, 14, 14, 13, 8,  11, 16, 16, 16, 16, 14, 9,  13, 19, 21,
    20, 19, 16, 11, 17, 22, 24, 22, 20, 18, 12, 18, 20, 20, 20, 17, 13, 9,  18,
    22, 22, 22, 19, 14, 9,  18, 24, 24, 24, 19, 15, 10, 19, 23, 25, 24, 21, 16,
    11, 17, 23, 27, 25, 23, 18, 13, 19, 25, 31, 28, 25, 20, 14, 23, 28, 31, 30,
    26, 22, 16, 27, 33, 32, 26, 21, 16, 11, 26, 32, 33, 28, 23, 17, 12, 27, 32,
    35, 28, 23, 18, 13, 26, 32, 36, 29, 25, 19, 14, 26, 31, 33, 31, 26, 22, 16,
    25, 30, 35, 33, 28, 23, 18, 27, 31, 34, 35, 30, 25, 20, 9,  11, 12, 14, 13,
    13, 12, 8,  11, 12, 13, 13, 11, 10, 6,  10, 11, 12, 12, 10, 8,  5,  8,  9,
    10, 10, 8,  5,  2,  5,  6,  6,  6,  5,  4,  1,  3,  4,  5,  5,  5,  4,  7,
    7,  5,  4,  5,  5,  4,  6,  10, 11, 13, 12, 12, 10, 5,  9,  11, 12, 12, 11,
    9,  4,  7,  10, 11, 10, 9,  7,  4,  5,  7,  8,  8,  7,  4,  2,  2,  4,  5,
    5,  4,  4,  4,  3,  5,  4,  4,  4,  4,  10, 8,  6,  5,  3,  4,  4,  5,  7,
    9,  10, 11, 10, 10, 4,  6,  8,  9,  10, 8,  8,  4,  5,  7,  7,  7,  7,  6,
    4,  3,  3,  3,  4,  4,  2,  2,  1,  0,  0,  0,  1,  2,  6,  5,  4,  3,  2,
    1,  2,  12, 10, 7,  5,  4,  3,  2,  4,  6,  7,  8,  10, 11, 10, 3,  6,  7,
    8,  9,  9,  9,  3,  6,  7,  7,  7,  7,  7,  6,  6,  6,  6,  6,  7,  6,  4,
    8,  7,  8,  8,  8,  8,  7,  13, 12, 11, 10, 9,  9,  12, 18, 15, 13, 11, 10,
    10, 11, 12, 12, 12, 13, 12, 10, 11, 13, 13, 13, 14, 12, 9,  12, 14, 14, 14,
    14, 13, 9,  11, 16, 15, 15, 15, 14, 9,  12, 18, 17, 17, 17, 15, 11, 14, 20,
    21, 21, 19, 16, 12, 18, 23, 26, 23, 21, 18, 13, 20, 22, 22, 22, 19, 15, 11,
    19, 24, 23, 24, 19, 15, 11, 20, 26, 24, 24, 20, 15, 11, 20, 25, 26, 26, 21,
    17, 12, 19, 25, 29, 27, 23, 18, 13, 20, 26, 32, 32, 26, 19, 14, 23, 29, 33,
    35, 28, 22, 16, 27, 35, 33, 28, 21, 17, 13, 29, 34, 36, 29, 23, 18, 13, 28,
    35, 38, 30, 24, 19, 14, 29, 34, 38, 30, 25, 20, 15, 27, 34, 38, 34, 28, 22,
    17, 27, 34, 39, 38, 31, 24, 19, 30, 36, 40, 41, 34, 26, 21, 9,  13, 16, 19,
    18, 17, 14, 8,  11, 15, 18, 18, 16, 13, 6,  10, 14, 16, 16, 13, 10, 5,  8,
    11, 13, 14, 11, 8,  2,  5,  7,  10, 11, 9,  7,  2,  3,  5,  7,  10, 9,  7,
    7,  6,  6,  7,  9,  9,  7,  7,  10, 14, 16, 16, 14, 11, 5,  9,  12, 15, 16,
    13, 9,  4,  7,  11, 13, 13, 11, 7,  4,  5,  8,  10, 10, 9,  4,  2,  2,  4,
    7,  7,  7,  4,  4,  3,  5,  5,  5,  6,  4,  9,  7,  6,  5,  4,  5,  4,  5,
    7,  9,  10, 12, 10, 9,  4,  6,  8,  9,  10, 9,  8,  4,  5,  7,  7,  7,  7,
    5,  4,  3,  3,  3,  4,  4,  2,  1,  1,  0,  0,  0,  1,  2,  6,  5,  4,  3,
    2,  1,  2,  11, 9,  7,  5,  3,  2,  2,  4,  6,  7,  8,  9,  11, 10, 4,  6,
    7,  8,  8,  9,  8,  3,  6,  7,  6,  6,  7,  7,  6,  6,  6,  6,  6,  6,  5,
    5,  8,  7,  7,  8,  8,  7,  7,  13, 12, 11, 10, 9,  9,  11, 17, 15, 13, 11,
    10, 10, 11, 12, 12, 12, 13, 13, 10, 11, 13, 13, 14, 14, 13, 8,  11, 14, 15,
    14, 14, 12, 9,  11, 17, 15, 15, 15, 13, 9,  11, 18, 17, 17, 17, 15, 10, 15,
    21, 22, 21, 19, 16, 12, 19, 23, 25, 23, 21, 18, 13, 21, 22, 22, 21, 19, 15,
    11, 20, 24, 24, 23, 20, 15, 10, 21, 26, 26, 24, 20, 15, 11, 20, 26, 26, 25,
    21, 16, 12, 19, 25, 29, 27, 23, 18, 13, 21, 26, 33, 32, 25, 20, 15, 24, 30,
    33, 33, 28, 22, 16, 28, 35, 33, 27, 21, 17, 13, 29, 35, 36, 29, 22, 18, 13,
    29, 35, 39, 30, 23, 18, 14, 29, 34, 38, 32, 25, 19, 14, 28, 33, 39, 34, 27,
    22, 17, 28, 33, 39, 38, 30, 24, 18, 29, 34, 39, 40, 33, 26, 20, 9,  13, 16,
    20, 20, 18, 15, 8,  12, 15, 19, 20, 17, 13, 7,  10, 14, 17, 18, 14, 11, 5,
    8,  11, 14, 16, 13, 8,  3,  5,  7,  10, 13, 10, 8,  2,  3,  5,  8,  11, 10,
    8,  3,  4,  4,  7,  10, 11, 8,  7,  10, 14, 17, 16, 14, 11, 5,  9,  13, 17,
    16, 12, 9,  5,  8,  11, 14, 14, 11, 7,  4,  6,  8,  11, 10, 9,  4,  2,  2,
    5,  7,  7,  7,  4,  3,  2,  4,  5,  6,  6,  4,  6,  3,  3,  5,  4,  5,  4,
    5,  8,  10, 11, 12, 10, 10, 4,  6,  8,  9,  10, 9,  8,  4,  5,  7,  7,  7,
    7,  5,  4,  4,  3,  4,  4,  4,  2,  1,  1,  0,  0,  0,  1,  2,  5,  3,  3,
    2,  2,  1,  2,  7,  5,  4,  4,  3,  2,  2,  4,  6,  7,  8,  9,  11, 10, 4,
    6,  7,  8,  9,  9,  8,  3,  6,  7,  6,  7,  7,  6,  6,  6,  6,  6,  6,  6,
    5,  5,  8,  8,  8,  8,  7,  7,  5,  10, 10, 10, 10, 8,  8,  7,  13, 12, 11,
    11, 10, 10, 11, 12, 12, 13, 13, 12, 10, 12, 13, 13, 14, 14, 13, 8,  12, 15,
    15, 14, 14, 13, 9,  11, 17, 15, 15, 15, 13, 9,  12, 18, 17, 17, 16, 15, 10,
    14, 19, 21, 19, 19, 16, 12, 15, 20, 23, 21, 21, 18, 13, 22, 22, 22, 21, 19,
    15, 11, 21, 24, 23, 23, 19, 15, 11, 20, 26, 25, 24, 20, 15, 11, 21, 25, 26,
    26, 21, 16, 12, 20, 25, 30, 27, 23, 18, 13, 21, 26, 32, 31, 25, 19, 15, 21,
    26, 32, 31, 27, 21, 16, 29, 35, 32, 26, 22, 17, 13, 29, 34, 35, 29, 23, 18,
    14, 29, 35, 37, 30, 23, 18, 14, 29, 34, 38, 31, 25, 20, 15, 28, 32, 37, 33,
    27, 22, 16, 28, 34, 38, 36, 30, 24, 18, 29, 34, 39, 39, 32, 26, 20, 8,  12,
    16, 19, 20, 17, 14, 7,  11, 15, 19, 19, 16, 12, 6,  9,  13, 16, 17, 14, 10,
    4,  7,  10, 13, 15, 12, 8,  1,  4,  7,  9,  13, 11, 8,  2,  3,  5,  8,  12,
    11, 8,  4,  4,  4,  7,  10, 11, 8,  6,  10, 13, 16, 16, 14, 10, 5,  8,  12,
    15, 16, 12, 8,  3,  7,  11, 13, 13, 10, 6,  3,  5,  8,  10, 9,  8,  4,  1,
    2,  4,  7,  7,  7,  4,  3,  3,  4,  6,  5,  6,  4,  6,  4,  3,  5,  4,  4,
    4,  4,  7,  9,  10, 11, 9,  8,  3,  5,  8,  9,  9,  8,  6,  3,  4,  6,  6,
    6,  6,  4,  3,  2,  3,  3,  3,  3,  1,  2,  2,  1,  1,  1,  0,  1,  4,  3,
    3,  2,  2,  2,  1,  8,  6,  4,  3,  3,  2,  2,  3,  5,  6,  7,  8,  10, 9,
    2,  6,  6,  7,  7,  8,  7,  3,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,  6,
    6,  5,  6,  8,  8,  8,  8,  8,  7,  5,  10, 10, 9,  9,  8,  8,  8,  14, 12,
    11, 10, 10, 10, 11, 12, 12, 12, 13, 13, 9,  12, 14, 13, 14, 14, 12, 7,  12,
    15, 15, 14, 14, 13, 8,  12, 17, 15, 15, 15, 13, 9,  13, 19, 17, 17, 16, 15,
    10, 14, 19, 20, 18, 18, 16, 11, 14, 20, 23, 21, 19, 18, 13, 21, 23, 22, 21,
    18, 14, 10, 22, 25, 23, 23, 19, 15, 11, 21, 26, 25, 23, 19, 15, 11, 21, 25,
    26, 24, 21, 16, 11, 20, 25, 28, 26, 22, 17, 13, 21, 26, 30, 28, 23, 19, 15,
    21, 27, 30, 30, 25, 20, 16, 28, 33, 30, 25, 21, 17, 13, 28, 33, 33, 26, 22,
    18, 13, 29, 33, 35, 27, 22, 18, 14, 29, 32, 35, 29, 23, 19, 15, 27, 32, 36,
    31, 25, 20, 16, 28, 32, 35, 34, 27, 23, 18, 27, 31, 36, 35, 29, 23, 19, 8,
    10, 13, 16, 15, 13, 10, 7,  10, 12, 15, 15, 12, 8,  6,  8,  11, 13, 14, 10,
    7,  5,  6,  9,  10, 13, 9,  6,  2,  5,  7,  9,  12, 9,  6,  3,  5,  6,  8,
    11, 10, 6,  4,  4,  6,  8,  10, 9,  6,  6,  9,  11, 13, 12, 10, 7,  5,  8,
    10, 13, 12, 8,  5,  4,  7,  9,  10, 9,  7,  4,  2,  5,  7,  8,  7,  6,  3,
    1,  3,  5,  7,  6,  5,  3,  3,  3,  5,  6,  5,  5,  3,  6,  4,  5,  6,  5,
    4,  3,  4,  7,  8,  8,  9,  7,  6,  2,  6,  7,  7,  7,  5,  4,  2,  5,  6,
    5,  4,  4,  2,  2,  3,  3,  3,  3,  2,  0,  3,  3,  2,  2,  2,  1,  0,  5,
    4,  3,  2,  2,  1,  0,  8,  5,  3,  3,  2,  2,  1,  2,  4,  4,  5,  7,  8,
    8,  1,  5,  4,  5,  6,  6,  6,  1,  6,  5,  5,  5,  5,  5,  5,  6,  5,  5,
    5,  5,  4,  5,  8,  7,  7,  7,  6,  6,  5,  10, 9,  8,  8,  8,  7,  8,  13,
    12, 10, 9,  9,  9,  11, 11, 11, 11, 12, 11, 8,  12, 12, 12, 13, 12, 11, 6,
    12, 14, 14, 13, 12, 11, 7,  12, 16, 14, 13, 13, 12, 8,  13, 18, 16, 16, 15,
    13, 9,  14, 19, 20, 17, 16, 14, 10, 15, 20, 23, 20, 18, 16, 12, 20, 21, 19,
    18, 15, 13, 9,  20, 22, 20, 18, 16, 13, 9,  20, 24, 22, 20, 16, 13, 10, 20,
    24, 23, 21, 17, 14, 11, 19, 23, 26, 24, 20, 16, 12, 20, 24, 30, 28, 23, 17,
    14, 21, 26, 29, 30, 25, 19, 14, 26, 30, 28, 22, 17, 15, 12, 26, 30, 29, 24,
    18, 15, 11, 26, 30, 32, 25, 19, 16, 12, 25, 29, 33, 26, 21, 17, 13, 25, 29,
    33, 30, 24, 20, 15, 26, 31, 35, 34, 27, 20, 16, 27, 32, 35, 35, 29, 23, 17,
    14, 17, 21, 24, 24, 22, 19, 13, 16, 20, 24, 25, 21, 18, 12, 15, 18, 21, 23,
    19, 15, 12, 13, 15, 17, 21, 16, 12, 9,  9,  11, 14, 14, 15, 12, 5,  5,  8,
    11, 13, 14, 12, 2,  3,  6,  9,  13, 15, 12, 13, 15, 19, 21, 22, 19, 17, 12,
    14, 17, 20, 21, 18, 14, 11, 13, 15, 18, 18, 16, 12, 11, 11, 13, 14, 15, 12,
    7,  8,  8,  9,  10, 9,  10, 7,  3,  3,  5,  7,  9,  9,  7,  3,  3,  3,  6,
    8,  8,  7,  11, 13, 14, 16, 18, 17, 15, 11, 12, 14, 15, 16, 15, 14, 10, 11,
    13, 13, 13, 13, 12, 10, 10, 10, 10, 11, 9,  5,  6,  6,  6,  6,  5,  5,  5,
    0,  2,  1,  2,  4,  4,  5,  4,  4,  2,  1,  3,  4,  5,  10, 11, 13, 14, 15,
    16, 15, 10, 11, 12, 14, 14, 15, 14, 9,  10, 12, 12, 12, 13, 12, 6,  9,  9,
    9,  10, 9,  7,  4,  5,  4,  5,  5,  4,  4,  0,  2,  2,  2,  3,  3,  5,  4,
    6,  3,  3,  3,  4,  5,  9,  10, 12, 13, 14, 15, 15, 8,  9,  11, 12, 13, 13,
    14, 8,  9,  10, 10, 11, 11, 12, 8,  8,  8,  8,  9,  8,  5,  5,  8,  7,  7,
    7,  6,  5,  4,  7,  7,  7,  7,  7,  5,  5,  8,  9,  8,  8,  8,  5,  11, 12,
    12, 13, 12, 14, 15, 11, 13, 13, 13, 12, 12, 13, 11, 14, 14, 13, 11, 10, 11,
    11, 13, 13, 13, 11, 9,  5,  9,  11, 13, 12, 10, 8,  5,  8,  11, 14, 13, 11,
    8,  6,  8,  12, 15, 15, 11, 9,  7,  15, 19, 18, 15, 13, 13, 14, 15, 19, 20,
    16, 13, 11, 12, 15, 18, 21, 16, 14, 11, 9,  15, 18, 20, 15, 13, 9,  6,  14,
    16, 19, 16, 11, 9,  7,  13, 15, 18, 17, 13, 10, 8,  12, 16, 19, 19, 14, 11,
    8,  12, 14, 15, 17, 17, 16, 14, 12, 13, 15, 16, 17, 14, 13, 11, 12, 14, 15,
    15, 12, 11, 10, 11, 11, 12, 12, 8,  4,  8,  8,  8,  8,  6,  5,  4,  4,  4,
    4,  3,  4,  5,  4,  2,  2,  2,  3,  4,  5,  4,  11, 13, 14, 15, 16, 15, 14,
    10, 12, 13, 15, 15, 14, 12, 10, 11, 13, 13, 13, 12, 10, 9,  10, 10, 10, 11,
    9,  4,  7,  7,  7,  7,  4,  4,  4,  2,  3,  3,  3,  3,  4,  4,  5,  4,  2,
    2,  3,  3,  4,  10, 11, 13, 14, 15, 15, 15, 9,  10, 12, 13, 14, 14, 13, 9,
    10, 12, 12, 12, 11, 10, 9,  9,  9,  9,  9,  8,  4,  5,  5,  5,  5,  3,  3,
    4,  2,  0,  1,  2,  2,  3,  4,  7,  6,  2,  0,  3,  3,  4,  10, 11, 12, 13,
    15, 16, 16, 9,  11, 12, 13, 14, 14, 14, 8,  11, 12, 12, 12, 12, 11, 5,  9,
    9,  9,  9,  8,  7,  3,  5,  5,  5,  5,  5,  5,  2,  7,  7,  6,  6,  6,  7,
    7,  13, 10, 8,  8,  8,  8,  10, 11, 12, 13, 14, 16, 16, 9,  10, 11, 13, 14,
    14, 14, 9,  11, 11, 11, 12, 12, 11, 9,  12, 11, 12, 12, 11, 7,  8,  13, 14,
    13, 14, 13, 9,  9,  15, 17, 17, 16, 15, 10, 12, 17, 19, 18, 18, 16, 11, 16,
    19, 18, 19, 16, 15, 16, 16, 21, 21, 21, 17, 13, 13, 16, 22, 23, 21, 17, 12,
    10, 16, 22, 23, 23, 19, 14, 10, 15, 21, 25, 23, 21, 17, 11, 16, 22, 27, 25,
    21, 18, 13, 18, 22, 26, 25, 23, 20, 15, 25, 30, 29, 25, 19, 15, 14, 25, 30,
    31, 26, 20, 15, 12, 25, 30, 33, 26, 21, 16, 11, 25, 30, 34, 28, 22, 18, 14,
    24, 29, 32, 27, 23, 20, 16, 24, 27, 30, 29, 24, 21, 17, 23, 27, 30, 30, 25,
    22, 19, 13, 16, 17, 18, 18, 17, 16, 12, 15, 17, 18, 18, 16, 14, 11, 14, 16,
    16, 15, 13, 11, 10, 12, 13, 13, 13, 10, 5,  7,  9,  10, 10, 8,  6,  5,  3,
    5,  7,  5,  6,  6,  5,  2,  3,  5,  5,  6,  6,  5,  11, 14, 16, 17, 17, 17,
    15, 10, 13, 15, 16, 17, 15, 13, 9,  12, 15, 15, 14, 13, 10, 9,  9,  12, 13,
    11, 9,  5,  7,  6,  8,  9,  6,  5,  5,  2,  2,  5,  5,  5,  5,  5,  5,  3,
    3,  5,  4,  5,  5,  9,  12, 14, 15, 16, 15, 14, 9,  10, 12, 14, 15, 13, 12,
    9,  10, 11, 11, 11, 11, 9,  9,  8,  8,  8,  8,  7,  3,  5,  5,  5,  4,  3,
    3,  3,  1,  1,  0,  1,  2,  3,  3,  6,  5,  3,  1,  2,  3,  3,  9,  11, 11,
    13, 15, 15, 15, 9,  11, 12, 13, 14, 14, 13, 7,  11, 11, 11, 11, 11, 10, 5,
    9,  8,  8,  8,  7,  7,  3,  5,  5,  6,  6,  6,  6,  2,  8,  8,  7,  7,  8,
    8,  6,  12, 11, 9,  9,  9,  9,  10, 10, 11, 13, 14, 15, 15, 9,  11, 12, 13,
    13, 13, 13, 10, 12, 13, 13, 13, 11, 9,  10, 13, 13, 13, 13, 12, 8,  9,  15,
    14, 15, 15, 14, 9,  10, 16, 18, 17, 17, 15, 11, 13, 18, 21, 18, 18, 17, 13,
    18, 20, 20, 20, 17, 15, 15, 18, 22, 21, 21, 18, 13, 12, 18, 24, 24, 23, 18,
    14, 10, 18, 23, 25, 24, 20, 15, 11, 18, 23, 27, 26, 21, 17, 13, 17, 23, 29,
    28, 24, 18, 14, 19, 25, 29, 31, 26, 20, 16, 27, 33, 32, 25, 20, 16, 14, 26,
    32, 34, 27, 22, 17, 12, 27, 33, 36, 28, 22, 17, 12, 27, 32, 37, 29, 24, 19,
    14, 25, 31, 37, 32, 26, 20, 16, 25, 31, 36, 35, 28, 22, 17, 26, 32, 37, 37,
    30, 24, 19, 12, 16, 19, 22, 22, 20, 18, 12, 15, 18, 21, 21, 19, 15, 10, 13,
    17, 19, 19, 17, 13, 8,  11, 14, 16, 17, 13, 8,  6,  8,  10, 12, 12, 10, 8,
    2,  4,  7,  9,  11, 10, 8,  2,  3,  5,  8,  10, 10, 8,  10, 13, 17, 20, 20,
    17, 14, 9,  12, 16, 19, 19, 16, 12, 8,  11, 14, 17, 16, 14, 9,  8,  9,  11,
    13, 13, 11, 5,  5,  5,  8,  10, 8,  8,  5,  1,  2,  4,  6,  6,  7,  5,  4,
    3,  3,  5,  5,  6,  5,  8,  11, 13, 14, 16, 13, 13, 8,  9,  12, 13, 14, 12,
    11, 7,  8,  10, 10, 10, 10, 7,  8,  7,  7,  7,  7,  6,  2,  4,  3,  3,  3,
    2,  2,  2,  2,  2,  1,  0,  1,  2,  2,  4,  3,  2,  2,  1,  2,  2,  8,  9,
    10, 11, 13, 14, 14, 8,  9,  10, 11, 12, 12, 11, 5,  9,  10, 9,  9,  9,  8,
    5,  8,  7,  6,  7,  6,  6,  3,  6,  6,  6,  6,  6,  6,  2,  8,  8,  7,  7,
    7,  7,  4,  11, 10, 9,  9,  9,  9,  9,  11, 11, 12, 13, 13, 13, 9,  11, 12,
    12, 13, 12, 11, 10, 13, 14, 13, 13, 11, 8,  10, 15, 13, 14, 14, 12, 8,  10,
    16, 15, 15, 15, 13, 9,  11, 16, 18, 17, 16, 14, 11, 12, 17, 20, 19, 18, 17,
    12, 19, 21, 20, 20, 18, 14, 13, 18, 23, 22, 22, 18, 14, 10, 19, 24, 24, 23,
    19, 14, 10, 19, 24, 25, 23, 20, 15, 10, 18, 24, 28, 26, 21, 17, 12, 18, 24,
    30, 29, 23, 18, 13, 18, 24, 30, 30, 25, 19, 15, 27, 34, 32, 26, 20, 16, 12,
    27, 34, 34, 28, 22, 17, 12, 27, 34, 37, 28, 22, 17, 13, 28, 33, 37, 30, 23,
    18, 14, 26, 32, 36, 33, 25, 19, 15, 26, 31, 36, 34, 28, 21, 17, 26, 31, 36,
    37, 29, 24, 18, 11, 15, 18, 21, 22, 20, 16, 10, 14, 17, 21, 22, 18, 14, 8,
    12, 16, 19, 20, 16, 12, 7,  10, 13, 16, 18, 14, 9,  4,  7,  9,  12, 14, 12,
    9,  0,  3,  6,  9,  13, 12, 9,  3,  3,  5,  8,  11, 12, 9,  8,  12, 16, 19,
    18, 16, 12, 7,  11, 14, 18, 18, 14, 10, 6,  10, 13, 16, 15, 13, 9,  6,  7,
    10, 12, 12, 10, 5,  3,  4,  6,  9,  9,  8,  5,  2,  2,  4,  6,  7,  7,  5,
    5,  4,  3,  6,  5,  6,  5,  6,  10, 11, 13, 14, 12, 11, 5,  8,  10, 11, 12,
    11, 8,  5,  7,  9,  9,  9,  9,  6,  6,  5,  5,  5,  6,  5,  3,  1,  1,  2,
    2,  2,  2,  2,  4,  3,  2,  1,  0,  1,  2,  7,  4,  3,  2,  1,  1,  2,  6,
    7,  8,  9,  10, 12, 11, 5,  7,  8,  9,  9,  9,  9,  4,  7,  7,  7,  7,  7,
    6,  5,  6,  6,  5,  5,  5,  5,  3,  7,  6,  6,  6,  6,  6,  4,  9,  8,  8,
    8,  7,  7,  7,  12, 10, 9,  9,  9,  9,  10, 11, 11, 11, 12, 12, 11, 11, 12,
    12, 13, 13, 11, 9,  11, 14, 14, 13, 13, 11, 8,  11, 15, 14, 13, 14, 12, 8,
    11, 17, 16, 15, 15, 13, 9,  12, 17, 18, 17, 16, 15, 10, 13, 17, 20, 19, 18,
    16, 12, 20, 21, 20, 21, 18, 14, 11, 20, 23, 23, 23, 19, 14, 9,  19, 25, 24,
    23, 19, 14, 10, 20, 24, 26, 24, 20, 15, 11, 18, 24, 27, 26, 21, 16, 12, 19,
    23, 30, 29, 23, 18, 14, 19, 24, 29, 31, 25, 20, 15, 28, 34, 32, 26, 21, 16,
    12, 27, 34, 34, 27, 21, 17, 12, 27, 33, 36, 29, 23, 18, 13, 28, 32, 37, 29,
    24, 19, 13, 26, 32, 36, 33, 25, 20, 15, 26, 32, 37, 33, 28, 22, 17, 27, 32,
    35, 36, 30, 23, 18, 10, 14, 18, 21, 21, 18, 15, 9,  12, 16, 20, 21, 17, 13,
    7,  11, 15, 18, 19, 16, 11, 6,  9,  12, 14, 16, 14, 9,  3,  6,  8,  11, 14,
    12, 9,  2,  4,  6,  9,  13, 12, 9,  4,  4,  5,  8,  11, 12, 9,  7,  11, 14,
    18, 18, 15, 11, 6,  10, 13, 17, 17, 13, 9,  5,  8,  12, 14, 14, 12, 8,  4,
    6,  9,  11, 11, 10, 5,  1,  3,  5,  8,  8,  8,  5,  2,  3,  4,  7,  7,  7,
    5,  6,  4,  4,  6,  5,  6,  5,  5,  8,  10, 11, 13, 11, 9,  3,  7,  9,  10,
    11, 9,  7,  3,  6,  7,  8,  7,  7,  4,  3,  3,  4,  4,  4,  4,  1,  2,  1,
    1,  1,  1,  2,  1,  4,  3,  2,  2,  1,  0,  1,  8,  6,  3,  3,  2,  1,  1,
    3,  5,  6,  7,  8,  10, 9,  3,  5,  6,  7,  8,  8,  7,  2,  5,  6,  6,  5,
    6,  5,  5,  6,  6,  5,  5,  5,  4,  4,  8,  7,  6,  7,  6,  6,  4,  10, 8,
    8,  8,  8,  7,  8,  12, 11, 10, 9,  9,  9,  11, 11, 11, 11, 12, 12, 9,  12,
    13, 12, 13, 13, 12, 7,  12, 14, 14, 13, 12, 11, 8,  11, 16, 14, 14, 14, 12,
    8,  12, 18, 17, 15, 16, 13, 9,  13, 18, 19, 18, 16, 15, 11, 14, 18, 21, 19,
    19, 16, 12, 20, 21, 20, 20, 17, 14, 10, 20, 23, 22, 22, 18, 14, 9,  20, 25,
    24, 23, 19, 14, 10, 20, 25, 24, 23, 20, 15, 10, 19, 25, 26, 25, 21, 16, 12,
    20, 25, 29, 28, 22, 18, 14, 20, 25, 29, 30, 24, 19, 15, 28, 33, 29, 24, 20,
    16, 12, 28, 32, 31, 26, 21, 16, 12, 28, 32, 34, 27, 23, 17, 13, 27, 31, 35,
    28, 23, 18, 14, 26, 31, 34, 31, 24, 20, 15, 26, 31, 35, 33, 26, 21, 17, 27,
    30, 35, 35, 29, 22, 18, 8,  11, 12, 16, 15, 13, 10, 7,  10, 12, 15, 15, 12,
    8,  6,  8,  11, 13, 14, 10, 7,  5,  6,  9,  10, 12, 9,  6,  2,  5,  7,  9,
    12, 9,  6,  3,  5,  6,  8,  11, 9,  6,  4,  5,  6,  8,  10, 9,  6,  6,  9,
    11, 13, 12, 10, 7,  5,  8,  10, 12, 12, 8,  5,  4,  7,  9,  10, 9,  7,  4,
    2,  5,  7,  8,  7,  6,  3,  1,  3,  5,  7,  6,  5,  3,  3,  3,  5,  6,  5,
    5,  3,  6,  4,  5,  6,  5,  4,  3,  4,  7,  8,  8,  9,  7,  6,  2,  6,  7,
    7,  7,  5,  4,  2,  5,  6,  5,  4,  4,  2,  2,  3,  3,  3,  3,  2,  0,  3,
    2,  2,  2,  2,  1,  0,  5,  4,  3,  2,  2,  1,  0,  8,  6,  3,  2,  2,  2,
    1,  2,  4,  4,  5,  6,  7,  8,  1,  4,  4,  5,  6,  5,  6,  1,  6,  5,  5,
    5,  5,  5,  5,  6,  5,  5,  5,  5,  4,  5,  8,  7,  7,  7,  7,  6,  5,  10,
    9,  8,  8,  8,  7,  8,  13, 12, 10, 9,  9,  9,  11, 11, 11, 11, 12, 11, 8,
    12, 12, 13, 12, 12, 11, 6,  12, 14, 14, 13, 12, 11, 7,  12, 16, 14, 13, 13,
    12, 8,  12, 18, 17, 15, 15, 13, 9,  13, 19, 20, 18, 16, 14, 10, 14, 20, 23,
    20, 18, 16, 11, 20, 20, 19, 17, 15, 13, 9,  20, 22, 20, 19, 16, 13, 9,  20,
    23, 22, 20, 17, 13, 10, 19, 24, 24, 21, 17, 14, 11, 19, 24, 26, 24, 20, 16,
    12, 20, 24, 30, 27, 22, 17, 13, 21, 25, 30, 29, 24, 19, 14, 26, 30, 27, 21,
    17, 14, 12, 26, 30, 29, 23, 18, 15, 12, 26, 30, 32, 25, 19, 16, 12, 26, 29,
    33, 26, 21, 17, 13, 25, 29, 33, 30, 24, 19, 15, 25, 31, 34, 34, 27, 21, 16,
    27, 32, 35, 35, 29, 23, 17, 20, 21, 23, 25, 26, 24, 23, 20, 21, 23, 24, 25,
    23, 20, 19, 21, 21, 23, 24, 20, 16, 18, 19, 19, 19, 20, 15, 11, 15, 15, 15,
    14, 14, 15, 10, 11, 11, 8,  10, 12, 14, 10, 5,  3,  5,  8,  11, 14, 10, 19,
    20, 22, 24, 24, 23, 22, 18, 20, 21, 23, 24, 22, 20, 17, 19, 20, 20, 21, 18,
    16, 17, 17, 18, 18, 16, 13, 8,  14, 14, 14, 12, 9,  9,  8,  9,  9,  7,  6,
    8,  8,  8,  2,  2,  4,  5,  7,  8,  8,  17, 19, 20, 21, 23, 24, 22, 17, 18,
    20, 21, 22, 21, 19, 17, 18, 19, 19, 19, 18, 15, 16, 16, 16, 16, 15, 12, 9,
    11, 12, 12, 11, 7,  8,  8,  4,  7,  6,  4,  6,  8,  8,  0,  2,  2,  4,  6,
    6,  8,  17, 18, 20, 21, 22, 23, 23, 16, 18, 20, 20, 21, 21, 21, 14, 19, 19,
    19, 18, 18, 17, 10, 17, 16, 16, 15, 11, 11, 8,  12, 12, 10, 6,  7,  8,  5,
    5,  5,  3,  4,  6,  7,  0,  3,  3,  3,  4,  5,  6,  15, 17, 19, 20, 21, 23,
    23, 12, 17, 18, 20, 20, 20, 21, 12, 16, 16, 17, 17, 16, 15, 12, 13, 13, 13,
    12, 10, 7,  9,  9,  8,  8,  7,  6,  6,  6,  7,  7,  6,  7,  7,  6,  4,  6,
    8,  7,  7,  8,  6,  13, 14, 15, 16, 18, 21, 23, 13, 14, 15, 16, 17, 19, 19,
    13, 14, 15, 15, 14, 15, 14, 13, 13, 13, 13, 12, 9,  6,  10, 12, 13, 12, 9,
    8,  6,  9,  10, 13, 13, 10, 8,  6,  7,  10, 14, 14, 11, 8,  7,  16, 19, 18,
    16, 17, 20, 21, 16, 19, 20, 17, 15, 17, 18, 16, 18, 21, 16, 14, 13, 13, 16,
    17, 20, 15, 12, 10, 7,  14, 16, 18, 15, 11, 9,  7,  12, 15, 17, 16, 12, 10,
    8,  11, 15, 18, 17, 13, 10, 8,  18, 19, 21, 22, 22, 21, 21, 18, 19, 20, 22,
    22, 19, 18, 17, 18, 19, 20, 19, 17, 14, 17, 17, 17, 17, 15, 12, 8,  14, 13,
    13, 11, 9,  8,  8,  10, 10, 7,  7,  8,  9,  8,  4,  2,  4,  6,  8,  8,  8,
    17, 19, 20, 21, 22, 21, 20, 16, 18, 19, 20, 21, 19, 17, 16, 17, 19, 19, 18,
    16, 13, 16, 16, 16, 16, 14, 11, 7,  14, 12, 12, 11, 7,  7,  7,  9,  8,  6,
    5,  6,  7,  7,  2,  2,  3,  4,  6,  6,  7,  16, 17, 18, 20, 21, 21, 21, 16,
    17, 18, 19, 20, 19, 18, 15, 17, 17, 17, 16, 16, 13, 15, 15, 14, 14, 13, 10,
    6,  10, 11, 11, 9,  5,  6,  6,  4,  6,  5,  3,  4,  5,  6,  2,  0,  2,  3,
    4,  5,  6,  16, 17, 18, 19, 21, 22, 22, 15, 17, 19, 19, 20, 19, 19, 13, 17,
    18, 18, 17, 16, 15, 9,  16, 15, 15, 14, 10, 11, 7,  12, 11, 10, 5,  5,  7,
    4,  6,  5,  5,  5,  5,  6,  2,  7,  6,  6,  6,  6,  7,  15, 17, 18, 20, 20,
    22, 22, 12, 16, 18, 18, 19, 19, 19, 12, 15, 16, 16, 16, 15, 13, 12, 13, 13,
    13, 12, 10, 6,  10, 10, 11, 11, 13, 11, 7,  7,  11, 14, 14, 15, 13, 8,  8,
    13, 16, 16, 16, 15, 10, 14, 16, 17, 17, 19, 21, 21, 14, 18, 18, 19, 17, 18,
    18, 14, 19, 20, 19, 16, 14, 13, 14, 19, 21, 21, 17, 12, 8,  12, 18, 22, 21,
    18, 16, 10, 12, 19, 22, 20, 19, 17, 12, 14, 19, 22, 21, 20, 17, 13, 22, 27,
    27, 22, 18, 20, 20, 22, 28, 29, 24, 18, 17, 17, 22, 27, 30, 24, 19, 14, 12,
    22, 26, 30, 24, 20, 16, 12, 20, 25, 29, 24, 19, 17, 14, 20, 25, 26, 25, 20,
    18, 15, 21, 23, 25, 25, 22, 19, 17, 16, 19, 19, 21, 20, 20, 19, 15, 18, 19,
    20, 20, 18, 16, 14, 16, 18, 19, 18, 15, 13, 13, 15, 16, 15, 15, 11, 7,  10,
    11, 12, 11, 9,  7,  6,  6,  8,  8,  6,  7,  7,  6,  1,  3,  5,  6,  7,  7,
    6,  14, 17, 19, 19, 20, 19, 18, 13, 16, 18, 19, 19, 17, 15, 12, 14, 18, 17,
    16, 15, 12, 12, 12, 14, 15, 13, 10, 6,  9,  9,  11, 10, 7,  6,  6,  5,  5,
    7,  6,  6,  6,  6,  2,  1,  4,  5,  5,  6,  6,  12, 15, 16, 18, 19, 18, 17,
    12, 13, 16, 17, 17, 16, 14, 12, 12, 14, 14, 14, 13, 10, 11, 11, 10, 11, 10,
    8,  4,  7,  7,  7,  7,  4,  4,  3,  2,  2,  3,  2,  3,  3,  3,  2,  2,  0,
    2,  3,  4,  4,  12, 13, 14, 16, 17, 18, 17, 11, 13, 14, 15, 16, 16, 14, 9,
    13, 13, 14, 13, 13, 11, 6,  12, 11, 11, 10, 8,  8,  4,  8,  7,  7,  5,  5,
    6,  2,  6,  6,  6,  6,  6,  6,  2,  8,  8,  7,  7,  7,  8,  12, 12, 14, 15,
    16, 17, 17, 10, 12, 13, 14, 15, 15, 15, 10, 12, 12, 12, 12, 12, 10, 10, 12,
    11, 12, 12, 10, 7,  8,  13, 13, 13, 14, 12, 8,  8,  14, 16, 16, 16, 14, 9,
    10, 15, 18, 17, 18, 16, 11, 16, 19, 18, 19, 16, 17, 17, 15, 20, 20, 20, 16,
    14, 14, 15, 22, 22, 20, 17, 12, 10, 16, 21, 22, 23, 18, 13, 10, 15, 21, 25,
    24, 20, 16, 11, 15, 21, 27, 27, 22, 17, 12, 17, 22, 29, 30, 24, 19, 14, 24,
    31, 30, 24, 19, 16, 16, 25, 31, 33, 26, 19, 15, 13, 24, 30, 35, 27, 21, 16,
    11, 24, 30, 35, 27, 22, 17, 13, 24, 29, 35, 31, 24, 19, 14, 24, 29, 34, 34,
    27, 21, 16, 24, 30, 34, 35, 29, 23, 18, 14, 18, 21, 23, 23, 22, 19, 13, 17,
    20, 22, 23, 20, 17, 11, 15, 19, 20, 20, 18, 15, 10, 13, 16, 18, 18, 14, 9,
    7,  10, 12, 14, 14, 11, 9,  4,  6,  8,  10, 12, 11, 9,  2,  3,  6,  9,  11,
    11, 9,  12, 15, 19, 21, 21, 19, 16, 11, 14, 18, 21, 20, 17, 13, 9,  12, 16,
    18, 18, 15, 11, 9,  10, 13, 16, 14, 12, 7,  6,  7,  9,  11, 10, 9,  6,  2,
    3,  6,  8,  8,  8,  6,  4,  2,  4,  7,  7,  7,  6,  9,  13, 14, 16, 17, 16,
    14, 9,  11, 13, 15, 15, 13, 11, 9,  10, 12, 12, 12, 11, 8,  9,  8,  8,  9,
    9,  7,  3,  5,  4,  5,  5,  4,  3,  2,  1,  0,  1,  1,  2,  3,  2,  4,  3,
    2,  0,  2,  2,  3,  9,  10, 11, 12, 13, 14, 14, 9,  10, 11, 12, 13, 12, 12,
    7,  10, 10, 10, 10, 10, 9,  4,  9,  7,  7,  7,  6,  6,  2,  5,  4,  5,  5,
    5,  5,  1,  7,  6,  6,  6,  6,  6,  4,  9,  9,  8,  7,  7,  8,  9,  10, 10,
    12, 13, 14, 14, 9,  10, 11, 12, 12, 12, 12, 9,  12, 12, 12, 12, 10, 8,  9,
    13, 12, 12, 13, 11, 7,  8,  14, 13, 13, 13, 12, 8,  10, 15, 17, 16, 15, 13,
    9,  11, 16, 19, 17, 17, 15, 10, 17, 19, 18, 18, 16, 14, 14, 17, 21, 21, 20,
    17, 12, 11, 17, 23, 22, 21, 18, 13, 9,  17, 22, 24, 22, 19, 14, 9,  17, 21,
    26, 24, 20, 16, 10, 16, 22, 28, 27, 22, 16, 12, 16, 23, 28, 29, 24, 18, 13,
    26, 32, 31, 24, 19, 15, 13, 26, 31, 33, 26, 20, 15, 11, 25, 31, 34, 27, 21,
    16, 11, 26, 31, 36, 29, 22, 17, 12, 24, 30, 35, 32, 23, 18, 14, 25, 30, 35,
    33, 26, 21, 15, 25, 30, 35, 35, 29, 23, 17, 12, 16, 20, 23, 23, 20, 18, 12,
    15, 19, 22, 23, 19, 16, 10, 14, 17, 20, 21, 17, 14, 9,  11, 14, 17, 19, 15,
    10, 5,  8,  10, 13, 15, 13, 10, 2,  5,  7,  10, 13, 13, 10, 3,  3,  6,  9,
    12, 12, 10, 10, 14, 17, 21, 20, 17, 14, 9,  12, 16, 19, 20, 16, 12, 7,  11,
    15, 17, 17, 14, 10, 6,  8,  11, 13, 13, 12, 6,  4,  5,  8,  10, 9,  9,  6,
    1,  3,  5,  7,  8,  8,  6,  5,  3,  4,  6,  6,  7,  6,  7,  11, 13, 14, 15,
    13, 11, 6,  9,  12, 13, 13, 12, 9,  6,  8,  10, 10, 10, 10, 6,  6,  6,  7,
    7,  7,  7,  2,  2,  2,  3,  3,  3,  3,  2,  3,  3,  2,  1,  1,  2,  2,  5,
    4,  3,  2,  0,  1,  2,  6,  7,  8,  9,  11, 12, 11, 6,  7,  8,  9,  10, 10,
    9,  5,  7,  7,  7,  7,  7,  6,  3,  6,  5,  5,  5,  4,  5,  2,  6,  5,  5,
    5,  5,  5,  3,  8,  7,  7,  7,  6,  6,  5,  11, 9,  8,  8,  8,  8,  9,  10,
    10, 11, 11, 12, 11, 10, 11, 11, 12, 12, 11, 9,  10, 12, 13, 12, 12, 11, 7,
    10, 14, 13, 12, 13, 11, 7,  10, 16, 14, 14, 14, 12, 8,  11, 16, 17, 16, 15,
    13, 9,  12, 16, 20, 18, 17, 15, 11, 18, 20, 20, 19, 16, 13, 11, 18, 22, 21,
    21, 18, 13, 9,  19, 24, 24, 22, 18, 13, 9,  19, 23, 25, 23, 19, 14, 10, 17,
    23, 26, 25, 20, 15, 11, 18, 23, 28, 27, 22, 17, 13, 18, 24, 29, 29, 24, 19,
    14, 27, 32, 31, 25, 19, 15, 11, 27, 32, 33, 26, 21, 16, 11, 27, 33, 35, 27,
    22, 17, 12, 26, 32, 36, 29, 22, 18, 12, 26, 31, 36, 32, 24, 19, 14, 25, 30,
    36, 34, 26, 20, 16, 25, 30, 35, 36, 29, 23, 17, 11, 15, 19, 22, 22, 20, 17,
    10, 14, 17, 21, 22, 18, 15, 9,  12, 16, 19, 20, 17, 12, 7,  10, 13, 16, 18,
    15, 10, 4,  7,  9,  12, 15, 13, 10, 2,  5,  7,  10, 14, 13, 10, 4,  4,  6,
    9,  12, 13, 10, 9,  12, 16, 20, 19, 16, 12, 7,  11, 15, 18, 18, 15, 11, 6,
    9,  13, 16, 16, 13, 9,  5,  7,  10, 13, 12, 11, 6,  1,  4,  7,  9,  9,  9,
    6,  3,  3,  5,  8,  8,  8,  6,  5,  4,  5,  7,  7,  7,  6,  6,  10, 12, 12,
    14, 12, 9,  4,  8,  10, 12, 12, 11, 7,  4,  7,  9,  9,  9,  9,  5,  4,  5,
    6,  5,  6,  6,  2,  1,  1,  3,  2,  2,  2,  2,  4,  3,  3,  2,  1,  1,  2,
    7,  5,  4,  2,  1,  0,  1,  4,  5,  6,  7,  9,  10, 9,  4,  5,  6,  7,  8,
    8,  7,  4,  5,  6,  5,  5,  5,  5,  4,  5,  4,  4,  4,  4,  3,  2,  6,  5,
    5,  5,  5,  5,  4,  8,  7,  7,  7,  6,  6,  7,  12, 9,  9,  8,  8,  8,  10,
    10, 10, 11, 11, 11, 9,  11, 12, 11, 12, 12, 10, 7,  11, 13, 13, 12, 12, 10,
    7,  11, 15, 13, 13, 13, 11, 7,  11, 16, 15, 14, 14, 12, 8,  12, 17, 17, 16,
    16, 13, 9,  13, 17, 21, 18, 17, 16, 11, 20, 20, 19, 19, 16, 13, 9,  19, 22,
    21, 20, 18, 13, 9,  19, 24, 23, 22, 17, 13, 9,  19, 23, 25, 22, 18, 14, 9,
    18, 23, 26, 24, 20, 16, 11, 18, 23, 28, 27, 21, 17, 13, 19, 23, 29, 29, 24,
    19, 14, 27, 31, 29, 24, 20, 16, 11, 26, 30, 31, 25, 20, 16, 12, 27, 32, 33,
    27, 21, 16, 11, 27, 31, 34, 28, 22, 17, 12, 26, 29, 34, 30, 23, 19, 14, 25,
    30, 34, 32, 25, 21, 16, 25, 30, 35, 34, 28, 22, 17, 10, 14, 17, 19, 19, 17,
    14, 9,  13, 15, 18, 19, 16, 13, 8,  11, 14, 16, 18, 15, 11, 7,  9,  12, 15,
    17, 13, 10, 3,  6,  9,  12, 15, 13, 10, 3,  5,  8,  10, 14, 13, 10, 5,  4,
    7,  10, 12, 13, 10, 8,  11, 15, 17, 16, 14, 11, 7,  10, 14, 16, 15, 13, 10,
    5,  9,  12, 15, 13, 12, 8,  4,  6,  9,  12, 11, 10, 6,  1,  4,  7,  9,  9,
    9,  6,  3,  4,  5,  8,  8,  8,  6,  7,  5,  5,  7,  7,  7,  6,  5,  9,  11,
    11, 12, 11, 8,  3,  7,  10, 10, 11, 9,  5,  2,  6,  8,  8,  8,  8,  3,  2,
    4,  5,  5,  5,  5,  2,  2,  2,  3,  2,  2,  2,  1,  5,  4,  3,  2,  2,  1,
    1,  8,  6,  4,  3,  2,  1,  0,  2,  4,  4,  6,  7,  9,  8,  2,  3,  4,  6,
    6,  6,  6,  1,  4,  4,  4,  4,  4,  4,  4,  5,  4,  4,  4,  4,  3,  3,  8,
    6,  5,  5,  5,  5,  5,  10, 8,  7,  7,  6,  6,  8,  13, 10, 9,  8,  8,  7,
    10, 10, 10, 10, 11, 10, 8,  11, 12, 11, 11, 11, 10, 6,  12, 13, 12, 12, 11,
    10, 6,  12, 15, 13, 12, 12, 11, 6,  12, 17, 15, 14, 13, 12, 8,  13, 17, 18,
    16, 15, 13, 9,  13, 18, 20, 17, 16, 14, 10, 19, 19, 18, 17, 15, 12, 8,  19,
    20, 19, 18, 16, 12, 8,  19, 23, 21, 19, 15, 12, 8,  19, 23, 22, 19, 16, 13,
    9,  18, 22, 24, 22, 18, 14, 10, 19, 23, 27, 25, 20, 15, 12, 18, 23, 28, 27,
    22, 17, 13, 25, 28, 25, 20, 17, 14, 11, 24, 28, 27, 22, 17, 14, 11, 24, 28,
    29, 22, 17, 14, 11, 25, 27, 30, 24, 19, 16, 12, 23, 27, 31, 28, 22, 17, 13,
    24, 28, 32, 31, 24, 19, 14, 25, 28, 32, 32, 26, 20, 15, 3,  7,  11, 15, 16,
    13, 11, 2,  5,  10, 14, 15, 13, 8,  2,  4,  8,  11, 13, 10, 5,  2,  2,  5,
    8,  10, 9,  5,  2,  2,  2,  5,  8,  10, 5,  5,  6,  6,  5,  8,  9,  5,  12,
    10, 8,  5,  6,  9,  5,  2,  4,  8,  11, 13, 10, 5,  2,  3,  7,  10, 13, 8,
    3,  2,  2,  5,  7,  9,  5,  2,  1,  2,  2,  4,  5,  3,  2,  2,  3,  3,  3,
    3,  3,  2,  7,  7,  8,  6,  3,  2,  2,  15, 13, 10, 7,  5,  3,  2,  2,  2,
    3,  5,  6,  4,  2,  1,  2,  2,  3,  4,  3,  1,  0,  2,  2,  2,  2,  2,  1,
    1,  2,  1,  1,  1,  1,  2,  4,  4,  4,  4,  4,  3,  2,  10, 10, 9,  8,  6,
    4,  2,  17, 16, 12, 9,  6,  4,  2,  0,  1,  1,  1,  2,  2,  5,  1,  2,  2,
    2,  2,  2,  5,  2,  2,  3,  3,  3,  3,  5,  4,  4,  5,  5,  5,  6,  7,  6,
    9,  9,  9,  9,  8,  7,  10, 15, 14, 13, 11, 10, 9,  17, 20, 17, 15, 13, 12,
    11, 8,  8,  8,  9,  9,  8,  5,  10, 10, 10, 10, 10, 9,  5,  10, 11, 11, 12,
    12, 10, 6,  10, 14, 14, 14, 14, 13, 9,  13, 18, 18, 18, 18, 17, 11, 15, 21,
    23, 21, 20, 18, 13, 20, 24, 25, 23, 21, 20, 15, 17, 18, 18, 18, 16, 11, 7,
    17, 20, 20, 19, 17, 12, 7,  17, 22, 21, 20, 19, 14, 9,  17, 23, 22, 22, 20,
    17, 14, 18, 24, 26, 25, 23, 20, 15, 21, 26, 29, 28, 24, 20, 17, 24, 28, 29,
    30, 25, 23, 18, 24, 29, 27, 22, 19, 15, 9,  24, 28, 29, 23, 20, 16, 11, 24,
    29, 30, 25, 21, 17, 13, 24, 29, 30, 26, 22, 20, 17, 25, 28, 32, 29, 25, 23,
    19, 26, 30, 33, 32, 26, 24, 20, 28, 32, 34, 33, 28, 25, 22, 6,  7,  8,  8,
    9,  7,  7,  5,  7,  8,  9,  9,  7,  6,  4,  6,  7,  8,  8,  7,  6,  3,  6,
    7,  7,  8,  7,  7,  3,  6,  7,  8,  9,  8,  7,  7,  9,  10, 9,  9,  8,  7,
    13, 13, 11, 10, 9,  8,  7,  4,  6,  7,  7,  7,  6,  5,  3,  6,  7,  7,  7,
    6,  5,  2,  5,  7,  7,  6,  6,  6,  1,  4,  7,  7,  6,  6,  7,  4,  5,  7,
    8,  7,  7,  6,  9,  9,  11, 10, 8,  7,  7,  16, 14, 12, 11, 8,  7,  7,  2,
    5,  6,  6,  6,  5,  2,  1,  4,  5,  5,  5,  5,  2,  1,  3,  4,  4,  5,  5,
    2,  1,  3,  4,  4,  5,  5,  4,  6,  6,  6,  6,  6,  5,  4,  11, 11, 11, 9,
    7,  5,  4,  18, 17, 13, 10, 7,  5,  4,  1,  0,  1,  1,  1,  2,  4,  1,  2,
    2,  2,  2,  2,  4,  2,  3,  2,  2,  3,  3,  4,  5,  5,  5,  6,  6,  6,  6,
    6,  10, 9,  9,  10, 9,  8,  12, 15, 14, 13, 11, 11, 9,  19, 21, 18, 15, 13,
    12, 11, 9,  8,  8,  8,  9,  7,  4,  10, 10, 9,  9,  10, 8,  4,  10, 11, 11,
    11, 11, 10, 6,  10, 15, 14, 14, 14, 13, 10, 13, 19, 18, 18, 19, 17, 11, 17,
    22, 24, 23, 21, 19, 13, 20, 26, 28, 25, 24, 21, 15, 17, 18, 17, 17, 14, 10,
    6,  17, 21, 19, 19, 16, 11, 7,  17, 21, 22, 21, 17, 13, 9,  17, 24, 25, 25,
    21, 17, 13, 20, 25, 31, 30, 25, 20, 15, 22, 28, 35, 33, 28, 22, 16, 25, 31,
    35, 36, 30, 24, 18, 25, 31, 29, 22, 17, 13, 9,  25, 30, 32, 25, 19, 15, 10,
    25, 31, 34, 27, 21, 17, 13, 24, 31, 37, 30, 26, 21, 17, 27, 33, 38, 36, 31,
    25, 18, 28, 36, 40, 40, 33, 27, 20, 32, 38, 41, 41, 35, 29, 23, 6,  9,  12,
    13, 13, 11, 9,  5,  8,  11, 13, 13, 11, 10, 4,  7,  10, 12, 13, 12, 10, 3,
    7,  10, 12, 14, 12, 11, 5,  7,  9,  12, 14, 13, 11, 8,  9,  11, 12, 14, 13,
    11, 14, 14, 12, 12, 13, 13, 11, 5,  7,  10, 12, 11, 9,  6,  4,  6,  9,  11,
    11, 9,  6,  2,  5,  8,  10, 10, 9,  7,  1,  5,  8,  11, 10, 10, 8,  4,  6,
    8,  10, 10, 11, 8,  10, 11, 11, 12, 10, 10, 8,  17, 16, 13, 12, 10, 9,  8,
    2,  5,  6,  7,  7,  5,  2,  1,  4,  5,  6,  6,  5,  2,  1,  3,  5,  5,  5,
    5,  3,  1,  3,  5,  5,  5,  6,  4,  6,  7,  7,  7,  7,  6,  4,  13, 12, 12,
    10, 8,  6,  4,  20, 18, 14, 11, 8,  6,  4,  1,  1,  0,  1,  1,  1,  3,  1,
    2,  1,  1,  1,  1,  3,  4,  3,  3,  3,  3,  3,  4,  7,  6,  6,  6,  6,  7,
    6,  8,  11, 10, 10, 10, 10, 8,  13, 16, 15, 14, 12, 11, 10, 19, 22, 19, 16,
    14, 13, 12, 9,  8,  8,  8,  8,  7,  3,  11, 10, 9,  9,  9,  8,  3,  10, 12,
    12, 12, 11, 10, 7,  10, 16, 15, 14, 15, 14, 10, 14, 21, 20, 20, 19, 17, 12,
    18, 24, 25, 23, 21, 18, 14, 22, 27, 28, 26, 24, 21, 15, 17, 19, 17, 17, 13,
    9,  5,  17, 21, 19, 18, 15, 11, 6,  17, 22, 22, 21, 17, 13, 10, 18, 24, 26,
    25, 21, 17, 13, 20, 27, 30, 30, 26, 20, 15, 23, 29, 36, 35, 29, 23, 17, 27,
    32, 37, 37, 31, 25, 19, 25, 30, 29, 22, 16, 12, 8,  25, 31, 31, 24, 18, 14,
    10, 25, 30, 35, 27, 22, 17, 13, 26, 31, 37, 31, 26, 21, 17, 27, 34, 39, 37,
    30, 25, 19, 30, 37, 43, 41, 33, 27, 20, 33, 38, 43, 43, 36, 29, 23, 7,  9,
    12, 15, 15, 13, 10, 6,  8,  11, 14, 15, 13, 10, 5,  7,  10, 13, 15, 14, 11,
    4,  7,  11, 14, 16, 14, 12, 5,  8,  11, 13, 17, 15, 12, 9,  11, 12, 13, 16,
    14, 12, 16, 15, 14, 13, 15, 15, 12, 5,  8,  10, 13, 12, 9,  6,  4,  7,  9,
    12, 12, 9,  6,  3,  5,  9,  11, 11, 10, 8,  1,  5,  9,  11, 11, 11, 9,  5,
    7,  9,  11, 11, 11, 9,  11, 12, 13, 13, 11, 10, 8,  19, 17, 14, 13, 10, 10,
    8,  3,  6,  6,  6,  7,  5,  2,  1,  4,  6,  6,  6,  5,  2,  1,  3,  5,  5,
    5,  6,  3,  2,  4,  5,  5,  6,  6,  5,  7,  8,  8,  8,  8,  7,  5,  14, 13,
    13, 11, 9,  7,  5,  21, 19, 15, 12, 9,  7,  6,  1,  1,  1,  0,  1,  1,  3,
    2,  2,  2,  1,  2,  1,  3,  5,  3,  3,  4,  4,  4,  5,  8,  6,  7,  7,  7,
    7,  7,  9,  12, 11, 11, 12, 10, 9,  14, 18, 16, 15, 14, 12, 11, 21, 24, 20,
    17, 15, 13, 12, 10, 9,  8,  8,  8,  7,  3,  11, 10, 9,  9,  9,  8,  3,  11,
    12, 12, 13, 12, 11, 7,  11, 16, 16, 16, 16, 15, 11, 15, 22, 21, 20, 21, 18,
    13, 19, 25, 26, 25, 22, 20, 14, 23, 28, 30, 27, 25, 21, 16, 18, 19, 17, 17,
    14, 9,  5,  18, 21, 19, 19, 15, 11, 7,  18, 23, 22, 22, 18, 14, 11, 18, 25,
    27, 25, 23, 19, 15, 21, 28, 32, 32, 26, 21, 16, 24, 32, 37, 36, 29, 23, 18,
    28, 34, 38, 38, 32, 26, 20, 26, 31, 29, 22, 17, 12, 8,  25, 31, 31, 24, 19,
    15, 11, 25, 30, 33, 28, 24, 18, 14, 26, 31, 37, 32, 27, 22, 18, 29, 35, 40,
    38, 31, 26, 20, 31, 38, 42, 42, 34, 28, 22, 34, 39, 44, 44, 37, 30, 24, 7,
    10, 12, 15, 15, 12, 10, 6,  9,  11, 14, 15, 13, 11, 5,  7,  11, 15, 16, 15,
    12, 4,  8,  11, 14, 17, 16, 13, 6,  9,  11, 14, 18, 16, 13, 11, 12, 14, 14,
    17, 16, 13, 17, 17, 15, 14, 16, 15, 13, 5,  8,  10, 13, 11, 9,  6,  4,  7,
    10, 12, 12, 9,  7,  3,  6,  9,  12, 12, 10, 8,  2,  6,  10, 12, 12, 11, 9,
    5,  8,  10, 12, 12, 12, 9,  12, 13, 14, 15, 12, 11, 9,  20, 19, 16, 14, 12,
    10, 9,  3,  6,  7,  6,  7,  5,  1,  1,  5,  6,  6,  6,  5,  2,  2,  4,  5,
    6,  6,  6,  4,  2,  4,  6,  6,  6,  6,  6,  7,  9,  9,  9,  10, 8,  6,  15,
    15, 14, 12, 10, 9,  6,  22, 21, 17, 14, 11, 9,  7,  2,  1,  1,  1,  0,  1,
    3,  3,  2,  2,  2,  2,  2,  3,  7,  3,  3,  4,  5,  5,  5,  9,  6,  8,  9,
    9,  8,  7,  10, 12, 12, 12, 13, 12, 10, 16, 19, 17, 16, 15, 14, 12, 22, 25,
    21, 18, 16, 15, 14, 10, 9,  8,  8,  8,  7,  2,  13, 11, 10, 9,  10, 9,  3,
    13, 12, 12, 13, 13, 12, 9,  13, 17, 17, 18, 17, 16, 12, 16, 23, 22, 22, 22,
    19, 14, 21, 27, 28, 26, 24, 21, 16, 24, 29, 31, 28, 27, 23, 17, 18, 19, 18,
    17, 13, 9,  5,  19, 21, 19, 18, 15, 12, 8,  18, 23, 22, 23, 19, 16, 12, 19,
    24, 28, 27, 23, 19, 16, 22, 29, 32, 31, 28, 23, 17, 27, 32, 39, 36, 29, 24,
    19, 30, 36, 38, 39, 33, 27, 21, 25, 29, 26, 21, 16, 12, 8,  25, 30, 29, 23,
    19, 16, 12, 26, 30, 31, 26, 23, 19, 15, 25, 32, 35, 31, 27, 24, 20, 29, 35,
    39, 38, 32, 26, 21, 32, 38, 43, 42, 35, 29, 23, 35, 40, 43, 45, 37, 31, 25,
    6,  8,  10, 12, 12, 9,  8,  6,  8,  9,  11, 12, 11, 9,  5,  7,  9,  12, 14,
    12, 11, 4,  7,  10, 13, 16, 14, 13, 6,  9,  12, 14, 18, 15, 13, 11, 13, 15,
    16, 17, 15, 13, 18, 18, 16, 15, 16, 15, 13, 5,  7,  8,  10, 8,  6,  5,  4,
    6,  8,  9,  9,  7,  6,  3,  6,  8,  10, 10, 9,  8,  2,  6,  9,  11, 11, 11,
    10, 6,  9,  11, 13, 13, 12, 9,  13, 14, 16, 15, 13, 12, 10, 22, 19, 17, 16,
    13, 11, 10, 3,  6,  5,  5,  5,  3,  2,  2,  5,  5,  4,  4,  4,  3,  2,  4,
    5,  5,  6,  6,  5,  3,  4,  6,  7,  7,  7,  8,  8,  9,  10, 11, 11, 10, 8,
    16, 17, 15, 14, 12, 10, 8,  23, 22, 18, 14, 12, 10, 8,  2,  2,  1,  1,  1,
    0,  2,  4,  2,  2,  2,  2,  3,  4,  8,  4,  3,  5,  6,  6,  6,  11, 6,  8,
    9,  9,  10, 8,  11, 13, 13, 14, 14, 12, 11, 16, 20, 18, 17, 16, 14, 13, 23,
    26, 22, 19, 17, 16, 15, 11, 9,  8,  8,  8,  7,  2,  14, 11, 10, 9,  10, 9,
    4,  14, 13, 12, 13, 14, 12, 9,  14, 17, 17, 17, 17, 17, 13, 16, 23, 23, 23,
    22, 19, 15, 21, 27, 28, 26, 23, 21, 17, 26, 31, 31, 28, 26, 22, 18, 18, 17,
    15, 13, 12, 9,  6,  18, 19, 16, 14, 12, 12, 9,  18, 21, 18, 19, 17, 15, 13,
    18, 23, 25, 24, 22, 19, 17, 22, 29, 31, 29, 26, 23, 18, 26, 33, 37, 34, 28,
    23, 20, 30, 36, 38, 37, 30, 25, 21, 22, 25, 22, 17, 13, 10, 9,  22, 25, 24,
    18, 15, 14, 12, 22, 25, 27, 22, 20, 18, 15, 22, 27, 33, 29, 25, 22, 20, 27,
    31, 37, 34, 30, 25, 21, 31, 36, 40, 40, 32, 27, 22, 35, 39, 42, 41, 35, 29,
    24, 9,  11, 13, 16, 16, 13, 10, 9,  11, 12, 15, 16, 14, 12, 8,  9,  12, 16,
    17, 15, 13, 8,  10, 13, 16, 19, 16, 14, 8,  11, 13, 17, 20, 18, 14, 11, 13,
    15, 16, 19, 18, 15, 18, 17, 16, 16, 18, 17, 14, 8,  10, 12, 13, 11, 8,  7,
    8,  9,  11, 13, 12, 10, 8,  7,  8,  11, 14, 13, 11, 9,  6,  8,  11, 14, 13,
    12, 11, 6,  10, 12, 14, 14, 13, 11, 13, 14, 16, 15, 14, 13, 11, 22, 19, 17,
    15, 13, 12, 11, 7,  8,  8,  7,  7,  5,  3,  6,  8,  8,  7,  7,  6,  4,  5,
    7,  7,  8,  8,  8,  6,  3,  7,  8,  8,  9,  9,  8,  7,  9,  10, 10, 10, 9,
    8,  16, 16, 15, 13, 11, 9,  8,  23, 22, 18, 14, 11, 9,  8,  5,  4,  3,  3,
    3,  3,  0,  2,  2,  3,  2,  2,  2,  2,  6,  2,  2,  3,  3,  3,  4,  10, 3,
    5,  6,  6,  6,  6,  9,  10, 10, 10, 10, 9,  7,  15, 18, 16, 14, 12, 10, 8,
    24, 25, 19, 15, 13, 11, 9,  4,  3,  2,  2,  2,  2,  0,  6,  3,  3,  2,  3,
    3,  2,  6,  4,  4,  5,  6,  6,  5,  6,  8,  9,  10, 10, 9,  8,  9,  14, 15,
    15, 15, 13, 9,  16, 20, 22, 20, 17, 14, 10, 22, 25, 25, 21, 19, 15, 11, 8,
    7,  6,  5,  3,  2,  1,  7,  10, 7,  6,  4,  4,  3,  8,  11, 10, 11, 9,  8,
    7,  8,  14, 17, 17, 14, 12, 10, 12, 19, 23, 23, 20, 16, 11, 18, 24, 30, 28,
    22, 17, 13, 24, 28, 31, 30, 24, 19, 14, 13, 16, 14, 8,  5,  3,  2,  13, 16,
    16, 10, 7,  6,  5,  13, 16, 19, 15, 12, 10, 8,  13, 18, 25, 21, 18, 15, 13,
    17, 24, 30, 28, 23, 19, 14, 22, 28, 34, 34, 27, 21, 15, 27, 32, 35, 35, 29,
    23, 17, 6,  10, 15, 18, 18, 16, 15, 5,  9,  14, 17, 18, 15, 13, 3,  8,  11,
    15, 16, 14, 11, 2,  5,  9,  11, 13, 13, 10, 1,  2,  6,  10, 12, 14, 10, 5,
    5,  5,  8,  11, 14, 10, 11, 9,  5,  7,  10, 14, 10, 3,  7,  12, 15, 16, 14,
    10, 2,  6,  11, 14, 15, 13, 8,  2,  5,  9,  11, 12, 11, 5,  2,  2,  6,  8,
    9,  8,  3,  2,  2,  3,  6,  7,  8,  3,  7,  7,  6,  5,  6,  6,  4,  15, 12,
    8,  5,  4,  5,  4,  2,  5,  7,  9,  11, 9,  5,  2,  3,  6,  8,  8,  8,  2,
    1,  2,  4,  5,  5,  5,  1,  0,  2,  2,  1,  2,  1,  1,  4,  4,  4,  4,  4,
    2,  1,  10, 9,  9,  8,  5,  3,  1,  16, 15, 11, 9,  6,  4,  2,  1,  1,  1,
    2,  3,  4,  2,  0,  1,  1,  2,  2,  1,  3,  1,  1,  1,  1,  1,  1,  3,  3,
    3,  3,  3,  4,  4,  4,  5,  7,  7,  7,  8,  7,  6,  9,  13, 11, 11, 10, 9,
    8,  16, 18, 14, 13, 12, 10, 9,  7,  7,  7,  8,  8,  7,  3,  8,  8,  9,  9,
    9,  8,  3,  8,  10, 10, 10, 11, 9,  5,  8,  13, 12, 13, 13, 12, 8,  11, 16,
    15, 15, 15, 14, 10, 14, 18, 19, 17, 16, 16, 12, 17, 20, 21, 18, 18, 16, 13,
    16, 16, 16, 16, 14, 10, 5,  15, 18, 17, 16, 14, 11, 7,  15, 19, 18, 17, 16,
    13, 8,  15, 19, 19, 18, 16, 15, 11, 16, 20, 22, 21, 18, 16, 13, 18, 22, 25,
    23, 20, 17, 14, 20, 24, 25, 25, 21, 18, 15, 21, 25, 22, 19, 16, 14, 8,  21,
    25, 25, 20, 16, 14, 10, 20, 25, 27, 21, 17, 15, 11, 21, 24, 27, 22, 18, 17,
    15, 21, 25, 28, 26, 21, 18, 16, 21, 25, 29, 28, 23, 19, 17, 24, 26, 29, 29,
    24, 20, 17, 7,  8,  9,  11, 11, 9,  7,  6,  7,  8,  10, 10, 8,  7,  5,  7,
    8,  9,  9,  8,  7,  4,  6,  7,  8,  8,  8,  8,  4,  7,  8,  8,  9,  8,  8,
    7,  8,  9,  9,  9,  8,  8,  13, 13, 11, 9,  9,  8,  7,  5,  7,  8,  9,  9,
    7,  6,  4,  7,  8,  8,  8,  7,  6,  3,  6,  7,  7,  7,  7,  6,  2,  5,  7,
    8,  7,  7,  7,  3,  5,  7,  8,  7,  7,  7,  8,  9,  10, 10, 8,  7,  7,  16,
    15, 12, 10, 8,  7,  7,  3,  6,  6,  6,  7,  6,  3,  2,  5,  6,  6,  6,  6,
    3,  1,  4,  5,  5,  6,  6,  3,  1,  4,  5,  5,  6,  6,  5,  5,  6,  6,  6,
    6,  6,  5,  11, 11, 11, 9,  7,  5,  5,  18, 17, 13, 10, 7,  5,  3,  2,  2,
    2,  2,  2,  2,  2,  1,  0,  1,  1,  1,  1,  3,  1,  1,  1,  1,  1,  1,  3,
    4,  4,  4,  4,  4,  4,  5,  6,  8,  8,  8,  8,  7,  6,  11, 14, 13, 12, 10,
    9,  8,  18, 20, 16, 14, 12, 10, 9,  7,  7,  7,  7,  7,  6,  2,  9,  9,  8,
    8,  8,  7,  3,  9,  10, 10, 10, 10, 8,  4,  9,  13, 13, 12, 13, 12, 8,  12,
    18, 17, 17, 18, 15, 10, 15, 21, 23, 21, 20, 17, 11, 19, 24, 26, 23, 22, 18,
    13, 16, 17, 17, 16, 13, 9,  5,  15, 20, 18, 18, 14, 10, 6,  15, 21, 20, 20,
    16, 12, 8,  16, 22, 24, 23, 19, 15, 11, 18, 24, 29, 28, 24, 19, 13, 20, 27,
    32, 31, 27, 21, 15, 25, 30, 34, 32, 28, 23, 17, 23, 29, 28, 22, 16, 12, 7,
    23, 29, 30, 24, 18, 13, 9,  23, 30, 33, 26, 20, 15, 11, 24, 29, 34, 29, 24,
    20, 15, 24, 31, 35, 34, 28, 23, 17, 27, 33, 37, 36, 30, 25, 19, 30, 35, 39,
    38, 33, 27, 22, 7,  10, 12, 14, 14, 12, 10, 7,  9,  12, 13, 14, 12, 10, 5,
    8,  10, 13, 13, 12, 11, 4,  8,  10, 12, 14, 13, 12, 5,  8,  10, 13, 15, 13,
    12, 8,  10, 11, 13, 14, 13, 11, 14, 14, 13, 12, 13, 13, 12, 5,  8,  11, 12,
    11, 10, 7,  5,  7,  10, 12, 11, 10, 7,  3,  6,  9,  11, 11, 10, 8,  3,  6,
    9,  11, 11, 11, 9,  5,  6,  8,  11, 11, 11, 9,  10, 11, 12, 12, 10, 10, 9,
    17, 16, 13, 12, 10, 9,  9,  4,  6,  7,  7,  8,  6,  3,  2,  5,  6,  7,  7,
    6,  3,  1,  4,  5,  5,  6,  6,  3,  1,  4,  5,  6,  6,  6,  4,  6,  7,  7,
    7,  7,  6,  5,  12, 12, 11, 10, 8,  6,  4,  19, 19, 14, 11, 8,  6,  5,  2,
    2,  1,  1,  2,  2,  3,  1,  1,  0,  1,  1,  1,  3,  2,  2,  2,  2,  2,  2,
    4,  6,  5,  5,  5,  5,  5,  5,  7,  9,  9,  9,  9,  9,  7,  12, 15, 14, 13,
    11, 10, 9,  19, 21, 17, 15, 13, 11, 11, 8,  7,  7,  7,  7,  6,  3,  9,  9,
    8,  8,  8,  7,  3,  9,  10, 10, 10, 10, 9,  5,  9,  14, 14, 14, 14, 13, 9,
    13, 19, 19, 18, 18, 16, 11, 17, 22, 24, 23, 20, 18, 12, 21, 26, 28, 24, 23,
    20, 14, 16, 18, 17, 16, 13, 9,  4,  16, 20, 18, 18, 14, 9,  6,  17, 21, 21,
    20, 16, 12, 8,  17, 24, 25, 24, 21, 16, 12, 20, 25, 30, 29, 25, 19, 14, 22,
    28, 35, 32, 28, 21, 16, 25, 31, 35, 36, 28, 23, 18, 24, 30, 27, 21, 16, 12,
    7,  24, 30, 30, 23, 18, 13, 9,  24, 30, 33, 26, 21, 16, 12, 24, 31, 36, 30,
    24, 20, 16, 25, 32, 38, 34, 29, 23, 18, 28, 34, 39, 40, 33, 26, 20, 31, 37,
    41, 41, 35, 28, 21, 8,  10, 13, 16, 16, 13, 11, 7,  9,  12, 15, 16, 14, 11,
    6,  8,  11, 14, 16, 14, 12, 5,  9,  11, 14, 17, 15, 13, 6,  8,  11, 14, 17,
    16, 13, 10, 11, 12, 14, 17, 16, 13, 16, 15, 13, 13, 15, 15, 13, 6,  8,  11,
    14, 12, 10, 7,  5,  8,  10, 13, 12, 10, 7,  4,  7,  10, 12, 12, 10, 9,  3,
    7,  10, 12, 12, 12, 9,  5,  7,  9,  12, 12, 12, 9,  11, 11, 13, 13, 11, 12,
    9,  19, 17, 15, 13, 10, 10, 9,  4,  7,  7,  7,  8,  6,  2,  3,  5,  7,  7,
    7,  6,  2,  1,  5,  6,  6,  6,  6,  4,  1,  5,  6,  6,  7,  7,  5,  7,  8,
    8,  8,  8,  7,  5,  14, 14, 13, 11, 9,  7,  5,  21, 20, 15, 12, 9,  7,  5,
    2,  1,  1,  1,  2,  2,  2,  2,  1,  1,  0,  1,  1,  3,  3,  2,  2,  2,  3,
    3,  4,  6,  5,  6,  6,  6,  6,  6,  8,  11, 10, 10, 10, 9,  8,  14, 17, 15,
    14, 12, 11, 9,  21, 23, 18, 16, 14, 12, 11, 8,  8,  7,  7,  7,  6,  3,  10,
    9,  8,  8,  8,  7,  3,  10, 11, 11, 11, 11, 10, 6,  10, 15, 15, 15, 15, 14,
    10, 13, 20, 20, 19, 19, 16, 11, 18, 25, 25, 24, 21, 18, 13, 22, 27, 28, 26,
    23, 20, 15, 17, 18, 17, 16, 12, 8,  4,  17, 20, 18, 17, 14, 10, 6,  17, 22,
    22, 21, 17, 13, 9,  17, 24, 26, 25, 21, 17, 13, 20, 26, 30, 30, 25, 20, 15,
    23, 29, 36, 33, 28, 22, 17, 27, 32, 36, 37, 30, 24, 19, 24, 30, 28, 21, 16,
    11, 7,  24, 29, 29, 23, 18, 13, 10, 24, 30, 33, 27, 21, 17, 13, 24, 31, 37,
    30, 25, 21, 17, 28, 33, 39, 36, 31, 24, 19, 30, 36, 41, 41, 33, 27, 20, 33,
    38, 43, 43, 36, 28, 22, 8,  11, 14, 17, 17, 15, 12, 7,  10, 13, 17, 17, 14,
    12, 6,  9,  12, 15, 18, 15, 13, 5,  9,  12, 15, 19, 16, 14, 6,  9,  12, 15,
    19, 17, 14, 10, 12, 13, 14, 18, 17, 14, 16, 15, 14, 14, 16, 16, 14, 6,  9,
    11, 15, 14, 11, 8,  5,  8,  11, 13, 13, 10, 8,  4,  7,  10, 13, 13, 11, 9,
    3,  7,  11, 13, 13, 12, 10, 5,  8,  10, 12, 13, 12, 10, 12, 12, 14, 14, 12,
    12, 10, 19, 17, 15, 14, 11, 11, 10, 4,  7,  8,  8,  9,  7,  3,  3,  6,  7,
    7,  7,  6,  3,  1,  5,  6,  7,  7,  7,  4,  1,  5,  7,  7,  7,  7,  6,  7,
    8,  9,  8,  8,  7,  6,  14, 14, 14, 12, 9,  7,  6,  21, 20, 16, 12, 10, 8,
    6,  2,  2,  1,  2,  2,  2,  2,  2,  1,  1,  1,  0,  0,  2,  4,  2,  2,  3,
    3,  3,  3,  7,  5,  6,  6,  6,  6,  5,  8,  11, 10, 10, 11, 9,  8,  14, 17,
    15, 14, 12, 11, 10, 21, 23, 19, 16, 14, 12, 11, 8,  7,  7,  7,  7,  6,  2,
    10, 9,  8,  8,  8,  7,  2,  10, 11, 10, 11, 11, 10, 6,  10, 15, 15, 15, 15,
    14, 10, 14, 21, 20, 20, 19, 17, 12, 18, 24, 26, 24, 21, 18, 13, 23, 28, 29,
    26, 24, 21, 15, 17, 18, 17, 15, 12, 9,  4,  16, 19, 18, 17, 13, 10, 6,  17,
    22, 21, 21, 18, 13, 9,  16, 24, 26, 25, 22, 18, 13, 20, 27, 30, 30, 26, 21,
    15, 24, 30, 37, 35, 28, 23, 17, 28, 32, 37, 37, 30, 24, 19, 24, 28, 25, 20,
    15, 11, 7,  24, 28, 28, 22, 17, 13, 10, 24, 29, 31, 25, 21, 17, 13, 24, 30,
    35, 31, 25, 21, 17, 28, 33, 38, 35, 30, 24, 19, 30, 35, 41, 40, 32, 27, 21,
    34, 39, 41, 42, 35, 29, 23, 8,  11, 14, 17, 17, 15, 11, 7,  10, 13, 16, 16,
    14, 12, 6,  9,  12, 15, 17, 16, 13, 5,  9,  12, 16, 18, 16, 14, 6,  9,  12,
    15, 18, 17, 14, 10, 12, 13, 14, 18, 17, 14, 17, 16, 14, 14, 16, 17, 14, 6,
    9,  12, 14, 13, 11, 8,  5,  8,  11, 13, 13, 10, 8,  4,  7,  10, 14, 13, 11,
    9,  3,  7,  11, 13, 13, 12, 10, 5,  8,  10, 13, 13, 12, 10, 11, 12, 14, 13,
    12, 12, 10, 19, 17, 15, 14, 11, 11, 9,  4,  7,  8,  8,  9,  7,  3,  3,  6,
    7,  7,  7,  6,  3,  2,  5,  6,  7,  7,  7,  4,  1,  5,  7,  7,  7,  7,  6,
    6,  8,  9,  9,  8,  7,  6,  14, 14, 13, 11, 9,  8,  6,  21, 19, 15, 12, 10,
    8,  6,  2,  2,  1,  1,  2,  3,  2,  1,  1,  1,  1,  0,  0,  2,  5,  2,  2,
    3,  3,  3,  3,  7,  5,  6,  6,  6,  6,  5,  9,  11, 10, 11, 10, 10, 8,  14,
    17, 16, 14, 13, 11, 10, 21, 23, 19, 16, 14, 13, 12, 9,  8,  7,  6,  7,  6,
    2,  11, 10, 8,  8,  8,  7,  2,  11, 11, 10, 11, 11, 10, 6,  10, 15, 15, 15,
    15, 14, 10, 14, 21, 20, 20, 19, 16, 12, 18, 24, 25, 23, 21, 18, 13, 23, 27,
    29, 25, 22, 20, 15, 16, 16, 14, 13, 11, 8,  5,  16, 18, 15, 13, 12, 10, 6,
    16, 20, 17, 17, 15, 12, 10, 17, 21, 23, 21, 19, 17, 13, 20, 26, 28, 26, 23,
    20, 15, 24, 29, 33, 30, 25, 21, 17, 27, 33, 34, 33, 26, 23, 19, 21, 23, 20,
    15, 13, 10, 7,  21, 24, 23, 17, 14, 13, 9,  21, 24, 25, 21, 18, 16, 13, 21,
    25, 30, 25, 22, 19, 16, 25, 29, 34, 32, 27, 23, 19, 29, 33, 37, 36, 29, 24,
    20, 32, 35, 37, 38, 32, 26, 21, 9,  11, 14, 17, 17, 14, 11, 9,  11, 13, 16,
    17, 13, 11, 8,  10, 12, 15, 17, 15, 12, 8,  10, 13, 16, 18, 15, 13, 8,  10,
    13, 15, 19, 17, 13, 11, 11, 13, 15, 18, 16, 13, 16, 15, 14, 14, 16, 17, 13,
    8,  10, 12, 14, 13, 10, 7,  8,  9,  11, 13, 13, 9,  7,  7,  8,  11, 13, 12,
    10, 8,  6,  9,  12, 14, 13, 12, 9,  6,  9,  11, 13, 13, 12, 10, 11, 12, 13,
    13, 12, 11, 10, 19, 17, 14, 13, 11, 11, 10, 7,  9,  9,  8,  9,  7,  4,  6,
    8,  8,  7,  7,  6,  3,  5,  8,  8,  7,  7,  6,  5,  4,  7,  8,  8,  7,  7,
    6,  7,  9,  9,  8,  8,  7,  6,  14, 14, 13, 11, 9,  7,  6,  21, 19, 14, 11,
    9,  7,  6,  5,  4,  3,  3,  3,  4,  2,  3,  3,  3,  2,  2,  2,  0,  2,  2,
    2,  3,  2,  2,  2,  7,  3,  4,  5,  4,  4,  4,  8,  9,  9,  8,  8,  7,  5,
    14, 15, 14, 11, 10, 8,  6,  20, 21, 16, 13, 11, 9,  7,  5,  3,  2,  2,  2,
    2,  2,  6,  4,  3,  2,  3,  2,  0,  5,  5,  4,  4,  4,  4,  3,  5,  8,  8,
    8,  8,  8,  6,  9,  14, 13, 13, 13, 10, 7,  14, 19, 20, 18, 15, 12, 8,  20,
    23, 23, 19, 17, 14, 9,  9,  9,  7,  6,  4,  3,  2,  9,  11, 9,  8,  5,  3,
    2,  8,  12, 11, 11, 9,  6,  5,  9,  14, 17, 16, 13, 10, 8,  12, 18, 22, 21,
    18, 14, 9,  17, 23, 27, 25, 20, 15, 11, 22, 26, 29, 28, 23, 17, 12, 14, 18,
    15, 10, 6,  3,  2,  13, 18, 18, 12, 8,  5,  3,  14, 18, 20, 15, 12, 9,  6,
    14, 19, 25, 21, 17, 13, 11, 17, 23, 28, 26, 22, 17, 12, 22, 26, 32, 32, 25,
    19, 14, 26, 30, 33, 33, 27, 20, 15, 10, 14, 18, 22, 22, 20, 17, 8,  12, 17,
    20, 22, 19, 16, 7,  11, 14, 17, 20, 17, 13, 5,  9,  12, 15, 16, 15, 13, 3,
    6,  10, 13, 15, 16, 14, 4,  5,  8,  11, 14, 16, 13, 10, 7,  7,  11, 13, 15,
    14, 7,  11, 15, 18, 20, 17, 13, 5,  9,  14, 17, 19, 15, 12, 4,  8,  12, 13,
    15, 14, 9,  3,  6,  9,  11, 12, 13, 8,  2,  3,  7,  10, 12, 12, 8,  6,  5,
    6,  8,  10, 11, 8,  12, 10, 6,  8,  8,  8,  8,  4,  8,  10, 12, 13, 12, 9,
    2,  7,  9,  11, 11, 11, 7,  1,  5,  8,  9,  9,  10, 4,  1,  3,  4,  5,  5,
    5,  1,  3,  3,  3,  3,  3,  3,  1,  9,  8,  7,  5,  4,  2,  1,  14, 13, 9,
    7,  5,  4,  1,  2,  2,  4,  5,  7,  8,  6,  1,  1,  2,  3,  4,  5,  2,  0,
    1,  1,  1,  1,  1,  1,  1,  2,  2,  2,  2,  2,  2,  4,  6,  6,  6,  6,  5,
    4,  9,  10, 9,  8,  8,  7,  6,  14, 15, 11, 10, 9,  8,  8,  6,  6,  6,  6,
    6,  4,  6,  7,  7,  8,  8,  8,  6,  3,  7,  9,  8,  8,  9,  8,  3,  7,  10,
    10, 10, 10, 9,  6,  9,  13, 12, 12, 12, 11, 8,  11, 15, 15, 14, 13, 12, 9,
    14, 17, 17, 15, 14, 13, 10, 13, 13, 13, 13, 11, 8,  5,  12, 15, 14, 13, 12,
    9,  6,  12, 16, 15, 14, 12, 10, 7,  13, 15, 16, 15, 13, 11, 9,  13, 16, 18,
    17, 16, 12, 10, 14, 18, 22, 20, 17, 14, 11, 16, 20, 22, 21, 18, 15, 12, 17,
    20, 19, 16, 13, 11, 6,  18, 21, 21, 16, 13, 11, 8,  17, 21, 23, 17, 14, 11,
    9,  17, 21, 23, 19, 15, 13, 11, 17, 21, 24, 21, 18, 15, 12, 18, 22, 25, 25,
    19, 16, 13, 20, 23, 26, 25, 21, 16, 14, 7,  8,  10, 13, 13, 11, 9,  7,  8,
    10, 12, 13, 10, 8,  6,  8,  9,  10, 11, 9,  7,  5,  7,  8,  9,  10, 8,  8,
    5,  7,  8,  9,  10, 9,  8,  7,  8,  9,  9,  9,  8,  8,  13, 13, 11, 9,  9,
    8,  8,  7,  8,  9,  10, 11, 9,  7,  6,  7,  8,  10, 11, 8,  7,  4,  7,  8,
    8,  8,  7,  6,  3,  6,  7,  8,  7,  7,  7,  3,  6,  8,  8,  8,  8,  7,  8,
    9,  10, 9,  7,  7,  7,  16, 15, 12, 10, 8,  7,  7,  4,  7,  7,  7,  7,  7,
    5,  3,  6,  7,  7,  7,  6,  4,  2,  5,  6,  6,  6,  6,  5,  1,  5,  6,  6,
    6,  6,  6,  5,  6,  6,  6,  6,  6,  6,  11, 11, 10, 9,  7,  5,  6,  18, 17,
    13, 10, 7,  5,  4,  2,  3,  3,  3,  3,  4,  2,  1,  1,  2,  2,  2,  2,  2,
    1,  0,  1,  1,  1,  1,  2,  3,  2,  2,  3,  3,  3,  3,  5,  7,  6,  6,  7,
    6,  5,  11, 12, 12, 11, 9,  8,  7,  18, 20, 15, 13, 11, 9,  8,  6,  6,  6,
    6,  6,  5,  2,  7,  7,  7,  7,  7,  6,  2,  8,  9,  9,  8,  9,  7,  3,  8,
    12, 11, 11, 12, 11, 7,  10, 16, 16, 15, 17, 14, 9,  13, 19, 22, 20, 19, 16,
    11, 18, 23, 24, 22, 20, 18, 12, 14, 16, 15, 16, 12, 8,  4,  14, 18, 17, 18,
    14, 9,  5,  14, 20, 19, 20, 16, 11, 7,  14, 20, 22, 22, 19, 14, 10, 16, 22,
    27, 24, 22, 18, 12, 19, 25, 30, 28, 24, 20, 14, 23, 28, 31, 30, 26, 22, 16,
    22, 28, 26, 20, 16, 11, 6,  22, 28, 28, 23, 18, 12, 8,  22, 27, 31, 24, 19,
    14, 10, 22, 27, 32, 25, 22, 18, 14, 23, 28, 33, 30, 25, 22, 16, 26, 30, 34,
    32, 28, 24, 18, 28, 31, 34, 35, 29, 25, 21, 9,  12, 14, 14, 15, 13, 12, 8,
    10, 13, 14, 15, 13, 11, 6,  10, 12, 14, 14, 12, 11, 5,  8,  11, 13, 14, 13,
    12, 6,  8,  11, 14, 15, 14, 12, 8,  9,  11, 13, 15, 14, 12, 14, 14, 12, 12,
    13, 14, 12, 6,  10, 12, 13, 13, 11, 9,  6,  9,  11, 13, 13, 11, 8,  4,  7,
    10, 12, 12, 10, 9,  3,  7,  10, 12, 11, 11, 9,  4,  6,  9,  11, 11, 12, 10,
    9,  10, 12, 12, 11, 11, 9,  17, 15, 13, 12, 10, 10, 9,  4,  7,  9,  9,  9,
    8,  4,  3,  6,  8,  8,  8,  7,  4,  2,  5,  7,  7,  7,  7,  4,  2,  5,  6,
    6,  7,  7,  5,  6,  6,  7,  6,  7,  6,  5,  12, 12, 11, 10, 7,  6,  5,  19,
    18, 14, 10, 8,  6,  4,  2,  2,  3,  3,  3,  3,  2,  1,  1,  2,  2,  2,  2,
    2,  1,  1,  0,  0,  0,  0,  2,  4,  3,  3,  4,  4,  4,  5,  6,  8,  7,  7,
    8,  7,  6,  12, 14, 12, 11, 10, 8,  7,  19, 20, 16, 13, 11, 10, 9,  7,  6,
    6,  6,  6,  5,  2,  8,  8,  7,  7,  8,  6,  2,  8,  9,  9,  9,  9,  7,  4,
    8,  13, 12, 12, 12, 11, 7,  11, 17, 17, 16, 16, 14, 9,  15, 21, 23, 20, 19,
    16, 11, 19, 24, 26, 23, 21, 18, 13, 15, 17, 15, 16, 12, 8,  4,  15, 18, 18,
    17, 13, 9,  5,  15, 20, 19, 19, 15, 11, 7,  15, 21, 23, 23, 19, 15, 11, 18,
    25, 28, 26, 23, 18, 12, 20, 26, 33, 31, 26, 19, 14, 23, 29, 33, 33, 28, 22,
    16, 22, 28, 27, 21, 15, 11, 6,  22, 28, 30, 22, 17, 12, 8,  23, 28, 32, 25,
    19, 15, 11, 23, 29, 34, 28, 22, 18, 15, 24, 31, 37, 34, 28, 21, 16, 27, 34,
    39, 37, 31, 25, 18, 30, 35, 40, 40, 33, 26, 20, 9,  13, 16, 19, 19, 17, 14,
    8,  12, 15, 18, 19, 16, 13, 7,  10, 14, 17, 18, 15, 13, 6,  9,  12, 15, 17,
    15, 13, 6,  9,  11, 15, 17, 15, 13, 8,  9,  11, 14, 16, 16, 13, 14, 14, 12,
    13, 16, 15, 13, 7,  11, 14, 17, 16, 13, 10, 6,  9,  13, 16, 16, 13, 9,  5,
    8,  11, 14, 14, 11, 8,  4,  7,  10, 12, 12, 12, 9,  5,  7,  10, 12, 12, 12,
    9,  9,  10, 11, 12, 11, 11, 9,  17, 15, 13, 11, 10, 10, 9,  5,  8,  9,  10,
    11, 9,  6,  4,  6,  8,  9,  10, 9,  5,  3,  5,  7,  7,  7,  7,  4,  2,  6,
    6,  6,  6,  7,  5,  6,  7,  7,  6,  6,  6,  5,  12, 12, 11, 9,  7,  5,  5,
    19, 17, 13, 10, 7,  5,  4,  3,  2,  3,  4,  4,  5,  3,  1,  2,  2,  3,  3,
    3,  3,  1,  1,  0,  0,  0,  0,  2,  4,  3,  3,  3,  3,  3,  4,  6,  8,  7,
    7,  7,  7,  5,  12, 14, 12, 11, 10, 8,  7,  19, 20, 16, 13, 11, 10, 8,  7,
    6,  6,  7,  7,  6,  3,  8,  8,  7,  8,  8,  7,  3,  8,  9,  9,  9,  9,  7,
    4,  8,  13, 12, 12, 12, 11, 7,  11, 17, 17, 16, 16, 14, 9,  15, 21, 22, 21,
    18, 16, 11, 19, 24, 25, 23, 21, 18, 12, 15, 17, 16, 16, 13, 9,  5,  15, 19,
    18, 17, 14, 9,  5,  15, 20, 19, 18, 14, 11, 7,  15, 22, 24, 22, 19, 15, 10,
    18, 24, 28, 26, 23, 18, 12, 21, 26, 34, 32, 25, 20, 14, 24, 29, 34, 33, 27,
    22, 16, 23, 28, 27, 21, 16, 12, 7,  23, 29, 29, 22, 17, 12, 8,  23, 28, 32,
    24, 19, 15, 10, 22, 29, 35, 29, 22, 18, 14, 23, 30, 36, 34, 27, 22, 16, 27,
    32, 39, 38, 31, 24, 18, 30, 36, 40, 40, 33, 26, 20, 10, 14, 18, 20, 21, 19,
    15, 8,  12, 16, 20, 21, 17, 13, 7,  10, 15, 18, 19, 16, 13, 6,  9,  12, 15,
    19, 16, 13, 6,  9,  12, 15, 18, 16, 14, 8,  9,  11, 14, 18, 17, 13, 14, 13,
    12, 13, 16, 17, 14, 7,  11, 15, 18, 17, 14, 11, 6,  10, 13, 16, 17, 13, 9,
    5,  8,  12, 14, 14, 11, 9,  4,  7,  10, 13, 13, 12, 10, 5,  7,  10, 12, 12,
    12, 9,  10, 10, 11, 12, 12, 11, 10, 17, 15, 12, 12, 10, 11, 9,  5,  8,  10,
    11, 12, 10, 6,  4,  7,  9,  10, 10, 9,  5,  3,  6,  7,  7,  7,  7,  4,  1,
    6,  6,  6,  7,  7,  5,  6,  7,  7,  6,  6,  6,  5,  13, 12, 11, 9,  7,  6,
    5,  19, 17, 13, 10, 7,  5,  4,  3,  3,  3,  4,  5,  6,  3,  1,  1,  2,  3,
    3,  3,  2,  1,  1,  0,  0,  0,  0,  1,  4,  3,  4,  3,  3,  3,  3,  6,  8,
    7,  7,  7,  6,  5,  13, 14, 12, 11, 9,  8,  6,  19, 21, 15, 13, 11, 9,  8,
    7,  6,  6,  6,  7,  6,  3,  9,  8,  7,  7,  8,  6,  2,  9,  10, 9,  8,  8,
    7,  3,  9,  13, 12, 12, 12, 11, 7,  12, 18, 17, 16, 16, 13, 8,  15, 21, 22,
    20, 18, 15, 10, 19, 24, 26, 23, 21, 17, 12, 15, 16, 15, 15, 12, 9,  4,  15,
    19, 17, 17, 13, 9,  4,  15, 20, 19, 18, 14, 10, 7,  15, 21, 23, 21, 18, 14,
    10, 18, 24, 29, 26, 23, 17, 12, 20, 27, 33, 31, 25, 19, 14, 24, 29, 33, 33,
    28, 21, 15, 22, 27, 26, 20, 15, 11, 7,  23, 27, 27, 21, 16, 12, 7,  22, 27,
    29, 23, 18, 14, 10, 23, 28, 33, 27, 23, 18, 13, 25, 30, 35, 33, 26, 22, 16,
    27, 32, 38, 38, 30, 23, 18, 29, 34, 38, 37, 32, 25, 20, 10, 14, 17, 21, 21,
    18, 15, 9,  12, 15, 20, 20, 17, 13, 7,  11, 14, 17, 19, 15, 13, 6,  9,  12,
    16, 18, 16, 14, 6,  9,  12, 15, 19, 17, 14, 9,  10, 11, 14, 18, 17, 14, 14,
    13, 12, 14, 17, 17, 13, 7,  11, 15, 18, 17, 15, 11, 6,  10, 13, 16, 17, 13,
    9,  5,  8,  12, 15, 14, 11, 9,  4,  8,  11, 13, 13, 12, 9,  5,  7,  10, 12,
    13, 12, 10, 10, 10, 11, 12, 12, 12, 10, 16, 14, 12, 12, 11, 11, 10, 5,  8,
    10, 11, 12, 10, 6,  4,  7,  9,  10, 10, 9,  5,  3,  6,  7,  8,  7,  7,  4,
    2,  6,  7,  7,  7,  7,  5,  6,  7,  7,  7,  7,  6,  5,  13, 12, 11, 9,  7,
    5,  5,  17, 16, 12, 10, 7,  5,  4,  3,  3,  3,  4,  5,  6,  4,  1,  1,  2,
    3,  3,  3,  2,  1,  1,  0,  0,  0,  0,  1,  4,  4,  4,  3,  3,  3,  3,  7,
    9,  8,  7,  8,  6,  5,  13, 14, 12, 10, 9,  8,  6,  18, 19, 15, 13, 11, 9,
    8,  7,  6,  6,  6,  7,  6,  4,  9,  8,  7,  7,  8,  6,  2,  9,  10, 9,  8,
    8,  7,  3,  9,  14, 13, 12, 12, 10, 7,  12, 18, 17, 16, 16, 14, 9,  15, 21,
    22, 20, 18, 15, 10, 18, 23, 24, 22, 19, 17, 12, 15, 15, 14, 13, 11, 9,  4,
    16, 17, 15, 14, 12, 9,  4,  15, 19, 17, 15, 12, 10, 7,  15, 20, 21, 18, 16,
    14, 10, 18, 23, 26, 23, 20, 17, 12, 21, 25, 31, 27, 22, 18, 14, 23, 28, 31,
    29, 24, 20, 15, 20, 23, 20, 15, 13, 11, 7,  21, 23, 22, 17, 13, 11, 7,  20,
    23, 23, 19, 15, 13, 10, 20, 24, 28, 22, 18, 17, 14, 23, 26, 30, 28, 23, 19,
    16, 26, 29, 33, 32, 25, 21, 17, 28, 31, 34, 34, 27, 22, 18, 11, 13, 16, 19,
    19, 16, 13, 10, 12, 15, 18, 18, 15, 11, 8,  11, 14, 16, 17, 14, 11, 7,  9,
    12, 15, 17, 15, 12, 8,  10, 12, 15, 18, 15, 12, 8,  9,  12, 14, 17, 16, 12,
    12, 12, 11, 13, 16, 16, 12, 9,  11, 14, 16, 15, 12, 9,  7,  10, 12, 15, 14,
    11, 8,  7,  9,  12, 13, 12, 10, 7,  6,  9,  11, 13, 12, 10, 8,  6,  8,  10,
    12, 12, 11, 9,  10, 9,  10, 12, 11, 11, 8,  15, 13, 11, 11, 10, 9,  8,  7,
    9,  10, 10, 11, 9,  6,  6,  8,  9,  9,  9,  7,  4,  4,  7,  8,  7,  6,  6,
    4,  4,  8,  7,  7,  6,  6,  5,  6,  8,  7,  7,  6,  6,  5,  12, 11, 10, 8,
    6,  5,  5,  16, 15, 11, 9,  6,  5,  4,  5,  4,  4,  4,  5,  6,  4,  3,  3,
    4,  4,  3,  3,  2,  2,  2,  2,  2,  1,  1,  0,  4,  2,  3,  3,  2,  2,  2,
    7,  7,  6,  6,  6,  5,  3,  12, 13, 11, 9,  7,  6,  4,  17, 18, 13, 10, 8,
    7,  5,  4,  4,  3,  3,  3,  4,  4,  5,  5,  3,  3,  3,  3,  2,  6,  5,  4,
    4,  4,  3,  2,  5,  9,  8,  7,  7,  6,  4,  8,  14, 13, 12, 12, 9,  5,  13,
    17, 18, 16, 14, 11, 7,  16, 20, 21, 18, 15, 13, 8,  10, 10, 9,  9,  7,  4,
    3,  9,  12, 11, 10, 8,  4,  2,  9,  13, 12, 12, 8,  5,  3,  9,  15, 16, 15,
    12, 9,  6,  13, 18, 22, 20, 17, 12, 8,  16, 21, 27, 24, 19, 14, 10, 20, 24,
    27, 27, 21, 16, 11, 15, 19, 18, 13, 9,  6,  3,  15, 20, 20, 15, 10, 6,  3,
    15, 20, 22, 16, 12, 8,  5,  15, 20, 25, 20, 16, 13, 9,  18, 23, 28, 26, 21,
    16, 11, 21, 26, 31, 30, 23, 17, 13, 24, 29, 31, 32, 25, 20, 14, 13, 16, 20,
    25, 25, 24, 19, 11, 14, 18, 23, 25, 21, 17, 10, 14, 17, 20, 23, 19, 16, 8,
    12, 14, 17, 20, 18, 15, 6,  9,  12, 15, 17, 18, 15, 5,  8,  11, 13, 16, 18,
    15, 7,  8,  9,  13, 15, 18, 15, 9,  14, 17, 20, 21, 19, 15, 8,  13, 15, 19,
    21, 18, 14, 7,  11, 14, 17, 17, 15, 12, 6,  9,  12, 14, 14, 14, 11, 3,  7,
    10, 12, 13, 14, 11, 4,  6,  9,  11, 12, 12, 11, 9,  7,  8,  10, 10, 11, 11,
    7,  11, 13, 14, 16, 15, 11, 5,  10, 11, 13, 13, 14, 9,  4,  8,  10, 11, 11,
    11, 7,  3,  5,  7,  8,  8,  8,  5,  2,  4,  6,  6,  6,  6,  5,  6,  6,  5,
    5,  5,  5,  5,  10, 9,  7,  4,  3,  4,  4,  4,  6,  7,  7,  9,  11, 11, 3,
    4,  6,  6,  7,  8,  7,  1,  3,  4,  4,  4,  4,  3,  0,  0,  0,  0,  0,  0,
    0,  3,  3,  3,  3,  3,  3,  2,  6,  7,  6,  5,  4,  4,  3,  10, 12, 8,  6,
    5,  4,  4,  4,  4,  4,  4,  6,  8,  10, 4,  5,  5,  5,  5,  5,  7,  4,  5,
    6,  5,  5,  5,  2,  4,  7,  6,  6,  6,  5,  3,  5,  9,  8,  8,  8,  7,  4,
    7,  11, 11, 11, 9,  8,  5,  10, 13, 13, 12, 11, 9,  6,  9,  10, 9,  9,  8,
    6,  8,  9,  11, 10, 10, 8,  6,  4,  9,  12, 11, 11, 9,  6,  4,  9,  12, 12,
    12, 10, 7,  5,  9,  13, 15, 14, 12, 9,  6,  11, 14, 18, 16, 13, 10, 7,  13,
    16, 18, 18, 14, 11, 8,  14, 17, 16, 12, 10, 7,  6,  14, 18, 17, 14, 10, 7,
    5,  14, 17, 19, 14, 11, 8,  5,  13, 16, 20, 15, 12, 9,  7,  13, 17, 20, 17,
    15, 11, 8,  14, 18, 21, 20, 16, 12, 9,  16, 19, 22, 22, 17, 14, 10, 10, 11,
    14, 17, 17, 14, 12, 9,  11, 13, 16, 17, 14, 11, 9,  11, 12, 13, 14, 13, 10,
    8,  9,  10, 12, 13, 10, 8,  6,  7,  8,  9,  11, 9,  8,  6,  7,  8,  8,  10,
    9,  8,  12, 12, 9,  8,  9,  9,  8,  9,  10, 12, 14, 14, 12, 10, 8,  10, 11,
    13, 14, 11, 9,  7,  9,  10, 11, 11, 10, 8,  6,  8,  9,  9,  9,  8,  7,  4,
    6,  7,  8,  7,  7,  7,  7,  8,  9,  8,  7,  7,  7,  15, 13, 11, 8,  6,  7,
    7,  7,  9,  10, 9,  10, 9,  8,  5,  8,  9,  9,  9,  9,  7,  4,  8,  9,  9,
    8,  8,  7,  3,  6,  6,  7,  7,  7,  6,  3,  4,  5,  6,  6,  6,  6,  9,  9,
    10, 8,  6,  6,  6,  17, 16, 12, 9,  6,  5,  5,  4,  5,  6,  6,  6,  7,  3,
    3,  4,  5,  5,  5,  5,  3,  2,  2,  3,  3,  4,  4,  2,  0,  0,  0,  0,  0,
    0,  0,  4,  5,  4,  4,  4,  4,  3,  9,  11, 10, 9,  7,  5,  4,  17, 19, 14,
    10, 9,  7,  6,  5,  5,  6,  6,  6,  5,  3,  6,  7,  7,  7,  8,  6,  3,  6,
    8,  9,  9,  9,  7,  3,  6,  10, 9,  9,  10, 9,  4,  8,  14, 14, 14, 14, 12,
    6,  11, 17, 19, 17, 16, 14, 8,  16, 21, 21, 19, 17, 16, 10, 13, 16, 16, 16,
    13, 8,  3,  14, 18, 17, 17, 14, 9,  5,  14, 19, 20, 18, 15, 10, 6,  14, 19,
    20, 19, 17, 13, 8,  14, 20, 22, 21, 18, 16, 10, 17, 21, 26, 23, 21, 17, 12,
    20, 23, 26, 25, 21, 19, 14, 22, 26, 25, 20, 16, 11, 6,  21, 26, 26, 21, 17,
    13, 8,  22, 26, 28, 23, 19, 14, 9,  21, 26, 28, 23, 19, 16, 12, 21, 25, 28,
    25, 20, 18, 14, 22, 26, 29, 28, 23, 19, 16, 23, 26, 30, 28, 24, 21, 17, 13,
    16, 18, 20, 19, 17, 16, 11, 14, 17, 19, 20, 17, 15, 10, 14, 17, 18, 18, 15,
    13, 8,  11, 14, 16, 17, 14, 12, 6,  9,  12, 13, 15, 13, 12, 5,  8,  11, 13,
    15, 14, 12, 11, 11, 10, 13, 14, 14, 12, 10, 13, 16, 18, 17, 16, 13, 9,  12,
    16, 18, 17, 16, 13, 7,  11, 14, 16, 16, 14, 11, 6,  9,  12, 14, 13, 12, 10,
    4,  7,  10, 12, 12, 12, 10, 7,  8,  9,  11, 11, 11, 10, 14, 12, 10, 10, 10,
    10, 10, 7,  11, 13, 14, 15, 13, 9,  6,  10, 12, 13, 13, 12, 8,  5,  8,  11,
    11, 11, 11, 7,  3,  6,  7,  7,  8,  8,  5,  3,  5,  6,  6,  6,  7,  5,  9,
    9,  9,  7,  5,  5,  5,  16, 15, 11, 8,  5,  5,  4,  5,  5,  6,  7,  8,  8,
    5,  3,  4,  5,  6,  6,  6,  4,  2,  2,  3,  4,  4,  4,  3,  0,  0,  0,  0,
    0,  0,  0,  4,  4,  4,  4,  4,  3,  2,  9,  11, 9,  8,  6,  5,  4,  16, 18,
    12, 9,  8,  6,  5,  5,  5,  6,  6,  7,  6,  5,  7,  7,  7,  7,  8,  6,  4,
    7,  8,  8,  8,  8,  6,  3,  7,  10, 9,  9,  9,  7,  4,  8,  14, 13, 13, 13,
    11, 5,  11, 17, 18, 17, 15, 12, 7,  15, 20, 21, 19, 17, 15, 9,  14, 15, 15,
    16, 13, 8,  5,  14, 17, 17, 16, 14, 9,  4,  14, 20, 19, 18, 14, 9,  5,  14,
    19, 21, 19, 15, 11, 7,  14, 20, 24, 23, 19, 14, 9,  17, 23, 29, 28, 22, 16,
    11, 20, 25, 30, 30, 24, 19, 13, 22, 28, 27, 21, 16, 11, 7,  22, 28, 29, 23,
    16, 12, 7,  22, 28, 32, 24, 17, 12, 8,  22, 28, 33, 25, 20, 15, 11, 21, 27,
    33, 30, 24, 19, 13, 23, 30, 35, 34, 27, 21, 15, 25, 31, 35, 36, 29, 23, 17,
    13, 16, 20, 23, 24, 21, 18, 11, 15, 19, 23, 23, 19, 16, 10, 14, 17, 21, 21,
    19, 15, 9,  11, 15, 18, 20, 16, 14, 6,  9,  12, 15, 18, 16, 13, 6,  8,  11,
    14, 17, 16, 14, 11, 11, 11, 13, 16, 16, 13, 10, 14, 17, 20, 20, 17, 14, 9,
    13, 16, 20, 20, 16, 13, 7,  11, 15, 18, 17, 15, 11, 6,  9,  12, 14, 14, 13,
    10, 4,  7,  10, 13, 13, 13, 10, 7,  7,  9,  11, 12, 12, 10, 14, 12, 10, 11,
    11, 11, 10, 8,  11, 13, 14, 15, 14, 9,  6,  10, 12, 13, 14, 13, 8,  5,  8,
    11, 10, 11, 11, 7,  4,  6,  7,  7,  8,  8,  5,  4,  5,  6,  6,  6,  6,  5,
    9,  9,  8,  7,  5,  5,  5,  16, 14, 10, 7,  5,  4,  4,  5,  6,  6,  7,  8,
    9,  6,  3,  4,  5,  6,  6,  6,  5,  2,  3,  3,  4,  3,  4,  3,  0,  0,  0,
    0,  0,  0,  0,  4,  5,  4,  4,  4,  3,  2,  9,  11, 9,  7,  6,  5,  3,  16,
    17, 12, 9,  7,  6,  5,  6,  6,  6,  6,  7,  6,  6,  7,  7,  7,  7,  8,  6,
    5,  7,  8,  8,  8,  8,  6,  3,  7,  10, 9,  9,  9,  7,  4,  9,  14, 13, 13,
    13, 10, 5,  11, 17, 19, 17, 15, 12, 7,  15, 19, 22, 19, 17, 14, 9,  14, 15,
    15, 15, 12, 9,  6,  14, 18, 17, 16, 13, 9,  4,  14, 19, 19, 18, 14, 9,  5,
    14, 19, 20, 19, 15, 11, 7,  14, 20, 25, 23, 19, 14, 9,  17, 23, 29, 28, 21,
    16, 10, 20, 26, 30, 30, 24, 18, 12, 22, 27, 26, 20, 15, 11, 7,  22, 28, 29,
    22, 16, 12, 7,  21, 28, 31, 23, 17, 12, 7,  22, 27, 31, 24, 19, 15, 11, 21,
    28, 33, 29, 24, 18, 12, 24, 29, 35, 34, 27, 20, 14, 26, 31, 36, 36, 29, 22,
    16, 13, 17, 21, 24, 24, 21, 18, 12, 15, 19, 23, 24, 20, 16, 10, 14, 17, 21,
    22, 18, 15, 9,  12, 15, 18, 21, 17, 14, 6,  9,  12, 15, 19, 17, 14, 6,  8,
    11, 14, 18, 17, 14, 11, 10, 10, 13, 16, 16, 14, 10, 14, 18, 22, 20, 18, 14,
    9,  13, 17, 20, 20, 16, 12, 8,  11, 15, 18, 17, 14, 11, 7,  9,  12, 14, 14,
    13, 9,  5,  7,  10, 12, 13, 12, 10, 7,  8,  9,  11, 12, 12, 10, 13, 11, 10,
    11, 11, 11, 10, 8,  11, 13, 14, 15, 14, 10, 6,  10, 12, 13, 14, 12, 8,  5,
    9,  10, 11, 10, 11, 6,  4,  7,  7,  7,  7,  7,  5,  4,  5,  6,  6,  6,  6,
    5,  10, 9,  8,  7,  5,  5,  5,  15, 13, 10, 7,  5,  4,  4,  5,  6,  6,  7,
    8,  9,  6,  4,  4,  5,  6,  6,  6,  4,  2,  3,  4,  3,  3,  3,  2,  0,  0,
    0,  0,  0,  0,  0,  4,  5,  4,  4,  4,  3,  2,  9,  11, 9,  7,  6,  5,  3,
    15, 16, 12, 9,  7,  6,  5,  6,  6,  6,  6,  7,  6,  6,  7,  7,  7,  7,  8,
    6,  4,  7,  8,  8,  8,  8,  6,  2,  7,  10, 9,  9,  9,  7,  4,  9,  14, 14,
    12, 13, 10, 5,  12, 17, 19, 17, 15, 12, 7,  15, 20, 22, 19, 17, 14, 9,  14,
    16, 15, 15, 12, 8,  6,  15, 18, 17, 17, 14, 9,  4,  15, 19, 19, 18, 14, 9,
    5,  14, 19, 20, 19, 15, 10, 7,  15, 21, 24, 23, 19, 14, 9,  17, 23, 30, 27,
    21, 16, 11, 20, 25, 30, 29, 24, 18, 12, 22, 27, 26, 20, 15, 11, 7,  22, 27,
    27, 21, 16, 11, 7,  22, 27, 30, 23, 17, 12, 7,  22, 27, 30, 24, 19, 15, 11,
    22, 26, 32, 29, 23, 18, 13, 24, 29, 34, 34, 26, 20, 14, 26, 31, 35, 35, 28,
    22, 16, 13, 17, 20, 24, 25, 22, 19, 12, 16, 19, 24, 24, 21, 16, 10, 14, 18,
    21, 23, 19, 15, 9,  12, 15, 19, 21, 17, 14, 7,  10, 12, 16, 19, 16, 14, 6,
    9,  11, 15, 18, 18, 14, 9,  9,  10, 13, 17, 17, 14, 11, 14, 18, 21, 21, 18,
    14, 9,  13, 17, 20, 20, 17, 13, 8,  11, 15, 17, 18, 15, 11, 7,  9,  12, 15,
    14, 13, 9,  5,  8,  10, 13, 13, 13, 10, 7,  7,  9,  12, 12, 12, 10, 10, 9,
    9,  11, 11, 11, 10, 8,  12, 13, 15, 16, 14, 10, 7,  10, 12, 13, 14, 12, 8,
    5,  9,  11, 11, 10, 10, 6,  4,  7,  8,  7,  7,  8,  5,  4,  5,  7,  6,  6,
    6,  5,  9,  8,  7,  6,  5,  5,  5,  11, 10, 8,  6,  4,  4,  4,  6,  6,  6,
    7,  9,  9,  6,  4,  4,  5,  6,  6,  7,  4,  2,  3,  4,  4,  3,  3,  2,  0,
    0,  0,  0,  0,  0,  0,  4,  5,  4,  4,  4,  3,  2,  9,  9,  8,  6,  6,  5,
    3,  12, 13, 10, 8,  7,  6,  5,  6,  6,  6,  6,  7,  6,  6,  7,  7,  7,  8,
    8,  6,  4,  7,  9,  8,  8,  8,  6,  2,  7,  11, 9,  9,  9,  7,  3,  9,  15,
    13, 13, 13, 10, 5,  12, 16, 17, 16, 14, 12, 7,  13, 18, 19, 18, 16, 13, 8,
    14, 15, 14, 13, 12, 8,  6,  15, 17, 15, 14, 12, 9,  4,  15, 18, 17, 15, 12,
    9,  5,  14, 18, 18, 15, 14, 11, 7,  15, 20, 22, 20, 17, 13, 8,  17, 22, 25,
    22, 18, 15, 10, 18, 23, 26, 24, 21, 16, 12, 20, 22, 20, 15, 13, 10, 7,  20,
    23, 22, 17, 14, 11, 7,  20, 23, 23, 17, 14, 11, 7,  20, 23, 24, 19, 16, 14,
    10, 20, 23, 27, 24, 20, 16, 12, 22, 26, 29, 29, 22, 18, 14, 24, 27, 29, 29,
    24, 19, 15, 12, 15, 18, 21, 20, 18, 15, 11, 13, 17, 20, 20, 17, 13, 10, 13,
    15, 18, 18, 15, 12, 9,  11, 13, 15, 18, 14, 11, 7,  9,  11, 14, 17, 14, 11,
    6,  8,  10, 12, 16, 14, 11, 8,  9,  10, 12, 14, 14, 11, 11, 13, 16, 18, 17,
    15, 11, 10, 12, 14, 17, 16, 13, 10, 8,  11, 14, 15, 14, 11, 8,  8,  9,  11,
    13, 12, 10, 7,  6,  8,  10, 11, 11, 10, 7,  5,  7,  9,  11, 10, 10, 7,  10,
    9,  9,  10, 9,  9,  7,  8,  11, 12, 12, 13, 11, 8,  8,  10, 11, 11, 11, 10,
    6,  7,  9,  10, 9,  8,  8,  5,  5,  8,  7,  6,  6,  6,  4,  3,  5,  6,  5,
    5,  5,  4,  7,  7,  7,  6,  5,  4,  4,  11, 11, 8,  6,  5,  3,  3,  7,  6,
    6,  6,  7,  8,  6,  4,  5,  5,  6,  6,  5,  4,  2,  3,  4,  4,  3,  3,  2,
    0,  0,  0,  0,  0,  0,  0,  3,  4,  3,  3,  3,  3,  2,  7,  9,  7,  6,  5,
    4,  3,  12, 13, 10, 8,  6,  5,  4,  4,  4,  5,  5,  6,  6,  6,  5,  6,  5,
    6,  6,  5,  4,  6,  7,  7,  6,  6,  5,  2,  6,  8,  7,  7,  7,  6,  3,  7,
    12, 11, 11, 11, 8,  4,  10, 15, 16, 14, 12, 10, 6,  13, 17, 19, 16, 14, 12,
    7,  11, 13, 12, 12, 10, 7,  6,  11, 14, 13, 13, 10, 7,  4,  12, 16, 16, 14,
    11, 7,  4,  11, 16, 16, 15, 12, 9,  6,  12, 17, 21, 19, 15, 11, 7,  15, 20,
    24, 23, 18, 13, 8,  17, 21, 25, 25, 20, 15, 10, 18, 22, 21, 16, 12, 9,  5,
    18, 22, 23, 17, 13, 9,  5,  18, 22, 25, 18, 13, 10, 6,  18, 22, 26, 21, 16,
    12, 9,  18, 23, 27, 24, 19, 15, 10, 20, 25, 30, 28, 21, 16, 11, 22, 26, 30,
    30, 24, 18, 13, 13, 17, 21, 26, 25, 22, 19, 11, 15, 19, 23, 25, 22, 19, 10,
    14, 18, 21, 24, 21, 17, 9,  12, 15, 18, 21, 19, 15, 6,  9,  12, 15, 16, 18,
    15, 3,  6,  10, 13, 16, 17, 15, 4,  6,  8,  12, 15, 18, 15, 10, 14, 18, 21,
    21, 18, 16, 9,  13, 16, 20, 21, 18, 14, 7,  11, 15, 17, 18, 18, 12, 6,  9,
    12, 15, 15, 15, 10, 3,  6,  9,  12, 12, 14, 10, 2,  4,  7,  10, 12, 11, 10,
    6,  5,  6,  9,  10, 10, 10, 7,  11, 14, 15, 16, 15, 12, 6,  10, 12, 13, 15,
    14, 10, 5,  8,  11, 11, 12, 12, 8,  5,  6,  8,  8,  9,  9,  5,  1,  3,  4,
    5,  5,  6,  5,  4,  3,  3,  3,  3,  4,  5,  8,  7,  4,  2,  2,  2,  3,  6,
    6,  8,  9,  10, 11, 9,  5,  6,  7,  8,  8,  9,  8,  4,  5,  6,  6,  6,  7,
    7,  3,  4,  4,  4,  4,  4,  3,  0,  2,  1,  1,  2,  1,  3,  4,  5,  4,  3,
    2,  2,  3,  8,  9,  6,  4,  3,  2,  3,  4,  6,  6,  6,  7,  8,  9,  5,  6,
    6,  6,  7,  7,  8,  5,  6,  7,  7,  7,  6,  6,  5,  7,  6,  6,  6,  5,  3,
    4,  7,  6,  6,  6,  5,  3,  5,  9,  9,  8,  7,  6,  4,  8,  11, 11, 9,  9,
    7,  4,  9,  11, 11, 11, 9,  7,  8,  9,  12, 11, 12, 10, 7,  7,  10, 13, 12,
    12, 10, 8,  6,  9,  12, 12, 12, 9,  7,  4,  8,  11, 13, 12, 10, 7,  5,  9,
    12, 16, 15, 11, 8,  5,  11, 13, 16, 16, 12, 9,  6,  14, 18, 17, 14, 11, 8,
    7,  14, 18, 19, 14, 12, 9,  7,  14, 19, 21, 14, 12, 9,  7,  14, 17, 20, 15,
    11, 8,  5,  13, 16, 19, 16, 12, 9,  6,  13, 17, 19, 18, 14, 10, 7,  14, 17,
    20, 19, 15, 11, 8,  15, 17, 19, 22, 22, 19, 17, 15, 16, 18, 21, 22, 19, 16,
    14, 16, 18, 19, 20, 18, 14, 13, 14, 15, 17, 18, 15, 10, 10, 11, 12, 13, 14,
    12, 10, 6,  8,  9,  9,  12, 12, 10, 8,  8,  8,  9,  11, 12, 10, 13, 16, 17,
    19, 19, 18, 16, 13, 14, 17, 18, 18, 16, 15, 11, 14, 16, 17, 16, 15, 13, 10,
    12, 14, 14, 14, 13, 9,  7,  9,  10, 11, 10, 9,  9,  3,  6,  7,  8,  9,  9,
    9,  10, 9,  7,  8,  8,  8,  9,  12, 14, 16, 15, 16, 16, 14, 10, 13, 15, 15,
    15, 15, 13, 9,  13, 14, 14, 14, 13, 12, 7,  10, 11, 11, 12, 11, 9,  3,  6,
    8,  8,  8,  8,  8,  5,  5,  5,  6,  7,  7,  8,  12, 12, 8,  5,  6,  6,  8,
    9,  10, 11, 12, 12, 13, 10, 7,  8,  9,  10, 11, 11, 9,  6,  7,  8,  8,  8,
    9,  8,  3,  4,  4,  5,  5,  5,  4,  2,  0,  0,  0,  0,  2,  3,  5,  7,  6,
    4,  2,  1,  3,  12, 14, 9,  6,  4,  3,  3,  4,  5,  7,  8,  9,  9,  10, 5,
    6,  6,  7,  8,  8,  9,  5,  7,  7,  7,  7,  6,  7,  5,  8,  8,  8,  8,  6,
    3,  4,  10, 10, 10, 10, 9,  3,  7,  12, 13, 12, 12, 10, 5,  12, 14, 15, 13,
    12, 11, 7,  12, 14, 14, 15, 11, 8,  9,  12, 16, 15, 16, 13, 8,  8,  12, 18,
    18, 17, 14, 9,  6,  12, 16, 18, 16, 14, 10, 5,  12, 16, 17, 16, 14, 11, 7,
    12, 16, 19, 17, 15, 12, 9,  14, 17, 19, 18, 15, 13, 10, 20, 23, 22, 19, 14,
    10, 8,  19, 23, 23, 19, 15, 12, 7,  19, 23, 25, 20, 16, 12, 7,  19, 22, 25,
    19, 16, 13, 9,  18, 21, 23, 20, 16, 14, 10, 17, 19, 23, 22, 17, 13, 12, 18,
    21, 23, 23, 18, 14, 12, 17, 20, 22, 25, 24, 23, 20, 15, 19, 21, 24, 24, 21,
    19, 14, 17, 21, 22, 22, 20, 17, 13, 15, 18, 20, 21, 18, 13, 9,  12, 15, 17,
    17, 15, 13, 6,  9,  11, 14, 16, 15, 13, 7,  8,  10, 13, 15, 15, 13, 14, 17,
    20, 22, 21, 20, 18, 13, 16, 21, 22, 21, 19, 16, 11, 15, 18, 19, 20, 17, 15,
    10, 12, 16, 17, 17, 16, 11, 7,  9,  12, 14, 13, 12, 11, 4,  7,  9,  12, 12,
    12, 11, 10, 9,  8,  11, 11, 12, 11, 11, 15, 17, 18, 19, 18, 14, 10, 13, 16,
    17, 18, 16, 12, 8,  12, 14, 14, 15, 15, 11, 7,  10, 11, 11, 11, 11, 7,  4,
    6,  7,  8,  7,  8,  7,  4,  5,  5,  6,  6,  7,  7,  11, 11, 7,  4,  5,  5,
    6,  9,  9,  10, 11, 13, 13, 10, 7,  8,  9,  10, 10, 11, 9,  6,  7,  7,  7,
    7,  8,  6,  3,  4,  4,  4,  4,  4,  3,  1,  0,  0,  0,  0,  1,  2,  5,  6,
    5,  4,  2,  2,  2,  11, 13, 8,  6,  4,  3,  3,  4,  5,  6,  8,  9,  10, 10,
    6,  6,  6,  7,  8,  8,  9,  6,  7,  7,  7,  7,  6,  6,  6,  9,  8,  8,  8,
    6,  2,  5,  10, 10, 9,  9,  8,  3,  7,  13, 14, 13, 12, 9,  5,  11, 16, 18,
    15, 14, 11, 6,  13, 15, 15, 15, 11, 9,  10, 12, 16, 16, 16, 12, 8,  8,  13,
    18, 18, 17, 13, 9,  5,  13, 18, 19, 18, 15, 10, 5,  12, 18, 21, 20, 16, 11,
    6,  12, 19, 25, 24, 19, 13, 8,  16, 21, 26, 26, 21, 15, 10, 20, 27, 26, 20,
    15, 10, 9,  21, 27, 28, 22, 16, 11, 7,  20, 28, 31, 23, 17, 12, 7,  21, 26,
    31, 24, 18, 13, 8,  20, 25, 31, 27, 21, 15, 10, 20, 26, 31, 31, 23, 17, 11,
    22, 28, 32, 32, 25, 19, 13, 17, 21, 24, 28, 27, 25, 22, 15, 20, 23, 26, 26,
    24, 20, 14, 18, 21, 24, 25, 22, 19, 13, 16, 19, 21, 23, 20, 15, 9,  12, 15,
    18, 20, 18, 15, 6,  9,  12, 15, 18, 17, 15, 7,  7,  11, 14, 17, 18, 14, 14,
    18, 21, 25, 24, 22, 18, 13, 16, 21, 24, 24, 21, 17, 11, 15, 18, 21, 21, 18,
    14, 10, 13, 15, 17, 18, 16, 11, 7,  10, 12, 14, 15, 14, 11, 4,  7,  10, 12,
    13, 13, 11, 9,  8,  9,  11, 11, 12, 11, 11, 15, 17, 18, 20, 18, 14, 10, 14,
    16, 17, 18, 16, 12, 8,  12, 14, 14, 15, 15, 10, 8,  10, 11, 11, 11, 11, 7,
    4,  6,  7,  7,  8,  7,  7,  5,  5,  6,  6,  6,  6,  7,  11, 10, 7,  4,  5,
    5,  6,  9,  9,  10, 11, 13, 13, 10, 7,  8,  9,  10, 10, 10, 8,  6,  6,  7,
    7,  7,  7,  6,  3,  4,  4,  4,  4,  4,  3,  1,  0,  0,  0,  0,  1,  2,  5,
    6,  5,  4,  2,  2,  2,  10, 11, 8,  5,  4,  3,  3,  5,  5,  6,  8,  8,  10,
    10, 6,  6,  6,  7,  8,  8,  8,  6,  7,  8,  7,  7,  6,  5,  6,  9,  8,  8,
    8,  6,  2,  5,  10, 10, 9,  9,  7,  3,  7,  13, 14, 13, 11, 9,  4,  10, 15,
    18, 15, 13, 11, 6,  13, 14, 14, 15, 11, 9,  10, 13, 17, 16, 16, 12, 8,  7,
    13, 19, 18, 17, 13, 8,  5,  13, 18, 19, 18, 14, 9,  4,  12, 17, 21, 19, 15,
    10, 6,  13, 19, 24, 23, 18, 12, 8,  16, 22, 26, 26, 20, 14, 9,  21, 27, 26,
    20, 15, 10, 8,  21, 27, 28, 21, 16, 11, 6,  20, 26, 31, 22, 17, 12, 6,  20,
    26, 31, 23, 18, 13, 7,  19, 26, 30, 27, 20, 14, 9,  20, 25, 31, 30, 23, 16,
    11, 22, 27, 32, 32, 25, 19, 12, 17, 20, 24, 28, 29, 26, 23, 16, 20, 24, 28,
    28, 24, 20, 14, 18, 22, 25, 26, 23, 19, 13, 16, 19, 22, 25, 21, 15, 10, 13,
    15, 19, 21, 19, 15, 7,  9,  13, 15, 20, 18, 16, 5,  8,  12, 15, 17, 19, 15,
    14, 18, 22, 26, 25, 22, 19, 13, 17, 20, 24, 24, 21, 17, 11, 15, 19, 22, 21,
    19, 15, 10, 13, 16, 18, 18, 17, 12, 7,  10, 12, 14, 15, 14, 11, 4,  7,  10,
    12, 13, 14, 12, 5,  6,  9,  12, 12, 12, 11, 11, 16, 17, 18, 20, 18, 14, 10,
    14, 16, 17, 18, 16, 12, 9,  13, 15, 14, 15, 14, 10, 8,  11, 11, 11, 12, 11,
    7,  4,  7,  8,  8,  8,  8,  7,  4,  5,  6,  6,  6,  6,  7,  6,  5,  5,  5,
    5,  5,  6,  9,  9,  10, 12, 13, 14, 10, 8,  8,  9,  10, 10, 10, 8,  7,  7,
    8,  7,  7,  7,  6,  3,  4,  4,  4,  4,  4,  3,  2,  0,  0,  0,  0,  1,  2,
    5,  5,  3,  2,  2,  1,  1,  6,  7,  4,  4,  3,  2,  2,  5,  5,  6,  8,  9,
    10, 10, 6,  6,  6,  7,  8,  8,  8,  6,  7,  7,  7,  7,  5,  5,  6,  9,  8,
    7,  8,  6,  2,  6,  11, 9,  9,  9,  7,  3,  7,  12, 13, 12, 10, 8,  4,  7,
    12, 15, 14, 12, 10, 5,  13, 15, 14, 14, 11, 9,  10, 13, 17, 16, 15, 12, 8,
    7,  13, 19, 18, 16, 13, 8,  4,  13, 18, 19, 18, 13, 9,  4,  13, 17, 20, 19,
    15, 10, 5,  13, 18, 24, 22, 18, 11, 7,  13, 18, 24, 25, 19, 14, 8,  20, 26,
    24, 19, 14, 10, 9,  20, 26, 27, 21, 15, 10, 6,  21, 26, 28, 21, 16, 11, 6,
    21, 25, 29, 23, 17, 12, 7,  20, 25, 28, 25, 19, 14, 9,  20, 26, 30, 27, 21,
    15, 10, 20, 26, 30, 30, 24, 17, 12, 16, 20, 24, 28, 28, 26, 21, 15, 19, 23,
    27, 28, 24, 20, 13, 17, 21, 24, 26, 22, 18, 12, 15, 18, 21, 24, 20, 15, 9,
    12, 15, 17, 21, 18, 15, 7,  10, 12, 16, 19, 18, 16, 5,  8,  11, 15, 18, 18,
    15, 14, 17, 21, 25, 24, 21, 18, 12, 16, 20, 23, 23, 20, 16, 11, 14, 18, 20,
    21, 18, 14, 9,  12, 15, 18, 18, 16, 11, 7,  9,  11, 14, 14, 14, 11, 4,  7,
    10, 13, 13, 14, 11, 5,  6,  9,  12, 12, 12, 11, 11, 15, 17, 17, 19, 17, 13,
    9,  13, 15, 16, 17, 16, 11, 8,  12, 14, 14, 14, 14, 9,  7,  10, 10, 10, 11,
    11, 7,  3,  6,  7,  7,  7,  8,  6,  4,  5,  6,  6,  6,  6,  7,  7,  5,  5,
    5,  5,  5,  5,  8,  9,  10, 11, 12, 13, 9,  7,  7,  8,  9,  10, 9,  7,  5,
    6,  7,  7,  6,  6,  5,  3,  4,  3,  3,  3,  3,  3,  1,  2,  1,  1,  1,  0,
    1,  4,  5,  3,  3,  2,  2,  1,  7,  8,  5,  4,  3,  2,  2,  5,  5,  5,  7,
    8,  9,  9,  7,  6,  6,  7,  7,  7,  7,  7,  8,  7,  7,  7,  5,  4,  7,  10,
    8,  7,  7,  6,  2,  6,  11, 10, 9,  9,  7,  2,  8,  12, 12, 11, 10, 8,  4,
    8,  12, 15, 12, 11, 10, 5,  14, 14, 13, 12, 11, 8,  9,  14, 16, 15, 14, 11,
    8,  6,  14, 18, 16, 14, 11, 8,  4,  14, 18, 17, 14, 12, 8,  4,  12, 17, 19,
    16, 13, 10, 5,  13, 17, 21, 18, 14, 11, 7,  14, 18, 21, 20, 15, 12, 8,  19,
    22, 19, 15, 12, 10, 7,  19, 22, 21, 17, 14, 10, 6,  20, 22, 23, 17, 13, 10,
    6,  19, 22, 23, 18, 14, 11, 7,  18, 21, 23, 20, 16, 12, 8,  18, 21, 23, 23,
    17, 13, 10, 19, 22, 24, 24, 19, 15, 11, 14, 18, 21, 23, 24, 21, 18, 14, 17,
    20, 23, 23, 20, 16, 12, 15, 19, 21, 22, 18, 15, 11, 14, 16, 19, 20, 17, 14,
    8,  11, 13, 16, 20, 18, 14, 7,  10, 13, 15, 19, 18, 14, 6,  8,  12, 15, 18,
    17, 14, 13, 16, 18, 21, 20, 18, 15, 11, 15, 17, 20, 19, 16, 13, 10, 13, 16,
    18, 17, 15, 12, 9,  11, 14, 16, 15, 14, 11, 6,  9,  12, 14, 14, 13, 10, 5,
    8,  11, 13, 13, 12, 11, 7,  7,  9,  12, 12, 12, 11, 10, 14, 15, 15, 16, 14,
    11, 8,  12, 14, 15, 14, 13, 10, 7,  11, 13, 12, 12, 12, 8,  6,  9,  9,  9,
    9,  9,  6,  3,  7,  8,  7,  7,  7,  6,  4,  5,  6,  6,  6,  6,  6,  8,  7,
    6,  5,  5,  5,  5,  8,  8,  9,  9,  10, 11, 7,  6,  6,  7,  8,  8,  8,  5,
    4,  5,  6,  5,  5,  5,  3,  2,  3,  2,  2,  2,  2,  2,  3,  3,  2,  2,  2,
    1,  0,  5,  5,  4,  3,  2,  2,  1,  7,  10, 6,  4,  3,  2,  2,  4,  4,  4,
    5,  6,  7,  7,  5,  5,  4,  4,  5,  5,  5,  5,  4,  4,  3,  3,  2,  2,  4,
    6,  4,  4,  4,  3,  1,  5,  8,  8,  7,  7,  5,  2,  6,  11, 12, 11, 9,  7,
    3,  9,  13, 15, 12, 11, 8,  4,  8,  9,  9,  9,  7,  6,  7,  8,  11, 10, 10,
    7,  4,  4,  8,  12, 12, 11, 7,  4,  2,  8,  12, 13, 12, 9,  6,  3,  9,  13,
    17, 15, 12, 8,  4,  11, 16, 21, 19, 14, 10, 5,  13, 18, 21, 21, 16, 11, 7,
    15, 19, 17, 13, 9,  6,  6,  14, 18, 19, 14, 9,  6,  3,  14, 19, 21, 15, 10,
    6,  3,  14, 18, 22, 16, 12, 9,  6,  14, 18, 23, 21, 16, 11, 7,  16, 21, 25,
    25, 19, 13, 8,  19, 23, 25, 26, 20, 15, 10, 14, 17, 22, 25, 25, 23, 20, 13,
    16, 20, 24, 25, 22, 18, 13, 15, 18, 21, 24, 19, 16, 12, 13, 16, 19, 21, 17,
    14, 9,  10, 12, 14, 15, 16, 13, 5,  6,  8,  11, 13, 15, 13, 3,  3,  6,  9,
    13, 15, 13, 13, 15, 18, 22, 22, 19, 17, 12, 14, 17, 21, 21, 18, 16, 11, 13,
    16, 18, 18, 16, 12, 11, 11, 13, 15, 15, 13, 7,  8,  8,  9,  11, 10, 11, 8,
    3,  3,  5,  8,  9,  9,  8,  4,  3,  4,  7,  8,  8,  7,  12, 13, 15, 16, 17,
    17, 16, 11, 13, 14, 15, 16, 16, 14, 10, 12, 13, 13, 13, 14, 12, 10, 10, 10,
    10, 11, 10, 6,  6,  6,  6,  6,  5,  5,  5,  0,  2,  1,  2,  4,  4,  5,  5,
    4,  2,  1,  3,  4,  5,  11, 12, 13, 13, 15, 16, 16, 10, 11, 12, 14, 14, 15,
    14, 9,  10, 12, 12, 13, 13, 12, 6,  9,  9,  9,  9,  9,  7,  4,  5,  5,  5,
    5,  4,  4,  0,  2,  2,  1,  2,  3,  5,  5,  6,  3,  2,  3,  3,  4,  9,  11,
    12, 13, 14, 15, 16, 8,  9,  11, 12, 13, 14, 14, 8,  9,  10, 11, 11, 12, 12,
    8,  8,  8,  8,  8,  8,  5,  5,  7,  7,  6,  6,  5,  4,  3,  6,  7,  7,  7,
    6,  4,  5,  8,  9,  8,  8,  7,  5,  10, 11, 12, 12, 12, 14, 15, 10, 12, 12,
    13, 12, 12, 14, 10, 13, 13, 13, 11, 10, 11, 10, 12, 13, 12, 11, 8,  5,  8,
    11, 12, 12, 9,  7,  5,  7,  10, 14, 13, 10, 8,  5,  8,  11, 14, 14, 11, 9,
    6,  14, 19, 17, 15, 12, 12, 14, 15, 19, 19, 16, 13, 11, 12, 15, 19, 21, 15,
    13, 10, 9,  15, 18, 21, 15, 12, 9,  6,  13, 16, 18, 15, 11, 9,  7,  12, 15,
    18, 17, 13, 9,  7,  12, 16, 18, 19, 14, 11, 8,  21, 23, 24, 27, 27, 25, 23,
    20, 23, 25, 26, 26, 23, 21, 20, 22, 23, 24, 24, 22, 18, 18, 20, 21, 21, 21,
    18, 12, 15, 17, 18, 17, 16, 13, 12, 11, 13, 13, 12, 13, 13, 12, 6,  8,  10,
    12, 13, 13, 12, 19, 22, 23, 25, 25, 24, 23, 18, 21, 23, 25, 24, 22, 21, 17,
    21, 22, 22, 21, 20, 18, 16, 19, 20, 20, 19, 16, 11, 12, 15, 16, 16, 12, 12,
    11, 8,  11, 12, 10, 11, 11, 11, 4,  6,  9,  10, 10, 11, 11, 17, 20, 21, 23,
    23, 23, 20, 15, 19, 21, 22, 22, 21, 18, 14, 18, 20, 20, 19, 20, 16, 13, 15,
    16, 16, 16, 15, 11, 8,  12, 13, 13, 10, 10, 10, 2,  7,  8,  8,  9,  9,  10,
    5,  6,  6,  7,  8,  9,  10, 14, 15, 17, 18, 19, 20, 18, 12, 13, 16, 17, 17,
    17, 16, 10, 12, 13, 14, 14, 14, 13, 7,  11, 11, 11, 11, 9,  9,  4,  7,  6,
    6,  4,  5,  5,  2,  0,  0,  2,  3,  4,  6,  5,  7,  3,  2,  2,  3,  4,  11,
    12, 13, 15, 16, 17, 18, 8,  11, 13, 14, 15, 15, 16, 8,  10, 11, 11, 12, 13,
    12, 8,  8,  8,  8,  8,  7,  5,  6,  7,  7,  7,  8,  6,  4,  3,  8,  9,  8,
    8,  8,  3,  5,  8,  9,  9,  9,  8,  5,  10, 12, 12, 13, 13, 16, 18, 10, 14,
    14, 15, 12, 14, 14, 10, 15, 15, 14, 11, 10, 11, 9,  14, 15, 13, 12, 7,  3,
    9,  13, 14, 13, 10, 9,  5,  9,  12, 14, 13, 11, 9,  7,  9,  11, 14, 14, 12,
    10, 8,  17, 20, 19, 17, 13, 14, 16, 17, 20, 20, 18, 14, 11, 13, 17, 20, 22,
    17, 14, 9,  9,  17, 19, 21, 16, 13, 11, 7,  15, 17, 19, 16, 12, 10, 8,  13,
    16, 18, 17, 13, 10, 8,  12, 15, 18, 18, 14, 11, 9,  21, 24, 28, 30, 29, 29,
    26, 20, 24, 27, 28, 30, 27, 23, 18, 23, 26, 27, 27, 24, 20, 17, 20, 23, 24,
    25, 21, 15, 14, 17, 20, 21, 19, 17, 15, 10, 13, 15, 16, 18, 17, 15, 6,  9,
    12, 15, 17, 17, 15, 19, 23, 25, 28, 28, 26, 23, 17, 21, 25, 27, 27, 24, 21,
    16, 19, 24, 25, 24, 22, 18, 15, 17, 21, 22, 21, 18, 13, 12, 14, 17, 18, 15,
    14, 13, 7,  10, 12, 14, 14, 14, 13, 4,  6,  10, 13, 13, 13, 13, 16, 20, 22,
    23, 25, 22, 18, 15, 18, 20, 22, 22, 21, 17, 14, 17, 19, 19, 19, 19, 14, 12,
    15, 16, 16, 15, 14, 9,  7,  11, 12, 12, 10, 10, 9,  2,  7,  7,  8,  8,  8,
    9,  5,  5,  6,  6,  7,  7,  8,  14, 14, 15, 16, 18, 18, 16, 12, 13, 14, 15,
    16, 16, 13, 9,  12, 12, 12, 12, 12, 10, 6,  10, 9,  9,  9,  7,  8,  4,  6,
    5,  5,  3,  3,  4,  1,  0,  0,  1,  2,  3,  3,  5,  6,  3,  2,  2,  2,  2,
    10, 11, 12, 13, 14, 15, 16, 7,  10, 11, 12, 13, 13, 14, 7,  9,  10, 10, 10,
    10, 10, 7,  7,  7,  7,  7,  6,  3,  5,  7,  7,  7,  8,  6,  2,  3,  8,  10,
    9,  9,  8,  3,  5,  11, 13, 11, 11, 10, 5,  10, 13, 13, 13, 12, 14, 15, 10,
    14, 14, 15, 11, 12, 13, 10, 16, 16, 16, 11, 9,  8,  10, 15, 17, 17, 12, 7,
    3,  9,  15, 19, 18, 15, 10, 5,  9,  15, 22, 21, 17, 11, 7,  11, 17, 22, 23,
    20, 14, 8,  18, 25, 24, 18, 13, 13, 14, 19, 25, 26, 19, 14, 11, 11, 18, 24,
    29, 21, 15, 10, 7,  18, 25, 29, 22, 17, 11, 6,  18, 23, 28, 25, 19, 13, 8,
    17, 23, 28, 27, 21, 15, 10, 18, 23, 28, 29, 22, 18, 12, 20, 24, 27, 31, 31,
    28, 26, 19, 23, 27, 30, 30, 27, 23, 18, 21, 25, 27, 29, 26, 21, 16, 19, 22,
    25, 26, 23, 17, 13, 16, 18, 21, 22, 19, 16, 10, 12, 15, 17, 20, 19, 16, 6,
    9,  12, 16, 18, 19, 16, 18, 21, 25, 28, 28, 26, 22, 16, 20, 24, 27, 27, 23,
    19, 15, 18, 22, 24, 24, 22, 17, 14, 16, 19, 22, 21, 19, 13, 11, 13, 16, 18,
    16, 15, 13, 7,  9,  12, 14, 14, 14, 12, 4,  7,  10, 13, 13, 14, 12, 15, 18,
    21, 22, 24, 21, 18, 14, 17, 20, 21, 21, 19, 16, 13, 16, 18, 18, 18, 17, 13,
    11, 13, 15, 14, 15, 14, 8,  7,  10, 11, 11, 10, 9,  8,  2,  6,  7,  7,  8,
    8,  8,  3,  5,  6,  6,  7,  7,  7,  13, 13, 14, 15, 16, 17, 14, 11, 11, 13,
    14, 14, 14, 11, 8,  10, 11, 11, 11, 10, 9,  5,  8,  7,  7,  7,  6,  6,  3,
    4,  4,  4,  2,  2,  3,  1,  2,  1,  0,  1,  2,  3,  3,  4,  2,  2,  2,  2,
    2,  9,  9,  10, 11, 12, 14, 13, 6,  8,  9,  10, 11, 11, 11, 6,  8,  8,  8,
    9,  9,  8,  6,  7,  6,  6,  6,  5,  3,  4,  8,  8,  8,  8,  6,  2,  3,  9,
    10, 10, 9,  7,  3,  5,  9,  12, 11, 11, 9,  5,  11, 13, 13, 13, 11, 12, 13,
    11, 15, 15, 15, 11, 10, 10, 11, 16, 16, 16, 11, 8,  7,  11, 16, 17, 16, 12,
    8,  3,  10, 15, 19, 17, 14, 9,  5,  10, 15, 22, 21, 16, 10, 6,  11, 16, 21,
    23, 18, 13, 8,  19, 25, 24, 18, 13, 11, 12, 19, 25, 27, 20, 14, 9,  9,  18,
    25, 29, 21, 15, 10, 6,  19, 24, 29, 22, 16, 11, 6,  18, 24, 29, 24, 18, 13,
    8,  18, 23, 29, 27, 20, 14, 9,  18, 24, 30, 29, 22, 16, 11, 19, 23, 26, 31,
    30, 27, 24, 17, 22, 26, 29, 30, 27, 22, 16, 20, 23, 27, 28, 25, 21, 15, 17,
    21, 24, 27, 23, 17, 12, 15, 17, 20, 22, 20, 17, 8,  11, 13, 17, 21, 20, 16,
    6,  9,  13, 16, 19, 20, 17, 16, 20, 24, 28, 27, 25, 21, 15, 19, 22, 26, 27,
    23, 19, 14, 18, 21, 24, 23, 21, 17, 12, 15, 18, 20, 20, 18, 13, 9,  12, 14,
    17, 16, 16, 13, 6,  9,  12, 14, 14, 15, 12, 4,  7,  10, 13, 13, 14, 13, 14,
    18, 19, 20, 22, 20, 17, 12, 15, 19, 19, 20, 19, 14, 11, 15, 17, 16, 16, 17,
    12, 10, 13, 13, 13, 13, 13, 8,  6,  9,  10, 10, 9,  9,  8,  3,  6,  7,  7,
    8,  8,  8,  4,  5,  6,  6,  7,  7,  7,  11, 12, 12, 14, 15, 16, 12, 10, 10,
    11, 12, 13, 13, 10, 8,  9,  10, 9,  9,  9,  7,  4,  7,  6,  6,  6,  6,  5,
    2,  2,  2,  2,  2,  2,  3,  2,  4,  2,  1,  0,  1,  2,  4,  6,  3,  2,  2,
    1,  2,  6,  7,  8,  9,  10, 11, 12, 5,  6,  7,  9,  9,  9,  10, 5,  6,  7,
    6,  6,  7,  6,  5,  7,  6,  6,  6,  5,  3,  4,  9,  8,  7,  7,  5,  2,  5,
    9,  10, 9,  9,  7,  3,  6,  10, 12, 11, 10, 9,  4,  11, 13, 13, 13, 10, 10,
    11, 12, 15, 14, 14, 11, 8,  9,  11, 17, 16, 15, 11, 7,  5,  11, 16, 17, 16,
    12, 8,  3,  11, 16, 19, 18, 14, 9,  4,  11, 16, 22, 20, 15, 10, 6,  11, 16,
    22, 22, 17, 12, 7,  19, 25, 23, 17, 13, 9,  10, 19, 25, 25, 19, 14, 9,  7,
    20, 25, 27, 20, 15, 10, 5,  19, 24, 28, 22, 16, 11, 6,  18, 24, 28, 23, 17,
    12, 7,  18, 23, 27, 25, 20, 14, 9,  18, 23, 27, 28, 22, 16, 10, 18, 22, 26,
    29, 29, 26, 23, 16, 20, 24, 29, 29, 25, 21, 15, 19, 23, 25, 28, 23, 19, 14,
    16, 19, 23, 25, 22, 16, 10, 13, 16, 19, 23, 20, 16, 8,  11, 14, 17, 21, 20,
    17, 7,  10, 13, 16, 19, 20, 16, 15, 19, 23, 26, 26, 23, 19, 14, 17, 22, 25,
    25, 21, 18, 12, 16, 20, 22, 23, 20, 16, 11, 14, 16, 19, 19, 17, 13, 8,  11,
    13, 16, 16, 15, 13, 6,  9,  12, 14, 14, 14, 13, 5,  7,  11, 13, 13, 13, 13,
    13, 16, 18, 19, 21, 19, 15, 11, 15, 17, 18, 19, 17, 13, 10, 13, 16, 15, 16,
    15, 11, 9,  11, 12, 12, 12, 12, 8,  5,  8,  9,  9,  9,  9,  8,  3,  6,  7,
    8,  7,  7,  8,  5,  5,  6,  6,  7,  7,  7,  10, 10, 11, 12, 14, 14, 10, 9,
    9,  10, 11, 11, 11, 8,  7,  8,  8,  8,  8,  8,  6,  3,  5,  5,  5,  5,  5,
    4,  2,  1,  2,  2,  1,  2,  2,  3,  4,  3,  2,  1,  0,  1,  5,  7,  4,  3,
    2,  2,  2,  4,  4,  6,  7,  8,  9,  10, 5,  5,  5,  7,  7,  7,  8,  5,  6,
    6,  6,  5,  5,  5,  5,  8,  7,  6,  6,  5,  1,  5,  9,  8,  7,  8,  5,  2,
    6,  10, 11, 10, 9,  7,  3,  7,  10, 13, 11, 11, 9,  4,  12, 13, 12, 12, 10,
    8,  9,  12, 15, 14, 13, 11, 7,  7,  12, 17, 16, 13, 11, 6,  4,  13, 16, 16,
    14, 12, 7,  3,  11, 16, 18, 15, 13, 9,  4,  11, 16, 20, 18, 14, 10, 6,  12,
    16, 21, 20, 15, 12, 7,  18, 21, 19, 15, 12, 9,  8,  18, 21, 20, 16, 13, 9,
    5,  18, 21, 23, 16, 13, 9,  5,  18, 21, 23, 17, 14, 10, 6,  18, 20, 23, 20,
    15, 12, 8,  18, 20, 23, 21, 17, 13, 9,  18, 21, 23, 23, 18, 13, 10, 17, 20,
    24, 27, 27, 24, 21, 16, 19, 23, 26, 27, 23, 20, 14, 18, 21, 24, 26, 22, 18,
    13, 16, 18, 21, 24, 21, 17, 10, 12, 15, 18, 22, 20, 16, 8,  11, 14, 17, 21,
    20, 16, 7,  10, 13, 16, 20, 19, 17, 14, 17, 21, 24, 23, 21, 18, 13, 17, 20,
    23, 23, 20, 16, 11, 15, 19, 21, 20, 18, 14, 10, 13, 16, 19, 17, 16, 12, 7,
    11, 13, 15, 16, 15, 12, 6,  9,  12, 14, 15, 14, 12, 6,  8,  11, 13, 13, 13,
    12, 12, 15, 17, 17, 19, 17, 13, 10, 13, 16, 17, 17, 16, 11, 9,  12, 14, 14,
    14, 14, 10, 8,  10, 11, 11, 11, 11, 7,  5,  8,  9,  9,  8,  8,  7,  5,  7,
    8,  8,  7,  7,  7,  6,  6,  6,  6,  6,  6,  6,  9,  9,  10, 11, 12, 13, 8,
    8,  8,  9,  9,  9,  10, 6,  6,  7,  7,  7,  6,  6,  4,  3,  4,  4,  3,  3,
    3,  3,  3,  3,  2,  2,  1,  1,  1,  5,  5,  4,  2,  2,  1,  0,  7,  7,  4,
    3,  2,  2,  2,  3,  3,  4,  5,  6,  8,  8,  4,  4,  4,  5,  5,  5,  6,  4,
    5,  4,  3,  3,  3,  3,  4,  6,  4,  3,  3,  3,  0,  5,  6,  5,  4,  4,  3,
    2,  6,  8,  9,  7,  6,  4,  2,  7,  10, 11, 8,  7,  5,  2,  6,  6,  6,  6,
    5,  7,  7,  6,  8,  7,  7,  5,  4,  5,  6,  9,  8,  7,  4,  2,  2,  6,  8,
    9,  8,  5,  3,  2,  7,  10, 13, 12, 9,  5,  2,  8,  12, 17, 15, 11, 7,  3,
    10, 14, 18, 17, 12, 8,  4,  11, 15, 14, 9,  6,  6,  6,  10, 15, 16, 10, 6,
    3,  3,  10, 15, 18, 11, 7,  3,  2,  10, 14, 18, 12, 8,  5,  3,  10, 15, 20,
    17, 12, 8,  4,  12, 17, 22, 20, 15, 10, 5,  14, 20, 23, 22, 17, 11, 7,  20,
    21, 23, 26, 26, 25, 23, 19, 21, 23, 25, 26, 23, 21, 18, 20, 21, 23, 23, 19,
    16, 18, 18, 19, 19, 20, 15, 11, 15, 15, 15, 14, 14, 14, 10, 11, 11, 8,  10,
    12, 14, 10, 5,  3,  5,  8,  11, 14, 10, 19, 20, 22, 23, 24, 23, 22, 18, 20,
    21, 24, 24, 21, 19, 18, 19, 21, 21, 20, 19, 16, 17, 17, 18, 18, 16, 13, 8,
    14, 14, 14, 13, 9,  9,  8,  9,  9,  7,  6,  8,  9,  9,  2,  2,  4,  5,  7,
    8,  8,  18, 20, 20, 21, 23, 23, 22, 17, 18, 20, 21, 22, 21, 19, 17, 18, 19,
    20, 19, 18, 16, 16, 17, 16, 16, 15, 12, 9,  11, 12, 12, 11, 7,  8,  8,  4,
    7,  6,  4,  6,  8,  8,  0,  2,  2,  4,  6,  6,  8,  17, 18, 19, 21, 23, 24,
    23, 16, 18, 20, 20, 21, 21, 20, 14, 18, 19, 19, 19, 18, 17, 10, 17, 16, 16,
    15, 12, 12, 7,  12, 11, 11, 6,  7,  8,  5,  5,  5,  3,  4,  5,  6,  0,  3,
    3,  3,  4,  5,  6,  15, 17, 19, 20, 22, 23, 23, 12, 16, 18, 19, 20, 20, 21,
    12, 16, 17, 17, 17, 17, 15, 12, 13, 13, 13, 12, 10, 7,  10, 9,  8,  8,  7,
    6,  6,  6,  7,  7,  6,  7,  7,  5,  4,  6,  8,  7,  7,  8,  6,  13, 14, 15,
    16, 19, 22, 23, 13, 14, 14, 16, 17, 18, 19, 13, 15, 15, 14, 14, 15, 14, 13,
    13, 13, 13, 12, 9,  6,  11, 12, 13, 12, 9,  8,  6,  8,  10, 13, 13, 10, 8,
    7,  7,  10, 13, 14, 11, 8,  7,  16, 19, 18, 16, 17, 20, 21, 16, 18, 19, 17,
    16, 17, 18, 16, 18, 20, 16, 14, 13, 13, 16, 17, 20, 15, 12, 10, 7,  14, 16,
    18, 16, 11, 8,  7,  12, 15, 17, 17, 12, 10, 8,  11, 15, 18, 18, 14, 10, 8,
    27, 30, 31, 32, 32, 31, 30, 26, 29, 31, 32, 32, 29, 27, 25, 28, 29, 30, 29,
    26, 23, 24, 26, 27, 27, 25, 21, 15, 21, 24, 23, 21, 18, 16, 15, 17, 19, 16,
    15, 17, 17, 15, 11, 11, 13, 15, 16, 16, 15, 25, 28, 30, 31, 30, 30, 29, 24,
    27, 30, 31, 30, 29, 26, 22, 26, 29, 28, 27, 25, 22, 22, 24, 25, 25, 23, 20,
    14, 18, 20, 22, 20, 15, 15, 14, 13, 16, 15, 14, 14, 14, 14, 7,  9,  12, 13,
    13, 14, 14, 23, 26, 27, 29, 30, 29, 26, 21, 25, 27, 29, 29, 27, 23, 20, 24,
    26, 26, 25, 24, 20, 18, 21, 22, 22, 21, 18, 14, 13, 17, 18, 17, 14, 14, 13,
    6,  13, 12, 10, 12, 12, 13, 3,  7,  8,  10, 11, 11, 13, 20, 21, 22, 24, 25,
    26, 25, 18, 20, 22, 23, 23, 22, 21, 15, 20, 20, 21, 20, 19, 18, 11, 19, 17,
    17, 16, 12, 13, 9,  14, 13, 11, 7,  8,  9,  6,  7,  6,  4,  6,  7,  7,  3,
    0,  3,  4,  5,  6,  8,  16, 19, 20, 21, 22, 24, 24, 12, 18, 20, 21, 21, 21,
    21, 12, 18, 18, 18, 18, 17, 16, 12, 14, 15, 14, 13, 10, 8,  10, 8,  9,  8,
    5,  4,  7,  6,  5,  5,  5,  5,  4,  6,  3,  3,  5,  5,  6,  5,  5,  13, 14,
    16, 17, 20, 22, 24, 13, 13, 14, 16, 18, 19, 20, 13, 13, 13, 14, 15, 16, 14,
    13, 12, 12, 12, 10, 9,  6,  10, 10, 11, 9,  7,  5,  5,  7,  8,  10, 9,  7,
    6,  4,  5,  7,  10, 10, 8,  7,  4,  14, 17, 16, 15, 18, 21, 22, 14, 16, 17,
    15, 16, 18, 18, 14, 17, 18, 14, 13, 13, 13, 14, 15, 17, 13, 11, 8,  4,  12,
    13, 15, 12, 8,  6,  5,  10, 12, 14, 13, 9,  7,  5,  8,  11, 14, 14, 10, 8,
    6,  25, 28, 31, 33, 33, 32, 29, 23, 27, 30, 32, 33, 30, 26, 21, 26, 29, 30,
    30, 27, 23, 21, 23, 26, 27, 28, 22, 17, 17, 20, 22, 23, 21, 19, 16, 13, 16,
    17, 17, 20, 19, 17, 8,  11, 14, 17, 19, 19, 16, 22, 25, 29, 31, 31, 29, 27,
    20, 25, 28, 30, 29, 28, 24, 19, 23, 26, 28, 27, 25, 21, 18, 21, 24, 25, 23,
    20, 15, 15, 17, 19, 20, 17, 16, 15, 11, 13, 15, 15, 15, 16, 15, 5,  9,  12,
    14, 15, 15, 15, 20, 23, 26, 27, 28, 26, 22, 18, 22, 24, 25, 26, 24, 20, 17,
    21, 23, 22, 22, 22, 17, 15, 18, 19, 19, 19, 17, 11, 9,  14, 15, 15, 12, 12,
    12, 3,  10, 11, 10, 10, 11, 11, 3,  6,  8,  8,  9,  9,  10, 17, 18, 18, 19,
    21, 22, 19, 14, 16, 17, 18, 19, 19, 16, 11, 15, 16, 16, 15, 15, 13, 8,  13,
    12, 12, 11, 10, 10, 6,  9,  8,  8,  5,  5,  6,  3,  3,  3,  2,  3,  4,  4,
    3,  3,  0,  2,  3,  4,  5,  12, 14, 15, 16, 17, 18, 19, 8,  13, 14, 15, 16,
    16, 16, 8,  12, 13, 13, 13, 13, 11, 8,  10, 10, 10, 9,  7,  4,  6,  6,  5,
    5,  6,  4,  4,  4,  6,  8,  8,  8,  6,  3,  2,  7,  10, 10, 10, 8,  3,  9,
    11, 11, 13, 15, 17, 18, 9,  12, 12, 13, 13, 15, 16, 9,  14, 14, 14, 11, 11,
    10, 9,  13, 15, 15, 11, 7,  3,  7,  12, 17, 17, 13, 8,  3,  7,  13, 19, 19,
    15, 10, 5,  8,  14, 20, 20, 17, 12, 6,  16, 22, 22, 16, 13, 16, 17, 16, 23,
    24, 18, 12, 13, 14, 17, 23, 26, 19, 13, 9,  10, 17, 22, 26, 20, 14, 9,  5,
    15, 21, 25, 23, 17, 12, 6,  15, 21, 25, 23, 18, 14, 8,  16, 21, 24, 24, 20,
    15, 10, 23, 26, 30, 33, 32, 30, 27, 21, 25, 29, 32, 32, 29, 26, 19, 24, 27,
    31, 31, 27, 22, 18, 21, 24, 27, 28, 24, 18, 15, 18, 20, 23, 23, 21, 18, 11,
    14, 17, 18, 22, 21, 18, 8,  11, 14, 17, 20, 21, 18, 19, 23, 27, 31, 29, 27,
    25, 18, 22, 26, 30, 29, 25, 22, 17, 20, 25, 26, 26, 24, 19, 16, 19, 22, 24,
    23, 20, 15, 13, 15, 18, 19, 18, 17, 14, 9,  11, 14, 16, 16, 16, 14, 5,  8,
    12, 15, 15, 15, 14, 17, 21, 23, 24, 26, 23, 20, 16, 19, 22, 23, 23, 21, 18,
    15, 18, 20, 20, 20, 20, 15, 13, 16, 16, 17, 17, 15, 10, 8,  12, 13, 13, 12,
    11, 10, 3,  8,  9,  9,  9,  10, 10, 3,  6,  7,  8,  8,  9,  8,  15, 15, 16,
    17, 19, 19, 15, 13, 14, 15, 16, 17, 17, 13, 10, 12, 13, 13, 13, 13, 10, 6,
    10, 9,  9,  9,  8,  8,  4,  6,  6,  6,  4,  3,  4,  2,  2,  2,  2,  2,  3,
    3,  3,  4,  2,  0,  2,  2,  3,  9,  10, 11, 12, 13, 15, 15, 6,  10, 11, 12,
    13, 13, 13, 6,  9,  9,  9,  10, 9,  9,  6,  7,  6,  6,  6,  5,  3,  4,  6,
    6,  6,  6,  4,  3,  2,  7,  9,  8,  8,  6,  2,  4,  8,  11, 10, 9,  8,  3,
    9,  11, 11, 12, 12, 14, 15, 9,  13, 13, 13, 11, 11, 11, 9,  15, 15, 14, 10,
    8,  8,  9,  14, 15, 15, 11, 6,  2,  8,  13, 18, 16, 12, 8,  3,  8,  14, 20,
    19, 14, 9,  5,  9,  14, 20, 21, 16, 11, 6,  17, 23, 22, 17, 11, 12, 13, 17,
    23, 24, 18, 12, 10, 10, 17, 23, 27, 19, 13, 8,  7,  17, 22, 27, 20, 15, 9,
    5,  16, 21, 27, 22, 16, 11, 6,  16, 22, 27, 25, 18, 13, 8,  16, 22, 27, 27,
    21, 15, 9,  20, 25, 28, 32, 32, 30, 27, 20, 23, 27, 31, 32, 27, 24, 17, 22,
    25, 29, 30, 26, 22, 17, 19, 22, 25, 28, 24, 18, 14, 16, 19, 21, 24, 22, 18,
    10, 12, 15, 18, 22, 21, 18, 8,  10, 14, 17, 20, 21, 18, 18, 22, 26, 29, 29,
    25, 22, 17, 20, 23, 27, 28, 24, 20, 15, 19, 23, 25, 25, 22, 19, 14, 17, 20,
    22, 22, 20, 14, 11, 14, 15, 18, 18, 17, 14, 7,  10, 13, 15, 16, 17, 14, 5,
    8,  12, 14, 15, 15, 14, 16, 19, 20, 22, 24, 22, 18, 14, 17, 20, 21, 22, 20,
    15, 13, 17, 18, 18, 19, 17, 13, 12, 15, 15, 14, 15, 14, 10, 8,  11, 11, 11,
    11, 10, 9,  3,  8,  9,  9,  9,  9,  9,  4,  6,  7,  7,  8,  8,  8,  13, 14,
    14, 15, 17, 18, 13, 12, 12, 13, 14, 14, 14, 11, 9,  11, 11, 11, 11, 11, 8,
    5,  9,  8,  7,  7,  7,  6,  3,  4,  4,  4,  3,  3,  3,  3,  2,  2,  2,  2,
    2,  2,  4,  5,  3,  2,  0,  1,  2,  7,  7,  8,  9,  11, 12, 12, 5,  7,  8,
    9,  9,  10, 10, 5,  6,  7,  7,  7,  7,  7,  5,  6,  5,  5,  5,  4,  2,  3,
    7,  6,  6,  6,  4,  2,  3,  8,  9,  8,  8,  6,  2,  4,  8,  11, 10, 10, 7,
    3,  10, 12, 12, 11, 9,  11, 12, 10, 14, 13, 13, 10, 8,  9,  10, 16, 15, 14,
    10, 6,  6,  10, 15, 16, 15, 11, 6,  2,  9,  14, 18, 17, 12, 8,  3,  9,  15,
    20, 19, 14, 9,  5,  10, 15, 20, 21, 16, 11, 6,  18, 24, 23, 16, 12, 10, 10,
    18, 23, 24, 18, 13, 8,  8,  18, 24, 26, 19, 13, 8,  5,  18, 23, 28, 21, 15,
    10, 4,  17, 22, 27, 23, 16, 11, 6,  17, 22, 27, 26, 18, 13, 8,  17, 22, 27,
    27, 21, 15, 9,  20, 24, 27, 31, 30, 28, 25, 18, 22, 25, 29, 30, 27, 23, 16,
    20, 24, 27, 28, 25, 21, 15, 18, 21, 24, 27, 23, 18, 12, 15, 17, 21, 24, 21,
    18, 9,  12, 15, 18, 22, 21, 18, 8,  11, 14, 17, 21, 21, 18, 17, 20, 24, 28,
    28, 25, 21, 15, 20, 23, 26, 27, 23, 19, 14, 17, 21, 24, 24, 21, 17, 13, 15,
    19, 20, 20, 19, 14, 10, 12, 15, 17, 17, 17, 14, 7,  10, 13, 15, 16, 16, 14,
    6,  9,  12, 15, 14, 14, 14, 14, 17, 20, 21, 22, 20, 16, 13, 16, 18, 19, 20,
    19, 14, 12, 15, 17, 17, 17, 16, 12, 11, 13, 13, 13, 14, 13, 9,  7,  9,  10,
    10, 10, 10, 9,  4,  8,  9,  9,  9,  9,  9,  5,  7,  7,  7,  8,  8,  8,  12,
    12, 13, 14, 15, 16, 11, 10, 11, 11, 12, 13, 13, 9,  9,  9,  10, 10, 9,  9,
    7,  5,  7,  6,  6,  6,  6,  5,  2,  3,  3,  3,  2,  3,  3,  3,  3,  2,  2,
    1,  1,  2,  5,  6,  4,  3,  1,  0,  1,  5,  5,  6,  8,  8,  10, 11, 4,  5,
    6,  7,  8,  8,  9,  4,  5,  5,  5,  5,  5,  5,  4,  6,  5,  5,  5,  3,  2,
    3,  8,  7,  6,  6,  4,  1,  4,  9,  10, 8,  8,  6,  2,  5,  9,  12, 10, 10,
    8,  3,  10, 12, 11, 11, 9,  9,  10, 10, 14, 13, 12, 10, 7,  7,  10, 16, 14,
    13, 10, 5,  4,  10, 15, 15, 14, 10, 6,  2,  10, 14, 17, 15, 12, 8,  3,  10,
    15, 19, 17, 13, 9,  5,  10, 15, 20, 19, 15, 11, 6,  17, 21, 19, 15, 11, 8,
    8,  17, 21, 20, 16, 12, 8,  6,  18, 21, 22, 16, 12, 8,  4,  17, 20, 22, 17,
    13, 9,  5,  17, 20, 23, 20, 15, 11, 6,  16, 20, 23, 21, 16, 13, 8,  16, 20,
    23, 23, 18, 13, 9,  19, 23, 26, 29, 30, 28, 24, 17, 21, 24, 29, 29, 26, 22,
    16, 20, 23, 27, 27, 24, 20, 14, 17, 20, 24, 26, 22, 18, 11, 14, 16, 20, 23,
    21, 18, 10, 13, 15, 19, 22, 21, 18, 8,  11, 15, 18, 21, 21, 18, 16, 20, 23,
    27, 26, 23, 20, 14, 19, 22, 26, 25, 22, 18, 13, 17, 20, 23, 23, 20, 16, 12,
    15, 17, 21, 20, 18, 14, 9,  12, 14, 17, 17, 17, 14, 8,  11, 13, 16, 16, 16,
    14, 6,  9,  12, 15, 15, 15, 14, 13, 17, 19, 20, 21, 19, 15, 12, 16, 18, 19,
    19, 18, 13, 11, 14, 16, 16, 16, 16, 11, 10, 12, 13, 12, 13, 13, 9,  6,  9,
    10, 10, 10, 10, 9,  5,  8,  9,  9,  9,  9,  9,  6,  7,  8,  8,  8,  8,  8,
    11, 11, 12, 13, 14, 15, 9,  9,  9,  10, 11, 12, 11, 7,  8,  8,  9,  9,  8,
    8,  6,  4,  6,  5,  5,  5,  5,  4,  3,  3,  3,  3,  3,  3,  2,  4,  4,  3,
    2,  2,  2,  2,  6,  8,  5,  3,  2,  1,  0,  2,  3,  5,  6,  7,  8,  9,  2,
    3,  4,  5,  6,  6,  7,  2,  3,  3,  3,  3,  4,  4,  2,  5,  3,  2,  2,  2,
    1,  3,  7,  5,  4,  4,  3,  0,  5,  8,  7,  5,  3,  3,  2,  7,  8,  8,  6,
    5,  3,  2,  6,  6,  5,  5,  6,  7,  9,  6,  8,  5,  5,  5,  5,  6,  6,  8,
    6,  5,  3,  3,  3,  6,  7,  7,  5,  4,  3,  1,  7,  9,  10, 8,  6,  3,  2,
    8,  10, 13, 11, 7,  4,  3,  9,  11, 14, 14, 9,  5,  3,  8,  11, 10, 6,  5,
    7,  7,  8,  11, 11, 7,  4,  4,  4,  8,  11, 13, 7,  4,  3,  2,  8,  11, 14,
    9,  6,  4,  3,  9,  11, 15, 13, 8,  5,  3,  9,  13, 18, 16, 11, 6,  3,  11,
    15, 18, 17, 12, 7,  4,  14, 17, 20, 24, 23, 22, 19, 13, 16, 19, 23, 23, 21,
    17, 12, 14, 17, 20, 21, 18, 16, 11, 13, 15, 17, 20, 18, 15, 11, 13, 14, 15,
    19, 17, 15, 9,  11, 13, 15, 17, 17, 15, 12, 12, 12, 14, 16, 17, 15, 12, 15,
    17, 20, 21, 19, 16, 11, 13, 16, 19, 21, 18, 14, 11, 13, 15, 17, 18, 16, 13,
    9,  12, 14, 15, 15, 14, 13, 9,  11, 13, 14, 14, 14, 13, 7,  10, 11, 13, 13,
    13, 13, 14, 14, 11, 12, 12, 12, 12, 10, 13, 14, 15, 16, 15, 12, 9,  12, 13,
    13, 15, 14, 11, 8,  11, 12, 12, 12, 13, 11, 7,  10, 11, 11, 12, 11, 11, 6,
    9,  11, 11, 11, 11, 11, 9,  10, 10, 9,  10, 11, 11, 15, 16, 12, 9,  9,  10,
    11, 8,  8,  9,  10, 10, 11, 4,  7,  7,  8,  8,  8,  9,  5,  6,  6,  6,  7,
    7,  7,  4,  4,  5,  5,  6,  6,  6,  4,  4,  4,  4,  5,  5,  5,  4,  9,  11,
    10, 8,  6,  3,  3,  15, 16, 12, 9,  7,  4,  2,  0,  1,  1,  2,  2,  2,  4,
    2,  2,  2,  2,  2,  1,  5,  2,  3,  3,  3,  4,  2,  4,  2,  6,  5,  6,  6,
    5,  2,  4,  9,  8,  7,  7,  7,  3,  9,  11, 11, 9,  9,  8,  4,  14, 14, 13,
    10, 9,  8,  6,  8,  8,  8,  8,  7,  2,  3,  8,  10, 9,  9,  7,  3,  2,  7,
    11, 10, 9,  8,  5,  0,  8,  10, 11, 10, 8,  7,  4,  8,  11, 14, 13, 11, 8,
    6,  10, 13, 17, 15, 12, 9,  7,  12, 15, 17, 16, 13, 10, 8,  12, 16, 14, 11,
    8,  6,  2,  12, 16, 16, 12, 9,  6,  2,  12, 16, 18, 12, 9,  7,  4,  12, 15,
    19, 14, 11, 8,  7,  12, 16, 19, 17, 13, 10, 7,  13, 17, 20, 19, 15, 11, 8,
    15, 18, 20, 21, 16, 12, 9,  15, 17, 19, 20, 21, 18, 17, 14, 16, 18, 20, 20,
    19, 17, 12, 15, 18, 19, 20, 18, 17, 11, 14, 17, 18, 20, 19, 17, 11, 14, 17,
    19, 21, 19, 17, 10, 14, 16, 18, 20, 19, 17, 13, 13, 15, 18, 20, 19, 17, 13,
    15, 18, 19, 18, 16, 14, 12, 15, 17, 19, 18, 16, 14, 11, 14, 16, 17, 17, 16,
    14, 9,  13, 16, 17, 17, 17, 15, 9,  12, 15, 17, 17, 17, 15, 8,  11, 14, 16,
    16, 16, 15, 16, 14, 13, 15, 15, 15, 15, 10, 14, 14, 15, 15, 13, 10, 9,  12,
    14, 14, 14, 13, 10, 8,  11, 12, 13, 13, 13, 10, 7,  11, 12, 12, 13, 13, 11,
    7,  10, 11, 12, 12, 12, 11, 10, 11, 10, 11, 11, 11, 11, 17, 17, 12, 10, 10,
    10, 10, 8,  8,  8,  9,  9,  9,  3,  7,  7,  7,  7,  8,  8,  3,  6,  6,  6,
    6,  6,  6,  4,  4,  5,  5,  6,  6,  6,  4,  6,  6,  5,  5,  5,  5,  4,  10,
    12, 10, 9,  6,  5,  3,  17, 19, 14, 10, 7,  5,  3,  1,  0,  1,  1,  2,  2,
    3,  2,  2,  1,  2,  2,  1,  3,  2,  3,  3,  3,  3,  1,  3,  2,  7,  6,  6,
    6,  5,  3,  5,  11, 10, 10, 11, 8,  3,  10, 14, 16, 15, 13, 10, 5,  16, 19,
    20, 16, 15, 12, 7,  9,  10, 10, 10, 7,  2,  2,  8,  12, 12, 11, 8,  3,  2,
    8,  14, 14, 14, 9,  5,  1,  8,  15, 17, 17, 13, 9,  5,  11, 17, 22, 21, 17,
    12, 7,  14, 20, 26, 25, 20, 15, 9,  18, 23, 27, 25, 21, 17, 11, 17, 22, 21,
    15, 10, 5,  1,  16, 22, 24, 17, 12, 6,  2,  16, 22, 25, 18, 13, 9,  4,  16,
    22, 27, 22, 17, 13, 9,  18, 24, 29, 26, 21, 17, 11, 20, 26, 30, 29, 23, 18,
    13, 23, 28, 30, 30, 25, 21, 15, 14, 17, 20, 22, 23, 20, 18, 13, 16, 19, 22,
    23, 20, 18, 12, 15, 18, 21, 23, 20, 18, 11, 14, 17, 21, 23, 22, 19, 12, 14,
    18, 20, 24, 23, 19, 11, 14, 17, 20, 23, 22, 19, 14, 14, 16, 19, 22, 21, 19,
    12, 15, 18, 21, 19, 17, 14, 11, 14, 18, 19, 19, 16, 14, 10, 13, 16, 19, 18,
    17, 15, 9,  13, 16, 18, 18, 18, 16, 10, 13, 15, 18, 18, 18, 15, 10, 11, 15,
    17, 18, 18, 16, 17, 16, 14, 16, 17, 16, 16, 10, 13, 15, 15, 15, 13, 9,  9,
    12, 13, 13, 14, 12, 9,  8,  11, 12, 12, 12, 13, 10, 8,  11, 12, 12, 12, 13,
    11, 7,  10, 12, 12, 12, 12, 11, 12, 12, 11, 11, 11, 11, 11, 19, 18, 14, 10,
    10, 10, 10, 8,  8,  8,  8,  8,  8,  2,  7,  7,  7,  7,  7,  7,  2,  6,  6,
    6,  6,  6,  6,  3,  4,  6,  6,  6,  6,  6,  4,  6,  7,  6,  6,  6,  5,  4,
    12, 13, 12, 10, 8,  6,  4,  19, 20, 15, 11, 8,  6,  5,  1,  1,  0,  1,  1,
    1,  2,  2,  2,  2,  1,  2,  1,  2,  2,  4,  3,  4,  4,  2,  3,  2,  7,  7,
    7,  7,  6,  4,  6,  12, 12, 11, 11, 9,  5,  11, 15, 17, 16, 14, 11, 6,  18,
    21, 20, 17, 16, 13, 7,  9,  11, 9,  9,  6,  2,  2,  9,  13, 11, 11, 7,  3,
    1,  9,  14, 14, 14, 10, 6,  2,  9,  16, 18, 17, 14, 10, 6,  12, 18, 23, 21,
    18, 13, 7,  15, 21, 28, 26, 20, 15, 9,  19, 25, 29, 27, 23, 17, 11, 16, 22,
    21, 15, 9,  5,  1,  17, 22, 23, 16, 11, 6,  2,  16, 22, 26, 19, 13, 9,  5,
    16, 23, 29, 23, 18, 14, 10, 18, 25, 31, 28, 22, 17, 11, 22, 28, 33, 33, 26,
    19, 13, 25, 30, 34, 34, 28, 21, 15, 14, 17, 21, 23, 24, 20, 18, 14, 16, 19,
    23, 24, 21, 18, 12, 15, 18, 22, 23, 22, 19, 11, 15, 18, 22, 25, 23, 20, 12,
    15, 18, 22, 26, 23, 20, 11, 14, 17, 21, 25, 23, 20, 16, 15, 17, 20, 23, 22,
    19, 12, 15, 18, 20, 20, 17, 14, 12, 14, 17, 20, 19, 17, 14, 10, 13, 17, 19,
    19, 18, 15, 9,  13, 17, 20, 19, 18, 16, 10, 13, 16, 18, 19, 19, 16, 11, 12,
    15, 18, 18, 18, 16, 18, 17, 15, 17, 17, 17, 16, 10, 13, 14, 15, 15, 12, 9,
    9,  12, 13, 13, 14, 12, 9,  9,  11, 13, 13, 13, 13, 10, 8,  11, 13, 13, 13,
    14, 11, 7,  10, 12, 12, 12, 12, 11, 13, 13, 13, 12, 12, 11, 11, 20, 19, 15,
    12, 10, 11, 10, 9,  8,  8,  8,  8,  8,  2,  8,  7,  7,  7,  7,  6,  2,  6,
    6,  6,  7,  6,  6,  3,  4,  6,  6,  6,  6,  6,  5,  6,  8,  8,  8,  8,  6,
    5,  13, 15, 13, 11, 9,  7,  5,  21, 21, 16, 12, 9,  7,  6,  2,  1,  1,  0,
    1,  1,  2,  3,  2,  2,  2,  2,  0,  2,  2,  4,  4,  4,  4,  3,  3,  2,  8,
    8,  8,  8,  7,  5,  7,  13, 12, 12, 13, 10, 6,  13, 17, 18, 17, 14, 12, 7,
    19, 22, 22, 19, 17, 14, 8,  9,  11, 9,  9,  6,  2,  2,  10, 12, 11, 11, 7,
    3,  2,  10, 15, 14, 14, 11, 6,  3,  9,  17, 18, 18, 15, 10, 7,  13, 19, 24,
    22, 18, 13, 8,  16, 22, 29, 27, 21, 16, 10, 21, 26, 30, 30, 25, 17, 12, 17,
    22, 20, 14, 9,  5,  1,  17, 22, 23, 16, 11, 6,  3,  17, 22, 25, 19, 14, 10,
    6,  17, 24, 29, 24, 18, 14, 10, 20, 26, 31, 29, 23, 18, 12, 23, 30, 35, 33,
    26, 19, 14, 25, 32, 35, 36, 28, 22, 16, 15, 18, 21, 24, 24, 21, 18, 14, 17,
    19, 23, 24, 22, 19, 12, 15, 19, 23, 25, 23, 20, 11, 16, 19, 22, 26, 24, 20,
    12, 16, 19, 23, 26, 24, 21, 12, 15, 18, 22, 26, 24, 21, 17, 17, 18, 20, 24,
    24, 21, 12, 16, 19, 22, 20, 17, 14, 12, 15, 18, 20, 20, 17, 15, 10, 14, 17,
    20, 20, 19, 16, 10, 14, 17, 20, 20, 19, 16, 10, 14, 17, 19, 20, 20, 17, 12,
    14, 16, 19, 19, 19, 17, 20, 18, 16, 18, 18, 18, 17, 10, 14, 15, 14, 15, 13,
    9,  10, 12, 13, 14, 14, 13, 10, 9,  12, 13, 14, 14, 14, 11, 9,  12, 14, 14,
    14, 14, 12, 8,  11, 13, 13, 13, 13, 12, 14, 14, 14, 13, 13, 12, 12, 22, 20,
    16, 12, 11, 11, 10, 9,  8,  8,  8,  8,  8,  2,  9,  7,  7,  7,  7,  7,  3,
    6,  6,  6,  7,  7,  7,  4,  6,  6,  7,  7,  7,  7,  6,  7,  8,  9,  9,  9,
    8,  6,  14, 16, 14, 12, 10, 8,  6,  22, 22, 17, 13, 10, 8,  7,  2,  2,  1,
    1,  0,  1,  2,  3,  2,  2,  2,  2,  1,  3,  3,  4,  4,  5,  5,  4,  3,  3,
    8,  8,  9,  9,  7,  6,  7,  14, 13, 13, 13, 11, 7,  14, 18, 19, 18, 15, 12,
    8,  20, 23, 23, 19, 18, 14, 9,  10, 10, 9,  8,  5,  2,  2,  10, 12, 10, 9,
    7,  4,  2,  10, 13, 12, 13, 10, 7,  4,  10, 15, 17, 16, 15, 11, 7,  13, 19,
    23, 21, 18, 14, 9,  17, 23, 28, 26, 20, 16, 11, 21, 27, 29, 28, 23, 18, 13,
    15, 17, 14, 10, 8,  4,  1,  15, 17, 15, 11, 9,  7,  3,  15, 17, 18, 15, 13,
    11, 7,  15, 19, 23, 20, 17, 15, 11, 18, 23, 27, 25, 22, 18, 13, 23, 27, 31,
    30, 24, 19, 15, 27, 30, 32, 32, 26, 21, 17, 13, 16, 20, 23, 23, 20, 17, 13,
    16, 18, 22, 23, 21, 19, 12, 14, 18, 22, 25, 22, 19, 11, 15, 19, 22, 26, 23,
    20, 12, 15, 18, 21, 25, 23, 20, 12, 15, 18, 21, 25, 23, 20, 18, 18, 17, 20,
    23, 23, 20, 12, 15, 17, 20, 18, 15, 13, 11, 14, 17, 19, 19, 17, 14, 10, 13,
    16, 19, 20, 17, 15, 9,  12, 16, 20, 19, 18, 16, 9,  13, 16, 19, 20, 19, 16,
    13, 14, 16, 18, 18, 18, 15, 21, 19, 17, 17, 17, 17, 16, 10, 13, 13, 13, 14,
    11, 8,  9,  12, 12, 12, 13, 12, 9,  8,  11, 12, 13, 13, 13, 10, 7,  11, 12,
    13, 13, 13, 11, 7,  11, 12, 13, 13, 13, 11, 15, 16, 15, 13, 12, 12, 11, 23,
    22, 17, 14, 11, 10, 10, 8,  7,  7,  7,  7,  7,  2,  7,  6,  6,  6,  6,  6,
    2,  4,  5,  5,  6,  6,  6,  4,  8,  5,  6,  6,  6,  7,  6,  8,  9,  10, 10,
    10, 9,  7,  15, 17, 16, 14, 11, 9,  8,  23, 24, 18, 15, 12, 10, 8,  2,  2,
    2,  1,  1,  0,  2,  4,  2,  2,  2,  2,  2,  2,  4,  3,  3,  4,  5,  5,  4,
    4,  7,  7,  8,  8,  8,  8,  8,  13, 13, 13, 13, 11, 8,  15, 19, 19, 17, 14,
    12, 9,  22, 24, 22, 18, 15, 13, 10, 6,  6,  4,  3,  3,  2,  1,  6,  7,  5,
    4,  3,  3,  2,  6,  9,  6,  7,  6,  6,  6,  6,  11, 12, 12, 11, 10, 9,  11,
    15, 19, 17, 15, 13, 10, 17, 21, 25, 22, 17, 13, 11, 22, 25, 26, 24, 19, 15,
    12, 10, 12, 8,  5,  3,  2,  2,  10, 12, 10, 6,  4,  4,  4,  10, 12, 13, 9,
    9,  8,  7,  10, 14, 18, 16, 13, 12, 10, 14, 18, 23, 22, 18, 15, 12, 19, 23,
    27, 27, 21, 16, 13, 24, 27, 28, 29, 23, 18, 13, 9,  11, 13, 15, 16, 13, 11,
    9,  11, 12, 15, 16, 14, 12, 8,  10, 12, 16, 18, 15, 13, 7,  10, 13, 16, 19,
    17, 15, 8,  11, 14, 17, 20, 17, 14, 11, 13, 15, 16, 19, 17, 14, 18, 18, 16,
    16, 18, 17, 15, 8,  10, 11, 14, 11, 9,  7,  7,  9,  11, 13, 12, 10, 8,  7,
    8,  11, 14, 13, 11, 10, 6,  9,  12, 14, 13, 12, 11, 6,  10, 12, 14, 14, 13,
    11, 13, 14, 15, 16, 14, 13, 11, 21, 19, 17, 15, 13, 12, 11, 7,  9,  8,  7,
    7,  5,  3,  6,  8,  8,  7,  7,  7,  5,  5,  7,  7,  8,  8,  8,  6,  3,  7,
    8,  9,  9,  9,  8,  7,  10, 10, 10, 10, 9,  8,  16, 16, 15, 13, 11, 9,  8,
    23, 22, 18, 14, 12, 10, 8,  5,  4,  3,  3,  3,  2,  0,  3,  2,  3,  2,  2,
    3,  2,  6,  2,  2,  3,  3,  3,  4,  10, 3,  5,  6,  6,  6,  6,  9,  10, 10,
    10, 10, 9,  7,  16, 18, 16, 14, 12, 10, 8,  23, 24, 19, 15, 12, 11, 9,  4,
    3,  2,  2,  2,  2,  0,  6,  4,  3,  2,  2,  3,  2,  6,  4,  4,  5,  5,  5,
    5,  6,  8,  8,  9,  10, 9,  8,  9,  15, 15, 15, 15, 12, 9,  15, 21, 21, 19,
    16, 14, 10, 22, 25, 25, 21, 18, 15, 11, 8,  7,  5,  5,  3,  2,  1,  8,  10,
    7,  6,  4,  4,  3,  8,  11, 10, 11, 9,  7,  6,  8,  13, 16, 16, 15, 12, 10,
    12, 19, 23, 22, 19, 16, 11, 18, 24, 30, 27, 22, 16, 13, 23, 28, 31, 30, 24,
    18, 14, 12, 16, 14, 8,  5,  3,  2,  13, 16, 16, 10, 6,  5,  4,  12, 16, 19,
    15, 12, 10, 8,  13, 18, 25, 21, 18, 15, 12, 17, 23, 29, 28, 23, 19, 14, 22,
    27, 33, 33, 26, 20, 16, 27, 32, 34, 34, 28, 23, 17, 16, 19, 23, 26, 26, 25,
    22, 15, 19, 22, 25, 26, 23, 21, 14, 17, 20, 23, 24, 22, 19, 13, 15, 17, 20,
    22, 20, 18, 12, 14, 16, 18, 21, 19, 18, 10, 12, 15, 17, 20, 20, 18, 10, 11,
    13, 16, 19, 20, 18, 14, 17, 20, 24, 24, 23, 18, 13, 16, 19, 22, 24, 22, 17,
    12, 14, 18, 20, 20, 18, 15, 11, 13, 15, 17, 18, 16, 14, 10, 12, 14, 15, 16,
    17, 14, 8,  11, 13, 14, 15, 15, 15, 11, 11, 12, 13, 14, 15, 14, 12, 14, 16,
    17, 19, 19, 14, 11, 13, 15, 16, 16, 17, 13, 10, 12, 14, 14, 15, 15, 12, 9,
    12, 12, 12, 12, 13, 12, 7,  10, 12, 12, 11, 12, 12, 8,  9,  10, 10, 11, 11,
    12, 12, 12, 10, 9,  10, 11, 12, 10, 10, 11, 11, 12, 14, 6,  8,  9,  9,  10,
    10, 11, 6,  7,  7,  8,  8,  9,  9,  5,  4,  6,  7,  7,  7,  7,  6,  5,  5,
    5,  6,  6,  7,  4,  8,  8,  7,  6,  5,  5,  4,  12, 12, 8,  6,  5,  4,  2,
    2,  2,  2,  2,  3,  4,  6,  0,  1,  1,  2,  1,  2,  5,  0,  2,  2,  1,  1,
    1,  4,  0,  2,  2,  1,  1,  1,  4,  2,  4,  3,  3,  4,  2,  2,  5,  7,  7,
    6,  5,  3,  2,  9,  10, 9,  7,  6,  4,  2,  4,  5,  5,  5,  3,  2,  4,  4,
    6,  6,  6,  3,  1,  3,  4,  7,  7,  6,  4,  1,  2,  4,  7,  8,  7,  5,  3,
    2,  4,  8,  10, 9,  7,  4,  2,  6,  10, 14, 11, 9,  6,  2,  9,  12, 14, 13,
    10, 6,  3,  9,  12, 11, 8,  5,  2,  2,  9,  12, 12, 8,  5,  2,  1,  9,  12,
    14, 9,  6,  3,  1,  9,  12, 15, 10, 7,  5,  2,  9,  12, 15, 13, 10, 7,  4,
    10, 13, 17, 16, 11, 8,  5,  12, 15, 16, 17, 13, 9,  6,  16, 19, 20, 22, 22,
    20, 18, 15, 18, 20, 21, 22, 20, 17, 14, 16, 18, 21, 22, 19, 18, 13, 15, 19,
    20, 22, 20, 18, 13, 16, 18, 20, 22, 21, 19, 11, 15, 18, 19, 21, 20, 18, 12,
    13, 17, 19, 20, 20, 18, 14, 17, 19, 21, 19, 18, 16, 13, 16, 18, 20, 19, 18,
    16, 12, 15, 17, 19, 18, 17, 16, 11, 14, 17, 18, 17, 18, 16, 11, 14, 17, 19,
    18, 18, 17, 9,  12, 15, 17, 18, 18, 16, 15, 14, 14, 16, 16, 17, 16, 12, 15,
    16, 16, 16, 15, 12, 11, 14, 15, 15, 15, 15, 12, 10, 13, 14, 14, 15, 15, 12,
    9,  12, 14, 13, 14, 14, 12, 8,  11, 13, 13, 13, 13, 12, 10, 10, 11, 12, 13,
    13, 12, 17, 16, 12, 10, 11, 11, 12, 10, 9,  10, 10, 10, 11, 4,  9,  8,  9,
    9,  9,  9,  4,  7,  7,  7,  8,  8,  8,  5,  5,  7,  7,  7,  7,  7,  6,  6,
    6,  6,  6,  6,  6,  5,  10, 11, 10, 9,  6,  5,  4,  17, 18, 13, 10, 7,  5,
    3,  2,  2,  2,  2,  2,  2,  4,  1,  0,  1,  1,  1,  2,  4,  1,  2,  2,  2,
    1,  0,  4,  1,  5,  5,  5,  5,  4,  3,  4,  9,  9,  9,  9,  7,  3,  9,  13,
    15, 14, 12, 9,  4,  16, 18, 18, 15, 14, 11, 5,  7,  9,  8,  9,  5,  1,  3,
    7,  11, 10, 10, 7,  2,  3,  7,  13, 13, 12, 8,  3,  2,  7,  13, 15, 15, 12,
    7,  4,  9,  16, 19, 18, 16, 11, 5,  12, 18, 22, 20, 17, 13, 7,  17, 21, 23,
    22, 18, 15, 9,  15, 20, 18, 14, 9,  4,  2,  15, 19, 20, 15, 11, 5,  1,  15,
    19, 21, 16, 12, 7,  3,  15, 20, 23, 19, 16, 12, 7,  16, 21, 24, 22, 18, 15,
    9,  18, 22, 25, 24, 20, 16, 12, 21, 23, 26, 25, 21, 18, 13, 16, 19, 21, 24,
    24, 22, 19, 15, 18, 20, 23, 25, 21, 19, 13, 17, 20, 23, 24, 21, 20, 13, 16,
    19, 22, 24, 22, 20, 13, 16, 19, 22, 25, 23, 20, 12, 15, 18, 21, 24, 23, 21,
    13, 14, 17, 20, 23, 24, 21, 13, 17, 20, 22, 21, 18, 16, 12, 16, 18, 21, 20,
    18, 15, 12, 14, 17, 20, 20, 18, 16, 10, 14, 17, 21, 19, 19, 17, 11, 14, 17,
    19, 20, 20, 17, 9,  13, 16, 18, 19, 19, 17, 16, 15, 15, 18, 17, 18, 17, 11,
    14, 16, 16, 16, 14, 11, 10, 13, 15, 15, 15, 14, 11, 10, 12, 14, 13, 14, 14,
    11, 9,  12, 14, 14, 14, 14, 12, 8,  11, 13, 13, 13, 13, 12, 11, 11, 12, 12,
    12, 12, 12, 18, 17, 13, 11, 11, 11, 11, 10, 9,  9,  9,  10, 9,  3,  9,  8,
    8,  8,  8,  8,  3,  8,  7,  7,  7,  7,  7,  3,  5,  7,  7,  7,  7,  7,  5,
    6,  6,  6,  6,  6,  6,  4,  11, 13, 11, 9,  7,  5,  4,  18, 20, 14, 10, 8,
    6,  4,  2,  1,  2,  2,  2,  2,  3,  1,  1,  0,  1,  1,  1,  3,  1,  2,  2,
    2,  2,  1,  3,  1,  6,  6,  6,  6,  5,  4,  5,  10, 10, 10, 10, 8,  4,  11,
    14, 16, 14, 12, 9,  5,  17, 19, 19, 16, 14, 12, 6,  7,  9,  8,  8,  5,  1,
    2,  7,  11, 10, 10, 6,  2,  2,  7,  13, 12, 12, 8,  4,  2,  8,  14, 16, 16,
    12, 8,  5,  10, 17, 21, 20, 16, 11, 6,  13, 20, 26, 25, 19, 13, 8,  17, 23,
    26, 27, 22, 16, 9,  15, 20, 19, 13, 8,  4,  1,  16, 21, 22, 15, 10, 5,  0,
    15, 20, 24, 17, 12, 8,  4,  15, 22, 27, 21, 16, 12, 8,  17, 24, 29, 27, 21,
    15, 10, 20, 26, 31, 32, 24, 18, 12, 23, 29, 33, 33, 26, 19, 14, 16, 19, 22,
    25, 25, 22, 20, 15, 18, 21, 25, 25, 22, 19, 13, 16, 20, 23, 26, 22, 21, 13,
    16, 19, 23, 26, 24, 21, 13, 16, 19, 22, 26, 25, 21, 12, 16, 19, 22, 25, 24,
    22, 15, 15, 17, 21, 25, 25, 21, 14, 16, 20, 22, 21, 19, 15, 13, 15, 19, 21,
    21, 19, 15, 12, 14, 17, 20, 21, 19, 17, 11, 15, 18, 21, 21, 20, 17, 12, 14,
    17, 20, 20, 21, 17, 11, 13, 16, 19, 20, 19, 17, 18, 16, 15, 18, 18, 18, 17,
    12, 14, 16, 16, 17, 14, 11, 11, 13, 15, 15, 15, 14, 10, 10, 12, 14, 15, 14,
    15, 11, 9,  13, 14, 14, 15, 15, 12, 9,  12, 13, 14, 14, 14, 12, 12, 13, 12,
    12, 12, 13, 12, 19, 18, 14, 11, 12, 12, 11, 10, 9,  9,  9,  9,  9,  2,  9,
    8,  8,  8,  8,  8,  2,  8,  7,  7,  8,  7,  8,  3,  5,  7,  7,  7,  7,  7,
    6,  7,  7,  7,  7,  7,  7,  4,  13, 14, 13, 11, 8,  6,  5,  19, 21, 16, 12,
    9,  7,  5,  2,  2,  1,  2,  2,  2,  2,  2,  1,  1,  0,  1,  1,  3,  2,  2,
    2,  3,  3,  2,  3,  2,  6,  6,  6,  7,  5,  5,  6,  12, 11, 11, 11, 8,  5,
    12, 16, 17, 15, 13, 10, 6,  18, 21, 20, 17, 15, 12, 7,  8,  9,  8,  8,  5,
    1,  2,  8,  11, 10, 9,  6,  2,  2,  8,  13, 13, 13, 9,  5,  3,  8,  15, 17,
    17, 13, 9,  6,  11, 18, 22, 21, 17, 12, 7,  14, 20, 26, 26, 19, 14, 9,  19,
    24, 28, 28, 22, 16, 10, 15, 21, 19, 13, 8,  3,  1,  15, 20, 21, 15, 9,  5,
    1,  15, 21, 24, 18, 13, 9,  5,  15, 22, 28, 23, 17, 13, 9,  18, 24, 30, 27,
    21, 16, 11, 20, 27, 32, 32, 24, 18, 12, 24, 30, 34, 34, 27, 20, 14, 16, 19,
    23, 26, 26, 23, 20, 15, 18, 21, 25, 26, 23, 20, 14, 17, 20, 23, 25, 24, 22,
    13, 17, 20, 24, 26, 25, 22, 14, 17, 20, 24, 27, 25, 21, 12, 16, 18, 23, 27,
    25, 22, 16, 16, 18, 22, 25, 25, 22, 14, 17, 20, 23, 22, 19, 16, 13, 16, 19,
    22, 22, 18, 16, 12, 15, 18, 21, 20, 20, 17, 11, 15, 18, 22, 21, 20, 17, 12,
    15, 18, 20, 21, 21, 17, 11, 14, 17, 20, 20, 20, 18, 18, 17, 16, 19, 18, 19,
    17, 12, 15, 15, 16, 17, 15, 11, 11, 14, 15, 15, 15, 14, 11, 10, 13, 14, 15,
    15, 15, 12, 10, 13, 15, 15, 15, 15, 12, 9,  13, 14, 14, 14, 14, 12, 13, 14,
    14, 13, 13, 13, 12, 20, 19, 15, 12, 12, 12, 12, 10, 9,  9,  9,  10, 10, 3,
    9,  8,  8,  8,  8,  8,  3,  8,  8,  8,  8,  8,  8,  3,  5,  7,  8,  8,  8,
    8,  6,  7,  8,  8,  8,  8,  7,  4,  13, 15, 13, 11, 9,  7,  5,  20, 21, 16,
    12, 10, 8,  6,  2,  2,  2,  2,  2,  2,  2,  1,  1,  1,  1,  0,  2,  3,  1,
    2,  3,  3,  3,  2,  3,  1,  6,  7,  7,  7,  6,  5,  6,  11, 11, 11, 11, 8,
    6,  12, 17, 18, 16, 13, 10, 7,  19, 21, 21, 17, 16, 12, 7,  8,  9,  8,  7,
    4,  1,  2,  8,  11, 9,  8,  6,  2,  2,  8,  12, 11, 12, 9,  5,  3,  8,  14,
    16, 15, 13, 9,  6,  11, 17, 21, 20, 18, 13, 7,  15, 21, 27, 25, 19, 14, 9,
    20, 24, 28, 26, 21, 16, 11, 14, 16, 14, 10, 7,  3,  1,  13, 16, 15, 11, 9,
    5,  2,  14, 16, 18, 14, 12, 9,  5,  14, 18, 23, 19, 16, 12, 9,  17, 22, 25,
    24, 20, 16, 11, 21, 25, 29, 29, 23, 18, 13, 24, 29, 31, 30, 25, 19, 14, 15,
    18, 21, 26, 25, 22, 18, 14, 17, 20, 24, 25, 22, 19, 13, 16, 19, 23, 24, 23,
    19, 12, 15, 19, 23, 25, 23, 20, 13, 15, 19, 22, 26, 24, 21, 11, 14, 17, 21,
    25, 24, 20, 16, 15, 16, 20, 23, 23, 21, 13, 16, 18, 22, 21, 19, 15, 12, 15,
    17, 21, 21, 17, 14, 11, 14, 17, 20, 19, 18, 15, 10, 13, 17, 20, 20, 19, 16,
    10, 14, 16, 19, 19, 19, 16, 11, 13, 16, 18, 18, 18, 16, 18, 17, 16, 17, 16,
    17, 16, 11, 14, 15, 15, 16, 14, 10, 10, 12, 13, 13, 14, 13, 9,  9,  11, 13,
    14, 13, 13, 10, 8,  12, 13, 13, 13, 13, 11, 7,  11, 12, 12, 12, 13, 11, 14,
    14, 13, 12, 11, 11, 11, 20, 19, 15, 12, 10, 10, 10, 9,  8,  8,  8,  9,  9,
    3,  8,  7,  7,  7,  7,  7,  2,  6,  6,  6,  7,  6,  6,  2,  5,  6,  6,  6,
    6,  6,  5,  7,  8,  8,  8,  8,  7,  5,  14, 16, 13, 11, 9,  7,  5,  21, 22,
    16, 12, 10, 8,  6,  1,  1,  1,  0,  1,  2,  3,  2,  2,  1,  1,  2,  0,  2,
    2,  3,  3,  4,  3,  3,  3,  2,  6,  6,  6,  6,  6,  5,  7,  12, 11, 10, 10,
    8,  6,  13, 16, 17, 14, 11, 9,  7,  19, 21, 20, 15, 13, 10, 7,  6,  6,  4,
    3,  3,  2,  2,  6,  7,  5,  4,  3,  2,  2,  6,  9,  6,  6,  4,  4,  3,  6,
    10, 10, 9,  8,  7,  7,  9,  13, 16, 14, 13, 10, 8,  14, 19, 22, 19, 14, 11,
    9,  19, 22, 23, 21, 16, 12, 9,  10, 11, 8,  5,  3,  2,  1,  10, 12, 10, 5,
    4,  3,  2,  10, 12, 12, 8,  7,  5,  5,  10, 13, 16, 13, 10, 9,  8,  12, 15,
    20, 19, 15, 12, 9,  16, 20, 24, 24, 17, 13, 10, 20, 24, 25, 25, 19, 14, 11,
    9,  11, 14, 17, 17, 14, 11, 9,  11, 13, 16, 17, 13, 11, 8,  10, 12, 15, 17,
    15, 12, 8,  10, 13, 16, 18, 16, 14, 8,  11, 13, 16, 19, 16, 13, 10, 11, 13,
    15, 18, 17, 13, 16, 15, 14, 15, 17, 17, 13, 8,  10, 12, 14, 13, 11, 7,  8,
    9,  11, 13, 13, 9,  7,  7,  8,  11, 13, 12, 10, 8,  6,  9,  12, 14, 13, 12,
    9,  6,  9,  11, 13, 13, 12, 10, 12, 12, 13, 13, 12, 12, 10, 19, 17, 14, 13,
    11, 11, 10, 7,  9,  8,  8,  9,  7,  4,  6,  8,  8,  7,  7,  6,  4,  5,  8,
    7,  8,  7,  7,  5,  4,  7,  8,  8,  7,  7,  6,  7,  9,  9,  8,  8,  8,  6,
    14, 14, 13, 11, 9,  7,  6,  21, 19, 15, 12, 9,  7,  6,  5,  4,  3,  3,  3,
    4,  2,  3,  3,  3,  3,  2,  2,  0,  3,  2,  2,  3,  2,  2,  2,  7,  3,  4,
    5,  4,  4,  4,  8,  9,  9,  8,  8,  7,  5,  14, 16, 14, 12, 10, 8,  6,  21,
    22, 16, 13, 10, 9,  7,  5,  3,  2,  2,  3,  2,  2,  5,  4,  3,  2,  3,  2,
    0,  5,  5,  4,  4,  4,  4,  3,  5,  8,  8,  8,  8,  8,  6,  9,  14, 14, 13,
    13, 10, 7,  14, 18, 19, 18, 14, 11, 8,  20, 22, 23, 19, 16, 13, 9,  9,  9,
    7,  6,  4,  3,  2,  8,  10, 8,  7,  5,  3,  2,  9,  12, 11, 11, 9,  6,  4,
    9,  14, 16, 16, 13, 10, 8,  12, 18, 22, 20, 18, 14, 9,  16, 22, 28, 26, 20,
    15, 10, 21, 26, 29, 28, 22, 17, 12, 14, 18, 15, 10, 6,  3,  2,  13, 17, 18,
    12, 8,  5,  3,  13, 17, 20, 15, 12, 9,  6,  14, 19, 25, 21, 16, 14, 10, 18,
    23, 28, 26, 21, 17, 12, 21, 27, 32, 32, 25, 19, 14, 26, 30, 32, 33, 26, 21,
    15, 16, 19, 23, 26, 26, 25, 23, 15, 18, 21, 25, 26, 23, 21, 14, 17, 20, 23,
    24, 22, 19, 13, 15, 17, 20, 22, 20, 18, 12, 14, 15, 18, 21, 20, 18, 11, 12,
    14, 17, 20, 20, 17, 10, 11, 13, 16, 19, 20, 18, 13, 17, 21, 24, 24, 23, 18,
    13, 15, 19, 22, 24, 21, 17, 12, 14, 17, 20, 21, 18, 15, 10, 13, 15, 17, 17,
    17, 15, 10, 12, 14, 15, 15, 17, 14, 8,  11, 13, 15, 15, 15, 14, 11, 11, 12,
    14, 14, 15, 14, 12, 14, 16, 18, 19, 19, 15, 11, 13, 15, 16, 17, 17, 13, 10,
    13, 13, 15, 14, 15, 12, 9,  12, 12, 12, 13, 13, 12, 7,  10, 11, 11, 11, 12,
    12, 8,  9,  9,  10, 11, 11, 12, 12, 12, 10, 9,  10, 11, 12, 10, 10, 10, 11,
    13, 13, 6,  8,  9,  9,  10, 10, 10, 5,  7,  7,  8,  8,  9,  9,  5,  4,  6,
    6,  7,  7,  7,  6,  5,  5,  6,  6,  6,  7,  5,  8,  8,  7,  6,  5,  5,  4,
    12, 12, 8,  6,  5,  4,  2,  2,  2,  2,  3,  3,  4,  6,  0,  1,  1,  2,  1,
    2,  5,  0,  2,  2,  1,  1,  1,  5,  0,  2,  2,  1,  2,  1,  3,  2,  4,  4,
    3,  4,  2,  2,  5,  7,  7,  6,  5,  3,  2,  9,  10, 10, 7,  6,  4,  2,  4,
    5,  4,  5,  3,  2,  4,  4,  6,  6,  6,  3,  1,  3,  4,  7,  7,  6,  4,  1,
    2,  4,  7,  8,  7,  5,  3,  2,  4,  8,  10, 9,  7,  4,  2,  6,  10, 13, 12,
    9,  6,  2,  9,  12, 14, 13, 10, 7,  3,  9,  12, 11, 8,  5,  2,  2,  9,  12,
    13, 8,  5,  2,  1,  9,  13, 14, 9,  6,  3,  1,  9,  12, 15, 10, 7,  5,  2,
    9,  12, 15, 13, 10, 7,  3,  10, 14, 17, 16, 11, 8,  5,  12, 15, 17, 17, 13,
    9,  6,  18, 19, 22, 24, 24, 22, 19, 17, 20, 21, 24, 24, 22, 19, 15, 18, 20,
    22, 24, 22, 20, 15, 18, 20, 21, 23, 22, 19, 14, 17, 19, 21, 24, 22, 21, 13,
    16, 19, 21, 23, 22, 20, 12, 14, 17, 20, 22, 22, 20, 15, 18, 20, 23, 22, 20,
    17, 14, 17, 20, 22, 20, 19, 17, 13, 17, 19, 21, 21, 18, 18, 12, 16, 18, 20,
    19, 18, 17, 12, 15, 18, 19, 19, 20, 18, 11, 13, 17, 19, 18, 19, 17, 14, 13,
    15, 17, 18, 18, 18, 13, 17, 17, 18, 18, 17, 14, 12, 15, 16, 16, 17, 16, 13,
    11, 14, 16, 16, 16, 17, 14, 10, 13, 15, 15, 16, 16, 14, 9,  12, 14, 14, 15,
    15, 14, 9,  11, 12, 13, 13, 14, 14, 16, 16, 12, 12, 13, 13, 13, 11, 11, 12,
    12, 12, 13, 4,  10, 10, 11, 11, 11, 11, 5,  9,  9,  9,  9,  10, 10, 5,  5,
    8,  8,  8,  8,  9,  7,  6,  7,  7,  7,  8,  8,  5,  9,  10, 9,  8,  6,  6,
    5,  16, 18, 13, 9,  6,  5,  3,  3,  3,  4,  4,  4,  3,  4,  1,  2,  2,  2,
    2,  2,  5,  1,  0,  1,  1,  1,  2,  5,  1,  3,  3,  3,  4,  2,  5,  3,  8,
    8,  8,  8,  6,  3,  8,  13, 14, 12, 10, 8,  3,  15, 17, 16, 13, 11, 9,  4,
    6,  8,  8,  8,  4,  2,  4,  6,  10, 9,  9,  6,  1,  4,  6,  11, 11, 10, 7,
    2,  3,  6,  12, 12, 12, 10, 6,  4,  8,  13, 15, 14, 12, 9,  4,  11, 15, 18,
    16, 13, 11, 6,  15, 17, 19, 17, 14, 12, 8,  13, 16, 15, 12, 8,  2,  2,  13,
    16, 16, 12, 9,  4,  2,  13, 16, 18, 13, 10, 6,  1,  13, 16, 19, 14, 12, 10,
    6,  13, 16, 20, 17, 14, 12, 8,  15, 17, 21, 20, 15, 13, 10, 17, 19, 22, 21,
    17, 14, 11, 18, 21, 24, 26, 26, 24, 21, 17, 20, 23, 26, 26, 24, 21, 15, 19,
    22, 26, 25, 23, 22, 14, 17, 21, 24, 26, 24, 22, 14, 17, 21, 23, 26, 25, 22,
    13, 16, 20, 23, 26, 25, 21, 13, 15, 18, 21, 24, 24, 22, 15, 19, 21, 24, 23,
    21, 17, 15, 18, 21, 24, 23, 20, 17, 13, 17, 20, 22, 22, 20, 17, 12, 16, 19,
    22, 22, 20, 18, 12, 15, 18, 21, 21, 22, 18, 11, 14, 17, 20, 21, 20, 18, 15,
    14, 16, 19, 19, 19, 18, 13, 17, 18, 18, 19, 17, 13, 12, 15, 17, 17, 17, 17,
    13, 11, 14, 16, 16, 16, 16, 13, 10, 13, 15, 15, 16, 16, 13, 10, 13, 15, 15,
    15, 15, 14, 10, 11, 13, 13, 14, 14, 13, 16, 16, 12, 12, 13, 13, 13, 11, 11,
    11, 11, 12, 12, 4,  10, 10, 10, 11, 10, 11, 4,  8,  9,  9,  9,  9,  9,  5,
    6,  8,  8,  8,  8,  8,  7,  7,  7,  7,  7,  7,  7,  4,  10, 11, 10, 8,  7,
    6,  4,  17, 18, 13, 9,  7,  5,  3,  3,  3,  3,  4,  4,  3,  4,  2,  2,  2,
    2,  2,  3,  4,  2,  1,  0,  0,  0,  2,  4,  2,  4,  3,  3,  4,  3,  4,  4,
    8,  8,  8,  8,  6,  3,  9,  13, 14, 12, 10, 7,  4,  15, 18, 18, 14, 12, 9,
    5,  5,  7,  7,  7,  3,  2,  3,  5,  9,  9,  8,  5,  1,  3,  5,  11, 11, 10,
    6,  2,  3,  6,  12, 14, 14, 10, 6,  4,  8,  14, 19, 18, 15, 9,  5,  11, 17,
    24, 23, 18, 11, 6,  16, 21, 25, 26, 20, 13, 7,  13, 19, 18, 12, 7,  2,  2,
    13, 19, 20, 14, 9,  3,  2,  13, 19, 23, 16, 11, 6,  2,  13, 20, 25, 19, 15,
    10, 6,  15, 21, 26, 25, 19, 14, 8,  17, 24, 29, 28, 21, 16, 10, 20, 26, 30,
    31, 24, 17, 11, 18, 22, 26, 29, 29, 26, 23, 17, 20, 25, 28, 29, 26, 22, 15,
    19, 23, 26, 28, 24, 22, 14, 17, 20, 24, 27, 25, 22, 14, 17, 20, 23, 27, 25,
    22, 13, 16, 20, 23, 26, 25, 22, 13, 14, 18, 22, 25, 25, 22, 15, 19, 23, 26,
    25, 22, 19, 14, 18, 22, 25, 24, 21, 18, 13, 16, 20, 23, 22, 20, 17, 13, 16,
    19, 21, 22, 21, 18, 12, 15, 18, 21, 21, 21, 18, 11, 14, 17, 20, 20, 21, 18,
    15, 14, 17, 19, 19, 19, 18, 13, 17, 19, 19, 21, 18, 14, 12, 15, 17, 19, 19,
    17, 13, 11, 14, 16, 16, 16, 16, 12, 10, 14, 15, 15, 15, 15, 12, 10, 13, 14,
    14, 14, 15, 13, 10, 11, 13, 13, 13, 13, 13, 17, 16, 12, 12, 12, 12, 12, 11,
    11, 12, 12, 13, 13, 5,  11, 10, 10, 11, 11, 11, 4,  9,  9,  9,  9,  8,  8,
    4,  5,  9,  8,  8,  8,  8,  6,  7,  7,  7,  7,  7,  7,  3,  10, 11, 10, 9,
    6,  6,  3,  17, 18, 13, 9,  7,  5,  3,  3,  3,  4,  4,  5,  4,  5,  1,  2,
    2,  3,  3,  4,  4,  1,  1,  0,  0,  0,  2,  3,  1,  4,  4,  3,  4,  3,  3,
    4,  8,  8,  8,  8,  5,  3,  10, 13, 14, 12, 10, 7,  4,  15, 18, 17, 14, 12,
    9,  4,  6,  7,  7,  7,  4,  3,  4,  6,  10, 8,  9,  6,  2,  3,  6,  11, 10,
    10, 6,  2,  2,  6,  12, 14, 13, 10, 6,  4,  9,  15, 18, 18, 14, 9,  4,  12,
    17, 24, 22, 17, 11, 6,  16, 21, 24, 25, 19, 13, 7,  14, 19, 18, 12, 7,  3,
    4,  13, 19, 20, 14, 8,  3,  2,  13, 19, 22, 15, 10, 6,  2,  14, 20, 25, 19,
    14, 10, 5,  15, 21, 27, 24, 19, 13, 8,  17, 24, 29, 29, 22, 15, 9,  21, 27,
    30, 30, 23, 17, 11, 18, 22, 26, 29, 30, 27, 23, 17, 21, 24, 28, 30, 26, 21,
    15, 19, 23, 26, 27, 24, 21, 14, 17, 21, 24, 27, 25, 22, 14, 17, 20, 23, 27,
    25, 22, 14, 16, 19, 23, 26, 25, 21, 13, 15, 18, 21, 25, 25, 22, 15, 19, 23,
    26, 26, 23, 20, 14, 18, 22, 25, 25, 22, 18, 13, 16, 20, 23, 23, 20, 17, 12,
    15, 19, 21, 22, 21, 17, 13, 15, 18, 21, 21, 20, 17, 11, 13, 17, 19, 20, 20,
    17, 15, 15, 15, 18, 18, 18, 18, 13, 16, 18, 19, 21, 19, 15, 12, 15, 18, 18,
    19, 17, 13, 12, 14, 16, 16, 15, 16, 11, 11, 14, 14, 15, 15, 15, 12, 10, 13,
    14, 14, 14, 14, 12, 10, 12, 13, 13, 13, 13, 12, 17, 16, 13, 12, 12, 12, 11,
    12, 11, 11, 12, 13, 13, 6,  11, 9,  10, 11, 11, 11, 4,  9,  9,  9,  8,  8,
    8,  4,  5,  9,  8,  8,  8,  8,  6,  7,  7,  7,  7,  7,  7,  3,  11, 12, 10,
    8,  6,  5,  3,  17, 18, 13, 10, 7,  5,  3,  4,  3,  4,  4,  5,  5,  5,  1,
    1,  2,  3,  3,  3,  4,  1,  1,  0,  0,  0,  1,  2,  1,  4,  4,  3,  4,  3,
    3,  5,  9,  8,  8,  8,  6,  3,  10, 14, 14, 12, 10, 7,  4,  15, 18, 17, 13,
    12, 9,  5,  6,  7,  7,  7,  4,  4,  5,  6,  9,  8,  8,  5,  2,  3,  6,  11,
    10, 9,  6,  2,  2,  6,  13, 13, 12, 10, 6,  4,  9,  15, 18, 17, 14, 9,  5,
    12, 18, 23, 21, 16, 11, 6,  16, 20, 24, 23, 18, 13, 7,  13, 15, 13, 10, 7,
    3,  4,  13, 16, 15, 11, 8,  3,  1,  12, 15, 17, 11, 9,  6,  2,  12, 17, 20,
    16, 13, 9,  6,  15, 19, 23, 21, 18, 13, 7,  18, 23, 26, 26, 20, 15, 9,  21,
    25, 28, 28, 22, 17, 11, 17, 20, 25, 28, 28, 25, 21, 16, 19, 23, 28, 28, 24,
    21, 14, 18, 21, 25, 27, 23, 20, 13, 16, 19, 22, 26, 23, 20, 13, 16, 19, 22,
    26, 24, 21, 12, 15, 18, 22, 25, 24, 21, 13, 14, 17, 21, 23, 24, 21, 14, 18,
    21, 25, 24, 22, 18, 13, 17, 20, 24, 23, 20, 16, 12, 16, 19, 22, 21, 19, 15,
    11, 14, 17, 20, 20, 19, 16, 12, 14, 17, 20, 19, 19, 16, 9,  12, 15, 18, 18,
    19, 16, 16, 14, 14, 17, 17, 17, 16, 12, 15, 17, 18, 19, 17, 13, 11, 14, 16,
    17, 17, 16, 11, 11, 13, 15, 14, 15, 14, 10, 10, 13, 13, 13, 13, 13, 11, 9,
    12, 12, 12, 12, 12, 11, 11, 12, 11, 11, 12, 11, 11, 17, 16, 12, 10, 10, 10,
    10, 10, 10, 10, 11, 12, 12, 6,  9,  8,  9,  9,  10, 10, 4,  8,  7,  7,  7,
    7,  7,  3,  5,  7,  6,  6,  6,  6,  5,  6,  6,  6,  5,  6,  5,  2,  11, 12,
    10, 9,  7,  5,  3,  17, 17, 13, 10, 7,  5,  3,  2,  1,  2,  3,  4,  5,  5,
    1,  0,  1,  2,  2,  3,  3,  1,  2,  2,  2,  1,  0,  2,  1,  5,  4,  4,  4,
    3,  3,  5,  9,  8,  8,  8,  6,  3,  11, 14, 14, 11, 9,  7,  4,  16, 17, 17,
    13, 10, 8,  5,  5,  5,  4,  3,  3,  3,  5,  5,  7,  5,  4,  3,  2,  2,  5,
    7,  5,  4,  2,  2,  1,  5,  8,  8,  7,  6,  5,  4,  8,  11, 13, 11, 10, 8,
    5,  12, 15, 18, 16, 11, 8,  6,  16, 18, 19, 18, 13, 9,  7,  8,  9,  7,  5,
    3,  3,  3,  8,  9,  8,  6,  3,  2,  1,  8,  9,  10, 6,  4,  3,  2,  7,  10,
    13, 10, 8,  6,  6,  10, 13, 17, 16, 12, 9,  7,  13, 17, 20, 19, 14, 10, 8,
    17, 20, 21, 21, 16, 11, 8,  13, 16, 19, 22, 22, 20, 16, 12, 15, 18, 22, 22,
    19, 15, 11, 15, 18, 20, 21, 18, 15, 10, 12, 15, 18, 21, 19, 16, 9,  12, 15,
    18, 21, 20, 16, 8,  11, 14, 17, 21, 19, 16, 11, 11, 13, 16, 20, 19, 16, 11,
    14, 17, 20, 18, 17, 14, 10, 13, 16, 19, 18, 15, 12, 8,  12, 15, 17, 16, 14,
    12, 7,  10, 13, 16, 16, 14, 12, 7,  10, 12, 15, 15, 15, 12, 9,  10, 11, 14,
    14, 14, 12, 14, 12, 11, 13, 13, 13, 12, 8,  12, 13, 14, 15, 13, 10, 7,  10,
    13, 13, 13, 13, 8,  6,  9,  11, 11, 11, 10, 7,  5,  9,  9,  9,  9,  9,  7,
    6,  8,  9,  9,  9,  8,  7,  12, 11, 9,  8,  7,  7,  7,  15, 13, 10, 8,  7,
    6,  6,  6,  6,  7,  8,  9,  9,  5,  5,  4,  5,  6,  6,  7,  3,  3,  3,  4,
    4,  3,  3,  2,  2,  3,  3,  3,  2,  2,  2,  6,  7,  6,  5,  5,  4,  2,  12,
    12, 9,  8,  6,  5,  3,  15, 16, 11, 9,  7,  5,  4,  4,  3,  3,  2,  3,  4,
    5,  4,  4,  3,  3,  3,  3,  3,  4,  5,  4,  3,  2,  2,  0,  4,  8,  5,  5,
    4,  4,  3,  8,  12, 9,  9,  8,  6,  4,  11, 14, 14, 12, 10, 7,  5,  15, 17,
    17, 14, 12, 9,  5,  8,  7,  6,  5,  4,  4,  4,  7,  9,  6,  6,  4,  3,  2,
    8,  11, 8,  7,  5,  3,  2,  8,  11, 12, 11, 9,  6,  5,  10, 14, 17, 16, 13,
    9,  5,  13, 18, 22, 20, 15, 10, 7,  16, 20, 23, 22, 17, 12, 8,  12, 15, 13,
    9,  5,  4,  3,  11, 15, 16, 11, 6,  3,  2,  12, 15, 18, 12, 8,  5,  3,  12,
    16, 21, 16, 12, 9,  6,  14, 19, 24, 21, 16, 12, 8,  16, 21, 26, 26, 19, 13,
    9,  20, 24, 27, 27, 22, 15, 10, 15, 19, 23, 26, 26, 25, 22, 14, 18, 22, 25,
    25, 23, 21, 13, 17, 20, 23, 24, 21, 19, 13, 15, 18, 20, 22, 20, 18, 12, 14,
    16, 18, 21, 20, 18, 10, 12, 15, 17, 20, 20, 18, 10, 11, 13, 15, 19, 19, 18,
    14, 17, 20, 23, 24, 23, 19, 13, 16, 19, 22, 24, 21, 17, 12, 14, 17, 20, 20,
    19, 15, 11, 13, 16, 17, 17, 17, 15, 10, 12, 14, 16, 16, 17, 14, 8,  11, 12,
    14, 14, 15, 15, 11, 11, 12, 14, 14, 14, 14, 12, 14, 16, 17, 19, 19, 15, 11,
    13, 15, 16, 17, 17, 12, 10, 13, 14, 14, 14, 15, 12, 9,  12, 12, 12, 13, 13,
    12, 7,  10, 12, 12, 12, 12, 12, 8,  9,  9,  10, 11, 12, 12, 12, 13, 10, 9,
    10, 11, 11, 10, 10, 10, 11, 13, 14, 6,  8,  9,  9,  10, 10, 11, 5,  7,  8,
    8,  8,  9,  9,  5,  4,  6,  6,  7,  7,  7,  5,  5,  5,  6,  6,  6,  7,  5,
    8,  8,  7,  6,  5,  5,  4,  12, 12, 8,  6,  5,  4,  2,  2,  2,  2,  2,  3,
    4,  6,  0,  1,  1,  2,  1,  2,  5,  0,  1,  1,  1,  1,  1,  5,  0,  2,  2,
    1,  2,  1,  4,  2,  4,  4,  3,  4,  2,  2,  5,  7,  7,  6,  5,  3,  2,  9,
    10, 10, 7,  6,  4,  2,  4,  5,  4,  5,  3,  2,  5,  4,  6,  6,  5,  3,  1,
    3,  4,  7,  7,  6,  4,  1,  2,  4,  7,  8,  7,  5,  3,  2,  4,  8,  11, 9,
    7,  4,  2,  6,  10, 14, 12, 9,  6,  2,  9,  12, 14, 13, 10, 7,  3,  9,  12,
    11, 7,  5,  2,  2,  9,  12, 13, 8,  5,  2,  1,  9,  12, 14, 9,  6,  3,  1,
    9,  12, 15, 10, 7,  5,  2,  8,  12, 15, 13, 9,  7,  4,  10, 14, 17, 16, 11,
    8,  5,  12, 15, 17, 17, 13, 9,  6,  21, 24, 26, 29, 28, 27, 25, 21, 23, 26,
    28, 29, 26, 23, 19, 22, 25, 26, 27, 25, 23, 18, 21, 23, 26, 27, 24, 21, 16,
    19, 21, 23, 25, 23, 22, 15, 19, 21, 22, 24, 23, 21, 12, 15, 19, 22, 24, 23,
    22, 20, 23, 25, 27, 26, 24, 22, 18, 21, 24, 26, 26, 23, 21, 17, 20, 23, 25,
    23, 23, 20, 16, 18, 21, 23, 22, 21, 19, 14, 17, 19, 22, 21, 21, 19, 12, 15,
    18, 20, 21, 20, 19, 12, 12, 17, 19, 20, 19, 20, 17, 21, 22, 22, 22, 21, 18,
    15, 20, 21, 22, 21, 20, 17, 14, 18, 20, 20, 20, 20, 17, 12, 16, 17, 17, 18,
    18, 16, 11, 14, 16, 16, 17, 17, 16, 8,  12, 14, 14, 16, 16, 16, 13, 13, 11,
    13, 15, 15, 15, 14, 15, 16, 16, 17, 17, 8,  13, 13, 14, 15, 15, 15, 8,  10,
    12, 13, 13, 13, 14, 8,  7,  10, 10, 10, 10, 11, 9,  7,  8,  9,  9,  9,  10,
    6,  8,  8,  7,  7,  7,  8,  6,  13, 14, 10, 7,  6,  6,  5,  6,  6,  7,  8,
    8,  6,  8,  2,  5,  6,  6,  6,  6,  8,  2,  3,  4,  4,  4,  5,  9,  2,  0,
    0,  0,  0,  2,  6,  3,  5,  4,  5,  5,  3,  5,  5,  9,  9,  8,  6,  4,  3,
    11, 12, 11, 8,  6,  5,  2,  4,  6,  6,  6,  3,  5,  7,  4,  7,  7,  7,  4,
    5,  6,  4,  8,  8,  8,  6,  3,  6,  4,  8,  8,  7,  5,  3,  3,  4,  8,  9,
    8,  7,  5,  2,  7,  9,  12, 11, 8,  6,  3,  11, 12, 13, 12, 9,  6,  4,  9,
    12, 11, 9,  6,  3,  6,  9,  12, 13, 9,  7,  3,  5,  9,  13, 15, 10, 7,  4,
    3,  10, 12, 15, 9,  7,  6,  3,  8,  11, 14, 12, 8,  6,  5,  9,  13, 15, 14,
    10, 7,  6,  11, 14, 16, 16, 12, 8,  6,  22, 26, 28, 31, 31, 29, 26, 21, 24,
    28, 31, 31, 28, 25, 19, 23, 26, 29, 29, 27, 23, 18, 20, 24, 27, 29, 26, 22,
    15, 18, 21, 24, 27, 25, 22, 14, 16, 20, 23, 27, 25, 22, 12, 15, 18, 22, 25,
    25, 22, 19, 23, 26, 30, 27, 26, 22, 18, 21, 25, 28, 28, 24, 22, 16, 20, 24,
    27, 25, 24, 20, 15, 18, 21, 23, 23, 21, 19, 13, 16, 19, 22, 22, 21, 19, 11,
    15, 17, 21, 21, 21, 19, 12, 12, 16, 19, 20, 20, 19, 16, 20, 22, 23, 24, 22,
    18, 15, 18, 21, 22, 22, 21, 17, 14, 17, 20, 20, 20, 20, 15, 13, 15, 16, 16,
    17, 17, 14, 10, 13, 15, 15, 15, 16, 14, 8,  12, 13, 14, 14, 14, 14, 13, 13,
    12, 12, 13, 13, 13, 13, 14, 15, 16, 17, 17, 9,  12, 13, 14, 15, 15, 15, 8,
    9,  11, 12, 13, 12, 13, 8,  6,  9,  9,  9,  9,  9,  7,  6,  8,  8,  8,  8,
    8,  4,  8,  8,  7,  6,  6,  7,  4,  13, 15, 10, 7,  5,  5,  3,  5,  6,  7,
    8,  8,  7,  8,  2,  5,  5,  6,  7,  6,  8,  2,  3,  3,  4,  4,  4,  5,  2,
    0,  0,  0,  0,  2,  4,  3,  5,  5,  4,  5,  3,  3,  6,  10, 11, 9,  7,  4,
    2,  12, 15, 14, 11, 9,  6,  2,  4,  6,  7,  7,  4,  6,  7,  4,  8,  8,  9,
    5,  5,  6,  4,  10, 10, 10, 6,  2,  4,  4,  10, 11, 11, 7,  3,  2,  5,  11,
    15, 15, 12, 6,  2,  8,  14, 20, 19, 14, 8,  3,  13, 17, 21, 21, 16, 10, 4,
    12, 19, 18, 12, 7,  5,  6,  13, 19, 21, 14, 8,  3,  5,  13, 19, 23, 15, 10,
    4,  2,  13, 18, 23, 17, 11, 7,  3,  12, 18, 23, 21, 16, 10, 4,  14, 20, 25,
    24, 19, 12, 6,  17, 23, 25, 25, 20, 14, 8,  22, 26, 29, 32, 33, 30, 26, 20,
    24, 28, 33, 33, 29, 26, 19, 23, 27, 30, 31, 28, 23, 18, 20, 24, 27, 30, 26,
    23, 15, 18, 21, 24, 28, 26, 23, 14, 17, 19, 23, 27, 26, 22, 12, 15, 18, 22,
    26, 25, 22, 19, 23, 27, 29, 29, 27, 23, 18, 21, 26, 29, 29, 25, 22, 16, 20,
    24, 27, 26, 24, 20, 15, 18, 21, 24, 23, 22, 19, 13, 16, 19, 21, 22, 21, 19,
    12, 15, 18, 20, 21, 21, 18, 12, 12, 17, 19, 20, 19, 19, 16, 20, 22, 23, 24,
    22, 19, 15, 18, 20, 22, 23, 22, 17, 13, 17, 19, 19, 20, 19, 15, 13, 15, 15,
    16, 16, 17, 13, 10, 13, 15, 15, 14, 15, 13, 8,  12, 13, 14, 14, 13, 13, 13,
    13, 12, 12, 13, 13, 12, 14, 14, 15, 16, 17, 18, 10, 13, 13, 14, 15, 15, 15,
    8,  10, 11, 12, 12, 12, 12, 7,  6,  10, 9,  9,  9,  9,  7,  6,  8,  8,  8,
    7,  7,  4,  8,  8,  7,  6,  6,  6,  3,  13, 14, 9,  6,  5,  5,  2,  6,  6,
    7,  8,  9,  8,  9,  1,  5,  6,  6,  7,  6,  8,  1,  3,  3,  3,  4,  4,  5,
    1,  0,  0,  0,  0,  2,  3,  3,  5,  4,  4,  4,  2,  2,  6,  10, 11, 9,  6,
    3,  2,  12, 15, 14, 10, 9,  5,  2,  4,  6,  7,  7,  5,  7,  8,  4,  8,  8,
    8,  5,  5,  6,  4,  10, 10, 9,  5,  2,  3,  4,  9,  11, 10, 6,  2,  2,  5,
    11, 15, 14, 11, 5,  2,  8,  14, 20, 18, 13, 7,  2,  12, 17, 21, 21, 15, 10,
    4,  13, 19, 17, 12, 7,  5,  7,  13, 18, 20, 13, 8,  3,  4,  13, 19, 21, 14,
    9,  4,  1,  13, 17, 22, 16, 10, 6,  2,  12, 17, 24, 21, 15, 9,  4,  14, 20,
    25, 25, 18, 11, 6,  17, 22, 26, 26, 20, 14, 8,  22, 26, 30, 34, 33, 30, 28,
    21, 24, 29, 33, 33, 30, 26, 19, 23, 27, 31, 32, 28, 24, 18, 20, 24, 28, 30,
    27, 23, 15, 18, 21, 25, 29, 26, 23, 14, 17, 20, 23, 27, 27, 23, 12, 15, 19,
    23, 26, 26, 22, 19, 23, 28, 30, 29, 26, 24, 18, 21, 25, 29, 30, 26, 22, 17,
    20, 24, 27, 27, 23, 20, 15, 18, 21, 23, 24, 22, 18, 14, 16, 19, 22, 22, 22,
    18, 12, 15, 17, 20, 20, 21, 19, 12, 13, 17, 20, 19, 20, 18, 17, 20, 22, 23,
    24, 23, 18, 15, 19, 21, 22, 23, 21, 17, 15, 17, 20, 19, 20, 19, 15, 13, 16,
    16, 17, 17, 16, 13, 10, 14, 15, 15, 15, 15, 13, 9,  12, 14, 14, 14, 14, 13,
    12, 12, 12, 12, 13, 13, 12, 15, 15, 15, 16, 17, 18, 10, 13, 13, 14, 15, 15,
    15, 8,  10, 12, 12, 12, 12, 12, 7,  6,  10, 9,  9,  9,  9,  7,  6,  8,  8,
    8,  7,  8,  4,  8,  8,  7,  7,  6,  6,  3,  12, 12, 9,  6,  5,  5,  2,  6,
    6,  7,  8,  9,  8,  10, 2,  5,  6,  7,  7,  6,  8,  1,  4,  4,  4,  4,  4,
    4,  1,  0,  0,  0,  0,  1,  3,  3,  5,  4,  4,  4,  2,  2,  6,  10, 10, 8,
    6,  3,  2,  11, 13, 13, 10, 8,  5,  1,  5,  7,  7,  7,  5,  7,  8,  5,  9,
    8,  8,  5,  5,  6,  5,  10, 9,  8,  5,  2,  3,  5,  10, 10, 9,  6,  2,  2,
    5,  11, 14, 13, 10, 5,  1,  8,  14, 19, 17, 12, 7,  2,  12, 16, 20, 20, 14,
    9,  3,  12, 15, 13, 10, 6,  6,  7,  12, 15, 15, 11, 7,  4,  4,  12, 15, 16,
    11, 8,  3,  2,  12, 15, 17, 13, 10, 6,  2,  11, 16, 19, 17, 14, 9,  4,  14,
    19, 23, 23, 16, 11, 5,  16, 21, 24, 23, 19, 13, 7,  21, 24, 28, 32, 33, 29,
    25, 19, 23, 27, 31, 32, 28, 25, 18, 21, 25, 29, 30, 27, 23, 17, 20, 22, 25,
    28, 25, 21, 14, 17, 20, 23, 27, 24, 21, 13, 16, 18, 22, 26, 25, 21, 11, 14,
    17, 21, 24, 24, 21, 17, 22, 25, 29, 28, 26, 23, 17, 20, 24, 28, 28, 24, 20,
    15, 19, 22, 26, 26, 23, 18, 14, 16, 20, 22, 22, 21, 17, 12, 15, 18, 20, 20,
    20, 17, 10, 13, 16, 19, 19, 19, 17, 10, 12, 15, 18, 18, 18, 17, 16, 19, 21,
    21, 24, 21, 17, 14, 17, 20, 21, 21, 20, 15, 13, 16, 18, 18, 18, 18, 14, 12,
    14, 15, 15, 15, 15, 11, 10, 13, 14, 13, 13, 13, 12, 8,  11, 12, 12, 12, 12,
    11, 10, 10, 10, 11, 11, 11, 11, 13, 13, 14, 15, 16, 17, 9,  11, 12, 13, 14,
    14, 14, 7,  9,  11, 10, 11, 10, 10, 6,  5,  9,  8,  7,  7,  7,  6,  5,  6,
    6,  6,  6,  6,  3,  8,  7,  6,  5,  4,  5,  3,  10, 10, 7,  5,  4,  3,  2,
    5,  5,  6,  7,  8,  8,  9,  1,  4,  5,  5,  6,  6,  7,  1,  2,  3,  3,  3,
    3,  4,  1,  2,  2,  2,  1,  0,  2,  2,  6,  5,  4,  4,  2,  2,  6,  9,  9,
    7,  5,  3,  1,  9,  11, 10, 7,  6,  4,  2,  5,  4,  4,  4,  5,  7,  8,  5,
    6,  4,  4,  4,  4,  6,  5,  8,  5,  4,  2,  2,  3,  5,  7,  7,  4,  3,  2,
    1,  5,  8,  10, 8,  6,  4,  2,  8,  11, 13, 10, 7,  5,  3,  10, 12, 13, 12,
    8,  6,  3,  9,  11, 8,  5,  5,  6,  6,  9,  11, 9,  5,  4,  4,  4,  9,  11,
    11, 6,  4,  2,  1,  8,  11, 11, 7,  5,  3,  2,  8,  10, 13, 11, 8,  5,  4,
    10, 13, 15, 14, 9,  7,  4,  11, 14, 15, 15, 11, 7,  5,  17, 21, 24, 28, 27,
    25, 22, 16, 20, 24, 27, 27, 23, 20, 14, 18, 21, 24, 26, 23, 18, 13, 16, 19,
    22, 25, 20, 17, 10, 13, 15, 19, 22, 20, 17, 9,  11, 14, 18, 22, 21, 17, 7,
    10, 14, 16, 20, 20, 17, 14, 18, 21, 25, 24, 22, 18, 13, 17, 21, 24, 23, 20,
    16, 12, 15, 20, 21, 21, 19, 14, 11, 13, 16, 19, 18, 17, 13, 8,  11, 13, 16,
    16, 16, 13, 7,  9,  12, 15, 15, 15, 12, 6,  8,  12, 14, 13, 14, 13, 12, 16,
    17, 18, 19, 18, 14, 10, 14, 16, 17, 17, 16, 12, 9,  13, 15, 14, 14, 14, 10,
    9,  11, 11, 11, 11, 11, 8,  5,  8,  9,  9,  9,  9,  8,  5,  7,  8,  8,  8,
    8,  8,  6,  6,  7,  6,  7,  7,  6,  10, 10, 10, 11, 12, 13, 9,  8,  8,  9,
    10, 10, 10, 6,  6,  7,  7,  7,  7,  7,  4,  3,  4,  4,  3,  4,  4,  3,  3,
    3,  2,  2,  2,  2,  2,  5,  5,  3,  3,  2,  1,  0,  6,  7,  4,  3,  2,  2,
    1,  2,  3,  4,  5,  6,  8,  8,  4,  3,  4,  5,  5,  5,  6,  4,  5,  4,  3,
    3,  3,  3,  4,  6,  4,  3,  3,  2,  0,  4,  6,  5,  4,  4,  2,  1,  6,  7,
    8,  7,  5,  3,  2,  7,  9,  11, 8,  7,  5,  2,  7,  6,  5,  5,  5,  7,  7,
    7,  8,  6,  6,  4,  4,  5,  7,  8,  7,  7,  4,  2,  2,  7,  8,  8,  8,  5,
    3,  2,  6,  9,  12, 11, 8,  5,  2,  7,  11, 16, 15, 10, 6,  3,  9,  13, 17,
    17, 12, 7,  3,  10, 14, 13, 8,  5,  6,  6,  10, 14, 15, 10, 6,  3,  3,  10,
    14, 17, 10, 6,  3,  2,  10, 13, 17, 12, 8,  5,  2,  10, 14, 19, 16, 11, 8,
    4,  12, 16, 21, 20, 14, 9,  5,  14, 18, 22, 22, 16, 11, 6,  19, 22, 24, 28,
    28, 25, 22, 18, 21, 23, 26, 28, 25, 22, 17, 20, 22, 24, 26, 23, 20, 16, 18,
    20, 22, 24, 21, 17, 13, 15, 17, 18, 21, 19, 16, 11, 12, 14, 16, 19, 18, 16,
    8,  10, 12, 15, 17, 18, 16, 17, 20, 23, 25, 25, 23, 20, 17, 19, 22, 24, 24,
    22, 19, 15, 18, 21, 22, 22, 20, 18, 14, 16, 18, 19, 19, 18, 14, 10, 13, 14,
    15, 15, 15, 14, 8,  10, 12, 14, 14, 15, 14, 9,  9,  11, 12, 13, 13, 14, 15,
    18, 19, 20, 20, 20, 16, 13, 17, 18, 19, 19, 18, 16, 12, 16, 17, 17, 17, 17,
    15, 11, 14, 15, 15, 15, 15, 13, 7,  10, 12, 11, 12, 12, 13, 5,  8,  9,  10,
    11, 12, 12, 10, 10, 8,  8,  10, 11, 11, 12, 14, 14, 15, 15, 16, 9,  11, 12,
    13, 13, 13, 14, 9,  9,  10, 11, 11, 12, 12, 9,  6,  8,  8,  9,  9,  9,  7,
    4,  5,  5,  5,  6,  6,  6,  5,  6,  5,  4,  4,  5,  5,  10, 10, 6,  4,  3,
    3,  3,  4,  5,  6,  7,  7,  8,  9,  2,  4,  5,  6,  6,  7,  9,  2,  3,  4,
    4,  4,  5,  8,  2,  3,  3,  3,  3,  2,  4,  0,  3,  2,  2,  2,  1,  3,  3,
    4,  5,  4,  3,  1,  1,  7,  7,  7,  5,  4,  3,  1,  5,  6,  6,  7,  5,  6,
    8,  5,  7,  7,  7,  5,  5,  7,  5,  8,  8,  8,  6,  4,  6,  5,  7,  8,  7,
    5,  2,  1,  3,  6,  9,  8,  5,  2,  1,  4,  8,  11, 10, 7,  4,  1,  6,  10,
    12, 11, 8,  5,  2,  10, 13, 13, 9,  6,  5,  6,  10, 14, 14, 10, 7,  5,  6,
    10, 14, 15, 10, 7,  5,  3,  10, 13, 15, 10, 7,  4,  1,  9,  11, 14, 12, 8,
    5,  2,  8,  12, 15, 14, 9,  6,  3,  10, 13, 15, 15, 11, 7,  4,  27, 29, 32,
    35, 35, 32, 30, 25, 29, 31, 34, 34, 31, 28, 25, 27, 31, 32, 33, 30, 26, 22,
    26, 28, 30, 32, 28, 24, 20, 23, 25, 26, 28, 26, 23, 16, 19, 21, 24, 26, 25,
    23, 13, 17, 21, 23, 26, 26, 23, 24, 28, 31, 33, 32, 29, 28, 23, 26, 29, 32,
    32, 29, 26, 21, 25, 28, 30, 30, 28, 25, 20, 23, 26, 28, 26, 25, 21, 16, 20,
    22, 24, 24, 22, 21, 14, 17, 20, 21, 22, 22, 21, 10, 13, 18, 21, 21, 21, 21,
    21, 25, 28, 28, 28, 27, 24, 20, 24, 26, 27, 27, 27, 23, 18, 22, 24, 25, 26,
    25, 22, 16, 20, 21, 22, 22, 23, 18, 11, 16, 17, 18, 18, 18, 18, 7,  13, 16,
    16, 16, 17, 18, 9,  10, 13, 15, 15, 16, 17, 18, 19, 21, 22, 22, 22, 15, 16,
    18, 20, 20, 20, 21, 14, 13, 16, 17, 18, 18, 18, 14, 9,  14, 14, 14, 15, 15,
    12, 7,  10, 10, 10, 10, 11, 8,  7,  7,  7,  8,  9,  9,  6,  9,  9,  6,  6,
    7,  8,  7,  9,  11, 12, 14, 14, 13, 14, 4,  9,  11, 12, 12, 11, 14, 4,  7,
    8,  8,  9,  9,  12, 4,  5,  5,  5,  5,  6,  6,  3,  0,  0,  0,  0,  3,  6,
    3,  3,  3,  2,  1,  1,  6,  6,  6,  5,  2,  2,  2,  5,  4,  5,  6,  6,  9,
    12, 13, 4,  5,  6,  6,  8,  10, 11, 4,  6,  6,  6,  5,  7,  9,  4,  5,  5,
    5,  3,  3,  6,  2,  3,  5,  4,  2,  2,  4,  2,  4,  7,  6,  3,  2,  2,  5,
    5,  8,  7,  4,  2,  1,  7,  10, 9,  7,  7,  10, 12, 7,  10, 11, 8,  6,  8,
    10, 7,  10, 12, 7,  5,  5,  6,  7,  9,  12, 7,  4,  2,  2,  5,  8,  10, 7,
    4,  2,  1,  4,  7,  10, 9,  5,  2,  1,  5,  9,  11, 11, 7,  3,  2,  27, 30,
    34, 37, 37, 34, 32, 25, 29, 32, 36, 36, 34, 29, 23, 27, 32, 34, 35, 32, 28,
    22, 25, 28, 31, 33, 29, 24, 19, 22, 25, 27, 30, 28, 24, 16, 19, 21, 24, 29,
    27, 24, 13, 17, 20, 24, 27, 27, 24, 24, 27, 31, 34, 33, 31, 28, 22, 26, 30,
    33, 33, 31, 27, 20, 24, 29, 31, 30, 29, 25, 19, 22, 25, 28, 28, 27, 22, 16,
    18, 22, 25, 24, 23, 21, 13, 16, 19, 23, 22, 23, 21, 10, 14, 18, 21, 21, 21,
    21, 21, 24, 27, 29, 29, 28, 23, 19, 23, 26, 27, 28, 26, 22, 18, 21, 24, 24,
    25, 24, 20, 16, 20, 20, 20, 21, 22, 17, 10, 16, 17, 17, 17, 18, 16, 7,  13,
    15, 16, 16, 16, 16, 8,  11, 13, 13, 15, 15, 15, 18, 19, 20, 21, 22, 23, 15,
    15, 17, 19, 20, 19, 19, 14, 12, 16, 17, 17, 17, 17, 13, 8,  13, 13, 13, 14,
    14, 11, 6,  9,  9,  9,  9,  9,  8,  6,  7,  7,  8,  8,  8,  5,  8,  9,  5,
    6,  6,  7,  5,  8,  10, 12, 13, 13, 13, 15, 3,  9,  10, 11, 11, 11, 14, 3,
    8,  8,  8,  8,  8,  9,  3,  5,  4,  4,  4,  5,  5,  2,  0,  0,  0,  0,  2,
    4,  3,  5,  6,  5,  3,  1,  4,  7,  10, 10, 6,  5,  2,  4,  4,  5,  6,  7,
    9,  11, 13, 4,  7,  7,  7,  8,  9,  11, 4,  9,  9,  8,  5,  7,  8,  4,  8,
    10, 10, 5,  3,  4,  2,  7,  12, 12, 7,  2,  3,  3,  9,  15, 15, 10, 4,  2,
    8,  12, 16, 16, 12, 6,  1,  11, 17, 16, 11, 7,  10, 12, 11, 18, 19, 13, 7,
    8,  9,  11, 17, 21, 14, 8,  4,  6,  11, 17, 21, 15, 9,  4,  2,  10, 16, 21,
    17, 12, 6,  1,  10, 16, 20, 19, 14, 8,  2,  13, 18, 20, 20, 16, 10, 4,  27,
    30, 33, 37, 36, 35, 31, 25, 29, 32, 36, 37, 35, 30, 23, 27, 31, 35, 35, 32,
    28, 22, 25, 29, 31, 34, 30, 24, 19, 22, 24, 27, 31, 28, 25, 16, 18, 21, 25,
    29, 28, 25, 13, 16, 20, 23, 27, 27, 25, 23, 28, 30, 34, 33, 31, 29, 22, 26,
    30, 33, 34, 29, 26, 20, 24, 28, 30, 31, 28, 23, 19, 22, 24, 27, 28, 26, 20,
    17, 19, 21, 24, 24, 23, 20, 14, 16, 19, 22, 21, 22, 20, 10, 14, 18, 20, 21,
    21, 21, 20, 24, 26, 27, 29, 27, 23, 19, 22, 25, 26, 26, 25, 21, 18, 21, 23,
    24, 24, 24, 19, 15, 20, 20, 20, 21, 20, 16, 10, 16, 16, 17, 16, 16, 16, 7,
    14, 14, 15, 15, 15, 16, 8,  11, 13, 14, 14, 14, 14, 18, 18, 19, 20, 22, 22,
    15, 15, 17, 18, 19, 20, 20, 13, 11, 16, 16, 16, 16, 16, 12, 8,  14, 12, 13,
    13, 13, 11, 6,  10, 9,  9,  9,  9,  7,  6,  7,  7,  7,  7,  8,  4,  8,  8,
    5,  6,  6,  6,  4,  7,  10, 12, 13, 13, 13, 14, 3,  9,  10, 11, 11, 10, 13,
    3,  8,  8,  8,  8,  8,  9,  3,  5,  4,  4,  4,  4,  4,  2,  0,  0,  0,  0,
    2,  3,  3,  5,  6,  4,  2,  1,  3,  6,  9,  9,  6,  4,  2,  2,  4,  5,  6,
    7,  9,  12, 13, 4,  7,  7,  7,  8,  9,  10, 4,  8,  9,  8,  5,  6,  7,  4,
    8,  9,  9,  5,  3,  3,  2,  7,  11, 11, 7,  2,  3,  3,  9,  15, 15, 9,  3,
    2,  7,  12, 17, 17, 11, 5,  1,  11, 17, 16, 11, 7,  10, 11, 11, 17, 19, 12,
    7,  8,  9,  11, 17, 20, 14, 8,  4,  5,  11, 17, 21, 14, 9,  3,  2,  10, 15,
    21, 17, 11, 5,  1,  10, 16, 21, 21, 14, 7,  2,  12, 18, 22, 22, 16, 10, 4,
    26, 30, 33, 39, 37, 35, 31, 25, 29, 32, 37, 37, 33, 30, 23, 26, 32, 34, 36,
    32, 28, 22, 24, 28, 31, 33, 30, 25, 19, 21, 25, 27, 30, 28, 25, 16, 19, 21,
    25, 28, 28, 25, 14, 17, 20, 24, 27, 28, 25, 23, 28, 30, 34, 34, 31, 27, 22,
    26, 29, 32, 33, 30, 26, 21, 24, 28, 30, 31, 28, 24, 20, 22, 25, 28, 29, 26,
    20, 17, 19, 21, 23, 24, 23, 20, 14, 16, 19, 21, 22, 23, 20, 12, 15, 18, 21,
    21, 21, 20, 21, 24, 27, 27, 29, 27, 23, 19, 23, 26, 26, 26, 25, 21, 18, 22,
    23, 23, 24, 24, 19, 15, 20, 20, 20, 20, 20, 15, 10, 16, 17, 17, 17, 16, 15,
    7,  14, 15, 15, 15, 15, 14, 7,  12, 14, 14, 14, 14, 14, 18, 19, 20, 20, 22,
    21, 15, 15, 17, 18, 20, 20, 19, 13, 12, 16, 16, 16, 16, 16, 12, 8,  14, 13,
    12, 13, 13, 11, 6,  10, 9,  9,  9,  9,  7,  6,  8,  8,  7,  7,  8,  4,  7,
    5,  6,  6,  6,  6,  4,  7,  11, 12, 12, 13, 13, 15, 4,  9,  10, 11, 11, 10,
    13, 4,  8,  8,  8,  8,  8,  8,  4,  5,  5,  4,  4,  4,  4,  2,  0,  0,  0,
    0,  2,  3,  3,  4,  4,  3,  2,  2,  3,  4,  5,  5,  4,  4,  2,  2,  4,  5,
    6,  7,  9,  11, 13, 4,  7,  7,  7,  8,  9,  10, 4,  9,  8,  7,  5,  6,  7,
    4,  8,  9,  8,  5,  3,  3,  2,  7,  11, 9,  6,  2,  2,  3,  9,  14, 12, 8,
    3,  2,  4,  9,  14, 14, 10, 5,  1,  10, 14, 12, 9,  8,  10, 11, 10, 14, 14,
    10, 7,  8,  8,  10, 14, 15, 10, 7,  4,  5,  10, 13, 15, 11, 8,  3,  2,  10,
    13, 16, 14, 10, 5,  1,  10, 15, 18, 17, 12, 7,  2,  11, 15, 18, 18, 13, 9,
    3,  24, 27, 31, 35, 36, 33, 29, 22, 26, 30, 34, 36, 32, 28, 21, 25, 28, 32,
    33, 29, 25, 19, 22, 26, 29, 31, 27, 23, 17, 19, 21, 25, 29, 26, 23, 15, 17,
    19, 23, 27, 26, 22, 13, 16, 19, 22, 26, 26, 23, 21, 25, 28, 32, 31, 28, 25,
    20, 22, 27, 31, 31, 28, 23, 19, 22, 26, 28, 28, 25, 21, 17, 20, 23, 25, 25,
    23, 18, 15, 17, 19, 22, 22, 21, 18, 13, 15, 17, 20, 20, 21, 19, 10, 14, 17,
    19, 19, 19, 18, 19, 22, 23, 25, 27, 24, 20, 18, 21, 23, 24, 24, 23, 18, 17,
    19, 21, 22, 21, 20, 16, 15, 17, 18, 18, 18, 18, 13, 10, 14, 15, 14, 14, 15,
    13, 6,  13, 14, 13, 13, 13, 13, 6,  12, 12, 12, 12, 12, 12, 17, 17, 17, 18,
    19, 19, 13, 14, 15, 16, 16, 17, 17, 10, 11, 14, 14, 14, 14, 13, 9,  7,  12,
    11, 10, 10, 10, 9,  5,  8,  8,  7,  7,  7,  5,  5,  6,  6,  6,  6,  6,  3,
    6,  4,  4,  4,  4,  4,  3,  7,  8,  9,  10, 11, 11, 13, 2,  7,  8,  8,  9,
    8,  10, 2,  6,  6,  5,  6,  6,  6,  2,  3,  3,  2,  2,  3,  3,  1,  3,  2,
    2,  2,  0,  2,  2,  5,  5,  4,  2,  1,  2,  3,  6,  7,  4,  3,  2,  2,  3,
    4,  5,  7,  8,  10, 11, 3,  4,  5,  6,  7,  7,  8,  3,  6,  5,  4,  4,  4,
    5,  3,  5,  5,  3,  2,  1,  2,  3,  7,  7,  5,  4,  2,  1,  5,  7,  10, 7,
    4,  3,  0,  6,  8,  10, 8,  5,  3,  1,  6,  8,  7,  5,  7,  8,  9,  6,  8,
    7,  6,  6,  6,  6,  6,  8,  9,  5,  3,  3,  3,  6,  8,  10, 7,  4,  2,  0,
    7,  10, 11, 8,  5,  3,  2,  8,  10, 11, 10, 6,  4,  2,  9,  10, 11, 11, 7,
    4,  3,  19, 22, 26, 30, 30, 27, 23, 17, 21, 25, 29, 29, 25, 22, 16, 20, 23,
    26, 28, 24, 20, 15, 17, 21, 24, 26, 23, 18, 12, 14, 17, 20, 24, 22, 18, 10,
    13, 16, 19, 22, 22, 18, 8,  11, 15, 18, 20, 21, 18, 16, 20, 23, 27, 25, 23,
    20, 15, 18, 22, 26, 26, 22, 18, 14, 17, 21, 23, 23, 20, 16, 12, 15, 18, 21,
    20, 19, 14, 9,  12, 15, 17, 17, 17, 14, 8,  11, 14, 16, 16, 16, 14, 6,  9,
    13, 15, 14, 15, 14, 14, 17, 19, 19, 21, 20, 15, 12, 15, 17, 18, 19, 18, 13,
    11, 14, 16, 16, 16, 16, 11, 10, 12, 13, 12, 13, 13, 9,  6,  9,  10, 10, 10,
    10, 9,  5,  8,  9,  9,  9,  9,  9,  6,  7,  8,  8,  8,  8,  8,  11, 11, 12,
    13, 14, 15, 9,  10, 10, 10, 11, 11, 12, 7,  8,  9,  9,  9,  8,  8,  5,  4,
    6,  5,  5,  5,  5,  4,  3,  3,  3,  3,  3,  2,  2,  4,  3,  2,  2,  2,  2,
    1,  6,  7,  4,  3,  2,  1,  0,  3,  3,  5,  6,  7,  8,  9,  2,  3,  4,  5,
    6,  6,  7,  2,  3,  3,  3,  3,  3,  4,  2,  5,  3,  2,  2,  2,  1,  3,  6,
    4,  3,  3,  2,  0,  4,  7,  6,  4,  3,  2,  2,  6,  8,  8,  6,  4,  3,  2,
    6,  6,  5,  5,  6,  7,  8,  6,  7,  5,  5,  5,  5,  5,  6,  8,  6,  4,  3,
    2,  2,  6,  8,  6,  5,  4,  3,  1,  6,  7,  9,  8,  5,  3,  2,  7,  9,  13,
    11, 7,  4,  2,  8,  10, 14, 13, 9,  5,  3,  8,  11, 9,  6,  5,  7,  7,  8,
    11, 11, 7,  4,  4,  4,  8,  11, 13, 7,  4,  3,  2,  8,  10, 14, 8,  5,  3,
    2,  8,  11, 15, 13, 8,  5,  3,  9,  13, 17, 17, 10, 6,  3,  11, 15, 18, 18,
    12, 7,  4,  23, 25, 27, 31, 31, 29, 25, 23, 24, 26, 29, 30, 27, 25, 21, 24,
    27, 27, 28, 25, 22, 20, 21, 24, 25, 26, 22, 16, 17, 19, 20, 21, 20, 18, 16,
    12, 14, 16, 16, 18, 18, 16, 8,  11, 14, 16, 18, 18, 16, 21, 24, 25, 28, 27,
    26, 24, 20, 23, 25, 27, 27, 24, 23, 18, 22, 25, 24, 25, 22, 20, 17, 20, 22,
    22, 21, 20, 15, 14, 16, 18, 19, 16, 15, 14, 9,  12, 14, 15, 14, 15, 15, 6,
    8,  12, 14, 14, 15, 15, 19, 22, 23, 24, 24, 24, 21, 16, 20, 22, 23, 24, 23,
    21, 15, 19, 21, 22, 22, 21, 19, 14, 17, 18, 18, 18, 19, 14, 9,  13, 14, 15,
    14, 14, 13, 4,  9,  10, 11, 12, 13, 13, 7,  7,  8,  10, 11, 12, 13, 15, 17,
    18, 20, 20, 21, 16, 14, 15, 16, 18, 18, 18, 14, 11, 13, 15, 15, 15, 15, 12,
    7,  11, 11, 11, 12, 11, 10, 5,  7,  7,  7,  6,  7,  6,  3,  3,  3,  3,  5,
    6,  6,  6,  6,  4,  2,  3,  4,  5,  8,  10, 11, 13, 14, 15, 16, 5,  9,  10,
    12, 12, 13, 15, 5,  8,  9,  9,  10, 10, 11, 5,  6,  6,  6,  6,  6,  5,  3,
    3,  3,  3,  3,  2,  4,  0,  3,  3,  2,  2,  2,  5,  4,  4,  5,  3,  3,  3,
    3,  7,  8,  8,  9,  11, 14, 15, 7,  9,  8,  9,  9,  11, 13, 7,  9,  9,  9,
    7,  8,  10, 7,  8,  8,  8,  6,  5,  5,  5,  7,  9,  7,  5,  3,  2,  3,  5,
    10, 8,  6,  3,  2,  4,  7,  10, 10, 7,  4,  2,  10, 13, 13, 10, 9,  12, 13,
    10, 14, 14, 11, 9,  9,  11, 10, 13, 16, 11, 8,  7,  8,  10, 13, 15, 10, 8,
    6,  2,  9,  11, 14, 11, 7,  4,  2,  7,  10, 13, 12, 8,  5,  3,  7,  11, 13,
    13, 9,  6,  3,  30, 34, 36, 38, 39, 38, 34, 29, 33, 36, 38, 38, 35, 33, 27,
    31, 33, 36, 37, 34, 30, 26, 29, 31, 35, 35, 30, 24, 23, 26, 27, 30, 29, 27,
    24, 18, 22, 23, 25, 27, 26, 24, 14, 18, 21, 24, 26, 26, 24, 27, 31, 35, 37,
    36, 35, 31, 25, 30, 33, 36, 36, 33, 29, 24, 28, 31, 34, 34, 31, 28, 23, 26,
    30, 32, 29, 28, 22, 19, 23, 25, 27, 25, 24, 22, 15, 18, 20, 22, 23, 24, 22,
    11, 15, 19, 22, 22, 22, 22, 24, 29, 30, 32, 33, 32, 28, 22, 26, 30, 31, 30,
    31, 26, 22, 25, 28, 28, 28, 28, 23, 19, 23, 24, 25, 25, 25, 18, 13, 19, 21,
    21, 19, 19, 19, 7,  15, 16, 16, 18, 18, 19, 7,  11, 14, 15, 16, 17, 17, 21,
    23, 24, 26, 27, 27, 21, 18, 21, 22, 24, 24, 24, 19, 14, 20, 20, 21, 21, 21,
    17, 11, 17, 17, 17, 17, 17, 15, 9,  12, 12, 13, 12, 12, 11, 6,  8,  8,  9,
    9,  10, 8,  7,  5,  6,  7,  8,  8,  8,  11, 14, 16, 17, 18, 19, 20, 7,  13,
    14, 16, 17, 16, 19, 7,  13, 13, 13, 14, 14, 15, 7,  9,  10, 9,  9,  9,  8,
    5,  3,  5,  5,  4,  5,  7,  3,  0,  2,  2,  1,  3,  7,  3,  3,  3,  2,  2,
    2,  5,  7,  9,  10, 12, 15, 18, 20, 7,  7,  9,  11, 13, 16, 16, 7,  8,  8,
    8,  10, 12, 12, 7,  7,  7,  7,  6,  7,  6,  5,  5,  6,  5,  3,  2,  5,  2,
    3,  5,  4,  3,  2,  4,  3,  5,  6,  6,  4,  2,  3,  9,  11, 11, 9,  12, 16,
    17, 9,  11, 12, 10, 10, 13, 15, 9,  11, 13, 9,  7,  9,  11, 9,  10, 12, 8,
    6,  5,  4,  7,  9,  10, 8,  4,  2,  3,  5,  7,  9,  8,  4,  3,  2,  4,  6,
    9,  9,  5,  3,  2,  32, 36, 40, 42, 43, 41, 37, 31, 35, 39, 42, 42, 39, 35,
    29, 33, 38, 40, 41, 37, 33, 28, 30, 35, 37, 39, 34, 27, 25, 27, 30, 32, 33,
    30, 27, 21, 23, 26, 28, 31, 31, 27, 16, 20, 24, 27, 30, 30, 27, 29, 34, 37,
    39, 39, 37, 34, 28, 33, 35, 38, 39, 35, 32, 26, 30, 34, 36, 36, 33, 28, 25,
    28, 31, 33, 34, 30, 24, 21, 24, 27, 29, 27, 26, 24, 16, 20, 23, 25, 25, 27,
    24, 13, 17, 21, 24, 24, 25, 24, 26, 30, 32, 34, 35, 34, 29, 25, 28, 31, 33,
    33, 31, 26, 22, 26, 30, 30, 29, 29, 24, 19, 25, 26, 26, 27, 25, 20, 13, 21,
    22, 23, 20, 21, 20, 8,  17, 18, 18, 18, 19, 20, 7,  14, 16, 16, 17, 17, 18,
    23, 24, 25, 26, 28, 29, 21, 19, 22, 24, 25, 26, 26, 19, 15, 21, 22, 22, 22,
    22, 18, 11, 18, 18, 18, 18, 17, 16, 9,  13, 15, 14, 13, 12, 12, 7,  8,  10,
    10, 10, 11, 9,  7,  5,  8,  9,  9,  10, 7,  11, 16, 17, 18, 19, 19, 21, 7,
    15, 16, 17, 18, 17, 20, 7,  13, 14, 14, 14, 14, 14, 7,  9,  11, 10, 10, 9,
    8,  5,  3,  6,  6,  4,  5,  6,  3,  2,  0,  2,  3,  4,  6,  4,  3,  3,  2,
    2,  3,  5,  7,  10, 12, 13, 16, 18, 20, 7,  9,  11, 12, 14, 16, 16, 7,  7,
    9,  9,  11, 13, 12, 7,  6,  7,  7,  7,  7,  6,  5,  4,  9,  9,  5,  3,  5,
    3,  5,  11, 11, 7,  2,  5,  1,  7,  11, 12, 9,  4,  4,  9,  15, 14, 10, 14,
    17, 18, 8,  15, 16, 10, 12, 14, 14, 9,  14, 18, 11, 8,  10, 11, 8,  14, 18,
    12, 7,  5,  5,  7,  13, 17, 14, 9,  4,  4,  7,  13, 16, 14, 11, 6,  3,  8,
    13, 15, 15, 12, 8,  2,  30, 33, 38, 42, 43, 38, 36, 29, 33, 37, 41, 41, 38,
    35, 28, 31, 35, 39, 40, 36, 31, 26, 29, 33, 35, 38, 33, 27, 23, 26, 28, 30,
    32, 30, 27, 19, 22, 25, 27, 31, 30, 27, 16, 19, 22, 26, 30, 29, 27, 27, 31,
    34, 39, 38, 35, 32, 26, 30, 34, 38, 37, 34, 30, 26, 29, 32, 35, 34, 31, 26,
    23, 25, 30, 32, 31, 29, 23, 20, 23, 26, 28, 26, 26, 22, 16, 19, 22, 23, 23,
    25, 23, 12, 17, 20, 23, 23, 24, 23, 25, 29, 30, 31, 34, 32, 27, 23, 27, 29,
    31, 31, 29, 25, 22, 26, 28, 28, 28, 27, 22, 18, 23, 25, 25, 25, 23, 18, 12,
    20, 21, 21, 20, 19, 18, 7,  16, 17, 17, 17, 18, 18, 6,  14, 16, 16, 16, 16,
    16, 21, 23, 24, 25, 26, 26, 20, 18, 22, 23, 23, 24, 23, 17, 14, 20, 21, 20,
    21, 21, 16, 10, 17, 17, 17, 17, 16, 14, 8,  12, 13, 13, 12, 11, 11, 7,  8,
    10, 10, 9,  10, 7,  6,  5,  8,  8,  8,  8,  5,  9,  15, 15, 17, 17, 17, 19,
    6,  13, 14, 15, 15, 14, 17, 6,  12, 12, 12, 12, 11, 12, 6,  8,  9,  9,  8,
    7,  7,  4,  2,  5,  4,  3,  4,  5,  2,  2,  2,  0,  2,  3,  4,  3,  2,  3,
    2,  2,  2,  4,  6,  9,  10, 11, 13, 16, 17, 6,  7,  9,  10, 12, 13, 14, 6,
    7,  7,  8,  9,  10, 9,  6,  6,  7,  7,  5,  6,  4,  4,  5,  9,  9,  4,  2,
    3,  2,  5,  11, 11, 6,  1,  3,  2,  6,  11, 13, 8,  3,  3,  9,  15, 14, 9,
    12, 14, 15, 9,  15, 17, 10, 10, 12, 12, 9,  15, 18, 11, 7,  9,  9,  9,  14,
    19, 12, 7,  4,  3,  7,  13, 19, 15, 8,  3,  2,  7,  13, 18, 17, 10, 5,  2,
    8,  14, 19, 18, 13, 7,  2,  29, 31, 36, 40, 40, 38, 34, 27, 30, 35, 39, 38,
    36, 32, 25, 29, 33, 37, 38, 33, 30, 24, 27, 31, 34, 36, 32, 26, 21, 24, 26,
    30, 32, 30, 25, 18, 20, 23, 27, 30, 28, 26, 16, 18, 22, 25, 29, 29, 26, 26,
    29, 33, 37, 35, 34, 30, 25, 28, 32, 35, 36, 32, 27, 22, 27, 30, 33, 33, 30,
    25, 22, 24, 26, 30, 30, 27, 21, 19, 21, 23, 26, 25, 25, 22, 16, 18, 20, 23,
    24, 24, 21, 12, 16, 19, 22, 22, 23, 21, 23, 26, 28, 29, 31, 29, 25, 22, 25,
    27, 29, 28, 27, 23, 20, 24, 26, 26, 26, 25, 20, 17, 22, 22, 22, 23, 22, 16,
    11, 18, 19, 19, 18, 18, 16, 7,  16, 17, 16, 16, 17, 16, 7,  15, 15, 15, 15,
    16, 15, 20, 21, 21, 22, 24, 24, 17, 17, 20, 20, 21, 21, 21, 15, 13, 19, 19,
    18, 18, 18, 13, 9,  16, 15, 15, 15, 14, 12, 7,  11, 11, 11, 10, 10, 9,  7,
    8,  10, 9,  9,  9,  6,  7,  5,  8,  8,  8,  8,  4,  8,  13, 14, 14, 15, 14,
    16, 5,  12, 12, 13, 13, 11, 15, 5,  10, 10, 10, 10, 9,  10, 5,  6,  7,  6,
    6,  5,  5,  3,  1,  3,  2,  2,  2,  3,  2,  1,  3,  2,  0,  2,  3,  4,  2,
    4,  2,  2,  1,  3,  4,  6,  7,  9,  10, 13, 14, 4,  5,  6,  8,  9,  10, 11,
    4,  7,  7,  6,  7,  7,  7,  4,  6,  7,  7,  3,  4,  3,  2,  5,  10, 8,  5,
    1,  2,  0,  6,  11, 11, 6,  2,  2,  3,  7,  12, 12, 8,  3,  2,  9,  12, 11,
    8,  9,  11, 12, 9,  13, 12, 9,  8,  9,  9,  9,  13, 14, 9,  6,  6,  7,  9,
    12, 14, 10, 7,  2,  2,  8,  12, 15, 13, 8,  3,  2,  8,  13, 16, 15, 10, 5,
    1,  8,  13, 16, 16, 11, 7,  2,  26, 28, 32, 36, 37, 34, 31, 24, 27, 31, 36,
    36, 33, 29, 23, 26, 29, 33, 34, 32, 27, 21, 24, 27, 31, 33, 29, 24, 18, 21,
    24, 27, 31, 27, 24, 16, 18, 22, 25, 28, 27, 24, 15, 17, 21, 23, 27, 27, 24,
    23, 27, 30, 35, 33, 31, 27, 21, 26, 29, 32, 32, 28, 25, 21, 23, 28, 30, 31,
    28, 23, 20, 22, 24, 27, 27, 25, 20, 17, 18, 21, 24, 24, 23, 20, 15, 17, 19,
    22, 22, 22, 20, 12, 16, 18, 20, 20, 21, 19, 21, 24, 25, 27, 28, 27, 22, 19,
    22, 25, 25, 26, 24, 20, 18, 21, 23, 23, 23, 22, 18, 16, 19, 20, 20, 20, 19,
    15, 10, 16, 16, 16, 16, 16, 14, 7,  15, 16, 15, 15, 15, 14, 7,  14, 14, 13,
    14, 14, 13, 18, 19, 18, 20, 21, 21, 14, 15, 17, 18, 18, 19, 18, 12, 12, 16,
    16, 16, 15, 15, 11, 8,  14, 13, 12, 12, 11, 10, 6,  10, 9,  9,  8,  8,  7,
    6,  8,  8,  7,  7,  7,  4,  7,  4,  6,  6,  6,  6,  3,  8,  10, 11, 12, 12,
    12, 13, 3,  9,  9,  10, 11, 9,  11, 3,  8,  7,  7,  7,  7,  7,  3,  4,  4,
    3,  3,  3,  3,  1,  1,  1,  1,  2,  1,  2,  2,  3,  4,  3,  2,  0,  3,  3,
    5,  5,  3,  3,  2,  2,  3,  5,  6,  7,  8,  10, 11, 3,  4,  6,  7,  7,  8,
    8,  3,  4,  4,  4,  5,  5,  6,  3,  4,  4,  3,  2,  2,  2,  2,  5,  6,  4,
    3,  2,  2,  3,  6,  8,  6,  3,  2,  1,  5,  7,  8,  7,  4,  3,  0,  5,  7,
    6,  6,  8,  9,  10, 5,  7,  7,  6,  6,  7,  7,  6,  7,  8,  4,  3,  4,  4,
    5,  7,  8,  5,  3,  2,  1,  5,  8,  9,  7,  4,  2,  0,  6,  8,  10, 9,  5,
    3,  2,  7,  9,  10, 10, 6,  4,  3,  20, 24, 29, 32, 32, 29, 25, 20, 23, 27,
    31, 31, 28, 25, 18, 21, 25, 29, 30, 25, 22, 16, 19, 22, 26, 28, 23, 20, 13,
    16, 19, 22, 26, 23, 19, 11, 14, 17, 20, 24, 23, 20, 10, 13, 16, 19, 22, 23,
    20, 18, 21, 25, 29, 28, 26, 22, 16, 20, 24, 28, 28, 24, 20, 15, 19, 23, 25,
    24, 23, 18, 14, 17, 20, 22, 22, 20, 16, 11, 13, 16, 18, 19, 18, 16, 10, 12,
    15, 17, 18, 17, 15, 7,  11, 14, 16, 16, 16, 16, 15, 19, 21, 21, 23, 21, 17,
    14, 17, 20, 21, 21, 20, 15, 13, 16, 18, 17, 18, 18, 14, 12, 14, 15, 15, 15,
    15, 11, 8,  11, 12, 12, 12, 12, 11, 5,  10, 11, 10, 10, 10, 11, 5,  8,  9,
    9,  10, 9,  9,  14, 13, 14, 14, 16, 17, 10, 11, 11, 12, 13, 13, 14, 8,  9,
    10, 11, 11, 10, 10, 7,  5,  8,  7,  7,  7,  7,  6,  4,  5,  5,  4,  4,  4,
    3,  5,  3,  3,  3,  3,  3,  3,  6,  5,  3,  2,  2,  2,  2,  4,  5,  6,  7,
    8,  9,  10, 2,  4,  5,  6,  6,  7,  8,  2,  3,  4,  4,  4,  4,  5,  2,  3,
    2,  2,  2,  1,  2,  1,  6,  4,  3,  3,  2,  2,  4,  7,  7,  5,  3,  2,  0,
    6,  8,  8,  5,  4,  3,  1,  5,  5,  5,  5,  6,  8,  9,  4,  6,  5,  5,  5,
    6,  6,  5,  7,  5,  4,  3,  3,  3,  5,  7,  7,  5,  4,  3,  0,  6,  8,  8,
    6,  4,  3,  1,  7,  9,  10, 8,  5,  3,  2,  8,  9,  11, 10, 6,  4,  2,  8,
    10, 7,  5,  6,  7,  7,  8,  9,  9,  6,  5,  5,  5,  8,  10, 10, 5,  4,  2,
    2,  8,  10, 11, 7,  5,  3,  2,  9,  10, 12, 10, 6,  4,  3,  9,  10, 14, 13,
    8,  5,  3,  9,  11, 14, 14, 9,  5,  3,  27, 30, 32, 34, 33, 31, 30, 26, 29,
    32, 33, 33, 30, 28, 25, 29, 30, 31, 31, 27, 24, 24, 25, 27, 28, 28, 23, 17,
    20, 23, 24, 23, 21, 18, 17, 17, 19, 19, 17, 19, 18, 17, 11, 13, 16, 18, 18,
    18, 17, 25, 27, 31, 32, 31, 30, 30, 24, 28, 30, 31, 31, 29, 26, 22, 25, 28,
    30, 28, 26, 23, 21, 24, 26, 26, 25, 21, 16, 18, 20, 22, 22, 17, 16, 16, 13,
    16, 17, 16, 16, 16, 16, 7,  11, 14, 16, 15, 16, 16, 22, 26, 28, 29, 30, 29,
    26, 21, 25, 27, 28, 28, 27, 24, 19, 23, 25, 26, 26, 25, 20, 18, 21, 22, 22,
    22, 20, 15, 11, 17, 18, 18, 15, 15, 14, 5,  12, 13, 13, 13, 13, 15, 4,  7,
    10, 11, 12, 13, 13, 19, 20, 22, 23, 25, 25, 22, 17, 19, 20, 22, 23, 23, 20,
    14, 18, 19, 19, 19, 18, 16, 11, 16, 15, 15, 15, 13, 13, 8,  11, 11, 10, 8,
    8,  9,  5,  5,  5,  5,  6,  7,  7,  4,  3,  2,  4,  5,  5,  7,  13, 16, 18,
    19, 20, 22, 22, 9,  15, 17, 18, 18, 19, 20, 9,  15, 15, 16, 16, 16, 14, 9,
    11, 12, 12, 11, 9,  7,  7,  6,  7,  6,  4,  3,  7,  4,  3,  4,  3,  4,  3,
    6,  0,  3,  4,  3,  4,  4,  4,  10, 11, 13, 14, 17, 20, 21, 10, 10, 12, 13,
    16, 17, 18, 10, 11, 11, 11, 12, 14, 13, 10, 10, 10, 9,  8,  7,  6,  8,  8,
    9,  8,  5,  4,  5,  5,  7,  9,  8,  5,  4,  3,  4,  5,  8,  9,  7,  5,  3,
    12, 14, 14, 13, 15, 19, 20, 12, 14, 15, 13, 13, 15, 17, 12, 14, 16, 12, 10,
    11, 11, 12, 13, 15, 11, 9,  6,  3,  10, 12, 14, 11, 7,  4,  3,  9,  10, 13,
    12, 8,  5,  4,  7,  10, 12, 13, 9,  6,  4,  34, 37, 39, 42, 42, 40, 38, 32,
    35, 39, 42, 42, 39, 36, 31, 34, 37, 39, 39, 36, 31, 29, 32, 34, 37, 36, 31,
    25, 26, 29, 30, 31, 30, 27, 25, 22, 24, 25, 25, 28, 27, 25, 16, 19, 21, 25,
    27, 27, 25, 30, 34, 38, 41, 40, 37, 35, 29, 33, 37, 39, 40, 36, 33, 27, 32,
    35, 37, 36, 33, 30, 26, 29, 33, 34, 32, 28, 23, 23, 26, 28, 29, 27, 24, 23,
    17, 21, 23, 22, 24, 24, 23, 11, 16, 20, 22, 23, 24, 23, 27, 31, 34, 35, 36,
    35, 30, 26, 29, 33, 34, 35, 33, 29, 23, 29, 31, 31, 31, 30, 25, 21, 26, 27,
    28, 27, 25, 20, 15, 22, 24, 23, 20, 20, 20, 9,  18, 18, 17, 17, 18, 20, 6,
    13, 15, 15, 16, 17, 18, 25, 26, 27, 28, 30, 31, 25, 20, 24, 26, 27, 27, 27,
    23, 17, 23, 24, 24, 24, 23, 21, 13, 20, 20, 20, 20, 18, 17, 11, 14, 15, 15,
    12, 12, 13, 8,  8,  11, 9,  10, 11, 10, 6,  4,  7,  7,  8,  9,  9,  13, 19,
    20, 22, 22, 24, 25, 10, 19, 19, 21, 21, 21, 22, 10, 17, 18, 18, 18, 17, 17,
    10, 12, 15, 14, 13, 11, 9,  7,  6,  10, 9,  5,  6,  7,  4,  3,  3,  2,  2,
    5,  8,  3,  0,  3,  2,  2,  3,  7,  10, 14, 15, 17, 20, 22, 24, 10, 12, 14,
    16, 18, 19, 20, 10, 10, 12, 12, 15, 16, 14, 10, 9,  8,  9,  10, 9,  7,  8,
    7,  7,  6,  4,  3,  7,  5,  5,  7,  5,  4,  2,  6,  2,  4,  6,  6,  4,  3,
    5,  10, 13, 13, 13, 17, 21, 22, 10, 13, 13, 12, 16, 18, 19, 10, 13, 14, 11,
    11, 13, 13, 10, 12, 13, 10, 8,  7,  6,  8,  10, 11, 9,  5,  3,  5,  7,  8,
    9,  8,  5,  3,  3,  5,  7,  9,  9,  6,  4,  2,  36, 39, 42, 47, 46, 43, 40,
    33, 38, 41, 46, 46, 42, 38, 33, 35, 40, 43, 43, 39, 35, 31, 33, 37, 39, 41,
    36, 31, 27, 30, 34, 35, 35, 32, 30, 23, 26, 28, 30, 33, 33, 30, 19, 22, 26,
    29, 32, 32, 30, 32, 36, 41, 44, 42, 41, 38, 31, 34, 39, 42, 42, 39, 35, 29,
    34, 37, 39, 40, 38, 32, 28, 31, 35, 36, 36, 32, 26, 23, 27, 30, 32, 30, 29,
    26, 18, 23, 26, 27, 27, 27, 27, 13, 20, 23, 26, 26, 26, 26, 30, 34, 35, 37,
    38, 38, 32, 27, 31, 35, 36, 36, 35, 30, 25, 30, 34, 34, 33, 32, 27, 21, 28,
    29, 29, 29, 28, 22, 15, 24, 26, 25, 23, 23, 22, 9,  20, 21, 20, 20, 21, 22,
    8,  17, 18, 19, 19, 20, 20, 25, 28, 29, 31, 31, 32, 26, 20, 26, 28, 29, 29,
    29, 23, 17, 24, 25, 26, 25, 25, 21, 14, 21, 22, 21, 22, 20, 18, 11, 15, 18,
    18, 15, 14, 14, 9,  10, 13, 13, 13, 13, 11, 8,  5,  10, 10, 11, 12, 8,  13,
    20, 20, 22, 23, 22, 25, 10, 18, 19, 21, 21, 20, 23, 9,  16, 18, 17, 17, 17,
    17, 10, 11, 14, 13, 13, 10, 10, 7,  5,  10, 9,  6,  7,  8,  5,  3,  3,  3,
    3,  5,  8,  4,  3,  0,  2,  3,  5,  7,  8,  14, 15, 17, 19, 22, 23, 9,  12,
    14, 15, 17, 19, 19, 9,  9,  12, 12, 14, 15, 14, 9,  8,  8,  8,  10, 9,  7,
    6,  5,  7,  7,  3,  5,  7,  4,  3,  8,  7,  5,  4,  7,  2,  4,  8,  8,  6,
    2,  5,  9,  12, 12, 13, 17, 20, 21, 9,  12, 14, 11, 15, 17, 18, 9,  12, 15,
    9,  11, 13, 13, 9,  11, 14, 10, 7,  7,  6,  7,  10, 13, 11, 6,  2,  5,  5,
    10, 11, 10, 7,  4,  4,  5,  8,  10, 10, 8,  6,  3,  32, 36, 39, 43, 44, 41,
    38, 31, 35, 38, 43, 44, 39, 35, 29, 33, 37, 40, 40, 38, 33, 28, 30, 34, 37,
    38, 34, 29, 25, 28, 30, 33, 35, 31, 29, 22, 24, 26, 29, 32, 31, 28, 18, 21,
    24, 28, 31, 32, 29, 29, 34, 38, 40, 41, 37, 34, 28, 32, 35, 39, 39, 36, 31,
    27, 30, 35, 38, 37, 33, 29, 25, 28, 31, 34, 33, 31, 24, 21, 25, 27, 29, 28,
    27, 24, 17, 21, 23, 25, 26, 27, 24, 13, 18, 22, 24, 24, 25, 25, 27, 30, 33,
    34, 35, 33, 29, 25, 29, 31, 33, 34, 32, 27, 23, 28, 30, 30, 30, 29, 24, 19,
    25, 25, 26, 26, 26, 20, 13, 21, 22, 23, 21, 20, 19, 8,  17, 19, 19, 19, 19,
    19, 7,  16, 17, 18, 18, 19, 18, 23, 25, 26, 27, 29, 28, 21, 18, 23, 24, 26,
    26, 25, 19, 15, 22, 23, 22, 22, 21, 18, 12, 19, 19, 19, 18, 17, 16, 9,  13,
    15, 15, 13, 12, 12, 8,  9,  11, 11, 11, 11, 9,  8,  5,  10, 9,  10, 10, 6,
    11, 16, 18, 19, 20, 18, 21, 7,  15, 16, 17, 17, 16, 19, 7,  12, 14, 14, 13,
    13, 14, 7,  8,  11, 10, 10, 7,  8,  5,  2,  6,  6,  4,  4,  6,  3,  2,  2,
    2,  2,  3,  5,  3,  2,  2,  0,  2,  3,  4,  6,  10, 11, 13, 15, 16, 19, 6,
    9,  10, 11, 13, 14, 15, 6,  7,  8,  9,  10, 11, 10, 6,  5,  6,  5,  6,  7,
    5,  4,  3,  7,  7,  3,  3,  4,  2,  3,  10, 10, 5,  2,  4,  1,  4,  10, 12,
    7,  2,  3,  7,  13, 12, 10, 13, 16, 16, 7,  13, 15, 9,  11, 13, 13, 7,  13,
    17, 10, 8,  10, 10, 7,  12, 17, 11, 5,  5,  4,  6,  11, 17, 13, 7,  2,  3,
    5,  12, 17, 16, 9,  4,  3,  6,  12, 17, 17, 11, 6,  2,  30, 35, 39, 42, 42,
    39, 36, 29, 34, 38, 41, 42, 38, 34, 28, 31, 36, 39, 41, 36, 33, 27, 28, 32,
    36, 38, 33, 28, 24, 25, 29, 33, 34, 31, 28, 20, 22, 26, 28, 32, 31, 28, 18,
    20, 24, 27, 30, 31, 28, 28, 31, 35, 40, 39, 35, 32, 26, 30, 34, 38, 39, 34,
    30, 25, 28, 32, 36, 36, 32, 27, 24, 26, 29, 33, 33, 30, 23, 20, 23, 26, 28,
    28, 26, 23, 16, 20, 23, 25, 26, 26, 24, 13, 19, 21, 24, 24, 24, 23, 25, 29,
    30, 32, 33, 31, 27, 23, 27, 29, 31, 30, 30, 25, 21, 26, 28, 29, 28, 27, 22,
    18, 25, 25, 25, 25, 24, 18, 12, 20, 22, 21, 21, 19, 18, 8,  18, 18, 19, 19,
    18, 18, 8,  16, 18, 17, 18, 18, 16, 20, 24, 24, 25, 26, 25, 19, 17, 22, 22,
    23, 24, 22, 17, 14, 20, 21, 20, 20, 20, 15, 11, 17, 17, 17, 17, 16, 14, 8,
    12, 14, 14, 13, 12, 11, 7,  9,  11, 11, 11, 11, 7,  7,  6,  10, 9,  9,  10,
    5,  9,  15, 16, 17, 18, 15, 18, 6,  14, 15, 15, 16, 13, 16, 6,  11, 12, 12,
    12, 10, 12, 6,  6,  9,  9,  8,  6,  7,  4,  2,  5,  4,  4,  3,  4,  3,  2,
    2,  2,  2,  2,  4,  4,  2,  3,  2,  0,  2,  3,  5,  8,  9,  10, 12, 14, 16,
    5,  6,  8,  9,  11, 11, 12, 5,  5,  6,  6,  8,  9,  8,  4,  4,  6,  5,  4,
    5,  4,  2,  4,  7,  7,  3,  2,  3,  2,  4,  10, 9,  4,  1,  3,  2,  5,  10,
    11, 6,  2,  2,  7,  11, 10, 7,  11, 13, 14, 7,  11, 11, 8,  9,  11, 11, 7,
    11, 13, 8,  6,  7,  8,  7,  11, 13, 9,  5,  3,  3,  6,  10, 14, 12, 7,  2,
    3,  6,  11, 15, 14, 8,  3,  2,  7,  12, 15, 15, 10, 5,  1,  27, 31, 36, 39,
    39, 36, 33, 27, 30, 34, 38, 39, 36, 32, 24, 27, 34, 36, 37, 33, 30, 24, 26,
    29, 32, 36, 32, 26, 21, 23, 26, 29, 32, 29, 26, 18, 20, 23, 26, 30, 29, 26,
    17, 19, 22, 25, 28, 29, 26, 24, 28, 32, 37, 35, 33, 29, 24, 27, 32, 34, 36,
    30, 27, 23, 26, 29, 32, 31, 30, 25, 22, 23, 27, 29, 29, 27, 22, 18, 20, 23,
    26, 25, 24, 21, 16, 18, 20, 23, 23, 24, 22, 12, 17, 20, 22, 22, 23, 21, 23,
    26, 28, 29, 30, 28, 23, 21, 25, 27, 28, 28, 27, 22, 20, 23, 26, 25, 26, 25,
    20, 17, 22, 21, 21, 21, 21, 16, 11, 18, 18, 18, 18, 18, 16, 8,  16, 17, 16,
    17, 16, 16, 8,  15, 15, 15, 15, 15, 14, 20, 21, 21, 22, 23, 23, 15, 16, 19,
    20, 20, 21, 19, 14, 13, 18, 18, 18, 17, 17, 12, 9,  15, 14, 14, 13, 13, 12,
    7,  11, 11, 10, 10, 10, 8,  7,  9,  10, 9,  9,  9,  5,  8,  5,  8,  8,  8,
    8,  3,  8,  12, 13, 14, 14, 13, 15, 4,  11, 12, 12, 12, 10, 13, 4,  9,  9,
    9,  9,  8,  9,  4,  5,  6,  5,  5,  4,  5,  3,  2,  2,  2,  2,  2,  3,  3,
    2,  3,  2,  1,  2,  3,  4,  3,  5,  3,  2,  0,  3,  3,  6,  7,  8,  9,  11,
    13, 3,  5,  7,  8,  8,  9,  10, 3,  4,  5,  5,  6,  6,  6,  3,  3,  3,  2,
    2,  3,  3,  1,  4,  6,  4,  3,  0,  3,  2,  6,  8,  5,  4,  2,  2,  4,  7,
    8,  7,  4,  2,  2,  4,  6,  6,  7,  9,  10, 11, 4,  6,  7,  6,  7,  8,  8,
    4,  6,  7,  4,  4,  4,  6,  4,  6,  8,  4,  2,  1,  2,  3,  8,  9,  7,  4,
    2,  2,  6,  9,  9,  9,  5,  3,  0,  7,  9,  9,  9,  6,  4,  2,  22, 26, 29,
    33, 33, 30, 27, 21, 24, 29, 33, 32, 29, 26, 19, 23, 27, 30, 32, 28, 24, 18,
    21, 24, 27, 30, 26, 21, 15, 17, 21, 24, 27, 24, 21, 13, 15, 18, 22, 25, 25,
    21, 12, 15, 18, 20, 24, 24, 21, 20, 23, 27, 31, 29, 26, 23, 18, 22, 26, 29,
    29, 26, 21, 17, 20, 24, 27, 27, 24, 20, 16, 18, 21, 24, 23, 22, 17, 13, 15,
    17, 20, 20, 20, 17, 12, 13, 16, 18, 19, 19, 16, 9,  12, 16, 18, 17, 18, 17,
    18, 20, 23, 24, 25, 23, 19, 17, 19, 21, 22, 22, 21, 17, 15, 18, 20, 20, 20,
    19, 15, 14, 16, 16, 16, 16, 16, 12, 9,  13, 14, 13, 13, 13, 12, 6,  12, 13,
    12, 12, 12, 12, 6,  10, 10, 11, 11, 11, 10, 15, 15, 16, 17, 18, 18, 11, 14,
    14, 14, 15, 15, 15, 9,  11, 12, 13, 12, 12, 11, 8,  6,  11, 9,  9,  9,  9,
    7,  4,  7,  6,  6,  5,  5,  4,  5,  5,  5,  5,  4,  4,  2,  6,  4,  3,  3,
    3,  3,  2,  6,  7,  7,  8,  9,  10, 11, 2,  5,  6,  7,  7,  8,  9,  2,  4,
    5,  4,  5,  5,  5,  2,  2,  2,  2,  1,  2,  2,  1,  4,  3,  3,  2,  1,  2,
    3,  5,  5,  3,  3,  2,  1,  4,  7,  6,  4,  3,  3,  0,  4,  4,  5,  6,  7,
    8,  10, 3,  5,  5,  6,  6,  6,  7,  4,  6,  5,  4,  4,  3,  4,  4,  6,  5,
    4,  3,  2,  1,  4,  7,  8,  5,  4,  3,  0,  5,  7,  9,  7,  4,  3,  2,  6,
    8,  9,  8,  5,  3,  2,  7,  9,  7,  5,  6,  8,  8,  7,  9,  8,  5,  5,  5,
    5,  7,  9,  9,  5,  3,  2,  3,  7,  8,  11, 6,  4,  3,  1,  8,  9,  11, 9,
    5,  3,  2,  8,  9,  11, 11, 6,  4,  2,  8,  10, 12, 12, 8,  5,  3,  24, 27,
    29, 32, 31, 29, 26, 23, 26, 28, 30, 32, 29, 25, 22, 24, 27, 29, 31, 29, 25,
    21, 23, 26, 28, 31, 28, 27, 20, 23, 25, 28, 31, 29, 26, 19, 23, 25, 27, 30,
    29, 27, 16, 20, 23, 26, 29, 28, 27, 22, 24, 27, 30, 28, 25, 24, 21, 24, 26,
    29, 28, 26, 24, 19, 22, 25, 28, 27, 25, 24, 18, 22, 24, 27, 26, 25, 23, 18,
    21, 24, 27, 26, 26, 24, 16, 19, 22, 24, 25, 25, 24, 13, 16, 21, 24, 25, 24,
    24, 19, 22, 23, 24, 24, 23, 19, 18, 20, 23, 23, 24, 23, 19, 17, 20, 22, 22,
    22, 23, 19, 16, 19, 21, 21, 22, 23, 20, 14, 18, 19, 20, 21, 22, 19, 11, 16,
    18, 19, 19, 20, 20, 13, 14, 16, 17, 19, 19, 18, 17, 18, 17, 18, 18, 17, 8,
    15, 15, 16, 16, 17, 16, 9,  13, 14, 15, 15, 15, 15, 10, 9,  14, 14, 14, 15,
    15, 11, 9,  12, 12, 13, 13, 14, 8,  10, 10, 10, 11, 11, 12, 6,  13, 13, 10,
    9,  10, 10, 6,  8,  9,  9,  9,  10, 6,  8,  4,  7,  7,  8,  8,  6,  9,  4,
    6,  5,  6,  6,  5,  7,  4,  4,  4,  4,  5,  5,  7,  5,  4,  4,  4,  4,  3,
    6,  7,  7,  7,  6,  4,  3,  4,  10, 10, 8,  6,  5,  3,  4,  0,  2,  2,  2,
    2,  5,  7,  0,  3,  2,  2,  1,  4,  8,  0,  4,  3,  2,  1,  3,  6,  0,  3,
    3,  2,  1,  2,  5,  2,  3,  5,  5,  3,  3,  4,  5,  6,  9,  8,  5,  3,  3,
    8,  9,  10, 9,  6,  4,  3,  4,  7,  6,  3,  2,  3,  6,  4,  7,  7,  4,  2,
    2,  5,  4,  7,  9,  4,  2,  0,  5,  4,  7,  10, 6,  3,  2,  3,  4,  7,  11,
    9,  5,  3,  3,  5,  9,  12, 11, 7,  4,  3,  7,  11, 12, 13, 8,  5,  3,  25,
    29, 32, 33, 34, 31, 29, 25, 27, 31, 34, 34, 32, 29, 23, 26, 29, 32, 34, 31,
    29, 21, 24, 28, 32, 34, 33, 30, 21, 24, 28, 32, 35, 33, 30, 20, 23, 27, 31,
    34, 33, 30, 18, 23, 25, 30, 33, 33, 31, 23, 25, 29, 31, 30, 27, 25, 21, 25,
    28, 31, 30, 27, 25, 21, 24, 27, 30, 29, 27, 25, 19, 22, 27, 28, 29, 29, 25,
    20, 22, 26, 29, 29, 28, 26, 19, 21, 24, 28, 28, 28, 25, 15, 19, 23, 27, 27,
    27, 26, 21, 25, 25, 26, 26, 24, 19, 19, 22, 25, 24, 25, 24, 19, 18, 22, 23,
    23, 24, 24, 20, 17, 21, 22, 23, 23, 23, 20, 14, 20, 22, 21, 22, 22, 21, 12,
    18, 20, 21, 21, 22, 20, 13, 16, 18, 19, 20, 20, 18, 19, 19, 19, 19, 19, 18,
    7,  16, 17, 18, 17, 18, 16, 9,  13, 16, 16, 17, 16, 15, 10, 10, 16, 16, 15,
    16, 15, 12, 11, 14, 15, 15, 14, 14, 9,  11, 12, 13, 13, 13, 13, 6,  14, 14,
    10, 11, 12, 12, 6,  8,  10, 10, 11, 10, 6,  7,  5,  9,  9,  9,  9,  6,  9,
    5,  8,  7,  7,  7,  5,  6,  5,  6,  6,  6,  7,  4,  6,  6,  5,  5,  5,  5,
    4,  6,  8,  9,  10, 9,  6,  5,  5,  11, 14, 14, 11, 8,  6,  4,  2,  0,  1,
    1,  3,  5,  6,  2,  2,  2,  2,  2,  4,  6,  2,  4,  4,  4,  1,  4,  7,  2,
    5,  7,  7,  4,  3,  5,  3,  7,  12, 11, 9,  6,  4,  6,  12, 16, 13, 11, 7,
    4,  12, 16, 16, 14, 12, 8,  5,  6,  11, 11, 6,  1,  3,  5,  6,  12, 12, 8,
    2,  3,  5,  6,  11, 13, 9,  4,  2,  5,  6,  12, 14, 12, 8,  4,  4,  8,  13,
    16, 15, 12, 8,  5,  10, 15, 17, 16, 13, 10, 6,  14, 17, 18, 17, 14, 11, 7,
    24, 27, 31, 33, 34, 31, 28, 23, 27, 29, 33, 34, 31, 28, 22, 25, 29, 32, 33,
    31, 28, 21, 25, 28, 31, 35, 32, 29, 22, 24, 28, 31, 35, 33, 30, 21, 24, 26,
    30, 34, 33, 29, 18, 21, 25, 29, 33, 33, 30, 21, 24, 28, 31, 29, 26, 24, 21,
    24, 27, 30, 30, 26, 23, 20, 23, 26, 28, 30, 27, 25, 19, 22, 26, 29, 29, 28,
    24, 20, 22, 26, 28, 28, 28, 25, 18, 21, 24, 27, 28, 27, 25, 16, 19, 23, 26,
    26, 27, 24, 20, 23, 24, 24, 24, 22, 17, 19, 21, 23, 24, 23, 22, 17, 18, 21,
    22, 23, 23, 21, 18, 16, 21, 22, 22, 23, 22, 18, 14, 20, 22, 22, 22, 22, 18,
    12, 18, 20, 20, 21, 21, 19, 15, 17, 19, 19, 19, 19, 17, 18, 17, 17, 17, 18,
    15, 6,  16, 16, 16, 16, 17, 14, 7,  12, 15, 16, 15, 15, 14, 9,  9,  16, 15,
    15, 15, 14, 12, 10, 14, 14, 15, 14, 13, 9,  12, 12, 12, 13, 13, 12, 6,  15,
    16, 11, 11, 12, 11, 5,  8,  10, 10, 10, 9,  4,  6,  4,  9,  8,  8,  8,  4,
    7,  4,  8,  7,  7,  7,  4,  6,  4,  6,  7,  6,  7,  4,  5,  6,  6,  6,  6,
    6,  5,  5,  8,  10, 12, 10, 7,  6,  5,  12, 16, 15, 12, 9,  7,  5,  2,  1,
    0,  1,  2,  3,  4,  2,  2,  2,  2,  2,  3,  4,  2,  4,  4,  4,  1,  3,  5,
    2,  6,  8,  8,  5,  4,  5,  4,  8,  13, 13, 9,  7,  5,  8,  13, 19, 18, 12,
    8,  5,  13, 18, 20, 19, 14, 9,  6,  6,  12, 11, 5,  1,  2,  4,  6,  12, 13,
    7,  1,  2,  4,  6,  12, 15, 9,  5,  2,  4,  6,  13, 18, 13, 9,  6,  5,  9,
    15, 21, 19, 13, 9,  6,  12, 18, 24, 23, 16, 10, 7,  16, 21, 25, 25, 18, 12,
    8,  24, 27, 30, 33, 33, 31, 26, 23, 26, 30, 33, 33, 31, 27, 21, 24, 28, 32,
    33, 31, 28, 21, 24, 29, 32, 35, 32, 29, 21, 24, 28, 31, 35, 33, 30, 20, 23,
    27, 30, 34, 32, 28, 19, 21, 26, 29, 33, 33, 29, 21, 25, 27, 31, 28, 26, 22,
    21, 23, 27, 30, 28, 26, 23, 19, 22, 26, 28, 29, 28, 23, 19, 23, 26, 29, 29,
    28, 24, 20, 23, 25, 28, 29, 28, 25, 18, 22, 24, 28, 28, 27, 25, 16, 19, 23,
    27, 27, 26, 24, 20, 23, 23, 24, 23, 21, 16, 19, 21, 23, 23, 23, 21, 16, 18,
    20, 22, 22, 22, 22, 17, 16, 21, 22, 22, 22, 22, 18, 15, 20, 22, 22, 22, 21,
    17, 13, 19, 20, 20, 21, 20, 18, 16, 18, 19, 19, 19, 19, 17, 18, 17, 17, 17,
    17, 14, 5,  16, 17, 16, 16, 15, 13, 6,  13, 15, 16, 15, 15, 13, 9,  9,  16,
    15, 15, 15, 13, 12, 11, 15, 14, 15, 14, 13, 8,  12, 13, 13, 13, 13, 12, 6,
    16, 17, 13, 11, 12, 11, 5,  8,  10, 10, 9,  8,  3,  5,  5,  9,  8,  8,  7,
    3,  6,  5,  8,  7,  7,  7,  3,  5,  5,  6,  7,  7,  7,  4,  5,  6,  6,  7,
    7,  7,  7,  5,  9,  12, 13, 11, 9,  7,  5,  14, 17, 17, 13, 10, 8,  6,  2,
    1,  1,  0,  2,  3,  4,  2,  3,  2,  2,  2,  3,  3,  2,  4,  4,  5,  2,  3,
    4,  2,  6,  9,  9,  6,  5,  5,  4,  9,  14, 13, 10, 8,  6,  9,  14, 20, 18,
    12, 9,  7,  15, 19, 21, 20, 15, 10, 7,  6,  9,  7,  4,  0,  2,  3,  6,  9,
    8,  5,  2,  2,  3,  6,  9,  10, 8,  5,  3,  4,  6,  11, 15, 12, 9,  7,  6,
    10, 14, 19, 18, 14, 10, 8,  13, 19, 23, 23, 16, 11, 8,  18, 22, 24, 24, 19,
    13, 9,  20, 23, 27, 30, 30, 28, 24, 19, 23, 26, 29, 29, 27, 24, 18, 21, 25,
    28, 31, 29, 26, 17, 21, 25, 28, 31, 29, 26, 18, 22, 24, 28, 32, 29, 26, 18,
    21, 24, 27, 32, 29, 25, 16, 19, 23, 26, 29, 29, 26, 18, 21, 24, 27, 27, 22,
    19, 18, 20, 23, 26, 26, 23, 20, 17, 19, 22, 26, 26, 24, 21, 16, 19, 23, 26,
    26, 25, 22, 17, 20, 23, 26, 25, 25, 21, 15, 18, 22, 24, 24, 24, 21, 17, 18,
    20, 23, 23, 23, 21, 17, 19, 19, 20, 21, 17, 13, 16, 18, 19, 19, 19, 18, 14,
    15, 18, 19, 20, 20, 19, 14, 15, 18, 20, 19, 20, 19, 15, 13, 17, 19, 18, 19,
    19, 16, 12, 16, 17, 18, 17, 18, 15, 19, 19, 16, 16, 17, 16, 15, 15, 14, 13,
    14, 14, 12, 3,  14, 13, 13, 13, 12, 11, 4,  11, 12, 12, 13, 12, 11, 7,  8,
    13, 13, 12, 12, 12, 9,  9,  12, 12, 11, 11, 10, 7,  12, 14, 12, 11, 10, 10,
    5,  19, 20, 15, 12, 9,  9,  6,  7,  6,  6,  6,  5,  2,  3,  3,  5,  5,  4,
    4,  3,  4,  3,  4,  3,  4,  4,  3,  4,  3,  3,  4,  5,  5,  5,  5,  5,  9,
    9,  9,  9,  8,  6,  10, 15, 16, 13, 10, 8,  6,  17, 20, 19, 15, 12, 9,  7,
    2,  3,  2,  2,  0,  2,  3,  2,  4,  3,  2,  2,  2,  3,  2,  6,  4,  4,  4,
    3,  4,  2,  7,  8,  8,  7,  6,  6,  7,  12, 14, 13, 12, 9,  7,  12, 16, 20,
    18, 13, 10, 8,  18, 21, 22, 19, 15, 11, 8,  7,  9,  5,  3,  2,  1,  2,  7,
    9,  7,  3,  2,  2,  3,  7,  9,  9,  6,  5,  5,  4,  7,  9,  13, 11, 9,  8,
    8,  9,  14, 17, 17, 14, 11, 8,  15, 18, 21, 22, 16, 13, 9,  19, 23, 23, 23,
    18, 14, 10, 16, 20, 23, 26, 25, 23, 20, 15, 18, 21, 25, 25, 24, 20, 14, 17,
    21, 25, 26, 24, 21, 14, 18, 21, 24, 28, 25, 22, 14, 18, 20, 25, 28, 26, 22,
    13, 17, 20, 23, 27, 26, 23, 17, 17, 19, 22, 25, 26, 22, 14, 17, 20, 23, 22,
    19, 15, 14, 16, 19, 22, 22, 20, 17, 12, 15, 18, 22, 22, 20, 17, 12, 15, 19,
    22, 22, 21, 18, 12, 16, 18, 21, 22, 21, 18, 12, 15, 18, 21, 21, 20, 18, 19,
    18, 17, 19, 19, 20, 18, 13, 15, 16, 16, 17, 14, 11, 12, 14, 15, 15, 16, 15,
    11, 11, 13, 14, 16, 16, 16, 12, 11, 13, 15, 15, 15, 15, 13, 9,  13, 15, 14,
    15, 15, 13, 14, 15, 14, 14, 14, 14, 13, 22, 20, 17, 13, 13, 13, 12, 11, 10,
    9,  9,  9,  9,  2,  10, 9,  9,  8,  9,  8,  3,  8,  8,  8,  9,  9,  9,  4,
    6,  8,  8,  9,  9,  8,  7,  7,  8,  9,  9,  9,  8,  6,  14, 16, 14, 13, 10,
    8,  7,  21, 23, 18, 13, 11, 9,  7,  2,  2,  2,  2,  2,  2,  2,  2,  1,  1,
    1,  1,  2,  3,  2,  2,  2,  3,  4,  3,  4,  2,  5,  6,  7,  7,  7,  7,  6,
    11, 12, 11, 11, 9,  7,  13, 18, 19, 15, 13, 10, 8,  20, 22, 21, 17, 14, 11,
    9,  5,  5,  3,  3,  2,  0,  2,  5,  6,  4,  3,  2,  2,  3,  5,  8,  6,  6,
    5,  5,  4,  5,  9,  11, 10, 9,  9,  8,  9,  14, 17, 15, 14, 12, 8,  15, 19,
    23, 20, 15, 12, 10, 21, 23, 24, 21, 17, 13, 10, 9,  11, 7,  4,  3,  2,  1,
    9,  11, 9,  5,  3,  3,  3,  9,  11, 11, 8,  7,  6,  6,  9,  12, 15, 13, 11,
    10, 10, 12, 16, 20, 19, 16, 13, 11, 17, 21, 24, 24, 19, 15, 11, 21, 24, 25,
    25, 20, 16, 12, 12, 15, 18, 20, 20, 17, 15, 11, 14, 17, 20, 20, 18, 16, 10,
    13, 16, 20, 21, 20, 17, 10, 13, 17, 20, 23, 20, 18, 10, 14, 16, 20, 24, 21,
    18, 11, 13, 16, 19, 23, 22, 18, 18, 17, 16, 18, 21, 22, 18, 11, 13, 16, 18,
    17, 14, 11, 9,  12, 15, 17, 16, 15, 13, 8,  11, 15, 18, 17, 16, 14, 7,  11,
    15, 18, 17, 17, 14, 8,  11, 14, 17, 17, 16, 14, 12, 14, 15, 16, 16, 16, 14,
    20, 19, 17, 16, 15, 15, 14, 8,  11, 12, 12, 12, 10, 7,  7,  10, 11, 11, 11,
    10, 7,  7,  9,  10, 11, 11, 11, 8,  6,  9,  11, 11, 11, 11, 9,  7,  10, 11,
    11, 11, 11, 9,  16, 16, 15, 13, 11, 9,  9,  22, 21, 17, 14, 11, 9,  8,  6,
    6,  5,  5,  5,  6,  1,  6,  5,  4,  4,  4,  4,  2,  5,  3,  4,  5,  4,  4,
    3,  8,  3,  5,  6,  6,  6,  6,  8,  9,  9,  10, 10, 9,  7,  16, 17, 15, 14,
    11, 9,  7,  23, 24, 18, 15, 12, 10, 8,  3,  2,  2,  2,  2,  1,  1,  5,  3,
    2,  2,  2,  2,  2,  4,  4,  3,  4,  5,  5,  4,  5,  7,  7,  8,  9,  8,  7,
    8,  13, 13, 13, 12, 11, 8,  15, 19, 20, 17, 14, 12, 9,  22, 24, 23, 18, 16,
    13, 10, 7,  6,  4,  3,  3,  2,  0,  7,  8,  5,  4,  3,  3,  3,  7,  10, 7,
    8,  7,  6,  6,  7,  11, 13, 13, 11, 10, 9,  11, 16, 20, 19, 16, 13, 10, 17,
    21, 26, 24, 19, 14, 11, 22, 25, 28, 25, 21, 16, 12, 10, 13, 10, 6,  3,  2,
    2,  11, 13, 12, 7,  4,  4,  4,  11, 13, 16, 11, 9,  8,  7,  11, 15, 21, 17,
    14, 12, 11, 14, 21, 24, 24, 20, 16, 12, 19, 24, 30, 30, 22, 17, 13, 25, 29,
    31, 30, 25, 19, 14, 23, 27, 29, 32, 32, 30, 27, 22, 25, 28, 31, 31, 29, 26,
    21, 24, 27, 29, 31, 28, 26, 20, 23, 26, 29, 30, 29, 27, 20, 23, 26, 28, 30,
    29, 26, 19, 21, 25, 27, 30, 28, 27, 16, 20, 23, 27, 29, 28, 27, 22, 24, 27,
    29, 29, 26, 24, 20, 24, 27, 28, 28, 26, 24, 20, 22, 26, 28, 26, 25, 22, 18,
    22, 24, 27, 26, 26, 24, 18, 21, 24, 26, 26, 26, 24, 16, 19, 22, 24, 25, 25,
    24, 13, 17, 21, 24, 24, 24, 24, 19, 22, 23, 25, 25, 23, 20, 18, 21, 22, 23,
    23, 23, 19, 17, 20, 22, 22, 22, 22, 19, 15, 19, 21, 21, 22, 22, 20, 14, 18,
    20, 20, 21, 21, 20, 11, 16, 18, 18, 19, 20, 20, 13, 14, 16, 17, 18, 19, 19,
    17, 17, 17, 18, 18, 18, 8,  15, 15, 16, 16, 17, 16, 9,  13, 15, 15, 15, 16,
    15, 9,  9,  13, 14, 14, 14, 14, 12, 9,  12, 13, 13, 13, 13, 8,  10, 10, 10,
    11, 12, 12, 6,  13, 13, 9,  9,  10, 10, 6,  7,  9,  9,  9,  10, 6,  7,  4,
    7,  8,  8,  8,  6,  9,  4,  6,  6,  6,  6,  5,  7,  4,  4,  4,  4,  5,  4,
    7,  5,  4,  4,  4,  4,  3,  6,  7,  7,  7,  6,  4,  3,  5,  10, 10, 8,  6,
    5,  3,  3,  0,  2,  2,  2,  2,  5,  7,  0,  3,  2,  2,  2,  4,  8,  0,  4,
    3,  2,  1,  3,  6,  0,  3,  3,  2,  1,  2,  5,  2,  3,  5,  5,  3,  3,  3,
    5,  6,  9,  8,  5,  3,  3,  8,  8,  10, 9,  6,  4,  3,  4,  7,  6,  3,  2,
    3,  6,  4,  7,  7,  4,  2,  2,  5,  4,  7,  9,  4,  2,  0,  4,  4,  7,  10,
    5,  3,  2,  3,  4,  7,  11, 9,  5,  3,  3,  5,  9,  12, 11, 7,  4,  3,  7,
    11, 12, 12, 8,  5,  3,  28, 31, 34, 36, 36, 33, 31, 26, 29, 33, 36, 37, 35,
    32, 25, 29, 32, 35, 37, 34, 31, 24, 27, 31, 34, 36, 34, 32, 24, 27, 31, 34,
    37, 36, 31, 23, 25, 30, 33, 36, 35, 32, 20, 24, 28, 32, 35, 35, 32, 25, 29,
    32, 34, 34, 31, 27, 24, 27, 30, 33, 32, 30, 27, 22, 26, 29, 32, 32, 30, 28,
    22, 25, 29, 32, 32, 31, 28, 23, 24, 28, 32, 31, 31, 28, 20, 24, 27, 30, 30,
    31, 29, 17, 20, 25, 29, 29, 29, 28, 23, 26, 27, 28, 28, 26, 21, 22, 25, 27,
    26, 27, 25, 21, 21, 24, 25, 26, 25, 27, 22, 18, 23, 26, 24, 26, 25, 22, 16,
    22, 24, 24, 25, 24, 23, 13, 20, 22, 23, 23, 24, 22, 14, 17, 20, 22, 22, 23,
    21, 20, 20, 21, 22, 22, 19, 10, 18, 19, 20, 20, 21, 19, 11, 15, 18, 18, 18,
    19, 17, 12, 11, 18, 18, 18, 18, 17, 14, 12, 16, 17, 17, 17, 16, 11, 12, 14,
    14, 15, 15, 15, 8,  14, 13, 12, 13, 14, 13, 8,  10, 12, 13, 13, 12, 7,  10,
    6,  11, 11, 11, 11, 7,  10, 6,  10, 9,  9,  9,  7,  9,  6,  8,  8,  8,  9,
    6,  7,  7,  5,  7,  7,  7,  4,  7,  8,  7,  9,  8,  5,  4,  6,  10, 12, 12,
    9,  7,  5,  5,  3,  2,  2,  3,  4,  6,  8,  3,  0,  1,  1,  3,  7,  8,  3,
    2,  2,  2,  2,  5,  8,  3,  3,  5,  5,  2,  3,  6,  4,  5,  8,  7,  7,  5,
    5,  5,  9,  11, 9,  8,  6,  4,  11, 13, 12, 10, 8,  7,  4,  4,  8,  7,  4,
    3,  4,  7,  4,  8,  7,  5,  2,  4,  7,  4,  7,  9,  6,  2,  4,  6,  4,  8,
    10, 7,  6,  4,  4,  6,  9,  10, 9,  8,  7,  4,  8,  10, 12, 12, 9,  7,  5,
    11, 12, 13, 13, 10, 8,  6,  26, 29, 33, 35, 36, 33, 29, 25, 29, 32, 35, 35,
    33, 30, 23, 27, 31, 33, 35, 35, 30, 22, 26, 30, 34, 37, 34, 31, 23, 25, 29,
    33, 37, 34, 31, 23, 25, 29, 33, 37, 35, 31, 20, 24, 27, 32, 34, 34, 31, 23,
    27, 30, 33, 32, 28, 25, 23, 26, 29, 32, 32, 29, 25, 22, 24, 28, 31, 31, 29,
    26, 21, 25, 28, 31, 31, 29, 27, 21, 23, 27, 31, 31, 30, 26, 20, 23, 26, 29,
    30, 30, 26, 17, 21, 25, 27, 28, 29, 27, 22, 25, 26, 26, 26, 23, 19, 21, 24,
    25, 25, 25, 24, 18, 20, 22, 24, 24, 24, 24, 19, 17, 23, 24, 24, 25, 24, 20,
    15, 22, 23, 23, 24, 23, 20, 13, 20, 22, 22, 22, 22, 20, 15, 18, 20, 21, 21,
    21, 19, 19, 19, 19, 19, 19, 16, 7,  17, 18, 18, 18, 18, 15, 9,  13, 17, 17,
    17, 17, 15, 10, 10, 17, 17, 17, 17, 15, 13, 12, 16, 16, 16, 16, 14, 10, 12,
    14, 14, 14, 15, 14, 7,  15, 15, 12, 13, 13, 13, 5,  9,  11, 12, 11, 10, 5,
    7,  6,  11, 10, 10, 9,  5,  8,  6,  9,  9,  9,  8,  5,  7,  5,  7,  8,  8,
    8,  4,  6,  7,  5,  7,  7,  7,  5,  5,  9,  9,  11, 9,  7,  6,  5,  12, 14,
    14, 10, 8,  7,  5,  2,  2,  2,  2,  3,  4,  5,  2,  1,  0,  1,  2,  4,  5,
    2,  2,  2,  2,  2,  4,  6,  2,  4,  6,  6,  4,  4,  5,  4,  7,  11, 11, 9,
    7,  5,  7,  12, 17, 15, 11, 8,  5,  12, 16, 19, 18, 13, 9,  6,  4,  10, 9,
    4,  2,  3,  4,  4,  10, 12, 6,  1,  3,  4,  4,  10, 14, 8,  3,  3,  4,  4,
    11, 17, 12, 7,  5,  5,  7,  13, 19, 17, 12, 9,  6,  10, 17, 22, 21, 15, 10,
    7,  15, 19, 23, 23, 17, 11, 8,  26, 28, 32, 35, 35, 32, 29, 25, 27, 31, 34,
    35, 31, 29, 23, 26, 30, 34, 35, 33, 29, 22, 25, 30, 33, 36, 34, 31, 23, 25,
    29, 33, 37, 35, 29, 23, 25, 28, 32, 35, 34, 32, 20, 23, 27, 31, 34, 34, 31,
    23, 26, 29, 32, 31, 27, 23, 22, 25, 29, 32, 30, 27, 24, 22, 24, 28, 31, 31,
    29, 25, 21, 24, 27, 31, 31, 30, 25, 21, 24, 27, 30, 30, 29, 26, 20, 23, 26,
    30, 29, 29, 25, 18, 21, 24, 28, 27, 28, 25, 22, 24, 25, 25, 25, 23, 17, 20,
    22, 25, 25, 24, 22, 17, 19, 22, 24, 24, 24, 22, 17, 17, 23, 23, 23, 24, 23,
    19, 15, 23, 23, 24, 23, 23, 19, 13, 20, 22, 22, 22, 22, 19, 15, 19, 20, 20,
    21, 21, 18, 20, 19, 18, 18, 18, 15, 6,  17, 18, 18, 17, 17, 14, 8,  13, 17,
    17, 17, 16, 14, 10, 10, 17, 17, 17, 17, 14, 13, 12, 16, 16, 16, 15, 14, 10,
    13, 14, 14, 14, 14, 13, 7,  16, 16, 13, 13, 13, 13, 5,  9,  12, 11, 11, 9,
    4,  6,  6,  10, 10, 9,  8,  4,  8,  6,  9,  8,  9,  8,  4,  6,  5,  7,  9,
    8,  8,  4,  6,  7,  6,  7,  7,  7,  6,  5,  9,  10, 12, 10, 8,  7,  5,  13,
    16, 15, 12, 9,  8,  6,  2,  2,  2,  2,  2,  3,  4,  2,  1,  1,  0,  2,  3,
    4,  2,  2,  3,  3,  2,  3,  4,  2,  4,  7,  7,  5,  5,  5,  4,  8,  12, 11,
    9,  8,  6,  8,  13, 18, 16, 11, 8,  6,  14, 18, 20, 18, 13, 9,  7,  5,  8,
    7,  3,  1,  2,  3,  5,  8,  8,  4,  0,  2,  4,  5,  8,  10, 7,  4,  3,  4,
    5,  10, 14, 11, 8,  6,  6,  8,  13, 18, 17, 12, 9,  7,  11, 17, 22, 22, 15,
    11, 8,  16, 21, 23, 23, 18, 12, 8,  22, 25, 28, 31, 32, 29, 26, 21, 23, 27,
    31, 32, 27, 25, 19, 23, 26, 29, 32, 29, 27, 19, 23, 26, 30, 32, 30, 27, 20,
    22, 26, 29, 32, 31, 28, 19, 22, 25, 29, 32, 30, 27, 17, 20, 24, 27, 31, 31,
    27, 20, 23, 26, 29, 28, 24, 21, 18, 22, 25, 28, 27, 24, 21, 18, 20, 24, 27,
    27, 26, 21, 17, 21, 25, 27, 26, 25, 22, 19, 21, 24, 26, 26, 26, 22, 16, 20,
    22, 25, 26, 26, 23, 16, 18, 21, 24, 25, 24, 22, 18, 20, 21, 22, 23, 19, 15,
    17, 19, 21, 21, 21, 20, 15, 17, 19, 20, 20, 20, 20, 15, 15, 19, 20, 20, 21,
    20, 16, 14, 19, 20, 20, 20, 19, 16, 12, 17, 18, 19, 19, 18, 16, 17, 17, 17,
    17, 17, 17, 16, 16, 15, 15, 15, 16, 13, 4,  14, 14, 14, 14, 14, 12, 5,  12,
    14, 13, 14, 13, 12, 8,  8,  14, 14, 13, 13, 12, 10, 10, 13, 13, 13, 12, 11,
    7,  12, 12, 11, 11, 11, 11, 5,  17, 18, 14, 10, 10, 10, 5,  7,  8,  7,  7,
    7,  3,  4,  3,  7,  6,  6,  6,  3,  5,  3,  6,  5,  6,  5,  3,  4,  3,  4,
    5,  5,  5,  4,  4,  5,  7,  8,  8,  8,  7,  5,  9,  13, 14, 12, 9,  7,  6,
    15, 18, 18, 13, 11, 8,  6,  1,  2,  2,  2,  2,  2,  3,  2,  3,  2,  2,  0,
    3,  3,  2,  4,  3,  3,  3,  2,  3,  2,  6,  8,  7,  6,  5,  5,  6,  10, 13,
    12, 10, 8,  6,  11, 16, 19, 16, 12, 9,  7,  16, 20, 21, 18, 14, 10, 7,  6,
    7,  5,  3,  1,  2,  2,  6,  7,  7,  3,  2,  2,  3,  5,  7,  8,  5,  4,  3,
    3,  6,  8,  12, 10, 8,  7,  7,  9,  12, 16, 16, 13, 10, 7,  13, 17, 20, 21,
    15, 12, 8,  18, 21, 21, 21, 17, 13, 9,  17, 21, 24, 28, 28, 26, 22, 17, 19,
    24, 28, 28, 24, 21, 15, 19, 22, 25, 27, 25, 22, 15, 18, 21, 25, 29, 26, 22,
    15, 18, 21, 24, 28, 26, 23, 14, 17, 20, 24, 28, 26, 23, 15, 16, 19, 23, 25,
    27, 23, 16, 19, 22, 25, 24, 22, 18, 14, 18, 21, 23, 23, 21, 16, 13, 16, 20,
    22, 22, 20, 18, 13, 16, 20, 23, 22, 22, 19, 13, 16, 19, 22, 22, 21, 19, 12,
    14, 18, 21, 21, 21, 19, 17, 16, 17, 19, 20, 20, 18, 14, 16, 17, 18, 19, 17,
    13, 13, 15, 16, 17, 17, 16, 12, 12, 14, 15, 16, 16, 16, 12, 11, 14, 16, 16,
    16, 16, 13, 11, 14, 15, 15, 15, 15, 13, 12, 13, 14, 14, 14, 14, 13, 19, 18,
    14, 13, 13, 13, 12, 12, 11, 10, 11, 12, 12, 4,  11, 10, 10, 10, 10, 10, 3,
    9,  9,  9,  9,  9,  9,  4,  6,  9,  9,  9,  9,  9,  7,  7,  8,  8,  8,  8,
    7,  4,  12, 14, 12, 10, 8,  7,  4,  18, 20, 14, 12, 9,  7,  5,  4,  3,  3,
    3,  4,  3,  4,  1,  2,  2,  2,  2,  2,  3,  1,  1,  1,  2,  2,  2,  3,  1,
    5,  5,  5,  5,  4,  4,  5,  10, 9,  9,  9,  7,  5,  12, 15, 16, 13, 10, 8,
    6,  17, 20, 18, 14, 11, 9,  6,  4,  5,  3,  3,  2,  2,  3,  4,  6,  4,  3,
    2,  0,  2,  4,  7,  5,  5,  3,  3,  2,  4,  8,  9,  8,  7,  6,  5,  8,  12,
    14, 13, 11, 9,  6,  12, 16, 20, 17, 12, 10, 7,  18, 21, 21, 19, 14, 11, 8,
    8,  10, 6,  4,  3,  2,  2,  8,  10, 8,  5,  3,  2,  1,  8,  10, 10, 7,  5,
    4,  3,  9,  10, 14, 11, 9,  8,  7,  10, 14, 17, 16, 14, 11, 8,  14, 18, 21,
    21, 16, 12, 9,  19, 21, 23, 22, 18, 13, 10, 14, 16, 21, 24, 24, 21, 18, 13,
    16, 19, 23, 24, 20, 17, 11, 14, 18, 21, 23, 20, 18, 10, 14, 18, 21, 24, 21,
    18, 11, 14, 17, 20, 24, 22, 18, 10, 13, 16, 19, 23, 22, 18, 15, 14, 15, 18,
    22, 21, 18, 11, 14, 18, 21, 20, 17, 14, 11, 14, 17, 20, 20, 16, 13, 9,  12,
    15, 18, 18, 16, 14, 9,  12, 15, 18, 17, 17, 14, 9,  12, 15, 17, 17, 17, 14,
    11, 12, 13, 16, 16, 16, 14, 18, 16, 14, 15, 15, 15, 14, 10, 12, 14, 14, 16,
    13, 9,  9,  11, 12, 13, 13, 12, 8,  7,  10, 12, 11, 11, 12, 8,  7,  10, 11,
    11, 11, 11, 9,  6,  9,  11, 11, 10, 10, 9,  13, 13, 12, 10, 9,  9,  9,  19,
    17, 15, 11, 9,  8,  8,  8,  7,  6,  7,  8,  9,  3,  7,  6,  6,  6,  6,  6,
    2,  6,  5,  5,  5,  4,  4,  2,  4,  5,  4,  4,  4,  4,  4,  7,  8,  8,  7,
    7,  6,  4,  14, 15, 13, 11, 8,  7,  5,  19, 20, 15, 12, 9,  7,  6,  2,  2,
    1,  2,  2,  2,  3,  3,  3,  2,  2,  2,  2,  2,  3,  3,  3,  3,  3,  2,  2,
    3,  6,  6,  6,  6,  5,  5,  7,  11, 11, 10, 9,  8,  5,  13, 16, 16, 13, 11,
    9,  7,  19, 20, 19, 15, 12, 10, 7,  7,  6,  4,  3,  3,  3,  3,  7,  7,  5,
    4,  3,  2,  0,  7,  9,  6,  6,  4,  3,  3,  7,  10, 10, 10, 8,  7,  6,  9,
    14, 16, 15, 12, 10, 7,  15, 18, 22, 20, 14, 10, 8,  19, 21, 23, 21, 16, 12,
    9,  10, 12, 9,  5,  3,  3,  2,  10, 12, 11, 6,  3,  2,  2,  10, 12, 13, 9,
    6,  5,  4,  10, 13, 17, 13, 11, 9,  8,  13, 16, 21, 20, 16, 12, 9,  16, 21,
    25, 24, 18, 13, 10, 20, 23, 25, 26, 20, 15, 11, 24, 26, 29, 32, 32, 30, 26,
    23, 25, 28, 31, 31, 29, 26, 22, 24, 27, 29, 31, 28, 26, 20, 23, 26, 29, 30,
    29, 27, 20, 23, 26, 29, 31, 28, 27, 19, 22, 24, 27, 30, 29, 26, 16, 20, 24,
    26, 29, 29, 27, 22, 24, 27, 29, 28, 26, 23, 21, 24, 27, 29, 27, 25, 24, 19,
    23, 25, 27, 27, 25, 23, 18, 21, 25, 27, 25, 25, 25, 18, 21, 24, 27, 26, 25,
    25, 16, 19, 23, 25, 25, 25, 24, 13, 16, 20, 24, 24, 25, 24, 19, 23, 23, 24,
    25, 23, 19, 18, 21, 22, 23, 24, 22, 20, 17, 20, 22, 22, 22, 23, 19, 15, 19,
    21, 21, 22, 22, 20, 14, 19, 19, 20, 21, 22, 20, 11, 17, 18, 19, 20, 20, 19,
    13, 14, 16, 17, 18, 19, 19, 17, 17, 17, 18, 18, 18, 7,  15, 16, 16, 16, 17,
    16, 8,  13, 15, 15, 15, 15, 15, 10, 9,  14, 14, 14, 14, 14, 12, 9,  12, 12,
    13, 13, 14, 8,  10, 10, 10, 11, 11, 12, 6,  13, 13, 9,  9,  10, 10, 6,  8,
    8,  9,  10, 10, 6,  8,  4,  7,  7,  8,  8,  6,  9,  4,  6,  6,  5,  6,  5,
    8,  4,  4,  4,  4,  5,  5,  6,  5,  4,  4,  4,  4,  3,  6,  7,  7,  7,  6,
    4,  3,  5,  10, 10, 8,  6,  4,  3,  4,  0,  2,  2,  2,  2,  5,  7,  0,  3,
    2,  2,  2,  4,  8,  0,  4,  2,  2,  1,  4,  6,  0,  3,  3,  2,  1,  2,  5,
    2,  3,  5,  5,  3,  3,  4,  5,  6,  9,  8,  5,  3,  3,  8,  9,  10, 9,  6,
    4,  3,  4,  7,  6,  3,  2,  3,  6,  4,  7,  8,  4,  2,  2,  5,  4,  7,  9,
    4,  2,  0,  5,  4,  7,  10, 6,  3,  2,  3,  4,  7,  10, 9,  5,  4,  3,  5,
    9,  12, 11, 7,  4,  3,  7,  11, 12, 12, 8,  5,  3,  30, 32, 35, 39, 38, 37,
    32, 28, 32, 34, 37, 39, 36, 33, 27, 31, 33, 37, 38, 36, 32, 26, 29, 32, 35,
    38, 37, 34, 25, 28, 33, 36, 38, 37, 35, 24, 27, 31, 35, 38, 37, 35, 22, 25,
    31, 34, 36, 37, 34, 27, 31, 33, 36, 36, 32, 29, 26, 29, 33, 35, 34, 32, 28,
    24, 28, 32, 34, 35, 33, 30, 24, 27, 31, 34, 34, 33, 30, 23, 26, 29, 33, 32,
    33, 30, 21, 25, 29, 32, 32, 33, 30, 19, 22, 27, 30, 31, 31, 30, 24, 28, 28,
    29, 30, 28, 23, 23, 27, 28, 29, 29, 28, 22, 22, 25, 27, 28, 28, 28, 23, 20,
    25, 26, 27, 28, 27, 25, 17, 24, 25, 26, 26, 26, 24, 14, 23, 24, 24, 25, 26,
    24, 15, 19, 21, 23, 24, 25, 23, 22, 23, 23, 23, 23, 21, 11, 19, 21, 21, 21,
    22, 20, 12, 16, 20, 20, 20, 20, 19, 13, 12, 20, 19, 20, 19, 19, 16, 13, 17,
    18, 19, 19, 18, 12, 13, 15, 16, 17, 17, 17, 9,  15, 13, 14, 15, 16, 16, 8,
    10, 14, 14, 14, 14, 9,  11, 7,  12, 13, 13, 12, 9,  12, 7,  11, 11, 11, 11,
    7,  10, 7,  8,  10, 10, 10, 8,  9,  8,  6,  9,  8,  9,  6,  8,  9,  8,  8,
    7,  7,  4,  7,  11, 10, 9,  7,  5,  3,  6,  4,  3,  4,  4,  6,  8,  10, 4,
    2,  2,  2,  4,  7,  9,  4,  0,  1,  1,  3,  6,  8,  4,  1,  2,  1,  2,  4,
    7,  4,  3,  4,  4,  4,  3,  7,  6,  6,  8,  6,  5,  4,  5,  8,  9,  9,  6,
    5,  4,  4,  2,  5,  3,  2,  3,  6,  9,  2,  5,  4,  3,  2,  5,  9,  2,  5,
    5,  3,  0,  4,  7,  2,  5,  6,  2,  2,  3,  5,  2,  4,  7,  5,  4,  4,  4,
    5,  6,  8,  8,  5,  4,  4,  8,  8,  9,  9,  6,  5,  4,  29, 33, 36, 39, 39,
    36, 33, 28, 31, 34, 38, 38, 36, 32, 26, 29, 34, 37, 38, 35, 32, 25, 28, 31,
    36, 39, 36, 33, 25, 29, 31, 36, 39, 37, 34, 24, 27, 30, 34, 38, 37, 33, 22,
    26, 29, 33, 36, 37, 33, 26, 29, 34, 36, 34, 32, 29, 25, 29, 32, 36, 35, 32,
    27, 24, 27, 30, 34, 34, 31, 28, 23, 26, 30, 33, 33, 32, 28, 24, 27, 30, 32,
    32, 31, 29, 22, 25, 29, 32, 32, 32, 29, 19, 23, 27, 30, 30, 30, 28, 24, 27,
    28, 29, 30, 26, 22, 23, 25, 28, 28, 28, 27, 21, 22, 25, 27, 26, 27, 26, 21,
    18, 25, 25, 25, 26, 25, 21, 16, 24, 25, 25, 26, 25, 22, 13, 22, 24, 24, 24,
    24, 22, 15, 20, 22, 23, 23, 23, 20, 22, 22, 22, 22, 23, 19, 10, 18, 20, 21,
    22, 21, 18, 11, 15, 20, 20, 20, 19, 17, 12, 11, 19, 19, 19, 18, 16, 15, 13,
    17, 18, 18, 19, 16, 11, 13, 15, 16, 16, 16, 15, 8,  15, 14, 14, 15, 15, 14,
    6,  10, 14, 14, 14, 12, 6,  10, 7,  13, 12, 13, 11, 6,  11, 7,  11, 11, 11,
    10, 5,  8,  7,  8,  10, 10, 9,  5,  8,  8,  6,  9,  9,  8,  5,  6,  9,  8,
    9,  7,  7,  5,  6,  11, 12, 12, 9,  6,  5,  5,  3,  4,  4,  5,  4,  5,  7,
    3,  2,  2,  3,  3,  5,  6,  3,  1,  0,  0,  3,  5,  7,  2,  2,  4,  4,  2,
    4,  5,  4,  5,  9,  8,  8,  5,  5,  6,  10, 15, 13, 10, 6,  4,  10, 14, 17,
    15, 11, 8,  4,  2,  8,  8,  2,  3,  4,  6,  2,  8,  10, 4,  2,  4,  6,  2,
    8,  12, 5,  1,  3,  5,  2,  9,  14, 9,  5,  4,  5,  5,  11, 16, 14, 10, 8,
    4,  8,  14, 19, 18, 13, 9,  5,  13, 18, 19, 19, 15, 10, 6,  28, 32, 36, 38,
    38, 35, 33, 27, 30, 35, 37, 39, 36, 31, 26, 29, 33, 36, 39, 34, 32, 24, 27,
    31, 35, 37, 35, 32, 25, 27, 31, 35, 37, 36, 33, 23, 26, 30, 33, 37, 35, 33,
    21, 25, 29, 31, 35, 35, 32, 25, 29, 33, 37, 35, 31, 27, 25, 29, 31, 36, 34,
    32, 27, 24, 26, 31, 33, 33, 30, 26, 23, 25, 29, 32, 32, 30, 26, 22, 25, 29,
    32, 32, 31, 26, 21, 25, 27, 31, 30, 29, 27, 19, 22, 26, 30, 29, 28, 27, 24,
    26, 29, 29, 30, 27, 20, 22, 25, 28, 28, 28, 26, 20, 21, 23, 26, 26, 26, 24,
    19, 18, 25, 25, 24, 25, 23, 19, 16, 23, 24, 24, 24, 23, 20, 13, 22, 23, 23,
    23, 23, 20, 15, 20, 21, 21, 21, 22, 18, 20, 21, 21, 22, 23, 18, 11, 18, 20,
    20, 21, 21, 17, 11, 14, 19, 18, 19, 18, 15, 12, 11, 18, 18, 17, 18, 15, 14,
    12, 16, 17, 17, 17, 14, 11, 13, 15, 16, 16, 16, 13, 7,  14, 14, 14, 14, 15,
    13, 5,  9,  14, 13, 15, 12, 7,  11, 6,  13, 12, 13, 12, 6,  11, 6,  10, 11,
    10, 9,  4,  7,  6,  7,  10, 9,  8,  4,  7,  8,  6,  8,  8,  7,  4,  4,  9,
    8,  9,  8,  6,  4,  4,  11, 12, 12, 9,  6,  5,  4,  2,  4,  4,  5,  4,  6,
    8,  2,  2,  2,  3,  3,  5,  6,  2,  1,  0,  0,  3,  3,  5,  2,  2,  4,  4,
    2,  3,  4,  4,  5,  9,  8,  7,  5,  4,  6,  10, 15, 13, 9,  6,  4,  10, 14,
    16, 15, 10, 7,  4,  3,  7,  6,  2,  3,  5,  6,  3,  7,  7,  4,  2,  3,  4,
    3,  7,  8,  5,  1,  2,  4,  3,  8,  11, 9,  4,  4,  4,  5,  11, 15, 14, 9,
    7,  4,  8,  14, 19, 19, 12, 8,  5,  13, 17, 20, 20, 14, 9,  6,  24, 29, 32,
    35, 36, 33, 29, 23, 27, 31, 34, 35, 32, 28, 22, 25, 28, 33, 34, 31, 27, 20,
    22, 26, 30, 32, 30, 28, 21, 23, 26, 30, 34, 31, 27, 20, 22, 26, 29, 33, 31,
    27, 17, 21, 24, 27, 31, 32, 28, 22, 25, 30, 33, 31, 28, 25, 21, 23, 27, 31,
    32, 28, 23, 20, 22, 27, 29, 28, 26, 22, 19, 21, 24, 27, 27, 26, 22, 20, 21,
    24, 27, 27, 27, 22, 18, 20, 23, 25, 26, 26, 23, 14, 18, 22, 25, 25, 24, 22,
    20, 23, 24, 25, 27, 23, 19, 19, 21, 24, 24, 25, 22, 17, 18, 21, 22, 22, 22,
    21, 16, 16, 20, 21, 21, 21, 21, 16, 14, 20, 20, 20, 20, 19, 16, 11, 17, 19,
    19, 19, 19, 16, 14, 15, 17, 17, 18, 18, 15, 18, 18, 17, 18, 19, 17, 9,  15,
    16, 16, 17, 17, 15, 9,  12, 16, 15, 15, 14, 12, 8,  9,  16, 14, 13, 13, 12,
    11, 10, 14, 13, 13, 12, 11, 8,  11, 11, 11, 11, 11, 10, 4,  14, 14, 10, 10,
    10, 10, 3,  7,  9,  10, 10, 10, 6,  9,  4,  9,  8,  9,  9,  4,  9,  4,  7,
    6,  6,  6,  3,  5,  4,  6,  6,  5,  5,  2,  4,  6,  5,  5,  5,  5,  4,  3,
    7,  10, 11, 9,  6,  5,  3,  12, 14, 14, 10, 8,  6,  4,  1,  1,  1,  2,  4,
    5,  7,  1,  2,  2,  2,  3,  3,  4,  1,  3,  4,  3,  0,  2,  4,  1,  5,  5,
    4,  4,  3,  3,  3,  7,  10, 9,  8,  6,  4,  8,  12, 16, 13, 9,  6,  4,  13,
    16, 18, 15, 11, 7,  5,  5,  6,  5,  3,  2,  4,  5,  4,  6,  6,  4,  2,  2,
    3,  4,  6,  7,  3,  2,  1,  2,  4,  7,  9,  7,  6,  4,  4,  6,  9,  13, 13,
    10, 7,  5,  10, 14, 17, 17, 13, 9,  6,  15, 18, 18, 18, 14, 10, 6,  20, 24,
    28, 32, 32, 29, 25, 19, 23, 26, 31, 31, 28, 24, 17, 21, 25, 28, 30, 26, 23,
    17, 19, 23, 26, 29, 26, 23, 16, 18, 21, 25, 29, 27, 23, 15, 18, 21, 24, 27,
    26, 23, 12, 16, 19, 23, 26, 27, 23, 17, 21, 25, 29, 28, 24, 21, 16, 20, 24,
    28, 27, 24, 20, 16, 18, 23, 25, 25, 21, 18, 15, 17, 20, 23, 22, 22, 19, 14,
    17, 20, 22, 22, 22, 18, 12, 16, 18, 21, 21, 21, 18, 13, 14, 17, 20, 20, 20,
    19, 15, 18, 21, 22, 23, 20, 16, 14, 17, 19, 21, 21, 19, 15, 14, 16, 18, 18,
    18, 18, 13, 13, 16, 16, 16, 16, 16, 13, 12, 15, 16, 16, 16, 15, 13, 10, 12,
    14, 14, 14, 14, 13, 15, 15, 12, 12, 13, 13, 12, 14, 13, 13, 14, 15, 15, 7,
    13, 12, 12, 13, 13, 13, 6,  10, 11, 11, 10, 10, 10, 5,  6,  10, 9,  9,  9,
    9,  7,  7,  9,  8,  8,  8,  8,  4,  10, 10, 9,  7,  7,  7,  2,  15, 16, 11,
    8,  6,  5,  3,  5,  5,  6,  6,  7,  6,  7,  1,  3,  4,  5,  5,  4,  6,  1,
    2,  2,  2,  2,  2,  3,  1,  3,  2,  2,  2,  2,  2,  4,  7,  7,  6,  6,  4,
    2,  9,  12, 12, 10, 7,  5,  3,  14, 16, 15, 11, 9,  6,  4,  3,  4,  3,  3,
    3,  5,  6,  3,  5,  4,  3,  3,  3,  3,  3,  6,  5,  4,  2,  0,  2,  4,  6,
    6,  5,  4,  3,  3,  6,  9,  11, 10, 8,  6,  4,  10, 13, 16, 14, 10, 7,  4,
    14, 16, 18, 15, 11, 8,  5,  7,  8,  7,  4,  3,  4,  4,  6,  8,  8,  5,  3,
    2,  2,  7,  8,  9,  5,  3,  2,  1,  7,  8,  11, 8,  6,  5,  4,  8,  11, 14,
    14, 11, 8,  5,  12, 15, 18, 18, 13, 9,  6,  16, 18, 19, 19, 14, 10, 7,  17,
    20, 25, 28, 28, 26, 21, 15, 19, 23, 27, 28, 25, 20, 14, 18, 21, 25, 27, 22,
    19, 12, 16, 19, 22, 24, 22, 19, 12, 14, 17, 21, 24, 23, 19, 10, 14, 16, 20,
    23, 22, 19, 11, 12, 15, 19, 22, 22, 19, 14, 17, 22, 25, 24, 22, 17, 13, 16,
    20, 24, 23, 20, 16, 12, 15, 19, 21, 21, 18, 15, 10, 13, 16, 18, 19, 17, 14,
    10, 13, 15, 18, 18, 18, 15, 9,  11, 14, 17, 17, 17, 14, 13, 12, 13, 15, 16,
    16, 14, 12, 15, 16, 18, 19, 17, 13, 10, 13, 16, 16, 17, 16, 12, 9,  12, 14,
    14, 14, 14, 10, 8,  11, 12, 12, 12, 12, 10, 7,  10, 11, 11, 11, 11, 10, 11,
    10, 10, 10, 10, 10, 9,  14, 13, 10, 9,  9,  9,  8,  9,  9,  10, 11, 12, 13,
    7,  8,  8,  9,  9,  10, 10, 5,  7,  6,  7,  7,  6,  7,  3,  4,  6,  5,  5,
    5,  5,  4,  6,  6,  5,  4,  5,  4,  2,  11, 11, 9,  7,  5,  4,  2,  14, 14,
    10, 8,  6,  4,  3,  0,  1,  2,  3,  4,  5,  6,  2,  2,  2,  3,  3,  3,  4,
    2,  3,  3,  2,  2,  1,  2,  2,  6,  4,  3,  3,  3,  2,  6,  9,  8,  7,  6,
    5,  2,  10, 12, 12, 9,  7,  6,  3,  13, 14, 14, 11, 8,  6,  4,  6,  6,  5,
    4,  4,  4,  6,  6,  8,  6,  4,  3,  2,  3,  6,  8,  7,  5,  3,  2,  0,  6,
    9,  8,  6,  5,  4,  3,  8,  11, 13, 11, 9,  6,  4,  11, 14, 17, 15, 10, 7,
    5,  14, 16, 18, 16, 12, 8,  6,  9,  10, 8,  6,  4,  4,  4,  10, 10, 10, 6,
    4,  2,  2,  9,  10, 11, 6,  4,  3,  2,  9,  11, 14, 10, 7,  6,  5,  10, 13,
    17, 15, 11, 8,  6,  13, 16, 20, 19, 13, 9,  6,  16, 19, 20, 20, 15, 11, 7,
    24, 27, 29, 31, 31, 31, 27, 23, 26, 28, 31, 32, 28, 27, 21, 24, 27, 30, 31,
    28, 25, 20, 24, 27, 29, 30, 29, 27, 20, 23, 26, 28, 30, 28, 26, 18, 22, 24,
    27, 31, 29, 26, 16, 20, 24, 26, 29, 28, 26, 21, 24, 28, 29, 28, 26, 23, 21,
    23, 25, 28, 28, 26, 23, 19, 23, 26, 28, 26, 26, 24, 18, 21, 25, 26, 26, 26,
    25, 17, 21, 24, 26, 25, 26, 24, 16, 19, 22, 25, 26, 25, 24, 13, 16, 21, 24,
    24, 25, 24, 19, 23, 24, 24, 25, 23, 20, 18, 21, 22, 23, 23, 23, 19, 17, 21,
    22, 22, 22, 23, 19, 15, 20, 21, 21, 22, 22, 20, 14, 18, 20, 20, 21, 21, 20,
    11, 16, 18, 19, 20, 20, 20, 13, 14, 16, 17, 18, 19, 19, 17, 17, 18, 18, 18,
    18, 8,  15, 15, 16, 17, 17, 16, 9,  13, 15, 15, 15, 15, 15, 10, 9,  13, 14,
    14, 15, 15, 12, 9,  12, 13, 13, 13, 14, 8,  10, 10, 10, 11, 11, 12, 6,  13,
    13, 9,  9,  10, 11, 6,  8,  8,  9,  9,  10, 6,  8,  4,  7,  8,  8,  8,  6,
    9,  4,  6,  5,  6,  6,  5,  7,  4,  4,  4,  4,  5,  5,  7,  5,  4,  4,  4,
    4,  3,  6,  7,  7,  7,  6,  4,  3,  5,  10, 10, 8,  6,  4,  3,  4,  0,  2,
    2,  2,  2,  5,  7,  0,  3,  2,  2,  2,  4,  8,  0,  4,  3,  2,  1,  4,  6,
    0,  3,  3,  2,  1,  2,  5,  2,  3,  5,  5,  3,  3,  4,  5,  6,  9,  8,  4,
    3,  3,  8,  9,  10, 9,  6,  4,  3,  4,  7,  6,  3,  2,  3,  6,  4,  7,  8,
    4,  2,  2,  5,  4,  7,  9,  4,  2,  0,  5,  4,  7,  10, 6,  3,  2,  3,  4,
    7,  11, 9,  5,  3,  3,  5,  9,  12, 12, 7,  4,  3,  7,  10, 12, 13, 8,  5,
    3,  30, 34, 37, 40, 39, 38, 34, 29, 34, 37, 40, 40, 38, 34, 28, 32, 35, 39,
    38, 38, 34, 27, 29, 34, 37, 39, 36, 33, 25, 28, 32, 35, 39, 37, 33, 23, 28,
    31, 34, 38, 37, 34, 21, 25, 29, 33, 36, 36, 34, 28, 32, 35, 37, 37, 34, 31,
    26, 31, 34, 37, 36, 33, 31, 25, 29, 33, 34, 35, 33, 30, 24, 28, 31, 33, 33,
    33, 30, 23, 26, 29, 32, 33, 32, 30, 20, 24, 28, 31, 32, 32, 30, 18, 22, 26,
    30, 30, 30, 28, 25, 30, 32, 32, 32, 30, 25, 24, 27, 30, 31, 32, 30, 25, 22,
    26, 28, 29, 29, 28, 24, 20, 25, 26, 27, 27, 27, 24, 16, 23, 25, 26, 26, 27,
    24, 13, 22, 24, 23, 25, 25, 24, 13, 18, 21, 22, 23, 23, 22, 23, 24, 24, 25,
    26, 23, 14, 19, 22, 22, 23, 23, 22, 14, 16, 21, 21, 21, 23, 20, 15, 12, 19,
    19, 19, 19, 18, 15, 12, 17, 18, 18, 18, 17, 12, 12, 14, 15, 16, 16, 16, 9,
    14, 12, 13, 14, 15, 15, 7,  10, 15, 16, 16, 15, 11, 13, 7,  13, 14, 15, 14,
    10, 13, 7,  11, 12, 12, 12, 8,  12, 7,  8,  10, 10, 10, 7,  8,  7,  5,  8,
    8,  8,  5,  8,  8,  7,  6,  6,  6,  3,  8,  10, 9,  8,  6,  4,  3,  6,  3,
    5,  6,  6,  7,  9,  11, 3,  3,  4,  4,  6,  8,  10, 3,  1,  2,  2,  4,  6,
    9,  3,  0,  2,  2,  2,  5,  7,  3,  2,  3,  3,  3,  3,  6,  5,  5,  7,  5,
    3,  3,  4,  7,  8,  7,  5,  4,  3,  3,  2,  4,  4,  2,  5,  7,  10, 2,  4,
    5,  3,  4,  6,  9,  2,  5,  6,  3,  2,  5,  6,  2,  4,  5,  3,  1,  2,  5,
    2,  4,  6,  5,  3,  3,  3,  4,  5,  7,  7,  4,  3,  3,  7,  7,  8,  9,  5,
    3,  3,  33, 36, 41, 43, 44, 41, 38, 31, 35, 39, 43, 44, 41, 37, 30, 35, 37,
    41, 43, 38, 35, 29, 33, 35, 39, 41, 38, 34, 27, 29, 33, 38, 40, 37, 33, 25,
    28, 32, 36, 40, 38, 34, 23, 26, 32, 34, 37, 38, 35, 30, 34, 38, 40, 40, 37,
    33, 29, 33, 36, 40, 40, 37, 32, 26, 32, 35, 39, 38, 35, 32, 26, 29, 32, 36,
    35, 33, 31, 25, 27, 30, 34, 34, 33, 29, 22, 26, 29, 33, 32, 32, 30, 19, 24,
    27, 31, 31, 32, 29, 27, 31, 34, 34, 34, 32, 27, 26, 29, 32, 33, 33, 32, 26,
    24, 28, 30, 31, 31, 30, 24, 20, 27, 27, 28, 28, 27, 23, 16, 25, 26, 27, 27,
    26, 23, 13, 24, 24, 25, 25, 26, 23, 14, 21, 23, 23, 24, 24, 22, 23, 25, 26,
    27, 28, 25, 17, 20, 24, 25, 26, 25, 22, 16, 15, 23, 23, 23, 23, 21, 17, 12,
    20, 20, 20, 19, 18, 16, 12, 17, 19, 19, 19, 16, 13, 13, 14, 17, 17, 17, 16,
    9,  14, 12, 15, 16, 16, 15, 7,  11, 17, 18, 19, 17, 12, 16, 8,  15, 16, 17,
    16, 10, 16, 8,  12, 14, 14, 13, 8,  12, 8,  8,  11, 11, 10, 7,  9,  8,  5,
    10, 10, 9,  5,  6,  8,  7,  7,  7,  7,  4,  8,  10, 9,  8,  6,  6,  3,  5,
    3,  7,  8,  9,  8,  10, 13, 3,  5,  6,  7,  7,  9,  10, 3,  2,  4,  4,  5,
    6,  8,  3,  2,  0,  0,  3,  6,  6,  3,  2,  5,  5,  4,  3,  5,  5,  6,  11,
    10, 6,  3,  5,  7,  11, 13, 11, 8,  4,  4,  1,  7,  7,  4,  7,  9,  10, 1,
    7,  9,  3,  6,  7,  9,  1,  7,  11, 4,  3,  5,  6,  1,  7,  11, 6,  1,  2,
    5,  1,  7,  12, 10, 7,  4,  3,  4,  10, 13, 13, 10, 5,  3,  9,  13, 14, 15,
    11, 7,  3,  33, 36, 40, 42, 44, 41, 37, 30, 34, 38, 44, 43, 40, 35, 29, 33,
    38, 41, 42, 38, 34, 28, 31, 35, 37, 40, 37, 32, 26, 28, 32, 35, 39, 36, 33,
    25, 27, 30, 34, 38, 36, 33, 23, 26, 30, 33, 36, 36, 33, 29, 33, 36, 41, 38,
    36, 32, 28, 32, 36, 39, 38, 35, 31, 26, 30, 33, 37, 36, 33, 29, 25, 27, 32,
    34, 34, 31, 28, 24, 26, 30, 32, 33, 32, 28, 22, 25, 28, 31, 31, 31, 28, 18,
    23, 27, 29, 30, 30, 27, 27, 31, 33, 33, 34, 31, 25, 25, 28, 31, 32, 32, 30,
    23, 22, 27, 29, 30, 30, 28, 22, 19, 25, 26, 26, 27, 26, 21, 15, 25, 25, 26,
    25, 24, 21, 12, 23, 24, 24, 24, 23, 21, 13, 20, 21, 22, 23, 22, 19, 22, 24,
    25, 25, 27, 23, 16, 18, 22, 24, 24, 24, 21, 15, 14, 21, 23, 22, 21, 18, 15,
    12, 19, 19, 19, 19, 15, 15, 12, 16, 19, 18, 17, 14, 12, 13, 14, 16, 16, 16,
    14, 8,  13, 12, 14, 15, 15, 14, 5,  10, 17, 17, 18, 16, 12, 16, 7,  15, 16,
    16, 15, 9,  16, 7,  11, 14, 13, 12, 7,  11, 7,  7,  11, 10, 9,  4,  7,  7,
    5,  10, 9,  8,  3,  5,  8,  7,  7,  7,  7,  3,  5,  10, 9,  8,  5,  5,  2,
    4,  2,  7,  8,  8,  8,  10, 13, 2,  5,  6,  7,  7,  8,  10, 2,  1,  4,  4,
    4,  5,  6,  2,  2,  0,  0,  2,  4,  5,  3,  2,  5,  5,  4,  2,  4,  5,  6,
    11, 10, 6,  3,  3,  7,  10, 13, 12, 7,  4,  3,  2,  6,  6,  4,  7,  9,  10,
    1,  6,  7,  3,  6,  6,  7,  1,  6,  8,  4,  2,  3,  5,  1,  6,  8,  5,  1,
    2,  3,  1,  7,  11, 11, 6,  4,  3,  4,  10, 15, 15, 9,  5,  2,  9,  13, 16,
    16, 11, 6,  3,  28, 32, 36, 40, 41, 36, 33, 27, 31, 35, 39, 40, 35, 32, 26,
    29, 34, 36, 39, 35, 30, 24, 27, 31, 34, 36, 32, 29, 22, 25, 28, 31, 34, 32,
    29, 21, 24, 26, 30, 33, 32, 29, 19, 22, 25, 28, 33, 31, 29, 26, 29, 34, 37,
    35, 33, 29, 25, 28, 32, 36, 35, 32, 28, 23, 27, 31, 34, 33, 30, 25, 22, 25,
    28, 30, 30, 28, 24, 20, 22, 25, 28, 28, 27, 23, 19, 22, 24, 27, 27, 27, 24,
    16, 19, 23, 26, 25, 26, 24, 23, 26, 29, 29, 31, 28, 23, 22, 26, 28, 28, 29,
    26, 21, 20, 23, 26, 25, 26, 25, 19, 17, 22, 22, 22, 23, 22, 18, 13, 21, 21,
    21, 21, 21, 17, 11, 19, 20, 20, 20, 19, 17, 12, 17, 18, 19, 19, 19, 16, 20,
    21, 22, 22, 24, 22, 15, 16, 20, 20, 21, 22, 19, 13, 13, 18, 19, 18, 18, 16,
    13, 10, 16, 15, 15, 15, 13, 12, 9,  14, 15, 14, 14, 12, 9,  10, 12, 12, 12,
    12, 11, 6,  12, 10, 11, 11, 11, 11, 4,  8,  14, 14, 15, 14, 11, 14, 5,  12,
    12, 13, 13, 8,  13, 5,  10, 10, 10, 10, 6,  8,  5,  5,  7,  6,  6,  3,  5,
    5,  4,  5,  5,  5,  2,  3,  6,  6,  7,  5,  3,  2,  4,  8,  9,  9,  6,  4,
    2,  3,  1,  4,  5,  6,  8,  9,  12, 1,  2,  4,  5,  6,  7,  8,  1,  2,  2,
    2,  4,  4,  5,  1,  2,  4,  2,  0,  3,  4,  2,  4,  6,  6,  4,  2,  3,  4,
    8,  12, 10, 6,  3,  2,  8,  11, 13, 11, 7,  4,  2,  4,  5,  4,  4,  6,  8,
    9,  4,  5,  5,  4,  5,  6,  6,  4,  6,  6,  3,  2,  3,  3,  3,  7,  8,  4,
    3,  1,  2,  4,  6,  9,  9,  7,  4,  2,  6,  10, 13, 13, 9,  5,  2,  11, 13,
    14, 14, 10, 6,  3,  25, 28, 32, 36, 36, 34, 29, 23, 26, 31, 35, 35, 31, 28,
    22, 25, 29, 33, 33, 30, 25, 20, 23, 27, 30, 33, 28, 24, 17, 20, 23, 26, 29,
    27, 24, 16, 19, 22, 25, 28, 27, 24, 14, 17, 21, 24, 28, 27, 24, 21, 25, 29,
    32, 32, 28, 25, 21, 24, 28, 31, 32, 27, 23, 18, 22, 27, 29, 29, 25, 22, 19,
    20, 24, 27, 26, 24, 20, 16, 18, 20, 23, 23, 22, 20, 14, 17, 19, 22, 22, 22,
    19, 11, 14, 18, 21, 21, 21, 20, 19, 22, 25, 26, 27, 25, 20, 18, 21, 24, 25,
    24, 23, 19, 17, 20, 22, 22, 22, 22, 16, 15, 18, 18, 18, 19, 19, 14, 11, 16,
    16, 16, 16, 16, 14, 9,  14, 15, 15, 15, 15, 14, 9,  12, 13, 13, 14, 14, 13,
    17, 17, 18, 18, 20, 19, 12, 15, 15, 17, 17, 17, 16, 10, 11, 15, 15, 15, 14,
    14, 9,  7,  12, 11, 11, 11, 11, 9,  7,  10, 9,  9,  9,  8,  6,  8,  7,  8,
    8,  8,  7,  3,  9,  9,  6,  6,  6,  6,  3,  7,  9,  9,  10, 11, 10, 12, 3,
    8,  8,  9,  9,  7,  10, 3,  6,  6,  6,  6,  5,  6,  3,  3,  3,  2,  2,  2,
    3,  2,  4,  3,  3,  3,  1,  3,  5,  7,  7,  6,  4,  2,  2,  7,  9,  9,  7,
    5,  3,  2,  2,  3,  4,  5,  6,  8,  10, 2,  3,  4,  5,  5,  6,  7,  2,  4,
    4,  3,  3,  3,  4,  2,  5,  5,  4,  3,  0,  2,  2,  6,  8,  6,  5,  3,  2,
    6,  9,  12, 9,  6,  4,  1,  9,  11, 12, 11, 7,  5,  2,  6,  8,  6,  4,  6,
    7,  8,  6,  8,  7,  5,  5,  5,  5,  6,  8,  9,  4,  2,  2,  3,  6,  9,  11,
    5,  3,  2,  1,  6,  8,  10, 10, 7,  5,  2,  8,  11, 13, 12, 8,  5,  3,  10,
    13, 14, 14, 10, 6,  4,  20, 24, 28, 32, 31, 29, 25, 19, 23, 27, 31, 31, 28,
    24, 18, 21, 25, 28, 31, 27, 22, 17, 19, 22, 26, 28, 25, 19, 13, 16, 19, 22,
    26, 23, 20, 11, 15, 17, 20, 24, 23, 19, 10, 13, 16, 19, 23, 23, 20, 18, 22,
    25, 29, 28, 25, 21, 17, 21, 24, 27, 28, 24, 20, 15, 19, 23, 25, 24, 22, 18,
    14, 17, 19, 22, 22, 20, 16, 11, 14, 16, 18, 19, 19, 15, 10, 12, 15, 18, 18,
    18, 15, 7,  10, 14, 16, 16, 16, 15, 15, 19, 20, 22, 23, 21, 17, 14, 17, 20,
    21, 21, 19, 15, 13, 16, 18, 18, 18, 18, 13, 12, 14, 15, 14, 14, 14, 10, 9,
    11, 12, 12, 12, 11, 10, 5,  10, 11, 10, 11, 11, 11, 6,  8,  10, 9,  9,  9,
    9,  13, 13, 14, 15, 16, 16, 10, 12, 12, 12, 13, 13, 13, 8,  9,  10, 11, 10,
    10, 10, 7,  5,  8,  7,  7,  7,  7,  6,  4,  5,  5,  4,  4,  4,  3,  5,  4,
    3,  3,  3,  3,  2,  6,  6,  3,  2,  2,  2,  1,  4,  5,  6,  7,  7,  9,  10,
    2,  4,  5,  6,  6,  7,  8,  2,  3,  4,  4,  4,  4,  5,  2,  3,  3,  2,  2,
    1,  2,  1,  6,  4,  3,  3,  2,  1,  5,  6,  6,  4,  3,  2,  0,  5,  7,  7,
    5,  4,  3,  1,  5,  5,  5,  5,  6,  8,  9,  5,  6,  5,  5,  5,  5,  6,  5,
    7,  5,  4,  3,  3,  3,  5,  7,  6,  5,  4,  3,  0,  6,  8,  8,  6,  4,  3,
    1,  6,  9,  11, 8,  5,  3,  2,  7,  9,  11, 10, 6,  4,  2,  7,  9,  7,  5,
    6,  7,  7,  8,  10, 9,  5,  5,  5,  5,  8,  10, 10, 5,  3,  2,  2,  8,  9,
    11, 7,  4,  3,  2,  8,  9,  12, 10, 6,  4,  2,  8,  10, 14, 13, 8,  4,  3,
    9,  12, 14, 14, 9,  5,  3,  27, 31, 32, 35, 35, 33, 30, 25, 29, 33, 35, 35,
    32, 29, 23, 27, 30, 33, 34, 31, 29, 23, 26, 28, 31, 33, 28, 26, 20, 23, 25,
    28, 30, 28, 26, 18, 22, 24, 27, 30, 28, 26, 15, 19, 22, 26, 28, 28, 26, 24,
    28, 30, 33, 32, 30, 27, 23, 27, 30, 31, 31, 29, 26, 21, 25, 28, 31, 30, 28,
    26, 20, 24, 27, 28, 28, 25, 23, 18, 20, 23, 25, 25, 26, 23, 16, 18, 22, 25,
    25, 24, 23, 12, 15, 20, 23, 24, 24, 23, 22, 25, 27, 27, 28, 26, 23, 20, 24,
    26, 28, 28, 26, 22, 18, 23, 25, 25, 24, 26, 22, 17, 20, 22, 22, 22, 24, 20,
    12, 18, 19, 20, 20, 21, 19, 9,  15, 17, 18, 19, 20, 19, 10, 12, 15, 16, 17,
    19, 19, 18, 20, 20, 22, 22, 22, 12, 16, 18, 19, 20, 21, 20, 13, 13, 17, 17,
    18, 18, 18, 13, 9,  14, 14, 14, 15, 15, 12, 8,  12, 12, 12, 12, 13, 8,  9,
    9,  9,  10, 11, 11, 6,  10, 10, 7,  8,  9,  9,  7,  9,  11, 12, 13, 13, 10,
    12, 4,  9,  10, 11, 11, 9,  12, 4,  8,  8,  8,  9,  8,  10, 4,  4,  5,  5,
    5,  6,  6,  3,  2,  2,  2,  2,  3,  6,  5,  5,  5,  4,  2,  2,  6,  8,  8,
    6,  4,  2,  1,  5,  2,  3,  4,  4,  7,  9,  11, 2,  4,  4,  4,  6,  8,  9,
    2,  4,  4,  4,  3,  6,  8,  2,  3,  3,  3,  2,  2,  6,  0,  3,  4,  3,  2,
    1,  5,  3,  4,  7,  5,  2,  1,  3,  6,  7,  8,  7,  3,  2,  1,  5,  8,  7,
    5,  5,  8,  9,  5,  8,  9,  6,  4,  6,  9,  5,  8,  10, 6,  4,  3,  6,  5,
    7,  10, 5,  2,  2,  3,  4,  6,  9,  7,  3,  2,  1,  4,  7,  10, 9,  5,  2,
    1,  5,  9,  10, 10, 6,  3,  1,  34, 37, 40, 44, 42, 41, 38, 33, 35, 39, 43,
    43, 40, 37, 30, 34, 38, 41, 43, 39, 36, 29, 32, 35, 39, 41, 37, 33, 26, 30,
    32, 35, 39, 34, 33, 23, 26, 30, 33, 36, 37, 33, 21, 25, 29, 33, 36, 36, 34,
    31, 35, 38, 42, 40, 37, 35, 29, 33, 37, 40, 41, 36, 33, 28, 31, 34, 38, 38,
    36, 31, 26, 29, 33, 35, 35, 34, 29, 23, 26, 29, 32, 31, 31, 28, 20, 24, 27,
    30, 31, 33, 29, 17, 21, 26, 29, 30, 30, 29, 27, 31, 33, 36, 36, 33, 29, 26,
    30, 32, 34, 34, 33, 28, 24, 28, 31, 32, 33, 32, 27, 21, 27, 27, 28, 29, 28,
    24, 15, 23, 25, 25, 25, 25, 25, 12, 21, 23, 24, 24, 24, 24, 12, 18, 21, 22,
    22, 23, 22, 25, 26, 27, 29, 28, 28, 19, 20, 23, 26, 26, 27, 24, 18, 16, 22,
    24, 24, 24, 23, 17, 12, 20, 20, 20, 21, 20, 17, 11, 16, 17, 17, 17, 17, 13,
    11, 13, 15, 15, 16, 15, 10, 12, 10, 12, 14, 14, 14, 8,  12, 17, 18, 19, 20,
    16, 19, 8,  15, 17, 18, 18, 13, 18, 8,  13, 15, 15, 15, 11, 15, 8,  8,  11,
    10, 11, 8,  9,  6,  3,  8,  7,  8,  6,  7,  7,  5,  4,  5,  5,  5,  8,  8,
    7,  5,  3,  3,  4,  7,  3,  7,  8,  10, 11, 14, 16, 3,  6,  7,  8,  10, 12,
    13, 3,  3,  5,  5,  7,  9,  11, 3,  2,  2,  2,  4,  6,  8,  3,  0,  3,  2,
    1,  4,  7,  3,  3,  4,  3,  2,  3,  7,  5,  6,  5,  4,  2,  1,  5,  4,  6,
    6,  6,  10, 12, 14, 4,  6,  7,  5,  8,  10, 11, 3,  6,  7,  4,  4,  7,  9,
    4,  5,  7,  3,  2,  3,  5,  2,  4,  5,  4,  2,  1,  5,  3,  4,  6,  5,  3,
    2,  4,  4,  5,  6,  6,  3,  2,  2,  38, 41, 46, 49, 49, 47, 45, 37, 41, 44,
    48, 50, 45, 41, 35, 38, 43, 46, 48, 44, 40, 33, 36, 39, 43, 46, 43, 36, 31,
    33, 37, 40, 43, 41, 36, 27, 30, 35, 38, 41, 40, 36, 25, 28, 33, 37, 40, 40,
    37, 35, 40, 42, 46, 46, 42, 37, 33, 37, 42, 46, 46, 41, 37, 31, 36, 40, 43,
    44, 40, 35, 30, 33, 37, 39, 40, 38, 33, 25, 30, 33, 36, 37, 36, 32, 22, 27,
    32, 34, 35, 35, 32, 18, 25, 30, 33, 33, 34, 32, 31, 36, 38, 39, 41, 37, 32,
    29, 35, 37, 38, 39, 36, 31, 27, 33, 34, 36, 36, 35, 29, 23, 31, 32, 32, 33,
    31, 25, 17, 27, 28, 28, 28, 27, 25, 14, 25, 26, 27, 27, 27, 26, 13, 22, 25,
    25, 26, 26, 24, 26, 30, 31, 32, 33, 31, 23, 22, 28, 30, 31, 30, 29, 22, 19,
    25, 27, 28, 28, 26, 22, 15, 22, 24, 24, 24, 22, 20, 13, 17, 21, 21, 21, 18,
    17, 13, 14, 18, 19, 19, 18, 13, 13, 11, 17, 17, 18, 17, 10, 14, 21, 22, 24,
    23, 19, 23, 10, 19, 21, 21, 21, 15, 22, 10, 15, 19, 18, 18, 13, 17, 10, 9,
    15, 15, 15, 10, 12, 8,  5,  12, 12, 11, 7,  9,  9,  6,  9,  9,  9,  7,  8,
    9,  7,  7,  7,  7,  7,  7,  5,  11, 13, 13, 14, 17, 20, 5,  8,  11, 12, 13,
    14, 16, 5,  4,  9,  9,  10, 11, 12, 5,  3,  5,  5,  6,  8,  8,  4,  3,  0,
    0,  3,  6,  7,  4,  3,  6,  5,  1,  5,  8,  6,  5,  7,  6,  2,  4,  6,  4,
    5,  5,  9,  13, 15, 16, 4,  6,  7,  8,  11, 13, 14, 4,  5,  9,  5,  8,  9,
    11, 4,  5,  9,  4,  3,  6,  7,  2,  4,  7,  5,  2,  3,  7,  2,  5,  8,  7,
    4,  3,  5,  4,  7,  8,  8,  5,  1,  4,  36, 40, 45, 47, 48, 45, 42, 35, 40,
    43, 48, 47, 44, 40, 33, 37, 42, 45, 46, 43, 39, 32, 35, 39, 43, 44, 40, 35,
    30, 32, 35, 39, 41, 38, 35, 27, 29, 32, 36, 40, 38, 34, 23, 28, 32, 34, 38,
    38, 34, 34, 38, 41, 45, 46, 41, 37, 33, 35, 40, 44, 44, 38, 35, 31, 35, 39,
    42, 42, 38, 33, 28, 32, 35, 39, 38, 35, 31, 24, 29, 32, 34, 36, 33, 30, 20,
    27, 30, 33, 33, 32, 30, 17, 24, 29, 32, 31, 31, 30, 31, 35, 36, 38, 38, 37,
    30, 28, 34, 36, 36, 38, 35, 29, 25, 32, 35, 34, 34, 33, 26, 21, 29, 31, 31,
    30, 30, 23, 15, 26, 27, 28, 27, 25, 24, 12, 23, 26, 27, 25, 25, 24, 12, 21,
    24, 24, 24, 24, 22, 25, 30, 29, 32, 31, 29, 23, 20, 27, 29, 29, 29, 26, 21,
    17, 26, 27, 26, 26, 23, 20, 14, 21, 23, 23, 22, 20, 19, 12, 17, 20, 20, 19,
    16, 15, 12, 13, 18, 18, 18, 15, 12, 12, 10, 16, 16, 17, 15, 8,  12, 20, 22,
    22, 21, 17, 22, 9,  18, 19, 21, 20, 14, 21, 9,  14, 18, 17, 17, 11, 16, 9,
    8,  15, 14, 13, 8,  11, 8,  4,  12, 11, 9,  5,  8,  7,  5,  9,  9,  8,  4,
    6,  8,  6,  7,  7,  7,  4,  5,  5,  11, 12, 13, 13, 15, 19, 5,  7,  11, 11,
    12, 13, 14, 5,  4,  9,  8,  9,  10, 11, 5,  3,  5,  5,  6,  6,  6,  3,  2,
    0,  0,  2,  4,  5,  3,  3,  6,  5,  1,  3,  5,  5,  5,  7,  7,  2,  3,  4,
    4,  5,  5,  9,  12, 14, 15, 4,  5,  5,  8,  10, 12, 12, 4,  5,  6,  5,  7,
    8,  9,  4,  4,  6,  3,  3,  4,  5,  2,  4,  7,  6,  1,  3,  4,  1,  5,  11,
    11, 4,  1,  4,  4,  8,  12, 12, 6,  1,  3,  33, 37, 41, 43, 44, 41, 38, 31,
    35, 39, 43, 44, 39, 36, 29, 34, 37, 42, 42, 38, 33, 28, 31, 34, 39, 41, 36,
    30, 26, 28, 31, 35, 37, 33, 31, 23, 24, 28, 32, 35, 34, 30, 21, 24, 27, 30,
    35, 34, 30, 30, 33, 38, 41, 40, 37, 32, 29, 31, 36, 40, 41, 37, 31, 28, 30,
    35, 37, 37, 34, 29, 26, 28, 31, 34, 34, 32, 26, 22, 25, 27, 30, 31, 29, 25,
    19, 23, 26, 29, 29, 28, 25, 14, 21, 25, 27, 27, 27, 25, 28, 31, 33, 34, 35,
    33, 28, 26, 30, 32, 33, 33, 31, 25, 22, 28, 30, 29, 30, 29, 23, 19, 27, 27,
    26, 28, 25, 19, 13, 22, 24, 23, 23, 22, 19, 10, 20, 22, 21, 21, 21, 20, 9,
    18, 20, 20, 20, 20, 18, 23, 26, 26, 27, 27, 27, 20, 18, 24, 25, 25, 26, 23,
    18, 15, 22, 23, 23, 22, 21, 17, 12, 19, 19, 19, 20, 17, 15, 10, 14, 16, 15,
    15, 13, 12, 9,  10, 15, 14, 14, 12, 9,  9,  7,  13, 13, 13, 12, 6,  11, 18,
    18, 19, 19, 15, 19, 7,  16, 16, 18, 17, 12, 18, 7,  12, 15, 14, 14, 10, 13,
    7,  7,  11, 11, 10, 6,  8,  5,  2,  7,  7,  6,  4,  5,  5,  3,  5,  4,  5,
    3,  4,  5,  4,  3,  3,  3,  3,  4,  3,  9,  9,  10, 12, 13, 17, 3,  7,  9,
    9,  11, 11, 12, 3,  4,  8,  7,  8,  8,  9,  3,  3,  4,  4,  4,  5,  4,  2,
    1,  3,  2,  0,  3,  4,  2,  3,  5,  4,  2,  2,  4,  3,  4,  5,  5,  3,  1,
    3,  4,  5,  6,  9,  11, 13, 13, 4,  5,  6,  8,  9,  10, 10, 4,  5,  6,  6,
    6,  7,  7,  4,  3,  5,  2,  2,  3,  3,  2,  3,  6,  5,  3,  1,  3,  2,  5,
    7,  6,  3,  2,  3,  4,  6,  7,  7,  4,  2,  2,  26, 31, 35, 39, 39, 35, 33,
    26, 30, 33, 39, 38, 36, 31, 24, 29, 32, 36, 37, 33, 29, 23, 26, 30, 33, 34,
    31, 26, 20, 24, 26, 29, 32, 29, 26, 18, 20, 23, 26, 30, 30, 26, 17, 18, 22,
    26, 29, 29, 26, 24, 28, 32, 36, 35, 33, 29, 24, 26, 31, 35, 34, 30, 27, 22,
    25, 29, 33, 31, 29, 24, 21, 24, 27, 29, 29, 27, 21, 18, 20, 23, 25, 25, 24,
    21, 16, 19, 21, 23, 23, 24, 21, 13, 17, 20, 23, 22, 22, 22, 22, 25, 28, 28,
    30, 28, 24, 21, 24, 27, 27, 28, 27, 22, 20, 23, 25, 25, 25, 25, 20, 17, 21,
    22, 21, 22, 22, 16, 11, 18, 18, 18, 18, 18, 16, 7,  17, 17, 16, 16, 17, 16,
    8,  15, 15, 15, 16, 16, 14, 20, 20, 20, 21, 23, 23, 16, 16, 19, 20, 20, 21,
    19, 14, 13, 18, 18, 18, 17, 17, 13, 9,  15, 15, 14, 14, 14, 11, 7,  12, 11,
    10, 10, 10, 8,  7,  8,  10, 9,  9,  9,  5,  7,  5,  8,  8,  7,  8,  3,  8,
    12, 13, 14, 14, 13, 15, 4,  11, 11, 12, 13, 10, 13, 4,  10, 9,  9,  9,  8,
    9,  4,  5,  6,  6,  5,  4,  5,  3,  2,  2,  2,  2,  2,  3,  3,  2,  3,  2,
    1,  2,  3,  4,  3,  5,  3,  2,  0,  3,  3,  6,  7,  8,  9,  11, 13, 3,  5,
    7,  8,  8,  9,  10, 3,  3,  5,  5,  6,  6,  6,  3,  3,  3,  2,  2,  3,  3,
    1,  4,  6,  4,  3,  0,  3,  2,  5,  8,  5,  3,  2,  2,  4,  7,  8,  7,  4,
    2,  2,  4,  6,  6,  7,  8,  10, 11, 4,  6,  6,  6,  7,  8,  8,  4,  6,  7,
    4,  4,  4,  6,  4,  6,  8,  4,  2,  1,  2,  3,  8,  9,  7,  4,  2,  2,  6,
    8,  10, 9,  5,  3,  0,  7,  9,  10, 9,  6,  4,  2,  21, 26, 31, 32, 34, 32,
    27, 20, 24, 28, 32, 34, 30, 25, 19, 22, 27, 30, 32, 28, 23, 18, 21, 24, 28,
    30, 26, 21, 15, 18, 21, 24, 27, 24, 21, 13, 15, 18, 21, 24, 24, 20, 12, 14,
    17, 21, 24, 25, 21, 20, 23, 26, 31, 29, 27, 24, 19, 22, 26, 29, 29, 26, 22,
    17, 21, 24, 27, 27, 24, 19, 16, 18, 21, 24, 23, 22, 17, 13, 15, 17, 20, 20,
    20, 17, 12, 13, 16, 19, 19, 19, 17, 9,  12, 15, 18, 17, 18, 17, 18, 20, 22,
    23, 25, 23, 18, 16, 19, 21, 22, 23, 21, 16, 15, 18, 19, 19, 19, 19, 15, 14,
    16, 16, 16, 16, 16, 12, 9,  12, 13, 13, 12, 13, 12, 6,  12, 12, 12, 11, 12,
    12, 6,  10, 11, 10, 11, 11, 10, 15, 15, 15, 16, 17, 18, 11, 13, 13, 14, 15,
    15, 15, 9,  10, 12, 12, 12, 12, 11, 8,  6,  11, 9,  8,  8,  8,  7,  4,  7,
    6,  6,  5,  5,  4,  5,  5,  5,  4,  4,  4,  2,  6,  4,  3,  3,  3,  3,  2,
    6,  7,  7,  8,  9,  10, 11, 2,  5,  6,  7,  7,  8,  9,  2,  4,  5,  4,  5,
    5,  5,  2,  2,  2,  2,  1,  2,  2,  1,  4,  4,  3,  2,  2,  2,  3,  5,  5,
    4,  2,  2,  1,  4,  6,  7,  4,  3,  3,  0,  3,  4,  5,  6,  7,  8,  10, 4,
    5,  5,  6,  6,  6,  7,  4,  7,  5,  4,  4,  4,  4,  4,  6,  5,  4,  3,  2,
    1,  4,  7,  8,  5,  4,  3,  0,  6,  7,  9,  7,  4,  3,  2,  6,  8,  10, 8,
    5,  3,  2,  7,  9,  7,  5,  6,  8,  8,  7,  9,  8,  5,  5,  5,  5,  7,  9,
    10, 5,  3,  2,  3,  7,  8,  11, 6,  4,  3,  1,  7,  9,  11, 8,  5,  3,  2,
    8,  9,  12, 11, 6,  4,  2,  8,  10, 12, 12, 8,  5,  3,  31, 34, 37, 39, 39,
    37, 34, 28, 33, 36, 38, 38, 35, 32, 27, 31, 34, 37, 37, 35, 31, 26, 28, 32,
    34, 35, 32, 27, 22, 25, 29, 30, 32, 29, 27, 18, 22, 24, 26, 30, 29, 27, 15,
    19, 23, 26, 29, 28, 27, 26, 31, 35, 36, 36, 34, 32, 26, 30, 34, 36, 37, 33,
    31, 24, 28, 31, 34, 34, 31, 28, 22, 26, 30, 32, 30, 30, 24, 20, 22, 25, 28,
    27, 26, 24, 16, 19, 22, 24, 25, 25, 24, 12, 16, 20, 24, 24, 25, 24, 24, 29,
    31, 31, 33, 30, 27, 23, 26, 29, 30, 31, 31, 26, 21, 26, 28, 28, 29, 29, 25,
    19, 23, 25, 24, 25, 25, 20, 12, 19, 20, 21, 21, 21, 20, 8,  16, 18, 18, 19,
    20, 20, 8,  13, 16, 16, 18, 18, 19, 21, 22, 24, 25, 25, 27, 18, 18, 20, 21,
    24, 23, 24, 17, 14, 19, 21, 21, 21, 21, 16, 11, 17, 17, 17, 17, 17, 15, 8,
    12, 12, 13, 13, 13, 11, 7,  9,  9,  10, 11, 12, 8,  9,  7,  7,  8,  9,  10,
    8,  10, 14, 15, 16, 17, 17, 18, 6,  12, 13, 15, 15, 14, 17, 6,  11, 11, 11,
    12, 11, 14, 6,  7,  8,  8,  8,  8,  7,  4,  2,  3,  3,  3,  5,  7,  3,  2,
    2,  2,  0,  3,  7,  5,  5,  4,  2,  2,  2,  5,  5,  6,  8,  9,  12, 15, 17,
    5,  5,  7,  8,  11, 13, 14, 5,  6,  6,  6,  8,  10, 11, 5,  5,  5,  5,  4,
    6,  6,  3,  3,  4,  3,  2,  2,  6,  0,  4,  5,  4,  2,  1,  5,  4,  4,  6,
    5,  2,  2,  3,  7,  9,  9,  8,  10, 13, 15, 7,  9,  10, 8,  8,  11, 13, 7,
    9,  11, 7,  6,  7,  9,  7,  8,  10, 6,  4,  3,  5,  5,  7,  9,  6,  3,  1,
    3,  4,  5,  9,  8,  3,  2,  1,  5,  6,  9,  9,  4,  2,  1,  37, 41, 44, 47,
    48, 44, 42, 35, 39, 43, 47, 48, 44, 40, 33, 38, 41, 45, 45, 42, 38, 32, 36,
    38, 42, 45, 40, 34, 29, 31, 35, 39, 39, 36, 34, 24, 28, 31, 33, 37, 37, 34,
    22, 25, 29, 32, 36, 36, 34, 33, 36, 41, 46, 42, 42, 39, 31, 36, 41, 44, 45,
    42, 36, 30, 34, 38, 41, 41, 39, 35, 29, 32, 36, 38, 39, 35, 30, 25, 29, 31,
    34, 33, 33, 30, 20, 25, 28, 32, 31, 31, 28, 16, 22, 26, 31, 30, 30, 30, 30,
    35, 36, 37, 39, 37, 33, 28, 33, 35, 36, 37, 36, 31, 26, 31, 33, 34, 34, 34,
    29, 22, 29, 30, 31, 31, 30, 24, 16, 24, 26, 26, 25, 26, 25, 11, 21, 23, 24,
    24, 24, 25, 10, 19, 21, 23, 23, 23, 22, 26, 29, 30, 31, 32, 33, 24, 21, 26,
    29, 30, 31, 29, 23, 18, 25, 27, 27, 27, 26, 21, 14, 22, 23, 23, 23, 22, 19,
    12, 16, 19, 19, 18, 17, 16, 11, 12, 15, 16, 16, 16, 12, 10, 8,  13, 14, 14,
    15, 9,  13, 20, 21, 22, 24, 21, 24, 10, 18, 20, 20, 22, 18, 22, 10, 15, 17,
    17, 18, 15, 17, 10, 9,  14, 14, 13, 10, 12, 8,  4,  9,  9,  9,  8,  9,  5,
    3,  5,  5,  6,  6,  9,  7,  5,  3,  3,  4,  5,  7,  6,  12, 13, 14, 17, 19,
    21, 6,  10, 11, 13, 15, 17, 18, 6,  6,  9,  10, 12, 13, 14, 6,  5,  6,  6,
    8,  9,  8,  4,  3,  3,  3,  3,  6,  7,  4,  0,  4,  3,  1,  4,  7,  3,  3,
    5,  3,  2,  3,  6,  6,  8,  8,  10, 15, 17, 19, 6,  8,  9,  9,  13, 15, 16,
    6,  8,  9,  7,  9,  11, 12, 6,  7,  8,  5,  5,  7,  6,  4,  5,  6,  5,  2,
    3,  7,  2,  4,  5,  4,  2,  1,  5,  3,  5,  5,  5,  3,  2,  4,  42, 47, 50,
    55, 55, 54, 48, 41, 45, 49, 54, 55, 52, 45, 39, 43, 47, 51, 52, 50, 45, 38,
    40, 45, 48, 51, 45, 39, 34, 38, 41, 44, 46, 42, 40, 31, 34, 38, 41, 44, 42,
    39, 27, 30, 35, 40, 42, 43, 40, 40, 43, 48, 51, 52, 48, 44, 38, 43, 47, 51,
    50, 46, 42, 35, 40, 45, 48, 48, 46, 42, 34, 38, 42, 44, 44, 42, 35, 29, 35,
    38, 41, 40, 38, 34, 22, 31, 34, 37, 37, 38, 34, 19, 29, 33, 35, 36, 37, 36,
    37, 40, 44, 44, 45, 44, 39, 33, 40, 42, 42, 43, 42, 37, 29, 38, 40, 41, 40,
    39, 34, 25, 35, 37, 36, 37, 35, 30, 20, 30, 33, 33, 32, 29, 29, 14, 26, 30,
    30, 29, 30, 29, 13, 23, 27, 29, 28, 28, 27, 29, 34, 36, 37, 39, 38, 30, 25,
    32, 34, 36, 36, 34, 27, 21, 30, 33, 32, 33, 30, 26, 18, 26, 29, 28, 29, 26,
    25, 16, 20, 25, 25, 24, 20, 21, 14, 14, 22, 21, 21, 20, 17, 14, 10, 19, 20,
    20, 19, 13, 17, 27, 28, 29, 29, 25, 30, 13, 22, 27, 27, 27, 22, 28, 13, 18,
    24, 23, 24, 18, 22, 13, 12, 20, 20, 19, 13, 17, 11, 7,  16, 15, 14, 9,  12,
    9,  5,  11, 11, 11, 8,  10, 9,  6,  8,  10, 10, 8,  9,  9,  15, 18, 20, 20,
    23, 26, 9,  12, 17, 18, 19, 20, 22, 9,  8,  15, 15, 16, 17, 17, 9,  7,  11,
    11, 12, 11, 11, 7,  5,  6,  6,  5,  8,  9,  5,  4,  0,  1,  4,  6,  9,  5,
    3,  2,  2,  3,  6,  8,  7,  8,  11, 16, 19, 21, 22, 7,  7,  9,  14, 18, 18,
    18, 8,  7,  8,  11, 14, 15, 15, 7,  6,  6,  7,  10, 10, 9,  6,  4,  5,  3,
    3,  5,  8,  4,  2,  4,  4,  2,  5,  7,  3,  2,  4,  4,  2,  4,  6,  42, 45,
    48, 52, 53, 51, 46, 40, 42, 47, 52, 52, 48, 43, 38, 42, 46, 49, 52, 47, 42,
    35, 40, 44, 46, 48, 45, 38, 32, 37, 39, 44, 44, 42, 38, 29, 33, 36, 39, 42,
    41, 37, 26, 30, 34, 38, 41, 41, 38, 38, 42, 46, 49, 48, 46, 43, 37, 40, 45,
    49, 48, 44, 40, 35, 38, 43, 47, 46, 42, 35, 33, 38, 40, 43, 41, 39, 33, 26,
    34, 36, 39, 38, 36, 32, 22, 29, 32, 36, 35, 35, 32, 17, 28, 32, 35, 34, 34,
    33, 35, 40, 42, 42, 44, 41, 35, 31, 39, 39, 42, 42, 39, 33, 28, 37, 39, 38,
    38, 37, 30, 24, 33, 34, 35, 35, 32, 28, 18, 28, 31, 31, 30, 29, 28, 13, 24,
    29, 28, 29, 28, 28, 13, 21, 27, 27, 27, 27, 25, 27, 34, 34, 35, 37, 33, 27,
    23, 30, 33, 34, 33, 31, 26, 20, 27, 32, 31, 30, 27, 24, 16, 24, 28, 28, 27,
    23, 23, 14, 17, 24, 23, 23, 18, 19, 13, 13, 21, 21, 20, 17, 16, 12, 9,  19,
    20, 19, 17, 11, 16, 24, 26, 27, 26, 23, 27, 12, 20, 25, 26, 24, 19, 26, 12,
    16, 23, 23, 21, 15, 20, 12, 10, 19, 19, 17, 10, 15, 10, 6,  15, 15, 12, 7,
    11, 9,  5,  11, 11, 11, 6,  8,  8,  5,  7,  9,  9,  6,  7,  8,  14, 18, 18,
    18, 19, 24, 8,  9,  16, 16, 17, 17, 19, 8,  6,  14, 13, 14, 14, 14, 8,  5,
    10, 9,  10, 9,  9,  6,  3,  5,  5,  4,  6,  7,  4,  3,  1,  0,  3,  5,  7,
    4,  3,  1,  2,  2,  4,  6,  6,  7,  11, 14, 17, 19, 20, 6,  7,  10, 13, 15,
    16, 16, 6,  6,  9,  10, 12, 13, 13, 6,  5,  5,  6,  8,  8,  7,  4,  4,  4,
    3,  3,  4,  6,  3,  2,  6,  6,  1,  4,  5,  2,  3,  6,  6,  2,  3,  4,  34,
    39, 42, 47, 46, 43, 40, 34, 37, 42, 46, 46, 43, 37, 32, 35, 40, 44, 45, 41,
    36, 31, 33, 37, 40, 42, 38, 32, 28, 30, 33, 37, 38, 36, 33, 25, 27, 29, 33,
    37, 36, 32, 23, 25, 28, 32, 35, 36, 32, 32, 35, 40, 44, 44, 40, 36, 32, 35,
    38, 43, 42, 38, 33, 30, 33, 38, 40, 40, 36, 31, 28, 31, 34, 37, 36, 34, 28,
    22, 29, 30, 34, 33, 30, 27, 19, 25, 27, 30, 30, 30, 28, 15, 25, 27, 29, 29,
    30, 27, 30, 34, 37, 36, 36, 34, 29, 27, 32, 34, 35, 36, 33, 28, 24, 30, 33,
    32, 32, 30, 25, 21, 29, 29, 30, 30, 27, 23, 15, 24, 26, 26, 25, 23, 22, 11,
    22, 24, 23, 23, 22, 22, 10, 19, 22, 22, 22, 22, 20, 25, 28, 28, 29, 30, 29,
    23, 20, 26, 27, 28, 28, 25, 20, 16, 24, 26, 25, 25, 22, 19, 13, 20, 22, 21,
    22, 18, 18, 11, 15, 19, 18, 17, 14, 14, 10, 11, 17, 15, 15, 14, 11, 10, 7,
    15, 14, 14, 13, 7,  12, 20, 20, 21, 21, 17, 22, 9,  17, 19, 20, 19, 14, 20,
    9,  13, 17, 17, 16, 11, 15, 9,  8,  14, 13, 12, 7,  10, 7,  3,  10, 9,  8,
    4,  7,  6,  3,  7,  6,  6,  3,  5,  5,  4,  5,  5,  4,  4,  4,  5,  10, 12,
    12, 13, 15, 19, 5,  8,  11, 11, 12, 13, 14, 4,  4,  10, 9,  9,  10, 10, 5,
    3,  6,  6,  6,  6,  5,  3,  2,  1,  1,  2,  3,  4,  2,  1,  4,  3,  0,  3,
    4,  3,  2,  4,  3,  2,  2,  3,  5,  5,  8,  10, 12, 14, 15, 5,  5,  7,  10,
    11, 12, 12, 5,  5,  6,  7,  8,  9,  9,  5,  4,  4,  4,  4,  5,  4,  3,  2,
    5,  4,  2,  2,  4,  1,  4,  5,  5,  2,  2,  3,  3,  4,  5,  5,  3,  0,  2,
    28, 33, 37, 40, 41, 38, 35, 28, 31, 36, 40, 39, 37, 33, 26, 29, 35, 38, 38,
    34, 31, 26, 28, 31, 35, 37, 33, 28, 23, 25, 28, 30, 34, 31, 27, 19, 22, 24,
    28, 32, 31, 27, 18, 21, 23, 27, 30, 31, 28, 27, 30, 34, 38, 36, 35, 30, 26,
    30, 32, 37, 37, 33, 28, 25, 28, 31, 34, 33, 32, 26, 23, 26, 28, 30, 30, 28,
    22, 20, 22, 25, 27, 27, 26, 22, 17, 20, 22, 25, 25, 25, 22, 13, 19, 21, 24,
    24, 25, 22, 25, 28, 29, 30, 31, 30, 25, 23, 26, 29, 30, 29, 28, 23, 21, 26,
    27, 27, 27, 27, 21, 18, 23, 23, 23, 24, 23, 17, 12, 20, 20, 20, 20, 19, 17,
    8,  19, 19, 18, 18, 18, 17, 8,  16, 17, 17, 17, 17, 15, 21, 22, 22, 23, 24,
    23, 17, 17, 21, 22, 22, 23, 21, 15, 13, 19, 20, 20, 19, 18, 14, 10, 16, 16,
    16, 16, 15, 13, 8,  12, 13, 12, 12, 11, 10, 8,  9,  11, 11, 10, 10, 6,  8,
    6,  10, 9,  9,  9,  4,  9,  14, 15, 16, 16, 13, 17, 5,  13, 13, 14, 14, 10,
    15, 6,  11, 11, 11, 11, 8,  10, 6,  6,  8,  7,  7,  5,  6,  4,  2,  4,  3,
    3,  3,  3,  3,  2,  2,  1,  2,  2,  3,  4,  2,  4,  2,  1,  2,  3,  3,  7,
    8,  9,  10, 12, 14, 3,  6,  7,  8,  9,  10, 10, 3,  4,  6,  6,  6,  7,  7,
    3,  3,  3,  3,  3,  4,  3,  1,  3,  5,  3,  2,  1,  3,  1,  5,  6,  4,  3,
    0,  3,  2,  5,  6,  6,  3,  2,  2,  4,  6,  6,  7,  9,  11, 12, 4,  7,  6,
    7,  8,  9,  9,  4,  6,  6,  5,  5,  5,  6,  4,  5,  6,  3,  2,  2,  2,  2,
    5,  7,  6,  3,  2,  2,  5,  6,  8,  7,  4,  2,  1,  5,  7,  8,  8,  5,  3,
    0,  24, 28, 32, 36, 35, 32, 29, 23, 26, 30, 34, 36, 32, 28, 21, 25, 29, 32,
    34, 31, 25, 19, 22, 26, 30, 32, 28, 23, 17, 20, 22, 26, 28, 27, 23, 15, 17,
    20, 23, 27, 26, 23, 14, 16, 19, 22, 25, 26, 23, 21, 24, 28, 34, 32, 28, 26,
    20, 24, 28, 31, 31, 28, 24, 18, 22, 26, 29, 28, 26, 22, 18, 20, 23, 25, 26,
    23, 19, 15, 17, 20, 22, 21, 21, 18, 13, 15, 18, 20, 20, 21, 19, 11, 13, 17,
    20, 19, 19, 18, 18, 22, 24, 25, 27, 25, 20, 17, 20, 23, 24, 24, 23, 19, 17,
    19, 22, 22, 21, 22, 17, 14, 18, 18, 18, 18, 18, 14, 10, 14, 15, 15, 15, 15,
    14, 6,  13, 14, 13, 13, 14, 13, 6,  12, 12, 12, 12, 13, 12, 17, 17, 17, 18,
    20, 20, 13, 14, 15, 16, 17, 17, 17, 11, 11, 14, 14, 14, 14, 13, 10, 7,  12,
    11, 11, 11, 10, 9,  5,  9,  8,  7,  7,  7,  5,  6,  7,  7,  6,  6,  6,  3,
    7,  4,  5,  5,  5,  5,  3,  7,  9,  9,  10, 11, 11, 13, 2,  7,  8,  9,  9,
    8,  11, 2,  6,  6,  6,  6,  6,  7,  2,  3,  3,  2,  2,  3,  3,  1,  2,  2,
    2,  2,  0,  2,  2,  4,  5,  4,  2,  1,  2,  3,  6,  7,  4,  3,  2,  2,  3,
    4,  5,  7,  8,  10, 11, 3,  4,  5,  6,  7,  7,  8,  3,  5,  4,  4,  4,  5,
    5,  3,  4,  5,  3,  2,  1,  2,  3,  6,  8,  5,  4,  2,  2,  4,  8,  10, 7,
    4,  3,  0,  6,  9,  10, 8,  5,  3,  1,  6,  8,  6,  5,  7,  8,  9,  6,  8,
    8,  6,  6,  6,  7,  6,  8,  9,  5,  3,  3,  4,  6,  7,  10, 7,  5,  2,  0,
    7,  9,  10, 8,  5,  3,  2,  8,  10, 11, 10, 6,  4,  2,  9,  10, 11, 11, 7,
    5,  3,  33, 37, 40, 43, 42, 41, 37, 32, 36, 40, 42, 42, 40, 36, 30, 34, 38,
    40, 41, 37, 34, 29, 32, 36, 37, 38, 33, 27, 25, 28, 32, 33, 32, 29, 28, 22,
    24, 27, 28, 32, 29, 28, 16, 20, 24, 27, 29, 30, 28, 30, 34, 38, 40, 40, 38,
    35, 29, 33, 37, 42, 40, 37, 34, 27, 31, 35, 38, 36, 34, 30, 26, 29, 32, 34,
    34, 32, 25, 23, 26, 28, 31, 28, 27, 25, 18, 22, 24, 25, 27, 26, 25, 13, 17,
    21, 24, 24, 25, 24, 27, 32, 33, 35, 36, 35, 31, 26, 29, 33, 34, 35, 34, 29,
    24, 29, 31, 31, 31, 31, 26, 20, 26, 27, 28, 28, 26, 21, 14, 22, 24, 24, 22,
    21, 21, 8,  17, 19, 19, 19, 20, 21, 7,  14, 17, 17, 18, 19, 19, 24, 25, 26,
    28, 30, 30, 24, 20, 24, 25, 27, 27, 27, 22, 17, 23, 24, 24, 24, 23, 20, 13,
    19, 20, 20, 20, 19, 17, 11, 14, 16, 16, 14, 13, 14, 8,  9,  11, 10, 11, 12,
    10, 7,  5,  8,  9,  10, 10, 9,  12, 18, 19, 20, 22, 22, 23, 9,  17, 18, 19,
    20, 19, 22, 9,  15, 16, 16, 16, 16, 16, 9,  11, 13, 13, 12, 10, 10, 6,  5,
    8,  8,  4,  6,  8,  4,  3,  1,  2,  3,  5,  8,  3,  2,  2,  1,  2,  4,  7,
    8,  12, 14, 15, 18, 21, 22, 8,  10, 12, 14, 16, 18, 18, 8,  8,  10, 10, 13,
    14, 14, 8,  7,  7,  7,  8,  9,  7,  6,  5,  6,  5,  3,  4,  7,  3,  3,  5,
    4,  3,  2,  6,  0,  3,  5,  5,  3,  2,  5,  8,  11, 11, 11, 16, 19, 20, 9,
    11, 12, 10, 14, 16, 17, 9,  11, 12, 9,  10, 12, 13, 9,  10, 11, 8,  6,  6,
    6,  7,  8,  10, 7,  4,  2,  5,  5,  7,  8,  7,  4,  3,  3,  4,  5,  7,  8,
    4,  3,  2,  39, 43, 46, 51, 52, 48, 44, 38, 42, 45, 50, 49, 46, 43, 36, 39,
    44, 48, 48, 45, 39, 35, 38, 42, 44, 45, 40, 34, 31, 35, 36, 40, 41, 37, 34,
    27, 30, 33, 34, 38, 38, 34, 22, 26, 29, 34, 37, 37, 33, 36, 40, 46, 48, 48,
    43, 41, 34, 38, 42, 47, 47, 42, 38, 32, 36, 41, 43, 44, 41, 35, 31, 34, 38,
    41, 40, 37, 30, 27, 32, 34, 36, 34, 33, 30, 21, 27, 30, 31, 32, 33, 30, 15,
    23, 25, 30, 30, 30, 29, 33, 36, 40, 41, 42, 40, 35, 31, 35, 38, 40, 41, 39,
    33, 28, 34, 37, 38, 36, 36, 31, 24, 31, 33, 33, 33, 31, 26, 17, 27, 28, 29,
    27, 26, 26, 12, 22, 25, 24, 24, 25, 26, 10, 18, 22, 23, 23, 24, 24, 27, 31,
    32, 34, 35, 35, 28, 23, 30, 31, 32, 32, 33, 25, 20, 28, 30, 29, 29, 28, 24,
    16, 24, 25, 26, 25, 22, 22, 13, 18, 21, 21, 18, 18, 18, 12, 11, 17, 16, 16,
    17, 14, 10, 7,  15, 14, 15, 15, 11, 15, 23, 24, 25, 26, 25, 28, 12, 20, 22,
    24, 24, 22, 26, 12, 17, 21, 21, 20, 18, 20, 12, 11, 17, 16, 16, 12, 14, 10,
    5,  13, 12, 9,  8,  10, 7,  5,  7,  6,  7,  7,  9,  5,  4,  4,  4,  5,  7,
    8,  9,  16, 18, 19, 22, 23, 25, 9,  13, 16, 18, 20, 20, 22, 9,  9,  14, 14,
    16, 17, 16, 9,  8,  10, 10, 12, 11, 9,  7,  6,  5,  5,  4,  7,  9,  4,  3,
    3,  3,  2,  5,  9,  4,  0,  3,  4,  2,  4,  7,  9,  9,  10, 15, 19, 22, 22,
    9,  9,  10, 13, 18, 19, 19, 9,  9,  11, 11, 13, 15, 14, 9,  8,  10, 7,  9,
    9,  7,  7,  7,  8,  6,  3,  4,  7,  5,  5,  6,  5,  3,  3,  6,  2,  4,  5,
    5,  3,  2,  5,  44, 47, 53, 55, 56, 52, 48, 42, 47, 51, 53, 55, 51, 47, 41,
    45, 50, 51, 54, 50, 44, 39, 42, 44, 49, 50, 47, 40, 36, 39, 42, 46, 46, 42,
    39, 31, 34, 38, 40, 44, 43, 39, 27, 31, 35, 39, 42, 43, 39, 40, 45, 49, 52,
    52, 48, 45, 39, 44, 47, 52, 50, 47, 42, 36, 42, 45, 48, 49, 45, 39, 35, 39,
    42, 44, 44, 41, 34, 28, 36, 39, 41, 39, 38, 35, 23, 32, 35, 36, 37, 36, 35,
    18, 29, 32, 36, 35, 36, 34, 36, 42, 44, 45, 47, 44, 38, 33, 41, 41, 45, 45,
    43, 37, 30, 39, 40, 41, 41, 39, 34, 25, 35, 37, 37, 37, 36, 30, 20, 31, 34,
    34, 31, 30, 30, 15, 26, 30, 29, 30, 29, 30, 13, 22, 28, 28, 28, 29, 28, 29,
    35, 36, 38, 39, 38, 31, 26, 34, 36, 37, 37, 35, 29, 22, 31, 34, 33, 34, 31,
    27, 18, 27, 30, 29, 30, 26, 25, 16, 20, 26, 25, 24, 21, 22, 15, 14, 22, 21,
    21, 20, 17, 14, 10, 19, 20, 20, 19, 14, 17, 25, 28, 30, 29, 26, 31, 14, 23,
    27, 28, 28, 23, 29, 14, 19, 25, 25, 24, 20, 24, 14, 13, 21, 20, 21, 13, 16,
    12, 8,  16, 16, 13, 10, 13, 9,  5,  11, 11, 12, 9,  11, 9,  6,  8,  10, 10,
    8,  10, 10, 16, 19, 21, 22, 24, 27, 10, 12, 18, 20, 21, 22, 23, 9,  8,  17,
    16, 17, 18, 18, 10, 8,  13, 12, 13, 12, 11, 8,  5,  7,  7,  5,  8,  10, 6,
    5,  2,  1,  4,  7,  9,  5,  3,  0,  2,  4,  6,  8,  9,  8,  12, 17, 21, 23,
    24, 9,  8,  11, 16, 20, 20, 20, 9,  8,  9,  13, 15, 16, 16, 8,  7,  7,  8,
    11, 11, 9,  6,  5,  5,  3,  4,  5,  8,  4,  3,  4,  4,  2,  5,  7,  3,  2,
    4,  4,  2,  4,  6,  44, 48, 53, 55, 55, 53, 49, 41, 48, 50, 54, 54, 52, 48,
    40, 44, 49, 52, 53, 49, 44, 39, 42, 47, 48, 51, 47, 42, 35, 39, 42, 45, 46,
    44, 40, 31, 34, 38, 42, 44, 43, 40, 27, 33, 36, 39, 43, 43, 40, 41, 44, 48,
    53, 53, 48, 43, 39, 45, 48, 51, 50, 47, 42, 36, 42, 46, 48, 48, 46, 39, 33,
    40, 43, 46, 45, 42, 35, 28, 36, 40, 41, 40, 38, 35, 22, 32, 35, 39, 38, 37,
    35, 18, 29, 34, 37, 35, 36, 36, 36, 41, 44, 45, 46, 44, 37, 34, 39, 43, 44,
    43, 41, 35, 29, 39, 41, 41, 40, 39, 33, 26, 37, 37, 37, 37, 36, 30, 19, 31,
    34, 34, 32, 30, 29, 15, 26, 31, 30, 30, 29, 29, 14, 21, 30, 29, 29, 28, 27,
    30, 36, 38, 38, 38, 36, 30, 25, 33, 35, 37, 35, 33, 28, 21, 30, 34, 34, 32,
    30, 26, 17, 24, 31, 30, 30, 24, 25, 15, 19, 26, 27, 24, 20, 21, 15, 14, 24,
    23, 22, 19, 17, 14, 10, 20, 22, 21, 18, 14, 16, 25, 29, 30, 27, 24, 30, 13,
    22, 27, 28, 26, 20, 28, 13, 17, 25, 24, 23, 17, 23, 13, 12, 21, 21, 19, 12,
    17, 11, 7,  17, 17, 13, 8,  13, 10, 6,  12, 13, 12, 7,  10, 9,  6,  8,  12,
    11, 7,  9,  9,  14, 19, 20, 19, 22, 26, 9,  10, 18, 18, 18, 19, 22, 9,  6,
    16, 15, 15, 16, 16, 9,  5,  12, 12, 11, 11, 10, 7,  4,  6,  7,  5,  7,  8,
    5,  3,  2,  2,  3,  5,  8,  5,  3,  2,  0,  3,  5,  7,  7,  7,  12, 16, 18,
    20, 22, 7,  7,  11, 14, 17, 17, 18, 7,  7,  9,  12, 13, 14, 14, 7,  6,  5,
    8,  9,  9,  8,  5,  4,  3,  2,  4,  5,  7,  3,  2,  5,  4,  2,  4,  6,  3,
    1,  5,  5,  1,  4,  5,  38, 42, 47, 47, 48, 47, 43, 36, 41, 44, 48, 49, 45,
    41, 34, 39, 43, 45, 47, 44, 38, 33, 36, 40, 43, 45, 41, 34, 31, 33, 37, 39,
    41, 39, 35, 26, 29, 32, 35, 39, 37, 35, 23, 28, 31, 34, 38, 38, 34, 34, 39,
    43, 47, 46, 41, 38, 34, 38, 41, 45, 44, 40, 36, 31, 35, 40, 43, 42, 39, 33,
    29, 34, 36, 40, 39, 36, 30, 24, 30, 33, 36, 35, 33, 30, 21, 27, 30, 32, 32,
    32, 29, 16, 26, 29, 31, 31, 31, 30, 31, 35, 38, 39, 39, 37, 31, 29, 35, 37,
    38, 38, 35, 30, 26, 32, 35, 35, 36, 33, 27, 22, 31, 32, 31, 32, 30, 24, 16,
    26, 27, 28, 27, 25, 24, 11, 24, 25, 26, 25, 24, 24, 11, 20, 24, 24, 24, 24,
    22, 25, 30, 30, 31, 32, 30, 24, 21, 29, 28, 30, 31, 28, 22, 18, 26, 28, 28,
    27, 24, 21, 15, 21, 24, 25, 24, 20, 20, 12, 15, 21, 20, 20, 16, 16, 11, 12,
    18, 18, 17, 15, 12, 11, 8,  17, 17, 16, 15, 9,  13, 21, 23, 24, 23, 19, 24,
    10, 19, 22, 22, 21, 16, 23, 10, 14, 19, 19, 18, 13, 17, 10, 9,  16, 16, 15,
    8,  12, 8,  4,  12, 12, 10, 5,  9,  7,  4,  9,  8,  8,  4,  6,  7,  4,  6,
    7,  7,  4,  5,  6,  12, 14, 15, 15, 17, 20, 6,  8,  12, 13, 14, 14, 16, 6,
    5,  11, 10, 11, 11, 12, 6,  4,  8,  7,  7,  7,  6,  4,  2,  2,  2,  3,  4,
    5,  2,  2,  3,  3,  2,  3,  5,  3,  2,  4,  3,  0,  3,  4,  5,  5,  10, 12,
    14, 16, 17, 5,  6,  9,  11, 12, 13, 13, 5,  6,  8,  9,  9,  10, 10, 5,  5,
    4,  5,  6,  6,  5,  3,  2,  3,  3,  1,  3,  4,  2,  3,  5,  4,  2,  2,  4,
    2,  4,  5,  4,  3,  2,  3,  31, 36, 40, 43, 43, 40, 36, 30, 33, 38, 43, 43,
    39, 35, 28, 32, 37, 39, 42, 37, 33, 28, 30, 33, 36, 40, 35, 29, 25, 27, 29,
    33, 35, 32, 29, 21, 24, 26, 30, 34, 32, 29, 20, 21, 26, 29, 32, 32, 29, 29,
    32, 36, 40, 38, 35, 33, 29, 31, 35, 38, 37, 35, 30, 26, 30, 33, 36, 36, 32,
    29, 25, 28, 30, 33, 33, 31, 24, 20, 25, 27, 29, 29, 27, 24, 18, 22, 25, 27,
    27, 27, 24, 14, 21, 24, 26, 26, 26, 24, 26, 30, 32, 33, 34, 32, 27, 25, 29,
    30, 31, 31, 30, 25, 23, 27, 29, 29, 29, 28, 22, 18, 26, 25, 26, 26, 24, 19,
    13, 22, 22, 22, 22, 21, 19, 9,  20, 20, 20, 20, 20, 19, 9,  17, 20, 18, 19,
    19, 17, 23, 24, 24, 26, 27, 25, 19, 18, 23, 23, 25, 24, 22, 17, 14, 22, 22,
    21, 22, 19, 16, 11, 18, 19, 18, 18, 16, 14, 9,  13, 15, 14, 14, 12, 11, 9,
    10, 13, 12, 12, 12, 8,  9,  7,  12, 11, 11, 11, 5,  10, 17, 17, 18, 18, 15,
    19, 7,  15, 16, 16, 16, 12, 17, 6,  12, 13, 13, 13, 9,  12, 7,  6,  10, 9,
    9,  6,  7,  5,  2,  6,  5,  5,  3,  5,  4,  2,  4,  3,  3,  3,  4,  4,  3,
    2,  2,  2,  2,  3,  4,  9,  9,  10, 11, 13, 16, 4,  7,  9,  9,  10, 11, 12,
    4,  4,  8,  7,  8,  8,  8,  4,  3,  4,  4,  4,  5,  4,  2,  1,  4,  3,  1,
    2,  3,  2,  3,  6,  4,  2,  2,  3,  2,  5,  6,  5,  3,  0,  3,  4,  5,  6,
    8,  10, 12, 13, 4,  5,  6,  8,  9,  10, 10, 4,  5,  6,  5,  6,  6,  7,  4,
    4,  6,  3,  2,  3,  3,  2,  4,  8,  5,  3,  0,  3,  3,  6,  7,  7,  4,  2,
    2,  5,  7,  7,  8,  5,  2,  2,  25, 28, 34, 37, 37, 34, 31, 24, 28, 32, 36,
    37, 32, 29, 23, 26, 30, 34, 36, 32, 27, 22, 24, 28, 31, 34, 30, 24, 19, 21,
    24, 27, 31, 28, 24, 17, 18, 21, 24, 29, 28, 24, 15, 17, 21, 24, 27, 27, 24,
    23, 27, 31, 34, 33, 30, 27, 22, 25, 29, 33, 33, 28, 25, 20, 24, 28, 31, 30,
    27, 24, 20, 22, 24, 28, 27, 26, 20, 17, 18, 21, 23, 24, 23, 20, 15, 17, 19,
    21, 22, 22, 20, 12, 16, 19, 21, 21, 21, 20, 21, 24, 26, 27, 28, 26, 22, 20,
    23, 24, 25, 26, 25, 20, 19, 21, 23, 23, 23, 22, 18, 16, 20, 20, 20, 19, 19,
    14, 10, 16, 16, 16, 16, 16, 14, 7,  16, 15, 15, 15, 15, 15, 7,  14, 14, 14,
    14, 14, 13, 18, 19, 19, 20, 21, 21, 14, 15, 17, 18, 19, 19, 18, 12, 12, 16,
    16, 16, 15, 15, 11, 8,  14, 13, 12, 12, 12, 10, 6,  10, 9,  9,  8,  8,  7,
    6,  8,  8,  7,  7,  7,  4,  7,  4,  6,  6,  6,  6,  3,  8,  11, 11, 12, 13,
    12, 14, 3,  9,  10, 10, 11, 9,  12, 4,  8,  8,  7,  7,  7,  8,  3,  4,  4,
    4,  3,  3,  3,  1,  1,  1,  1,  1,  1,  3,  2,  3,  4,  3,  2,  0,  2,  3,
    5,  5,  3,  2,  2,  2,  3,  5,  6,  7,  8,  10, 12, 3,  4,  6,  7,  7,  8,
    9,  3,  4,  4,  4,  5,  5,  6,  3,  3,  4,  3,  2,  2,  2,  1,  5,  6,  4,
    3,  2,  2,  3,  6,  8,  6,  3,  2,  1,  5,  7,  8,  7,  4,  3,  0,  5,  7,
    6,  6,  8,  9,  10, 5,  7,  6,  6,  6,  7,  7,  5,  7,  8,  4,  3,  4,  4,
    5,  7,  8,  5,  3,  2,  1,  5,  8,  9,  7,  4,  3,  0,  6,  8,  10, 9,  5,
    3,  2,  7,  9,  10, 10, 6,  4,  2,  31, 36, 39, 41, 40, 39, 36, 31, 35, 38,
    41, 41, 38, 36, 30, 33, 36, 40, 42, 39, 36, 29, 32, 36, 39, 41, 39, 38, 28,
    31, 35, 38, 42, 40, 37, 28, 30, 34, 38, 41, 42, 36, 25, 29, 33, 37, 40, 40,
    37, 29, 32, 36, 40, 38, 35, 32, 28, 32, 35, 38, 38, 34, 32, 27, 30, 34, 38,
    38, 34, 32, 25, 29, 34, 36, 37, 36, 32, 25, 29, 32, 36, 36, 36, 33, 24, 28,
    32, 35, 36, 35, 32, 21, 26, 30, 34, 34, 35, 32, 27, 31, 31, 32, 33, 30, 25,
    27, 29, 30, 30, 32, 29, 25, 24, 28, 29, 30, 30, 30, 25, 21, 27, 28, 29, 30,
    30, 25, 19, 27, 28, 28, 29, 30, 26, 15, 24, 26, 28, 28, 28, 26, 16, 22, 25,
    26, 26, 26, 25, 24, 25, 25, 25, 25, 22, 13, 22, 23, 23, 25, 24, 21, 14, 17,
    22, 22, 23, 22, 20, 15, 14, 22, 21, 22, 23, 20, 17, 15, 19, 20, 21, 21, 19,
    14, 15, 17, 19, 19, 19, 18, 10, 16, 14, 17, 17, 18, 17, 8,  12, 16, 16, 17,
    15, 10, 12, 9,  15, 15, 15, 14, 10, 13, 9,  13, 13, 13, 13, 8,  12, 9,  9,
    13, 13, 12, 9,  10, 10, 7,  11, 11, 11, 6,  8,  10, 9,  8,  9,  9,  5,  8,
    12, 11, 9,  7,  7,  4,  7,  4,  6,  6,  6,  7,  9,  10, 4,  4,  4,  5,  5,
    9,  10, 4,  2,  2,  3,  5,  7,  9,  4,  2,  1,  1,  3,  6,  8,  5,  4,  4,
    4,  4,  4,  7,  7,  6,  8,  6,  4,  4,  6,  9,  9,  9,  7,  5,  4,  5,  0,
    4,  3,  1,  4,  7,  9,  0,  4,  4,  2,  4,  6,  8,  0,  4,  5,  2,  2,  5,
    8,  0,  3,  4,  2,  2,  4,  6,  2,  4,  5,  5,  5,  4,  5,  5,  6,  8,  8,
    5,  5,  4,  8,  8,  9,  9,  6,  5,  4,  37, 41, 45, 47, 47, 45, 41, 37, 40,
    44, 46, 48, 46, 42, 36, 39, 42, 47, 47, 46, 43, 34, 37, 41, 45, 48, 46, 42,
    34, 37, 41, 45, 49, 46, 42, 33, 36, 41, 44, 47, 45, 42, 30, 35, 38, 43, 47,
    46, 42, 36, 39, 42, 45, 43, 41, 36, 34, 37, 41, 44, 44, 39, 36, 33, 36, 40,
    42, 43, 40, 36, 32, 36, 38, 43, 42, 42, 37, 30, 35, 38, 42, 41, 40, 37, 28,
    34, 38, 41, 41, 40, 37, 25, 31, 36, 40, 40, 40, 37, 33, 36, 38, 38, 37, 34,
    28, 31, 34, 36, 38, 36, 34, 28, 28, 34, 36, 36, 35, 34, 29, 25, 34, 34, 36,
    36, 34, 30, 22, 32, 34, 35, 35, 34, 30, 19, 30, 33, 33, 33, 32, 30, 18, 28,
    31, 31, 32, 32, 28, 28, 31, 31, 30, 29, 25, 16, 25, 29, 29, 30, 28, 24, 18,
    21, 28, 28, 28, 27, 23, 20, 17, 26, 29, 27, 27, 23, 23, 18, 23, 27, 27, 26,
    22, 19, 19, 20, 25, 25, 25, 21, 15, 18, 17, 23, 24, 24, 21, 11, 16, 22, 22,
    22, 16, 12, 16, 12, 19, 21, 21, 16, 11, 18, 13, 16, 19, 19, 16, 9,  15, 13,
    12, 19, 19, 15, 11, 14, 14, 10, 17, 17, 13, 8,  11, 13, 11, 14, 14, 12, 7,
    10, 14, 13, 12, 13, 11, 6,  8,  7,  11, 12, 9,  9,  11, 13, 7,  8,  10, 8,
    7,  9,  12, 7,  5,  8,  7,  6,  8,  10, 7,  4,  7,  6,  6,  8,  10, 8,  6,
    5,  5,  4,  6,  9,  9,  8,  8,  7,  5,  6,  8,  11, 9,  8,  7,  6,  5,  7,
    4,  0,  2,  4,  6,  9,  11, 4,  0,  2,  3,  5,  7,  10, 4,  0,  3,  2,  6,
    9,  10, 4,  1,  3,  2,  4,  5,  8,  4,  3,  5,  5,  5,  5,  7,  6,  6,  8,
    8,  6,  5,  6,  7,  9,  8,  8,  7,  5,  6,  36, 40, 42, 44, 44, 42, 39, 35,
    38, 42, 44, 45, 42, 38, 34, 37, 41, 44, 45, 42, 40, 33, 37, 41, 45, 46, 43,
    40, 33, 36, 40, 43, 47, 44, 39, 32, 35, 39, 43, 46, 44, 40, 30, 34, 38, 41,
    45, 44, 39, 34, 37, 40, 43, 41, 36, 34, 32, 35, 39, 42, 42, 37, 33, 31, 35,
    38, 40, 41, 37, 34, 31, 35, 37, 41, 41, 39, 34, 29, 35, 36, 40, 39, 39, 35,
    27, 33, 36, 39, 39, 38, 35, 24, 31, 35, 38, 37, 37, 35, 31, 34, 36, 35, 35,
    31, 24, 29, 33, 34, 35, 34, 31, 24, 27, 33, 34, 34, 32, 31, 26, 23, 33, 33,
    34, 33, 31, 27, 21, 31, 33, 33, 33, 29, 27, 18, 29, 32, 31, 31, 30, 28, 18,
    27, 30, 30, 31, 29, 25, 27, 29, 28, 28, 27, 22, 14, 22, 28, 27, 27, 25, 20,
    16, 19, 26, 27, 27, 25, 20, 18, 15, 24, 27, 26, 25, 20, 21, 17, 22, 25, 25,
    24, 19, 17, 17, 19, 24, 25, 23, 18, 14, 18, 16, 22, 22, 22, 18, 10, 14, 20,
    20, 20, 14, 8,  14, 11, 18, 19, 19, 14, 8,  15, 11, 14, 19, 18, 13, 7,  14,
    11, 11, 18, 18, 13, 7,  13, 13, 9,  16, 16, 12, 6,  9,  12, 11, 14, 14, 11,
    6,  7,  14, 13, 12, 12, 10, 6,  7,  6,  10, 11, 7,  5,  7,  10, 6,  7,  9,
    7,  5,  7,  9,  6,  3,  8,  6,  5,  7,  8,  6,  4,  7,  6,  4,  6,  7,  7,
    6,  5,  5,  6,  6,  7,  9,  8,  11, 11, 8,  6,  7,  11, 10, 12, 12, 10, 6,
    6,  3,  2,  0,  3,  4,  6,  8,  3,  2,  2,  2,  4,  5,  7,  3,  2,  3,  2,
    4,  6,  7,  3,  2,  6,  4,  4,  5,  6,  4,  5,  10, 11, 9,  6,  6,  6,  10,
    15, 16, 11, 7,  6,  9,  14, 17, 17, 13, 8,  6,  28, 32, 36, 38, 38, 36, 32,
    29, 31, 35, 38, 39, 36, 32, 27, 31, 34, 37, 39, 36, 33, 26, 30, 34, 37, 40,
    37, 34, 27, 30, 33, 36, 40, 38, 34, 26, 29, 32, 36, 39, 38, 34, 24, 27, 30,
    35, 37, 38, 34, 28, 30, 34, 36, 34, 30, 27, 26, 28, 32, 35, 34, 31, 27, 25,
    28, 32, 34, 34, 32, 28, 24, 28, 31, 35, 34, 32, 28, 24, 28, 31, 34, 34, 34,
    29, 23, 27, 29, 33, 33, 33, 29, 21, 25, 28, 31, 32, 31, 29, 26, 29, 29, 28,
    29, 25, 19, 25, 26, 28, 28, 28, 25, 19, 23, 26, 27, 28, 28, 25, 20, 19, 26,
    27, 28, 27, 26, 22, 17, 25, 27, 26, 26, 25, 22, 15, 25, 25, 25, 26, 24, 22,
    16, 22, 24, 24, 24, 24, 20, 22, 23, 22, 21, 21, 17, 8,  18, 22, 21, 21, 20,
    16, 10, 15, 21, 21, 21, 20, 16, 13, 12, 20, 21, 20, 19, 16, 16, 14, 18, 21,
    20, 19, 15, 12, 15, 16, 18, 18, 17, 15, 9,  16, 15, 16, 17, 16, 14, 6,  11,
    15, 15, 14, 10, 5,  8,  7,  14, 13, 13, 10, 5,  10, 8,  11, 12, 12, 10, 5,
    9,  7,  9,  12, 12, 10, 5,  8,  9,  7,  11, 11, 9,  6,  6,  10, 9,  10, 9,
    8,  6,  5,  13, 13, 13, 10, 8,  7,  5,  3,  6,  5,  4,  3,  4,  6,  3,  4,
    4,  3,  3,  4,  5,  3,  2,  2,  2,  3,  4,  6,  3,  2,  4,  4,  4,  5,  5,
    5,  6,  9,  9,  8,  7,  5,  7,  10, 16, 14, 10, 7,  6,  11, 15, 17, 15, 12,
    8,  6,  2,  4,  3,  0,  2,  3,  4,  2,  4,  4,  2,  2,  3,  5,  2,  4,  5,
    3,  2,  3,  4,  2,  6,  9,  7,  6,  5,  5,  5,  9,  13, 12, 11, 8,  6,  9,
    14, 18, 18, 13, 10, 7,  14, 18, 19, 19, 15, 11, 7,  24, 27, 30, 33, 32, 30,
    27, 24, 26, 29, 32, 33, 31, 27, 22, 25, 28, 31, 33, 31, 29, 21, 25, 28, 32,
    34, 32, 29, 22, 25, 27, 31, 35, 33, 29, 21, 24, 27, 30, 34, 33, 29, 19, 22,
    25, 29, 33, 33, 28, 21, 24, 28, 30, 29, 25, 23, 21, 24, 27, 30, 29, 25, 22,
    20, 22, 26, 29, 28, 27, 23, 20, 22, 26, 29, 28, 27, 24, 21, 23, 26, 29, 29,
    27, 23, 19, 21, 24, 28, 27, 27, 24, 16, 20, 23, 26, 26, 26, 24, 20, 22, 23,
    23, 23, 20, 15, 19, 22, 22, 23, 22, 20, 16, 19, 20, 22, 23, 22, 21, 17, 16,
    22, 23, 23, 23, 21, 18, 15, 21, 21, 21, 22, 21, 18, 13, 19, 20, 20, 21, 20,
    17, 17, 18, 19, 19, 19, 20, 17, 19, 17, 16, 17, 16, 13, 5,  16, 16, 16, 16,
    15, 12, 6,  13, 16, 15, 16, 15, 13, 9,  10, 16, 16, 15, 15, 13, 12, 11, 14,
    14, 14, 14, 12, 8,  12, 13, 13, 13, 13, 12, 6,  17, 18, 13, 12, 12, 11, 5,
    8,  10, 9,  9,  8,  3,  5,  5,  9,  8,  8,  7,  3,  6,  5,  8,  7,  7,  7,
    3,  5,  5,  6,  7,  7,  7,  5,  5,  6,  7,  7,  7,  8,  7,  5,  9,  12, 14,
    12, 9,  8,  6,  15, 18, 17, 13, 10, 8,  6,  2,  1,  1,  1,  2,  3,  3,  2,
    3,  2,  1,  1,  3,  4,  2,  3,  3,  3,  2,  3,  4,  2,  5,  7,  7,  6,  5,
    6,  5,  10, 13, 12, 11, 8,  6,  10, 15, 19, 17, 12, 9,  7,  16, 19, 21, 18,
    14, 10, 8,  4,  6,  4,  2,  0,  2,  3,  4,  6,  5,  3,  1,  2,  3,  4,  6,
    7,  5,  5,  3,  4,  4,  8,  12, 9,  8,  7,  7,  8,  12, 16, 15, 13, 10, 8,
    13, 16, 20, 21, 15, 11, 9,  18, 22, 21, 21, 17, 13, 9,  19, 23, 25, 29, 28,
    25, 22, 19, 21, 24, 27, 28, 26, 23, 17, 20, 24, 27, 30, 27, 24, 17, 20, 24,
    28, 30, 29, 25, 18, 20, 23, 27, 31, 28, 25, 16, 19, 22, 26, 29, 29, 25, 16,
    18, 22, 25, 28, 29, 26, 18, 20, 23, 25, 23, 21, 18, 16, 19, 23, 25, 25, 21,
    19, 15, 18, 21, 25, 24, 22, 20, 15, 19, 22, 25, 24, 23, 20, 16, 18, 21, 24,
    24, 23, 21, 14, 17, 20, 23, 23, 23, 20, 18, 18, 19, 22, 22, 22, 21, 15, 18,
    19, 19, 19, 16, 13, 15, 17, 18, 18, 18, 17, 13, 15, 16, 18, 18, 18, 18, 14,
    14, 17, 18, 18, 18, 18, 15, 12, 15, 17, 17, 17, 17, 15, 13, 15, 16, 17, 16,
    16, 15, 20, 19, 16, 15, 15, 15, 13, 15, 13, 12, 12, 12, 11, 2,  14, 12, 12,
    11, 11, 10, 3,  11, 11, 11, 12, 11, 11, 6,  7,  11, 11, 11, 11, 10, 9,  9,
    10, 10, 10, 10, 10, 6,  13, 14, 13, 11, 9,  9,  6,  19, 21, 16, 13, 10, 8,
    7,  6,  5,  5,  5,  4,  2,  3,  2,  4,  4,  3,  3,  2,  3,  2,  2,  2,  3,
    3,  3,  4,  2,  3,  5,  5,  6,  6,  6,  5,  10, 10, 10, 10, 8,  7,  11, 16,
    17, 15, 11, 9,  7,  18, 21, 20, 15, 13, 10, 8,  3,  4,  2,  2,  1,  2,  2,
    3,  4,  3,  2,  2,  2,  3,  3,  6,  4,  5,  5,  4,  4,  3,  8,  9,  9,  8,
    7,  7,  8,  12, 15, 14, 13, 10, 8,  13, 17, 20, 19, 14, 11, 8,  19, 22, 23,
    21, 16, 12, 9,  7,  9,  6,  3,  2,  0,  2,  7,  9,  7,  4,  3,  2,  2,  7,
    9,  9,  7,  6,  5,  5,  7,  11, 14, 12, 10, 9,  8,  10, 15, 18, 17, 15, 13,
    9,  15, 19, 22, 23, 17, 13, 10, 20, 23, 23, 24, 19, 15, 11, 15, 18, 21, 24,
    25, 22, 18, 14, 17, 20, 24, 25, 22, 20, 13, 16, 20, 23, 26, 24, 21, 12, 16,
    20, 23, 26, 24, 21, 13, 16, 19, 23, 27, 24, 21, 12, 16, 18, 22, 25, 24, 21,
    17, 16, 17, 21, 24, 24, 21, 13, 16, 19, 21, 21, 18, 15, 12, 15, 18, 20, 20,
    18, 15, 11, 14, 17, 20, 21, 19, 16, 10, 14, 18, 21, 21, 19, 17, 11, 14, 17,
    20, 20, 20, 17, 12, 13, 16, 19, 19, 19, 16, 19, 17, 16, 18, 18, 18, 17, 11,
    14, 15, 15, 16, 14, 10, 10, 13, 14, 14, 14, 13, 10, 9,  11, 13, 14, 14, 14,
    11, 9,  12, 14, 14, 14, 14, 12, 8,  11, 13, 13, 13, 13, 12, 14, 14, 14, 13,
    12, 12, 12, 22, 20, 16, 13, 11, 11, 11, 9,  9,  8,  8,  9,  9,  2,  8,  7,
    7,  7,  7,  7,  2,  6,  6,  7,  7,  7,  7,  3,  6,  6,  7,  7,  7,  7,  6,
    7,  8,  9,  9,  9,  7,  6,  14, 16, 14, 12, 10, 8,  6,  21, 22, 17, 13, 10,
    8,  7,  2,  1,  1,  1,  1,  2,  2,  2,  2,  1,  1,  1,  1,  2,  2,  2,  2,
    4,  4,  3,  3,  2,  6,  6,  7,  7,  7,  6,  6,  11, 12, 11, 11, 9,  7,  13,
    17, 18, 15, 12, 10, 7,  20, 22, 21, 16, 13, 11, 8,  6,  5,  4,  3,  2,  1,
    2,  5,  7,  4,  3,  3,  2,  2,  6,  9,  6,  6,  5,  4,  4,  6,  10, 10, 10,
    9,  8,  7,  9,  14, 16, 15, 13, 11, 8,  15, 19, 22, 19, 15, 12, 9,  20, 23,
    24, 22, 16, 13, 10, 9,  11, 7,  4,  3,  2,  0,  10, 11, 9,  5,  3,  3,  3,
    9,  11, 12, 8,  7,  6,  5,  9,  13, 16, 13, 11, 10, 9,  12, 16, 20, 19, 16,
    13, 10, 17, 20, 24, 24, 18, 14, 11, 21, 25, 25, 25, 20, 16, 12, 32, 36, 39,
    42, 41, 39, 35, 31, 35, 37, 41, 41, 40, 35, 29, 33, 36, 39, 41, 39, 36, 29,
    32, 35, 39, 42, 40, 37, 29, 31, 35, 39, 42, 41, 37, 27, 31, 34, 38, 42, 40,
    36, 24, 28, 33, 37, 40, 41, 37, 30, 33, 36, 38, 38, 35, 31, 28, 31, 36, 38,
    37, 34, 32, 27, 31, 34, 37, 37, 35, 31, 25, 30, 34, 37, 36, 35, 33, 26, 29,
    33, 36, 36, 36, 33, 24, 29, 31, 35, 36, 35, 32, 21, 26, 30, 34, 34, 34, 32,
    27, 30, 31, 32, 33, 30, 24, 25, 29, 31, 32, 31, 30, 25, 25, 27, 28, 30, 31,
    30, 25, 21, 27, 28, 30, 29, 30, 26, 19, 26, 29, 30, 29, 28, 25, 15, 25, 26,
    28, 27, 27, 25, 16, 23, 24, 25, 27, 27, 25, 24, 24, 25, 25, 25, 22, 13, 21,
    23, 24, 24, 24, 21, 14, 17, 22, 22, 23, 22, 20, 15, 14, 22, 21, 22, 22, 20,
    18, 14, 19, 20, 21, 21, 19, 14, 15, 17, 19, 19, 19, 18, 11, 16, 14, 16, 18,
    18, 17, 8,  12, 16, 17, 17, 15, 10, 12, 9,  15, 15, 15, 14, 10, 13, 9,  13,
    13, 13, 12, 8,  11, 9,  10, 13, 13, 12, 9,  10, 10, 7,  11, 11, 10, 6,  8,
    10, 9,  8,  9,  9,  5,  8,  12, 11, 9,  7,  7,  4,  7,  4,  6,  6,  6,  7,
    9,  11, 4,  4,  4,  5,  6,  9,  10, 4,  2,  2,  3,  4,  7,  9,  4,  2,  1,
    1,  4,  6,  8,  5,  4,  4,  4,  4,  4,  7,  7,  6,  8,  6,  5,  4,  6,  8,
    9,  9,  7,  5,  4,  5,  0,  4,  3,  2,  4,  7,  9,  0,  4,  4,  2,  3,  7,
    9,  0,  4,  5,  2,  2,  6,  8,  0,  4,  5,  2,  2,  4,  6,  2,  4,  5,  5,
    5,  4,  5,  4,  6,  8,  8,  5,  5,  4,  8,  8,  9,  9,  6,  5,  4,  37, 41,
    45, 47, 47, 44, 41, 36, 40, 43, 47, 47, 44, 41, 35, 38, 43, 46, 47, 44, 41,
    33, 37, 41, 45, 48, 45, 42, 35, 37, 41, 45, 48, 46, 43, 33, 37, 40, 43, 47,
    46, 43, 31, 35, 39, 43, 46, 46, 43, 34, 39, 43, 44, 44, 39, 36, 34, 37, 42,
    44, 43, 41, 36, 33, 36, 40, 43, 43, 39, 36, 31, 36, 40, 43, 43, 41, 37, 30,
    36, 39, 42, 42, 42, 38, 28, 34, 37, 40, 40, 41, 37, 25, 32, 37, 40, 39, 39,
    37, 32, 36, 38, 37, 37, 34, 28, 31, 35, 37, 37, 38, 34, 28, 28, 33, 34, 36,
    36, 34, 28, 25, 34, 35, 34, 35, 34, 30, 23, 33, 35, 34, 35, 34, 29, 18, 30,
    32, 34, 34, 32, 30, 18, 28, 32, 31, 33, 32, 28, 29, 30, 31, 31, 30, 25, 16,
    25, 30, 30, 30, 28, 23, 18, 21, 28, 28, 29, 27, 22, 20, 17, 26, 28, 28, 27,
    23, 22, 18, 23, 27, 27, 27, 22, 18, 19, 20, 25, 25, 25, 21, 15, 18, 17, 22,
    23, 24, 21, 11, 16, 22, 23, 22, 17, 12, 16, 12, 20, 21, 21, 16, 11, 18, 13,
    16, 20, 19, 15, 9,  15, 12, 12, 19, 19, 15, 11, 14, 14, 10, 17, 17, 13, 8,
    11, 13, 11, 15, 15, 13, 7,  10, 14, 13, 12, 13, 11, 6,  9,  7,  11, 12, 9,
    9,  11, 13, 7,  8,  10, 8,  7,  10, 12, 7,  5,  8,  7,  6,  8,  10, 7,  4,
    7,  6,  6,  8,  10, 8,  6,  5,  5,  5,  6,  9,  9,  8,  7,  7,  5,  6,  8,
    11, 9,  8,  7,  6,  5,  7,  4,  0,  2,  4,  6,  9,  11, 4,  0,  2,  3,  5,
    7,  10, 4,  0,  3,  2,  5,  9,  10, 4,  1,  3,  2,  4,  5,  8,  4,  3,  5,
    5,  5,  5,  7,  6,  6,  8,  8,  6,  5,  6,  7,  8,  8,  8,  6,  5,  6,  39,
    41, 46, 47, 47, 45, 41, 37, 41, 43, 47, 46, 43, 40, 37, 39, 42, 46, 48, 45,
    42, 35, 38, 43, 46, 48, 46, 43, 36, 39, 43, 45, 49, 46, 44, 35, 38, 42, 45,
    48, 47, 43, 32, 35, 40, 43, 47, 47, 43, 36, 39, 43, 45, 43, 39, 36, 35, 38,
    42, 43, 44, 40, 35, 34, 37, 42, 44, 42, 40, 36, 32, 37, 41, 43, 42, 40, 37,
    31, 37, 40, 43, 43, 41, 37, 29, 35, 39, 42, 42, 40, 37, 25, 33, 38, 41, 40,
    39, 37, 35, 37, 37, 38, 38, 33, 26, 31, 36, 37, 37, 36, 33, 27, 29, 35, 37,
    37, 36, 33, 28, 25, 34, 36, 37, 36, 33, 30, 23, 34, 36, 36, 35, 32, 30, 19,
    31, 34, 35, 35, 32, 30, 19, 29, 33, 33, 33, 31, 27, 29, 31, 31, 31, 30, 24,
    16, 25, 30, 31, 30, 27, 22, 18, 21, 28, 29, 30, 27, 22, 20, 18, 26, 29, 28,
    28, 22, 23, 19, 23, 28, 28, 26, 21, 19, 19, 20, 26, 26, 26, 20, 16, 19, 17,
    24, 24, 24, 20, 12, 16, 23, 23, 22, 16, 10, 16, 13, 20, 22, 21, 15, 10, 17,
    13, 16, 21, 20, 15, 9,  16, 12, 13, 21, 19, 15, 9,  15, 14, 11, 19, 19, 13,
    7,  11, 15, 12, 16, 16, 12, 7,  9,  15, 14, 14, 15, 11, 7,  8,  7,  12, 13,
    8,  7,  9,  12, 8,  7,  12, 8,  6,  8,  10, 7,  4,  10, 7,  6,  8,  10, 7,
    5,  9,  7,  5,  7,  9,  9,  7,  7,  5,  6,  7,  8,  10, 9,  9,  10, 7,  6,
    7,  12, 10, 11, 11, 9,  6,  7,  4,  2,  2,  3,  5,  7,  9,  4,  2,  0,  3,
    5,  6,  9,  4,  2,  2,  2,  5,  8,  9,  4,  2,  5,  3,  4,  6,  8,  5,  4,
    9,  10, 8,  6,  7,  7,  8,  14, 14, 11, 7,  6,  8,  12, 15, 15, 12, 8,  6,
    31, 35, 38, 40, 41, 38, 34, 30, 34, 37, 40, 41, 37, 34, 29, 31, 36, 39, 41,
    39, 35, 28, 32, 36, 38, 42, 39, 36, 29, 32, 35, 39, 42, 40, 36, 28, 32, 34,
    38, 40, 40, 36, 25, 29, 33, 36, 40, 40, 35, 30, 33, 36, 38, 36, 32, 28, 28,
    31, 34, 37, 36, 32, 29, 27, 30, 34, 36, 36, 34, 30, 26, 30, 34, 36, 36, 34,
    30, 26, 30, 33, 36, 36, 35, 31, 24, 29, 32, 34, 35, 34, 30, 22, 26, 31, 34,
    34, 33, 30, 28, 30, 31, 31, 31, 27, 20, 26, 29, 29, 30, 29, 27, 21, 24, 29,
    29, 30, 30, 27, 22, 20, 28, 30, 30, 29, 27, 24, 18, 28, 29, 29, 29, 27, 23,
    16, 26, 28, 28, 28, 26, 23, 17, 24, 25, 26, 27, 26, 21, 24, 25, 24, 24, 22,
    18, 10, 20, 23, 23, 24, 22, 17, 12, 16, 22, 22, 22, 21, 16, 15, 13, 21, 22,
    22, 21, 17, 18, 14, 19, 22, 21, 20, 16, 14, 15, 17, 19, 20, 19, 16, 10, 17,
    15, 18, 18, 18, 16, 7,  12, 17, 16, 16, 11, 5,  11, 8,  15, 15, 15, 11, 6,
    12, 9,  12, 14, 14, 11, 5,  10, 9,  9,  14, 13, 11, 5,  10, 10, 8,  13, 12,
    10, 6,  7,  11, 10, 10, 10, 9,  5,  6,  13, 12, 11, 9,  8,  6,  5,  4,  7,
    7,  5,  4,  5,  7,  4,  5,  5,  5,  3,  5,  6,  4,  3,  4,  4,  4,  5,  6,
    4,  3,  3,  3,  4,  5,  5,  6,  5,  8,  8,  8,  6,  5,  8,  9,  14, 13, 10,
    7,  5,  10, 13, 16, 14, 11, 8,  5,  2,  3,  2,  2,  3,  4,  5,  2,  3,  3,
    0,  2,  4,  5,  2,  3,  4,  2,  2,  4,  5,  2,  5,  8,  6,  5,  5,  5,  4,
    8,  12, 12, 10, 8,  6,  7,  12, 17, 18, 13, 9,  6,  12, 17, 19, 18, 14, 10,
    7,  25, 29, 32, 35, 35, 31, 29, 24, 28, 30, 35, 35, 32, 28, 23, 26, 30, 33,
    35, 32, 30, 23, 26, 30, 33, 36, 33, 30, 24, 25, 29, 32, 36, 34, 30, 22, 25,
    28, 32, 35, 33, 30, 20, 23, 27, 31, 33, 34, 30, 24, 26, 30, 33, 30, 28, 23,
    23, 25, 28, 32, 31, 28, 24, 22, 23, 28, 31, 30, 27, 24, 21, 24, 27, 30, 30,
    28, 25, 21, 25, 27, 30, 29, 29, 25, 20, 23, 25, 29, 29, 29, 25, 17, 20, 24,
    27, 28, 27, 25, 22, 24, 25, 26, 26, 22, 17, 21, 22, 24, 25, 24, 23, 17, 20,
    22, 24, 24, 24, 22, 17, 17, 23, 24, 23, 24, 23, 18, 15, 22, 23, 22, 23, 22,
    18, 13, 20, 21, 21, 22, 21, 18, 15, 18, 19, 20, 20, 21, 17, 20, 19, 18, 18,
    19, 15, 7,  16, 18, 18, 17, 17, 14, 8,  14, 18, 17, 16, 17, 14, 10, 10, 17,
    17, 16, 16, 14, 13, 12, 16, 16, 15, 16, 13, 9,  12, 14, 14, 14, 14, 12, 6,
    15, 16, 12, 12, 13, 12, 5,  9,  11, 11, 11, 9,  4,  6,  5,  10, 9,  9,  8,
    3,  8,  5,  9,  8,  8,  8,  3,  6,  5,  7,  9,  8,  7,  4,  6,  7,  6,  7,
    7,  7,  6,  4,  9,  10, 12, 10, 8,  6,  5,  13, 16, 16, 11, 9,  7,  5,  2,
    2,  1,  2,  2,  3,  4,  2,  2,  1,  0,  2,  3,  4,  2,  2,  2,  2,  2,  3,
    4,  2,  4,  6,  6,  5,  5,  5,  4,  8,  11, 10, 9,  7,  5,  8,  13, 18, 15,
    11, 8,  6,  14, 18, 19, 17, 12, 9,  7,  4,  5,  3,  2,  1,  2,  3,  4,  5,
    4,  2,  0,  2,  4,  4,  5,  6,  4,  3,  2,  3,  4,  7,  10, 8,  7,  6,  6,
    7,  11, 14, 14, 11, 9,  7,  11, 15, 19, 19, 14, 10, 7,  16, 19, 20, 20, 16,
    12, 8,  21, 24, 27, 31, 32, 29, 25, 19, 23, 27, 30, 31, 28, 24, 18, 22, 26,
    29, 30, 28, 25, 18, 21, 24, 28, 31, 28, 25, 19, 21, 24, 27, 31, 29, 25, 17,
    20, 23, 26, 30, 29, 25, 15, 19, 22, 26, 29, 29, 26, 19, 21, 25, 29, 28, 25,
    21, 18, 20, 24, 28, 27, 24, 20, 17, 20, 22, 26, 25, 23, 21, 16, 20, 22, 25,
    25, 24, 21, 17, 19, 22, 24, 24, 24, 21, 15, 18, 21, 23, 24, 23, 21, 16, 16,
    19, 22, 22, 22, 21, 17, 19, 21, 22, 22, 20, 16, 16, 18, 19, 21, 21, 19, 14,
    16, 17, 19, 19, 19, 18, 15, 14, 18, 18, 18, 18, 18, 16, 13, 17, 18, 18, 17,
    18, 15, 11, 15, 17, 17, 17, 16, 15, 17, 16, 15, 15, 16, 16, 14, 16, 14, 14,
    14, 15, 14, 6,  14, 13, 13, 13, 13, 12, 5,  11, 12, 12, 12, 11, 11, 6,  8,
    12, 12, 12, 11, 11, 9,  9,  11, 11, 11, 10, 10, 6,  11, 11, 11, 9,  9,  9,
    4,  17, 18, 13, 10, 8,  8,  4,  7,  7,  6,  6,  7,  4,  5,  2,  5,  5,  5,
    5,  3,  5,  2,  4,  3,  3,  3,  2,  3,  2,  3,  3,  3,  4,  4,  4,  5,  8,
    8,  7,  8,  6,  4,  9,  13, 14, 12, 9,  7,  5,  16, 18, 17, 13, 10, 8,  5,
    2,  3,  2,  2,  2,  3,  4,  2,  4,  3,  2,  2,  2,  2,  2,  5,  4,  3,  2,
    2,  2,  2,  6,  7,  6,  6,  5,  5,  6,  10, 13, 11, 10, 8,  5,  11, 15, 18,
    16, 12, 9,  6,  16, 19, 19, 18, 13, 10, 7,  6,  8,  5,  3,  2,  2,  3,  6,
    7,  7,  4,  2,  0,  2,  6,  7,  8,  5,  4,  3,  3,  6,  9,  12, 9,  8,  7,
    6,  8,  12, 16, 15, 12, 10, 7,  13, 16, 20, 21, 15, 11, 8,  18, 21, 20, 21,
    16, 12, 9,  17, 20, 24, 28, 28, 25, 22, 16, 19, 23, 27, 28, 24, 20, 14, 17,
    21, 24, 26, 24, 20, 13, 17, 20, 23, 27, 24, 21, 14, 17, 20, 23, 27, 25, 21,
    12, 15, 19, 22, 26, 24, 21, 14, 14, 18, 21, 25, 24, 21, 14, 18, 22, 25, 24,
    21, 18, 13, 17, 20, 23, 23, 20, 16, 13, 15, 18, 21, 21, 19, 16, 12, 15, 18,
    20, 21, 19, 16, 12, 15, 18, 20, 20, 20, 17, 10, 13, 16, 19, 20, 19, 17, 16,
    15, 15, 18, 18, 18, 17, 13, 16, 17, 18, 19, 17, 13, 12, 14, 16, 16, 17, 15,
    11, 10, 13, 14, 14, 14, 14, 11, 10, 13, 14, 14, 14, 14, 12, 9,  12, 14, 13,
    13, 14, 12, 12, 12, 12, 12, 13, 12, 12, 18, 17, 13, 11, 11, 11, 11, 11, 10,
    10, 11, 12, 12, 5,  10, 9,  9,  9,  10, 10, 3,  8,  8,  8,  8,  7,  7,  3,
    5,  8,  7,  7,  7,  7,  5,  7,  7,  7,  6,  6,  6,  3,  12, 13, 11, 9,  7,
    6,  4,  18, 18, 14, 10, 8,  6,  4,  2,  2,  2,  3,  3,  4,  4,  1,  1,  0,
    1,  2,  2,  3,  1,  2,  2,  2,  1,  1,  2,  1,  5,  5,  4,  4,  4,  3,  5,
    10, 9,  8,  8,  6,  4,  11, 14, 14, 12, 10, 7,  5,  17, 19, 17, 13, 10, 8,
    5,  5,  5,  4,  3,  3,  3,  4,  5,  7,  4,  4,  3,  1,  2,  5,  8,  6,  4,
    3,  2,  2,  5,  9,  9,  7,  6,  6,  5,  9,  12, 14, 12, 10, 8,  5,  12, 16,
    19, 16, 12, 9,  6,  17, 19, 20, 18, 14, 10, 7,  9,  10, 7,  5,  3,  2,  3,
    10, 10, 9,  5,  4,  2,  0,  9,  10, 11, 7,  5,  4,  3,  10, 11, 14, 10, 8,
    7,  6,  10, 14, 17, 16, 13, 10, 8,  14, 17, 21, 20, 15, 11, 8,  18, 20, 22,
    22, 17, 12, 9,  32, 35, 38, 41, 41, 38, 36, 30, 34, 37, 41, 41, 39, 37, 29,
    32, 37, 40, 42, 39, 37, 28, 32, 36, 39, 42, 39, 37, 28, 31, 35, 39, 42, 41,
    36, 28, 30, 34, 38, 41, 40, 36, 25, 29, 33, 37, 40, 39, 37, 29, 33, 36, 39,
    38, 35, 32, 28, 32, 35, 39, 37, 35, 31, 27, 31, 34, 37, 37, 35, 31, 25, 30,
    33, 36, 36, 36, 33, 25, 30, 33, 36, 35, 36, 32, 24, 27, 31, 35, 36, 35, 33,
    21, 26, 30, 34, 34, 34, 32, 27, 31, 31, 32, 32, 30, 25, 26, 29, 31, 32, 32,
    30, 25, 24, 28, 30, 30, 30, 30, 24, 21, 28, 28, 30, 30, 29, 26, 18, 26, 28,
    29, 29, 29, 25, 15, 25, 27, 27, 28, 28, 25, 16, 22, 25, 26, 26, 27, 25, 24,
    25, 24, 25, 25, 23, 13, 20, 23, 24, 24, 24, 21, 14, 18, 22, 23, 22, 22, 20,
    15, 14, 21, 21, 22, 22, 20, 18, 14, 19, 20, 21, 21, 19, 14, 15, 17, 18, 19,
    19, 18, 11, 16, 14, 16, 17, 18, 17, 8,  12, 16, 17, 17, 15, 10, 13, 9,  15,
    15, 15, 13, 10, 14, 9,  13, 13, 13, 12, 8,  12, 9,  9,  12, 12, 12, 9,  10,
    10, 7,  11, 11, 10, 6,  8,  10, 9,  8,  8,  9,  5,  8,  12, 10, 9,  7,  7,
    4,  7,  4,  6,  6,  6,  7,  9,  11, 4,  4,  4,  5,  6,  9,  10, 4,  2,  2,
    3,  4,  7,  9,  4,  2,  1,  1,  3,  6,  8,  5,  4,  4,  4,  4,  4,  7,  7,
    6,  8,  6,  5,  4,  6,  9,  9,  9,  7,  5,  4,  6,  0,  4,  3,  2,  4,  7,
    9,  0,  4,  4,  2,  4,  6,  8,  0,  4,  5,  2,  2,  6,  8,  0,  4,  4,  2,
    2,  4,  6,  2,  4,  5,  5,  5,  4,  5,  4,  6,  8,  8,  6,  5,  4,  8,  8,
    9,  9,  6,  5,  4,  38, 41, 44, 47, 47, 44, 41, 37, 40, 43, 47, 47, 45, 42,
    35, 39, 42, 46, 47, 45, 42, 34, 37, 42, 45, 48, 46, 42, 34, 38, 41, 45, 49,
    46, 43, 34, 36, 41, 44, 48, 46, 42, 32, 35, 38, 42, 46, 46, 42, 35, 39, 43,
    44, 42, 39, 36, 34, 38, 41, 45, 43, 39, 36, 33, 36, 39, 43, 42, 40, 36, 31,
    36, 39, 43, 41, 40, 37, 31, 35, 39, 43, 41, 41, 37, 28, 34, 38, 41, 40, 40,
    37, 24, 31, 36, 39, 40, 39, 37, 33, 36, 38, 38, 37, 34, 27, 32, 34, 37, 38,
    37, 33, 28, 28, 33, 36, 35, 36, 34, 28, 25, 34, 35, 36, 35, 34, 30, 22, 33,
    35, 35, 35, 33, 30, 19, 31, 32, 33, 33, 32, 29, 19, 28, 31, 32, 33, 31, 28,
    29, 31, 30, 30, 29, 25, 16, 24, 29, 29, 29, 28, 24, 18, 21, 28, 29, 29, 27,
    23, 19, 17, 26, 27, 28, 28, 23, 22, 18, 23, 27, 26, 26, 22, 19, 19, 19, 25,
    25, 24, 22, 14, 19, 17, 23, 24, 24, 20, 11, 16, 22, 21, 22, 17, 12, 16, 13,
    20, 21, 20, 16, 12, 17, 12, 16, 20, 19, 16, 9,  15, 12, 12, 19, 19, 15, 10,
    14, 14, 10, 18, 17, 14, 8,  11, 14, 11, 15, 15, 12, 7,  10, 15, 13, 12, 13,
    11, 6,  9,  7,  11, 12, 9,  9,  10, 13, 7,  8,  10, 8,  7,  10, 12, 7,  5,
    8,  7,  6,  8,  10, 7,  5,  7,  6,  6,  8,  9,  8,  6,  6,  5,  5,  6,  9,
    9,  8,  7,  7,  5,  6,  8,  11, 9,  8,  7,  6,  5,  7,  4,  0,  2,  4,  6,
    9,  11, 4,  0,  2,  3,  5,  7,  10, 4,  0,  3,  2,  5,  9,  9,  4,  1,  3,
    2,  4,  5,  8,  4,  3,  5,  5,  5,  5,  7,  6,  6,  8,  8,  6,  5,  6,  7,
    9,  8,  8,  6,  5,  6,  41, 44, 47, 50, 50, 47, 43, 40, 43, 48, 50, 51, 47,
    44, 39, 42, 46, 48, 51, 46, 44, 37, 41, 45, 48, 51, 48, 45, 38, 41, 45, 49,
    51, 49, 45, 37, 40, 44, 47, 51, 49, 46, 34, 38, 42, 46, 49, 48, 44, 39, 42,
    46, 48, 46, 42, 38, 38, 41, 45, 48, 46, 42, 37, 37, 40, 43, 46, 45, 43, 39,
    33, 40, 43, 46, 46, 43, 39, 33, 40, 43, 45, 45, 44, 39, 30, 38, 40, 44, 44,
    43, 38, 27, 36, 40, 43, 42, 41, 39, 37, 40, 41, 40, 40, 37, 29, 34, 39, 39,
    41, 38, 36, 29, 31, 38, 40, 38, 38, 36, 30, 27, 37, 38, 40, 37, 36, 32, 25,
    35, 38, 38, 37, 35, 32, 21, 33, 36, 36, 36, 34, 32, 21, 30, 35, 35, 36, 33,
    29, 31, 34, 33, 34, 31, 27, 19, 26, 32, 34, 33, 31, 25, 20, 23, 30, 32, 31,
    30, 24, 22, 19, 27, 31, 32, 29, 23, 25, 20, 25, 31, 30, 28, 22, 21, 21, 22,
    29, 28, 27, 22, 17, 21, 18, 26, 27, 26, 21, 14, 18, 26, 26, 25, 18, 13, 19,
    14, 22, 25, 24, 17, 12, 20, 14, 18, 23, 23, 16, 10, 18, 14, 15, 22, 22, 15,
    10, 17, 15, 12, 21, 20, 14, 9,  13, 16, 13, 18, 18, 14, 8,  10, 16, 14, 15,
    17, 12, 8,  9,  9,  13, 15, 10, 9,  11, 15, 9,  9,  14, 10, 8,  10, 13, 9,
    5,  12, 8,  7,  9,  11, 9,  6,  11, 8,  7,  9,  10, 11, 8,  9,  6,  6,  7,
    9,  11, 9,  8,  8,  6,  7,  9,  12, 11, 9,  9,  8,  6,  7,  5,  3,  3,  5,
    7,  9,  12, 5,  3,  2,  4,  6,  8,  11, 5,  3,  0,  4,  7,  9,  11, 5,  3,
    3,  3,  4,  7,  9,  6,  4,  7,  8,  7,  6,  8,  7,  6,  10, 11, 8,  6,  7,
    9,  10, 11, 11, 9,  7,  6,  34, 38, 42, 44, 45, 41, 37, 32, 37, 41, 44, 44,
    41, 37, 31, 35, 39, 43, 43, 41, 36, 30, 33, 37, 40, 43, 40, 37, 30, 33, 37,
    40, 43, 40, 38, 29, 32, 35, 40, 42, 41, 36, 26, 31, 35, 38, 42, 41, 38, 32,
    35, 39, 43, 40, 36, 33, 31, 34, 38, 41, 40, 37, 32, 30, 32, 36, 39, 38, 35,
    30, 27, 31, 34, 37, 38, 35, 31, 27, 31, 34, 38, 37, 36, 31, 25, 30, 33, 36,
    37, 35, 31, 21, 27, 32, 35, 35, 34, 31, 29, 33, 34, 35, 33, 31, 25, 27, 31,
    33, 35, 33, 30, 24, 24, 30, 31, 32, 31, 29, 23, 21, 30, 30, 30, 30, 28, 24,
    19, 28, 30, 30, 29, 28, 24, 16, 26, 28, 28, 29, 26, 25, 16, 24, 27, 26, 28,
    26, 22, 23, 27, 26, 28, 27, 22, 15, 20, 25, 26, 26, 26, 21, 15, 17, 23, 24,
    24, 23, 18, 16, 14, 23, 23, 23, 21, 18, 19, 15, 19, 23, 22, 21, 17, 15, 15,
    17, 21, 21, 20, 16, 11, 16, 15, 19, 19, 20, 16, 7,  13, 19, 18, 19, 15, 9,
    15, 9,  17, 18, 17, 14, 8,  15, 9,  13, 16, 15, 12, 6,  12, 9,  10, 15, 14,
    11, 6,  10, 10, 8,  14, 13, 10, 5,  7,  11, 9,  11, 11, 9,  4,  5,  12, 11,
    9,  10, 8,  4,  5,  4,  9,  9,  8,  6,  8,  11, 4,  6,  8,  7,  5,  7,  9,
    4,  3,  5,  5,  3,  5,  6,  4,  3,  4,  4,  3,  4,  5,  6,  4,  5,  5,  6,
    4,  5,  7,  6,  11, 10, 7,  5,  5,  9,  11, 12, 12, 9,  6,  4,  2,  2,  2,
    3,  5,  7,  8,  2,  2,  2,  2,  4,  5,  7,  2,  2,  3,  0,  3,  5,  6,  2,
    3,  6,  4,  3,  3,  4,  3,  5,  9,  10, 8,  5,  4,  5,  9,  15, 15, 11, 7,
    4,  9,  14, 17, 17, 12, 8,  5,  27, 33, 36, 39, 39, 37, 33, 27, 30, 35, 38,
    40, 37, 32, 25, 29, 34, 37, 38, 34, 30, 25, 27, 32, 35, 37, 34, 32, 25, 27,
    30, 34, 37, 35, 31, 24, 26, 29, 33, 36, 34, 31, 21, 24, 28, 32, 35, 34, 32,
    26, 29, 34, 37, 35, 32, 28, 24, 29, 32, 35, 36, 32, 27, 24, 26, 30, 33, 33,
    30, 25, 23, 25, 28, 31, 31, 29, 26, 23, 25, 28, 31, 31, 28, 26, 21, 24, 27,
    30, 30, 29, 26, 18, 22, 25, 28, 29, 28, 26, 24, 26, 29, 30, 30, 27, 22, 22,
    25, 28, 28, 29, 26, 20, 21, 24, 26, 26, 26, 25, 18, 17, 24, 24, 24, 25, 24,
    19, 16, 23, 23, 23, 23, 22, 19, 13, 21, 22, 22, 22, 20, 19, 14, 19, 21, 21,
    21, 21, 17, 21, 22, 21, 22, 23, 20, 13, 17, 20, 21, 21, 21, 18, 12, 14, 19,
    19, 18, 19, 15, 12, 11, 19, 17, 17, 17, 14, 13, 12, 16, 16, 17, 16, 13, 10,
    13, 14, 15, 15, 15, 13, 7,  14, 13, 13, 13, 13, 13, 4,  9,  14, 14, 15, 13,
    9,  13, 6,  13, 12, 13, 12, 6,  12, 6,  10, 10, 10, 9,  4,  8,  6,  7,  9,
    9,  8,  4,  6,  7,  5,  8,  7,  7,  3,  4,  8,  7,  8,  7,  6,  3,  4,  10,
    11, 11, 8,  5,  4,  3,  2,  4,  5,  5,  5,  7,  9,  2,  2,  3,  4,  4,  5,
    7,  2,  0,  1,  1,  2,  3,  4,  2,  2,  3,  2,  2,  2,  3,  4,  5,  8,  7,
    6,  4,  3,  5,  9,  14, 12, 8,  5,  3,  10, 13, 16, 13, 9,  6,  3,  3,  6,
    4,  2,  5,  6,  7,  2,  5,  5,  2,  3,  4,  5,  3,  6,  7,  3,  0,  3,  4,
    2,  5,  7,  5,  4,  3,  3,  4,  7,  11, 11, 8,  6,  4,  7,  11, 15, 15, 11,
    7,  4,  12, 16, 16, 16, 12, 8,  5,  24, 29, 32, 36, 35, 32, 29, 23, 27, 31,
    35, 34, 31, 28, 21, 25, 29, 33, 34, 30, 26, 20, 22, 26, 30, 32, 29, 27, 19,
    22, 24, 28, 32, 30, 27, 18, 21, 23, 27, 31, 30, 27, 16, 19, 23, 26, 29, 30,
    26, 22, 25, 28, 33, 31, 28, 25, 20, 24, 28, 31, 31, 27, 24, 19, 22, 26, 30,
    29, 26, 22, 18, 20, 23, 26, 26, 25, 21, 18, 20, 22, 26, 26, 25, 22, 16, 19,
    22, 25, 24, 24, 22, 13, 17, 20, 23, 23, 24, 22, 19, 22, 24, 26, 26, 24, 20,
    18, 21, 23, 24, 25, 23, 18, 17, 20, 22, 21, 22, 21, 16, 15, 19, 19, 19, 20,
    19, 15, 13, 17, 19, 18, 18, 18, 15, 11, 16, 17, 17, 18, 17, 16, 13, 14, 15,
    16, 16, 17, 14, 17, 17, 17, 18, 19, 18, 10, 15, 16, 17, 17, 17, 15, 9,  11,
    15, 15, 15, 14, 13, 8,  8,  14, 13, 12, 12, 11, 10, 9,  12, 12, 11, 11, 10,
    6,  10, 10, 10, 10, 10, 9,  3,  13, 14, 10, 8,  9,  8,  3,  7,  9,  10, 10,
    11, 8,  10, 3,  7,  8,  9,  9,  5,  9,  3,  6,  6,  6,  6,  3,  5,  3,  4,
    4,  4,  3,  2,  3,  5,  5,  4,  4,  4,  3,  3,  7,  9,  10, 8,  6,  4,  2,
    11, 14, 13, 10, 7,  4,  2,  0,  2,  2,  3,  4,  6,  8,  0,  4,  3,  3,  3,
    4,  5,  0,  4,  3,  2,  1,  2,  3,  0,  5,  5,  3,  3,  2,  2,  3,  7,  9,
    8,  7,  4,  2,  7,  12, 15, 12, 9,  5,  3,  12, 15, 16, 14, 10, 7,  4,  6,
    9,  6,  3,  3,  5,  6,  6,  9,  8,  4,  2,  3,  4,  6,  9,  11, 5,  3,  0,
    3,  6,  7,  9,  6,  4,  4,  3,  6,  9,  12, 12, 9,  6,  4,  9,  13, 16, 16,
    11, 8,  4,  14, 17, 17, 17, 13, 9,  5,  20, 23, 27, 31, 30, 28, 24, 19, 22,
    26, 31, 31, 27, 24, 17, 21, 25, 28, 29, 26, 22, 16, 19, 22, 25, 27, 24, 21,
    14, 17, 20, 23, 27, 25, 22, 14, 16, 19, 23, 26, 25, 21, 11, 14, 18, 22, 25,
    25, 22, 17, 20, 25, 29, 28, 25, 21, 16, 20, 24, 28, 27, 23, 20, 15, 18, 22,
    24, 24, 22, 18, 14, 16, 19, 21, 21, 19, 17, 13, 16, 18, 20, 20, 21, 17, 11,
    14, 17, 20, 20, 20, 17, 12, 12, 16, 19, 19, 18, 17, 15, 18, 21, 22, 23, 21,
    16, 14, 17, 19, 20, 21, 20, 15, 13, 16, 18, 18, 18, 17, 13, 12, 14, 14, 14,
    15, 15, 12, 10, 13, 14, 14, 14, 14, 12, 9,  11, 12, 12, 13, 12, 12, 13, 12,
    11, 11, 11, 11, 11, 13, 13, 13, 14, 15, 15, 8,  11, 11, 12, 13, 13, 13, 7,
    9,  10, 11, 10, 10, 10, 6,  5,  9,  8,  7,  7,  7,  6,  7,  7,  7,  7,  6,
    6,  3,  9,  9,  8,  6,  5,  5,  2,  13, 13, 9,  7,  5,  4,  2,  4,  5,  5,
    6,  7,  7,  8,  1,  3,  4,  5,  5,  5,  6,  1,  1,  2,  2,  2,  2,  3,  1,
    3,  2,  1,  2,  1,  2,  3,  6,  6,  5,  5,  3,  2,  8,  11, 11, 9,  6,  4,
    2,  12, 14, 13, 10, 8,  6,  3,  5,  5,  4,  4,  4,  6,  7,  5,  7,  4,  4,
    4,  3,  4,  5,  7,  5,  4,  2,  1,  2,  5,  7,  6,  5,  3,  3,  2,  6,  9,
    11, 9,  7,  6,  3,  9,  12, 15, 13, 9,  6,  4,  13, 15, 16, 14, 10, 7,  4,
    8,  10, 7,  4,  4,  5,  5,  8,  10, 9,  5,  3,  3,  3,  8,  10, 11, 6,  4,
    3,  0,  8,  9,  11, 7,  5,  4,  3,  8,  10, 14, 13, 9,  7,  5,  11, 14, 17,
    16, 12, 8,  6,  14, 16, 17, 17, 13, 9,  6,  32, 35, 38, 42, 42, 39, 35, 31,
    35, 38, 41, 41, 39, 37, 29, 33, 37, 40, 41, 39, 37, 29, 31, 35, 38, 42, 39,
    37, 28, 31, 35, 39, 42, 40, 37, 27, 31, 35, 37, 41, 40, 36, 24, 28, 33, 36,
    41, 39, 36, 29, 33, 37, 39, 38, 34, 32, 29, 32, 35, 38, 37, 35, 31, 27, 30,
    33, 38, 37, 34, 32, 26, 29, 33, 36, 36, 35, 33, 26, 29, 33, 35, 36, 36, 33,
    23, 28, 31, 35, 35, 35, 33, 21, 25, 29, 33, 34, 34, 32, 27, 31, 32, 32, 33,
    30, 24, 26, 28, 32, 31, 32, 29, 25, 24, 28, 29, 30, 30, 29, 24, 21, 28, 28,
    29, 30, 30, 26, 19, 26, 29, 28, 29, 28, 26, 15, 24, 27, 27, 28, 27, 26, 16,
    22, 25, 25, 27, 26, 25, 24, 25, 25, 25, 25, 22, 13, 21, 23, 24, 24, 24, 21,
    14, 18, 22, 23, 23, 22, 20, 15, 13, 22, 22, 22, 23, 20, 17, 15, 20, 21, 21,
    21, 19, 14, 15, 17, 19, 19, 19, 18, 11, 16, 14, 16, 17, 18, 17, 8,  12, 17,
    16, 17, 14, 10, 13, 9,  15, 15, 15, 14, 10, 14, 9,  12, 13, 13, 13, 8,  12,
    9,  10, 13, 12, 12, 9,  10, 10, 7,  11, 11, 10, 6,  8,  10, 9,  8,  9,  9,
    5,  8,  12, 10, 9,  7,  7,  4,  7,  4,  6,  6,  6,  7,  9,  10, 4,  4,  4,
    5,  5,  9,  10, 4,  2,  2,  3,  4,  7,  9,  4,  2,  1,  1,  4,  6,  8,  5,
    4,  4,  4,  4,  4,  7,  7,  6,  8,  6,  4,  4,  6,  9,  9,  8,  7,  5,  4,
    5,  0,  4,  3,  2,  4,  7,  9,  0,  4,  4,  2,  4,  6,  8,  0,  4,  5,  2,
    2,  6,  8,  0,  4,  4,  2,  2,  4,  6,  2,  4,  6,  5,  5,  4,  5,  4,  6,
    8,  8,  6,  5,  4,  8,  8,  9,  9,  6,  5,  4,  38, 42, 46, 49, 49, 46, 42,
    37, 41, 46, 48, 50, 45, 42, 36, 39, 44, 47, 48, 45, 40, 34, 38, 41, 45, 48,
    44, 41, 34, 37, 41, 45, 48, 45, 41, 32, 37, 40, 43, 47, 46, 42, 30, 34, 39,
    43, 46, 46, 42, 36, 40, 44, 46, 44, 41, 37, 34, 38, 42, 45, 45, 40, 37, 33,
    37, 42, 43, 44, 41, 38, 30, 36, 39, 42, 40, 39, 37, 30, 35, 38, 42, 42, 40,
    36, 27, 33, 36, 40, 41, 39, 38, 24, 31, 35, 39, 39, 37, 37, 32, 36, 39, 39,
    39, 36, 29, 32, 35, 37, 39, 37, 35, 29, 28, 34, 36, 37, 36, 35, 28, 25, 34,
    33, 34, 35, 33, 29, 22, 32, 34, 34, 34, 33, 30, 18, 29, 31, 33, 33, 32, 29,
    17, 27, 30, 31, 32, 31, 27, 28, 31, 32, 31, 31, 27, 19, 24, 30, 31, 31, 30,
    25, 19, 20, 27, 29, 28, 28, 24, 21, 16, 26, 27, 27, 26, 22, 22, 17, 22, 26,
    26, 25, 22, 18, 18, 19, 24, 24, 24, 21, 14, 17, 15, 22, 23, 23, 20, 11, 15,
    22, 23, 24, 18, 14, 19, 12, 20, 22, 21, 18, 13, 19, 12, 16, 19, 19, 17, 10,
    16, 12, 12, 18, 18, 15, 10, 13, 13, 9,  17, 16, 13, 8,  10, 12, 10, 14, 14,
    12, 7,  10, 13, 12, 11, 12, 10, 6,  8,  7,  11, 13, 11, 9,  12, 15, 7,  7,
    11, 10, 8,  11, 13, 7,  5,  9,  8,  7,  8,  11, 7,  4,  7,  6,  7,  9,  9,
    7,  5,  5,  4,  4,  6,  8,  8,  7,  6,  6,  4,  5,  8,  10, 8,  8,  6,  5,
    4,  6,  4,  1,  2,  6,  8,  10, 13, 4,  1,  2,  5,  7,  9,  10, 4,  1,  3,
    3,  5,  7,  9,  4,  0,  3,  1,  3,  5,  7,  4,  2,  4,  4,  4,  4,  6,  5,
    5,  7,  7,  5,  4,  6,  7,  7,  7,  7,  5,  4,  5,  45, 49, 52, 55, 56, 52,
    48, 43, 47, 51, 55, 54, 51, 47, 41, 45, 50, 52, 53, 50, 46, 40, 44, 47, 51,
    52, 49, 46, 38, 41, 45, 49, 52, 50, 46, 37, 41, 44, 48, 51, 50, 46, 34, 39,
    43, 47, 50, 49, 47, 42, 45, 49, 53, 51, 48, 43, 40, 45, 49, 53, 51, 47, 42,
    37, 43, 47, 51, 49, 46, 40, 35, 40, 44, 48, 46, 45, 40, 33, 41, 44, 46, 45,
    45, 40, 30, 39, 42, 45, 45, 44, 40, 26, 36, 40, 44, 43, 42, 40, 38, 43, 45,
    46, 45, 42, 34, 34, 41, 44, 44, 44, 40, 34, 31, 40, 42, 41, 41, 39, 33, 28,
    37, 39, 39, 38, 36, 33, 24, 36, 38, 40, 38, 35, 33, 21, 32, 37, 37, 37, 34,
    33, 19, 30, 34, 35, 35, 34, 30, 31, 37, 38, 37, 36, 32, 25, 27, 34, 36, 35,
    35, 30, 25, 24, 31, 35, 34, 33, 27, 25, 20, 28, 31, 32, 30, 25, 26, 20, 25,
    31, 31, 29, 23, 22, 21, 21, 29, 29, 28, 23, 19, 20, 17, 26, 28, 27, 22, 14,
    18, 27, 29, 29, 23, 19, 25, 15, 23, 27, 27, 22, 16, 25, 15, 19, 25, 25, 20,
    13, 20, 15, 15, 23, 23, 17, 11, 17, 15, 12, 21, 21, 15, 10, 14, 16, 12, 18,
    19, 15, 8,  12, 15, 13, 14, 17, 13, 8,  12, 10, 14, 19, 15, 13, 16, 21, 10,
    10, 17, 13, 12, 14, 18, 10, 6,  15, 11, 9,  11, 14, 10, 5,  11, 8,  7,  10,
    11, 10, 6,  9,  6,  5,  8,  10, 10, 8,  6,  5,  4,  6,  10, 11, 9,  7,  5,
    4,  6,  8,  5,  3,  6,  9,  12, 14, 16, 5,  3,  5,  8,  10, 12, 14, 5,  3,
    3,  6,  7,  9,  11, 5,  3,  0,  3,  6,  10, 10, 5,  3,  3,  3,  3,  5,  8,
    6,  5,  5,  6,  4,  5,  7,  8,  6,  6,  6,  5,  4,  6,  38, 43, 47, 49, 51,
    47, 43, 36, 41, 43, 50, 49, 46, 41, 35, 39, 44, 46, 47, 45, 39, 34, 37, 40,
    44, 46, 42, 38, 31, 34, 38, 42, 44, 42, 38, 30, 34, 36, 40, 44, 43, 37, 28,
    31, 35, 39, 42, 42, 38, 34, 40, 44, 47, 45, 42, 38, 34, 38, 42, 46, 45, 41,
    37, 32, 36, 40, 43, 43, 39, 34, 31, 34, 37, 40, 39, 38, 33, 27, 32, 35, 38,
    38, 37, 33, 24, 32, 34, 37, 37, 36, 33, 20, 29, 33, 36, 36, 35, 34, 33, 36,
    38, 38, 39, 36, 30, 29, 34, 38, 39, 39, 35, 29, 26, 33, 36, 36, 36, 34, 27,
    23, 31, 32, 33, 33, 31, 26, 19, 29, 32, 32, 31, 29, 25, 15, 28, 30, 31, 31,
    28, 25, 15, 25, 28, 29, 29, 27, 24, 26, 30, 31, 31, 32, 28, 21, 22, 29, 30,
    31, 30, 25, 20, 18, 26, 28, 29, 27, 23, 20, 16, 22, 25, 25, 25, 19, 20, 14,
    19, 25, 24, 23, 17, 16, 15, 16, 22, 22, 21, 18, 12, 15, 13, 20, 20, 20, 17,
    9,  14, 22, 23, 24, 20, 15, 20, 10, 19, 21, 22, 18, 13, 21, 11, 14, 19, 19,
    16, 10, 16, 10, 9,  17, 16, 12, 7,  12, 10, 7,  15, 15, 11, 7,  9,  11, 8,
    12, 12, 10, 5,  7,  11, 9,  10, 11, 9,  4,  6,  5,  11, 14, 12, 11, 13, 17,
    5,  7,  12, 11, 10, 11, 14, 6,  3,  9,  8,  7,  8,  10, 5,  3,  6,  5,  4,
    5,  7,  5,  3,  4,  3,  2,  4,  6,  6,  5,  7,  6,  4,  3,  7,  8,  7,  8,
    8,  5,  3,  4,  2,  2,  4,  7,  9,  12, 13, 2,  2,  3,  6,  8,  9,  10, 2,
    2,  3,  4,  5,  6,  8,  2,  1,  3,  0,  3,  5,  6,  2,  1,  5,  6,  4,  3,
    5,  3,  5,  11, 11, 7,  3,  4,  5,  9,  12, 13, 8,  4,  3,  32, 37, 41, 44,
    43, 41, 38, 30, 35, 39, 44, 44, 41, 36, 30, 34, 39, 41, 42, 38, 34, 28, 32,
    35, 38, 41, 37, 32, 26, 29, 31, 35, 38, 36, 32, 24, 27, 30, 34, 38, 36, 33,
    22, 25, 29, 34, 36, 36, 32, 30, 35, 38, 41, 41, 37, 33, 30, 32, 36, 40, 38,
    36, 31, 27, 31, 35, 38, 37, 34, 30, 25, 29, 32, 35, 35, 32, 27, 23, 26, 30,
    32, 32, 31, 28, 21, 25, 28, 30, 31, 30, 27, 18, 23, 27, 30, 29, 29, 28, 27,
    31, 33, 34, 35, 33, 26, 25, 29, 31, 33, 33, 30, 24, 23, 28, 31, 30, 31, 29,
    23, 19, 26, 27, 26, 28, 26, 21, 15, 24, 25, 25, 25, 24, 21, 13, 23, 24, 23,
    23, 23, 21, 12, 21, 22, 22, 23, 23, 19, 22, 25, 26, 27, 27, 25, 18, 19, 24,
    24, 25, 25, 22, 17, 15, 22, 23, 23, 22, 19, 16, 12, 19, 19, 19, 20, 16, 16,
    11, 16, 18, 17, 17, 14, 12, 12, 13, 16, 16, 16, 13, 9,  12, 11, 15, 14, 15,
    13, 6,  10, 17, 18, 18, 17, 13, 18, 7,  16, 16, 17, 16, 10, 17, 7,  12, 15,
    14, 13, 8,  12, 7,  7,  11, 10, 10, 5,  8,  7,  4,  9,  9,  8,  4,  5,  7,
    6,  6,  7,  6,  3,  5,  9,  8,  7,  5,  5,  2,  4,  3,  8,  9,  9,  9,  11,
    15, 3,  6,  7,  8,  8,  9,  11, 3,  2,  5,  4,  6,  6,  7,  3,  1,  1,  1,
    3,  3,  4,  2,  2,  3,  3,  2,  2,  4,  4,  5,  9,  8,  4,  2,  5,  6,  9,
    11, 9,  6,  2,  3,  2,  4,  4,  6,  8,  10, 11, 2,  4,  4,  5,  7,  8,  8,
    2,  4,  5,  3,  4,  4,  5,  2,  3,  7,  3,  0,  3,  4,  1,  4,  7,  7,  5,
    2,  3,  3,  8,  11, 12, 7,  3,  2,  8,  12, 13, 12, 8,  4,  2,  27, 32, 36,
    39, 40, 36, 33, 27, 30, 35, 39, 38, 35, 32, 25, 29, 33, 37, 38, 34, 30, 25,
    26, 30, 34, 36, 32, 27, 21, 24, 27, 30, 34, 31, 27, 19, 22, 25, 28, 32, 31,
    28, 18, 20, 24, 27, 30, 31, 27, 26, 29, 34, 37, 35, 33, 28, 24, 27, 31, 35,
    36, 31, 28, 23, 26, 30, 33, 32, 29, 24, 21, 24, 28, 30, 29, 28, 23, 19, 21,
    24, 26, 26, 26, 22, 17, 20, 22, 25, 26, 25, 22, 14, 18, 22, 25, 24, 24, 22,
    23, 26, 28, 29, 31, 28, 24, 22, 25, 27, 28, 28, 27, 21, 20, 25, 25, 26, 26,
    25, 19, 17, 22, 22, 22, 22, 22, 17, 13, 19, 20, 19, 20, 19, 16, 10, 18, 19,
    19, 18, 18, 17, 10, 15, 17, 17, 18, 17, 15, 20, 21, 21, 22, 23, 22, 15, 17,
    20, 19, 21, 21, 20, 14, 13, 19, 19, 18, 18, 17, 13, 9,  16, 15, 15, 14, 13,
    12, 8,  13, 13, 12, 12, 11, 8,  9,  11, 11, 11, 11, 10, 6,  10, 8,  9,  9,
    10, 9,  4,  8,  13, 13, 14, 15, 12, 15, 5,  12, 12, 13, 13, 9,  13, 5,  10,
    10, 9,  10, 7,  9,  5,  5,  6,  6,  6,  3,  5,  4,  2,  4,  3,  3,  3,  3,
    5,  5,  5,  4,  2,  2,  4,  6,  7,  7,  5,  3,  1,  3,  2,  4,  6,  7,  8,
    10, 12, 2,  3,  5,  6,  7,  8,  9,  2,  3,  4,  4,  4,  5,  6,  2,  2,  2,
    2,  1,  2,  3,  2,  3,  6,  4,  3,  1,  3,  3,  7,  10, 8,  5,  2,  3,  6,
    9,  10, 9,  6,  3,  2,  4,  6,  5,  5,  7,  9,  10, 4,  6,  6,  5,  6,  7,
    7,  3,  5,  7,  3,  3,  4,  5,  4,  5,  10, 5,  3,  0,  3,  4,  6,  8,  8,
    5,  3,  1,  6,  9,  12, 11, 7,  4,  1,  9,  11, 12, 12, 8,  5,  2,  24, 27,
    32, 36, 36, 33, 29, 23, 26, 30, 34, 35, 32, 28, 21, 25, 29, 32, 33, 30, 26,
    20, 22, 26, 29, 32, 28, 23, 17, 19, 22, 26, 28, 26, 23, 15, 17, 20, 23, 27,
    26, 22, 14, 16, 19, 22, 26, 26, 22, 21, 25, 28, 33, 31, 29, 25, 20, 24, 28,
    31, 31, 27, 23, 19, 22, 26, 28, 28, 25, 22, 18, 20, 23, 25, 25, 24, 19, 15,
    17, 19, 21, 22, 22, 18, 13, 15, 18, 20, 20, 21, 18, 11, 14, 17, 20, 19, 19,
    18, 19, 22, 24, 25, 27, 25, 20, 18, 21, 23, 24, 24, 23, 18, 17, 20, 21, 22,
    22, 21, 17, 15, 17, 18, 18, 18, 18, 13, 10, 14, 15, 15, 15, 15, 13, 6,  13,
    14, 14, 14, 14, 13, 7,  12, 13, 12, 12, 12, 12, 17, 17, 17, 18, 19, 19, 13,
    15, 15, 16, 16, 17, 17, 11, 11, 14, 15, 14, 14, 13, 10, 7,  12, 11, 10, 10,
    10, 9,  5,  9,  8,  8,  7,  7,  6,  6,  7,  6,  6,  6,  6,  3,  7,  4,  5,
    5,  5,  5,  3,  7,  9,  9,  10, 11, 11, 13, 2,  7,  8,  9,  9,  8,  11, 2,
    6,  6,  5,  6,  6,  6,  2,  3,  3,  2,  2,  2,  3,  1,  2,  2,  2,  2,  0,
    2,  2,  5,  4,  3,  2,  1,  2,  3,  6,  6,  4,  3,  2,  1,  3,  4,  5,  7,
    8,  9,  11, 3,  4,  5,  6,  6,  7,  8,  3,  6,  4,  4,  4,  4,  5,  3,  5,
    4,  3,  2,  1,  2,  3,  6,  6,  5,  3,  2,  1,  5,  7,  9,  7,  4,  2,  0,
    6,  7,  9,  8,  5,  3,  1,  6,  7,  6,  5,  7,  8,  9,  6,  8,  7,  5,  6,
    6,  6,  6,  8,  9,  4,  3,  3,  3,  6,  8,  9,  6,  4,  2,  0,  6,  8,  10,
    8,  4,  3,  2,  7,  9,  11, 10, 6,  3,  2,  7,  9,  11, 10, 7,  4,  2,  33,
    38, 42, 45, 45, 42, 39, 33, 37, 41, 45, 45, 43, 37, 30, 35, 39, 42, 43, 41,
    38, 30, 33, 36, 40, 43, 39, 36, 27, 30, 34, 38, 41, 40, 36, 26, 30, 33, 36,
    40, 39, 35, 23, 27, 32, 36, 39, 38, 36, 31, 36, 39, 42, 41, 38, 35, 29, 33,
    38, 41, 41, 37, 33, 28, 32, 36, 40, 39, 37, 32, 27, 30, 34, 36, 36, 36, 31,
    25, 28, 32, 34, 35, 34, 30, 22, 27, 29, 33, 34, 33, 31, 20, 24, 28, 33, 32,
    33, 31, 28, 32, 35, 34, 36, 34, 28, 27, 30, 32, 35, 35, 32, 28, 24, 29, 32,
    33, 31, 32, 27, 21, 28, 28, 30, 29, 29, 25, 17, 25, 27, 28, 28, 28, 25, 14,
    24, 26, 26, 26, 27, 26, 14, 21, 24, 25, 24, 25, 24, 24, 26, 27, 28, 29, 26,
    17, 20, 25, 26, 28, 28, 25, 17, 17, 23, 25, 24, 24, 23, 18, 13, 20, 21, 21,
    21, 19, 18, 13, 18, 20, 19, 19, 18, 14, 14, 15, 17, 18, 18, 18, 10, 14, 12,
    15, 16, 17, 16, 9,  12, 18, 19, 20, 19, 14, 17, 9,  16, 17, 18, 17, 12, 17,
    8,  13, 15, 15, 15, 10, 14, 9,  8,  12, 12, 12, 8,  10, 8,  5,  10, 10, 9,
    7,  8,  9,  7,  7,  8,  8,  5,  10, 10, 8,  7,  6,  6,  3,  8,  4,  8,  9,
    9,  9,  12, 14, 4,  6,  7,  8,  9,  10, 13, 4,  2,  5,  5,  6,  8,  10, 4,
    2,  1,  1,  4,  6,  8,  4,  2,  2,  2,  2,  3,  8,  5,  4,  6,  4,  3,  2,
    6,  7,  7,  6,  5,  3,  2,  5,  2,  4,  4,  5,  8,  10, 12, 2,  4,  5,  4,
    7,  8,  10, 2,  4,  5,  3,  4,  6,  7,  2,  4,  5,  2,  1,  4,  7,  0,  4,
    5,  3,  3,  2,  5,  3,  4,  6,  6,  4,  3,  4,  5,  6,  6,  6,  4,  3,  2,
    41, 45, 50, 51, 52, 50, 46, 40, 43, 48, 51, 53, 48, 44, 37, 41, 46, 50, 51,
    48, 43, 36, 39, 43, 46, 50, 46, 41, 33, 36, 41, 44, 47, 45, 41, 32, 35, 39,
    42, 46, 45, 42, 28, 34, 37, 41, 45, 45, 41, 37, 41, 47, 49, 48, 44, 41, 35,
    41, 44, 49, 48, 44, 40, 33, 39, 43, 47, 44, 42, 38, 33, 37, 40, 44, 42, 41,
    36, 29, 34, 37, 40, 41, 39, 36, 25, 33, 36, 39, 40, 38, 36, 22, 30, 35, 38,
    39, 38, 36, 34, 39, 42, 42, 42, 39, 34, 32, 37, 40, 41, 42, 38, 32, 29, 36,
    37, 38, 39, 37, 31, 25, 33, 35, 35, 35, 34, 29, 20, 31, 33, 33, 34, 32, 30,
    16, 29, 31, 31, 32, 31, 29, 16, 26, 30, 30, 31, 30, 27, 28, 33, 34, 34, 34,
    32, 23, 24, 31, 32, 34, 33, 29, 23, 20, 29, 31, 30, 30, 27, 23, 17, 24, 27,
    27, 27, 24, 23, 15, 20, 25, 26, 25, 21, 19, 16, 18, 23, 23, 24, 20, 15, 16,
    14, 21, 22, 22, 20, 11, 16, 24, 25, 26, 23, 18, 24, 12, 21, 23, 24, 22, 16,
    23, 12, 17, 21, 21, 19, 13, 19, 12, 11, 18, 17, 15, 10, 14, 11, 8,  16, 15,
    13, 9,  11, 12, 9,  13, 13, 12, 8,  10, 12, 10, 11, 12, 11, 8,  9,  7,  13,
    15, 14, 14, 16, 20, 7,  9,  14, 13, 12, 14, 16, 7,  4,  11, 11, 9,  11, 13,
    7,  4,  7,  7,  6,  8,  10, 6,  4,  4,  4,  3,  8,  9,  7,  5,  4,  3,  2,
    5,  9,  8,  7,  5,  4,  2,  4,  8,  4,  3,  5,  9,  12, 14, 16, 4,  3,  4,
    8,  11, 12, 14, 4,  3,  4,  5,  7,  9,  11, 4,  2,  3,  1,  4,  7,  8,  4,
    0,  4,  3,  2,  4,  8,  3,  3,  4,  5,  3,  3,  7,  5,  5,  5,  5,  3,  2,
    5,  47, 50, 55, 58, 58, 55, 52, 45, 50, 53, 58, 57, 54, 50, 43, 48, 52, 54,
    56, 52, 48, 42, 45, 49, 51, 55, 51, 45, 39, 42, 45, 49, 52, 50, 45, 36, 40,
    43, 47, 50, 49, 45, 32, 38, 43, 46, 49, 51, 45, 42, 47, 51, 55, 54, 50, 47,
    42, 45, 51, 55, 54, 49, 44, 40, 44, 48, 53, 51, 47, 43, 36, 43, 47, 49, 48,
    46, 40, 32, 39, 42, 46, 46, 44, 39, 28, 36, 41, 45, 43, 44, 40, 24, 35, 40,
    44, 43, 41, 40, 38, 43, 47, 47, 48, 45, 38, 36, 43, 46, 48, 47, 43, 37, 32,
    40, 44, 44, 44, 43, 35, 28, 38, 40, 40, 40, 38, 34, 22, 34, 37, 38, 37, 36,
    33, 19, 32, 37, 36, 36, 35, 33, 18, 28, 34, 35, 35, 33, 31, 32, 39, 39, 42,
    40, 36, 30, 28, 36, 38, 39, 38, 34, 28, 24, 33, 37, 36, 35, 29, 28, 21, 28,
    33, 33, 33, 27, 27, 18, 23, 31, 30, 29, 23, 23, 19, 19, 28, 28, 28, 23, 20,
    18, 15, 25, 27, 27, 22, 15, 18, 28, 31, 31, 27, 23, 29, 16, 24, 30, 30, 26,
    20, 28, 16, 20, 27, 26, 23, 17, 23, 16, 14, 23, 23, 19, 13, 19, 14, 10, 20,
    20, 16, 11, 15, 14, 10, 16, 18, 15, 9,  12, 13, 11, 13, 17, 14, 9,  11, 11,
    15, 21, 18, 17, 20, 25, 10, 10, 19, 18, 16, 17, 21, 11, 6,  16, 15, 13, 14,
    17, 10, 6,  12, 12, 9,  11, 12, 9,  5,  7,  7,  7,  9,  11, 9,  7,  5,  4,
    4,  7,  11, 10, 8,  5,  3,  3,  8,  9,  6,  5,  10, 13, 15, 18, 20, 6,  5,
    9,  12, 14, 16, 17, 5,  5,  7,  9,  10, 12, 14, 5,  4,  3,  5,  7,  8,  10,
    5,  4,  0,  2,  4,  7,  9,  5,  3,  3,  4,  3,  6,  8,  6,  4,  4,  4,  3,
    4,  7,  44, 47, 51, 55, 56, 53, 48, 43, 46, 50, 54, 55, 52, 45, 40, 44, 49,
    51, 54, 48, 45, 40, 42, 46, 50, 52, 48, 42, 35, 39, 42, 45, 48, 45, 41, 32,
    37, 39, 42, 46, 45, 41, 29, 34, 39, 42, 45, 46, 41, 42, 45, 49, 53, 51, 47,
    44, 40, 44, 48, 51, 50, 46, 42, 36, 41, 45, 47, 47, 45, 40, 33, 39, 43, 46,
    46, 43, 37, 28, 35, 39, 42, 41, 40, 36, 25, 34, 37, 40, 40, 40, 37, 21, 32,
    36, 39, 39, 38, 36, 36, 42, 43, 44, 46, 42, 37, 33, 39, 42, 44, 43, 41, 33,
    29, 38, 40, 40, 41, 40, 33, 26, 35, 37, 37, 38, 36, 29, 20, 31, 34, 34, 34,
    32, 31, 16, 28, 31, 33, 33, 30, 30, 15, 24, 31, 31, 31, 30, 27, 30, 35, 36,
    37, 37, 35, 29, 25, 33, 34, 36, 36, 31, 26, 22, 30, 34, 34, 32, 28, 26, 17,
    25, 30, 29, 29, 24, 25, 16, 19, 26, 26, 24, 21, 21, 15, 16, 25, 25, 25, 20,
    17, 15, 12, 22, 23, 23, 20, 13, 16, 26, 28, 29, 25, 22, 28, 13, 22, 26, 28,
    25, 19, 27, 13, 17, 25, 24, 22, 15, 21, 13, 12, 21, 21, 18, 11, 17, 12, 7,
    17, 17, 14, 8,  13, 11, 8,  14, 15, 13, 7,  10, 11, 9,  10, 13, 12, 7,  9,
    9,  14, 18, 18, 17, 19, 24, 9,  9,  17, 17, 16, 16, 19, 9,  6,  15, 14, 12,
    13, 15, 8,  5,  10, 10, 9,  10, 10, 7,  4,  5,  6,  5,  7,  8,  6,  5,  3,
    3,  4,  6,  8,  7,  6,  3,  2,  3,  6,  7,  5,  5,  10, 13, 15, 18, 20, 5,
    5,  9,  12, 14, 15, 16, 5,  5,  8,  10, 11, 11, 13, 5,  4,  3,  6,  7,  8,
    8,  3,  3,  2,  0,  3,  5,  7,  3,  2,  4,  5,  2,  5,  6,  4,  4,  6,  6,
    2,  4,  6,  37, 42, 45, 48, 48, 46, 42, 36, 40, 43, 47, 48, 44, 40, 34, 37,
    42, 46, 46, 42, 38, 32, 36, 41, 43, 44, 41, 34, 29, 33, 36, 39, 40, 37, 35,
    27, 29, 33, 35, 39, 37, 33, 24, 27, 30, 35, 37, 39, 34, 34, 38, 41, 46, 45,
    42, 37, 34, 37, 40, 45, 44, 40, 35, 31, 35, 39, 42, 41, 38, 34, 29, 33, 36,
    39, 38, 36, 29, 25, 30, 32, 35, 35, 33, 29, 20, 27, 29, 32, 32, 32, 29, 15,
    26, 29, 32, 31, 31, 29, 31, 34, 37, 39, 40, 37, 30, 28, 34, 36, 37, 37, 35,
    29, 25, 32, 35, 35, 34, 34, 27, 21, 30, 31, 31, 31, 29, 25, 16, 25, 28, 28,
    27, 25, 24, 12, 23, 25, 25, 25, 24, 24, 11, 19, 25, 23, 24, 24, 21, 25, 29,
    30, 31, 31, 30, 24, 21, 28, 29, 30, 30, 27, 21, 18, 25, 27, 27, 27, 23, 20,
    15, 22, 24, 23, 23, 20, 19, 12, 15, 21, 21, 19, 15, 16, 11, 12, 19, 18, 18,
    15, 12, 11, 8,  17, 16, 16, 15, 9,  13, 21, 23, 23, 22, 19, 24, 9,  18, 21,
    22, 21, 15, 22, 10, 14, 19, 18, 17, 12, 17, 10, 8,  16, 15, 14, 8,  11, 8,
    4,  12, 11, 10, 5,  8,  7,  4,  9,  8,  8,  4,  6,  6,  5,  6,  7,  7,  4,
    5,  5,  11, 13, 14, 14, 16, 20, 5,  8,  12, 13, 13, 14, 16, 5,  4,  11, 10,
    10, 11, 11, 5,  3,  7,  6,  7,  7,  6,  3,  2,  2,  1,  3,  4,  5,  3,  2,
    3,  3,  2,  3,  5,  4,  3,  4,  4,  1,  3,  4,  5,  5,  9,  11, 13, 15, 16,
    5,  5,  8,  10, 12, 12, 13, 5,  5,  7,  8,  8,  9,  10, 5,  4,  3,  4,  5,
    6,  4,  3,  2,  4,  3,  0,  3,  4,  2,  3,  5,  5,  2,  2,  3,  2,  5,  6,
    6,  3,  1,  3,  32, 35, 39, 42, 42, 40, 37, 30, 34, 38, 42, 43, 39, 35, 29,
    31, 37, 40, 41, 37, 33, 28, 29, 33, 38, 39, 35, 28, 25, 27, 30, 33, 36, 33,
    29, 22, 23, 26, 30, 34, 32, 29, 20, 22, 25, 29, 32, 32, 28, 29, 33, 36, 40,
    39, 36, 32, 28, 31, 35, 38, 39, 34, 30, 26, 30, 34, 36, 35, 32, 28, 26, 26,
    30, 33, 33, 30, 24, 21, 23, 27, 30, 29, 28, 23, 17, 22, 24, 27, 27, 26, 24,
    14, 20, 23, 26, 26, 26, 24, 27, 30, 31, 32, 35, 31, 27, 25, 29, 31, 32, 31,
    29, 24, 22, 27, 29, 28, 29, 28, 22, 19, 26, 26, 25, 25, 25, 19, 13, 22, 22,
    22, 22, 20, 18, 9,  20, 20, 20, 19, 20, 19, 8,  17, 19, 18, 18, 19, 17, 22,
    25, 25, 25, 27, 26, 19, 18, 23, 24, 24, 25, 23, 17, 14, 22, 22, 22, 21, 19,
    16, 11, 18, 18, 18, 18, 16, 14, 9,  13, 15, 14, 14, 12, 11, 9,  10, 13, 13,
    12, 12, 8,  8,  6,  12, 11, 11, 11, 5,  10, 17, 17, 18, 18, 15, 19, 7,  15,
    15, 16, 16, 12, 17, 7,  12, 13, 13, 13, 9,  12, 7,  6,  10, 9,  9,  5,  8,
    5,  2,  6,  5,  5,  3,  5,  4,  2,  4,  3,  3,  3,  4,  4,  3,  2,  2,  2,
    2,  3,  3,  9,  9,  10, 11, 13, 16, 3,  7,  8,  9,  10, 11, 12, 3,  4,  7,
    7,  7,  8,  8,  3,  3,  4,  4,  4,  4,  3,  2,  1,  4,  3,  1,  2,  3,  1,
    3,  5,  4,  2,  2,  3,  2,  4,  5,  5,  3,  0,  2,  4,  5,  6,  8,  10, 12,
    13, 4,  5,  6,  8,  9,  10, 10, 4,  5,  6,  5,  6,  6,  7,  4,  4,  5,  3,
    2,  3,  3,  2,  4,  7,  5,  3,  0,  3,  3,  5,  7,  6,  3,  2,  2,  4,  6,
    7,  7,  4,  2,  2,  26, 30, 34, 38, 38, 34, 31, 24, 29, 32, 36, 37, 33, 29,
    23, 26, 31, 35, 35, 32, 28, 22, 25, 28, 31, 33, 29, 24, 19, 21, 24, 28, 30,
    28, 24, 17, 19, 22, 25, 29, 28, 25, 16, 17, 20, 24, 27, 28, 24, 23, 27, 31,
    35, 33, 31, 27, 22, 25, 30, 33, 33, 30, 26, 21, 24, 28, 30, 31, 28, 24, 20,
    21, 25, 27, 28, 26, 20, 17, 19, 21, 24, 24, 23, 20, 15, 17, 20, 22, 22, 22,
    20, 12, 16, 19, 21, 21, 21, 20, 22, 24, 27, 27, 29, 26, 22, 20, 23, 25, 26,
    26, 25, 20, 18, 22, 23, 23, 24, 23, 18, 16, 20, 20, 20, 20, 20, 15, 11, 16,
    17, 17, 17, 16, 15, 7,  16, 15, 15, 15, 15, 14, 7,  14, 14, 14, 14, 14, 14,
    18, 18, 19, 20, 22, 21, 14, 15, 18, 18, 19, 19, 19, 13, 12, 17, 17, 16, 16,
    15, 11, 8,  15, 13, 12, 13, 12, 10, 6,  10, 10, 9,  9,  9,  7,  6,  8,  8,
    8,  7,  8,  4,  7,  4,  7,  6,  6,  6,  3,  7,  11, 11, 12, 13, 12, 14, 4,
    9,  10, 10, 11, 10, 12, 4,  8,  8,  7,  7,  7,  8,  4,  5,  4,  4,  4,  4,
    4,  2,  1,  1,  1,  1,  2,  3,  2,  3,  4,  3,  2,  0,  3,  3,  4,  5,  3,
    3,  2,  2,  3,  5,  6,  8,  9,  11, 12, 3,  4,  6,  7,  7,  8,  9,  3,  4,
    4,  5,  5,  5,  6,  3,  3,  4,  3,  2,  2,  2,  1,  5,  6,  4,  3,  2,  2,
    3,  7,  8,  6,  4,  2,  2,  5,  7,  9,  8,  4,  3,  0,  5,  7,  6,  6,  8,
    9,  10, 5,  7,  7,  6,  7,  7,  7,  5,  7,  8,  4,  3,  4,  5,  5,  6,  8,
    5,  3,  1,  2,  5,  8,  10, 8,  4,  3,  0,  7,  9,  10, 9,  5,  3,  1,  8,
    9,  10, 10, 6,  4,  2,  36, 41, 47, 48, 47, 47, 42, 36, 39, 44, 48, 49, 45,
    41, 34, 38, 42, 45, 47, 44, 39, 32, 35, 39, 42, 45, 41, 36, 29, 33, 35, 39,
    41, 39, 37, 26, 29, 32, 37, 41, 39, 36, 23, 27, 32, 34, 38, 39, 35, 33, 38,
    42, 45, 44, 42, 39, 31, 37, 41, 45, 44, 40, 38, 31, 35, 40, 42, 42, 40, 35,
    29, 33, 36, 39, 38, 38, 31, 25, 28, 32, 36, 35, 35, 32, 22, 27, 30, 32, 34,
    34, 31, 18, 24, 28, 32, 33, 32, 31, 31, 36, 37, 38, 39, 37, 32, 29, 33, 35,
    37, 38, 36, 31, 26, 32, 36, 35, 35, 35, 30, 22, 29, 31, 31, 31, 31, 26, 17,
    26, 27, 28, 27, 27, 26, 13, 24, 26, 26, 26, 27, 26, 12, 21, 23, 25, 24, 25,
    24, 27, 29, 30, 31, 32, 31, 23, 21, 27, 29, 30, 29, 28, 22, 19, 25, 27, 26,
    27, 25, 22, 14, 21, 24, 23, 23, 22, 20, 13, 17, 20, 19, 20, 18, 16, 12, 13,
    17, 18, 18, 17, 12, 12, 10, 15, 16, 17, 17, 10, 13, 20, 22, 22, 22, 19, 23,
    10, 18, 20, 20, 21, 16, 21, 10, 15, 18, 18, 18, 13, 17, 10, 9,  14, 14, 14,
    10, 12, 8,  4,  10, 10, 10, 8,  9,  7,  5,  7,  7,  8,  6,  9,  8,  7,  5,
    5,  6,  6,  8,  5,  11, 12, 13, 15, 17, 20, 5,  8,  10, 11, 13, 14, 16, 5,
    5,  8,  8,  10, 12, 13, 5,  4,  4,  4,  6,  8,  8,  4,  3,  2,  1,  2,  6,
    8,  4,  2,  4,  3,  1,  5,  8,  5,  5,  4,  3,  2,  4,  6,  4,  6,  6,  9,
    13, 16, 17, 4,  6,  7,  7,  11, 13, 14, 5,  6,  7,  4,  8,  9,  11, 4,  5,
    6,  3,  3,  5,  7,  3,  3,  5,  3,  2,  3,  7,  0,  4,  5,  5,  2,  1,  5,
    3,  5,  5,  5,  3,  1,  4,  42, 48, 52, 54, 55, 52, 49, 41, 46, 50, 54, 53,
    50, 46, 40, 44, 48, 52, 53, 50, 45, 38, 41, 46, 50, 52, 47, 41, 35, 39, 41,
    46, 47, 46, 42, 31, 35, 37, 42, 46, 44, 41, 28, 33, 38, 41, 44, 44, 41, 39,
    45, 48, 53, 51, 47, 44, 39, 43, 47, 50, 50, 47, 42, 36, 43, 46, 49, 48, 44,
    40, 34, 39, 44, 45, 46, 42, 36, 29, 35, 38, 41, 41, 40, 37, 24, 33, 36, 39,
    39, 39, 36, 20, 31, 34, 38, 38, 37, 37, 36, 40, 43, 43, 46, 43, 37, 34, 39,
    42, 43, 43, 41, 36, 30, 39, 40, 41, 41, 39, 33, 25, 35, 37, 37, 37, 35, 30,
    20, 31, 33, 33, 33, 32, 31, 15, 28, 31, 31, 31, 31, 30, 15, 25, 29, 30, 30,
    30, 27, 30, 35, 37, 37, 38, 36, 28, 25, 33, 34, 36, 35, 32, 27, 21, 30, 34,
    32, 32, 29, 26, 18, 26, 30, 29, 30, 26, 25, 16, 19, 26, 25, 25, 21, 21, 15,
    16, 23, 24, 24, 21, 17, 15, 12, 21, 22, 22, 20, 13, 17, 25, 27, 29, 27, 23,
    29, 14, 22, 26, 27, 25, 20, 27, 13, 18, 23, 23, 22, 17, 21, 13, 12, 20, 20,
    18, 12, 16, 12, 7,  16, 16, 14, 9,  13, 11, 7,  13, 13, 13, 8,  10, 10, 8,
    10, 12, 11, 8,  9,  9,  15, 18, 19, 18, 21, 24, 9,  10, 17, 17, 17, 18, 20,
    9,  6,  14, 14, 14, 15, 16, 9,  5,  10, 10, 10, 11, 11, 7,  4,  5,  5,  5,
    8,  10, 6,  4,  2,  2,  4,  6,  10, 7,  5,  3,  2,  3,  7,  8,  6,  6,  9,
    14, 16, 19, 21, 6,  6,  8,  13, 15, 16, 18, 6,  6,  6,  10, 12, 13, 14, 6,
    5,  5,  5,  8,  9,  9,  4,  3,  3,  2,  3,  5,  9,  4,  0,  3,  4,  1,  6,
    7,  3,  3,  4,  4,  2,  4,  6,  49, 54, 58, 61, 61, 58, 53, 48, 51, 57, 60,
    60, 57, 53, 46, 50, 54, 57, 59, 54, 51, 44, 47, 51, 55, 56, 51, 46, 40, 44,
    47, 51, 53, 49, 46, 36, 41, 44, 46, 50, 50, 46, 32, 38, 42, 46, 49, 48, 47,
    45, 49, 54, 58, 56, 54, 48, 44, 48, 52, 58, 56, 52, 47, 41, 47, 51, 55, 54,
    50, 44, 38, 44, 48, 52, 50, 48, 41, 33, 42, 44, 48, 46, 46, 41, 27, 37, 41,
    44, 45, 43, 40, 23, 34, 39, 43, 42, 42, 41, 41, 46, 50, 50, 51, 49, 41, 38,
    45, 48, 50, 49, 46, 40, 33, 44, 46, 47, 46, 44, 37, 30, 40, 43, 43, 43, 41,
    34, 24, 34, 39, 39, 39, 35, 34, 19, 30, 36, 36, 36, 35, 35, 17, 26, 34, 35,
    34, 34, 32, 34, 42, 41, 43, 42, 41, 34, 29, 38, 41, 41, 40, 36, 33, 25, 34,
    39, 39, 36, 33, 31, 21, 29, 36, 35, 33, 28, 29, 19, 23, 31, 32, 29, 24, 26,
    18, 18, 28, 29, 27, 23, 22, 17, 14, 25, 26, 26, 23, 17, 20, 29, 33, 34, 30,
    28, 33, 17, 25, 32, 32, 29, 24, 31, 17, 21, 29, 30, 26, 20, 26, 17, 15, 25,
    26, 22, 15, 21, 15, 10, 20, 22, 17, 11, 17, 13, 9,  16, 19, 15, 10, 14, 13,
    9,  11, 17, 15, 9,  11, 12, 17, 24, 23, 22, 24, 30, 12, 12, 22, 22, 20, 21,
    25, 12, 9,  19, 19, 17, 18, 20, 12, 8,  14, 16, 13, 13, 14, 10, 6,  7,  11,
    7,  10, 12, 9,  5,  4,  6,  5,  8,  10, 8,  6,  4,  5,  5,  7,  10, 8,  7,
    16, 18, 20, 23, 24, 8,  8,  13, 17, 19, 20, 20, 8,  7,  11, 14, 16, 16, 17,
    8,  6,  5,  11, 11, 12, 10, 6,  4,  3,  4,  5,  7,  10, 5,  3,  0,  1,  3,
    6,  9,  5,  3,  2,  2,  3,  5,  8,  48, 52, 55, 59, 59, 57, 52, 47, 50, 55,
    59, 59, 56, 50, 44, 48, 52, 56, 58, 53, 49, 43, 46, 50, 53, 54, 51, 44, 38,
    44, 46, 49, 52, 49, 44, 34, 40, 43, 45, 50, 48, 43, 30, 37, 41, 44, 48, 47,
    43, 45, 51, 53, 56, 56, 51, 47, 44, 47, 53, 55, 56, 50, 45, 40, 47, 51, 54,
    52, 48, 44, 36, 43, 48, 50, 49, 44, 40, 32, 39, 45, 47, 44, 43, 39, 26, 36,
    40, 43, 42, 42, 39, 21, 33, 38, 42, 42, 41, 40, 40, 45, 47, 48, 50, 48, 40,
    37, 44, 48, 46, 49, 46, 38, 32, 42, 46, 45, 46, 43, 37, 28, 40, 42, 43, 41,
    40, 33, 23, 35, 37, 38, 36, 34, 33, 17, 29, 35, 35, 35, 34, 34, 16, 24, 33,
    33, 33, 32, 31, 32, 39, 40, 43, 42, 40, 34, 28, 38, 40, 41, 40, 36, 32, 24,
    33, 38, 38, 37, 33, 30, 20, 28, 34, 34, 33, 28, 28, 19, 21, 31, 30, 28, 24,
    25, 17, 17, 27, 27, 26, 22, 21, 16, 13, 23, 26, 26, 21, 17, 19, 29, 33, 34,
    30, 27, 33, 16, 24, 32, 32, 29, 24, 31, 16, 21, 29, 29, 26, 20, 26, 16, 15,
    24, 25, 22, 14, 20, 14, 10, 19, 21, 17, 10, 17, 12, 8,  14, 17, 15, 9,  13,
    12, 8,  10, 16, 14, 9,  11, 11, 17, 23, 23, 22, 24, 29, 12, 12, 21, 22, 21,
    21, 24, 12, 9,  19, 19, 17, 18, 20, 11, 7,  14, 15, 13, 12, 13, 10, 5,  7,
    10, 7,  9,  11, 8,  5,  4,  6,  5,  7,  10, 7,  5,  4,  4,  4,  7,  9,  8,
    8,  16, 18, 21, 23, 24, 8,  8,  14, 18, 20, 20, 20, 8,  8,  11, 16, 15, 15,
    16, 8,  7,  6,  11, 11, 11, 10, 6,  5,  4,  5,  5,  6,  9,  4,  4,  1,  0,
    3,  6,  8,  4,  3,  2,  2,  2,  5,  7,  41, 45, 48, 52, 51, 50, 45, 39, 42,
    46, 52, 51, 47, 43, 37, 41, 45, 49, 49, 46, 41, 36, 39, 41, 46, 47, 44, 36,
    33, 36, 38, 42, 43, 40, 37, 29, 32, 35, 39, 42, 41, 37, 25, 30, 34, 37, 40,
    41, 37, 37, 42, 45, 49, 48, 44, 40, 36, 41, 44, 47, 47, 42, 37, 33, 38, 43,
    45, 44, 42, 36, 31, 37, 39, 41, 41, 38, 32, 26, 33, 35, 38, 38, 35, 32, 21,
    30, 33, 35, 34, 34, 31, 16, 28, 31, 34, 34, 33, 32, 34, 39, 40, 43, 42, 40,
    33, 31, 37, 40, 41, 40, 37, 33, 26, 35, 38, 39, 37, 36, 30, 24, 32, 33, 34,
    34, 32, 26, 17, 27, 31, 30, 30, 27, 26, 13, 24, 29, 28, 27, 26, 27, 12, 20,
    27, 27, 27, 26, 24, 27, 33, 32, 34, 34, 33, 27, 22, 30, 33, 32, 32, 29, 24,
    20, 27, 31, 31, 30, 26, 23, 17, 23, 27, 27, 26, 21, 22, 13, 17, 24, 23, 21,
    18, 18, 12, 12, 21, 20, 19, 17, 15, 12, 9,  19, 19, 19, 17, 11, 15, 23, 26,
    26, 24, 21, 26, 11, 20, 24, 25, 23, 18, 24, 11, 15, 22, 22, 20, 15, 19, 11,
    10, 19, 18, 16, 10, 13, 9,  5,  14, 14, 12, 6,  10, 8,  4,  10, 11, 10, 5,
    8,  8,  5,  7,  9,  8,  5,  6,  7,  13, 16, 17, 16, 19, 23, 7,  9,  15, 15,
    15, 16, 18, 7,  5,  13, 12, 13, 13, 13, 7,  4,  10, 9,  9,  9,  8,  5,  2,
    4,  4,  4,  5,  6,  3,  2,  2,  1,  2,  4,  6,  4,  3,  2,  2,  2,  4,  5,
    6,  6,  11, 13, 15, 17, 18, 6,  6,  11, 13, 14, 15, 15, 6,  6,  8,  10, 11,
    11, 11, 5,  5,  4,  6,  7,  7,  6,  3,  3,  3,  2,  2,  3,  5,  2,  1,  3,
    3,  0,  3,  4,  2,  3,  4,  4,  2,  3,  4,  33, 38, 42, 46, 45, 43, 37, 32,
    36, 40, 45, 44, 41, 37, 31, 34, 39, 42, 43, 39, 34, 30, 32, 36, 39, 40, 37,
    31, 27, 29, 31, 36, 37, 35, 31, 23, 26, 29, 33, 36, 34, 31, 22, 25, 28, 30,
    34, 34, 31, 31, 34, 38, 42, 42, 37, 34, 30, 33, 38, 41, 40, 36, 32, 29, 32,
    36, 38, 38, 36, 28, 27, 29, 32, 36, 35, 32, 27, 22, 26, 30, 32, 31, 30, 26,
    18, 23, 26, 29, 29, 29, 26, 15, 23, 25, 28, 28, 28, 26, 28, 31, 35, 34, 37,
    34, 28, 26, 31, 31, 34, 34, 32, 26, 23, 30, 31, 31, 31, 30, 23, 19, 28, 28,
    28, 28, 26, 21, 14, 24, 24, 24, 23, 23, 21, 10, 21, 23, 21, 22, 22, 21, 10,
    19, 21, 20, 21, 21, 18, 24, 26, 27, 27, 29, 27, 21, 19, 25, 26, 27, 27, 24,
    18, 16, 23, 24, 24, 24, 21, 18, 12, 19, 21, 20, 21, 18, 17, 10, 14, 17, 17,
    16, 13, 13, 10, 10, 15, 15, 14, 13, 10, 9,  7,  14, 13, 13, 12, 6,  11, 18,
    19, 20, 20, 16, 21, 8,  16, 18, 18, 18, 13, 19, 8,  12, 15, 15, 15, 11, 14,
    8,  7,  12, 12, 11, 6,  9,  6,  2,  8,  8,  7,  4,  6,  5,  3,  6,  5,  5,
    3,  5,  5,  3,  4,  4,  3,  3,  4,  4,  10, 10, 11, 13, 14, 18, 4,  8,  10,
    10, 12, 12, 13, 4,  4,  9,  8,  9,  9,  9,  4,  3,  5,  5,  5,  5,  4,  2,
    2,  2,  2,  2,  3,  4,  2,  1,  5,  4,  2,  2,  4,  3,  3,  5,  4,  2,  2,
    3,  5,  5,  8,  10, 11, 13, 14, 5,  5,  7,  9,  10, 11, 11, 5,  5,  6,  7,
    7,  8,  8,  5,  4,  5,  3,  3,  4,  3,  3,  3,  7,  5,  2,  2,  3,  1,  5,
    6,  6,  3,  0,  3,  4,  6,  6,  6,  4,  2,  2,  27, 31, 35, 38, 39, 36, 33,
    25, 30, 34, 39, 38, 35, 30, 25, 29, 32, 36, 37, 34, 29, 24, 26, 29, 32, 36,
    31, 26, 21, 24, 26, 29, 33, 30, 26, 18, 20, 23, 27, 30, 30, 25, 17, 19, 22,
    25, 29, 29, 26, 25, 28, 33, 35, 35, 33, 29, 24, 28, 32, 35, 35, 32, 27, 23,
    26, 30, 32, 32, 30, 25, 22, 24, 27, 29, 29, 26, 21, 19, 20, 23, 26, 26, 25,
    21, 16, 18, 21, 24, 23, 24, 21, 13, 17, 20, 22, 23, 22, 21, 22, 26, 28, 29,
    31, 28, 23, 22, 24, 26, 28, 28, 27, 22, 20, 23, 25, 25, 25, 25, 19, 17, 22,
    22, 22, 22, 21, 16, 11, 18, 19, 18, 18, 17, 16, 8,  17, 17, 17, 17, 16, 16,
    8,  16, 16, 15, 15, 16, 14, 20, 21, 20, 22, 24, 22, 16, 16, 20, 20, 21, 21,
    20, 14, 13, 18, 18, 18, 17, 17, 13, 9,  16, 15, 14, 14, 14, 12, 7,  12, 11,
    11, 10, 10, 8,  7,  9,  10, 9,  9,  9,  5,  8,  5,  8,  8,  8,  8,  3,  8,
    13, 13, 14, 15, 13, 15, 5,  11, 12, 12, 13, 10, 14, 5,  10, 10, 9,  9,  8,
    9,  5,  5,  6,  6,  5,  4,  5,  3,  1,  2,  2,  2,  2,  3,  3,  2,  3,  2,
    1,  2,  3,  4,  3,  4,  3,  2,  0,  2,  3,  6,  7,  8,  9,  11, 13, 3,  5,
    7,  8,  8,  9,  10, 3,  4,  5,  5,  6,  6,  6,  3,  3,  3,  2,  2,  3,  3,
    1,  4,  5,  4,  3,  0,  2,  1,  5,  7,  5,  3,  1,  2,  3,  6,  7,  6,  4,
    2,  2,  4,  6,  6,  7,  9,  10, 11, 4,  6,  6,  6,  8,  8,  8,  4,  6,  7,
    4,  4,  4,  6,  4,  6,  7,  4,  2,  1,  2,  3,  7,  8,  6,  3,  2,  1,  5,
    7,  9,  8,  4,  3,  0,  6,  7,  9,  9,  5,  3,  2,  38, 44, 48, 51, 51, 48,
    46, 38, 42, 46, 50, 51, 48, 44, 37, 41, 45, 47, 49, 44, 41, 34, 38, 41, 45,
    47, 43, 36, 32, 34, 38, 42, 42, 38, 37, 28, 30, 33, 36, 41, 38, 37, 23, 26,
    32, 35, 39, 40, 36, 37, 39, 45, 49, 49, 44, 41, 36, 39, 43, 47, 48, 44, 39,
    34, 37, 42, 45, 44, 42, 36, 31, 36, 38, 41, 42, 38, 32, 27, 31, 35, 38, 36,
    36, 31, 22, 28, 31, 33, 34, 35, 32, 18, 25, 29, 32, 33, 33, 32, 34, 36, 40,
    41, 43, 41, 37, 31, 34, 39, 40, 40, 39, 34, 28, 35, 37, 37, 37, 37, 32, 23,
    33, 34, 34, 34, 32, 27, 18, 28, 29, 30, 29, 28, 27, 13, 24, 26, 26, 27, 27,
    27, 11, 21, 24, 24, 25, 25, 25, 28, 32, 33, 34, 36, 35, 27, 23, 30, 31, 34,
    33, 31, 25, 20, 28, 29, 30, 30, 28, 24, 16, 23, 26, 26, 26, 24, 23, 14, 17,
    22, 22, 21, 19, 18, 12, 13, 17, 19, 18, 18, 15, 11, 9,  16, 16, 17, 17, 11,
    15, 23, 25, 26, 27, 23, 27, 12, 20, 23, 25, 25, 21, 25, 12, 16, 21, 21, 21,
    17, 20, 12, 11, 17, 17, 17, 12, 14, 10, 5,  13, 12, 11, 8,  11, 7,  4,  8,
    8,  9,  7,  10, 7,  5,  5,  6,  7,  7,  9,  7,  14, 16, 17, 19, 22, 24, 8,
    11, 15, 16, 18, 19, 20, 8,  7,  13, 13, 15, 15, 16, 7,  6,  9,  9,  11, 10,
    9,  5,  4,  4,  4,  4,  7,  9,  5,  3,  3,  2,  3,  5,  8,  4,  2,  3,  3,
    1,  5,  7,  8,  7,  9,  14, 18, 20, 21, 7,  7,  9,  12, 16, 17, 18, 7,  7,
    9,  9,  12, 14, 14, 8,  6,  8,  5,  7,  9,  7,  5,  5,  6,  4,  2,  4,  8,
    3,  3,  5,  4,  2,  4,  6,  0,  4,  5,  5,  3,  3,  5,  45, 50, 54, 59, 58,
    56, 50, 44, 48, 52, 57, 58, 51, 48, 42, 46, 51, 55, 54, 52, 46, 41, 44, 46,
    51, 53, 48, 41, 36, 41, 44, 47, 48, 45, 41, 32, 37, 40, 42, 45, 46, 42, 28,
    33, 37, 42, 45, 46, 42, 42, 47, 50, 54, 54, 50, 46, 39, 44, 50, 53, 53, 49,
    45, 39, 43, 48, 51, 50, 46, 41, 35, 41, 45, 47, 46, 43, 36, 30, 37, 41, 43,
    41, 40, 37, 24, 33, 38, 38, 40, 40, 37, 19, 31, 35, 38, 39, 38, 36, 38, 43,
    46, 46, 48, 45, 41, 34, 41, 46, 46, 47, 44, 38, 31, 41, 42, 44, 43, 40, 36,
    27, 38, 39, 40, 38, 37, 32, 21, 33, 35, 35, 34, 32, 31, 16, 26, 32, 31, 32,
    30, 32, 15, 24, 29, 31, 31, 30, 29, 31, 38, 40, 39, 40, 39, 32, 27, 35, 37,
    39, 38, 35, 30, 24, 31, 37, 36, 35, 32, 29, 19, 27, 31, 32, 32, 27, 27, 17,
    21, 28, 27, 26, 22, 22, 16, 15, 24, 23, 23, 21, 19, 15, 12, 21, 22, 22, 21,
    15, 18, 28, 30, 31, 30, 27, 31, 15, 24, 29, 30, 29, 24, 30, 15, 19, 26, 27,
    25, 19, 24, 15, 14, 22, 23, 21, 14, 19, 13, 8,  18, 18, 15, 10, 15, 11, 6,
    12, 14, 13, 8,  12, 10, 7,  9,  12, 11, 8,  10, 11, 16, 21, 22, 22, 24, 29,
    11, 12, 20, 20, 21, 22, 24, 11, 8,  17, 17, 18, 18, 18, 10, 7,  13, 13, 13,
    12, 12, 8,  5,  7,  8,  6,  9,  10, 6,  5,  2,  3,  4,  7,  10, 5,  4,  2,
    1,  4,  7,  9,  8,  8,  14, 18, 21, 23, 24, 8,  8,  12, 17, 20, 21, 21, 8,
    8,  10, 14, 16, 16, 16, 9,  7,  6,  9,  12, 11, 9,  6,  5,  4,  4,  5,  6,
    9,  4,  3,  3,  3,  3,  5,  8,  4,  0,  3,  3,  2,  5,  7,  49, 54, 57, 61,
    61, 57, 54, 47, 52, 57, 60, 62, 56, 53, 46, 50, 55, 58, 58, 55, 50, 45, 49,
    52, 55, 57, 52, 46, 40, 45, 49, 52, 53, 50, 46, 35, 41, 44, 47, 50, 50, 46,
    31, 38, 43, 45, 50, 51, 45, 47, 49, 55, 59, 57, 54, 50, 44, 50, 55, 58, 57,
    52, 46, 41, 47, 53, 55, 54, 51, 44, 39, 46, 50, 51, 50, 48, 40, 32, 41, 45,
    47, 46, 45, 40, 27, 37, 41, 43, 44, 44, 41, 22, 34, 40, 44, 42, 41, 41, 41,
    49, 50, 52, 52, 49, 43, 37, 46, 50, 50, 50, 47, 41, 33, 42, 47, 47, 47, 44,
    38, 29, 41, 43, 44, 42, 41, 35, 23, 35, 39, 40, 37, 36, 35, 19, 29, 37, 36,
    37, 34, 36, 18, 26, 35, 35, 34, 33, 32, 33, 40, 43, 45, 43, 41, 35, 30, 38,
    41, 42, 42, 38, 34, 25, 35, 40, 40, 39, 33, 32, 22, 30, 36, 35, 35, 30, 30,
    20, 23, 31, 32, 30, 24, 26, 18, 18, 28, 29, 28, 23, 23, 18, 14, 24, 27, 26,
    23, 18, 21, 29, 34, 36, 33, 29, 34, 17, 26, 33, 34, 31, 25, 33, 17, 21, 30,
    30, 28, 21, 27, 17, 16, 25, 27, 23, 15, 21, 15, 10, 20, 23, 18, 11, 17, 13,
    9,  15, 19, 16, 10, 14, 13, 9,  11, 18, 15, 10, 12, 12, 17, 25, 24, 23, 26,
    31, 12, 13, 23, 23, 22, 22, 26, 12, 9,  20, 20, 19, 19, 21, 12, 8,  14, 16,
    14, 14, 14, 11, 6,  8,  11, 7,  9,  12, 9,  5,  4,  6,  5,  8,  11, 7,  5,
    4,  5,  4,  7,  10, 9,  8,  17, 19, 22, 24, 26, 9,  8,  15, 19, 20, 21, 21,
    9,  8,  11, 16, 16, 17, 17, 9,  7,  7,  13, 12, 12, 11, 6,  5,  4,  6,  6,
    7,  10, 5,  4,  2,  2,  3,  7,  9,  4,  3,  0,  0,  3,  5,  8,  49, 53, 57,
    61, 62, 59, 55, 48, 53, 57, 60, 61, 57, 52, 45, 51, 53, 58, 59, 56, 51, 44,
    47, 52, 55, 57, 52, 46, 42, 45, 48, 51, 54, 49, 45, 35, 41, 45, 47, 50, 49,
    45, 31, 38, 41, 46, 49, 50, 46, 46, 52, 55, 59, 57, 54, 50, 46, 50, 54, 57,
    55, 53, 48, 41, 48, 52, 56, 53, 50, 44, 38, 46, 50, 52, 50, 47, 42, 31, 41,
    46, 48, 45, 45, 40, 27, 37, 41, 43, 43, 43, 40, 22, 35, 40, 42, 43, 41, 41,
    41, 48, 50, 51, 51, 49, 42, 36, 46, 48, 50, 49, 46, 41, 33, 43, 47, 48, 46,
    45, 38, 30, 41, 44, 44, 44, 40, 35, 24, 34, 39, 40, 38, 36, 35, 19, 30, 36,
    36, 36, 35, 35, 17, 24, 34, 35, 35, 33, 32, 33, 41, 43, 44, 44, 41, 35, 29,
    38, 42, 43, 40, 38, 33, 26, 34, 40, 40, 39, 33, 31, 22, 30, 36, 36, 34, 29,
    30, 20, 23, 31, 32, 30, 24, 26, 19, 18, 28, 29, 27, 23, 22, 17, 14, 24, 27,
    27, 22, 18, 21, 31, 34, 35, 32, 29, 35, 17, 26, 33, 33, 30, 25, 33, 17, 21,
    30, 30, 28, 21, 27, 17, 16, 25, 27, 24, 15, 22, 15, 11, 20, 22, 17, 11, 17,
    14, 9,  15, 18, 16, 10, 14, 13, 9,  10, 17, 15, 9,  12, 13, 17, 25, 24, 23,
    25, 31, 13, 13, 22, 23, 22, 23, 26, 13, 9,  20, 20, 18, 19, 21, 12, 8,  14,
    16, 14, 13, 14, 10, 6,  8,  12, 7,  10, 12, 9,  5,  4,  7,  5,  8,  10, 7,
    6,  4,  5,  5,  8,  10, 9,  8,  17, 19, 21, 24, 25, 9,  8,  15, 18, 20, 21,
    22, 9,  8,  11, 17, 17, 17, 17, 9,  7,  6,  12, 12, 12, 11, 6,  5,  4,  6,
    6,  7,  10, 5,  4,  2,  2,  4,  6,  9,  5,  3,  0,  0,  3,  5,  8,  43, 47,
    51, 55, 55, 53, 49, 40, 45, 50, 53, 53, 50, 45, 39, 44, 47, 51, 52, 48, 43,
    39, 42, 46, 47, 49, 46, 39, 35, 38, 41, 45, 46, 43, 39, 30, 34, 37, 40, 44,
    43, 38, 27, 32, 36, 39, 42, 43, 40, 40, 43, 48, 51, 51, 47, 43, 39, 42, 47,
    50, 50, 47, 41, 36, 41, 45, 47, 48, 44, 39, 33, 38, 42, 44, 44, 40, 34, 27,
    36, 38, 42, 39, 38, 35, 22, 32, 35, 37, 36, 37, 34, 18, 29, 34, 37, 37, 35,
    34, 36, 40, 43, 44, 45, 42, 37, 32, 38, 42, 44, 42, 41, 33, 28, 38, 40, 40,
    40, 38, 33, 25, 35, 36, 36, 36, 34, 29, 19, 30, 33, 33, 32, 30, 29, 14, 26,
    30, 29, 30, 28, 29, 13, 21, 29, 28, 29, 28, 26, 28, 36, 36, 37, 37, 35, 29,
    24, 32, 35, 36, 35, 31, 27, 20, 30, 33, 33, 32, 28, 25, 17, 24, 29, 28, 28,
    24, 24, 15, 18, 25, 26, 24, 19, 20, 14, 14, 23, 22, 22, 19, 17, 13, 10, 20,
    21, 21, 18, 12, 16, 25, 28, 29, 26, 23, 28, 13, 21, 26, 27, 25, 19, 27, 13,
    17, 24, 24, 22, 16, 21, 13, 12, 20, 19, 18, 11, 16, 11, 7,  16, 16, 13, 7,
    12, 10, 5,  12, 13, 12, 6,  9,  9,  6,  8,  11, 10, 6,  8,  8,  14, 19, 19,
    18, 20, 24, 8,  10, 17, 18, 17, 17, 20, 8,  6,  14, 14, 14, 14, 15, 8,  5,
    11, 11, 10, 10, 10, 6,  3,  5,  6,  4,  6,  8,  4,  3,  2,  2,  3,  5,  7,
    4,  3,  2,  1,  3,  4,  6,  6,  6,  13, 15, 17, 19, 20, 6,  6,  12, 14, 16,
    16, 17, 6,  6,  9,  12, 12, 12, 13, 6,  5,  5,  8,  8,  8,  7,  4,  3,  3,
    2,  3,  4,  6,  3,  2,  3,  2,  2,  4,  5,  3,  2,  3,  3,  0,  4,  5,  36,
    40, 45, 47, 47, 44, 40, 34, 38, 42, 46, 46, 43, 38, 32, 36, 41, 44, 45, 42,
    36, 31, 34, 38, 40, 43, 39, 33, 29, 32, 33, 37, 39, 36, 32, 25, 27, 31, 33,
    37, 36, 33, 23, 26, 29, 33, 36, 37, 33, 33, 36, 41, 45, 43, 40, 35, 31, 35,
    39, 44, 43, 39, 35, 30, 33, 38, 41, 39, 36, 32, 29, 31, 34, 37, 37, 35, 29,
    24, 29, 31, 34, 32, 32, 29, 19, 26, 28, 31, 30, 32, 28, 15, 24, 27, 30, 30,
    29, 28, 31, 34, 36, 37, 37, 36, 30, 28, 32, 34, 36, 36, 35, 28, 25, 31, 34,
    34, 34, 31, 25, 20, 29, 29, 29, 30, 28, 23, 15, 24, 26, 26, 25, 24, 23, 11,
    21, 23, 23, 24, 23, 23, 10, 19, 24, 23, 22, 23, 20, 25, 29, 28, 30, 30, 29,
    23, 20, 27, 28, 29, 29, 26, 21, 17, 24, 27, 26, 26, 22, 19, 14, 20, 23, 22,
    22, 19, 18, 11, 15, 19, 19, 18, 14, 15, 11, 11, 17, 16, 16, 14, 11, 10, 7,
    16, 15, 15, 14, 8,  12, 20, 21, 22, 21, 18, 22, 9,  17, 20, 20, 20, 15, 21,
    9,  14, 18, 17, 17, 12, 15, 9,  8,  15, 14, 13, 7,  10, 7,  3,  10, 10, 9,
    5,  7,  6,  3,  8,  7,  7,  4,  5,  6,  4,  5,  6,  5,  4,  5,  5,  11, 12,
    13, 14, 16, 19, 5,  8,  11, 12, 13, 13, 15, 5,  5,  10, 9,  10, 10, 10, 5,
    3,  7,  6,  6,  6,  5,  3,  2,  1,  1,  2,  4,  4,  2,  2,  4,  3,  0,  3,
    5,  3,  2,  4,  4,  2,  2,  4,  5,  5,  9,  11, 13, 15, 15, 5,  5,  8,  10,
    12, 12, 12, 5,  5,  7,  8,  8,  9,  9,  5,  4,  4,  4,  4,  5,  4,  3,  2,
    4,  4,  1,  2,  4,  1,  4,  5,  5,  3,  2,  3,  2,  5,  5,  5,  3,  0,  3,
    29, 34, 38, 41, 41, 39, 34, 28, 31, 36, 40, 40, 37, 33, 27, 31, 34, 38, 39,
    36, 30, 26, 28, 31, 34, 37, 32, 27, 23, 25, 27, 31, 33, 31, 27, 20, 22, 25,
    28, 33, 31, 27, 19, 21, 23, 27, 30, 30, 28, 27, 30, 34, 38, 38, 34, 31, 26,
    29, 32, 37, 36, 34, 29, 25, 27, 32, 35, 33, 31, 26, 23, 25, 28, 31, 30, 28,
    23, 20, 23, 25, 28, 27, 26, 22, 17, 20, 23, 25, 25, 25, 23, 14, 19, 22, 24,
    24, 24, 24, 25, 28, 29, 31, 32, 30, 26, 23, 27, 28, 29, 30, 27, 23, 22, 25,
    28, 27, 27, 26, 21, 18, 23, 24, 23, 23, 23, 17, 12, 20, 20, 19, 20, 18, 17,
    8,  19, 19, 18, 18, 18, 17, 8,  16, 18, 17, 17, 18, 15, 21, 23, 23, 23, 25,
    24, 17, 18, 21, 22, 22, 22, 22, 15, 14, 20, 20, 19, 20, 18, 14, 10, 17, 17,
    16, 16, 15, 13, 8,  13, 13, 12, 12, 11, 10, 8,  9,  12, 11, 10, 10, 7,  8,
    6,  10, 9,  9,  9,  4,  9,  15, 15, 16, 17, 14, 17, 6,  13, 13, 14, 14, 11,
    15, 6,  11, 11, 11, 11, 8,  10, 6,  6,  8,  8,  7,  5,  6,  4,  2,  4,  4,
    3,  3,  4,  3,  2,  2,  2,  2,  3,  4,  4,  2,  3,  2,  1,  2,  3,  3,  7,
    8,  9,  10, 12, 14, 3,  6,  8,  9,  9,  10, 10, 3,  4,  6,  6,  6,  7,  7,
    3,  3,  3,  3,  3,  4,  3,  1,  3,  5,  3,  2,  2,  3,  1,  4,  6,  4,  3,
    0,  3,  2,  5,  6,  5,  3,  2,  2,  4,  6,  6,  8,  9,  11, 12, 4,  6,  6,
    7,  8,  9,  9,  4,  6,  6,  5,  5,  5,  6,  4,  4,  6,  3,  2,  2,  3,  2,
    5,  7,  6,  3,  2,  2,  4,  6,  8,  7,  4,  3,  2,  5,  7,  8,  8,  5,  3,
    0,
};
