/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-launcher-context.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_LAUNCHER_CONTEXT_H
#define __UNITY_WEBAPPS_LAUNCHER_CONTEXT_H

typedef struct _UnityWebappsLauncherContext UnityWebappsLauncherContext;

#include "unity-webapps-context.h"

typedef void (*UnityWebappsLauncherCallback) (UnityWebappsContext *context, gpointer user_data);

void unity_webapps_launcher_set_count (UnityWebappsContext *context, gint count);
void unity_webapps_launcher_clear_count (UnityWebappsContext *context);

void unity_webapps_launcher_set_progress (UnityWebappsContext *context, gdouble progress);
void unity_webapps_launcher_clear_progress (UnityWebappsContext *context);

void unity_webapps_launcher_set_urgent (UnityWebappsContext *context);

void unity_webapps_launcher_add_static_action (UnityWebappsContext *context, const gchar *label, const gchar *page);
void unity_webapps_launcher_remove_static_actions (UnityWebappsContext *context);

void unity_webapps_launcher_add_action (UnityWebappsContext *context, const gchar *label, UnityWebappsLauncherCallback callback, gpointer user_data);
void unity_webapps_launcher_remove_action (UnityWebappsContext *context, const gchar *label);
void unity_webapps_launcher_remove_actions (UnityWebappsContext *context);

#endif
