#!/usr/bin/perl

use strict;
use warnings;

use Test::More tests => 128;
use Text::CSV_XS;

my @pat = (
    "00", 
    "\00",
    "0\0",
    "\0\0",

    "0\n0",
    "\0\n0",
    "0\n\0",
    "\0\n\0",

    "\"0\n0",
    "\"\0\n0",
    "\"0\n\0",
    "\"\0\n\0",

    "\"0\n\"0",
    "\"\0\n\"0",
    "\"0\n\"\0",
    "\"\0\n\"\0",

    "0\n0",
    "\0\n0",
    "0\n\0",
    "\0\n\0",
    );
my %exp = map {
    my $x = $_;
    $x =~ s/\0/\\0/g;
    $x =~ s/\n/\\n/g;
    ($_ => $x);
    } @pat;
my $line = ["", undef, "0\n", "", "\0\0\n0"];

my $csv = Text::CSV_XS->new ({
    eol			=> "\n",
    binary		=> 1,
    auto_diag		=> 1,
    blank_is_undef	=> 1,
    });

ok ($csv->combine (@$line), "combine [ ... ]");
is ($csv->string, qq{,,"0\n",,""0"0\n0"\n}, "string");

open my $fh, ">", "__41test.csv" or die $!;
binmode $fh;

for (@pat) {
    ok ($csv->print ($fh, [ $_ ]), "print $exp{$_}");
    }

$csv->always_quote (1);

ok ($csv->print ($fh, $line), "print [ ... ]");

close $fh;

open $fh, "<", "__41test.csv" or die $!;
binmode $fh;

foreach my $pat (@pat) {
    ok (my $row = $csv->getline ($fh), "getline $exp{$pat}");
    is ($row->[0], $pat, "data $exp{$pat}");
    }

is_deeply ($csv->getline ($fh), $line, "read [ ... ]");

close $fh;

unlink "__41test.csv";

$csv = Text::CSV_XS->new ({
    eol			=> "\n",
    binary		=> 1,
    auto_diag		=> 1,
    blank_is_undef	=> 1,
    quote_null		=> 0,
    });

ok ($csv->combine (@$line), "combine [ ... ]");
is ($csv->string, qq{,,"0\n",,"\0\0\n0"\n}, "string");

open $fh, ">", "__41test.csv" or die $!;
binmode $fh;

for (@pat) {
    ok ($csv->print ($fh, [ $_ ]), "print $exp{$_}");
    }

$csv->always_quote (1);

ok ($csv->print ($fh, $line), "print [ ... ]");

close $fh;

open $fh, "<", "__41test.csv" or die $!;
binmode $fh;

foreach my $pat (@pat) {
    ok (my $row = $csv->getline ($fh), "getline $exp{$pat}");
    is ($row->[0], $pat, "data $exp{$pat}");
    }

is_deeply ($csv->getline ($fh), $line, "read [ ... ]");

close $fh;

unlink "__41test.csv";
