package hdinsight

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ScriptExecutionHistoryClient is the the HDInsight Management Client.
type ScriptExecutionHistoryClient struct {
	ManagementClient
}

// NewScriptExecutionHistoryClient creates an instance of the
// ScriptExecutionHistoryClient client.
func NewScriptExecutionHistoryClient(subscriptionID string) ScriptExecutionHistoryClient {
	return NewScriptExecutionHistoryClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewScriptExecutionHistoryClientWithBaseURI creates an instance of the
// ScriptExecutionHistoryClient client.
func NewScriptExecutionHistoryClientWithBaseURI(baseURI string, subscriptionID string) ScriptExecutionHistoryClient {
	return ScriptExecutionHistoryClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get gets the script execution detail for the given script execution id.
//
// resourceGroupName is the name of the resource group. clusterName is the name
// of the cluster. scriptExecutionID is the script execution Id
func (client ScriptExecutionHistoryClient) Get(resourceGroupName string, clusterName string, scriptExecutionID string) (result RuntimeScriptActionDetail, err error) {
	req, err := client.GetPreparer(resourceGroupName, clusterName, scriptExecutionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ScriptExecutionHistoryClient) GetPreparer(resourceGroupName string, clusterName string, scriptExecutionID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"scriptExecutionId": autorest.Encode("path", scriptExecutionID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-03-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptExecutionHistory/{scriptExecutionId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ScriptExecutionHistoryClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ScriptExecutionHistoryClient) GetResponder(resp *http.Response) (result RuntimeScriptActionDetail, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List lists all scripts execution history for the given cluster.
//
// resourceGroupName is the name of the resource group. clusterName is the name
// of the cluster.
func (client ScriptExecutionHistoryClient) List(resourceGroupName string, clusterName string) (result ScriptActionExecutionHistoryList, err error) {
	req, err := client.ListPreparer(resourceGroupName, clusterName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ScriptExecutionHistoryClient) ListPreparer(resourceGroupName string, clusterName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-03-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptExecutionHistory", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ScriptExecutionHistoryClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ScriptExecutionHistoryClient) ListResponder(resp *http.Response) (result ScriptActionExecutionHistoryList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListNextResults retrieves the next set of results, if any.
func (client ScriptExecutionHistoryClient) ListNextResults(lastResults ScriptActionExecutionHistoryList) (result ScriptActionExecutionHistoryList, err error) {
	req, err := lastResults.ScriptActionExecutionHistoryListPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "List", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "List", resp, "Failure sending next results request")
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "List", resp, "Failure responding to next results request")
	}

	return
}

// Promote promote ad-hoc script execution to a persisted script.
//
// resourceGroupName is the name of the resource group. clusterName is the name
// of the cluster. scriptExecutionID is the script execution Id
func (client ScriptExecutionHistoryClient) Promote(resourceGroupName string, clusterName string, scriptExecutionID int64) (result autorest.Response, err error) {
	req, err := client.PromotePreparer(resourceGroupName, clusterName, scriptExecutionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "Promote", nil, "Failure preparing request")
		return
	}

	resp, err := client.PromoteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "Promote", resp, "Failure sending request")
		return
	}

	result, err = client.PromoteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.ScriptExecutionHistoryClient", "Promote", resp, "Failure responding to request")
	}

	return
}

// PromotePreparer prepares the Promote request.
func (client ScriptExecutionHistoryClient) PromotePreparer(resourceGroupName string, clusterName string, scriptExecutionID int64) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"clusterName":       autorest.Encode("path", clusterName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"scriptExecutionId": autorest.Encode("path", scriptExecutionID),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2015-03-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/scriptExecutionHistory/{scriptExecutionId}/promote", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// PromoteSender sends the Promote request. The method will close the
// http.Response Body if it receives an error.
func (client ScriptExecutionHistoryClient) PromoteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// PromoteResponder handles the response to the Promote request. The method always
// closes the http.Response Body.
func (client ScriptExecutionHistoryClient) PromoteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
