#ifndef CYGONCE_HAL_BASETYPE_H
# define CYGONCE_HAL_BASETYPE_H

//======================================================================
//
//      basetype.h
//
//      HAL emulation for the host-side infrastructure.
//
//======================================================================
//####COPYRIGHTBEGIN####
//                                                                          
// ----------------------------------------------------------------------------
// Copyright (C) 1998, 1999, 2000 Red Hat, Inc.
//
// This file is part of the eCos host tools.
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT 
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 
// 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// ----------------------------------------------------------------------------
//                                                                          
//####COPYRIGHTEND####
//======================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   bartv
// Contact(s):  bartv   
// Date:        1998/07/13
// Version:     0.01
//
//####DESCRIPTIONEND####
//======================================================================

// The purpose of this header file is to replicate the functionality
// provided by <cyg/hal/basetype.h> on the target side. Essentially
// this file has to define endianness. Optionally it can also define
// the correct data types for e.g. cyg_count32 etc.
//
// On the host side portability is achieved by means of autoconf and
// feature tests, as opposed to re-implementing the HAL for each
// platform. In particular there will be a generated header file
// <pkgconf/hostinfra.h> which gets filled in during the configure
// process.
//
// It has been decided that the host side should use exactly the same
// infrastructure header files as the target side (although extra
// functionality may be defined in these header files where
// appropriate). This means that the host side needs to provide
// <cyg/hal/basetype.h>, even though it does not contain a HAL.
//
// This implementation of <cyg/hal/basetype.h> reads in the
// configuration header generated by the configure script and adapts
// this information into whatever is required by
// <cyg/infra/cyg_type.h>.

#ifndef CYGONCE_PKGCONF_INFRA_H
# include <pkgconf/infra.h>
#endif

// The autoconf test for endianness will result in a #define for
// LITTLE_ENDIAN_HOST on appropriate platforms. This needs to be
// converted into a definition of CYG_BYTEORDER as per the target-side
// HAL headers.

#ifdef WORDS_BIGENDIAN
# define CYG_BYTEORDER CYG_MSBFIRST
#else
# define CYG_BYTEORDER CYG_LSBFIRST
#endif

// The default definitions for cyg_halint8/16/32 and cyg_halcount8/16/32
// should be fine (although eventually we may come across a platform
// where int's are 64 bit). 64 bit arithmetic is a bit more of a problem.
// on the majority of systems so there is an autoconf test which will
// generate appropriate #define's for cyg_halint64 and cyg_halcount64,
// which means this header file does not to do anything more.
// cyg_halbool and cyg_halatomic should both be ok.


// Any symbols defined in <cyg/infra/config.h> which have been processed
// here should no longer be of any interest, and in the interests of
// reducing name space pollution they get undef'ed here.
#undef WORDS_BIGENDIAN

#endif  // CYGONCE_HAL_BASETYPE_H
// End of basetype.h
