<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>prefork - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Apache MPM prefork</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../de/mod/prefork.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="../en/mod/prefork.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/prefork.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/prefork.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../tr/mod/prefork.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Implmente un serveur web avec dmarrage anticip de
processus, sans thread</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>mpm_prefork_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>prefork.c</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module multi-processus (MPM) implmente un serveur web avec
    dmarrage anticip de processus. Chaque processus du serveur peut
    rpondre aux requtes entrantes, et un processus parent contrle la
    taille du jeu de processus enfants. Il est particulirement indiqu pour les
    sites qui ne doivent pas utiliser les threads afin de maintenir une
    compatibilit avec certaines bibliothques non sres du point de vue
    des threads. C'est galement le MPM le plus appropri si l'on veut
    isoler les requtes les unes des autres, de faon  ce qu'un
    problme concernant une requte n'affecte pas les autres.</p>

    <p>Ce MPM s'auto-contrle de manire efficace, de sorte qu'il est
    rarement ncessaire d'ajuster ses directives de configuration. Le
    plus important est la dfinition de la directive <code class="directive"><a href="../mod/mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></code> ; sa valeur doit tre
    assez grande pour pouvoir traiter autant de requtes simultanes que
    vous pensez recevoir, mais assez petite pour conserver suffisamment
    de mmoire RAM pour tous les processus.</p>
</div>
<div id="quickview"><a href="https://www.apache.org/foundation/contributing.html" class="badge"><img src="https://www.apache.org/images/SupportApache-small.png" alt="Support Apache!" /></a><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#how-it-works">Comment a marche</a></li>
</ul><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#coredumpdirectory">CoreDumpDirectory</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#enableexceptionhook">EnableExceptionHook</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mod_unixd.html#group">Group</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#listen">Listen</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#listenbacklog">ListenBacklog</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxconnectionsperchild">MaxConnectionsPerChild</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxmemfree">MaxMemFree</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#maxspareservers">MaxSpareServers</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#minspareservers">MinSpareServers</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#pidfile">PidFile</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#receivebuffersize">ReceiveBufferSize</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#scoreboardfile">ScoreBoardFile</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#sendbuffersize">SendBufferSize</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#serverlimit">ServerLimit</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mpm_common.html#startservers">StartServers</a></li>
<li><img alt="" src="../images/right.gif" /> <a href="mod_unixd.html#user">User</a></li>
</ul>
<h3>Traitement des bugs</h3><ul class="seealso"><li><a href="https://www.apache.org/dist/httpd/CHANGES_2.4">Journal des modifications de httpd</a></li><li><a href="https://bz.apache.org/bugzilla/buglist.cgi?bug_status=__open__&amp;list_id=144532&amp;product=Apache%20httpd-2&amp;query_format=specific&amp;order=changeddate%20DESC%2Cpriority%2Cbug_severity&amp;component=mpm_prefork">Problmes connus</a></li><li><a href="https://bz.apache.org/bugzilla/enter_bug.cgi?product=Apache%20httpd-2&amp;component=mpm_prefork">Signaler un bug</a></li></ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><a href="../bind.html">Dfinition des adresses et ports
qu'utilise le serveur HTTP Apache</a></li>
<li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="how-it-works" id="how-it-works">Comment a marche</a></h2>
    <p>Un processus de contrle unique a pour tche de lancer les
    processus enfants qui attendent les connexions et les traitent au
    fur et  mesure qu'elles arrivent. Apache httpd essaie toujours de
    maintenir plusieurs processus serveurs inactifs ou <dfn>en
    rserve</dfn>, afin de pouvoir traiter les requtes entrantes. De
    cette faon, les clients n'ont pas besoin d'attendre le dmarrage
    d'un nouveau processus enfant pour que leurs requtes puissent tre
    traites.</p>

    <p>Les directives <code class="directive"><a href="../mod/mpm_common.html#startservers">StartServers</a></code>, <code class="directive"><a href="#minspareservers">MinSpareServers</a></code>, <code class="directive"><a href="#maxspareservers">MaxSpareServers</a></code> et <code class="directive"><a href="../mod/mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></code> permettent de contrler
    la manire dont le processus parent cre les processus enfants pour
    traiter les requtes. En gnral, Apache httpd s'auto-contrle de manire
    efficace, de sorte que la plupart des sites peuvent conserver les
    valeurs par dfaut des directives. Les sites qui doivent traiter
    plus de 256 requtes simultanes doivent augmenter la valeur de
    <code class="directive"><a href="../mod/mpm_common.html#maxrequestworkers">MaxRequestWorkers</a></code>, alors que les
    sites dont la ressource mmoire est limite doivent la diminuer afin
    d'viter une hyperactivit du serveur (utilisation excessive de la
    mmoire virtuelle sur disque). Vous trouverez plus d'informations 
    propos du contrle de la cration de processus dans le document <a href="../misc/perf-tuning.html">conseils en matire de
    performances</a></p>

    <p>Alors que le processus parent est en gnral dmarr en tant que
    <code>root</code> sous Unix afin de pouvoir se mettre  l'coute sur le port 80, les
    processus enfants sont lancs par Apache httpd sous un utilisateur avec
    privilges restreints. On peut contrler les privilges accords aux
    processus enfants d'Apache httpd  l'aide des directives <code class="directive"><a href="../mod/mod_unixd.html#user">User</a></code> et <code class="directive"><a href="../mod/mod_unixd.html#group">Group</a></code>. Les processus enfants doivent
    tre en mesure de lire tous les contenus destins  tre servis,
    mais leurs privilges doivent tre aussi bas que possible.</p>

    <p>La directive <code class="directive"><a href="../mod/mpm_common.html#maxconnectionsperchild">MaxConnectionsPerChild</a></code> permet de
    contrler la frquence  laquelle le serveur recycle ses processus
    en arrtant les plus anciens et en en lanant de nouveaux.</p>

    <p>Ce module MPM utilise le mutex <code>mpm-accept</code> pour
    srialiser l'accs aux connexions entrantes lorsque peut se
    prsenter un problme d'afflux de requtes (en gnral quand il y a
    plusieurs sockets en coute). Les aspects de l'implmentation de ce
    mutex peuvent tre configurs via la directive <code class="directive"><a href="../mod/core.html#mutex">Mutex</a></code>. Vous trouverez des informations
    supplmentaires  propos de ce mutex dans la documentation  propos
    des  <a href="../misc/perf-tuning.html">conseils en matire de
    performances</a></p>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="maxspareservers" id="maxspareservers">Directive</a> <a name="MaxSpareServers" id="MaxSpareServers">MaxSpareServers</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximum de processus serveurs enfants
inactifs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MaxSpareServers <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MaxSpareServers 10</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>prefork</td></tr>
</table>
    <p>La directive <code class="directive">MaxSpareServers</code> permet de
    dfinir le nombre maximum souhait de processus serveurs enfants
    <em>inactifs</em>. Un processus inactif est un processus qui ne
    traite pas de requte. S'il y a plus de
    <code class="directive">MaxSpareServers</code> processus inactifs, le
    processus parent arrtera les processus excdentaires.</p>

    <p>La modification de ce paramtre n'est ncessaire que
    dans le cas de sites trs sollicits. Dfinir ce paramtre  une
    valeur trs grande est cependant dans la plupart des cas une
    mauvaise ide. Si vous essayez d'affecter  ce paramtre une valeur
    gale ou infrieure  la valeur de <code class="directive"><a href="#minspareservers">MinSpareServers</a></code>, le serveur HTTP Apache
    l'ajustera automatiquement  la valeur de <code class="directive">
    MinSpareServers</code><code> + 1</code>.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#minspareservers">MinSpareServers</a></code></li>
<li><code class="directive"><a href="../mod/mpm_common.html#startservers">StartServers</a></code></li>
<li><code class="directive"><a href="../mod/mpm_common.html#maxsparethreads">MaxSpareThreads</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="minspareservers" id="minspareservers">Directive</a> <a name="MinSpareServers" id="MinSpareServers">MinSpareServers</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre minimum de processus serveurs enfants
inactifs</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>MinSpareServers <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>MinSpareServers 5</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>MPM</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>prefork</td></tr>
</table>
    <p>La directive <code class="directive">MinSpareServers</code> permet de
    dfinir le nombre minimum dsir de processus serveurs enfants
    <em>inactifs</em>. Un processus inactif est un processus qui ne
    traite pas de requte. S'il y a moins de
    <code class="directive">MinSpareServers</code> processus inactifs, le
    processus parent va crer de nouveaux enfants de la manire suivante
    : il en cre un, attend une seconde, il en cre deux, attend une
    seconde, il en cre quatre, puis continue ainsi exponentiellement
    jusu' ce que son taux de cration de processus enfants soit de 32
    par seconde. Il ne s'arrte que lorsque le nombre de processus
    enfants correspond  la dfinition de la directive
    <code class="directive">MinSpareServers</code>.</p>

    <p>La modification de ce paramtre n'est ncessaire que
    dans le cas de sites trs sollicits. Dfinir ce paramtre  une
    valeur trs grande est dans la plupart des cas une mauvaise
    ide.</p>

<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#maxspareservers">MaxSpareServers</a></code></li>
<li><code class="directive"><a href="../mod/mpm_common.html#startservers">StartServers</a></code></li>
<li><code class="directive"><a href="../mod/mpm_common.html#minsparethreads">MinSpareThreads</a></code></li>
</ul>
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../de/mod/prefork.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="../en/mod/prefork.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/prefork.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/prefork.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../tr/mod/prefork.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/prefork.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2017 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>