/*
 * activity-log-manager.vala
 * Copyright (C) 2012 Seif Lotfy <seif@lotfy.com>
 * Copyright (C) 2012 Stefano Candori <stefano.candori@gmail.com>
 * Copyright (C) 2012 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright (C) 2012 Intel Corp.
 *               Authored by: Seif Lotfy <seif.lotfy@collabora.co.uk>
 * Copyright (C) 2013 Jeremy Bicha <jbicha@ubuntu.com>
 * 
 * alm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * alm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */
 
#if DIAGNOSTIC
extern Gtk.Widget whoopsie_daisy_preferences_new ();
#endif

namespace Alm {

	public class ActivityLogManager : Gtk.Box {
		private Gtk.Notebook notebook;
		private SecurityWidget security_widget;
		private SearchResultsWidget searchresults_widget;
		private PrivacyWidget privacy_widget;
		private Gtk.Widget whoopsie;

		private Blacklist blacklist;

		public ActivityLogManager () {
			Object(orientation: Gtk.Orientation.VERTICAL);
			this.set_size_request(600, 450);
			this.spacing = 6;
			this.margin = 12;

			blacklist = new Blacklist();
			privacy_widget = new PrivacyWidget(blacklist);
			
			notebook = new Gtk.Notebook();
			this.pack_start(notebook, true, true, 0);
			var privacy_label = new Gtk.Label(_("Files & Applications"));
			notebook.append_page(privacy_widget, privacy_label);

			if (GLib.Environment.get_variable ("XDG_CURRENT_DESKTOP") == "Unity")
			{
				security_widget = new SecurityWidget();
				var security_label = new Gtk.Label(_("Security"));
				notebook.prepend_page(security_widget, security_label);

				searchresults_widget = new SearchResultsWidget();
				var searchresults_label = new Gtk.Label(_("Search"));
				notebook.append_page(searchresults_widget, searchresults_label);
			}

#if DIAGNOSTIC
			whoopsie = whoopsie_daisy_preferences_new ();
			var whoopsie_label = new Gtk.Label(_("Diagnostics"));
			notebook.append_page(whoopsie, whoopsie_label);
#endif
			this.show_all();
		}

		public void append_page (Gtk.Widget widget, string label) {
			var app_label = new Gtk.Label(_(label));
			notebook.append_page(widget, app_label);
		}
	}
}
