/*****************************************************************************
 * callbacks.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Copyright (C) 2003-2005, Erica Andrews
 * (Phrozensmoke ['at'] yahoo.com)
 * http://phpaint.sourceforge.net/pyvoicechat/
 * 
 * Copyright (C) 2000-2002 Chris Pinkham
 * cpinkham@corp.infi.net, cpinkham@bc2va.org
 * http://www4.infi.net/~cpinkham/gyach/
 * 
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 *****************************************************************************/

#include <sys/utsname.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "config.h"

#include "gyach.h"
#include "gyach_int.h"
#include "gyach_int_text.h"
#include "aliases.h"
#include "callbacks.h"
#include "commands.h"
#include "roomui.h"
#include "fader.h"
#include "friends.h"
#include "history.h"
#include "ignore.h"
#include "interface.h"
#include "setupwindow2.h"
#include "main.h"
#include "roomlist.h"
#include "users.h"
#include "yahoochat.h"
#include "conference.h"
#include "webconnect.h"
#include "ycht.h"
#include "webcam.h"
#include "plugins.h"
#include "profname.h"
#include "gytreeview.h"
#include "sounds.h"
#include "pmwindow.h"
#include "pmnotebook.h"
#include "packet_handler.h"
#include "voice_chat.h"
#include "yahoofxfer.h"
#include "yahoophshare.h"
#include "yab.h"
#include "util.h"


#include "gy_config.h"
#include "gyachi_lib.h"
#include "theme_support.h"


GtkWidget *favorites_window = NULL;
GtkWidget *edit_win = NULL;
char *last_loginname=NULL;

GtkTreeView *setup_list = NULL;
char *setup_row_selected = NULL;
GtkTreeIter setupiter;
char setup_which[32] = "";
static gchar callbackbuf[1152];

GtkWidget *favroom_setup_menu=NULL;
GtkWidget *budpop_menu=NULL;
GtkWidget *budgrp_menu=NULL;

char *selected_buddy_group=NULL;
char *selected_buddy =NULL;
char *stealth_sel_buddy=NULL;
char *user_for_file=NULL;

int web_login_warn_shown=0;

/* local prototypes */
static void shutdown_pms_session (PM_SESSION *pm_sess);
void pms_add_friend(GtkMenuItem *widget, gpointer user_data, int temp_friend);

#define FILE_MSG_LOG	"Log To File"

char *TMP_FRIEND_CB="~[Temporary Friends]~";
int txlimit=800;


void on_b_send_clicked(GtkButton *button, gpointer user_data)
{
	char *text;

	text = strdup(gtk_entry_get_text(GTK_ENTRY(chat_entry)));
	gtk_entry_set_text(GTK_ENTRY(chat_entry), "");

	if ( ! strlen( text )) {
		free(text);    /*  added: PhrozenSmoke, seg fault watch */
		return;
	}

	history_add( text );

	/* ok, we have something to send */
	chat_command( text, 0);
	free(text);  /*  added: PhrozenSmoke, seg fault watch */
	/*  ct_scroll_to_bottom();  */  
}


void on_b_clear_clicked(GtkButton *button, gpointer user_data)
{
	gtk_entry_set_text(GTK_ENTRY(chat_entry), "");
}


void on_window1_map(GtkWidget *widget, gpointer user_data)
{
	chat_window = widget;
}


void on_chat_entry_activate(GtkEditable *editable, gpointer user_data)
{
	on_b_send_clicked( NULL, NULL );
}


void on_aliases_map(GtkWidget *widget, gpointer user_data)
{
	chat_aliases = GTK_TREE_VIEW(widget);
	read_aliases();
}


void collect_chat_list_selected(GtkTreeSelection *selection, gpointer data)
{
	GtkTreeModel *model;
	if ( user_selected ) {
		free( user_selected );  
		user_selected=NULL;
	}
	if ( gtk_tree_selection_get_selected(selection, &model, &chat_user_iter)) {
		gchar *sfound;
		gtk_tree_model_get(model, &chat_user_iter,GYQUAD_COL2, &sfound, -1);	
		user_selected=strdup(sfound);
		g_free(sfound);
	} 
}

void onChatUsersRowActivated(GtkTreeView *tv, GtkTreePath *tp, GtkTreeViewColumn *col, gpointer user_data)
{

	if (!user_selected) {
			gchar *sfound;
			gtk_tree_model_get_iter(gtk_tree_view_get_model(tv), &chat_user_iter, tp);
			gtk_tree_model_get(gtk_tree_view_get_model(tv), &chat_user_iter,GYQUAD_COL2, &sfound, -1);	
			user_selected=strdup(sfound);
			g_free(sfound);
	}
	if (!user_selected) {return;}
	on_pm_activate(NULL, NULL);
}

void display_chat_user_popup(GtkWidget *user_data)
{
	if (! chat_user_menu) {chat_user_menu = create_user_menu(user_data);}
	/* right clicked popup user menu */
	gtk_menu_popup((GtkMenu *) chat_user_menu, NULL, NULL, NULL, NULL, 1, 0);
}

gboolean on_chatlist_kb_popup(GtkWidget *widget, gpointer user_data)
{
	display_chat_user_popup(user_data);
	return FALSE;
}

gboolean on_users_clicked(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	if ((event->button == 3 && event->type == GDK_BUTTON_PRESS)) {
		display_chat_user_popup(user_data);
	}
	return FALSE;
}



void on_users_map(GtkWidget *widget, gpointer user_data)
{
	chat_users = GTK_TREE_VIEW(widget);
}


void onAliasesRowActivated(GtkTreeView *tv, GtkTreePath *tp, GtkTreeViewColumn *col, gpointer user_data)
{
		GtkTreeModel *model;
		GtkTreeIter iter;
		model=gtk_tree_view_get_model(tv);
		if (gtk_tree_model_get_iter(model, &iter, tp)) {
			gchar *iname;
			char *tname=NULL;
			gtk_tree_model_get(model, &iter,  GYTRIPLE_COL1, &iname, -1);
			tname=strdup(iname);
				if ( user_selected ) {
					check_alias(tname, user_selected );
					/* free( user_selected );
						user_selected = NULL;  */
				} else {check_alias( tname, "" );}
			free(tname);
			g_free(iname);
		}
}

void display_alias_pop_menu(GtkWidget *parent)
{
	if ( alias_window ) {return;}
	if (! alias_menu) {
		alias_menu = create_alias_menu(parent);
	}
	gtk_menu_popup((GtkMenu *) alias_menu, NULL, NULL, NULL, NULL, 1, 0);
}

gboolean on_aliases_clicked(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	GtkWidget *parent = user_data;

	if (event->button == 3 && event->type == GDK_BUTTON_PRESS)
	{	/* right clicks */
		display_alias_pop_menu(parent);
	}
	return FALSE;
}

gboolean on_aliases_kb_popup(GtkWidget *widget, gpointer user_data)
{
	GtkWidget *parent = user_data;

	/* Shift-F10 pressed */
	display_alias_pop_menu(parent);
	return TRUE;
}


void on_connect_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( logged_in )
		return;

	if (!login_window) {
		login_window = build_login_window();
	}
	gtk_widget_show_all(login_window);
	gtk_window_present(GTK_WINDOW(login_window));
}


void on_disconnect_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( ! logged_in )
		return;
	ymsg_leave_chat( ymsg_sess );
	ymsg_messenger_logout(ymsg_sess);
	ymsg_sess->pkt.type = YMSG_GYE_EXIT; /*  force logout */
	handle_yahoo_packet();
	reset_user_list();
	reset_screenname_aliases();
}


void on_chat_page_reordered_cb(GtkNotebook *notebook, GtkWidget *child, guint page_num, gpointer user_data)
{
	char *label_name = g_object_get_data(G_OBJECT(child), "label_name");
	int this_page;
	char *my_name;
	int i;

	if (label_name) {
		this_page = find_tab_posn(label_name);
		my_name=chat_tabs[this_page];
		if (this_page > page_num) {
			/* page has moved to the left.
			 * Need to inservt it, and shuffle pages up.
			 */
			for (i=this_page; i>page_num; i--) {
				chat_tabs[i] = chat_tabs[i-1];
			}
		}
		else {
			/* page has moved to the right.
			 * Need to shuffle pages down, and put page in new location.
			 */
			for (i=this_page; i<page_num; i++) {
				chat_tabs[i] = chat_tabs[i+1];
			}
		}

		chat_tabs[page_num] = my_name;
	}


}

void on_quit_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GList *pm_lptr;
	PM_SESSION *pm_sess;

	if ( ymsg_sess->io_callback_tag > 0) {
		gdk_input_remove( ymsg_sess->io_callback_tag );
		ymsg_sess->io_callback_tag = 0;
	}

	if ( ymsg_sess->ping_callback_tag >0) {
		g_source_remove( ymsg_sess->ping_callback_tag );
		ymsg_sess->ping_callback_tag = 0;
	}

	/* destroy conversation windows / notebooks. This will properly close
	 * any photosharing sessions that might happen to be open.
	 */
	while ( (pm_lptr=g_list_first(pm_list)) != 0 ) {
		pm_sess = pm_lptr->data;
		shutdown_pms_session (pm_sess);
	}

	if (auto_leave_chatroom) {
		on_disconnect_activate(menuitem, user_data);
	}

	close( ymsg_sess->sock ); 
	ymsg_sess->sock = -1; 
	ymsg_sess->quit = 1; 

	write_config();
	history_save();

	gdk_threads_leave();


	reset_user_list();

	/* destroy main chat window */
	if (chat_window) {
		gtk_widget_destroy(chat_window);
		chat_window=0;
	}

	if (GTK_IS_TREE_VIEW(bd_tree)) {
		GtkTreeModel *model;
		model=freeze_treeview(GTK_WIDGET(bd_tree));
		gtk_tree_store_clear(GTK_TREE_STORE(model));
	}

	/* destroy login window */
	if (login_window && GTK_IS_WIDGET(login_window)) {
		gtk_widget_destroy(login_window);
		login_window=0;
	}

	reset_screenname_aliases();
	clear_quick_profiles();
	remove_all_online_friends();

	exit(0);
}


void on_chatroom_clear(GtkMenuItem *menuitem, gpointer user_data)
{
	chat_command("/clear", 0);
}

void on_room_list_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *parent = user_data;
	GtkWidget *tmp_widget;

	if ( ! room_window ) {
		room_window = create_room_list(parent);
		gtk_widget_show_all( room_window );
		populate_room_list(0);
	} else {
		gtk_widget_show_all( room_window );

		if ( ! cache_room_list ) {
			tmp_widget = lookup_widget( room_window, "room_tree" );
			gy_empty_model(gtk_tree_view_get_model(GTK_TREE_VIEW(tmp_widget)), GYTV_TYPE_TREE);
			populate_room_list(0);
		}
	}
}


void on_favorites_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *parent = user_data;
	GList *this_item = NULL;
	GtkWidget *tmp_widget;
	GtkTreeModel *model;
	GtkTreeIter iter;
	char *answer=NULL;
	GdkPixbuf *imbuf=NULL;

	if ( favorites_window )
		return;

	favorites_window = create_favorites(parent);
	tmp_widget = lookup_widget( favorites_window, "fav_room_list" );
	model=freeze_treeview(tmp_widget );

	
	for (this_item = room_list; this_item; this_item=g_list_next(this_item) ) {
		YMSG_ROOM *room;

		room = this_item->data;
		if (room->fav) {
			answer = strdup(room->room_name);
			gtk_list_store_append(GTK_LIST_STORE(model), &iter);
			imbuf=get_pixbuf_from_stock_id(GTK_WIDGET(favorites_window),
						       GYACHI_PM_JOIN,
						       GTK_ICON_SIZE_MENU);
			gtk_list_store_set(GTK_LIST_STORE(model), &iter, 
					   GYSINGLE_PIX_TOGGLE, imbuf?TRUE:FALSE, 
					   GYSINGLE_PIX, imbuf,
					   GYSINGLE_COL1, answer,
					   GYSINGLE_COLOR, NULL, GYSINGLE_TOP, "",  -1);
			if (imbuf) {
				g_object_unref(imbuf);
			}
			free(answer);
		}
	}

	unfreeze_treeview(tmp_widget, model);
	set_basic_treeview_sorting(tmp_widget, GYLIST_TYPE_SINGLE);
	gtk_widget_show_all( favorites_window );
}


void on_add_to_favorites_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	YMSG_ROOM *room;

	if (is_conference) {
		snprintf(callbackbuf, 380, "  %s%s[%s]%s%s\n" ,
			 YAHOO_STYLE_ITALICON, YAHOO_COLOR_RED,
			 _("You cannot add a conference room to your favorites list"), 
			 YAHOO_STYLE_ITALICOFF, YAHOO_COLOR_BLACK
			 );
		append_to_textbox_color(chat_window,NULL,callbackbuf);
	}

	if (! strcmp( ymsg_sess->room, "[NONE]") ) {return; }


	room = find_room(ymsg_sess->room);
	if (room && room->fav) {
		snprintf(callbackbuf, 380, "  %s%s[%s: '%s']%s%s\n" ,
			 YAHOO_STYLE_ITALICON, YAHOO_COLOR_RED,
			 _("The following room is already in your favorites list"), 
			 ymsg_sess->room,
			 YAHOO_STYLE_ITALICOFF, YAHOO_COLOR_BLACK
			 );
		append_to_textbox_color(chat_window,NULL,callbackbuf);
		return;
	}

	add_room(ymsg_sess->room, 0, 1);

	write_config();
	snprintf(callbackbuf, 380, "  %s%s[%s: '%s']%s%s\n" ,
		 YAHOO_STYLE_ITALICON, YAHOO_COLOR_ORANGE,
		 _("The following room has been added to your favorites list"), 
		 ymsg_sess->room,
		 YAHOO_STYLE_ITALICOFF, YAHOO_COLOR_BLACK
		 );
	append_to_textbox_color(chat_window,NULL,callbackbuf);
}


void on_help_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *tmp_widget=NULL;
	int        yahoo_tab;

	tmp_widget=g_object_get_data(G_OBJECT(chat_window),"gynotebook");
	snprintf(callbackbuf, 350, "file:%s/html/%s", 
		PACKAGE_DOC_DIR,
		user_data?"gyachi-ylinks.html":"gyachi-help.html");
	load_myyahoo_URL(callbackbuf);
	if (tmp_widget) {
		yahoo_tab = find_tab_posn(YAHOO_TAB);
		gtk_notebook_set_current_page(GTK_NOTEBOOK(tmp_widget), yahoo_tab);
	}
	gdk_window_raise(chat_window->window );
}


void  on_about_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *tmp_widget;
	char *info_data=NULL;
	struct utsname un;
	int        yahoo_tab;

	info_data=malloc(4096);
	if (! info_data) {return;}
	uname(&un);

	snprintf(info_data, 4000,
			"<table border=\"2\" cellpadding=\"4\" width=\"95%%\"><tr><td width=\"100%%\" bgcolor=\"#eeeeFF\"><center><b><font size=\"4\"  color=\"#660099\">%s</b></center></font><font size=\"3\" color=\"#000000\" face=\"Arial\"><br><br><b><a href=\"%s\">Gyach-E Improved</a> (Gyach-I) version %s</b><br><br>"
			"Copyright (c) 2007-2008 Gregory D. Hosler.<br>"
			"Copyright (c) 2006 Stefan Sikora and Zoltan Csala.<br>"
			"Copyright (c) 2003-2005 Erica Andrews.<br>"
			"Copyright (c) 2000-2003 Chris Pinkham.<br>"
			"<br>"
			"This software comes with No Warranty and No Technical Support. This is free software and is distributed under the GNU General Public License (GPL).  You may redistribute it under certain conditions.  Please see the COPYING or LICENSE file for details." 
			"<br><br>"
			"&nbsp; &nbsp;<b>Project Started:</b>   July 2000<br>"
			"&nbsp; &nbsp;<b>This Binary Compiled:</b>   " __DATE__ " at " __TIME__ "<br>"
			"&nbsp; &nbsp;<b>GTK+ Version:</b>   %d.%d.%d<br>"
			"&nbsp; &nbsp;<b>Currently Running on:</b>   %s %s [%s]<br>"
			"&nbsp; &nbsp;<b>Author E-Mail:</b>   %s<br>"
			"&nbsp; &nbsp;<b>Author E-Mail:</b>   %s<br>"
			"&nbsp; &nbsp;<b>Web Page:</b>   <a href=\"%s\">%s</a><br>"
			"&nbsp; &nbsp;<b>Old Gyach-Author E-Mail:</b>   %s<br>"
			"&nbsp; &nbsp;<b>Old Gyach-Web Page:</b>   <a href=\"%s\">%s</a><br>",

			_("About GYachE Improved"), GYACH_URL, VERSION, gtk_major_version, 
			gtk_minor_version, gtk_micro_version,
			un.sysname, un.release, un.machine, GYACH_EMAIL2, GYACH_EMAIL, GYACH_URL,
			GYACH_URL,  GYACH_EMAIL_OLD, GYACH_URL_OLD, GYACH_URL_OLD
		 );

	strcat(info_data,"</td></tr></table><br>");

	tmp_widget=g_object_get_data(G_OBJECT(chat_window),"gynotebook");
	set_myyahoo_html_data(info_data);
	free(info_data);
	if (tmp_widget) {
		yahoo_tab = find_tab_posn(YAHOO_TAB);
		gtk_notebook_set_current_page(GTK_NOTEBOOK(tmp_widget), yahoo_tab);
	}
	gdk_window_raise(chat_window->window );
}



void  on_profile_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( ! user_selected ) { return ; }
	snprintf(callbackbuf,100, "/profile %s", user_selected);
	chat_command(callbackbuf, 0);					
}

void on_qprofile_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	char *profile=NULL;
	char *ualias=NULL;
	if ( ! user_selected ) {return; }

	if (is_conference) {
		snprintf(callbackbuf, 512,  "\n%s[%s]\n", 
			 YAHOO_COLOR_ORANGE,
			 _("QUICK PROFILES ARE NOT AVAILABLE IN CONFERENCE ROOMS.")
			 );
		append_to_textbox(chat_window,NULL,callbackbuf);
		return; 
	}

	profile=get_quick_profile(user_selected);
	ualias=get_screenname_alias(user_selected);
	if (!profile) {return;}
	if (!ualias) {return; }
	snprintf(callbackbuf, 1023, 
		 "\n%s[%s]\n%s%s ( %s ) : %s\n\n", 
		 YAHOO_COLOR_ORANGE, _("QUICK PROFILE"), 
		 YAHOO_COLOR_RED, user_selected, ualias, profile
		 );
	append_to_textbox(chat_window,NULL,callbackbuf);
	free(profile); profile=NULL;
	free(ualias); ualias=NULL;
}




/* CHANGED: PhrozenSmoke */
/* callback for "Instant Message" on user menu (create_user_menu())
 * menu looks like:
 *       instant message
 *       -----------------
 *       quick profile
 *       profile
 *       -----------------
 *       add to friends
 *       add as temporary friend
 *       -----------------
 *       follow
 *       -----------------
 *       view webcam
 *       send webcam invitation
 *       -----------------
 *       ignore
 *       ignore & broadcast
 *       un-ignore,
 *       mute
 *       un-mute
 *       do not auto-mute
 *       -----------------
 *       copy name
 *       copy nick name
 *
 * this menu is attached to:
 *      alias popup on main chat window.
 *            display_chat_user_popup()
 */
void on_pm_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( ! user_selected ) {
		return;
	} else {
		PM_SESSION *mypm_sess;

		if (strcasecmp( user_selected , ymsg_sess->user ) && (! find_profile_name(user_selected ))) {
		        /* old way */
		        /* pm_window=blank_pm_window(user_selected );  */
			if ( !(mypm_sess = find_pm_session( user_selected)) ) {
				mypm_sess=new_pm_session(user_selected);
			}
			gtk_widget_show_all(mypm_sess->pm_window );
			pm_notebook_select_tab(mypm_sess->pm_notebook, user_selected);
			gdk_window_raise(mypm_sess->pm_window->window );

if ( capture_fp ) {
fprintf(capture_fp, "\n[%s] pm_notebook_select_tab --> CROSS ROAD INTERSECTION 5 <-- on_pm_activate()\n", gyach_timestamp());
fflush( capture_fp );
}

		}
	}	
}


void on_copy_room_user_name(GtkMenuItem *menuitem, gpointer nick_user_data)
{
	gchar *myalias=NULL;
	if ( ! user_selected ) {return;}
	if (nick_user_data) {
		myalias=get_screenname_alias(user_selected);
			} else {myalias=g_strdup(user_selected);}
	gtk_entry_set_text( GTK_ENTRY(chat_entry), myalias );
	gtk_editable_set_position(GTK_EDITABLE(chat_entry), strlen(myalias));
	if (myalias) {g_free(myalias); myalias=NULL;}
}



void  on_add_to_friends_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( ! user_selected )
		return;   /* FIX ME - need to do real add here */

	add_friend(chat_window, user_selected);
}


void on_ignore_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( ! user_selected )
		return;

	/* Added: PhrozenSmoke - whether to 'broadcast' to the room we are ignoring a person, 
            or do a 'quiet' ignore and tell no one.  Default is to NOT  'broadcast'  
	    From 'ignore.h'	
	*/ 
	BROADCAST_IGNORE=0;  /* do a quiet ignore unless we explicitly say to 'broadcast' */

	if (! ignore_check( user_selected )) { ignore_toggle( user_selected ); }
}


void on_ignore_broadcast_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( ! user_selected )
		return;

	/* Added: PhrozenSmoke - whether to 'broadcast' to the room we are ignoring a person, 
            or do a 'quiet' ignore and tell no one.  Default is to NOT  'broadcast'  
	    From 'ignore.h'	
	*/ 
	BROADCAST_IGNORE=1;  /* do a a LOAD ignore, we explicitly said to 'broadcast' */

	if (! ignore_check( user_selected )) { ignore_toggle( user_selected );  }
	BROADCAST_IGNORE=0;  /* turn 'broadcasting' off */
}


void on_unignore(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( ! user_selected )
		return;

	if ( ignore_check( user_selected )) { ignore_toggle( user_selected );  }
}


void on_unmute(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( ! user_selected )
		return;

	if ( mute_check( user_selected )) { mute_toggle( user_selected );  }
}


void on_domute(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( ! user_selected )
		return;

	if (! mute_check( user_selected )) { mute_toggle( user_selected );  }
}


void on_doimmunity(GtkMenuItem *menuitem,  gpointer user_data)
{
	if ( ! user_selected ) {return;}
	immunity_add(user_selected);
}


void on_add_tmp_friend(GtkMenuItem *menuitem, gpointer user_data)
{
	if ( ! user_selected )
		return;
 	add_temporary_friend( user_selected );
}



/* added: PhrozenSmoke, callback for opening blank PM windows
 * Prompt for the username, and then open a pm window
 */
void on_blank_pm_window(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *parent = user_data;
	GtkWidget *pm_window;

	pm_window=blank_pm_window(parent, NULL);
}


/* call back to destroy window when [cancel] button is called! */
void  on_pm_cancel_clicked(GtkButton *button, gpointer user_data)
{
        GtkWidget *pm_window = (GtkWidget *)user_data;

	gtk_widget_destroy(pm_window);
}

/* call back to destroy window when [x] kill window icon is clicked!
 * Almost the same as [cancel], except that the callback is slightly
 * different, and expects a true/false return.
 * False to propogate the event further.
 */
gboolean on_pm_window_destroy_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
        GtkWidget *pm_window = (GtkWidget *)user_data;

	gtk_widget_destroy(pm_window);
	return FALSE;
}



void on_pm_user_map(GtkWidget *widget, gpointer user_data)
{
	pm_user = widget;
}


void on_pm_entry_activate(GtkEditable *editable, gpointer user_data)
{
	on_pm_send_clicked( NULL, user_data );
}


void on_login_button_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *tmp_widget;
	int java_chat=0;
	char *at_host;

	logged_in  = 0;
	valid_user = 1;
	login_invisible=0;	
	login_noroom=0;

	login_name_changed=1;

	tmp_widget = lookup_widget( login_window, "chat_port" );
	ymsg_sess->port=atoi(gyachi_combobox_get_selected_item(tmp_widget));

	if ( (ymsg_sess->port<20)  || (ymsg_sess->port>8002) ) {
		show_ok_dialog(_("Invalid Port."));
		ymsg_sess->port= YMSG_CHAT_PORT;
		return;
	}

	tmp_widget = lookup_widget( login_window, "chat_server" );
	strncpy( ymsg_sess->host, gyachi_combobox_get_selected_item(tmp_widget), 125);

	if (strlen(ymsg_sess->host)<2) {return;} /* no host */ 

	if (last_chatserver) {	free(last_chatserver); }
	last_chatserver=strdup(ymsg_sess->host);

	using_web_login=0;
	if (! strcasecmp(ymsg_sess->host, "wcs2.msg.dcn.yahoo.com")) {using_web_login=1;}
	if (! strcasecmp(ymsg_sess->host, "wcs1.msg.dcn.yahoo.com")) {using_web_login=1;}
	if (! strncasecmp(ymsg_sess->host, "YCHT", 4)) {using_web_login=1; java_chat=1;}
	if (! strncasecmp(ymsg_sess->host, "WEB LOGIN", 9)) {using_web_login=1;}

	if (using_web_login ) {		
		if ( (! g_object_get_data(G_OBJECT(button), "confirmed" )) && 
		(! web_login_warn_shown) ) {
			GtkWidget *okbutton;

			snprintf(callbackbuf, 650, "%s\n        '%s'\n%s",
			java_chat?_("The following server uses the 'web login'\nconnection method (Java Chat):"):_("The following server uses the 'web login'\nconnection method:"),
			ymsg_sess->host,
			java_chat?_("This is an experimental, backup connection method,\nsupporting only chat rooms. This server\ndoes not allow you to login as invisible, use conferences\n, change your away status, view webcams, or add/remove\nbuddies on your buddy list. Several other major\nfeatures may also be unavailable. Continue?"):_("This is an experimental, backup connection method.\nThis server does not allow you to login as invisible, change\nyour away status, or add/remove\nbuddies on your buddy list. Several other major\nfeatures may also be unavailable. Continue?")
			);

			okbutton=show_confirm_dialog(callbackbuf,"YES","NO");
			if (!okbutton) {return;}
  			g_signal_connect(G_OBJECT(okbutton), "clicked",
					    G_CALLBACK (on_login_button_clicked), NULL);
   			g_object_set_data(G_OBJECT(okbutton), "confirmed", "OK");
			web_login_warn_shown=1;
			return;
		} else {
			tmp_widget =g_object_get_data(G_OBJECT(button), "mywindow" );
			if (tmp_widget) {gtk_widget_destroy(tmp_widget);}
		}
	}

	tmp_widget = lookup_widget( login_window, "chat_username" );
	strncpy(ymsg_sess->user, gyachi_combobox_get_selected_item(tmp_widget), 60);
	
	if (strlen(ymsg_sess->user)<1) {
		show_ok_dialog(_("No username given"));
		return;
	}

	at_host = strcasestr(ymsg_sess->user, "@yahoo");
	if (at_host) {
		/* if user was dumb enough to login with userid@yahoo.com
		 * then remove the "@yahoo.com" because yahoo doesn't like that!
		 */
		*at_host = NULL;
	}

	if (last_loginname) {
		if (!strcasecmp(last_loginname, ymsg_sess->user)) {
			login_name_changed=0;
		}
	}

	if ( (! login_name_changed) && (login_credentials) ) {
			if (verify_passphrase) {free(verify_passphrase); verify_passphrase=NULL;}
			verify_passphrase=strdup( gtk_entry_get_text( GTK_ENTRY(login_credentials)) );
			if (strlen(verify_passphrase)<1) {return;}	
	} else {
		if (last_credentials_key) {free(last_credentials_key);}
		last_credentials_key=NULL;
		if (verify_passphrase) {free(verify_passphrase); verify_passphrase=NULL;}
	}

	if (last_loginname) {free(last_loginname);}
	last_loginname=strdup(ymsg_sess->user);

	tmp_widget = lookup_widget( login_window, "chat_password" );
	if (login_name_changed || strcmp(ymsg_sess->password, gtk_entry_get_text( GTK_ENTRY(tmp_widget)))) {
		if (ymsgr_token) {
			free(ymsgr_token);
			ymsgr_token=NULL;
		}
	}

	strncpy( ymsg_sess->password,
		 gtk_entry_get_text( GTK_ENTRY(tmp_widget)), 30 );

	if (strlen(ymsg_sess->password)<1) {
		show_ok_dialog(_("Incorrect password."));
		return;
	}

	if ( password ) {
		free( password );
		password = NULL;
	}

	/* remember password, will be saved when we write_config() */
	if ( remember_password ) {
		password = strdup( ymsg_sess->password );
	}

	tmp_widget = lookup_widget( login_window, "chat_room" );
	strncpy( ymsg_sess->req_room, gyachi_combobox_get_selected_item(tmp_widget), 62);

	strncpy( ymsg_sess->room,  "[NONE]", 62);

	if (last_chatroom) {free(last_chatroom); }
	last_chatroom=strdup(ymsg_sess->req_room);

	tmp_widget = lookup_widget( login_window, "noroom_button" );
	login_noroom=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tmp_widget));

	tmp_widget = lookup_widget( login_window, "invis_button" );
	login_invisible=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tmp_widget));

	tmp_widget = lookup_widget( login_window, "chat_protocol");
	messy_ver  = yprotocol_name_to_protocol(gyachi_combobox_get_selected_item(tmp_widget));

	write_config();

	gtk_widget_destroy( login_window );
	login_window=NULL;

	if (verify_passphrase && last_credentials_key) {
		if ( ! unlock_yahoo_account(ymsg_sess, verify_passphrase)) {	
			login_window = build_login_window();
			gtk_widget_show_all(login_window);
			return;
		}
		if (last_credentials_key) {free(last_credentials_key);}		
		last_credentials_key=NULL;
	}

	login_credentials=NULL;
	login_to_yahoo_chat();
}

void on_password_entry_activate(GtkEntry *entry, gpointer user_data)
{
	on_login_button_clicked((GtkButton *)user_data, NULL);
}

void on_cancel_login_clicked(GtkButton *button, gpointer user_data)
{
	username[0] = '\0';
	gtk_widget_destroy( login_window );
	login_window=NULL;
	valid_user = 1;
	logged_in = 0;
}


void on_cancel_favs_clicked(GtkButton *button, gpointer user_data)
{
	gtk_widget_destroy( favorites_window );
	favorites_window = NULL;
}



void on_close_profile_clicked(GtkButton *button, gpointer user_data)
{
	if ( ! profile_window )
		return;

	gtk_widget_destroy( profile_window );
	profile_window = NULL;
}

void on_alias_edit_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *parent = user_data;

	edit_alias(parent);
}


void on_alias_delete_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter iter;
	selection=gtk_tree_view_get_selection(chat_aliases);
	if (! gtk_tree_selection_get_selected(selection, &model, &iter)) {return;}
	gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
	alias_selected = -1;
	save_aliases();
}


void on_alias_new_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *parent = user_data;

	GtkTreeSelection *selection;
	selection=gtk_tree_view_get_selection(chat_aliases);
	gtk_tree_selection_unselect_all(selection);
	alias_selected = -1;
	edit_alias(parent);
}


void on_alias_send_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter iter;
	char *alias_ptr;
	char *alias_tmp;
	selection=gtk_tree_view_get_selection(chat_aliases);
	if (! gtk_tree_selection_get_selected(selection, &model, &iter)) {return;}

	gtk_tree_model_get(gtk_tree_view_get_model(chat_aliases), &iter,GYTRIPLE_COL1, &alias_ptr, -1);
	alias_tmp=strdup(alias_ptr);
	if ( user_selected ) {
		check_alias( alias_tmp, user_selected );
	} else {
		check_alias(alias_tmp, "" );
	}
	g_free(alias_ptr);
	free(alias_tmp);
}


void on_alias_save_clicked(GtkButton *button, gpointer user_data)
{
	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter iter;
	gchar *alias_name;
	gchar *cmd_value1;
	gchar *cmd_value2;
	GtkWidget *tmp_widget;

	if ( alias_window ) {
		/* save the entry */
	
	selection=gtk_tree_view_get_selection(chat_aliases);
	
	if (! gtk_tree_selection_get_selected(selection, &model, &iter)) {
		/* NOthing selected, so append */
		gtk_list_store_append(GTK_LIST_STORE(gtk_tree_view_get_model(chat_aliases)), &iter);
	} 


		tmp_widget = lookup_widget( alias_window, "alias_name" );
		snprintf(callbackbuf, 11, "%s", gtk_entry_get_text(GTK_ENTRY(tmp_widget)) );
		alias_name=strdup(callbackbuf);
		tmp_widget = lookup_widget( alias_window, "cmd_value1" );
		cmd_value1=strdup(gtk_entry_get_text(GTK_ENTRY(tmp_widget)));
		tmp_widget = lookup_widget( alias_window, "cmd_value2" );
		cmd_value2=strdup(gtk_entry_get_text(GTK_ENTRY(tmp_widget)));

			gtk_list_store_set(GTK_LIST_STORE(gtk_tree_view_get_model(chat_aliases)), &iter,  
			GYTRIPLE_COL1, alias_name, GYTRIPLE_COL2, cmd_value1, 
			GYTRIPLE_COL3, cmd_value2, -1);

		alias_selected = -1;
		gtk_tree_selection_unselect_all(selection);
		free(cmd_value2);   free(cmd_value1);   free(alias_name);
		save_aliases();

		/* now get rid of the window */
		on_alias_cancel_clicked( button, user_data );
	}
}


void on_alias_cancel_clicked(GtkButton *button, gpointer user_data)
{
	if ( alias_window ) {
		gtk_widget_hide( alias_window );
		gtk_widget_destroy( alias_window );
		alias_window = NULL;
	}
}



void  on_follow_activate(GtkMenuItem *menuitem, gpointer  user_data)
{
	if ( user_selected ) {
		snprintf( callbackbuf, 200, "/follow %s", user_selected );
		try_command( callbackbuf, 0 );
	}
}



gboolean on_chat_entry_key_press_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	GtkTextBuffer *text_buffer;
	GtkClipboard *clip;
	GtkWidget *tmp_widget;

	if ( event->type == GDK_KEY_PRESS ) {

		/* printf( "keyval pressed = %d\n", event->key.keyval ); fflush( stdout ); */


		switch( event->key.keyval ) {
			case 65289:	/* tab, try to expand */
						tab_complete();
						return( TRUE );
						break;

			case 65362:	/* up arrow, scroll up to previous message */
						gtk_entry_set_text( GTK_ENTRY(widget), history_prev());
						return( TRUE );
						break;

			case 65364:	/* down arrow, scroll down to next message */
						gtk_entry_set_text( GTK_ENTRY(widget), history_next());
						return( TRUE );
						break;

			case    99: /* c, try to copy if CTRL-C */
						if ( event->key.state & GDK_CONTROL_MASK ) {
							tmp_widget = (GtkWidget *)ct_widget();

							text_buffer = gtk_text_view_get_buffer(
								GTK_TEXT_VIEW(tmp_widget) );
							clip = gtk_clipboard_get( GDK_SELECTION_CLIPBOARD );

							/* fixed: PhrozenSmoke,  allow smart use of Ctrl+C on 
								both the GtkEntry and TextBuffer, depending on what's
								selected */
							/* Clear old text we may have copied before */
							/* This allows us to truly see if we are trying to 
								copy selected data in the TextBuffer on in the Entry */

							gtk_clipboard_clear(clip);

							/* Try copying the GtkEntry first */
							gtk_editable_copy_clipboard(GTK_EDITABLE(widget));

							/* Check if text was actually copied from the GtkEntry */
							if (! gtk_clipboard_wait_is_text_available (clip)) {
								/* Nothing was copied! Copy from the TextBuffer... */
								gtk_text_buffer_copy_clipboard( text_buffer, clip );
																										}

							/*  printf("\nclip:  %d\n\n", gtk_clipboard_wait_is_text_available (clip) ); fflush(stdout);   */

							return( TRUE );
						}
						break;

			case   102: /* f, try to find if CTRL-F */
						if ( event->key.state & GDK_CONTROL_MASK ) {
							 jump_to_chat_tab();

							search_pos = -1;
							if ( search_text ) {
								free( search_text );
								search_text = NULL;
							}

							if ( ! find_window ) {
								find_window = create_find_window();
							} else {
								if ( search_text ) {
									tmp_widget =lookup_widget( find_window,
										"search_text" );
									gtk_entry_set_text(GTK_ENTRY(tmp_widget),
										search_text );

									tmp_widget = lookup_widget( find_window,
										"case_sensitive" );
									gtk_toggle_button_set_active(
										GTK_TOGGLE_BUTTON(tmp_widget) ,
										search_case_sensitive );
								}
							}
							gtk_widget_show_all( find_window );
							return( TRUE );
						}
						break;

			case   103: /* g, try to find next if CTRL-G */
						if ( event->key.state & GDK_CONTROL_MASK ) {
							search_chat_text( search_case_sensitive );
							return( TRUE );
						}
						break;

			case   118: /* v, try to past if CTRL-V */
						/* since gtk_entry has a gtk_editable, it already */
						/* implements CTRL-V so we do nothing here */
						if ( event->key.state & GDK_CONTROL_MASK ) {
						}
						break;

		}
	}

	return FALSE;
}

/* This is the "Save Current Text" off the "Connection" pulldown menu */
void on_save_current_text_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	char *filename;
	char buf[301];
 
	filename = pm_make_user_filename("gyachi-logs");
	ct_capture_to_file( filename );

	snprintf(buf, 300, "%s %s", _("Chat window captured to file:"), filename);	
	gtk_statusbar_pop( GTK_STATUSBAR(chat_status), st_cid );
	gtk_statusbar_push( GTK_STATUSBAR(chat_status), st_cid, _utf(buf)); 

	free( filename );
}

/* This is the "Log Debug to File" off the "Connection" pulldown menu */
/* The debug file contains all the debug info, as well as packet debugging.
 * However, it is possible to have packet debugging enabled w/o debugging
 * enabled. In this case, the packet debugging will go to stdout.
 * To more easily accomodate packet debugging throughout gyachi, I have
 * created a separate File* pointer (packetdump_fp), which will either
 * point at the debug file, or stdout.
 *
 * Both on_debug_logging_activate(), and on_packet_debugging_activate()
 * coordinate the setting of packetdump_fp.
 */
void on_debug_logging_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *tmp_widget;
	char      *debug_filename;

	tmp_widget = lookup_widget( chat_window, "debug_logging" );
	debug_logging=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(tmp_widget));
	gyachi_set_tooltip(GTK_WIDGET(menuitem), 0);

	if (!debug_logging) {
		/* debug logging is off. Close the Debug file log, if open */
		if ( capture_fp ) {
		      fclose( capture_fp );
		      capture_fp = NULL;
		}

		/* revert packet debugging to stdout */
		if ( packetdump_fp ) {
		      packetdump_fp = stdout;
		}

		/* We're done. */
		return;
	}

	/* At this point, Debug logging is enabled.
	 * If the debug file is already opened, we're done.
	 * Otherwise open the debug file.
	 */
	if ( capture_fp ) {
		/* Debug file is already opened. We're done. */
		/* revert packet debugging to debug file */
		if ( packetdump_fp ) {
		      packetdump_fp = capture_fp;
		}
		return;
	}

	debug_filename = pm_make_user_filename("gyachi-debug");

	capture_fp = fopen( debug_filename, "ab" );
	if ( capture_fp ) {
		fprintf( capture_fp, "\nGyachE Improved, version %s\n"
			 "Copyright (c) 2007-2008 Gregory D. Hosler\n"
			 "Copyright (c) 2006 Stefan Sikora\n"
			 "Copyright (c) 2003-2005, Erica Andrews\n"
			 "%s\nLicense: GNU General Public License\n\nCONNECTION LOG\n", VERSION, GYACH_URL );
		fprintf( capture_fp, "%s", gyach_timestamp());
		fprintf( capture_fp, "\n_____________________\n\n" );
		fflush( capture_fp );
		if (packetdump_fp) {
			packetdump_fp = capture_fp;
		}
		gyachi_set_tooltip(GTK_WIDGET(menuitem), debug_filename);
	} else {
		/* fixme, how about an error message?? */
		/* fixed: PhrozenSmoke, added dialog box */
		show_ok_dialog(_("Error opening file for saving."));
		tmp_widget = lookup_widget( chat_window, "debug_logging" );
		gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(tmp_widget), 0);
		if (packetdump_fp) {
			packetdump_fp = stdout;
		}
	}

	free( debug_filename );
}

/* This is the "Packet Debugging" off the "Connection" pulldown menu */
void on_packet_debugging_activate(GtkCheckMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *checkitem;
	gboolean value;

	checkitem = lookup_widget( chat_window, "packet_debugging" );
	value = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(checkitem));
	if ( value ) {
		debug_packets = 1;
		packetdump_fp = capture_fp ? capture_fp : stdout;
	} else {
		debug_packets = 0;
		packetdump_fp = 0;
	}
	write_config();
}


/* This is the "Log Chat to File" off the "Connection" pulldown menu */
void on_chat_window_logging_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget     *tmp_widget;
	GtkWidget     *chat_text;
	GtkTextBuffer *textbuffer;       
	char          *capture_filename;
	int            rv;
	char           buf[512];

	tmp_widget = lookup_widget( chat_window, "chat_window_logging" );
	chat_window_logging=gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(tmp_widget));

	chat_text  = lookup_widget( chat_window, "chat_text" );
	textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(chat_text));

	gyachi_set_tooltip(GTK_WIDGET(menuitem), 0);

	if (!chat_window_logging) {
		/* Chat logging is off. Close the Chat file log, if open */
		pm_capture_to_file( NULL, textbuffer, GTK_TEXT_VIEW(chat_text), chat_window);

		/* We're done. */
		return;
	}

	/* At this point, Chat file logging is enabled.
	 * If the log file is already opened, we're done.
	 * Otherwise open the Chat log file.
	 */
	capture_filename = pm_make_user_filename("gyachi-logs");

	rv = pm_capture_to_file( capture_filename, textbuffer, GTK_TEXT_VIEW(chat_text), chat_window);
	/*
		    args:
		    GtkTextBuffer *mybuffer,    "textbuffer" = gtk_text_view_get_buffer(GTK_TEXT_VIEW(pms_entry));
		    GtkTextView *widget,        "pmstext"    = gtk_text_view_new () (the display area)
		    GtkWidget  *mywindow )      "pmwindow"   = the overall frame
	*/
	if (rv) {
		/* error occured, and the file was not opened! */
		tmp_widget = lookup_widget( chat_window, "chat_window_logging" );
		gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(tmp_widget), 0);
		free( capture_filename );
		return;
	}

	gyachi_set_tooltip(GTK_WIDGET(menuitem), capture_filename);
	free( capture_filename );

	snprintf( buf, 500, "\nGyachE Improved, version %s\n"
		  "Copyright (c) 2007-2008 Gregory D. Hosler\n"
		  "Copyright (c) 2006 Stefan Sikora\n"
		  "Copyright (c) 2003-2005, Erica Andrews\n"
		  "%s\nLicense: GNU General Public License\n\nCONNECTION LOG\n", VERSION, GYACH_URL );
	append_to_textbox_color(chat_window, NULL , buf );

	snprintf( buf, 500, "%s", gyach_timestamp());
	append_to_textbox_color(chat_window, NULL , buf );

	snprintf( buf, 500, "\n_____________________\n\n" );
	append_to_textbox_color(chat_window, NULL , buf );
}

void on_status_here_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 0 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem))))
		cmd_away( "0" );
}


void on_status_be_right_back_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 1 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "1" );
}


void on_status_busy_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 2 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "2" );
}


void on_status_not_at_home_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 3 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "3" );
}


void on_status_not_at_my_desk_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 4 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "4" );
}


void on_status_not_in_the_office_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 5 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "5" );
}


void on_status_on_the_phone_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 6 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "6" );
}


void on_status_on_vacation_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 7 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "7" );
}


void on_status_out_to_lunch_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 8 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "8" );
}


void on_status_stepped_out_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 9 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "9" );
}


void on_status_invisible_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 12 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "12" );
}


/* added, PhrozenSmoke : Idle away */


void on_status_idle_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 999 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "999" );
}

void on_setup_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	int buddy_tab;

	if ( ! setup_window ) {
		setup_window = create_setup_window();
		set_setup_options();
	}
	/* finally show the window */
	gtk_widget_show_all( setup_window );

	/* Show a specific tab first? */
	if (user_data) {
		GtkWidget *tmp_widget=NULL;
		char *sel_tab=(char *) user_data;
		tmp_widget=g_object_get_data(G_OBJECT(setup_window), "notebook1");
		if (!tmp_widget) {return;}
		if ( (!strcmp(sel_tab,"color")) || (!strcmp(sel_tab,"font")) ) {
			buddy_tab = find_tab_posn(BUDDY_TAB);
			gtk_notebook_set_current_page(GTK_NOTEBOOK(tmp_widget), buddy_tab);
			if (!strcmp(sel_tab,"font")) {
				GtkWidget *tmp_wid=NULL;
				tmp_wid=g_object_get_data(G_OBJECT(setup_window), "notebook2");
				if (tmp_wid) {
					gtk_notebook_set_current_page(GTK_NOTEBOOK(tmp_wid),1);
				}
			}
		}
	}
}

void on_setup_activate_button(GtkButton *button,  gpointer user_data)
{
	on_setup_activate(NULL,user_data);
}


void on_save_setup_clicked(GtkButton *button, gpointer user_data)
{
	if ( ! setup_window )
		return;

	get_setup_options();
	set_text_entry_styles();
	write_config();

	/* destroy the window */
	gtk_widget_destroy( setup_window );
	setup_window = NULL;
}


void on_cancel_setup_clicked(GtkButton *button, gpointer user_data)
{
	if ( ! setup_window )
		return;

	gtk_widget_destroy( setup_window );
	setup_window = NULL;
}


void on_status_custom_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 10 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) )) {
		if ( custom_away_message )
			cmd_away( custom_away_message );
		else
			cmd_away( "Be Right Back" );
	}
}

void on_addfavroom_insert_activate(GtkMenuItem *menuitem, gpointer  user_data)
{
	YMSG_ROOM *room;

	if (!room_selected) {return;}

	room = find_room(room_selected);
	if (room && room->fav) {
		snprintf(callbackbuf, 350, "  %s%s[%s: '%s']%s%s\n" ,
			 YAHOO_STYLE_ITALICON, YAHOO_COLOR_RED,
			 _("The following room is already in your favorites list"), 
			 room_selected,
			 YAHOO_STYLE_ITALICOFF, YAHOO_COLOR_BLACK
			 );
		append_to_textbox_color(chat_window,NULL,callbackbuf);
		return;
	}

	add_room(room_selected, 0, 1);

	write_config();
	snprintf(callbackbuf, 350, "  %s%s[%s: '%s']%s%s\n" ,
		 YAHOO_STYLE_ITALICON, YAHOO_COLOR_ORANGE,
		 _("The following room has been added to your favorites list"), 
		 room_selected,
		 YAHOO_STYLE_ITALICOFF, YAHOO_COLOR_BLACK
		 );
	append_to_textbox_color(chat_window,NULL,callbackbuf);
}




void on_cancel_room_clicked(GtkButton *button, gpointer user_data)
{
	if ( room_window ) {gtk_widget_hide( room_window );	}
}



void collect_roomlist_selected_room()
{
	GtkTreeModel *model;
	GtkTreeIter iter;		
	GtkTreeSelection *selection;

	if (!room_window) {return;}
	selection=gtk_tree_view_get_selection(GTK_TREE_VIEW(lookup_widget( room_window, "room_tree" )));
	if ( gtk_tree_selection_get_selected(selection, &model, &iter)) {
		ROOM_ENTRY *room_item;
		gtk_tree_model_get(model, &iter,GYROOM_DATA, &room_item, -1);		

		if ( room_selected ) {
			free( room_selected );  
			room_selected=NULL;
		}
		if (room_item) {
			if ((!room_item->top_level) && room_item->room_name && 
				strcmp(room_item->room_name, _("---- downloading list ----")) ) {
					room_selected=strdup( room_item->room_name );
			}
		}
	}
}

void display_room_lister_popup()
{
	collect_roomlist_selected_room();
	if (!room_selected) {return ;}
	if (!favroom_setup_menu) {favroom_setup_menu=create_addfavroom_menu();}

	/* if the Setupwindow is running, we need to save all options and 
		hide it */
	if (setup_window) {
		get_setup_options();
		set_text_entry_styles();
		write_config();
		/* destroy the window */
		gtk_widget_destroy( setup_window );
		setup_window = NULL;
	}

	gtk_widget_show_all(GTK_WIDGET(favroom_setup_menu));
	/* right clicked popup action window */
	gtk_menu_popup((GtkMenu *) favroom_setup_menu,
		NULL, NULL, NULL, NULL, 1, 0);
}

gboolean on_room_tree_kb_popup(GtkWidget *widget, gpointer user_data)
{
	/* Shift-F10 pressed */
	display_room_lister_popup();
	return TRUE;
}


void on_goto_room_clicked(GtkButton *button, gpointer user_data)
{
	if (user_list) {
		/* leave current room */
		chat_command("/leave", 0);
	}

	collect_roomlist_selected_room();
	if (!room_selected) {return;}
	snprintf( callbackbuf, 128, "/join %s", room_selected );
	set_current_chat_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(button), PROFNAMESTR))));
	chat_command( callbackbuf, 0 );
	if ( auto_close_roomlist )
		gtk_widget_hide( room_window );
}

void onRoomListActivated(GtkTreeView *tv, GtkTreePath *tp, GtkTreeViewColumn *col, gpointer user_data)
{
	collect_roomlist_selected_room();
	if (!room_selected) {return;}
	snprintf( callbackbuf, 128 , "/join %s", room_selected );
	set_current_chat_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(tv), PROFNAMESTR))));
	chat_command( callbackbuf, 0 );
	if ( auto_close_roomlist ) {gtk_widget_hide( room_window );}
}


gboolean on_room_tree_button_press_event(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	/* Right mouse button, PhrozenSmoke */
	if (event->button == 3 && event->type == GDK_BUTTON_PRESS) {
		display_room_lister_popup();
	}

	return FALSE;
}


void on_setup_insert_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *parent = user_data;

	if ( edit_win ) {return;}
	if (! setup_list) {return;}

	edit_win = create_edit_ignore_window(parent);
	gtk_widget_show_all( edit_win );

	tmp_widget = lookup_widget( edit_win, "edit_ignore_label" );
	if ( ! strcmp( setup_which, "friend_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), _("Add Friend:") );
	} else if ( ! strcmp( setup_which, "regex_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), _("Add Ignore Regex:") );
	} else if ( ! strcmp( setup_which, "ignore_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), _("Add User To Ignore:") );
	} else if ( ! strcmp( setup_which, "login_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), _("Add Yahoo Login:" ));
	} else if ( ! strcmp( setup_which, "favroom_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), _("Add Favorite Room:") );
	/* added, PhrozenSmoke */
	} else if ( ! strcmp( setup_which, "fav_room_list" )) {
		gtk_label_set_text( GTK_LABEL(tmp_widget), _("Add Favorite Room:") );
	}

	tmp_widget = lookup_widget( edit_win, "edit_ignore_text" );
	gtk_entry_set_text( GTK_ENTRY(tmp_widget), "" );
	if ( setup_row_selected ) {
		free( setup_row_selected );  
		setup_row_selected=NULL;
	}
	if (setup_menu) {gtk_menu_popdown((GtkMenu *) setup_menu);}
}


void collect_setup_list_selected() {
	GtkTreeModel *model;
	GtkTreeSelection *selection;

	if (!setup_list) {
		if ( setup_row_selected ) {
			free( setup_row_selected );  
			setup_row_selected=NULL;
		}
		return;
	}
	selection=gtk_tree_view_get_selection(setup_list);
	if ( gtk_tree_selection_get_selected(selection, &model, &setupiter)) {
		gchar *sfound;
		gtk_tree_model_get(model, &setupiter,GYSINGLE_COL1, &sfound, -1);		
		if ( setup_row_selected ) {	free( setup_row_selected );  }
		setup_row_selected=strdup(sfound);
		g_free(sfound);
	} else {
		if ( setup_row_selected ) {
			free( setup_row_selected );  
			setup_row_selected=NULL;
		}
	}
}


void on_setup_delete_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (! setup_list) {return;}
	collect_setup_list_selected();

	if ( setup_row_selected) {

		if ( ! strcmp( setup_which, "friend_list" )) {
			if ( using_web_login || ycht_is_running() ) {
				show_ok_dialog(_("This feature is not available when connected using the WEBCONNECT or YCHT servers."));
			}
			else {
				remove_friend(setup_row_selected, TRUE);
			}
		}

		/* added PhrozenSmoke */
		if ( ! strcmp( setup_which, "fav_room_list" )) {
			YMSG_ROOM *room;

			room = find_room(setup_row_selected);
			if (room) {
				room->fav = 0;
			}
		}

		/* added, PhrozenSmoke - makes the setup ignore list deletion actually functional */
		if ( ! strcmp( setup_which, "ignore_list" )) {
			snprintf(callbackbuf,128,"/ignore %s", setup_row_selected );
			chat_command(callbackbuf, 0);
		}

		gtk_list_store_remove(GTK_LIST_STORE(gtk_tree_view_get_model(setup_list)), &setupiter);
		if ( setup_row_selected ) {
			free( setup_row_selected );  
			setup_row_selected=NULL;
		}

		if ( ! strcmp( setup_which, "fav_room_list" )) {
			write_config();
		}
	}
	if (setup_menu) {
		gtk_menu_popdown((GtkMenu *) setup_menu);
	}
}


void on_setup_edit_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *parent = user_data;

	if ( edit_win ) {return;}
	if (! setup_list) {return;}
	collect_setup_list_selected();

	if ( setup_row_selected ) {
		edit_win = create_edit_ignore_window(parent);
		gtk_widget_show_all( edit_win );

		tmp_widget = lookup_widget( edit_win, "edit_ignore_label" );
		if ( ! strcmp( setup_which, "friend_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), _("Edit Friend") );
		} else if ( ! strcmp( setup_which, "regex_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), _("Edit Ignore Regex") );
		} else if ( ! strcmp( setup_which, "ignore_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), _("Edit Ignored User") );
		} else if ( ! strcmp( setup_which, "favroom_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), _("Edit Favorite Room") );
		} else if ( ! strcmp( setup_which, "login_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), _("Edit Yahoo Login") );
		/* added, PhrozenSmoke */
		} else if ( ! strcmp( setup_which, "fav_room_list" )) {
			gtk_label_set_text( GTK_LABEL(tmp_widget), _("Edit Favorite Room") );
		}

		tmp_widget = lookup_widget( edit_win, "edit_ignore_text" );
		gtk_entry_set_text( GTK_ENTRY(tmp_widget),setup_row_selected );
	}

	if (setup_menu) {gtk_menu_popdown((GtkMenu *) setup_menu);}
}

void display_setup_list_popup(GtkWidget *parent, GtkWidget *widget) {
		GtkWidget *tmp_widget;

		setup_list = NULL;
		if ( setup_row_selected ) {
			free( setup_row_selected );  
			setup_row_selected=NULL;
		}

		tmp_widget = lookup_widget( setup_window, "friend_list" );
		if ( tmp_widget == widget )
			strncpy( setup_which, "friend_list", 30 );

		tmp_widget = lookup_widget( setup_window, "regex_list" );
		if ( tmp_widget == widget )
			strncpy( setup_which, "regex_list", 30 );

		tmp_widget = lookup_widget( setup_window, "ignore_list" );
		if ( tmp_widget == widget )
			strncpy( setup_which, "ignore_list", 30 );

		tmp_widget = lookup_widget( setup_window, "login_list" );
		if ( tmp_widget == widget )
			strncpy( setup_which, "login_list" , 30);

		tmp_widget = lookup_widget( setup_window, "favroom_list" );
		if ( tmp_widget == widget )
			strncpy( setup_which, "favroom_list", 30 );

		setup_list = GTK_TREE_VIEW(widget);
		collect_setup_list_selected();
		if (setup_menu) {gtk_widget_destroy(setup_menu); setup_menu = NULL;}
		setup_menu=create_setup_menu(parent);
		gtk_widget_show_all(GTK_WIDGET(setup_menu));

		/* right clicked popup action window */
		gtk_menu_popup((GtkMenu *) setup_menu,
			NULL, NULL, NULL, NULL, 1, 0);

		/* printf("Menu popped up:  %s\n", setup_menu ? "is not null":"is null");
		fflush(stdout);
		printf("Menu popped up-tmp_widget:  %s\n", tmp_widget ? "is not null":"is null");
		fflush(stdout); */ 
}

gboolean on_setup_list_button_press_event(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	if (event->button == 3 && event->type == GDK_BUTTON_PRESS) {
		display_setup_list_popup(user_data, widget);
	}

	return FALSE;
}

void on_setuplist_tree_kb_popup(GtkWidget *widgy, gpointer user_data)
{
	display_setup_list_popup(user_data, widgy);
}


void on_edit_ig_save_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *tmp_widget;
	char *answer;
	GdkPixbuf *imbuf=NULL;
	GtkTreeModel *model;
	GtkWindow *edit_ignore_window = user_data;

	if (! setup_list) {return;}
	tmp_widget = lookup_widget( edit_win, "edit_ignore_text" );

	if ( setup_row_selected ) {
		/* editing a current row, so delete first */
		if ( ! strcmp( setup_which, "friends_list" )) {
			if ( using_web_login || ycht_is_running() ) {
				show_ok_dialog(_("This feature is not available when connected using the WEBCONNECT or YCHT servers."));
			}
			else {
				remove_friend( setup_row_selected, TRUE );
			}
		}

		/* added PhrozenSmoke */
		if ( ! strcmp( setup_which, "fav_room_list" )) {
			YMSG_ROOM *room;

			room = find_room(setup_row_selected);
			if (room) {
				room->fav = 0;
			}
		}

		gtk_list_store_remove(GTK_LIST_STORE(gtk_tree_view_get_model(setup_list)), &setupiter);
		if ( setup_row_selected ) {
			free( setup_row_selected );  
			setup_row_selected=NULL;
		}
	}

	answer=strdup(gtk_entry_get_text( GTK_ENTRY(tmp_widget)));
	gtk_list_store_append(GTK_LIST_STORE(gtk_tree_view_get_model(setup_list)), &setupiter);

	model = gtk_tree_view_get_model(setup_list);
	if ( ! strcmp( setup_which, "friend_list" )) {
		imbuf=get_pixbuf_from_stock_id(GTK_WIDGET(edit_ignore_window),
					       GYACHI_STATUS_HERE_MALE,
					       GTK_ICON_SIZE_MENU);
	} else if ( ! strcmp( setup_which, "regex_list" )) {
		imbuf=get_pixbuf_from_stock_id(GTK_WIDGET(edit_ignore_window),
					       GYACHI_STATUS_MUTE,
					       GTK_ICON_SIZE_MENU);
	} else if ( ! strcmp( setup_which, "ignore_list" )) {
		imbuf=get_pixbuf_from_stock_id(GTK_WIDGET(edit_ignore_window),
					       GYACHI_STATUS_IGNORE,
					       GTK_ICON_SIZE_MENU);
	} else if ( ! strcmp( setup_which, "favroom_list" )) {
		imbuf=get_pixbuf_from_stock_id(GTK_WIDGET(edit_ignore_window),
					       GYACHI_PM_JOIN,
					       GTK_ICON_SIZE_MENU);
	} else if ( ! strcmp( setup_which, "login_list" )) {
		imbuf=get_pixbuf_from_stock_id(GTK_WIDGET(edit_ignore_window),
					       GYACHI_STATUS_HERE,
					       GTK_ICON_SIZE_MENU);
	} else if ( ! strcmp( setup_which, "fav_room_list" )) {
		imbuf=get_pixbuf_from_stock_id(GTK_WIDGET(edit_ignore_window),
					       GYACHI_PM_JOIN,
					       GTK_ICON_SIZE_MENU);
	}

	gtk_list_store_set(GTK_LIST_STORE(model), &setupiter, 
			   GYSINGLE_PIX_TOGGLE, imbuf?TRUE:FALSE, 
			   GYSINGLE_PIX, imbuf,
			   GYSINGLE_COL1, answer,
			   GYSINGLE_COLOR, NULL, GYSINGLE_TOP, "",  -1);
	if (imbuf) {
		g_object_unref(imbuf);
	}

	gtk_tree_selection_select_iter(gtk_tree_view_get_selection(setup_list), &setupiter);
	if ( edit_win ) {gtk_widget_destroy( edit_win );}
	edit_win = NULL;
	if ( ! strcmp( setup_which, "friend_list" )) {
		add_friend(chat_window, answer);
	}

	/* added PhrozenSmoke */
	if ( ! strcmp( setup_which, "fav_room_list" )) {
		add_room(answer, 0, 1);
		write_config();
	}
	free(answer);
}


void on_edit_ig_cancel_clicked(GtkButton *button, gpointer user_data)
{
	if ( edit_win )
		gtk_widget_destroy( edit_win );

	edit_win = NULL;
}


void on_status_autoaway_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	if (( my_status != 11 ) &&
		(gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem)) ))
		cmd_away( "11" );
}


gboolean on_favorites_destroy_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if ( favorites_window )
		gtk_widget_destroy( favorites_window );

	favorites_window = NULL;

	return( TRUE );
}


gboolean on_profile_window_destroy_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if ( profile_window )
		gtk_widget_destroy( profile_window );

	profile_window = NULL;

	return( TRUE );
}


gboolean on_alias_window_destroy_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{

  return FALSE;
}


gboolean on_setup_window_destroy_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if ( setup_window )
		gtk_widget_destroy( setup_window );

	setup_window = NULL;

	return( TRUE );
}


gboolean on_edit_ignore_window_destroy_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if ( edit_win )
		gtk_widget_destroy( edit_win );

	edit_win = NULL;

	return( TRUE );
}


gboolean on_room_list_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if ( room_window ) {
		gtk_widget_hide( room_window );
	}

	return( TRUE );
}


void on_exit_clicked(GtkButton *button, gpointer user_data)
{
	on_quit_activate( NULL, NULL );
}


void on_tgl_bold_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
	use_bold = gtk_toggle_button_get_active( togglebutton );
}


void on_tgl_italics_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
	use_italics = gtk_toggle_button_get_active( togglebutton );
}


void on_tgl_underline_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
	use_underline = gtk_toggle_button_get_active( togglebutton );
}




/* added PhrozenSmoke: a SHARED method for sending PM text, it seems kind of dumb 
     that we had two large callbacks for sending text with the 'Send' button or by sending 
     text by hitting 'Enter' - let's be sensible and use ONE method for sending PM text - 
     before this, on_pms_send_activate and on_pms_entry_activate were re-writes of 
     the same method, just looking up different widgets.  Plus, the methods were inconsistent 
     'on_pms_entry_activate would bring us back from 'away' but on_pms_send_activate 
     didn't - let's keep behavior consistent */

/*  Also, this new shared method finally adds support for fonts, font sizes, colors, 
      faders, and smileys in PMs, instead of plain boring black text */

void pm_clear_text_view(GtkWidget *textv) {
	GtkTextIter tstart;
	GtkTextIter tend;
	int text_length;
	GtkTextBuffer *text_buffer;
	text_buffer=gtk_text_view_get_buffer( GTK_TEXT_VIEW(textv) );
	text_length = gtk_text_buffer_get_char_count( text_buffer );
	gtk_text_buffer_get_iter_at_offset( text_buffer, &tstart, 0 );
	gtk_text_buffer_get_iter_at_offset( text_buffer, &tend, text_length );
	gtk_text_buffer_delete( text_buffer, &tstart, &tend );
	gtk_text_buffer_get_end_iter( text_buffer, &tend );
	gtk_text_buffer_create_mark( text_buffer, "end_mark", &tend, 0 );
}

void send_pm_session_text(PM_SESSION *pm_sess)
{
	GtkWidget *pms_entry;
	char *text;
	char buf[1408] = "/tell ";   /* leave extra space for formatting */
	char textbuf[1152]="";
	char fontbuf[150]="";
	char colbuf[20]="";
	char *tuxviron=NULL;
	char *myalias=NULL;
	/* Support pm '/' commands /t, /e, /clear - think, emote, clear */
	int pm_command=0;
	int search_res=0;


	pms_entry = lookup_widget( pm_sess->pm_window, "pms_entry" );

	if (pm_sess->window_style==1) {
		int  length;
		GtkTextIter start;
		GtkTextIter end;
		gchar *ptr;
		GtkTextBuffer *mybuffer;
		mybuffer=g_object_get_data(G_OBJECT(pms_entry), "textbuffer");
		length = gtk_text_buffer_get_char_count( mybuffer );
		gtk_text_buffer_get_iter_at_offset( mybuffer, &start, 0 );
		gtk_text_buffer_get_iter_at_offset(mybuffer, &end, length );
		ptr = gtk_text_buffer_get_text(mybuffer, &start, &end, 0 );
		text = strdup(ptr);
		g_free( ptr );
		pm_clear_text_view(pms_entry);
	} else {
		text = strdup(gtk_entry_get_text(GTK_ENTRY(pms_entry)));
		gtk_entry_set_text(GTK_ENTRY(pms_entry), "");
	}

	if ( ! strlen( text )) {
		free(text);   /* added PhrozenSmoke, seg fault watch */
		return;
	}

	if ( (!strncasecmp(text,"/clear", 6)) || 
		(!strncasecmp(text,"/clr", 4)) ) { /* request to clear PM box */
		pm_clear_text_view(pm_sess->pm_text);
		set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
		pm_sess->typing = 0;
		ymsg_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );
		reset_current_pm_profile_name();
		return; 
	}

	if ( (!strncasecmp(text,"/date", 5)) || (!strncasecmp(text,"/time", 5)) ) { 
		time_t time_llnow= time(NULL);
		append_to_textbox_color( pm_sess->pm_window, pm_sess->pm_text, buf );
		append_timestamp(pm_sess->pm_window,pm_sess->pm_text);
		snprintf(buf,50, "%s", ctime(&time_llnow ));
		append_to_textbox_color( pm_sess->pm_window, pm_sess->pm_text, buf );
		set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
		pm_sess->typing = 0;
		ymsg_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );
		reset_current_pm_profile_name();
		return; 
	}


	if ( ! strncasecmp(text,"/help", 5) ) { /* show help */
		snprintf( buf, 1000, "%s/adv - Send Gyach-E URL info\n/clear - Clear this window\n/clr - Clear this window\n/e - Send *emote* text\n/t - Send . o O ( think ) text\ns: [term] - search the web for 'term' and share\n/date - show current data/time locally\n/time - show current data/time locally\n/ver - Send Gyach-E URL info\n/help - Show PM help\n", YAHOO_COLOR_PMPURPLE
		 );
		append_to_textbox_color( pm_sess->pm_window, pm_sess->pm_text, buf );
		set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
		pm_sess->typing = 0;
		ymsg_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );
		reset_current_pm_profile_name();
		return; 
	}

	if (!strncasecmp(text,"/t ", 3)) { /* 'Think' text */
		pm_command=1;
	}
	if (!strncasecmp(text,"/e ", 3)) { /* 'Emote' text */
		pm_command=2;
	}

	if (!strncasecmp(text,"s: ", 3)) { /* web search */
		search_res=1;
	}

	if ( (!strncasecmp(text,"/ver", 4)) || (!strncasecmp(text,"/adv", 4)) ) {  
		struct utsname un;
		uname( &un );
		/* Gyach-E version */ 
		snprintf( textbuf, 550, 
			"%sGYachE Improved %s version %s  [%s%s%s] under %s  %s.  GYachE Improved supports webcams, faders, Y! 'nicknames', and %spY! Voice Chat%s (the FIRST Y! voice chat program for Linux.)",
			YAHOO_STYLE_BOLDON, YAHOO_STYLE_BOLDOFF, VERSION,
			YAHOO_STYLE_URLON, GYACH_URL, YAHOO_STYLE_URLOFF,
			un.sysname, un.release, YAHOO_STYLE_BOLDON, YAHOO_STYLE_BOLDOFF);

		free(text);
		text=strdup(textbuf);
		snprintf(textbuf, 3,"%s","");
	}

	set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));

	strncat( buf, pm_sess->pm_user , 75);
	strcat( buf, " " );

	/* added by PhrozenSmoke:  add formatting to PM messages */

	if ( use_color && (!use_chat_fader) ) {
		if ( ! strcmp( use_color, "black" )) {
			strcat( textbuf, YAHOO_COLOR_BLACK );
		} else if ( ! strcmp( use_color, "blue" )) {
			strcat( textbuf, YAHOO_COLOR_BLUE );
		} else if ( ! strcmp( use_color, "cyan" )) {
			strcat( textbuf, YAHOO_COLOR_CYAN );
		} else if ( ! strcmp( use_color, "gray" )) {
			strcat( textbuf, YAHOO_COLOR_GRAY );
		} else if ( ! strcmp( use_color, "green" )) {
			strcat( textbuf, YAHOO_COLOR_GREEN );
		} else if ( ! strcmp( use_color, "pink" )) {
			strcat( textbuf, YAHOO_COLOR_PINK );
		} else if ( ! strcmp( use_color, "purple" )) {
			strcat( textbuf, YAHOO_COLOR_PURPLE );
		} else if ( ! strcmp( use_color, "yellow" )) {
			strcat( textbuf, "\033[#ffff00m" );
		} else if ( ! strcmp( use_color, "orange" )) {
			strcat( textbuf, "\033[#ffc800m" );
		} else if ( ! strcmp( use_color, "red" )) {
			strcat( textbuf, YAHOO_COLOR_RED );
		} else if ( ! strcmp( use_color, "custom" )) {
			snprintf( colbuf, 19, "\033[#%02x%02x%02xm",
				  custom_color_red, custom_color_green, custom_color_blue );			
			strcat(textbuf,colbuf);	
		}
	}

	if (strstr(text,YAHOO_FONT_TAG_START)==NULL) {
		/* only append if 'cmd' contains no 'font' tag */
		snprintf( fontbuf, 148, "%s %s%s\" %s%d\">",
			  YAHOO_FONT_TAG_START, YAHOO_FONT_FACE_START, 
			  font_family?font_family:"Sans",
			  YAHOO_FONT_SIZE_START, font_size );
		strcat(textbuf,fontbuf);
	}

	if (use_chat_fader && fader_start_string && fader_end_string) {  
		/* fader use requested */
		strcat(textbuf, fader_start_string);
	} 

	if (use_bold)
		strcat(textbuf, YAHOO_STYLE_BOLDON);

	if (use_italics)
		strcat(textbuf, YAHOO_STYLE_ITALICON);

	if (use_underline)
		strcat(textbuf, YAHOO_STYLE_UNDERLINEON);

	if (pm_command==2) { /* emote */  strcat(textbuf,"** ");}
	if (pm_command==1) { /* think */  strcat(textbuf,". o O ( ");}
	if (pm_command) { 
		strncat( textbuf, text+3, txlimit ); 
	} else {strncat( textbuf, text, txlimit ); } /* plain text */
	if (pm_command==2) { /* emote */  strcat(textbuf," **");}
	if (pm_command==1) { /* think */  strcat(textbuf," )");}

	if (use_chat_fader && fader_start_string && fader_end_string) {  
		strcat(textbuf, fader_end_string);
	}

	sharing_bimages=pm_sess->buddy_image_share;

	if (pm_sess->sms) {
		/* just to be safe, turn encryption off if the recipient is on SMS */ 
		pm_sess->encrypted_myway=0;
		pm_sess->encrypted_theirway=0;
	}

	if ( (enable_tuxvironments || 
	      (pm_sess->encrypted_myway &&  pm_sess->encrypted_theirway)) &&
	     (! pm_sess->sms)  && (! search_res) ) {
		char *tosend=_b2loc(textbuf);

		if (pm_sess->encrypted_myway &&  pm_sess->encrypted_theirway) {
			set_current_gpgme_passphrase(pm_sess->my_gpg_passphrase);
			tosend=gyache_encrypt_message(get_current_pm_profile_name(),_b2loc( textbuf), pm_sess->encryption_type);
		}

		tuxviron=g_object_get_data(G_OBJECT(pm_sess->pm_window),"imv");			

		if (tuxviron) {
			if (strlen(tuxviron)>3) {
				ymsg_pm_full(ymsg_sess, pm_sess->pm_user, tosend, tuxviron );
			} else {
				ymsg_pm(ymsg_sess, pm_sess->pm_user, tosend );
			}
		} else {ymsg_pm(ymsg_sess, pm_sess->pm_user, tosend );}
	} else {
		/* NO Tuvironment, no encryption */ 
		if (pm_sess->sms || search_res) { 
			/* send plain text, SMS or search result */  
			strncat(buf,text, 154); 
		}
		else {strncat(buf,textbuf, 1152); }
		chat_command(_b2loc(buf), 0);
	}

	if ( chat_timestamp_pm ) {
		append_timestamp(pm_sess->pm_window,pm_sess->pm_text);
	}

	if (pm_nick_names) {myalias=get_screenname_alias(get_current_pm_profile_name());}

	snprintf( buf, 1406, "%s%s%s%s%s%s %s \n",
		YAHOO_COLOR_PMBLUE, YAHOO_STYLE_BOLDON, 
		myalias?myalias:get_current_pm_profile_name(),
		pm_command?" ":":", 	/* emote or think vs plain */
		YAHOO_COLOR_BLACK, YAHOO_STYLE_BOLDOFF, textbuf );
	// if (show_emoticons) {convert_smileys(buf); }
	append_to_textbox_color( pm_sess->pm_window, pm_sess->pm_text, buf );
	/* g_warning("TEXT IM:  %s",textbuf);  */

	if (myalias) {g_free(myalias); myalias=NULL;}
	reset_current_pm_profile_name();

	if (enable_tuxvironments) {
		if (tuxviron) {
			gtk_widget_queue_draw( GTK_WIDGET(pm_sess->pm_text));
		}
	}


	if (search_res) {handle_y_search_results(pm_sess->pm_window, pm_sess->pm_text, text);}

	free( text );

	if ((my_status == 11) ||
	    ((my_status) && (my_status != 12) && (pm_brings_back))) {
		cmd_away( "0" );
	}

	pm_notebook_set_typing_status(pm_sess, SENT_TEXT);

	auto_away_time = time(NULL) + ( auto_away * 60 );
}


/* end added PhrozenSmoke */

void  on_pm_send_clicked(GtkButton *button,  gpointer user_data)
{
	GtkWidget *pm_user;
	GtkWidget *pm_entry;
	PM_SESSION *mypm_sess;
	GtkWidget *pms_entry=NULL;
	char *text=NULL;
	char *myuser;
	GtkWidget *pm_window = (GtkWidget *)user_data;

	pm_user = lookup_widget( pm_window, "pm_user" );
	snprintf( callbackbuf,  78, "%s", gtk_entry_get_text(GTK_ENTRY(pm_user)) );
	myuser = skip_whitespace( callbackbuf );
	if (strlen(myuser)<1) {return;}
	pm_entry = lookup_widget( pm_window, "pm_entry" );		
	text=strdup(gtk_entry_get_text(GTK_ENTRY(pm_entry)));
	if (strlen(text)==0) {
		free(text);
		return ;
	}
	if (user_selected) {free(user_selected); user_selected=NULL;}
	user_selected=strdup(myuser);
	on_pm_activate(NULL, NULL);

	if ( (mypm_sess = find_pm_session( user_selected )) ) {
		pms_entry = lookup_widget( mypm_sess->pm_window, "pms_entry" );
		if (pms_entry) {
			gyachi_combobox_select_item( 
				g_object_get_data(G_OBJECT(mypm_sess->pm_window), PROFNAMESTR),
				retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_entry), PROFNAMESTR))));
			
			if (mypm_sess->window_style==1) {
				gtk_text_buffer_set_text(g_object_get_data(G_OBJECT(pms_entry), "textbuffer"), text, strlen(text));
			} else {
				gtk_entry_set_text(GTK_ENTRY(pms_entry),text );
			}

			send_pm_session_text(mypm_sess);
		}
	}
	free(text);
	if (user_selected) {free(user_selected); user_selected=NULL;}
	gtk_widget_destroy( pm_window );
	pm_window=NULL;
}





void on_pms_entry_activate(GtkEditable *editable, gpointer user_data)
{
	PM_SESSION *pm_sess;

	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(editable), "pms_entry")) ) {
		set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
		pm_sess->typing = 0;
		ymsg_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );
		send_pm_session_text(pm_sess);	
		reset_current_pm_profile_name();	
	}
}



void on_pms_send_clicked(GtkButton *button, gpointer user_data)
{
	PM_SESSION *pm_sess;

	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(button), "pms_send" )) ) {
		set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
		pm_sess->typing = 0;
		ymsg_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );
		send_pm_session_text(pm_sess);
		focus_pm_entry(pm_sess);
		reset_current_pm_profile_name();
	}
}


/* added PhrozenSmoke: A 'buzz' feature */
void on_pms_buzz_clicked(GtkButton *button, gpointer user_data)
{
	PM_SESSION *pm_sess;

	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(button), "buzz_user" )) ) {
		set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));

		if ( chat_timestamp_pm ) {
			append_timestamp(pm_sess->pm_window,pm_sess->pm_text);
		}
		snprintf(callbackbuf, 256, "<font size=\"16\">  %s%s%s %s%s %s%s\n", 
						"\033[#C65CC6m", YAHOO_STYLE_BOLDON, "** BUZZ!!! **",  
						"\033[#8DA8D4m", "** BUZZ!!! **", 
						YAHOO_STYLE_BOLDOFF, YAHOO_COLOR_BLACK);
		append_to_textbox_color( pm_sess->pm_window, pm_sess->pm_text, callbackbuf );
		snprintf(callbackbuf, 150, "/tell %s <ding>", pm_sess->pm_user);
		chat_command(callbackbuf, 0);
		focus_pm_entry(pm_sess);
		reset_current_pm_profile_name();
	     }
}
/*  end buzz feature */


void on_pms_clear_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *pms_entry;
	PM_SESSION *pm_sess;


	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(button), "pms_clear" )) ) {
		pms_entry = lookup_widget( pm_sess->pm_window, "pms_entry" );
		set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));

		if (pm_sess->window_style==1) {
			pm_clear_text_view(pms_entry);
		} else {
			gtk_entry_set_text(GTK_ENTRY(pms_entry), "");
		}		
			if (pm_sess->typing ) {
				pm_sess->typing = 0;
				ymsg_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );
			}
		focus_pm_entry(pm_sess);
		reset_current_pm_profile_name();
	}
}


/* Closes window and frees all PM session resources, and turns typing status
   and encryption stuff off */

void shutdown_pms_session (PM_SESSION *pm_sess)
{
	if ( pm_sess  != NULL ) {
		char *tuxenv=NULL;
		int encrypt_say_goodbye=0;

		if (plugins_yphotos_loaded()) {
			plugins_remove_yphoto_album(pm_sess->pm_user);
		}

		set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));

		if (pm_sess->typing ) {
			pm_sess->typing = 0;
			ymsg_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );
		}

		if (pm_sess->encrypted_myway) {
			/* tell them encryption is off */
			encrypt_say_goodbye=1;
			snprintf(callbackbuf, 80, "%s", pm_sess->pm_user);
			pm_sess->encrypted_myway=0;
		}

		/* memory leak fix, also seg-fault watch */	
		/* clear tuxenvironment stuff */
		tuxenv=g_object_get_data(G_OBJECT(pm_sess->pm_window ), "imv");
		if (tuxenv != NULL) {
			free(tuxenv);
			tuxenv=NULL;
			g_object_set_data(G_OBJECT(pm_sess->pm_window ), "imv", tuxenv);
		}

		/* clear logging stuff */
		tuxenv=g_object_get_data(G_OBJECT(pm_sess->pm_text ), "logfilename");
		if (tuxenv != NULL) {
			free(tuxenv);
			tuxenv=NULL;
			g_object_set_data(G_OBJECT(pm_sess->pm_text), "logfilename", tuxenv);
		}

		if (g_object_get_data(G_OBJECT(pm_sess->pm_text),"logfile") != NULL) {
		        /* Close any open log-files */
		        FILE *lastfile;
			lastfile=g_object_get_data(G_OBJECT(pm_sess->pm_text),"logfile");
			fprintf(lastfile, "\n" );
			fflush(lastfile);
			fclose(lastfile);
			lastfile=NULL;
			g_object_set_data(G_OBJECT(pm_sess->pm_text),"logfile", lastfile);
		}

		gtk_widget_destroy( pm_sess->pm_window );
		pm_list = g_list_remove( pm_list, pm_sess );

		/* memory leak fix, also seg-fault watch */
		if (pm_sess->pm_user) {
			free(pm_sess->pm_user);
			pm_sess->pm_user=NULL;
		}

		free( pm_sess );

		/* We want to make sure we send this after the window and text buffer 
		   are destroyed to avoid Gtk problems if/when a response comes back */
		if (encrypt_say_goodbye) {
			ymsg_encryption_notify(ymsg_sess,callbackbuf,0);
		}
	}
	reset_current_pm_profile_name();
}

void on_pms_close_clicked(GtkWidget *button, gpointer user_data)
{
	PM_SESSION *pm_sess;

	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(button), "pms_close" )) ) {
		shutdown_pms_session (pm_sess);
	}
}

void on_pms_ignore_clicked_cb(GtkButton *button, gpointer user_data)
{
	PM_SESSION *pm_sess;
	GtkWidget *tmp_widget;

	tmp_widget =g_object_get_data(G_OBJECT(button), "mywindow" );
	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(user_data), "pms_ignore" )) ) {
		if ( ! ignore_check( pm_sess->pm_user )) {ignore_toggle( pm_sess->pm_user );}
		shutdown_pms_session (pm_sess);
	}
	if (tmp_widget) {gtk_widget_destroy(tmp_widget);}
}

void on_pms_ignore_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *okbutton=NULL;

	okbutton = show_confirm_dialog(_("Are you sure you want to ignore this and close this window?"),"YES","NO");
	if (!okbutton) {return;}
	g_signal_connect(G_OBJECT(okbutton), "clicked",
			    G_CALLBACK (on_pms_ignore_clicked_cb), button);
}


void on_chat_status_map(GtkWidget *widget, gpointer user_data)
{
	chat_status = widget;
}


void on_pms_profile_clicked(GtkButton *button,  gpointer  user_data)
{
	PM_SESSION *pm_sess;
	char       *buffer;

	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(button), "pms_profile" )) ) {
		buffer = malloc(strlen(pm_sess->pm_user) + 10);
		strcpy(buffer, "/profile ");
		strcat(buffer, pm_sess->pm_user);
		chat_command(buffer, 0);		
		free(buffer);
		focus_pm_entry(pm_sess);
	}
	return;
}


void on_room_tree_tree_expand(GtkTreeView *treeview, GtkTreeIter *iterr, GtkTreePath *treepath,  gpointer user_data)
{
	ROOM_ENTRY *room_item;

	gtk_tree_model_get(gtk_tree_view_get_model(treeview), 
			iterr, GYROOM_DATA, &room_item, -1);

	if ( ! room_item->populated ) {
		if (populate_child_room_list( room_item->room_id, treeview, treepath ) ) {
			room_item->populated = 1;

			if ( room_item->temp_child ) {
				GtkTreeIter childiter;
				if (gtk_tree_model_get_iter(gtk_tree_view_get_model(treeview), &childiter, 
							    room_item->temp_child  ) ) {
					gtk_tree_store_remove(GTK_TREE_STORE(gtk_tree_view_get_model(treeview)), &childiter);
					gtk_tree_path_free(room_item->temp_child);
					room_item->temp_child = NULL;
					/* gtk_tree_store_set(GTK_TREE_STORE(gtk_tree_view_get_model(treeview)), iterr, 
					   GYROOM_DATA, room_item, -1); */ 
				}
			}
		}
	}
	/* DO NOT FREE This the gpointer we obtain and the one in the tree store
	are one in the same! */
	/* g_free(room_item); */
}

void display_favorite_list_popup(GtkWidget *parent, GtkWidget *widget) {
	if ( favorites_window ) {
		setup_list = GTK_TREE_VIEW(lookup_widget( favorites_window, "fav_room_list" ));
		if ( GTK_WIDGET(setup_list) == widget ) {strncpy( setup_which,"fav_room_list", 30);}
	}
	else {
		return;
	}

	setup_list = GTK_TREE_VIEW(widget);
	collect_setup_list_selected();
	if (setup_menu) {gtk_widget_destroy(setup_menu); setup_menu = NULL;}
	setup_menu=create_setup_menu(parent);
	gtk_widget_show_all(GTK_WIDGET(setup_menu));

	/* right clicked popup action window */
	gtk_menu_popup((GtkMenu *) setup_menu,
		NULL, NULL, NULL, NULL, 1, 0);
}

void  jump_to_favorite_room(GtkWidget *widget)
{
	char *buffer;

	if ( favorites_window ) {
		setup_list = GTK_TREE_VIEW(lookup_widget( favorites_window, "fav_room_list" ));
		strncpy( setup_which, "fav_room_list", 30 );
	}
	else {
		return ;
	}

	collect_setup_list_selected();
	if (! setup_row_selected ) {return; }

	if (user_list) {
		/* leave current room */
		chat_command("/leave", 0);
	}

	/* join room */
	buffer = malloc(strlen(setup_row_selected) + 7);
	strcpy(buffer, "/join ");
	strcat(buffer, setup_row_selected);
	set_current_chat_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(widget), PROFNAMESTR))));
	chat_command(buffer, 0 );
	/* printf("tried to join-222:  %s \n", buffer); fflush(stdout); */
	free(buffer);

	if ( auto_close_roomlist ) {
		gtk_widget_destroy( favorites_window );
		favorites_window = NULL;
	}
}


gboolean on_favroom_list_button_press_event(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	/* added: PhrozenSmoke, right mouse clicks pop up menu for editing favorites
		like the menu seen in the Setup window */

	if (event->button == 3 && event->type == GDK_BUTTON_PRESS) {
		display_favorite_list_popup(user_data, widget);
	}
	return FALSE;
}

void on_favoriteroom_tree_kb_popup(GtkWidget *widgy, gpointer user_data)
{
	display_favorite_list_popup(user_data, widgy);
}

/* double-clicks on fav room list */
void onFavoriteRoomRowActivated(GtkTreeView *tv, GtkTreePath *tp, GtkTreeViewColumn *col, gpointer user_data)
{
	jump_to_favorite_room(GTK_WIDGET(tv));
}

void on_goto_fav_clicked(GtkButton *button, gpointer user_data)
{
	jump_to_favorite_room(GTK_WIDGET(button));
}


gboolean on_login_window_destroy_event(GtkWidget *widget, GdkEvent *event, gpointer user_data) 
{
	login_window=NULL;
	return (0);
}


gboolean on_pms_text_button_press_event(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
#ifdef USE_GTK2
	int x, y;
	gint buf_x, buf_y;
#endif
	gchar *ptr;

	if (event->button == 1 && event->type == GDK_BUTTON_PRESS) {
#ifdef USE_GTK2
		x = event->x;
		y = event->y;

		gtk_text_view_window_to_buffer_coords( GTK_TEXT_VIEW(widget),
			GTK_TEXT_WINDOW_TEXT, x, y, &buf_x, &buf_y );
		ptr = get_word_at_pos( GTK_TEXT_VIEW(widget), buf_x, buf_y );
#else
		ptr = get_word_at_cursor( GTK_TEXT(widget));
#endif
		if ( check_clicked_text( ptr )) {
			return( TRUE );
		}
	}

	return FALSE;
}


void on_color_custom_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
	GtkWidget *tmp_widget;
	int set;

	tmp_widget = lookup_widget( setup_window, "color_custom" );
	set =  gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (tmp_widget ));

	tmp_widget = lookup_widget( setup_window, "colorselection" );
	if ( set ) {
		gtk_widget_set_sensitive( tmp_widget, 1 );
	} else {
		gtk_widget_set_sensitive( tmp_widget, 0 );
	}
}


void on_enable_chat_spam_filter_toggled(GtkToggleButton *togglebutton, gpointer  user_data)
{
	GtkWidget *tmp_widget;
	int set;

	set = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (togglebutton));
	tmp_widget = lookup_widget( setup_window,"ignore_guests");
	if (!tmp_widget) {return;}

	if ( set ) {
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (tmp_widget ), TRUE);
		gtk_widget_set_sensitive( tmp_widget, 0 );
	} else {
		gtk_widget_set_sensitive( tmp_widget, 1 );
	}
}


void on_reload_room_list_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkTreeIter iter;
	GtkTreeModel *model;
	gboolean valid;

	tmp_widget = lookup_widget( room_window, "room_tree" );
	model=gtk_tree_view_get_model(GTK_TREE_VIEW(tmp_widget));

	/* Added, PhrozenSmoke: To eliminate memory leaks created
	   by refreshing the room list, we needed to free all the ROOM_ENTRY
	   stuff that is malloced containing strdup'ed strings that is set 
	   as row data, free everything up before clearing the room tree...
	   Note: We don't need to apply this to the 'create a room' UI because
	   the room creation tree is re-used once created and is not 'refreshable'
	*/	

	valid = gtk_tree_model_get_iter_first(model, &iter);
	while(valid) {	
		ROOM_ENTRY *room_item;
		gtk_tree_model_get(model, &iter,GYROOM_DATA, &room_item, -1);
		if (room_item->room_name) {
			free(room_item->room_name);
			room_item->room_name=NULL;
		}
		if (room_item->room_id) {
			free(room_item->room_id);
			room_item->room_id=NULL;
		}
		if (room_item->temp_child) {
			gtk_tree_path_free(room_item->temp_child);
			room_item->temp_child=NULL;
		}
		valid =gtk_tree_model_iter_next(model, &iter);
	}

	gy_empty_model(model, GYTV_TYPE_TREE);

	tmp_widget = lookup_widget( room_window, "intlcombo" );
	if (tmp_widget) {
		set_room_list_country_code((char *)gyachi_combobox_get_selected_item(tmp_widget));
	}	
	populate_room_list(0);
}


gboolean on_pms_entry_key_press_event(GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	PM_SESSION *pm_sess;
	GYACHI_NOTEBOOK_INTERFACE *gy_notebook;
	int page;

	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(widget), "pms_entry" )) ) {
		if ( (event->keyval==GDK_Tab)  && (pm_sess->window_style==1)) {			
			return TRUE;  /* This stops the Tab char from being inserted */
		}

		if ( (event->keyval==GDK_Return)  && (pm_sess->window_style==1)) {
			set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
			pm_sess->typing = 0;
			if (! pm_sess->sms) {ymsg_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );}
			send_pm_session_text(pm_sess);	
			reset_current_pm_profile_name();	
			return TRUE;  /* This stops the return char from being inserted */
		}

		if ((event->keyval==GDK_BackSpace) ||
		    (event->keyval==GDK_Delete)    ||
		    (event->keyval==GDK_KP_Delete) ) {
			if (pm_sess->typing ) {
				set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
				pm_sess->typing = 0;
				if (! pm_sess->sms) {ymsg_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );}
				reset_current_pm_profile_name();
			}
			return FALSE;
		}

		if ( pm_sess->window_style==1) {
			int mylimit = txlimit;

			/* textbox */
			GtkWidget *pms_entry;
			pms_entry = lookup_widget( pm_sess->pm_window, "pms_entry" );
			if (pm_sess->sms) {mylimit=151;}
			if (gtk_text_buffer_get_char_count(GTK_TEXT_BUFFER(g_object_get_data(G_OBJECT(pms_entry), "textbuffer"))) > (mylimit-1) ) {
				/* Set the input text limit if we've exceeded it */
				return TRUE;
			}
		}

		/* check for control-page-up/down
		 * and allow that key combination to flip between the tabs
		 * a.la. gnome-terminal
		 */
		if ((event->keyval == GDK_Page_Up) && (event->state == 4)) {
			/* control page-up will go to tab on the left */
			gy_notebook=pm_sess->pm_notebook;
			page = gtk_notebook_get_current_page(GTK_NOTEBOOK(gy_notebook->notebook));
			if (page > 0) {
				gtk_notebook_set_current_page(GTK_NOTEBOOK(gy_notebook->notebook), page-1);
			}
			return FALSE;
		}

		if ((event->keyval == GDK_Page_Down) && (event->state == 4)) {
			/* control page-down will go to tab on the right */
			gy_notebook=pm_sess->pm_notebook;
			page = gtk_notebook_get_current_page(GTK_NOTEBOOK(gy_notebook->notebook));
			gtk_notebook_set_current_page(GTK_NOTEBOOK(gy_notebook->notebook), page+1);
			return FALSE;
		}

		/* Don't turn typing status on for special characters 
		   like the 'up' and 'down' arrows, 'insert', 'ALT', 'CTRL' key...etc.
		*/

		if (event->keyval > GDK_3270_Enter) {
			if (event->keyval < GDK_KP_Equal) {return FALSE;}
			if (event->keyval > GDK_KP_9) {return FALSE;}			
		}

		if ( ! pm_sess->typing ) {
			set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
			pm_sess->typing = 1;
			if (! pm_sess->sms) {ymsg_typing( ymsg_sess, pm_sess->pm_user, pm_sess->typing );}
			reset_current_pm_profile_name();
		}
	}

	return FALSE;
}


void on_find_button_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *tmp_widget;
	int case_sensitive;

	tmp_widget = lookup_widget( find_window, "search_text" );

	search_pos = -1;
	search_text = strdup( gtk_entry_get_text(GTK_ENTRY(tmp_widget)));

	tmp_widget = lookup_widget( find_window, "case_sensitive" );
	case_sensitive = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tmp_widget));

	search_chat_text( case_sensitive );
}


void on_clear_find_button_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( find_window, "search_text" );
	gtk_entry_set_text(GTK_ENTRY(tmp_widget), "");

	search_pos = -1;
	if ( search_text ) {
		free( search_text );
		search_text = NULL;
	}
}


void on_cancel_find_button_clicked(GtkButton *button, gpointer user_data)
{
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( find_window, "search_text" );
	gtk_entry_set_text(GTK_ENTRY(tmp_widget), "");

	gtk_widget_hide( find_window );
	search_pos = -1;
	if ( search_text ) {
		free( search_text );
		search_text = NULL;
	}
}


void on_find_next_button_clicked(GtkButton *button, gpointer user_data)
{
	search_chat_text( search_case_sensitive );
}


gboolean on_find_window_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	if ( find_window )
		gtk_widget_destroy( find_window );

	find_window = NULL;

	search_pos = -1;
	if ( search_text ) {
		free( search_text );
		search_text = NULL;
	}

	return( TRUE );
}


void on_search_text_activate(GtkEditable *editable, gpointer user_data)
{
	on_find_button_clicked( NULL, NULL );
}


void on_browser_clicked(GtkButton *button, gpointer user_data)
{
	char *browser = (char *)user_data;
	GtkWidget *tmp_widget;

	tmp_widget = lookup_widget( setup_window, "browser_command" );

	if ( ! strcmp( browser, "netscape" )) {
		gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"netscape -noraise -remote 'openURL(%s,GyachE)' &");
	} else if ( ! strcmp( browser, "mozilla" )) {
		gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"mozilla -remote 'openURL(%s,new-window)' &");
	} else if ( ! strcmp( browser, "opera" )) {
			 gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"opera -remote 'openURL(%s,new-page)' &");
	} else if ( ! strcmp( browser, "konquerer" )) {
		gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"kfmclient openURL '%s' &");
	} else {
		gtk_entry_set_text(GTK_ENTRY(tmp_widget),
			"netscape -noraise -remote 'openURL(%s)'  &");
	}
}

/* added: PhrozenSmoke, buddy list callbacks */

void display_buddy_grp_menu(GtkWidget *parent) {
	if (! budgrp_menu) {
		budgrp_menu=create_budgrp_popup_menu(parent);
	}
	gtk_menu_popup((GtkMenu *) budgrp_menu, NULL, NULL, NULL, NULL, 1, 0);
}

void display_buddy_list_popup_menu(GtkWidget *parent) {
	if ( ! selected_buddy ) {
		if ( selected_buddy_group ) {
			display_buddy_grp_menu(parent);
		}
		return;
	}
	if (!budpop_menu) {
		budpop_menu=create_budlist_popup_menu(parent);
	}
	gtk_widget_show_all(GTK_WIDGET(budpop_menu));
	/* right clicked popup action window */
	gtk_menu_popup((GtkMenu *) budpop_menu, NULL, NULL, NULL, NULL, 1, 0);
}

void on_display_buddy_list_popup_menu_kb(GtkWidget *widget, gpointer user_data)
{
	display_buddy_list_popup_menu(user_data);
}

void onBuddyListRowActivated(GtkTreeView *tv, GtkTreePath *tp, GtkTreeViewColumn *col, gpointer user_data)
{
	GtkTreeIter iter;
	gchar *sfound;
	char *gtemp=NULL;

	if (!tp) {return;}
	gtk_tree_model_get_iter(gtk_tree_view_get_model(tv), &iter, tp);

	if ( selected_buddy_group ) {
		free( selected_buddy_group );
		selected_buddy_group=NULL;
	}
	if ( selected_buddy ) {
		free( selected_buddy );  
		selected_buddy=NULL;
	}

	if (budgrp_menu) {gtk_menu_popdown((GtkMenu *) budgrp_menu);}
	if (budpop_menu) {gtk_menu_popdown((GtkMenu *) budpop_menu);}

	gtk_tree_model_get(gtk_tree_view_get_model(tv), &iter,GYDOUBLE_TOP, &sfound, -1);
	gtemp=strdup(sfound);		
	if (!strcmp(gtemp, "GYEBuddy_TopLvl")) {  /* buddy group selected */
		gchar *gfound;
		g_free(sfound);
		free(gtemp);
		gtk_tree_model_get(gtk_tree_view_get_model(tv), &iter,GYDOUBLE_COL1, &gfound, -1);	
		if (strcmp(gfound, TMP_FRIEND_CB)) {
			selected_buddy_group=strdup(gfound);
		}
		
		g_free(gfound);
		return;
	}
	else {  /* regular buddy selected */
		gchar *gfound;
		if (strcmp(gtemp, TMP_FRIEND_CB)) {
			selected_buddy_group=strdup(gtemp);
		}
		free(gtemp);
		g_free(sfound);
		gtk_tree_model_get(gtk_tree_view_get_model(tv), &iter,GYDOUBLE_COL1, &gfound, -1);	
		if (strcmp(gfound, TMP_FRIEND_CB)) {
			selected_buddy=strdup(gfound);
		}
		g_free(gfound);
	}

	if ( ! selected_buddy ) {return;}
	gtemp=strdup(selected_buddy); /* cater for another buddy click, while we're processing this one */
	if (  strcasecmp( gtemp, ymsg_sess->user ) && (! find_profile_name(gtemp))) {
		PM_SESSION *mypm_sess;

		if ( !(mypm_sess = find_pm_session( gtemp )) ) {
			/* open a new window if one doesn't exist already */
			mypm_sess=new_pm_session(gtemp);
		}

if ( capture_fp ) {
fprintf(capture_fp, "\n[%s] pm_notebook_select_tab --> CROSS ROAD INTERSECTION 6 <-- onBuddyListRowActivated()\n", gyach_timestamp());
fflush( capture_fp );
}

		gtk_widget_show_all(mypm_sess->pm_window );
		pm_notebook_select_tab(mypm_sess->pm_notebook, gtemp);
		gtk_window_present(GTK_WINDOW(mypm_sess->pm_notebook->window));
		focus_pm_entry(mypm_sess);
	}
	free(gtemp);
 }



gboolean on_select_a_buddy(GtkWidget *widget, GdkEventButton *event, gpointer user_data)
{
	GtkWidget *parent = user_data;

	/* Right mouse button clicks: Popup menu */
	if (event->button == 3 && event->type == GDK_BUTTON_PRESS) {
		if (selected_buddy) {
			display_buddy_list_popup_menu(parent);
			return FALSE;
		}
		if (selected_buddy_group) {
			display_buddy_grp_menu(parent);
			return FALSE;
		}
	}

	return FALSE;
}


#ifdef HAVE_GTK_WIDGET_TOOLTIP
void on_buddy_selection_changed_cb(GtkTreeSelection *selection, GtkWidget *tree_view)
{
	gtk_widget_trigger_tooltip_query(tree_view);
}

gboolean on_query_tooltip_buddy_tree_cb (GtkWidget  *widget,
					 gint        x,
					 gint        y,
					 gboolean    keyboard_tip,
					 GtkTooltip *tooltip,
					 gpointer    data) {
	char *(pieces[5]);
        char *t_filename;
	GdkPixbuf *imbuf=NULL;
	GtkTreeIter iter;
	GtkTreeView *tree_view = GTK_TREE_VIEW (widget);
	GtkTreeModel *model = gtk_tree_view_get_model (tree_view);
	GtkTreePath *path = NULL;
	GtkTreeViewColumn *column = NULL;
	gchar *tmp;
	char  *buddy_name;

	if (keyboard_tip) {
		/* keyboard action. i.e. mot mouse invocation */
		return(FALSE);
	}

	/* get model, and iter. From that we can easily get the LABEL
	 * (which holds the buddy name)
	 */
	if (!gtk_tree_view_get_tooltip_context(tree_view, &x, &y,
					       keyboard_tip,
					       &model, &path, &iter)) {
		/* no row at the x/y coordinates */
		gtk_tree_path_free(path);
		return(FALSE);
	}

	if (gtk_tree_path_get_depth(path) != 2) {
		/* not on a buddy row */
		gtk_tree_path_free(path);
		return(FALSE);
	}

	if (!gtk_tree_view_get_path_at_pos(tree_view,
					   x, y,
					   &path, &column, NULL, NULL)) {
	  	/* no row at the x/y coordinates */
		gtk_tree_path_free(path);
		return(FALSE);
	}

	if (strcmp(gtk_tree_view_column_get_title(column), "Buddy")) {
		/* not in the buddy column */
		gtk_tree_path_free(path);
		return(FALSE);
	}

	/* if here, we're on a buddy row, in the "Buddy" column (which includes
	 * the status icon, buddy/avatar pixmaps, and buddy name).
	 * Now ... if the buddy image's available, make a tooltip w/ the
	 * fullsized image...
	 */
	gtk_tree_model_get(model, &iter, GYDOUBLE_LABEL, &tmp, -1);
	buddy_name = tmp+1;

	imbuf = NULL;
        pieces[0]=GYACH_CFG_DIR;
        pieces[1]="/bimages/bimage-";
        pieces[2]=buddy_name;
        pieces[3]=".png";
        pieces[4]=NULL;
        t_filename=gyachi_filename(pieces);

	imbuf=gdk_pixbuf_new_from_file(t_filename, NULL);

	if (imbuf) {
		gtk_tooltip_set_icon(tooltip, imbuf);
		gtk_tree_view_set_tooltip_cell(tree_view, tooltip, path, column, NULL);
		g_object_unref(imbuf);
	}


	free(t_filename);
	gtk_tree_path_free(path);
	g_free(tmp);
	return(imbuf != NULL);
}
#endif

void on_buddy_pm_activate(GtkButton *bbutton, gpointer user_data)
{
	char *gtemp=NULL;
	if ( ! selected_buddy) { return; }	

	gtemp=strdup(selected_buddy); /* cater for another buddy click, while we're processing this one */
	if (  strcasecmp( gtemp, ymsg_sess->user ) && (! find_profile_name(gtemp))) {
		PM_SESSION *mypm_sess;

		if ( !(mypm_sess = find_pm_session( gtemp )) ) {
			/* open a new window if one doesn't exist already */
			mypm_sess=new_pm_session(gtemp);
		}

if ( capture_fp ) {
fprintf(capture_fp, "\n[%s] pm_notebook_select_tab --> CROSS ROAD INTERSECTION 7 <-- on_buddy_pm_activate()\n", gyach_timestamp());
fflush( capture_fp );
}

		gtk_widget_show_all(mypm_sess->pm_window );
		pm_notebook_select_tab(mypm_sess->pm_notebook, gtemp);
		gtk_window_present(GTK_WINDOW(mypm_sess->pm_notebook->window));

		/* old way */
		/* pm_window=blank_pm_window(gtemp); */
	}
	free(gtemp);
}


void  on_buddy_profile_activate(GtkButton *bbutton, gpointer user_data)
{
	char *buffer;

	if ( ! selected_buddy ) { return ; }

	buffer = malloc(strlen(selected_buddy) + 10);
	strcpy(buffer, "/profile ");
	strcat(buffer, selected_buddy);
	chat_command(buffer, 0);					
	free(buffer);
 }



void  on_buddy_buzz(GtkButton *button, gpointer  user_data)
{
	char *buffer;

	if ( ! selected_buddy) {return;  }

	if (  strcasecmp( selected_buddy, ymsg_sess->user ) && (! find_profile_name(selected_buddy))) {
		buffer = malloc(strlen(selected_buddy) + 14);
		strcpy(buffer, "/tell ");
		strcat(buffer, selected_buddy);
		strcat(buffer, " <ding>");
		chat_command(buffer, 0);
		free(buffer);
	}
}


void on_buddy_invite_to_chat(GtkButton *button, gpointer user_data)
{
	GtkWidget *parent = user_data;

	if ( ! selected_buddy) {
		return;
	}

	if (  strcasecmp( selected_buddy, ymsg_sess->user ) && (! find_profile_name(selected_buddy))) {
		if (is_conference) {
			use_multpm_settings=0;
			use_chat_settings=0;
			open_make_conference_window_with_name(parent, selected_buddy);
			return;
		}
		if (in_a_chat) {
			use_chat_settings=1;
			use_multpm_settings=0;
			open_make_conference_window_with_name(parent, selected_buddy);
			return;
		}
	}
}


/* PhrozenSmoke:  more Buddy list callbacks */
void on_add_this_buddy(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tmp_entry;
	char newbuddy[65]="";
	char *nbuddy=newbuddy;
	gchar *etext=NULL;
	int i;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "mywindow" );
	tmp_entry = g_object_get_data(G_OBJECT(widget), "myentry" );
	if (tmp_entry) {
		etext=g_strdup(gtk_entry_get_text(GTK_ENTRY(tmp_entry)));
		for (i=0; i<strlen(etext); i++) {
			if (etext[i] != ' ') {newbuddy[i]=etext[i]; }
		}
	}

	if ( ! find_friend( nbuddy )) {
		add_friend(chat_window, nbuddy);
	}

	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
	if (etext) {g_free(etext);}
}

void on_click_add_a_buddy(GtkButton *widget, gpointer user_data)
{
	GtkWidget *okbutton;

	/* added to GETTEXT here */
	okbutton=show_input_dialog(chat_window, "Buddy","Add Buddy","Cancel");
	g_signal_connect(G_OBJECT(okbutton), "clicked",
                      G_CALLBACK (on_add_this_buddy), NULL);

	if (selected_buddy) {
		GtkWidget *tmp_entry;
		if (find_profile_name(selected_buddy)) {return;}
		if (!strcasecmp(selected_buddy, ymsg_sess->user)) {return;}
		if (! find_temporary_friend(selected_buddy)) {return; }
		tmp_entry = g_object_get_data(G_OBJECT(okbutton), "myentry" );
		if (tmp_entry) {gtk_entry_set_text(GTK_ENTRY(tmp_entry), selected_buddy); }
	}
}


void on_click_remove_buddy(GtkButton *widget, gpointer user_data)
{
	GtkWidget *parent = user_data;

	create_yremove_window(parent);
}


/* from budlist popup */
/* from file icon on buddy list tab */
void on_send_buddy_file(GtkButton *widget, gpointer user_data)
{
	GtkWidget *parent = user_data;

	if ( ! selected_buddy) {return;}
	if (find_profile_name(selected_buddy)) {return;}
	if (!strcasecmp(selected_buddy, ymsg_sess->user )) {return;}
	if (user_for_file) {free(user_for_file); }
	user_for_file=strdup(selected_buddy);

	select_file_to_send(parent, NULL, strdup(selected_buddy));
}

/* from Actions menu */
void on_send_file_to_user_cb(GtkWidget *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tentry;
	char newbuddy[65]="";
	char *nbuddy=newbuddy;
	GtkWidget *parent = user_data;
	gchar *etext=NULL;
	int i;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "window" );
	tentry = g_object_get_data(G_OBJECT(widget), "entry" );
	if (tentry) {
		etext=g_strdup(gyachi_combobox_get_selected_item(tentry));
		for (i=0; i<strlen(etext); i++) {
			if (etext[i] != ' ') {newbuddy[i]=etext[i]; }
		}
	}

	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
	if (strlen(nbuddy) >0) {
		if (user_for_file) {free(user_for_file); }
		user_for_file=strdup(nbuddy);
		select_file_to_send(parent, NULL, strdup(nbuddy));
	}
	if (etext) {g_free(etext);}

}


/* from Actions menu */
void on_send_file_to_user(GtkMenuItem *widget, gpointer user_data)
{
	GtkWidget *parent = user_data;
	GtkWidget *okbutton;
	GList *sorted_friend_list;
	char  *default_friend;

	/* added to GETTEXT here */
	sorted_friend_list = get_sorted_friend_list(&default_friend, 0);
	default_friend = default_friend ? default_friend : (sorted_friend_list ? g_list_first(sorted_friend_list)->data : "");
	okbutton=create_list_dialog(parent, _("User"), _("User:"), default_friend, sorted_friend_list, TRUE, GYACHI_PM_JOIN);
	g_list_free(sorted_friend_list);
	g_signal_connect(G_OBJECT(okbutton), "clicked",
                      G_CALLBACK (on_send_file_to_user_cb), parent);
}

void on_show_offline_buddies_click (GtkCheckMenuItem *menuitem, gpointer user_data)
{
	gboolean value;

	value = gtk_check_menu_item_get_active(menuitem);
	show_offline_buddies = value;
	if (show_offline_buddies) {
		show_offline_in_online    = 0;
		dont_show_offline_buddies = 0;
		write_config();
		refresh_buddy_clist();
	}
}

void on_show_offline_in_online_buddies_click (GtkCheckMenuItem *menuitem, gpointer user_data)
{
	gboolean value;

	value = gtk_check_menu_item_get_active(menuitem);
	show_offline_in_online = value;
	if (show_offline_in_online) {
		show_offline_buddies      = 0;
		dont_show_offline_buddies = 0;
		write_config();
		refresh_buddy_clist();
	}

}

void on_dont_show_offline_buddies_click (GtkCheckMenuItem *menuitem, gpointer user_data)
{
	gboolean value;

	value = gtk_check_menu_item_get_active(menuitem);
	dont_show_offline_buddies = value;
	if (dont_show_offline_buddies) {
		show_offline_buddies   = 0;
		show_offline_in_online = 0;
		write_config();
		refresh_buddy_clist();
	}

}

void on_show_empty_groups_click(GtkCheckMenuItem *menuitem, gpointer user_data)
{
	gboolean value;

	value = gtk_check_menu_item_get_active(menuitem);
	show_empty_groups = value;
	write_config();
	refresh_buddy_clist();
}

void on_expand_all_groups_click(GtkCheckMenuItem *menuitem, gpointer user_data)
{
	gboolean value;

	value = gtk_check_menu_item_get_active(menuitem);
	expand_all_groups = value;
	if (expand_all_groups) {
		expand_only_online_groups = 0;
		expand_no_groups = 0;
		write_config();
		refresh_buddy_clist();
	}
}

void on_expand_only_online_groups_click(GtkCheckMenuItem *menuitem, gpointer user_data)
{
	gboolean value;

	value = gtk_check_menu_item_get_active(menuitem);
	expand_only_online_groups = value;
	if (expand_only_online_groups) {
		expand_all_groups = 0;
		expand_no_groups = 0;
		refresh_buddy_clist();
	}
}

void on_expand_no_groups_click(GtkCheckMenuItem *menuitem, gpointer user_data)
{
	gboolean value;

	value = gtk_check_menu_item_get_active(menuitem);
	expand_no_groups = value;
	if (expand_no_groups) {
		expand_all_groups = 0;
		expand_only_online_groups = 0;
		refresh_buddy_clist();
	}
}


/* the send file icon on the PM window */
void on_pms_sendfile_clicked(GtkButton *button, gpointer user_data)
{
	PM_SESSION *pm_sess;
	GtkWidget *parent = user_data;
	
	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(button), "send_user" )) ) {
		if (user_for_file) {free(user_for_file); }
		user_for_file=strdup( pm_sess->pm_user );
		select_file_to_send(parent, NULL, strdup(pm_sess->pm_user));
	}
}


/* added: PhrozenSmoke, put 'Find...' window on menu */
void on_find_menu_clicked(GtkMenuItem *mitem, gpointer user_data)
{
	jump_to_chat_tab();

	search_pos = -1;
	if ( ! find_window ) {
		if ( search_text ) {
			free( search_text );
			search_text = NULL;
		}
		find_window = create_find_window();
	} 
	gtk_widget_show_all( find_window );
}


int on_buddy_profile_activate_timeout2(guint data)
{
	char *buffer;

	if ( ! user_for_file ) { return FALSE; }

	buffer = malloc(strlen(user_for_file) + 10);
	strcpy(buffer, "/profile ");
	strcat(buffer, user_for_file);
	chat_command(buffer, 0);
	free(buffer);

	if (user_for_file) {
		free(user_for_file);
		user_for_file=NULL;
	}
	return FALSE;
}


void on_open_profile_cb(GtkWidget *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tentry;
	char newbuddy[65]="";
	char *nbuddy=newbuddy;
	gchar *etext=NULL;
	int i;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "window" );
	tentry = g_object_get_data(G_OBJECT(widget), "entry" );
	if (tentry) {
		etext=g_strdup(gyachi_combobox_get_selected_item(tentry));
		for (i=0; i<strlen(etext); i++) {
			if (etext[i] != ' ') {
				newbuddy[i]=etext[i];
			}
		}
	}

	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
	if (strlen(nbuddy) >0) {
		if (user_for_file) {
			free(user_for_file);
		}
		user_for_file=strdup( nbuddy);
		g_timeout_add( 10 , (void *)on_buddy_profile_activate_timeout2, NULL );
	}
	if (etext) {
		g_free(etext);
	}

}

GList *get_sorted_friend_list(char **default_friend, int pms) {
	GList *sorted_friend_list;
	GtkWidget *tmp_widget=NULL;
	int page = 1;

	tmp_widget=g_object_get_data(G_OBJECT(chat_window),"gynotebook");
	if (tmp_widget) {	
		page = gtk_notebook_get_current_page(GTK_NOTEBOOK(tmp_widget));
	}

	if ((page == 0) && (pms == 0)) {
		sorted_friend_list = g_list_sort(g_list_copy(user_list), (GCompareFunc)gstrcmp);
		*default_friend = user_selected;
	}
	else {
		sorted_friend_list = g_list_sort(g_list_copy(friend_list), (GCompareFunc)gstrcmp);
		*default_friend = selected_buddy;
	}

	return(sorted_friend_list);
}


void on_open_profile_clicked(GtkMenuItem *widget, gpointer user_data)
{
	GtkWidget *parent = user_data;
	GtkWidget *okbutton;
	GList *sorted_friend_list;
	char  *default_friend;

	/* added to GETTEXT here */
	sorted_friend_list = get_sorted_friend_list(&default_friend, 0);
	default_friend = default_friend ? default_friend : (sorted_friend_list ? g_list_first(sorted_friend_list)->data : "");
	okbutton=create_list_dialog(parent, _("User"), _("User:"), default_friend, sorted_friend_list, TRUE, GYACHI_PM_JOIN);
	g_list_free(sorted_friend_list);
	g_signal_connect(G_OBJECT(okbutton), "clicked",
                      G_CALLBACK (on_open_profile_cb), NULL);
}


/* added, PhrozenSmoke - Conference callbacks */
void on_start_conference(GtkMenuItem *widget, gpointer user_data)
{
	GtkWidget *parent = user_data;

	use_chat_settings=0;
	chat_command("/conf_start", parent);
}


void on_invite_to_conf(GtkMenuItem *widget, gpointer user_data)
{
	GtkWidget *parent = user_data;

	if (is_conference) {use_chat_settings=0;}
	if (in_a_chat) {use_chat_settings=1; }

	if (is_conference || in_a_chat) {
		chat_command("/conf_start", parent);
	}
}


void  on_conf_accept_cb(GtkButton *button, gpointer  user_data)
{
	GtkWidget *tmp_widget;
	char *enteras=NULL;
	enteras=g_object_get_data(G_OBJECT(button),PROFNAMESTR );
	if (enteras) {
		set_current_chat_profile_name(enteras);
		free(enteras); enteras=NULL;
	}
	tmp_widget =g_object_get_data(G_OBJECT(button), "mywindow" );
	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
	accept_invite();
}

void  on_conf_decline_cb(GtkButton *button, gpointer  user_data)
{
	GtkWidget *tmp_widget;
	char *enteras=NULL;
	enteras=g_object_get_data(G_OBJECT(button),PROFNAMESTR );
	if (enteras) {
		set_current_chat_profile_name(enteras);
		free(enteras); enteras=NULL;
	}
	tmp_widget =g_object_get_data(G_OBJECT(button), "mywindow" );
	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
	decline_invite(NULL);
}


void  on_accept_voice_conf(GtkButton *button, gpointer user_data)
{
	GtkWidget *tmp_widget;
	char *pmroom=NULL;
	char *cookie=NULL;

	tmp_widget =g_object_get_data(G_OBJECT(button), "mywindow" );
	pmroom =g_object_get_data(G_OBJECT(button), "pmroom" );
	cookie =g_object_get_data(G_OBJECT(button), "cookie" );
	if (pmroom && cookie) {
		char *currusr=g_object_get_data(G_OBJECT(button),PROFNAMESTR);
		set_current_pm_profile_name( currusr?currusr:ymsg_sess->user );
		set_voice_conference_cookie(cookie);
		voice_launch_conference(1, currusr?currusr:ymsg_sess->user , pmroom, 0);
		free(pmroom);
		free(cookie);
		if (currusr) {
			free(currusr);
		}
	}
	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
}

void  on_activate_voice_conf(GtkButton *button, gpointer user_data)
{
	GtkWidget *tmp_widget;
	PM_SESSION *pm_sess;

	tmp_widget =g_object_get_data(G_OBJECT(button), "mywindow" );
	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(button), "voice_chat" )) ) {
		char *currusr=retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR)));
		snprintf(callbackbuf, 70, "%s-%d%d%c%d%d", currusr, 9, 4, pm_sess->pm_user[0], 3,
			currusr[0]);
		set_current_pm_profile_name( currusr );
		/* voice_launch_conference(1, currusr ,proom); */ 
		ymsg_voice_invite(ymsg_sess, pm_sess->pm_user, callbackbuf );

		snprintf( callbackbuf, 255 ,  "%s%s   ** '%s' %s **%s%s\n",
						YAHOO_COLOR_BLUE, YAHOO_STYLE_BOLDON, 
						currusr, 
						_("has enabled voice chat."), 
						YAHOO_COLOR_BLACK, YAHOO_STYLE_BOLDOFF );

		 append_to_textbox_color( pm_sess->pm_window, pm_sess->pm_text, callbackbuf );
		 focus_pm_entry(pm_sess);
		 reset_current_pm_profile_name();
	}
	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
}


void on_activate_voice_chat(GtkMenuItem *widget, gpointer user_data)
{
	if (!ymsg_sess->room) {return;}
	if (!ymsg_sess->user) {return;}
	if ( is_conference) {  
		sprintf(callbackbuf,"%s","");

		strcat(callbackbuf,"\n");
		strcat(callbackbuf,YAHOO_STYLE_BOLDON);
		strcat(callbackbuf,YAHOO_COLOR_PURPLE);
		strncat(callbackbuf,_("Voice Chat"), 60);
		strcat(callbackbuf,":  ");
		strcat(callbackbuf,YAHOO_COLOR_GREEN);
		strncat(callbackbuf, _("Enabled"), 60);
		strcat(callbackbuf,YAHOO_COLOR_BLACK);
		strcat(callbackbuf,YAHOO_STYLE_BOLDON);
		strcat(callbackbuf,"\n");
		append_to_textbox_color( chat_window, NULL, callbackbuf );

		voice_launch_conference(1, get_chat_profile_name(), ymsg_sess->room, 1);
	}
	else {
		voice_launch(1, 1);
	}
}


void  on_reject_buddy_add(GtkButton *button, gpointer user_data)
{
	GtkWidget *tmp_widget;
	char *mbuddy=NULL;
	tmp_widget =g_object_get_data(G_OBJECT(button), "mywindow" );
	mbuddy =g_object_get_data(G_OBJECT(button), "buddy" );
	if (mbuddy) {
		ymsg_reject_buddy( ymsg_sess, mbuddy);

		if ( chat_timestamp) {
			append_timestamp(chat_window, NULL);
			append_to_textbox( chat_window, NULL, " " );
		}

		snprintf(callbackbuf, 300 , "%s%s** %s '%s' **%s%s\n",
			 YAHOO_STYLE_ITALICON, YAHOO_COLOR_RED,
			 _("Denied buddy list privileges for"), mbuddy,
			 YAHOO_STYLE_ITALICOFF, YAHOO_COLOR_BLACK);
		append_to_textbox( chat_window, NULL, callbackbuf );
		free(mbuddy);
	}
	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
}

/* added PhrozenSmoke */
void on_refresh_activate(GtkMenuItem *menuitem, gpointer user_data)
{
	reset_all_online_friends_statuses( );
	refresh_buddy_clist();
	ymsg_refresh(ymsg_sess);
}

void  on_room_invite_accept_cb(GtkButton *button, gpointer  user_data)
{
	GtkWidget *tmp_widget;
	char *chatroom=NULL;
	char *buffer;

	tmp_widget =g_object_get_data(G_OBJECT(button), "mywindow" );
	chatroom =g_object_get_data(G_OBJECT(button), "chatroom" );
	if (chatroom) {
		char *enteras=NULL;
		enteras=g_object_get_data(G_OBJECT(button),PROFNAMESTR );
		if (enteras) {
			set_current_chat_profile_name(enteras);
			free(enteras);
			enteras=NULL;
		}
		buffer = malloc(strlen(chatroom)+7);
		strcpy(buffer, "/join ");
		strcat(buffer, chatroom);
		chat_command(buffer, 0);
		free(buffer);
		free(chatroom);
	}
	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
}



void on_report_abuse(GtkMenuItem *widget, gpointer user_data)
{
	snprintf( callbackbuf, 350, "%s", "http://add.yahoo.com/fast/help/chat/cgi_abuse" );
	display_url( (void *) strdup(callbackbuf) );
}

void on_yahoo_games(GtkMenuItem *widget, gpointer user_data)
{
	snprintf( callbackbuf, 350, "%s",  "http://games.yahoo.com");
	display_url( (void *) strdup(callbackbuf) );
}

void on_yahoo_news_alert(GtkMenuItem *widget, gpointer user_data)
{
	snprintf( callbackbuf, 350, "%s", "http://alerts.yahoo.com");
	display_url( (void *) strdup(callbackbuf) );
}

void on_yahoo_mail_act(GtkMenuItem *widget, gpointer user_data)
{
	chat_command("/mail", 0 );
}

void on_leave_room_or_conf(GtkMenuItem *widget, gpointer user_data)
{
	chat_command("/leave", 0);
}


void on_make_custom_away_cb(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tmp_entry;
	GtkWidget *busy_icon;
	GtkWidget *idle_icon;
	char *etext=NULL;

	force_busy_icon=0;
	force_idle_icon=0;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "mywindow" );
	tmp_entry = g_object_get_data(G_OBJECT(widget), "myentry" );
	busy_icon = g_object_get_data(G_OBJECT(widget), "busy_icon" );
	idle_icon = g_object_get_data(G_OBJECT(widget), "idle_icon" );

	custom_away_icon=0;
	if  (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(busy_icon))) {
		force_busy_icon=1;
		custom_away_icon=1;
	}

	if  (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(idle_icon))) {
		force_idle_icon=1;
		custom_away_icon=2;
	}

	if (tmp_entry) {
		etext=strdup(gtk_entry_get_text(GTK_ENTRY(tmp_entry)));
	}

	if (tmp_widget) {
		gtk_widget_destroy(tmp_widget);
	}

	if (strlen(etext) > 0) {
		if (custom_away_message) {
			free(custom_away_message);
		}
		custom_away_message = etext;
		etext = NULL;
		cmd_away(custom_away_message);
	}
	if (etext) {
		free(etext);
	}
	write_config();
}

void on_make_custom_away(GtkMenuItem *menuitem, gpointer  user_data)
{
	GtkWidget *okbutton;
	GtkWidget *dhextra;
	GSList    *staticon_group = NULL;
	GtkWidget *norm_icon;
	GtkWidget *busy_icon;
	GtkWidget *idle_icon;
	GtkWidget *tmpentry;		

	/* added to GETTEXT here */
	okbutton=show_input_dialog(chat_window, _("Away message"), "OK" ,"Cancel");
	g_signal_connect(G_OBJECT(okbutton), "clicked",
                      G_CALLBACK (on_make_custom_away_cb), NULL);
  	dhextra=g_object_get_data(G_OBJECT(okbutton), "dhextra");

	tmpentry=g_object_get_data(G_OBJECT(okbutton), "myentry");

	switch (messy_ver) {
	case YMSG_VER_11:
		break;

	case YMSG_VER_13:
	case YMSG_VER_15:
	case YMSG_VER_16:
		if (tmpentry) {
			gtk_entry_set_max_length(GTK_ENTRY(tmpentry),254);
		}
		break;
	}

	if (custom_away_message && (strlen(custom_away_message))) {
		if (tmpentry) {
			gtk_entry_set_text(GTK_ENTRY(tmpentry),custom_away_message);
		}
	}

	norm_icon = gtk_radio_button_new_with_mnemonic (NULL, _("Normal icon"));	
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (norm_icon), staticon_group);
	staticon_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (norm_icon));
	gyachi_set_tooltip(norm_icon,_("Here"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(norm_icon), TRUE);

	busy_icon = gtk_radio_button_new_with_mnemonic (NULL, _("Busy icon"));
	gyachi_set_tooltip(busy_icon,_("Busy"));	
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (busy_icon), staticon_group);
	staticon_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (busy_icon));

	idle_icon = gtk_radio_button_new_with_mnemonic (NULL, _("Idle icon"));	
	gyachi_set_tooltip(idle_icon,_("Idle"));	
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (idle_icon), staticon_group);
	staticon_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (idle_icon));

	if (custom_away_icon == 1) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(busy_icon), TRUE);
	if (custom_away_icon == 2) gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(idle_icon), TRUE);

	gtk_box_pack_start (GTK_BOX (dhextra), norm_icon, TRUE, TRUE, 2);
	gtk_box_pack_start (GTK_BOX (dhextra), gtk_label_new("    "), FALSE, FALSE, 2);
	gtk_box_pack_start (GTK_BOX (dhextra), busy_icon, TRUE, TRUE, 2);
	gtk_box_pack_start (GTK_BOX (dhextra), idle_icon, TRUE, TRUE, 2);
	g_object_set_data(G_OBJECT(okbutton), "busy_icon", busy_icon);
	g_object_set_data(G_OBJECT(okbutton), "idle_icon", idle_icon);
	gtk_widget_show_all(dhextra);
}



void on_view_briefcase_cb(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tmp_entry;
	char newsite[65]="";
	char *nsite=newsite;
	gchar *etext=NULL;
	int i;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "mywindow" );
	tmp_entry = g_object_get_data(G_OBJECT(widget), "myentry" );
	if (tmp_entry) {
		etext=g_strdup(gtk_entry_get_text(GTK_ENTRY(tmp_entry)));
		for (i=0; i<strlen(etext); i++) {
			if (etext[i] != ' ') {newsite[i]=etext[i]; }
		}
	}

	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}

	if (strlen(nsite)>0) {
		snprintf( callbackbuf, 350, "http://briefcase.yahoo.com/bc/%s", nsite);
		display_url( (void *) strdup(callbackbuf) );
	}

	if (etext) {g_free(etext);}
}


void on_view_briefcase(GtkMenuItem *menuitem, gpointer  user_data)
{
	GtkWidget *okbutton;

	/* added to GETTEXT here */
	okbutton=show_input_dialog(chat_window, _("User"), "OK" ,"Cancel");
	g_signal_connect(G_OBJECT(okbutton), "clicked",
                      G_CALLBACK (on_view_briefcase_cb), NULL);
	if (selected_buddy) {
		GtkWidget *tmp_entry;
		tmp_entry = g_object_get_data(G_OBJECT(okbutton), "myentry" );
		gtk_entry_set_text(GTK_ENTRY(tmp_entry), selected_buddy);
	}
}


void on_rejoin_room(GtkMenuItem *menuitem, gpointer  user_data)
{
	chat_command("/rejoin", 0);
}



void on_send_contact_info_cb(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tentry;
	char newsite[65]="";
	char *nsite=newsite;
	gchar *etext=NULL;
	int i;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "window" );
	tentry = g_object_get_data(G_OBJECT(widget), "entry" );
	if (tentry) {
		etext=g_strdup(gyachi_combobox_get_selected_item(tentry));
		for (i=0; i<strlen(etext); i++) {
			if (etext[i] != ' ') {newsite[i]=etext[i]; }
		}
	}

	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}

	if (strlen(nsite)>0) {
		snprintf(callbackbuf, 150, "/business-card %s", nsite);
		chat_command(callbackbuf, 0);
	}

	if (etext) {g_free(etext);}
}


void on_send_contact_info(GtkMenuItem *menuitem, gpointer  user_data)
{
	GtkWidget *parent = user_data;
	GtkWidget *okbutton;
	GList *sorted_friend_list;
	char  *default_friend;

	/* added to GETTEXT here */
	sorted_friend_list = get_sorted_friend_list(&default_friend, 0);
	default_friend = default_friend ? default_friend : "";
	okbutton=create_list_dialog(parent, _("User"), _("User:"), default_friend, sorted_friend_list, TRUE, GYACHI_PM_JOIN);
	g_list_free(sorted_friend_list);
	g_signal_connect(G_OBJECT(okbutton), "clicked",
                      G_CALLBACK (on_send_contact_info_cb), NULL);
}


void on_buddy_add_accept_cb(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	char *nbuddy;

	nbuddy=g_object_get_data(G_OBJECT(widget), "buddy");
	if (nbuddy) {
		if ( ! find_friend( nbuddy )) {
			add_friend(chat_window, nbuddy);
		}
		free(nbuddy);
	}
	tmp_widget =g_object_get_data(G_OBJECT(widget), "mywindow" );
	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
}

void on_buddy_add_accept(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	char *nbuddy;

	nbuddy=g_object_get_data(G_OBJECT(widget), "buddy");
	if (nbuddy) {
		ymsg_accept_buddy(ymsg_sess, nbuddy);
		if (!find_friend(nbuddy)) {
			GtkWidget *okbutton;
			okbutton=show_confirm_dialog(_("Would you like to add this user to your buddy list?"),"YES","NO");
			if (!okbutton) {return;}
			g_signal_connect(G_OBJECT(okbutton), "clicked",
					    G_CALLBACK (on_buddy_add_accept_cb), NULL);
			g_object_set_data(G_OBJECT(okbutton), "buddy", strdup(nbuddy));
		}
		free(nbuddy);
	}
	tmp_widget =g_object_get_data(G_OBJECT(widget), "mywindow" );
	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
}



/* webcam stuff */
void on_viewcam_cb(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tentry;
	char newsite[65]="";
	char *nsite=newsite;
	gchar *etext=NULL;
	char *buffer;
	int i;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "window" );
	tentry = g_object_get_data(G_OBJECT(widget), "entry" );
	if (tentry) {
		etext=g_strdup(gyachi_combobox_get_selected_item(tentry));
		for (i=0; i<strlen(etext); i++) {
			if (etext[i] != ' ') {newsite[i]=etext[i]; }
		}
	}

	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}

	if (strlen(nsite)>0) {
		if (strcasecmp(nsite, ymsg_sess->user )) {
			buffer=malloc(strlen(nsite)+10);
			strcpy(buffer, "/viewcam ");
			strcat(buffer, nsite);
			chat_command(buffer, 0);
			free(buffer);
		}
	}
	if (etext) {g_free(etext);}
}


void on_viewcam_worker(GtkMenuItem *menuitem, gpointer  user_data, int pms)
{
	GtkWidget *parent = user_data;
	GtkWidget *okbutton;
	GList *sorted_friend_list;
	char  *default_friend;

	/* added to GETTEXT here */
	sorted_friend_list = get_sorted_friend_list(&default_friend, pms);
	default_friend = default_friend ? default_friend : (sorted_friend_list ? g_list_first(sorted_friend_list)->data : "");
	okbutton=create_list_dialog(parent, _("User"), _("User:"), default_friend, sorted_friend_list, TRUE, GYACHI_PM_JOIN);
	g_list_free(sorted_friend_list);
	g_signal_connect(G_OBJECT(okbutton), "clicked",
			    G_CALLBACK ( on_viewcam_cb),
			    0);
}

void on_viewcam(GtkMenuItem *menuitem, gpointer  user_data)
{
	on_viewcam_worker(menuitem, user_data, 0);
}

void on_viewcam_room(GtkMenuItem *menuitem, gpointer user_data)
{
	if (user_list == 0) {
		return; /* no user list */	
	}

	on_viewcam_worker(menuitem, user_data, 0);
}

void on_startmycam(GtkMenuItem *widget, gpointer user_data)
{
	yahoo_webcam_get_feed(get_default_profile_name());
}


void on_sendcaminvite_cb(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tentry;
	char newsite[65]="";
	char *nsite=newsite;
	gchar *etext=NULL;
	int i;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "window" );
	tentry = g_object_get_data(G_OBJECT(widget), "entry" );
	if (tentry) {
		etext=g_strdup(gyachi_combobox_get_selected_item(tentry));
		for (i=0; i<strlen(etext); i++) {
			if (etext[i] != ' ') {newsite[i]=etext[i]; }
		}
	}

	if (tmp_widget) {gtk_widget_destroy( tmp_widget );}
	if (strlen(nsite)>0) {
		if (strcasecmp(nsite, ymsg_sess->user )) {
			ymsg_webcam_invite( ymsg_sess, nsite); 
		}
	}
	if (etext) {g_free(etext);}
}

void on_sendcaminvite_worker(GtkMenuItem *menuitem, gpointer  user_data, int pms)
{
	GtkWidget *parent = user_data;
	GtkWidget *okbutton;
	GList *sorted_friend_list;
	char  *default_friend;

	sorted_friend_list = get_sorted_friend_list(&default_friend, pms);
	default_friend = default_friend ? default_friend : (sorted_friend_list ? g_list_first(sorted_friend_list)->data : "");
	okbutton=create_list_dialog(parent, _("User"), _("User:"), default_friend, sorted_friend_list, TRUE, GYACHI_PM_JOIN);
	g_list_free(sorted_friend_list);
	g_signal_connect(G_OBJECT(okbutton), "clicked",
			    G_CALLBACK (on_sendcaminvite_cb), NULL);
}

void on_sendcaminvite(GtkMenuItem *menuitem, gpointer  user_data)
{
	on_sendcaminvite_worker(menuitem, user_data, 0);
}

void on_sendcaminvite_room(GtkMenuItem *menuitem, gpointer  user_data)
{
	GtkWidget *parent = user_data;
	GtkWidget *okbutton;
	GList *sorted_friend_list;
	char  *default_friend;

	if (user_list == 0) {
		return; /* no user list */	
	}

	sorted_friend_list = get_sorted_friend_list(&default_friend, 0);
	default_friend = default_friend ? default_friend : (sorted_friend_list ? g_list_first(sorted_friend_list)->data : "");
	okbutton=create_list_dialog(parent, _("User"), _("User:"), default_friend, sorted_friend_list, TRUE, GYACHI_PM_JOIN);
	g_list_free(sorted_friend_list);
	g_signal_connect(G_OBJECT(okbutton), "clicked",
			    G_CALLBACK (on_sendcaminvite_cb), NULL);
}

void on_enable_webcam_feature_clicked(GtkToggleButton *button, gpointer user_data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(user_data), gtk_toggle_button_get_active(button));
}

void on_show_cam_is_on_clicked(GtkToggleButton  *button, gpointer user_data)
{
	gtk_widget_set_sensitive(GTK_WIDGET(user_data), gtk_toggle_button_get_active(button));
}


void on_display_plugin_info(GtkMenuItem *menuitem, gpointer  user_data)
{
	GtkWidget *tmp_widget=NULL;
	int chat_tab;

	print_loaded_plugin_info(display_message);
	tmp_widget=g_object_get_data(G_OBJECT(chat_window),"gynotebook");
	if (tmp_widget) {
		chat_tab = find_tab_posn(CHAT_TAB);
		gtk_notebook_set_current_page(GTK_NOTEBOOK(tmp_widget), chat_tab);
	}
	gdk_window_raise(chat_window->window );
}


void collect_buddy_list_selected(GtkTreeSelection *selection, gpointer data)
{
	GtkTreeModel *model;
	GtkTreeIter iter;

	if ( gtk_tree_selection_get_selected(selection, &model, &iter)) {
		gchar *sfound;
		char *gtemp=NULL;

		if ( selected_buddy_group ) {
			free( selected_buddy_group );
			selected_buddy_group=NULL;
		}
		if ( selected_buddy ) {
			free( selected_buddy );  
			selected_buddy=NULL;
		}

		if (budgrp_menu) {gtk_menu_popdown((GtkMenu *) budgrp_menu);}
		if (budpop_menu) {gtk_menu_popdown((GtkMenu *) budpop_menu);}

		gtk_tree_model_get(model, &iter,GYDOUBLE_TOP, &sfound, -1);	
		gtemp=strdup(sfound);
		if (!strcmp(gtemp, "GYEBuddy_TopLvl")) {  /* buddy group selected */
			gchar *gfound;
			g_free(sfound);
			free(gtemp);
			gtk_tree_model_get(model, &iter,GYDOUBLE_COL1, &gfound, -1);	
			if (strcmp(gfound,TMP_FRIEND_CB)) {
				selected_buddy_group=strdup(gfound);
			}
			g_free(gfound);
			return;
		}
		else {  /* regular buddy selected */
			gchar *gfound;
			if (strcmp(gtemp, TMP_FRIEND_CB)) {
				selected_buddy_group=strdup(gtemp);
			}
			free(gtemp);
			g_free(sfound);
			gtk_tree_model_get(model, &iter,GYDOUBLE_COL1, &gfound, -1);	
			if (strcmp(gfound, TMP_FRIEND_CB)) {
				selected_buddy=strdup(gfound);
			}
			g_free(gfound);
			return;
		}
	}
}


void on_buddy_list_rename_cb(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tmp_entry;
	gchar *etext=NULL;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "mywindow" );
	tmp_entry = g_object_get_data(G_OBJECT(widget), "myentry" );
	if (tmp_entry) {
		etext=g_strdup(gtk_entry_get_text(GTK_ENTRY(tmp_entry)));
	}
	ymsg_group_rename( ymsg_sess, etext );
	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
	if (etext) {g_free(etext);}
}

void on_buddy_list_rename(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *parent = user_data;
	GtkWidget *okbutton, *tmpentry;

	if ( ! selected_buddy_group ) {return;}
	if (strcmp(selected_buddy_group, TMP_FRIEND_CB)==0) {
		show_ok_dialog(_("You cannot rename or delete the selected buddy group."));
		return;
	}
	if (strcmp(selected_buddy_group, "Y! Mobile Messenger")==0) {
		show_ok_dialog(_("You cannot rename or delete the selected buddy group."));
		return;
	}
	/* added to GETTEXT here */
	okbutton=show_input_dialog(parent, "Group","Rename","Cancel");

	tmpentry=g_object_get_data(G_OBJECT(okbutton), "myentry");
	if (tmpentry) {
		gtk_entry_set_text(GTK_ENTRY(tmpentry),selected_buddy_group);
	}

	g_signal_connect(G_OBJECT(okbutton), "clicked",
                      G_CALLBACK (on_buddy_list_rename_cb), NULL);
}

void on_move_buddy_to_group_cb(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tentry;
	gchar *etext=NULL;
	char *selbud=NULL;

	if (!selected_buddy) {return;}
	if (!selected_buddy_group) {return;}
	if (strcmp(selected_buddy_group, TMP_FRIEND_CB)==0) {return;}

	tmp_widget = g_object_get_data(G_OBJECT(widget), "window" );
	tentry = g_object_get_data(G_OBJECT(widget), "entry");
	if (tentry) {
		etext=g_strdup(gyachi_combobox_get_selected_item(tentry));
	}
	if (strcmp(etext, selected_buddy_group)) {
		switch (messy_ver) {
		case YMSG_VER_11:
			/* older versions of yahoo, we remove the buddy from the
			 * old group, and add them to the new group
			 */
			selbud=strdup(selected_buddy);
			/* Remove buddy from old group */
			ymsg_remove_buddy(ymsg_sess, selbud);

			/* Re-add buddy to new group */
			if (selected_buddy_group) {
				free(selected_buddy_group);
			}
			selected_buddy_group=strdup(etext);
			ymsg_add_buddy(ymsg_sess, selbud);
			break;

		case YMSG_VER_13:
		case YMSG_VER_15:
		case YMSG_VER_16:
			/* newer versions of yahoo, there is a "change group"
			 * to change the group of a user.
			 * We need the buddy id, the old group, and the new group
			 *
			 * selected_buddy_group -- old group
			 * etext                -- new group
			 * selected_buddy       -- buddy id
			 *
			 */
			ymsg_change_group(ymsg_sess, selected_buddy, selected_buddy_group, etext);
			break;
		}
	}

	if (tmp_widget) {
		gtk_widget_destroy( tmp_widget );
	}
	if (selbud) {free(selbud);}
	if (etext)  {g_free(etext);}
}

void on_move_buddy_to_group(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *parent = user_data;
	GtkWidget *okbutton;

	if (!selected_buddy) {return;}
	if (!selected_buddy_group) {return;}
	if (strcmp(selected_buddy_group, TMP_FRIEND_CB)==0) {return;}
	okbutton=create_list_dialog(parent, _("Group"), _("Group:"), selected_buddy_group, get_buddy_group_list(), TRUE, GYACHI_PM_JOIN);
	g_signal_connect(G_OBJECT(okbutton), "clicked",
			    G_CALLBACK ( on_move_buddy_to_group_cb),
			    NULL);
}

void on_open_multi_pms(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *parent = user_data;

	use_multpm_settings=1;
	use_chat_settings=0;
	open_make_conference_window(parent);
}


void on_gameprofile_cb(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tentry;
	char newsite[65]="";
	char *nsite=newsite;
	gchar *etext=NULL;
	int i;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "window" );
	tentry = g_object_get_data(G_OBJECT(widget), "entry" );
	if (tentry) {
		etext=g_strdup(gyachi_combobox_get_selected_item(tentry));
		for (i=0; i<strlen(etext); i++) {
			if (etext[i] != ' ') {newsite[i]=etext[i]; }
		}
	}

	if (tmp_widget) {gtk_widget_destroy( tmp_widget );}
	if (strlen(nsite)>0) {
		GtkWidget *tmp_widget=NULL;
		int yahoo_tab;

		tmp_widget=g_object_get_data(G_OBJECT(chat_window),"gynotebook");
		snprintf(callbackbuf, 256, "http://profiles.games.yahoo.com/games/profile2?name=%s", nsite);
		load_myyahoo_URL(callbackbuf);
		if (tmp_widget) {
			yahoo_tab = find_tab_posn(YAHOO_TAB);
			gtk_notebook_set_current_page(GTK_NOTEBOOK(tmp_widget), yahoo_tab);
		}
		gdk_window_raise(chat_window->window );
	}
	if (etext) {g_free(etext);}
}

void on_gameprofile(GtkMenuItem *menuitem, gpointer  user_data)
{
	GtkWidget *parent = user_data;
	GtkWidget *okbutton;
	GList *sorted_friend_list;
	char  *default_friend;

	sorted_friend_list = get_sorted_friend_list(&default_friend, 0);
	default_friend = default_friend ? default_friend : (sorted_friend_list ? g_list_first(sorted_friend_list)->data : "");
	okbutton=create_list_dialog(parent, _("User"), _("User:"), default_friend, sorted_friend_list, TRUE, GYACHI_PM_JOIN);
	g_list_free(sorted_friend_list);
	g_signal_connect(G_OBJECT(okbutton), "clicked",
                      G_CALLBACK (on_gameprofile_cb), NULL);
}

void view_full_sized_avatar(char *who, char *avatar, int animation) {

	switch (messy_ver) {
	case YMSG_VER_11:
		return;

	case YMSG_VER_13:
	case YMSG_VER_15:
	case YMSG_VER_16:
		break;
	}

	if (!avatar ) {return;}	

	if (animation) {
		snprintf( callbackbuf, 400, "%s \"http://img.avatars.yahoo.com/users/%s.full.swf\" &", flash_player_cmd?flash_player_cmd:"gflashplayer", avatar );
		my_system(callbackbuf);
	}
	else {		
		char *tmppage=NULL;
		GtkWidget *tmp_widget=NULL;
		int yahoo_tab;

		if (!who ) {return;}
		tmppage=malloc(1184);
		if (!tmppage) {return;}
		tmp_widget=g_object_get_data(G_OBJECT(chat_window),"gynotebook");
		snprintf(tmppage, 1182, "<br><center><img  src=\"http://img.avatars.yahoo.com/users/%s.large.%s\"><br>%s</center><br> <br><center><a href=\"http://img.avatars.yahoo.com/users/%s.large.png\">http://img.avatars.yahoo.com/users/%s.large.png</a><br><a href=\"http://img.avatars.yahoo.com/users/%s.medium.png\">http://img.avatars.yahoo.com/users/%s.medium.png</a><br><a href=\"http://img.avatars.yahoo.com/users/%s.small.png\">http://img.avatars.yahoo.com/users/%s.small.png</a><br><a href=\"http://img.avatars.yahoo.com/users/%s.full.swf\">http://img.avatars.yahoo.com/users/%s.full.swf</a><br>", avatar,avatar_filetype, who, avatar, avatar, avatar, avatar,avatar, avatar,avatar, avatar);
		set_myyahoo_html_data(tmppage);
		free(tmppage);
		if (tmp_widget) {
			yahoo_tab = find_tab_posn(YAHOO_TAB);
			gtk_notebook_set_current_page(GTK_NOTEBOOK(tmp_widget), yahoo_tab);
		}
		gdk_window_raise(chat_window->window );
	}
}


void on_viewavatar(GtkMenuItem *menuitem, gpointer  user_data)
{

	switch (messy_ver) {
	case YMSG_VER_11:
		return;

	case YMSG_VER_13:
	case YMSG_VER_15:
	case YMSG_VER_16:
		break;
	}

	if (!selected_buddy) {return; }
	else {
		struct yahoo_friend *FROBJECT = NULL;
		FROBJECT=yahoo_friend_find(selected_buddy);
		if (FROBJECT) {
			if (FROBJECT->avatar) {
				if (user_data) {
					view_full_sized_avatar(selected_buddy, FROBJECT->avatar, 1); 
				}
				else {
					view_full_sized_avatar(selected_buddy, FROBJECT->avatar, 0);
				}
			}
			else {
				show_ok_dialog(_("The user has no avatar."));
			}
		}
		else {
			show_ok_dialog(_("The user has no avatar."));
		}
	}
}


void on_viewgameroom(GtkMenuItem *menuitem, gpointer  user_data)
{
	if (!selected_buddy) {return; }
	else {
		struct yahoo_friend *FROBJECT = NULL;
		FROBJECT=yahoo_friend_find(selected_buddy);
		if (FROBJECT) {
			if (FROBJECT->game_url) {
				if (strlen(FROBJECT->game_url)>1) {
					snprintf( callbackbuf, 400, "%s", FROBJECT->game_url );
					display_url( (void *) strdup(callbackbuf) );
				}
				else {
					show_ok_dialog(_("The user is not in a game room."));
				}
			}
			else {
				show_ok_dialog(_("The user is not in a game room."));
			}
		}
		else {
			show_ok_dialog(_("The user is not in a game room."));
		}
	}
}


void on_viewbuddyinfo(GtkMenuItem *menuitem, gpointer  user_data)
{
	GtkWidget *parent = user_data;

	if (!selected_buddy) {return; }
	else {
		struct yahoo_friend *FROBJECT = NULL;
		FROBJECT=yahoo_friend_find(selected_buddy);
		if (FROBJECT) {
			char *b_info_buf=NULL;
			b_info_buf=malloc(5120);
			if (! b_info_buf) {return;}

			snprintf(callbackbuf,85, "</font>\n[~G1y_eBreak~]<font face=\"sans\" size=\"14\">%s", YAHOO_COLOR_PMBLUE);

			snprintf( b_info_buf, 500, "<font face=\"Arial\" size=\"16\">%s[ %s ]\n%s\"%s\" ", YAHOO_COLOR_PMPURPLE, selected_buddy, YAHOO_COLOR_PMBLUE,  FROBJECT->main_stat?FROBJECT->main_stat:""  );

			if (FROBJECT->away) {
				strcat(b_info_buf," (");
				strncat(b_info_buf,_("Away"), 15);
				strcat(b_info_buf,") ");
			}		
			if (FROBJECT->idle) {
				strcat(b_info_buf," (");
				strncat(b_info_buf,_("Idle"), 15);
				strcat(b_info_buf,") ");
			}	
			strcat(b_info_buf,callbackbuf);

			if (FROBJECT->inchat) {
				strncat(b_info_buf,_("Chat"), 15);
				strcat(b_info_buf,callbackbuf);
			}
			if (FROBJECT->ingames) {
				strncat(b_info_buf,_("Games"), 15);
				strcat(b_info_buf,callbackbuf);
			}
			if (FROBJECT->webcam) {
				strncat(b_info_buf,_("Webcam"), 20);
				strcat(b_info_buf,callbackbuf);
			}
			if (FROBJECT->insms) {
				strncat(b_info_buf,_("SMS (Cell Phone)"), 25);
				strcat(b_info_buf,callbackbuf);
			}
			if (FROBJECT->launchcast) {
				strncat(b_info_buf,"LaunchCAST", 12);
				if (FROBJECT->radio_stat) {
					if (strlen(FROBJECT->radio_stat)>1) {
						strncat(b_info_buf,": ", 3);
						strncat(b_info_buf,FROBJECT->radio_stat, 45);
					}
				}
				strcat(b_info_buf,callbackbuf);
			}

			if (FROBJECT->avatar) {
				if (strlen(FROBJECT->avatar)>1) {
						strncat(b_info_buf,"Avatar", 7);
						strcat(b_info_buf,callbackbuf);
				}
			}

			strncat(b_info_buf, _("Identities"), 25);
			strcat(b_info_buf,": ");
			strncat(b_info_buf, get_buddy_identities_list(selected_buddy) , 288);
			strcat(b_info_buf,callbackbuf);
			strcat(b_info_buf,"\n</font>");

			if (prof_text) {g_free(prof_text); prof_text=NULL;}
			prof_text = g_strdup( _utf(b_info_buf) );
			free(b_info_buf);
			if (prof_pic) {
				free(prof_pic);
				prof_pic=NULL;
			}
			if (FROBJECT->avatar) {
				if (download_yavatar(FROBJECT->avatar, 1 , NULL)) {
					char *(pieces[6]);

					pieces[0]=GYACH_CFG_DIR;
					pieces[1]="/yavatars/";
					pieces[2]=FROBJECT->avatar;
					pieces[3]=".medium.";
					pieces[4]=avatar_filetype;
					pieces[5]=NULL;
					prof_pic=gyachi_filename(pieces);
					/* printf("filename: %s\n", prof_pic); fflush(stdout); */ 				}
			}
			if ( profile_window ) {
				gtk_widget_destroy( profile_window );
				profile_window = NULL;
			}
			display_profile(parent);
			if (profile_window) {
				gtk_window_set_title (GTK_WINDOW (profile_window), selected_buddy);
			}
		}
	}
}




void on_open_stealth_window(GtkMenuItem *menuitem, gpointer  user_data)
{
	GtkWidget *parent = user_data;

	switch (messy_ver) {
	case YMSG_VER_11:
		return;

	case YMSG_VER_13:
	case YMSG_VER_15:
	case YMSG_VER_16:
		break;
	}

	if (!selected_buddy) {return; }

	else {
		GtkWidget *swin, *offline, *online, *permoff;
		struct yahoo_friend *FROBJECT = NULL;
		FROBJECT=yahoo_friend_find(selected_buddy);
		if (stealth_sel_buddy) {free(stealth_sel_buddy);}
		stealth_sel_buddy=strdup(selected_buddy);
		if (FROBJECT) {
			swin=create_stealth_window(parent, selected_buddy);
			offline=g_object_get_data(G_OBJECT(swin), "offline");
			online=g_object_get_data(G_OBJECT(swin), "online");
			permoff=g_object_get_data(G_OBJECT(swin), "permoff");
			if (my_status != 12) { /* visible */
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (online), TRUE);
				gtk_widget_set_sensitive(offline, FALSE);
				if (FROBJECT->stealth==3) {
					gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (permoff), TRUE);
				}
			}
			else { /* invisible */
				gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (offline), TRUE);
				if (FROBJECT->stealth==3) {
					gtk_widget_set_sensitive(offline, FALSE);
					gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (permoff), TRUE);
				}
				if (FROBJECT->stealth==1) {
					gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (online), TRUE);
				}
			}
			gtk_widget_show_all(swin);
		}
	}
}

void on_activate_stealth_window(GtkButton *widget, gpointer  user_data)
{
	GtkWidget *swin=NULL;
	GtkWidget *offline, *online, *permoff;
	struct yahoo_friend *FROBJECT = NULL;		
	swin=g_object_get_data(G_OBJECT(widget), "mywindow");
	if (!stealth_sel_buddy) {if (swin) {gtk_widget_destroy(swin);} return; }
	FROBJECT=yahoo_friend_find(stealth_sel_buddy);
	if (!FROBJECT) {if (swin) {gtk_widget_destroy(swin);} return; }

	offline=g_object_get_data(G_OBJECT(swin), "offline");
	online=g_object_get_data(G_OBJECT(swin), "online");
	permoff=g_object_get_data(G_OBJECT(swin), "permoff");

	if (my_status != 12) { /* visible */
		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (permoff))) {
			if (FROBJECT->stealth<3) {
				ymsg_stealth(ymsg_sess, stealth_sel_buddy, 0);
				ymsg_stealth_perm(ymsg_sess, stealth_sel_buddy, 0);
			}
		}
		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (online))) {
			if (FROBJECT->stealth==3) {
				ymsg_stealth_perm(ymsg_sess, stealth_sel_buddy, 1);
				ymsg_stealth(ymsg_sess, stealth_sel_buddy, 1);
			}
		}
	} else { /* invisible */
		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (permoff))) {
			if (FROBJECT->stealth<3) {
				ymsg_stealth(ymsg_sess, stealth_sel_buddy, 0);
				ymsg_stealth_perm(ymsg_sess, stealth_sel_buddy, 0);
			}
		}
		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (online))) {
				if (FROBJECT->stealth==3) {ymsg_stealth_perm(ymsg_sess,stealth_sel_buddy,1);}
				ymsg_stealth(ymsg_sess, stealth_sel_buddy, 1);
		}
		if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (offline))) {
				ymsg_stealth(ymsg_sess, stealth_sel_buddy, 0);
		}

	}

	if (swin) {gtk_widget_destroy(swin);}
}

void on_send_audible_cb(GtkWidget *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	PM_SESSION *pm_sess;
	char *smiley_t=NULL;
	char *myalias=NULL;
	char *aud_text=NULL;
	char *aud_hash=NULL;
	char *aud_file=NULL;

	tmp_widget=g_object_get_data(G_OBJECT(widget),"mywindow");
	pm_sess=g_object_get_data(G_OBJECT(widget),"pms_sess");
	smiley_t=g_object_get_data(G_OBJECT(widget),"smiley_tag");

	if (pm_sess && smiley_t) {
		focus_pm_entry(pm_sess);
		if ( ! check_gy_audible(smiley_t) ) {
			if (tmp_widget) {gtk_widget_destroy(tmp_widget);}
			return;
		}

		aud_text=get_gy_audible_text(smiley_t);
		aud_hash=get_gy_audible_hash(smiley_t);
		aud_file=get_gy_audible_disk_name( smiley_t );

		if ( (! aud_text) || (! aud_hash) || (! aud_file) ) {
			if (tmp_widget) {gtk_widget_destroy(tmp_widget);}
			if (aud_file) {free(aud_file);}
			if (aud_text) {free(aud_text);}
			if (aud_hash) {free(aud_hash);}
			return;
		}
		set_current_pm_profile_name(retrieve_profname_str(GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));

		ymsg_audible(ymsg_sess, pm_sess->pm_user, smiley_t, aud_text, aud_hash);

		if ( chat_timestamp_pm ) {
			append_timestamp(pm_sess->pm_window,pm_sess->pm_text);
		}
		if (pm_nick_names) {myalias=get_screenname_alias(get_current_pm_profile_name());}

		snprintf( callbackbuf, 256, "%s%s%s%s%s  ",
			YAHOO_COLOR_PMBLUE, YAHOO_STYLE_BOLDON, 
			myalias?myalias:get_current_pm_profile_name(),
			YAHOO_COLOR_BLACK, YAHOO_STYLE_BOLDOFF );
		append_to_textbox_color( pm_sess->pm_window, pm_sess->pm_text, callbackbuf );
		
		snprintf(callbackbuf,350,"%s/audibles/%s.gif", PACKAGE_DATA_DIR, aud_file);
		ct_append_pixmap(callbackbuf, pm_sess->pm_text);

		snprintf( callbackbuf, 500, " %s . o O ( %s ) %s\n",
			"\033[#A7708Cm", aud_text,YAHOO_COLOR_BLACK  );
		append_to_textbox_color( pm_sess->pm_window, pm_sess->pm_text, callbackbuf );

		/* Play mp3 here */
		play_audible(smiley_t);

		if (myalias) {g_free(myalias); myalias=NULL;}
		if (aud_text) {free(aud_text);}
		if (aud_hash) {free(aud_hash);}
		if (aud_file) {free(aud_file);}
		reset_current_pm_profile_name();

		if ((my_status == 11) ||
		    ((my_status) && (my_status != 12) && (pm_brings_back))) {
			cmd_away( "0" );
		}

		pm_notebook_set_typing_status(pm_sess, SENT_TEXT);

		auto_away_time = time(NULL) + ( auto_away * 60 );
	}

	if (tmp_widget) {gtk_widget_destroy(tmp_widget);}
}


void on_open_audible_window(GtkWidget *button, gpointer user_data)
{
	PM_SESSION *pm_sess;

	switch (messy_ver) {
	case YMSG_VER_11:
		return;

	case YMSG_VER_13:
	case YMSG_VER_15:
	case YMSG_VER_16:
		break;
	}

	if (! enable_audibles) {return;}

	if ( (pm_sess=find_pm_session_from_widget( GTK_WIDGET(button), "pm_aud" )) ) {
		show_audibles_window(pm_sess);
	}
}


void revoke_buddy(gchar *buddy)
{
	char *buffer;

	buffer = malloc(strlen(buddy)+9);
	strcpy(buffer, "/revoke ");
	strcat(buffer, buddy);
	chat_command(buffer, 0);
	free(buffer);
}


void on_activate_yremove(GtkWidget *button, gpointer user_data)
{
	GtkWidget *yremovewin;
	GtkWidget *tcombo;
	GtkWidget *remove_buddy, *remove_me, *yahoo_ignore, *gyachi_ignore;
	gchar     *buddy=NULL;
	int was_tmp_friend=0;

	tcombo     = g_object_get_data(G_OBJECT(button), "tcombo");
	yremovewin = g_object_get_data(G_OBJECT(button), "mywindow");
	if (tcombo) {
		buddy=g_strdup(gyachi_combobox_get_selected_item(tcombo));
	}

	/* make sure we're not trying to remove ourself, or one of our profiles! */
	if (buddy && strlen(buddy)>0) {
		remove_buddy  = g_object_get_data(G_OBJECT(button), "remove_buddy");
		remove_me     = g_object_get_data(G_OBJECT(button), "remove_me");
		yahoo_ignore  = g_object_get_data(G_OBJECT(button), "yahoo_ignore");
		gyachi_ignore = g_object_get_data(G_OBJECT(button), "gyachi_ignore");

		/* remove buddy from my buddy list */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(remove_buddy))) {
			if (find_temporary_friend( buddy) ) {
				remove_temporary_friend(buddy);
				was_tmp_friend=1;
			}

			/* Patches a segfault that was caused by calling 'revoke' after remove */
			if (! was_tmp_friend) {
				if (find_friend( buddy )) {
					if ( using_web_login || ycht_is_running() ) {
						show_ok_dialog(_("This feature is not available when connected using the WEBCONNECT or YCHT servers."));
						return;
					}
					else {
						remove_friend(buddy, TRUE);
					}
				}
			}
		}

		/* remove me from buddy's list */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(remove_me))) {
			revoke_buddy(buddy);
		}

		/* don't put *us* on the yahoo or gyachi Ignore List! */
		if (strcasecmp(buddy, ymsg_sess->user) && !find_profile_name(buddy)) {
			/* add buddy to Yahoo!'s Ignore list */
			/* WARNING -- below code copied from ignore.c! */
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(yahoo_ignore))) {
				if ( using_web_login || ycht_is_running() ) {
					show_ok_dialog(_("This feature is not available when connected using the WEBCONNECT or YCHT servers."));
					return;
				}
				start_check_perm_igg_add_timeout(strdup(buddy));
				ymsg_perm_ignore(ymsg_sess,buddy, 0); 
			}

			/* add buddy to GyachI's Ignore list */
			/* WARNING -- below code copied from ignore.c! */
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gyachi_ignore))) {
				if (! ignore_check(buddy)) {
					ignore_toggle(buddy);
				}
				update_perm_igg_clist(4); /* UGH. a literal... */
			}
		}
	}

	if (buddy) {g_free(buddy);}
	if (yremovewin) {gtk_widget_destroy(yremovewin);}
}


void on_activate_yprivacy(GtkWidget *button, gpointer user_data)
{
	GtkWidget *swin;
	GtkWidget *gameson, *gameshs, *yonline;
	int doit=0;
	char fetchit[64]="";

	swin=g_object_get_data(G_OBJECT(button), "mywindow");
	gameson=g_object_get_data(G_OBJECT(button), "gameson");
	gameshs=g_object_get_data(G_OBJECT(button), "gameshs");
	yonline=g_object_get_data(G_OBJECT(button), "yonline");


	if (gameson) {
		doit=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gameson));
		snprintf(callbackbuf, 100,
			 "http://insider.msg.yahoo.com/ycontent/?setgp=0&enabled=%s", 
			doit?"1":"0");
		fetch_url( callbackbuf,  fetchit, 62, NULL, ymsg_sess->cookie );
	}
	if (gameshs) {
		doit=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(gameshs));
		snprintf(callbackbuf, 100,
			 "http://mtab.games.yahoo.com/messenger/prefs?action=set&show_hs=%s", 
			doit?"1":"0");
		fetch_url( callbackbuf,  fetchit, 62, NULL, ymsg_sess->cookie );
	}
	if (yonline) {
		doit=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(yonline));
		snprintf(callbackbuf, 100,
			 "http://edit.profiles.yahoo.com/config/edit_identity?.opi=%s&.set=1", 
			doit?"0":"1");
		fetch_url(callbackbuf,  fetchit, 62, NULL, ymsg_sess->cookie );
	}
	
	if (swin) {gtk_widget_destroy(swin);}
}

void on_open_yprivacy_window(GtkMenuItem *menuitem, gpointer  user_data)
{
	GtkWidget *parent = user_data;

	create_yprivacy_window(parent);
}

void on_remove_me_clicked(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tentry;
	gchar *etext=NULL;

	tentry = g_object_get_data(G_OBJECT(widget), "entry" );
	if (tentry) {
		etext=g_strdup(gyachi_combobox_get_selected_item(tentry));
	}
	if (etext && strlen(etext)>0) {
		revoke_buddy(etext);
		gyachi_combobox_select_item(tentry, "");
	}
	if (etext) {g_free(etext);}
}

void on_perm_offline_input_clicked(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tentry;
	gchar *etext=NULL;

	switch (messy_ver) {
	case YMSG_VER_11:
		return;

	case YMSG_VER_13:
	case YMSG_VER_15:
	case YMSG_VER_16:
		break;
	}

	tentry = g_object_get_data(G_OBJECT(widget), "entry" );
	if (tentry) {
		etext=g_strdup(gyachi_combobox_get_selected_item(tentry));
	}
	if (etext && strlen(etext)>0) {
		if (user_data) {  /* bring online */
			ymsg_stealth_perm(ymsg_sess, etext, 1);
			ymsg_stealth(ymsg_sess, etext, 1);
		} else {  /* send offline */
			ymsg_stealth(ymsg_sess, etext, 0);
			ymsg_stealth_perm(ymsg_sess, etext, 0);
		}
		gyachi_combobox_select_item(tentry, "");
	}
	if (etext) {g_free(etext);}
}


void update_my_buddy_image(PM_SESSION *pm_sess, int is_me) {
	GdkPixbuf *imbuf=NULL;
	int scaleto;
	char *t_filename;
	char *(pieces[5]);


	if (!show_bimages) {return;}
	if (!pm_sess->buddy_image_visible) {return;}

	if (pm_sess->buddy_image_size > 2) {pm_sess->buddy_image_size=2;}
	if (pm_sess->buddy_image_size < 0) {pm_sess->buddy_image_size=0;}
	scaleto=100;
	if (pm_sess->buddy_image_size==0) {scaleto=54;}
	if (pm_sess->buddy_image_size==2) {scaleto=142;}

	if (is_me) { 		
		if (!pm_sess->bimage_me) {return;}
		if ( (! bimage_file) || (! pm_sess->buddy_image_share) ) {
			gtk_image_set_from_stock(GTK_IMAGE(pm_sess->bimage_me), GTK_STOCK_NEW, GTK_ICON_SIZE_DND);
			gtk_widget_show_all(pm_sess->bimage_me);
			return;
		}

		/* can we use bimage_file here ? */
		pieces[0]=GYACH_CFG_DIR;
		pieces[1]="/";
		pieces[2]=ymsg_sess->user;
		pieces[3]=".friend_icon.png";
		pieces[4]=NULL;
		t_filename=gyachi_filename(pieces);
		imbuf=gdk_pixbuf_new_from_file_at_size(t_filename, scaleto, scaleto, NULL);
		free(t_filename);
	}
	else {
		struct yahoo_friend *FRIEND_OBJECT;

		if (!pm_sess->bimage_them) {return;}

		FRIEND_OBJECT=yahoo_friend_find(pm_sess->pm_user);
		if (FRIEND_OBJECT) {
			if (FRIEND_OBJECT->buddy_image_file) {
				imbuf=gdk_pixbuf_new_from_file_at_size(FRIEND_OBJECT->buddy_image_file, scaleto, scaleto, NULL);
			}
		}
	}

	if (!imbuf) {return;}

	gtk_image_set_from_pixbuf(GTK_IMAGE(is_me?pm_sess->bimage_me:pm_sess->bimage_them), imbuf);
	gtk_widget_show_all(is_me?pm_sess->bimage_me:pm_sess->bimage_them);

	g_object_unref(imbuf);
}
	
void on_bimage_share(GtkMenuItem *widget, gpointer user_data)
{
	PM_SESSION *pm_sess;
	GtkWidget *my_widget=(GtkWidget *) user_data;

	if (! user_data) {return;}	
	if (!show_bimages) {return;}
	if ( (pm_sess = find_pm_session_from_widget( my_widget, "pms_entry" )) ) {
		pm_sess->buddy_image_share=bimage_share;
		update_my_buddy_image(pm_sess, 1);
		set_current_pm_profile_name(retrieve_profname_str(
				  GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
		ymsg_bimage_toggle(ymsg_sess, pm_sess->pm_user, pm_sess->buddy_image_share);
		reset_current_pm_profile_name();
	}
}

void on_bimage_share_off(GtkMenuItem *widget, gpointer user_data)
{
	PM_SESSION *pm_sess;
	GtkWidget *my_widget=(GtkWidget *) user_data;

	if (! user_data) {return;}	
	if (!show_bimages) {return;}
	if ( (pm_sess = find_pm_session_from_widget( my_widget, "pms_entry" )) ) {
		pm_sess->buddy_image_share=0;
		update_my_buddy_image(pm_sess, 1);
		set_current_pm_profile_name(retrieve_profname_str(
				  GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
		ymsg_bimage_toggle(ymsg_sess, pm_sess->pm_user, pm_sess->buddy_image_share);
		reset_current_pm_profile_name();
	}
}


void on_bimage_update_size(GtkMenuItem *widget, gpointer user_data, int bimsize)
{
	PM_SESSION *pm_sess;
	GtkWidget *my_widget=(GtkWidget *) user_data;

	if (! user_data) {return;}
	if ( (pm_sess = find_pm_session_from_widget( my_widget, "pms_entry" )) ) {
		pm_sess->buddy_image_size=bimsize;
		update_my_buddy_image(pm_sess, 1);
		update_my_buddy_image(pm_sess, 0);
	}
}

void on_bimage_update_size1(GtkMenuItem *widget, gpointer user_data)
{
	on_bimage_update_size(widget, user_data, 0);
}
void on_bimage_update_size2(GtkMenuItem *widget, gpointer user_data)
{
	on_bimage_update_size(widget, user_data, 1);
}
void on_bimage_update_size3(GtkMenuItem *widget, gpointer user_data)
{
	on_bimage_update_size(widget, user_data, 2);
}

void fix_icon(gpointer user_data)
{
	GYACHI_NOTEBOOK_INTERFACE *gy_notebook;

	gy_notebook = g_object_get_data(G_OBJECT(user_data), "gy_notebook");
	if (gy_notebook) {
		pm_notebook_set_title(gy_notebook);
	}
}

void on_bimage_show_cb(GtkMenuItem *widget, gpointer user_data)
{
	if (! user_data) {return;}
	g_object_steal_data(G_OBJECT(user_data), "hide");
	gtk_widget_show_all((GtkWidget *) user_data);

	if (show_bicon) {
		fix_icon(user_data);
	}
}
void on_bimage_hide_cb(GtkMenuItem *widget, gpointer user_data)
{
	if (! user_data) {return;}
	g_object_set_data(G_OBJECT(user_data), "hide", user_data);
	gtk_widget_hide((GtkWidget *) user_data);

	if (show_bicon) {
		fix_icon(user_data);
	}
}

void on_bimage_view_my_avatar_cb(GtkMenuItem *menuitem, gpointer  user_data)
{
	switch (messy_ver) {
	case YMSG_VER_11:
		return;

	case YMSG_VER_13:
	case YMSG_VER_15:
	case YMSG_VER_16:
		break;
	}

	if (!my_avatar) {
		show_ok_dialog("You have no avatar.");
		return;
	}
	if (user_data) {
		view_full_sized_avatar(ymsg_sess->user, my_avatar, 1); 
	} else {
		view_full_sized_avatar(ymsg_sess->user, my_avatar, 0); 
	}
}


void on_bimage_view_avatar(GtkMenuItem *menuitem, gpointer  user_data)
{
	struct yahoo_friend *FROBJECT = NULL;
	PM_SESSION *pm_sess;
	GtkWidget *my_widget=(GtkWidget *)user_data;

	if (! user_data) {return;}
	if ( (pm_sess = find_pm_session_from_widget( my_widget, "pms_entry" )) ) {
		FROBJECT=yahoo_friend_find(pm_sess->pm_user);
		if (FROBJECT) {
			if (FROBJECT->avatar) {
				view_full_sized_avatar(pm_sess->pm_user, FROBJECT->avatar, 0); 
			}
			else {
				show_ok_dialog(_("The user has no avatar."));
			}
		}
		else {
			show_ok_dialog(_("This feature is only available for friends."));
		}
	}
}

void on_bimage_view_animation(GtkMenuItem *menuitem, gpointer  user_data)
{
	struct yahoo_friend *FROBJECT = NULL;
	PM_SESSION *pm_sess;
	GtkWidget *my_widget=(GtkWidget *)user_data;

	if (! user_data) {return;}
	if ( (pm_sess = find_pm_session_from_widget( my_widget, "pms_entry" )) ) {
		FROBJECT=yahoo_friend_find(pm_sess->pm_user);
		if (FROBJECT) {
			if (FROBJECT->avatar) {
				view_full_sized_avatar(pm_sess->pm_user, FROBJECT->avatar, 1); 
			}
			else {
				show_ok_dialog_p(pm_sess->pm_notebook->window, _("The user has no avatar."));
			}
		}
		else {
			show_ok_dialog_p(pm_sess->pm_notebook->window, _("This feature is only available for friends."));
		}
	}
}


void on_bimage_edit_my_photo(GtkButton *widget, gpointer user_data)
{
	GtkWidget *imwidg=NULL;
	GtkWidget *parent = user_data;

	switch (messy_ver) {
	case YMSG_VER_11:
		return;

	case YMSG_VER_13:
	case YMSG_VER_15:
	case YMSG_VER_16:
		break;
	}

	imwidg=create_bimage_select_window(parent);

	if (widget != NULL) {
	 	GtkWidget *textfocus=NULL;
		textfocus=g_object_get_data(G_OBJECT(widget),"textfocus" );
		if (textfocus != NULL) {
			GtkWidget *touched=NULL;	
			g_object_set_data(G_OBJECT(imwidg),"textfocus", textfocus);
			touched=g_object_get_data(G_OBJECT(imwidg),"okbutton");
			if (touched) {g_object_set_data(G_OBJECT(touched),"textfocus", textfocus);}
			touched=g_object_get_data(G_OBJECT(imwidg),"cancel_button");
			if (touched) {g_object_set_data(G_OBJECT(touched),"textfocus", textfocus);}
		}
	}
}


void on_select_buddy_image(GtkButton *widget, gpointer user_data)
{
	GtkWidget  *parent = user_data;
	char       *filename;
	const char *b_filename;
	const char *file_ptr;
	GdkPixbufFormat *fileinfo = NULL;
	int         height=0;
	int         width=0;
	int         scaleto = 96;
	GdkPixbuf  *imbuf=NULL;

	b_filename = gtk_entry_get_text(GTK_ENTRY(bimdiag_entry1));
	if (!b_filename || strlen(b_filename) == 0) {
		file_ptr = bimage_file;
	}
	else {
		file_ptr = b_filename;
	}
	filename=gyachi_file_browser(parent, file_ptr, OPEN);

	if (filename) {
		fileinfo = gdk_pixbuf_get_file_info(filename, &width, &height);
	}

	/* ignore file if
	 *  1) file format is not recognized, or
	 *  2) file sizes are rediculously small...
	 */
	if ((width > 20) && (height > 20)) {
		imbuf=gdk_pixbuf_new_from_file_at_size(filename, scaleto, scaleto, NULL);
		gtk_image_set_from_pixbuf(GTK_IMAGE(bimdiag_image1), imbuf);
		g_object_unref(imbuf);

		gtk_entry_set_text(GTK_ENTRY(bimdiag_entry1), filename);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(bimdiag_radio2), TRUE);

		if (bimage_browsed_file) {
			free(bimage_browsed_file);
		}
		bimage_browsed_file=filename;
	}
	else {
		gtk_image_set_from_stock(GTK_IMAGE(bimdiag_image1), GTK_STOCK_NEW, GTK_ICON_SIZE_DIALOG);
	}
}

void on_goto_edit_avatar(GtkButton *button, gpointer  user_data)
{
	snprintf( callbackbuf, 200, "%s", "http://avatars.yahoo.com");
	display_url( (void *) strdup(callbackbuf) );
}

void on_goto_edit_avatar_menu(GtkMenuItem *menuitem, gpointer  user_data)
{
	on_goto_edit_avatar(NULL, NULL);
}

void on_delete_all_yavatars(GtkButton *button, gpointer  user_data)
{
	delete_all_yavatars();
}

void on_delete_all_bimages(GtkButton *button, gpointer  user_data)
{
	delete_all_bimages();
}

void on_refresh_bavatar(GtkButton *button, gpointer  user_data)
{
	GdkPixbuf *imbuf;
	struct stat sbuf;
	char *(pieces[6]);
	char *my_png;
	char *my_ava;
	char *my_command;

	if (! my_avatar) {  return;}
	delete_yavatars(my_avatar);
	download_yavatar(my_avatar, 0, NULL);
	if (! download_yavatar(my_avatar, 2, NULL)) { return; }

	pieces[0]=GYACH_CFG_DIR;
	pieces[1]="/";
	pieces[2]=ymsg_sess->user;
	pieces[3]=".friend_icon.png";
	pieces[4]=NULL;
	my_png=gyachi_filename(pieces);
	unlink(my_png);

	pieces[0]=GYACH_CFG_DIR;
	pieces[1]="/yavatars/";
	pieces[2]=my_avatar;
	pieces[3]=".large.";
	pieces[4]=avatar_filetype;
	pieces[5]=NULL;
	my_ava = gyachi_filename(pieces);

	pieces[0]="convert -colors 96 -quality 9 ";
	pieces[1]=my_ava;
	pieces[2]=" ";
	pieces[3]=my_png;
	pieces[4]=NULL;	
	my_command=build_string(pieces);
	my_system(my_command);
	free(my_command);

	if (stat(my_png, &sbuf )) {
		snprintf(callbackbuf, 300, "%s \"%s\" %s", _("The image"), my_ava, _("could not be converted to a PNG image."));
		show_ok_dialog(callbackbuf);
		snprintf(callbackbuf, 3, "%s", "");
		gtk_entry_set_text(GTK_ENTRY(bimdiag_entry2), callbackbuf);
		free(my_png);
		free(my_ava);
		return;
	}

	imbuf=gdk_pixbuf_new_from_file_at_size(my_png, 96, 96, NULL);
	gtk_entry_set_text(GTK_ENTRY(bimdiag_entry2), my_ava);
	if (! imbuf) {
		snprintf(callbackbuf, 300, "%s \"%s\" %s \"%s\" %s",
			 _("The image"), my_ava,
			 _("converted to a PNG image."), my_png,
			 _("could not be loaded."));
		show_ok_dialog(callbackbuf);
		snprintf(callbackbuf, 3, "%s", "");
		gtk_entry_set_text(GTK_ENTRY(bimdiag_entry2), callbackbuf);
		free(my_png);
		free(my_ava);
		return;
	}

	gtk_image_set_from_pixbuf(GTK_IMAGE(bimdiag_image2), imbuf);
	g_object_unref(imbuf);

//	I think not needed...
//	update_buddy_clist();

	free(my_png);
	free(my_ava);
}


void convert_buddy_image()
{
	struct stat sbuf;
	char *(pieces[10]);
	char *my_png;
	char *my_bimage;

	pieces[0]=GYACH_CFG_DIR;
	pieces[1]="/";
	pieces[2]=ymsg_sess->user;
	pieces[3]=".friend_icon.png";
	pieces[4]=NULL;
	my_png=gyachi_filename(pieces);
	unlink(my_png);

//	pieces[0]=GYACH_CFG_DIR;
//	pieces[1]="/";
//	pieces[2]=ymsg_sess->user;
	pieces[3]=".my_bimage";
//	pieces[4]=NULL;
	my_bimage=gyachi_filename(pieces);
	if (stat(my_bimage, &sbuf)) {
		/* some error. File doesn't exist, or link invalid.
		 * Get rid of link if it is there...
		 * Do conversion on gyachrc bimage_file instead...
		 */
		unlink(my_bimage);
		free(my_bimage);
		my_bimage=strdup(bimage_file);
	}
	if ((bimage_share==1) && my_avatar && bimage_file) {
		char *my_command;

		pieces[0]="convert -colors 96 -quality 9 ";
		pieces[1]=GYACH_CFG_DIR;
		pieces[2]="/yavatars/";
		pieces[3]=my_avatar;
		pieces[4]=".large.";
		pieces[5]=avatar_filetype;
		pieces[6]="  ";
		pieces[7]=my_png;
		pieces[8]=NULL;
		my_command=build_string(pieces);
		my_system(my_command);
		free(my_command);
	}

	if ((bimage_share==2) && bimage_file) {
		char *my_command;

		/* buddy image conversion change 8/2008
		 * Try to convert directly from selected image to png
		 * If this succeeds, then we're done.
		 * If this doesn't succeed, then convert to gif, and then
		 * convert the gif to png. That always seems to work...
		 */
		unlink(my_png);

		pieces[0]="convert -resize 96x96 -colors 128 -quality 7 ";
		pieces[1]=my_bimage;
		pieces[2]="  ";
		pieces[3]=my_png;
		pieces[4]=NULL;
		my_command=build_string(pieces);
		my_system(my_command);
		free(my_command);

		if (stat(my_png, &sbuf)) {
			char *my_gif;
			char *my_command;

			/* some error. File doesn't exist, or link invalid.
			 * Convert into gif, and the convert gif into png...
			 */

			pieces[0]=GYACH_CFG_DIR;
			pieces[1]="/";
			pieces[2]=ymsg_sess->user;
			pieces[3]=".friend_icon.gif";
			pieces[4]=NULL;
			my_gif=gyachi_filename(pieces);
			unlink(my_gif);

			pieces[0]="convert ";
			pieces[1]=my_bimage;
			pieces[2]=" ";
			pieces[3]=my_gif;
			pieces[4]=NULL;
			my_command=build_string(pieces);
			my_system(my_command);
			free(my_command);

			if (stat(my_gif, &sbuf)) {
				char *message;

				pieces[0]=_("The image");
				pieces[1]=" \"";
				pieces[2]=my_bimage;
				pieces[3]="\" ";
				pieces[4]=_("could not be converted to a GIF image.");
				pieces[5]=NULL;
				message=build_string(pieces);
				show_ok_dialog(message);
				free(message);

				free(my_png);
				free(my_bimage);
				free(my_gif);
				return;
			}

			/* maintain aspect ratio.
			 * "-resize 96x96!" will force a resize to exactly 96x96,
			 * stretching the width/length as necessary
			 */
			pieces[0]="convert -resize 96x96 -colors 128 -quality 7 ";
			pieces[1]=my_gif;
			pieces[2]=" ";
			pieces[3]=my_png;
			pieces[4]=NULL;
			my_command=build_string(pieces);
			my_system(my_command);
			free(my_command);

			if (stat(my_png, &sbuf)) {
				char *message;

				pieces[0]=_("The image");
				pieces[1]=" \"";
				pieces[2]=my_gif;
				pieces[3]="\" (";
				pieces[4]=_("GIF from");
				pieces[5]=" \"";
				pieces[6]=my_bimage;
				pieces[7]="\") ";
				pieces[8]=_("could not be converted to a 96x96 .PNG image.");
				pieces[9]=NULL;
				message=build_string(pieces);
				show_ok_dialog(message);
				free(message);

				free(my_png);
				free(my_bimage);
				free(my_gif);
				return;
			}

			/* cleanup */
			unlink(my_gif);
			free(my_gif);
		}
	}

	free(my_png);
	free(my_bimage);
}

void update_my_bimages()
{
	GList *this_session = pm_list;
	PM_SESSION *pm_sess;

	while (this_session) {   /* any open PM sessions */
		int ichange=0;

		pm_sess = (PM_SESSION *)this_session->data;
		this_session = g_list_next( this_session );
		if (pm_sess->buddy_image_size != bimage_size) {ichange=1;}
		pm_sess->buddy_image_size=bimage_size;
		pm_sess->buddy_image_share=bimage_share;

		if ( (bimage_friend_only) && (! find_friend(pm_sess->pm_user)) && 
		     (! find_temporary_friend(pm_sess->pm_user)) ) {
			pm_sess->buddy_image_share=0;
		}

		if (! pm_sess->buddy_image_share) {
			set_current_pm_profile_name(retrieve_profname_str(
						  GTK_WIDGET(g_object_get_data(G_OBJECT(pm_sess->pm_window), PROFNAMESTR))));
			ymsg_bimage_toggle(ymsg_sess, pm_sess->pm_user, 0);
			reset_current_pm_profile_name();
		} 

		update_my_buddy_image(pm_sess, 1);
		if (ichange) {
			/* size change, update theirs */ 
			update_my_buddy_image(pm_sess, 0);
		}
	}
}

void on_activate_bimage_config(GtkButton *button, gpointer  user_data)
{
	int b_int=0;
	int b_size=0;
	char *avy=NULL;
	char *(pieces[6]);

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (bimdiag_radio2))) {
		b_int=2;  /* photo */
	}
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (bimdiag_radio3))) {
		b_int=1;  /* avatar */
	}
	if (b_int==1) {
		avy=strdup(gtk_entry_get_text(GTK_ENTRY(bimdiag_entry2) ));
	}
	else {
		char *my_bimage;

		if (b_int==2) {
			if (bimage_browsed_file) {
				avy = bimage_browsed_file;
				bimage_browsed_file = NULL;
			}
			else {
				avy=strdup(gtk_entry_get_text(GTK_ENTRY(bimdiag_entry1)));
			}
		}

		pieces[0]=GYACH_CFG_DIR;
		pieces[1]="/";
		pieces[2]=ymsg_sess->user;
		pieces[3]=".my_bimage";
		pieces[4]=NULL;
		my_bimage=gyachi_filename(pieces);
		unlink(my_bimage);
		symlink(avy, my_bimage);
		free(my_bimage);
	}
	
	if (avy) {
		if (strlen(avy)<1) {free(avy);  return;}
		if (bimage_file) {free(bimage_file);}
		if (bimage_hash) {free(bimage_hash); bimage_hash=NULL;}
		bimage_timestamp=0;
		bimage_file=avy;
		avy = NULL;
	}

	if (bimage_url) {
		free(bimage_url);
		bimage_url=NULL;
	}

	bimage_share=b_int;

	show_bimages=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bimdiag_check1));
	bimage_friend_only=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bimdiag_check2));
	show_yavatars=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bimdiag_check3));
	share_blist_avatar=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bimdiag_check4));

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (bimdiag_size_radio2))) {
		b_size=1;
	}
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON (bimdiag_size_radio3))) {
		b_size=2;
	}
	bimage_size=b_size;
	ymsg_avatar_toggle(ymsg_sess, share_blist_avatar);

	update_my_bimages();
	if (bimage_share && bimage_file) {
		upload_new_buddy_image();
	}

	write_config();

	on_close_bimage_select_window(GTK_WIDGET(button), user_data);
}


void on_pms_sendcaminvite(GtkMenuItem *widget, gpointer user_data)
{
	PM_SESSION *pm_sess;

	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(widget), "pms_menu1" )) ) {
		if (selected_buddy) {free(selected_buddy);}
		selected_buddy=strdup(pm_sess->pm_user);
		on_sendcaminvite_worker(widget, user_data, 1);
	}
	return;
}

void on_pms_viewcam(GtkMenuItem *widget, gpointer user_data)
{
	PM_SESSION *pm_sess;

	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(widget), "pms_menu2" )) ) {
		if (selected_buddy) {free(selected_buddy);}
		selected_buddy=strdup(pm_sess->pm_user);
		on_viewcam_worker(widget, user_data, 1);
	}
	return;
}


void on_photoalbum_cb(GtkButton *widget, gpointer user_data)
{
	GtkWidget *tmp_widget;
	GtkWidget *tmp_entry;
	char newsite[65]="";
	char *nsite=newsite;
	gchar *etext=NULL;
	int i;

	tmp_widget =g_object_get_data(G_OBJECT(widget), "mywindow" );
	tmp_entry = g_object_get_data(G_OBJECT(widget), "myentry" );
	if (tmp_entry) {
		etext=g_strdup(gtk_entry_get_text(GTK_ENTRY(tmp_entry)));
		for (i=0; i<strlen(etext); i++) {
			if (etext[i] != ' ') {newsite[i]=etext[i]; }
		}
	}

	if (tmp_widget) {gtk_widget_destroy( tmp_widget );}
	if (strlen(nsite)>0) {
		snprintf( callbackbuf, 300, "http://photos.yahoo.com/bc/%s", nsite);
		display_url( (void *) strdup(callbackbuf) );
	}
	if (etext) {g_free(etext);}
}

void on_photoalbum(GtkMenuItem *menuitem, gpointer  user_data)
{
	GtkWidget *okbutton;

	okbutton=show_input_dialog(chat_window, _("User"), "OK" ,"Cancel");
	g_signal_connect(G_OBJECT(okbutton), "clicked",
                      G_CALLBACK (on_photoalbum_cb), NULL);
	if (selected_buddy) {
		GtkWidget *tmp_entry;
		tmp_entry = g_object_get_data(G_OBJECT(okbutton), "myentry" );
		gtk_entry_set_text(GTK_ENTRY(tmp_entry), selected_buddy);
	} else {
		if (user_selected) {
			GtkWidget *tmp_entry;
			tmp_entry = g_object_get_data(G_OBJECT(okbutton), "myentry" );
			gtk_entry_set_text(GTK_ENTRY(tmp_entry), user_selected);
		}
	}
}


void on_blist_get_yab(GtkMenuItem *widget, gpointer user_data)
{
	GtkWidget *parent = user_data;

	if ( ! selected_buddy ) { return ; }
	search_open_yab(parent, selected_buddy);
}


void on_pms_get_yab(GtkMenuItem *widget, gpointer user_data)
{
	GtkWidget  *pm_session = (GtkWidget *)user_data;
	PM_SESSION *pm_sess = g_object_get_data(G_OBJECT(pm_session), "session");
	GtkWidget *parent;

	if ( pm_sess ) {
		parent = pm_sess->pm_notebook->window;
		search_open_yab(parent, pm_sess->pm_user);
	}
	return;
}

void on_pms_yphoto_start(GtkMenuItem *widget, gpointer user_data)
{
	GtkWidget  *pm_session = (GtkWidget *)user_data;
	PM_SESSION *pm_sess = g_object_get_data(G_OBJECT(pm_session), "session");

	if ( pm_sess ) {
		if (plugins_yphotos_loaded()) {
			plugins_on_yphoto_session_start(pm_sess);
		}
	}
	return;
}

void on_pms_yphotoshare_start (GtkMenuItem *widget, gpointer user_data) {
	GtkWidget  *pm_session = (GtkWidget *)user_data;
	PM_SESSION *pm_sess = g_object_get_data(G_OBJECT(pm_session), "session");

	if ( pm_sess ) {
		yahoo_yphoto_invite(pm_sess->pm_user);
	}
	return;
}

void on_pms_dlmanager_start (GtkMenuItem *widget, gpointer user_data) {
	GtkWidget  *pm_session = (GtkWidget *)user_data;
	GtkWidget  *dlmanager;

	dlmanager = g_object_get_data(G_OBJECT(pm_session), "dlmanager");
	if (!dlmanager) {
		dlmanager = create_dl_manager(pm_session);
	}
	g_object_steal_data(G_OBJECT(dlmanager), "hide");

	gtk_widget_show(dlmanager);
	return;
}

void on_pms_add_friend(GtkMenuItem *widget, gpointer user_data)
{
	pms_add_friend(widget, user_data, 0);
}

void on_pms_add_tempfriend(GtkMenuItem *widget, gpointer user_data)
{
	pms_add_friend(widget, user_data, 1);
}

void pms_add_friend(GtkMenuItem *widget, gpointer user_data, int temp_friend)
{
	PM_SESSION *pm_sess;
	char       *buffer;
	char      *(buffer_pieces[3]);


	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(widget), "fadd1" )) ) {
		if (! find_friend(pm_sess->pm_user)) {
			if (temp_friend) {
				buffer_pieces[0]="/temp-friend-add ";
			} else {
				buffer_pieces[0]="/buddy ";
			}
			buffer_pieces[1]=pm_sess->pm_user;
			buffer_pieces[2]=NULL;
			buffer = build_string(buffer_pieces);
			chat_command(buffer, user_data);
			free(buffer);
		}
		return;
	}

	if ( (pm_sess = find_pm_session_from_widget( GTK_WIDGET(widget), "fadd2" )) ) {
		if (! find_friend(pm_sess->pm_user)) {
			if (temp_friend) {
				buffer_pieces[0]="/temp-friend-add ";
			} else {
				buffer_pieces[0]="/buddy ";
			}
			buffer_pieces[1]=pm_sess->pm_user;
			buffer_pieces[2]=NULL;
			buffer = build_string(buffer_pieces);
			chat_command(buffer, user_data);
			free(buffer);
		}
		return;
	}
}



void on_check_gyache_version_cb(GtkMenuItem *widget, gpointer user_data)
{
	int url_length=0;
	char *tmppage=NULL;
	char *gynews=NULL;
	char *gyversion=NULL;
	GtkWidget *tmp_widget=NULL;
	int yahoo_tab;
	
	tmppage=malloc(8192);
	if (! tmppage) {return;}
	tmp_widget=g_object_get_data(G_OBJECT(chat_window),"gynotebook");
	snprintf(callbackbuf, 150, "%s%s", GYACH_URL, "GYACHI_VERSION");
	/* should be under 60-70 bytes */ 
	url_length=fetch_url( callbackbuf, tmppage, 600, NULL, NULL );
	
	if (url_length>1) {gyversion=strdup(tmppage);}
	else {gyversion=strdup("Latest version could not be retrieved");}

	/* There should be a separate file with news, suitable for */
	/* INCLUDING into web page or here */
	snprintf(callbackbuf, 150, "%s%s", GYACH_URL, "news.html");
	sprintf(tmppage,"%s","");
	url_length=fetch_url(callbackbuf, tmppage, 8100, NULL, NULL);
	
	if (url_length>1) {gynews=strdup(tmppage);}
	else {gynews=strdup("Latest news could not be retrieved");}

	/* check for missing pages */ 
	if ( strstr(gynews, "not found on this server")  || 
		strstr(gynews, "<html>") || strstr(gynews, "<HTML>") ) {
			free(gynews);
			gynews=strdup("Latest news could not be retrieved");
	}
	/* check for missing pages */ 
	if ( strstr(gyversion, "not found on this server")  || 
		strstr(gyversion, "<html>") || strstr(gyversion, "<HTML>") ) {
			free(gyversion);
			gyversion=strdup("Latest version could not be retrieved");
	}

	/* TODO: Remove reference to gyachi.shtml once site starts at index.shtml */
	snprintf(tmppage, 8190, "<br>You are currently using version: <b>%s</b><br>The most CURRENT version available is: <b>%s</b><br><a href=\"%sdownload.shtml\">Download  Gyach-E Improved</a><br>&nbsp; <br>&nbsp; <br><b><a href=\"%snews.html\">Gyach-E Improved</a> News Bulletins:</b><br>%s<br>", VERSION, gyversion, GYACH_URL, GYACH_URL, gynews );
	set_myyahoo_html_data(tmppage);
	free(tmppage);
	free(gynews);
	free(gyversion);
	if (tmp_widget) {
		yahoo_tab = find_tab_posn(YAHOO_TAB);
		gtk_notebook_set_current_page(GTK_NOTEBOOK(tmp_widget), yahoo_tab);
	}
	gdk_window_raise(chat_window->window );
}
