/*****************************************************************************
 * gyachi-gtkspell.c, Plugin to use gtkspell for spell checking
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * Released under the terms of the GPL.
 * *NO WARRANTY*
 *
 * Copyright (C) 2008, Gregory D Hosler (ghosler ['at'] users.sourceforge.net)
 * Released under the terms of the GPL.
 *
 *****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>
#include <gtkspell/gtkspell.h>

#include "plugin_api.h"
#include "config.h"
#include "spellcheck_plugin.h"

#define MY_VERSION "1.0"


static void report_gtkspell_error(GtkWidget *parent, const char *err) {
	GtkWidget *dlg;
	dlg = gtk_message_dialog_new(
			GTK_WINDOW(parent),
			GTK_DIALOG_DESTROY_WITH_PARENT,
			GTK_MESSAGE_ERROR,
			GTK_BUTTONS_CLOSE,
			"GtkSpell error: %s", err);
	gtk_dialog_run(GTK_DIALOG(dlg));
	gtk_widget_destroy(dlg);
}

void gtk_spell_activate(GtkTextView *text_view, int activate, GtkWidget *parent)
{
	GtkSpell *spell;
	GError *error = NULL;

	spell = gtkspell_get_from_text_view(text_view);
	if (activate) {
		if (!spell) {
			/* attached a GtkSpell, if not already attached */
			spell = gtkspell_new_attach(text_view, NULL, &error);

			if (spell == NULL) {
				report_gtkspell_error(parent, error->message);
				g_error_free(error);
			}
		}
	}
	else {
		/* deattached a GtkSpell, if attached */
		if (spell) {
			gtkspell_detach(spell);
		}
	}
}

GYACHI_SPELLCHECK_PLUGIN gtkspell_spellcheck_plugin = {
	.name        = "GTKSPELL",
	.description = NULL,
	.activate    = gtk_spell_activate
};

int gtkspell_plugin_init() {
	char description[512];

	sprintf(description, "spellcheck plugin using gtkspell [gyachigtkspell.so] %s", MY_VERSION);
	gtkspell_spellcheck_plugin.description = strdup(description);
	register_spellcheck_plugin(&gtkspell_spellcheck_plugin);
	select_spellcheck_plugin(gtkspell_spellcheck_plugin.name);
	return(1);
}

PLUGIN_INFO plugin_info = {
	.type = PLUGIN_GENERIC,
	.module_name = "GyachI-spellcheck-plugin-gtkspell",
	.description = "A plugin to use gtkspell for spell checking",
	.version     = "0.1",
	.date        = "24/11/2008",
	.credits     = "Gregory D Hosler [ghosler ('at') users.sourceforge.net]",
	.sys_req     = "",
	.init        = gtkspell_plugin_init
};
