# (c) Copyright 2020-2021 CodeWeavers, Inc.

from gi.repository import GLib
from gi.repository import Gtk
from gi.repository import Vte

# for localization
from cxutils import cxgettext as _

class FixDialog(object):

    def __init__(self, title, text, prompt, command, callback):
        self.retcode = None
        self.command = command
        self.callback = callback
        self.finished = False

        self.dialog = Gtk.Dialog()
        self.dialog.set_title(title)
        self.dialog.set_resizable(False)
        self.dialog.connect('response', self.dialog_response)

        self.no = self.dialog.add_button(Gtk.STOCK_NO, 1)
        self.yes = self.dialog.add_button(Gtk.STOCK_YES, 0)
        self.yes.grab_default()

        self.label = Gtk.Label()
        self.label.set_text(text +'\n\n' + prompt)
        self.label.set_property('margin', 5)
        self.label.set_halign(Gtk.Align.START)

        content = self.dialog.get_content_area()
        content.set_size_request(600, -1)
        content.add(self.label)

        self.dialog.show_all()

        self.ok = self.dialog.add_button(_("Continue"), -1)
        self.ok.hide()

        self.progress = Gtk.ProgressBar()
        content.add(self.progress)

        self.term = Vte.Terminal()
        self.term.set_input_enabled(False)
        self.term.set_size(80, 24)

        self.expander = Gtk.Expander()
        self.expander.set_label(_("Details"))
        self.expander.add(self.term)
        content.add(self.expander)

        self.expander.show_all()
        self.expander.hide()

    def destroy(self):
        self.dialog.destroy()
        self.callback()

    def dialog_response(self, _dialog, response):
        if self.retcode is None:
            self.retcode = response

        if response == 0:
            self.run_command()
        else:
            self.destroy()

    def update_pulse(self):
        if self.finished:
            return False

        self.progress.pulse()
        return True

    def run_response(self, _vte, retcode):
        self.retcode = retcode >> 8 if retcode >> 8 != 0 else -retcode
        self.finished = True
        self.ok.set_sensitive(True)
        self.progress.set_fraction(1)

        if retcode != 0:
            self.label.set_text(_("Failed to install missing packages."))
        else:
            self.label.set_text(_("Finished installing missing packages."))

    def spawn_cb(self, *args):
        pass

    def run_command(self):
        self.yes.hide()
        self.no.hide()
        self.ok.show()
        self.expander.show()
        self.progress.show()
        self.ok.set_sensitive(False)
        self.label.set_text(_(u'Installing\u2026'))

        GLib.timeout_add(300, self.update_pulse)

        self.term.connect('child-exited', self.run_response)
        try:
            # The child_setup_data parameter is undocumented!
            self.term.spawn_async(Vte.PtyFlags.DEFAULT, None, self.command,
                                  None, GLib.SpawnFlags.DEFAULT,
                                  None, None, # child_setup, child_setup_data
                                  -1, # timeout
                                  None, # cancellable
                                  self.spawn_cb, None) # callback, user_data
        except AttributeError:
            # Fall back to the deprecated spawn_sync() if spawn_async() is
            # missing (which should not be the case on Vte >= 0.48 but may
            # happen anyway due to a gir parser bug).
            self.term.spawn_sync(Vte.PtyFlags.DEFAULT, None, self.command,
                                 None, GLib.SpawnFlags.DEFAULT,
                                 None, None, # child_setup, child_setup_data
                                 None) # cancellable
