\name{AreaOpeningImageFilter}
\alias{AreaOpeningImageFilter}
\title{AreaOpeningImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Morphological opening by attributes.
AreaOpeningImageFilter}
\details{
An attribute opening removes blobs according to criteria such as area.
When applied to grayscale images they have the effect of trimming
peaks (regions brighter than their surroundings) based on area while
leaving the rest of the image unchanged.
This code was contributed in the Insight Journal paper
"Grayscale morphological attribute operations" by Beare R. https://hdl.handle.net/1926/1316 https://www.insight-journal.org/browse/publication/203
Richard Beare. Department of Medicine, Monash University, Melbourne,
Australia.
See:
AreaOpening for the procedural interface
itk::AreaOpeningImageFilter for the Doxygen on the original ITK class.
AreaOpeningImageFilter}
%C++ includes: sitkAreaOpeningImageFilter.h
\section{Methods}{
\describe{
\item{ AreaOpeningImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{}
\item{double GetLambda() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetUseImageSpacing() const:}{
Set/Get whether the image spacing is used or not - defaults to true.
}
\item{Self SetFullyConnected(bool FullyConnected):}{}
\item{Self SetLambda(double Lambda):}{
The size of the area opening.
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set/Get whether the image spacing is used or not - defaults to true.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~AreaOpeningImageFilter():}{
Destructor
}
}
}
