/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.util;

import com.intellij.codeInsight.completion.ml.MLWeigherUtil;
import com.intellij.completion.ml.features.MLCompletionWeigher;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u000e\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0010\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00100\u000f2\u001a\u0010\u0011\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00130\u0012J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0001H\u0002J\u0014\u0010\u0016\u001a\u00020\f2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u0007H\u0002J(\u0010\u001a\u001a\u00020\u001b*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0001H\u0002J(\u0010\u001e\u001a\u00020\u001b*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0001H\u0002J(\u0010 \u001a\u00020\u001b*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007H\u0002J.\u0010#\u001a\u00020\u001b*\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u00072\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/completion/ml/util/RelevanceUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NULL_TEXT", "", "IGNORED_FACTORS", "", "weighersClassesCache", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "asRelevanceMaps", "Lkotlin/Pair;", "", "relevanceObjects", "", "Lcom/intellij/openapi/util/Pair;", "acceptValue", "value", "isJetBrainsClass", "aClass", "Ljava/lang/Class;", "normalized", "addMlFeatures", "", "prefix", "comparable", "addProximityValues", "proximity", "addDataClassValues", "featureName", "dataClassString", "addProperties", "properties", "intellij.completionMlRanking"})
@SourceDebugExtension(value={"SMAP\nRelevanceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelevanceUtil.kt\ncom/intellij/completion/ml/util/RelevanceUtil\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n382#2,7:112\n1869#3,2:119\n14#4:121\n*S KotlinDebug\n*F\n+ 1 RelevanceUtil.kt\ncom/intellij/completion/ml/util/RelevanceUtil\n*L\n61#1:112,7\n101#1:119,2\n12#1:121\n*E\n"})
public final class RelevanceUtil {
    @NotNull
    public static final RelevanceUtil INSTANCE = new RelevanceUtil();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String NULL_TEXT = "null";
    @NotNull
    private static final Set<String> IGNORED_FACTORS;
    @NotNull
    private static final HashMap<String, Boolean> weighersClassesCache;

    private RelevanceUtil() {
    }

    @NotNull
    public final kotlin.Pair<Map<String, Object>, Map<String, Object>> asRelevanceMaps(@NotNull List<? extends Pair<String, Object>> relevanceObjects) {
        Intrinsics.checkNotNullParameter(relevanceObjects, (String)"relevanceObjects");
        HashMap relevanceMap = new HashMap();
        Map additionalMap = new LinkedHashMap();
        block14: for (Pair<String, Object> pair : relevanceObjects) {
            Object object = pair.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            String name = this.normalized((String)object);
            Object value = pair.second;
            if (IGNORED_FACTORS.contains(name) || value == null) continue;
            switch (name) {
                case "proximity": {
                    this.addProximityValues(relevanceMap, "prox", value);
                    continue block14;
                }
                case "kotlin.proximity": {
                    this.addProximityValues(relevanceMap, "kt_prox", value);
                    continue block14;
                }
                case "swiftSymbolProximity": {
                    ((Map)relevanceMap).put(name, value);
                    this.addProximityValues(relevanceMap, "swift_prox", value);
                    continue block14;
                }
                case "kotlin.callableWeight": {
                    this.addDataClassValues(relevanceMap, "kotlin.callableWeight", value.toString());
                    continue block14;
                }
                case "ml_weigh": {
                    this.addMlFeatures(additionalMap, "ml", value);
                    continue block14;
                }
            }
            if (!this.acceptValue(value) && !Intrinsics.areEqual((Object)name, (Object)"ml_rank")) continue;
            ((Map)relevanceMap).put(name, value);
        }
        return new kotlin.Pair(relevanceMap, (Object)additionalMap);
    }

    private final boolean acceptValue(Object value) {
        return value instanceof Number || value instanceof Boolean || value.getClass().isEnum() || this.isJetBrainsClass(value.getClass());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isJetBrainsClass(Class<?> aClass) {
        Object object;
        void $this$getOrPut$iv;
        Map map = weighersClassesCache;
        String key$iv = aClass.getName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Boolean answer$iv = PluginInfoDetectorKt.getPluginInfo(aClass).getType().isDevelopedByJetBrains();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Boolean)object;
    }

    private final String normalized(String $this$normalized) {
        return StringsKt.substringBefore$default((String)$this$normalized, (char)'@', null, (int)2, null);
    }

    private final void addMlFeatures(Map<String, Object> $this$addMlFeatures, String prefix, Object comparable) {
        if (!(comparable instanceof MLCompletionWeigher.DummyComparable)) {
            LOG.error("Unexpected value type of `" + prefix + "`: " + comparable.getClass().getSimpleName());
            return;
        }
        for (Map.Entry<String, Object> entry : ((MLCompletionWeigher.DummyComparable)comparable).getMlFeatures().entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            $this$addMlFeatures.put(prefix + "_" + name, value);
        }
    }

    private final void addProximityValues(Map<String, Object> $this$addProximityValues, String prefix, Object proximity) {
        Map weights = MLWeigherUtil.INSTANCE.extractWeightsOrNull(proximity);
        if (weights == null) {
            LOG.error("Unexpected comparable type for `" + prefix + "` weigher: " + proximity.getClass().getSimpleName());
            return;
        }
        for (Map.Entry entry : weights.entrySet()) {
            String name = (String)entry.getKey();
            Object weight = entry.getValue();
            $this$addProximityValues.put(prefix + "_" + name, weight);
        }
    }

    private final void addDataClassValues(Map<String, Object> $this$addDataClassValues, String featureName, String dataClassString) {
        if (StringUtil.countChars((CharSequence)dataClassString, (char)'(') != 1) {
            $this$addDataClassValues.put(featureName, dataClassString);
        } else {
            char[] cArray = new char[]{','};
            this.addProperties($this$addDataClassValues, featureName, StringsKt.split$default((CharSequence)StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)dataClassString, (char)'(', null, (int)2, null), (char)')', null, (int)2, null), (char[])cArray, (boolean)false, (int)0, (int)6, null));
        }
    }

    private final void addProperties(Map<String, Object> $this$addProperties, String prefix, List<String> properties) {
        Iterable $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (!(!StringsKt.isBlank((CharSequence)it))) continue;
            String key = prefix + "_" + ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)it, (char)'=', null, (int)2, null))).toString();
            String value = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)it, (char)'=', null, (int)2, null))).toString();
            if (Intrinsics.areEqual((Object)value, (Object)NULL_TEXT)) continue;
            $this$addProperties.put(key, value);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RelevanceUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"kotlin.byNameAlphabetical", "scalaMethodCompletionWeigher", "unresolvedOnTop", "alphabetic", "TabNineLookupElementWeigher", "AixLookupElementWeigher", "CodotaCompletionWeigher", "CodotaCompletionWeigher_Kotlin", "EmcSuggestionsWeigher", "codotaPriorityWeigher", "com.zlabs.code.completion.ScaCompletionWeigher", "com.aliyun.odps.studio.intellij.compiler.codecompletion.OdpsqlCompletionWeigher"};
        IGNORED_FACTORS = SetsKt.setOf((Object[])objectArray);
        weighersClassesCache = new HashMap();
    }
}

