/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;

public class GoogleDocStringSectionFixer
extends PyFixer<PyStringLiteralExpression> {
    public GoogleDocStringSectionFixer() {
        super(PyStringLiteralExpression.class);
    }

    @Override
    protected boolean isApplicable(@NotNull Editor editor2, @NotNull PyStringLiteralExpression pyString) {
        if (editor2 == null) {
            GoogleDocStringSectionFixer.$$$reportNull$$$0(0);
        }
        if (pyString == null) {
            GoogleDocStringSectionFixer.$$$reportNull$$$0(1);
        }
        return DocStringUtil.getParentDefinitionDocString(pyString) == pyString && DocStringParser.guessDocStringFormat(pyString.getText(), pyString) == DocStringFormat.GOOGLE;
    }

    @Override
    public void doApply(@NotNull Editor editor2, @NotNull PySmartEnterProcessor processor2, @NotNull PyStringLiteralExpression pyString) {
        int lineEnd;
        int lineNum;
        int lineStart;
        if (editor2 == null) {
            GoogleDocStringSectionFixer.$$$reportNull$$$0(2);
        }
        if (processor2 == null) {
            GoogleDocStringSectionFixer.$$$reportNull$$$0(3);
        }
        if (pyString == null) {
            GoogleDocStringSectionFixer.$$$reportNull$$$0(4);
        }
        int offset = editor2.getCaretModel().getOffset();
        Document document = editor2.getDocument();
        String line = document.getText(TextRange.create((int)(lineStart = document.getLineStartOffset(lineNum = document.getLineNumber(offset))), (int)(lineEnd = document.getLineEndOffset(lineNum))));
        if (!StringUtil.isEmptyOrSpaces((String)line)) {
            String header;
            String trimmedLine = line.trim();
            String string = header = trimmedLine.endsWith(":") ? trimmedLine.substring(0, trimmedLine.length() - 1) : trimmedLine;
            if (SectionBasedDocString.isValidSectionTitle(header)) {
                String patch = (trimmedLine.endsWith(":") ? "\n" : ":\n") + PyIndentUtil.getLineIndent(line) + GoogleCodeStyleDocStringBuilder.getDefaultSectionIndent(pyString.getContainingFile());
                int insertionOffset = lineStart + StringUtil.trimTrailing((String)line).length();
                document.replaceString(insertionOffset, lineEnd, (CharSequence)patch);
                processor2.registerUnresolvedError(insertionOffset + patch.length());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyString";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/GoogleDocStringSectionFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doApply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

