/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.privileges.dlsfls;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.OpenSearchSecurityException;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.MatchNoneQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.security.privileges.PrivilegesConfigurationValidationException;
import org.opensearch.security.privileges.PrivilegesEvaluationContext;
import org.opensearch.security.privileges.PrivilegesEvaluationException;
import org.opensearch.security.privileges.UserAttributes;
import org.opensearch.security.privileges.dlsfls.AbstractRuleBasedPrivileges;
import org.opensearch.security.privileges.dlsfls.DlsRestriction;
import org.opensearch.security.securityconf.impl.SecurityDynamicConfiguration;
import org.opensearch.security.securityconf.impl.v7.RoleV7;

public class DocumentPrivileges
extends AbstractRuleBasedPrivileges<DlsQuery, DlsRestriction> {
    private final NamedXContentRegistry xContentRegistry;

    public DocumentPrivileges(SecurityDynamicConfiguration<RoleV7> roles, Map<String, IndexAbstraction> indexMetadata, NamedXContentRegistry xContentRegistry, Settings settings) {
        super(roles, indexMetadata, (RoleV7.Index rolePermissions) -> DocumentPrivileges.roleToRule(rolePermissions, xContentRegistry), settings);
        this.xContentRegistry = xContentRegistry;
    }

    static DlsQuery roleToRule(RoleV7.Index rolePermissions, NamedXContentRegistry xContentRegistry) throws PrivilegesConfigurationValidationException {
        String dlsQueryTemplate = rolePermissions.getDls();
        if (dlsQueryTemplate != null && !Strings.isBlank((String)dlsQueryTemplate)) {
            return DlsQuery.create(dlsQueryTemplate, xContentRegistry);
        }
        return null;
    }

    @Override
    protected DlsRestriction unrestricted() {
        return DlsRestriction.NONE;
    }

    @Override
    protected DlsRestriction fullyRestricted() {
        return DlsRestriction.FULL;
    }

    @Override
    protected DlsRestriction compile(PrivilegesEvaluationContext context, Collection<DlsQuery> rules) throws PrivilegesEvaluationException {
        ArrayList<RenderedDlsQuery> renderedQueries = new ArrayList<RenderedDlsQuery>(rules.size());
        for (DlsQuery query : rules) {
            renderedQueries.add(query.evaluate(context));
        }
        return new DlsRestriction(renderedQueries);
    }

    public static RenderedDlsQuery getRenderedDlsQuery(NamedXContentRegistry xContentRegistry, String query) throws IOException {
        return new RenderedDlsQuery(DocumentPrivileges.parseQuery(xContentRegistry, query), query);
    }

    static QueryBuilder parseQuery(NamedXContentRegistry xContentRegistry, String queryString) throws IOException {
        XContentParser parser = JsonXContent.jsonXContent.createParser(xContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, queryString);
        return AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
    }

    static abstract class DlsQuery {
        final String queryString;

        DlsQuery(String queryString) {
            this.queryString = queryString;
        }

        abstract RenderedDlsQuery evaluate(PrivilegesEvaluationContext var1) throws PrivilegesEvaluationException;

        public int hashCode() {
            return this.queryString.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DlsQuery)) {
                return false;
            }
            DlsQuery other = (DlsQuery)obj;
            return Objects.equals(this.queryString, other.queryString);
        }

        protected QueryBuilder parseQuery(String queryString, NamedXContentRegistry xContentRegistry) throws PrivilegesConfigurationValidationException {
            try {
                XContentParser parser = JsonXContent.jsonXContent.createParser(xContentRegistry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, queryString);
                return AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser);
            }
            catch (Exception e) {
                throw new PrivilegesConfigurationValidationException("Invalid DLS query: " + queryString, e);
            }
        }

        static DlsQuery create(String queryString, NamedXContentRegistry xContentRegistry) throws PrivilegesConfigurationValidationException {
            if (UserAttributes.needsAttributeSubstitution(queryString)) {
                return new Dynamic(queryString, xContentRegistry);
            }
            return new Constant(queryString, xContentRegistry);
        }

        static class Dynamic
        extends DlsQuery {
            private final NamedXContentRegistry xContentRegistry;

            Dynamic(String queryString, NamedXContentRegistry xContentRegistry) {
                super(queryString);
                this.xContentRegistry = xContentRegistry;
            }

            @Override
            RenderedDlsQuery evaluate(PrivilegesEvaluationContext context) throws PrivilegesEvaluationException {
                String effectiveQueryString = UserAttributes.replaceProperties(this.queryString, context);
                if (UserAttributes.needsAttributeSubstitution(effectiveQueryString)) {
                    throw new PrivilegesEvaluationException("Invalid DLS query: " + effectiveQueryString, new OpenSearchSecurityException("User attribute substitution failed", new Object[0]));
                }
                try {
                    return new RenderedDlsQuery(this.parseQuery(effectiveQueryString, this.xContentRegistry), effectiveQueryString);
                }
                catch (Exception e) {
                    throw new PrivilegesEvaluationException("Invalid DLS query: " + effectiveQueryString, e);
                }
            }
        }

        static class Constant
        extends DlsQuery {
            private final RenderedDlsQuery renderedDlsQuery;

            Constant(String queryString, NamedXContentRegistry xContentRegistry) throws PrivilegesConfigurationValidationException {
                super(queryString);
                this.renderedDlsQuery = new RenderedDlsQuery(this.parseQuery(queryString, xContentRegistry), queryString);
            }

            @Override
            RenderedDlsQuery evaluate(PrivilegesEvaluationContext context) {
                return this.renderedDlsQuery;
            }
        }
    }

    public static class RenderedDlsQuery {
        public static RenderedDlsQuery MATCH_NONE = new RenderedDlsQuery((QueryBuilder)new MatchNoneQueryBuilder(), "{\"match_none\": {}}");
        private final QueryBuilder queryBuilder;
        private final String renderedSource;

        RenderedDlsQuery(QueryBuilder queryBuilder, String renderedSource) {
            this.queryBuilder = queryBuilder;
            this.renderedSource = renderedSource;
        }

        public QueryBuilder getQueryBuilder() {
            return this.queryBuilder;
        }

        public String getRenderedSource() {
            return this.renderedSource;
        }
    }
}

