/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.complexscripts.scripts;

import org.apache.fop.complexscripts.fonts.GlyphDefinitionTable;
import org.apache.fop.complexscripts.scripts.ScriptProcessor;
import org.apache.fop.complexscripts.util.CharAssociation;
import org.apache.fop.complexscripts.util.GlyphSequence;
import org.apache.fop.complexscripts.util.ScriptContextTester;

public class DefaultScriptProcessor
extends ScriptProcessor {
    private static final String[] GSUB_FEATURES = new String[]{"ccmp", "liga", "locl"};
    private static final String[] GPOS_FEATURES = new String[]{"kern", "mark", "mkmk"};

    DefaultScriptProcessor(String script) {
        super(script);
    }

    @Override
    public String[] getSubstitutionFeatures() {
        return GSUB_FEATURES;
    }

    @Override
    public ScriptContextTester getSubstitutionContextTester() {
        return null;
    }

    @Override
    public String[] getPositioningFeatures() {
        return GPOS_FEATURES;
    }

    @Override
    public ScriptContextTester getPositioningContextTester() {
        return null;
    }

    @Override
    public GlyphSequence reorderCombiningMarks(GlyphDefinitionTable gdef, GlyphSequence gs, int[] unscaledWidths, int[][] gpa, String script, String language) {
        int ng = gs.getGlyphCount();
        int[] ga = gs.getGlyphArray(false);
        int nm = 0;
        for (int i = 0; i < ng; ++i) {
            int[] pa;
            int gid = ga[i];
            int gw = unscaledWidths[i];
            int[] nArray = pa = gpa != null ? gpa[i] : null;
            if (!this.isReorderedMark(gdef, ga, unscaledWidths, i, pa)) continue;
            ++nm;
        }
        if (nm > 0 && ng - nm > 0) {
            int i;
            CharAssociation[] aa = gs.getAssociations(0, -1);
            int[] nga = new int[ng];
            Object npa = gpa != null ? new int[ng][] : (Object)null;
            CharAssociation[] naa = new CharAssociation[ng];
            boolean k = false;
            Object ba = null;
            int bg = -1;
            Object bpa = null;
            int[] order = new int[ng];
            for (i = 0; i < ng; ++i) {
                order[i] = i;
            }
            block2: for (i = 1; i < ng; ++i) {
                int[] pa;
                int[] nArray = pa = gpa != null ? gpa[i] : null;
                if (!this.isReorderedMark(gdef, ga, unscaledWidths, i, pa)) continue;
                for (int j = i; j > 0; --j) {
                    int[] paj;
                    DefaultScriptProcessor.switchGlyphs(order, j);
                    int[] nArray2 = paj = gpa != null ? gpa[order[j]] : null;
                    if (!this.isMarkNotReordered(gdef, ga, order[j], paj)) continue block2;
                }
            }
            for (i = 0; i < ng; ++i) {
                nga[i] = ga[order[i]];
                naa[i] = aa[order[i]];
                if (gpa == null) continue;
                npa[i] = gpa[order[i]];
            }
            if (npa != null) {
                System.arraycopy(npa, 0, gpa, 0, ng);
            }
            return new GlyphSequence(gs, null, nga, null, null, naa, null);
        }
        return gs;
    }

    private static void switchGlyphs(int[] order, int i) {
        if (i < 1) {
            throw new IllegalArgumentException(i + " must be > 0");
        }
        int oi = order[i];
        order[i] = order[i - 1];
        order[i - 1] = oi;
    }

    protected boolean isReorderedMark(GlyphDefinitionTable gdef, int[] glyphs, int[] unscaledWidths, int index, int[] pa) {
        pa = pa != null ? pa : new int[1];
        return gdef.isGlyphClass(glyphs[index], 3) && pa[0] != 0;
    }

    private boolean isMarkNotReordered(GlyphDefinitionTable gdef, int[] glyphs, int index, int[] pa) {
        pa = pa != null ? pa : new int[1];
        return gdef.isGlyphClass(glyphs[index], 3) && pa[0] == 0;
    }
}

