/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JAutoScrollBarPane;
import org.freeplane.core.ui.components.JComboBoxFactory;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.presentations.mindmapmode.CollectionChangeListener;
import org.freeplane.features.presentations.mindmapmode.CollectionChangedEvent;
import org.freeplane.features.presentations.mindmapmode.NamedElement;
import org.freeplane.features.presentations.mindmapmode.NamedElementCollection;
import org.freeplane.features.presentations.mindmapmode.Stringifyed;
import org.freeplane.features.presentations.mindmapmode.UndoableNamedElementCollection;

class CollectionBoxController<T extends NamedElement<T>> {
    private static final String PRESENTATION_MAX_DROP_BOX_ROW_COUNT_PROPERTY = "presentation.maxDropBoxRowCount";
    private NamedElementCollection<T> collection;
    private JComboBox<Stringifyed<T>> comboBoxCollectionNames = JComboBoxFactory.create();
    private final JComponent[] components;
    private final JComponent[] editingComponents;
    private final JButton btnMoveUp;
    private final JButton btnMoveDown;
    private final JButton btnMove;
    private final JButton btnNewElement;
    private final JButton btnCopy;
    private final JButton btnDeleteElement;
    private final CollectionChangeListener<T> collectionChangeListener;
    private JComponent collectionComponent;
    private JLabel lblElementCounter;

    public JComponent createCollectionBox() {
        this.collectionComponent = Box.createVerticalBox();
        Box names = Box.createHorizontalBox();
        names.add(this.lblElementCounter);
        names.add(this.comboBoxCollectionNames);
        this.collectionComponent.add(names);
        Box collectionButtons = Box.createHorizontalBox();
        collectionButtons.setBorder(BorderFactory.createEmptyBorder(0, this.lblElementCounter.getPreferredSize().width + 2, 0, 0));
        collectionButtons.add(this.btnNewElement);
        collectionButtons.add(this.btnDeleteElement);
        collectionButtons.add(this.btnMoveUp);
        collectionButtons.add(this.btnMoveDown);
        collectionButtons.add(this.btnMove);
        collectionButtons.add(this.btnCopy);
        collectionButtons.add(Box.createHorizontalGlue());
        this.collectionComponent.add(collectionButtons);
        return this.collectionComponent;
    }

    public CollectionBoxController(String elementName) {
        this.comboBoxCollectionNames.setEditable(false);
        Dimension comboBoxPreferredSize = this.comboBoxCollectionNames.getPreferredSize();
        this.comboBoxCollectionNames.setMaximumSize(new Dimension(Integer.MAX_VALUE, comboBoxPreferredSize.height));
        final ResourceController resourceController = ResourceController.getResourceController();
        this.comboBoxCollectionNames.setMaximumRowCount(resourceController.getIntProperty(PRESENTATION_MAX_DROP_BOX_ROW_COUNT_PROPERTY, 9));
        resourceController.addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (CollectionBoxController.PRESENTATION_MAX_DROP_BOX_ROW_COUNT_PROPERTY.equals(propertyName)) {
                    CollectionBoxController.this.comboBoxCollectionNames.setMaximumRowCount(resourceController.getIntProperty(CollectionBoxController.PRESENTATION_MAX_DROP_BOX_ROW_COUNT_PROPERTY, 9));
                }
            }
        });
        this.lblElementCounter = new JLabel("XXX/XXX ");
        this.lblElementCounter.setHorizontalAlignment(0);
        this.lblElementCounter.setPreferredSize(this.lblElementCounter.getPreferredSize());
        this.btnNewElement = this.createNewElementButton(elementName);
        this.btnDeleteElement = this.createDeleteElementButton(elementName);
        this.btnMoveUp = this.createMoveUpButton(elementName);
        this.btnMoveDown = this.createMoveDownButton(elementName);
        this.btnMove = this.createMoveButton(elementName);
        this.btnCopy = this.createCopyButton(elementName);
        this.components = new JComponent[]{this.comboBoxCollectionNames, this.lblElementCounter, this.btnNewElement, this.btnDeleteElement, this.btnMoveUp, this.btnMoveDown, this.btnMove, this.btnCopy};
        this.editingComponents = new JComponent[]{this.btnNewElement, this.btnDeleteElement, this.btnMoveUp, this.btnMoveDown, this.btnMove, this.btnCopy};
        this.disableUiElements();
        this.collectionChangeListener = new CollectionChangeListener<T>(){

            @Override
            public void onCollectionChange(CollectionChangedEvent<T> event) {
                if (event.eventType != CollectionChangedEvent.EventType.SELECTION_CHANGED) {
                    if (CollectionBoxController.this.btnNewElement.isEnabled()) {
                        CollectionBoxController.this.enableUiElements();
                    }
                    CollectionBoxController.this.updateElementCounterLabel();
                }
            }
        };
    }

    public void setCollection(NamedElementCollection<T> newCollection) {
        if (this.collection == newCollection) {
            return;
        }
        if (this.collection != null) {
            this.collection.removeCollectionChangeListener(this.collectionChangeListener);
        }
        this.collection = newCollection;
        if (newCollection == null) {
            this.disableUiElements();
        } else {
            ComboBoxModel<Stringifyed<T>> elements = newCollection.getElements();
            this.comboBoxCollectionNames.setModel(elements);
            this.enableUiElements();
            this.updateElementCounterLabel();
            this.collection.addCollectionChangeListener(this.collectionChangeListener);
        }
    }

    private void updateElementCounterLabel() {
        int collectionSize = this.collection.getSize();
        int currentElementIndex = this.collection.getCurrentElementIndex();
        this.lblElementCounter.setText((currentElementIndex >= 0 ? Integer.toString(currentElementIndex + 1) + "/" + Integer.toString(collectionSize) : "-/-") + " ");
    }

    private void enableUiElements() {
        int collectionSize = this.collection.getSize();
        int currentElementIndex = this.collection.getCurrentElementIndex();
        this.comboBoxCollectionNames.setEnabled(true);
        this.lblElementCounter.setEnabled(true);
        this.comboBoxCollectionNames.setEditable(collectionSize > 0);
        this.btnNewElement.setEnabled(true);
        this.btnDeleteElement.setEnabled(collectionSize > 0);
        this.btnMoveUp.setEnabled(currentElementIndex > 0);
        this.btnMoveDown.setEnabled(currentElementIndex >= 0 && currentElementIndex < collectionSize - 1);
        this.btnMove.setEnabled(collectionSize > 1);
        this.btnCopy.setEnabled(collectionSize > 0);
    }

    private void disableUiElements() {
        this.comboBoxCollectionNames.setModel(new DefaultComboBoxModel());
        this.lblElementCounter.setText("-/- ");
        for (JComponent c : this.components) {
            c.setEnabled(false);
        }
    }

    private JButton createMoveButton(String elementName) {
        JButton btnMove = TranslatedElementFactory.createButtonWithIcon((String)(elementName + ".move.icon"), (String)"collection.move");
        btnMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Vector<String> items = new Vector<String>(CollectionBoxController.this.collection.getSize());
                for (int i = 1; i <= CollectionBoxController.this.collection.getSize(); ++i) {
                    items.addElement(i + ": " + CollectionBoxController.this.collection.getElement(i - 1).getName());
                }
                DefaultComboBoxModel elements = new DefaultComboBoxModel(items);
                JList targets = new JList(elements);
                targets.setSelectionMode(0);
                String title = TextUtils.getText((String)"collection.moveTo");
                JAutoScrollBarPane scrollPane = new JAutoScrollBarPane(targets);
                UITools.setScrollbarIncrement((JScrollPane)scrollPane);
                if (JOptionPane.showConfirmDialog(CollectionBoxController.this.collectionComponent, scrollPane, title, 2, -1) == 0) {
                    UndoableNamedElementCollection.of(CollectionBoxController.this.collection).moveCurrentElementTo(targets.getSelectedIndex());
                }
            }
        });
        return btnMove;
    }

    private JButton createMoveDownButton(String elementName) {
        JButton btnMoveDown = TranslatedElementFactory.createButtonWithIcon((String)(elementName + ".down.icon"), (String)"collection.down");
        btnMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoableNamedElementCollection.of(CollectionBoxController.this.collection).moveCurrentElementDown();
            }
        });
        return btnMoveDown;
    }

    private JButton createMoveUpButton(String elementName) {
        JButton btnMoveUp = TranslatedElementFactory.createButtonWithIcon((String)(elementName + ".up.icon"), (String)"collection.up");
        btnMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoableNamedElementCollection.of(CollectionBoxController.this.collection).moveCurrentElementUp();
            }
        });
        return btnMoveUp;
    }

    private JButton createDeleteElementButton(String elementName) {
        JButton btnDeleteElement = TranslatedElementFactory.createButtonWithIcon((String)(elementName + ".delete.icon"), (String)"collection.delete");
        btnDeleteElement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoableNamedElementCollection.of(CollectionBoxController.this.collection).removeCurrentElement();
            }
        });
        return btnDeleteElement;
    }

    private JButton createNewElementButton(final String elementName) {
        JButton btnNewElement = TranslatedElementFactory.createButtonWithIcon((String)(elementName + ".new.icon"), (String)("collection.new." + elementName));
        btnNewElement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = TextUtils.getText((String)("collection.new." + elementName));
                UndoableNamedElementCollection.of(CollectionBoxController.this.collection).add(text + " " + (CollectionBoxController.this.collection.getSize() + 1));
                ComboBoxEditor editor = CollectionBoxController.this.comboBoxCollectionNames.getEditor();
                editor.selectAll();
                editor.getEditorComponent().requestFocusInWindow();
            }
        });
        return btnNewElement;
    }

    private JButton createCopyButton(String elementName) {
        JButton btnCopyElement = TranslatedElementFactory.createButtonWithIcon((String)(elementName + ".copy.icon"), (String)("collection.copy." + elementName));
        btnCopyElement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoableNamedElementCollection.of(CollectionBoxController.this.collection).copyCurrentElement();
                ComboBoxEditor editor = CollectionBoxController.this.comboBoxCollectionNames.getEditor();
                editor.selectAll();
                editor.getEditorComponent().requestFocusInWindow();
            }
        });
        return btnCopyElement;
    }

    void disableEditing() {
        for (JComponent c : this.editingComponents) {
            c.setEnabled(false);
        }
    }

    void enableEditing() {
        if (this.collection != null) {
            this.enableUiElements();
        }
    }
}

