/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.owl.ui.prefix.PrefixMappingEditorView;

public class PrefixMappingEditorViewImpl
extends JPanel
implements PrefixMappingEditorView {
    private final JTextField prefixNameField = new JTextField(30);
    private final JTextField prefixField = new JTextField(30);

    public PrefixMappingEditorViewImpl() {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel layout = new PreferencesLayoutPanel();
        layout.setUseVerticalLabelling(true);
        layout.addGroup("Prefix name");
        layout.addGroupComponent((JComponent)this.prefixNameField);
        layout.addHelpText("<html><body>Prefix names are usually short and should end with a colon.<br>Examples are <b>schema:</b>, <b>go:</b> and <b>vehicle:</b></body></html>");
        layout.addVerticalPadding();
        layout.addGroup("Prefix");
        layout.addGroupComponent((JComponent)this.prefixField);
        layout.addHelpText("Prefixes should not contain spaces and usually end with a slash (/) or hash (#)");
        this.add((Component)layout, "North");
    }

    @Override
    public PrefixMappingEditorView asJComponent() {
        return this;
    }

    @Override
    public void clear() {
        this.prefixNameField.setText("");
        this.prefixField.setText("");
    }

    @Override
    public void setPrefixName(@Nonnull String prefixName) {
        this.prefixNameField.setText(prefixName);
    }

    @Override
    @Nonnull
    public String getPrefixName() {
        return this.prefixNameField.getText().trim();
    }

    @Override
    public void setPrefix(@Nonnull String prefix) {
        this.prefixField.setText(prefix);
    }

    @Override
    public String getPrefix() {
        return this.prefixField.getText().trim();
    }

    @Override
    public void setPrefixNameChangedHandler(final @Nonnull PrefixMappingEditorView.PrefixNameChangedHandler handler) {
        this.prefixNameField.getDocument().addDocumentListener(new DocumentListener(){
            final /* synthetic */ PrefixMappingEditorViewImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                handler.handlePrefixNameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                handler.handlePrefixNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    @Override
    public void setPrefixChangedHandler(final @Nonnull PrefixMappingEditorView.PrefixChangedHandler handler) {
        this.prefixField.getDocument().addDocumentListener(new DocumentListener(){
            final /* synthetic */ PrefixMappingEditorViewImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                handler.handlePrefixChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                handler.handlePrefixChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public static void main(String[] args) {
        PrefixMappingEditorViewImpl view = new PrefixMappingEditorViewImpl();
        JOptionPane.showConfirmDialog(null, view);
    }
}

