/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

final class Ast {
    private static final char escapeCharacter = '\\';
    private static final char alternationCharacter = '/';
    private static final char beginParameterCharacter = '{';
    private static final char endParameterCharacter = '}';
    private static final char beginOptionalCharacter = '(';
    private static final char endOptionalCharacter = ')';

    Ast() {
    }

    static final class Token
    implements Located {
        final String text;
        final Type type;
        final int start;
        final int end;

        Token(String text, Type type, int start, int end) {
            this.text = Objects.requireNonNull(text);
            this.type = Objects.requireNonNull(type);
            this.start = start;
            this.end = end;
        }

        static boolean canEscape(Integer token) {
            if (Character.isWhitespace(token)) {
                return true;
            }
            switch (token) {
                case 40: 
                case 41: 
                case 47: 
                case 92: 
                case 123: 
                case 125: {
                    return true;
                }
            }
            return false;
        }

        static Type typeOf(Integer token) {
            if (Character.isWhitespace(token)) {
                return Type.WHITE_SPACE;
            }
            switch (token) {
                case 47: {
                    return Type.ALTERNATION;
                }
                case 123: {
                    return Type.BEGIN_PARAMETER;
                }
                case 125: {
                    return Type.END_PARAMETER;
                }
                case 40: {
                    return Type.BEGIN_OPTIONAL;
                }
                case 41: {
                    return Type.END_OPTIONAL;
                }
            }
            return Type.TEXT;
        }

        static boolean isEscapeCharacter(int token) {
            return token == 92;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Token token = (Token)o;
            return this.start == token.start && this.end == token.end && this.text.equals(token.text) && this.type == token.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.start, this.end, this.text, this.type});
        }

        public String toString() {
            return new StringJoiner(", ", "{", "}").add("\"type\": \"" + (Object)((Object)this.type) + "\"").add("\"start\": " + this.start + "").add("\"end\": " + this.end + "").add("\"text\": \"" + this.text + "\"").toString();
        }

        static enum Type {
            START_OF_LINE,
            END_OF_LINE,
            WHITE_SPACE,
            BEGIN_OPTIONAL("(", "optional text"),
            END_OPTIONAL(")", "optional text"),
            BEGIN_PARAMETER("{", "a parameter"),
            END_PARAMETER("}", "a parameter"),
            ALTERNATION("/", "alternation"),
            TEXT;

            private final String symbol;
            private final String purpose;

            private Type() {
                this(null, null);
            }

            private Type(String symbol, String purpose) {
                this.symbol = symbol;
                this.purpose = purpose;
            }

            String purpose() {
                return Objects.requireNonNull(this.purpose, this.name() + " does not have a purpose");
            }

            String symbol() {
                return Objects.requireNonNull(this.symbol, this.name() + " does not have a symbol");
            }
        }
    }

    static final class Node
    implements Located {
        private final Type type;
        private final List<Node> nodes;
        private final String token;
        private final int start;
        private final int end;

        Node(Type type, int start, int end, String token) {
            this(type, start, end, null, token);
        }

        Node(Type type, int start, int end, List<Node> nodes) {
            this(type, start, end, nodes, null);
        }

        private Node(Type type, int start, int end, List<Node> nodes, String token) {
            this.type = Objects.requireNonNull(type);
            this.nodes = nodes;
            this.token = token;
            this.start = start;
            this.end = end;
        }

        @Override
        public int start() {
            return this.start;
        }

        @Override
        public int end() {
            return this.end;
        }

        List<Node> nodes() {
            return this.nodes;
        }

        Type type() {
            return this.type;
        }

        String text() {
            if (this.nodes == null) {
                return this.token;
            }
            return this.nodes().stream().map(Node::text).collect(Collectors.joining());
        }

        public String toString() {
            return this.toString(0).toString();
        }

        private StringBuilder toString(int depth) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
            sb.append("{").append("\"type\": \"").append((Object)this.type).append("\", \"start\": ").append(this.start).append(", \"end\": ").append(this.end);
            if (this.token != null) {
                sb.append(", \"token\": \"").append(this.token.replaceAll("\\\\", "\\\\\\\\")).append("\"");
            }
            if (this.nodes != null) {
                sb.append(", \"nodes\": ");
                if (!this.nodes.isEmpty()) {
                    StringBuilder padding = new StringBuilder();
                    for (int i = 0; i < depth; ++i) {
                        padding.append("  ");
                    }
                    sb.append(this.nodes.stream().map(node -> node.toString(depth + 1)).collect(Collectors.joining(",\n", "[\n", "\n" + padding + "]")));
                } else {
                    sb.append("[]");
                }
            }
            sb.append("}");
            return sb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.start == node.start && this.end == node.end && this.type == node.type && Objects.equals(this.nodes, node.nodes) && Objects.equals(this.token, node.token);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.nodes, this.token, this.start, this.end});
        }

        static enum Type {
            TEXT_NODE,
            OPTIONAL_NODE,
            ALTERNATION_NODE,
            ALTERNATIVE_NODE,
            PARAMETER_NODE,
            EXPRESSION_NODE;

        }
    }

    static interface Located {
        public int start();

        public int end();
    }
}

