/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value.constant;

import java.time.Instant;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.facet.compare.ConstantComparator;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.constant.ConstantValue;

public class ConstantDateValue
extends ConstantValue
implements DateValue.CastingDateValue {
    private final long value;
    private final Date valueDate;
    private final String valueStr;
    public static final String name = "const_date";
    private final String exprStr;

    public ConstantDateValue(long value) {
        this.value = value;
        this.valueDate = new Date(value);
        this.valueStr = Instant.ofEpochMilli(value).toString();
        this.exprStr = ConstantValue.createExpressionString(this, this.valueStr);
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public Date getDate() {
        return this.valueDate;
    }

    @Override
    public String getString() {
        return this.valueStr;
    }

    @Override
    public Object getObject() {
        return this.valueDate;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void streamLongs(LongConsumer cons) {
        cons.accept(this.value);
    }

    @Override
    public void streamDates(Consumer<Date> cons) {
        cons.accept(this.valueDate);
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        cons.accept(this.valueStr);
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        cons.accept(this.valueDate);
    }

    @Override
    public ConstantComparator getObjectComparator(String expression) {
        return new ConstantComparator();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.CONST;
    }
}

