/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;
import org.apache.solr.update.processor.FieldValueMutatingUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public final class RegexReplaceProcessorFactory
extends FieldMutatingUpdateProcessorFactory {
    private static final String REPLACEMENT_PARAM = "replacement";
    private static final String PATTERN_PARAM = "pattern";
    private static final String LITERAL_REPLACEMENT_PARAM = "literalReplacement";
    private Pattern pattern;
    private String replacement;
    private boolean literalReplacementEnabled = true;

    @Override
    public void init(NamedList<?> args) {
        Object patternParam = args.remove(PATTERN_PARAM);
        if (patternParam == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required init parameter: pattern");
        }
        try {
            this.pattern = Pattern.compile(patternParam.toString());
        }
        catch (PatternSyntaxException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid regex: " + String.valueOf(patternParam), (Throwable)e);
        }
        Object replacementParam = args.remove(REPLACEMENT_PARAM);
        if (replacementParam == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required init parameter: replacement");
        }
        Boolean literalReplacement = args.removeBooleanArg(LITERAL_REPLACEMENT_PARAM);
        if (literalReplacement != null) {
            this.literalReplacementEnabled = literalReplacement;
        }
        this.replacement = this.literalReplacementEnabled ? Matcher.quoteReplacement(replacementParam.toString()) : replacementParam.toString();
        super.init(args);
    }

    @Override
    protected FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return FieldMutatingUpdateProcessor.SELECT_NO_FIELDS;
    }

    @Override
    public UpdateRequestProcessor getInstance(SolrQueryRequest request, SolrQueryResponse response, UpdateRequestProcessor next) {
        return FieldValueMutatingUpdateProcessor.valueMutator(this.getSelector(), next, src -> {
            if (src instanceof CharSequence) {
                CharSequence txt = (CharSequence)src;
                return this.pattern.matcher(txt).replaceAll(this.replacement);
            }
            return src;
        });
    }
}

