/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.api.model.IndexType;
import org.apache.solr.client.api.model.SchemaGetDynamicFieldInfoResponse;
import org.apache.solr.client.api.model.SchemaGetFieldInfoResponse;
import org.apache.solr.client.api.model.SchemaGetFieldTypeInfoResponse;
import org.apache.solr.client.api.model.SchemaInfoResponse;
import org.apache.solr.client.api.model.SchemaListCopyFieldsResponse;
import org.apache.solr.client.api.model.SchemaListDynamicFieldsResponse;
import org.apache.solr.client.api.model.SchemaListFieldTypesResponse;
import org.apache.solr.client.api.model.SchemaListFieldsResponse;
import org.apache.solr.client.api.model.SchemaNameResponse;
import org.apache.solr.client.api.model.SchemaSimilarityResponse;
import org.apache.solr.client.api.model.SchemaUniqueKeyResponse;
import org.apache.solr.client.api.model.SchemaVersionResponse;
import org.apache.solr.client.api.model.SchemaZkVersionResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SchemaApi {

    public static class ListSchemaFields
    extends SolrRequest<ListSchemaFieldsResponse> {
        private final IndexType indexType;
        private final String indexName;

        public ListSchemaFields(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/fields".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ListSchemaFieldsResponse createResponse(SolrClient client) {
            return new ListSchemaFieldsResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListSchemaFieldsResponse
    extends JacksonParsingResponse<SchemaListFieldsResponse> {
        public ListSchemaFieldsResponse() {
            super(SchemaListFieldsResponse.class);
        }
    }

    public static class ListSchemaFieldTypes
    extends SolrRequest<ListSchemaFieldTypesResponse> {
        private final IndexType indexType;
        private final String indexName;

        public ListSchemaFieldTypes(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/fieldtypes".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ListSchemaFieldTypesResponse createResponse(SolrClient client) {
            return new ListSchemaFieldTypesResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListSchemaFieldTypesResponse
    extends JacksonParsingResponse<SchemaListFieldTypesResponse> {
        public ListSchemaFieldTypesResponse() {
            super(SchemaListFieldTypesResponse.class);
        }
    }

    public static class ListDynamicFields
    extends SolrRequest<ListDynamicFieldsResponse> {
        private final IndexType indexType;
        private final String indexName;

        public ListDynamicFields(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/dynamicfields".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ListDynamicFieldsResponse createResponse(SolrClient client) {
            return new ListDynamicFieldsResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListDynamicFieldsResponse
    extends JacksonParsingResponse<SchemaListDynamicFieldsResponse> {
        public ListDynamicFieldsResponse() {
            super(SchemaListDynamicFieldsResponse.class);
        }
    }

    public static class ListCopyFields
    extends SolrRequest<ListCopyFieldsResponse> {
        private final IndexType indexType;
        private final String indexName;

        public ListCopyFields(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/copyfields".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ListCopyFieldsResponse createResponse(SolrClient client) {
            return new ListCopyFieldsResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListCopyFieldsResponse
    extends JacksonParsingResponse<SchemaListCopyFieldsResponse> {
        public ListCopyFieldsResponse() {
            super(SchemaListCopyFieldsResponse.class);
        }
    }

    public static class GetSchemaZkVersion
    extends SolrRequest<GetSchemaZkVersionResponse> {
        private final IndexType indexType;
        private final String indexName;
        private Integer refreshIfBelowVersion;

        public GetSchemaZkVersion(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/zkversion".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        public void setRefreshIfBelowVersion(Integer refreshIfBelowVersion) {
            this.refreshIfBelowVersion = refreshIfBelowVersion;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.refreshIfBelowVersion != null) {
                params.add("refreshIfBelowVersion", this.refreshIfBelowVersion.toString());
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("refreshIfBelowVersion");
            return queryParams;
        }

        @Override
        protected GetSchemaZkVersionResponse createResponse(SolrClient client) {
            return new GetSchemaZkVersionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaZkVersionResponse
    extends JacksonParsingResponse<SchemaZkVersionResponse> {
        public GetSchemaZkVersionResponse() {
            super(SchemaZkVersionResponse.class);
        }
    }

    public static class GetSchemaVersion
    extends SolrRequest<GetSchemaVersionResponse> {
        private final IndexType indexType;
        private final String indexName;

        public GetSchemaVersion(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/version".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetSchemaVersionResponse createResponse(SolrClient client) {
            return new GetSchemaVersionResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaVersionResponse
    extends JacksonParsingResponse<SchemaVersionResponse> {
        public GetSchemaVersionResponse() {
            super(SchemaVersionResponse.class);
        }
    }

    public static class GetSchemaUniqueKey
    extends SolrRequest<GetSchemaUniqueKeyResponse> {
        private final IndexType indexType;
        private final String indexName;

        public GetSchemaUniqueKey(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/uniquekey".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetSchemaUniqueKeyResponse createResponse(SolrClient client) {
            return new GetSchemaUniqueKeyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaUniqueKeyResponse
    extends JacksonParsingResponse<SchemaUniqueKeyResponse> {
        public GetSchemaUniqueKeyResponse() {
            super(SchemaUniqueKeyResponse.class);
        }
    }

    public static class GetSchemaSimilarity
    extends SolrRequest<GetSchemaSimilarityResponse> {
        private final IndexType indexType;
        private final String indexName;

        public GetSchemaSimilarity(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/similarity".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetSchemaSimilarityResponse createResponse(SolrClient client) {
            return new GetSchemaSimilarityResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaSimilarityResponse
    extends JacksonParsingResponse<SchemaSimilarityResponse> {
        public GetSchemaSimilarityResponse() {
            super(SchemaSimilarityResponse.class);
        }
    }

    public static class GetSchemaName
    extends SolrRequest<GetSchemaNameResponse> {
        private final IndexType indexType;
        private final String indexName;

        public GetSchemaName(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/name".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetSchemaNameResponse createResponse(SolrClient client) {
            return new GetSchemaNameResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaNameResponse
    extends JacksonParsingResponse<SchemaNameResponse> {
        public GetSchemaNameResponse() {
            super(SchemaNameResponse.class);
        }
    }

    public static class GetSchemaInfo
    extends SolrRequest<GetSchemaInfoResponse> {
        private final IndexType indexType;
        private final String indexName;

        public GetSchemaInfo(IndexType indexType, String indexName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName));
            this.indexType = indexType;
            this.indexName = indexName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetSchemaInfoResponse createResponse(SolrClient client) {
            return new GetSchemaInfoResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetSchemaInfoResponse
    extends JacksonParsingResponse<SchemaInfoResponse> {
        public GetSchemaInfoResponse() {
            super(SchemaInfoResponse.class);
        }
    }

    public static class GetFieldTypeInfo
    extends SolrRequest<GetFieldTypeInfoResponse> {
        private final IndexType indexType;
        private final String indexName;
        private final String fieldTypeName;

        public GetFieldTypeInfo(IndexType indexType, String indexName, String fieldTypeName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/fieldtypes/{fieldTypeName}".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName).replace("{fieldTypeName}", fieldTypeName));
            this.indexType = indexType;
            this.indexName = indexName;
            this.fieldTypeName = fieldTypeName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetFieldTypeInfoResponse createResponse(SolrClient client) {
            return new GetFieldTypeInfoResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetFieldTypeInfoResponse
    extends JacksonParsingResponse<SchemaGetFieldTypeInfoResponse> {
        public GetFieldTypeInfoResponse() {
            super(SchemaGetFieldTypeInfoResponse.class);
        }
    }

    public static class GetFieldInfo
    extends SolrRequest<GetFieldInfoResponse> {
        private final IndexType indexType;
        private final String indexName;
        private final String fieldName;

        public GetFieldInfo(IndexType indexType, String indexName, String fieldName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/fields/{fieldName}".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName).replace("{fieldName}", fieldName));
            this.indexType = indexType;
            this.indexName = indexName;
            this.fieldName = fieldName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetFieldInfoResponse createResponse(SolrClient client) {
            return new GetFieldInfoResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetFieldInfoResponse
    extends JacksonParsingResponse<SchemaGetFieldInfoResponse> {
        public GetFieldInfoResponse() {
            super(SchemaGetFieldInfoResponse.class);
        }
    }

    public static class GetDynamicFieldInfo
    extends SolrRequest<GetDynamicFieldInfoResponse> {
        private final IndexType indexType;
        private final String indexName;
        private final String fieldName;

        public GetDynamicFieldInfo(IndexType indexType, String indexName, String fieldName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/{indexType}/{indexName}/schema/dynamicfields/{fieldName}".replace("{indexType}", indexType.toString()).replace("{indexName}", indexName).replace("{fieldName}", fieldName));
            this.indexType = indexType;
            this.indexName = indexName;
            this.fieldName = fieldName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected GetDynamicFieldInfoResponse createResponse(SolrClient client) {
            return new GetDynamicFieldInfoResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class GetDynamicFieldInfoResponse
    extends JacksonParsingResponse<SchemaGetDynamicFieldInfoResponse> {
        public GetDynamicFieldInfoResponse() {
            super(SchemaGetDynamicFieldInfoResponse.class);
        }
    }
}

