/*
 * Copyright 2017 Marco Martin <mart@kde.org>
 * Copyright 2017 The Qt Company Ltd.
 *
 * GNU Lesser General Public License Usage
 * Alternatively, this file may be used under the terms of the GNU Lesser
 * General Public License version 3 as published by the Free Software
 * Foundation and appearing in the file LICENSE.LGPLv3 included in the
 * packaging of this file. Please review the following information to
 * ensure the GNU Lesser General Public License version 3 requirements
 * will be met: https://www.gnu.org/licenses/lgpl.html.
 *
 * GNU General Public License Usage
 * Alternatively, this file may be used under the terms of the GNU
 * General Public License version 2.0 or later as published by the Free
 * Software Foundation and appearing in the file LICENSE.GPL included in
 * the packaging of this file. Please review the following information to
 * ensure the GNU General Public License version 2.0 requirements will be
 * met: http://www.gnu.org/licenses/gpl-2.0.html.
 */


import QtQuick
import QtQuick.Window
import QtQuick.Templates as T
import org.mauikit.controls as Maui

T.Label 
{
    id: control

    verticalAlignment: lineCount > 1 ? Text.AlignTop : Text.AlignVCenter

    activeFocusOnTab: false
    focus: false
    //Text.NativeRendering is broken on non integer pixel ratios
    renderType: Window.devicePixelRatio % 1 !== 0 ? Text.QtRendering : Text.NativeRendering
  
    font.capitalization: Maui.Style.defaultFont.capitalization
    font.family: Maui.Style.defaultFont.family
    font.italic: Maui.Style.defaultFont.italic
    font.letterSpacing: Maui.Style.defaultFont.letterSpacing
    font.pointSize: Maui.Style.defaultFont.pointSize
    font.strikeout: Maui.Style.defaultFont.strikeout
    font.underline: Maui.Style.defaultFont.underline
    font.weight: Maui.Style.defaultFont.weight
    font.wordSpacing: Maui.Style.defaultFont.wordSpacing
    
    color: Maui.Theme.textColor
    linkColor: Maui.Theme.linkColor

    opacity: enabled? 1 : 0.6

    Accessible.role: Accessible.StaticText
    Accessible.name: text
        
    MouseArea
    {
        anchors.fill: parent
        cursorShape: control.hoveredLink ? Qt.PointingHandCursor : Qt.ArrowCursor
        acceptedButtons: Qt.NoButton // Not actually accepting clicks, just changing the cursor
    }
}
