/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.remover.query;

import java.util.Map;
import java.util.Objects;
import org.keycloak.models.sessions.infinispan.changes.remote.remover.query.MultipleConditionQueryRemover;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionKey;
import org.keycloak.models.sessions.infinispan.entities.RemoteAuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.query.ClientSessionQueries;

public class ClientSessionQueryConditionalRemover
extends MultipleConditionQueryRemover<ClientSessionKey, RemoteAuthenticatedClientSessionEntity> {
    @Override
    String getEntity() {
        return ClientSessionQueries.CLIENT_SESSION;
    }

    public void removeByUserSessionId(String userSessionId) {
        this.add(new RemoveByUserSession(this.nextParameter(), userSessionId));
    }

    public void removeByRealmId(String realmId) {
        this.add(new RemoveByRealm(this.nextParameter(), realmId));
    }

    public void removeByUserId(String realmId, String userId) {
        this.add(new RemoveByUser(this.nextParameter(), realmId, this.nextParameter(), userId));
    }

    private record RemoveByUserSession(String userSessionParameter, String userSessionId) implements MultipleConditionQueryRemover.RemoveCondition<ClientSessionKey, RemoteAuthenticatedClientSessionEntity>
    {
        @Override
        public String getConditionalClause() {
            return "(userSessionId = :%s)".formatted(this.userSessionParameter);
        }

        @Override
        public void addParameters(Map<String, Object> parameters) {
            parameters.put(this.userSessionParameter, this.userSessionId);
        }

        @Override
        public boolean willRemove(ClientSessionKey key, RemoteAuthenticatedClientSessionEntity value) {
            return Objects.equals(value.getUserSessionId(), this.userSessionId);
        }
    }

    private record RemoveByRealm(String realmParameter, String realmId) implements MultipleConditionQueryRemover.RemoveCondition<ClientSessionKey, RemoteAuthenticatedClientSessionEntity>
    {
        @Override
        public String getConditionalClause() {
            return "(realmId = :%s)".formatted(this.realmParameter);
        }

        @Override
        public void addParameters(Map<String, Object> parameters) {
            parameters.put(this.realmParameter, this.realmId);
        }

        @Override
        public boolean willRemove(ClientSessionKey key, RemoteAuthenticatedClientSessionEntity value) {
            return Objects.equals(value.getRealmId(), this.realmId);
        }
    }

    private record RemoveByUser(String realmParameter, String realmId, String userParameter, String userId) implements MultipleConditionQueryRemover.RemoveCondition<ClientSessionKey, RemoteAuthenticatedClientSessionEntity>
    {
        @Override
        public String getConditionalClause() {
            return "(userId = :%s && realmId = :%s)".formatted(this.userParameter, this.realmParameter);
        }

        @Override
        public void addParameters(Map<String, Object> parameters) {
            parameters.put(this.realmParameter, this.realmId);
            parameters.put(this.userParameter, this.userId);
        }

        @Override
        public boolean willRemove(ClientSessionKey key, RemoteAuthenticatedClientSessionEntity value) {
            return Objects.equals(value.getUserId(), this.userId) && Objects.equals(value.getRealmId(), this.realmId);
        }
    }
}

