/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.ConfigSynonym;

public final class ServerTopicConfigSynonyms {
    public static final String LOG_PREFIX = "log.";
    public static final String LOG_CLEANER_PREFIX = "log.cleaner.";
    public static final Map<String, List<ConfigSynonym>> ALL_TOPIC_CONFIG_SYNONYMS = Utils.mkMap((Map.Entry[])new Map.Entry[]{ServerTopicConfigSynonyms.sameNameWithLogPrefix("segment.bytes"), ServerTopicConfigSynonyms.listWithLogPrefix("segment.ms", new ConfigSynonym("roll.ms"), new ConfigSynonym("roll.hours", ConfigSynonym.HOURS_TO_MILLISECONDS)), ServerTopicConfigSynonyms.listWithLogPrefix("segment.jitter.ms", new ConfigSynonym("roll.jitter.ms"), new ConfigSynonym("roll.jitter.hours", ConfigSynonym.HOURS_TO_MILLISECONDS)), ServerTopicConfigSynonyms.singleWithLogPrefix("segment.index.bytes", "index.size.max.bytes"), ServerTopicConfigSynonyms.singleWithLogPrefix("flush.messages", "flush.interval.messages"), ServerTopicConfigSynonyms.listWithLogPrefix("flush.ms", new ConfigSynonym("flush.interval.ms"), new ConfigSynonym("flush.scheduler.interval.ms")), ServerTopicConfigSynonyms.sameNameWithLogPrefix("retention.bytes"), ServerTopicConfigSynonyms.listWithLogPrefix("retention.ms", new ConfigSynonym("retention.ms"), new ConfigSynonym("retention.minutes", ConfigSynonym.MINUTES_TO_MILLISECONDS), new ConfigSynonym("retention.hours", ConfigSynonym.HOURS_TO_MILLISECONDS)), ServerTopicConfigSynonyms.single("max.message.bytes", "message.max.bytes"), ServerTopicConfigSynonyms.sameNameWithLogPrefix("index.interval.bytes"), ServerTopicConfigSynonyms.sameNameWithLogCleanerPrefix("delete.retention.ms"), ServerTopicConfigSynonyms.sameNameWithLogCleanerPrefix("min.compaction.lag.ms"), ServerTopicConfigSynonyms.sameNameWithLogCleanerPrefix("max.compaction.lag.ms"), ServerTopicConfigSynonyms.singleWithLogPrefix("file.delete.delay.ms", "segment.delete.delay.ms"), ServerTopicConfigSynonyms.singleWithLogCleanerPrefix("min.cleanable.dirty.ratio", "min.cleanable.ratio"), ServerTopicConfigSynonyms.sameNameWithLogPrefix("cleanup.policy"), ServerTopicConfigSynonyms.sameName("unclean.leader.election.enable"), ServerTopicConfigSynonyms.sameName("min.insync.replicas"), ServerTopicConfigSynonyms.sameName("compression.type"), ServerTopicConfigSynonyms.sameName("compression.gzip.level"), ServerTopicConfigSynonyms.sameName("compression.lz4.level"), ServerTopicConfigSynonyms.sameName("compression.zstd.level"), ServerTopicConfigSynonyms.sameNameWithLogPrefix("preallocate"), ServerTopicConfigSynonyms.sameNameWithLogPrefix("message.timestamp.type"), ServerTopicConfigSynonyms.sameNameWithLogPrefix("message.timestamp.before.max.ms"), ServerTopicConfigSynonyms.sameNameWithLogPrefix("message.timestamp.after.max.ms"), ServerTopicConfigSynonyms.sameNameWithLogPrefix("local.retention.ms"), ServerTopicConfigSynonyms.sameNameWithLogPrefix("local.retention.bytes")});
    public static final Map<String, String> TOPIC_CONFIG_SYNONYMS = ALL_TOPIC_CONFIG_SYNONYMS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfigSynonym)((List)e.getValue()).get(0)).name()));

    public static String serverSynonym(String topicConfigName) {
        String serverSynonym = TOPIC_CONFIG_SYNONYMS.get(topicConfigName);
        if (serverSynonym == null) {
            throw new NoSuchElementException("No server synonym found for " + topicConfigName);
        }
        return serverSynonym;
    }

    private static Map.Entry<String, List<ConfigSynonym>> sameName(String configName) {
        return Utils.mkEntry((Object)configName, List.of(new ConfigSynonym(configName)));
    }

    private static Map.Entry<String, List<ConfigSynonym>> sameNameWithLogPrefix(String configName) {
        return Utils.mkEntry((Object)configName, List.of(new ConfigSynonym(LOG_PREFIX + configName)));
    }

    private static Map.Entry<String, List<ConfigSynonym>> sameNameWithLogCleanerPrefix(String configName) {
        return Utils.mkEntry((Object)configName, List.of(new ConfigSynonym(LOG_CLEANER_PREFIX + configName)));
    }

    private static Map.Entry<String, List<ConfigSynonym>> singleWithLogPrefix(String topicConfigName, String brokerConfigName) {
        return Utils.mkEntry((Object)topicConfigName, List.of(new ConfigSynonym(LOG_PREFIX + brokerConfigName)));
    }

    private static Map.Entry<String, List<ConfigSynonym>> singleWithLogCleanerPrefix(String topicConfigName, String brokerConfigName) {
        return Utils.mkEntry((Object)topicConfigName, List.of(new ConfigSynonym(LOG_CLEANER_PREFIX + brokerConfigName)));
    }

    private static Map.Entry<String, List<ConfigSynonym>> listWithLogPrefix(String topicConfigName, ConfigSynonym ... synonyms) {
        List synonymsWithPrefix = Arrays.stream(synonyms).map(s -> new ConfigSynonym(LOG_PREFIX + s.name(), s.converter())).collect(Collectors.toList());
        return Utils.mkEntry((Object)topicConfigName, synonymsWithPrefix);
    }

    private static Map.Entry<String, List<ConfigSynonym>> single(String topicConfigName, String brokerConfigName) {
        return Utils.mkEntry((Object)topicConfigName, List.of(new ConfigSynonym(brokerConfigName)));
    }
}

